/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.locale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Resource {
    static final String LANGUAGE_FILE_LOAD_ERROR_TITLE = "fatal error";
    static final String LANGUAGE_FILE_LOAD_ERROR_MESSAGE = "Language file loading error.";
    static Resource resource;
    Locale locale;
    Map<String, String> values = new HashMap<String, String>();

    public Resource(Locale locale) {
        this.locale = locale;
    }

    public void load() throws IOException, ParserConfigurationException, SAXException {
        InputStream in = null;
        try {
            in = new FileInputStream("locale" + File.separator + "language." + this.locale.getLanguage() + ".xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList nodelist = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodelist.getLength()) {
                Element ele;
                Node node = nodelist.item(i);
                if (node instanceof Element && !this.values.containsKey((ele = (Element)node).getTagName())) {
                    this.values.put(ele.getTagName(), ele.getTextContent());
                }
                ++i;
            }
        }
        finally {
            in.close();
        }
    }

    public String getValue(String key) {
        String result = this.values.get(key);
        return result == null ? "" : result;
    }

    public Locale getInstanceLocale() {
        return this.locale;
    }

    public static synchronized Resource makeInstance(Locale locale) {
        resource = new Resource(locale);
        try {
            resource.load();
            return resource;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, LANGUAGE_FILE_LOAD_ERROR_MESSAGE, LANGUAGE_FILE_LOAD_ERROR_TITLE, 0);
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(null, LANGUAGE_FILE_LOAD_ERROR_MESSAGE, LANGUAGE_FILE_LOAD_ERROR_TITLE, 0);
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(null, LANGUAGE_FILE_LOAD_ERROR_MESSAGE, LANGUAGE_FILE_LOAD_ERROR_TITLE, 0);
        }
        return null;
    }

    public static synchronized Resource getInstance() {
        return resource;
    }

    public static synchronized String get(String key) {
        return Resource.getInstance().getValue(key);
    }

    public static synchronized Locale getLocale() {
        return Resource.getInstance().getInstanceLocale();
    }
}

