/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.GanttChartPrintable;
import jp.sourceforge.freegantt.swing.Application;

public class PreviewDialog
extends JDialog {
    private static final long serialVersionUID = 6695686076348590807L;
    Application app;
    PageFormat pageFormat;
    int page = 0;
    int pageCount = 0;
    BufferedImage image;
    JPanel buttonPanel;
    ImagePanel imagePanel;
    JButton prevPageButton;
    JButton postPageButton;
    JLabel pageLabel;

    public PreviewDialog(Application app) {
        super((Frame)app, true);
        this.app = app;
        this.setContentPane(new ContentPane());
        this.setTitle(Resource.get("previewTitle"));
        this.setSize(640, 480);
        this.pageCount = app.getTaskLineDataPane().getPrintRange().getPrintRanges().size();
        this.updatePageFormat(app.getProject().getPageFormat());
        this.updatePage();
        this.renderPage(this.page);
    }

    public void updatePageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.image = new BufferedImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight(), 4);
        Graphics g = null;
        try {
            g = this.image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        this.imagePanel.setImage(this.image);
        this.repaint();
    }

    private void renderPage(int pageIndex) {
        block8: {
            GanttChartPrintable printable = new GanttChartPrintable(this.app);
            Graphics g = null;
            try {
                try {
                    g = this.image.getGraphics();
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.image.getWidth(this), this.image.getHeight(this));
                    printable.print(g, this.pageFormat, pageIndex);
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                    if (g != null) {
                        g.dispose();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (g != null) {
                    g.dispose();
                }
                throw throwable;
            }
            if (g != null) {
                g.dispose();
            }
        }
        this.imagePanel.repaint();
    }

    private void updatePage() {
        this.pageLabel.setText(this.page + " / " + this.pageCount);
        this.prevPageButton.setEnabled(this.page > 0);
        this.postPageButton.setEnabled(this.page < this.pageCount - 1);
    }

    class CloseAction
    implements ActionListener {
        CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewDialog.this.dispose();
        }
    }

    class ContentPane
    extends JPanel {
        private static final long serialVersionUID = -4424554441476030096L;

        public ContentPane() {
            this.setLayout(new BoxLayout(this, 1));
            PreviewDialog.this.buttonPanel = new JPanel();
            PreviewDialog.this.buttonPanel.setLayout(new FlowLayout());
            PreviewDialog.this.buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 24));
            this.add(PreviewDialog.this.buttonPanel);
            JButton pageButton = new JButton(Resource.get("previewPage"));
            pageButton.addActionListener(new PageConfigureAction());
            PreviewDialog.this.buttonPanel.add(pageButton);
            JButton printButton = new JButton(Resource.get("previewPrint"));
            printButton.addActionListener(new PrintAction());
            PreviewDialog.this.buttonPanel.add(printButton);
            JPanel panel = new JPanel();
            panel.setSize(12, 1);
            PreviewDialog.this.buttonPanel.add(panel);
            PreviewDialog.this.prevPageButton = new JButton(Resource.get("previewPrevPage"));
            PreviewDialog.this.prevPageButton.addActionListener(new PrevPageAction());
            PreviewDialog.this.buttonPanel.add(PreviewDialog.this.prevPageButton);
            PreviewDialog.this.pageLabel = new JLabel();
            PreviewDialog.this.buttonPanel.add(PreviewDialog.this.pageLabel);
            PreviewDialog.this.postPageButton = new JButton(Resource.get("previewPostPage"));
            PreviewDialog.this.postPageButton.addActionListener(new PostPageAction());
            PreviewDialog.this.buttonPanel.add(PreviewDialog.this.postPageButton);
            JButton closeButton = new JButton(Resource.get("previewClose"));
            closeButton.addActionListener(new CloseAction());
            PreviewDialog.this.buttonPanel.add(closeButton);
            PreviewDialog.this.imagePanel = new ImagePanel();
            PreviewDialog.this.imagePanel.setBounds(0, 0, 100, 100);
            PreviewDialog.this.imagePanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.add(PreviewDialog.this.imagePanel);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            int height = this.getHeight();
            PreviewDialog.this.imagePanel.setSize(PreviewDialog.this.imagePanel.getWidth(), height -= PreviewDialog.this.buttonPanel.getHeight());
            PreviewDialog.this.imagePanel.setPreferredSize(this.getSize());
        }
    }

    class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 7267024727103791877L;
        Image image;

        ImagePanel() {
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == null) {
                return;
            }
            double scaleX = (double)this.getWidth() / (double)this.image.getWidth(this);
            double scaleY = (double)this.getHeight() / (double)this.image.getHeight(this);
            double scale = Math.min(scaleX, scaleY);
            int scaledWidth = (int)((double)this.image.getWidth(this) * scale);
            int scaledHeight = (int)((double)this.image.getHeight(this) * scale);
            g.drawImage(this.image, (this.getWidth() - scaledWidth) / 2, (this.getHeight() - scaledHeight) / 2, scaledWidth, scaledHeight, this);
        }
    }

    class PageConfigureAction
    implements ActionListener {
        PageConfigureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewDialog.this.app.configurePage();
            PreviewDialog.this.updatePageFormat(PreviewDialog.this.app.getProject().getPageFormat());
            PreviewDialog.this.renderPage(PreviewDialog.this.page);
        }
    }

    class PostPageAction
    implements ActionListener {
        PostPageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewDialog.this.page = Math.min(PreviewDialog.this.pageCount - 1, PreviewDialog.this.page + 1);
            PreviewDialog.this.updatePage();
            PreviewDialog.this.renderPage(PreviewDialog.this.page);
        }
    }

    class PrevPageAction
    implements ActionListener {
        PrevPageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewDialog.this.page = Math.max(0, PreviewDialog.this.page - 1);
            PreviewDialog.this.updatePage();
            PreviewDialog.this.renderPage(PreviewDialog.this.page);
        }
    }

    class PrintAction
    implements ActionListener {
        PrintAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewDialog.this.app.print();
        }
    }
}

