/*
YUI 3.7.3 (build 5687)
Copyright 2012 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/
if (typeof _yuitest_coverage == "undefined"){
    _yuitest_coverage = {};
    _yuitest_coverline = function(src, line){
        var coverage = _yuitest_coverage[src];
        if (!coverage.lines[line]){
            coverage.calledLines++;
        }
        coverage.lines[line]++;
    };
    _yuitest_coverfunc = function(src, name, line){
        var coverage = _yuitest_coverage[src],
            funcId = name + ":" + line;
        if (!coverage.functions[funcId]){
            coverage.calledFunctions++;
        }
        coverage.functions[funcId]++;
    };
}
_yuitest_coverage["build/charts-base/charts-base.js"] = {
    lines: {},
    functions: {},
    coveredLines: 0,
    calledLines: 0,
    coveredFunctions: 0,
    calledFunctions: 0,
    path: "build/charts-base/charts-base.js",
    code: []
};
_yuitest_coverage["build/charts-base/charts-base.js"].code=["YUI.add('charts-base', function (Y, NAME) {","","/**"," * The Charts widget provides an api for displaying data"," * graphically."," *"," * @module charts"," * @main charts"," */","","/**"," * The charts-base submodule contains the core functionality for the charts module."," *"," * @module charts"," * @submodule charts-base"," */","var CONFIG = Y.config,","    WINDOW = CONFIG.win,","    DOCUMENT = CONFIG.doc,","    Y_Lang = Y.Lang,","    IS_STRING = Y_Lang.isString,","    Y_DOM = Y.DOM,","    LeftAxisLayout,","    RightAxisLayout,","    BottomAxisLayout,","    TopAxisLayout,","    _getClassName = Y.ClassNameManager.getClassName,","    SERIES_MARKER = _getClassName(\"seriesmarker\"),","    ShapeGroup,","    CircleGroup,","    RectGroup,","    EllipseGroup,","    DiamondGroup;","","/**"," * Abstract class for creating groups of shapes with the same styles and dimensions."," *"," * @class ShapeGroup"," * @constructor"," */"," ShapeGroup = function(cfg)"," {","    ShapeGroup.superclass.constructor.apply(this, arguments);"," };","    "," ShapeGroup.NAME = \"shapeGroup\";",""," Y.extend(ShapeGroup, Y.Path, {    ","    /**","     * Updates the shape.","     *","     * @method _draw","     * @private","     */","    _draw: function()","    {","        var xvalues = this.get(\"xvalues\"),","            yvalues = this.get(\"yvalues\"),","            x,","            y,","            xRad,","            yRad,","            i = 0,","            len,","            attrs = [],","            dimensions = this.get(\"dimensions\"),","            width = dimensions.width,","            height = dimensions.height,","            radius = dimensions.radius,","            yRadius = dimensions.yRadius,","            id = this.get(\"id\"),","            className = this.node.className,","            widthIsArray = Y_Lang.isArray(width),","            heightIsArray = Y_Lang.isArray(height),","            radiusIsArray = Y_Lang.isArray(radius),","            yRadiusIsArray = Y_Lang.isArray(yRadius);","        if(xvalues && yvalues && xvalues.length > 0)","        {","            this.clear();","","            len = xvalues.length;","            for(; i < len; ++i)","            {","                x = xvalues[i];","                y = yvalues[i];","                xRad = radiusIsArray ? radius[i] : radius;","                yRad = yRadiusIsArray ? yRadius[i] : yRadius;","                if(!isNaN(x) && !isNaN(y) && !isNaN(xRad))","                {","                    this.drawShape({","                        x: x,","                        y: y,","                        width: widthIsArray ? width[i] : width,","                        height: heightIsArray ? height[i] : height,","                        radius: xRad,","                        yRadius: yRad ","                    });","                    this.closePath();","                    attrs[i] = {","                        id: id + \"_\" + i,","                        className: className,","                        coords: (x - this._left) + \", \" + (y - this._top)  + \", \" + radius,","                        shape: \"circle\"","                    };","                }","            }","            this._closePath();","        }","    },","","    /**","     * Parses and array of lengths into radii","     *","     * @method _getRadiusCollection","     * @param {Array} val Array of lengths","     * @return Array","     * @private","     */","    _getRadiusCollection: function(val)","    {","        var i = 0,","            len = val.length,","            radii = [];","        for(; i < len; ++i)","        {   ","            radii[i] = val[i] * 0.5;","        }","        return radii;","    }"," });","    ","ShapeGroup.ATTRS = Y.merge(Y.Path.ATTRS, {","    dimensions: {","        getter: function()","        {","            var dimensions = this._dimensions,","                radius,","                yRadius,","                width,","                height;","            if(dimensions.hasOwnProperty(\"radius\"))","            {","                return dimensions;","            }","            else","            {","                width = dimensions.width;","                height = dimensions.height;","                radius = Y_Lang.isArray(width) ? this._getRadiusCollection(width) : (width * 0.5);","                yRadius = Y_Lang.isArray(height) ? this._getRadiusCollection(height) : (height * 0.5);","                return {","                    width: width,","                    height: height,","                    radius: radius,","                    yRadius: yRadius","                };","            }","        },","","        setter: function(val)","        {","            this._dimensions = val;","            return val;","        }","    },","    xvalues: {","        getter: function()","        {","            return this._xvalues;","        },","        setter: function(val)","        {","            this._xvalues = val;","        }","    },","    yvalues: {","        getter: function()","        {","            return this._yvalues;","        },","        setter: function(val)","        {","            this._yvalues = val;","        }","    }","});","Y.ShapeGroup = ShapeGroup;","/**"," * Abstract class for creating groups of circles with the same styles and dimensions."," *"," * @module charts"," * @submodule charts-base"," * @class CircleGroup"," * @constructor"," */"," CircleGroup = function(cfg)"," {","    CircleGroup.superclass.constructor.apply(this, arguments);"," };","    "," CircleGroup.NAME = \"circleGroup\";",""," Y.extend(CircleGroup, Y.ShapeGroup, {    ","    /**","     * Algorithm for drawing shape.","     *","     * @method drawShape","     * @param {Object} cfg Parameters used to draw the shape.","     */","    drawShape: function(cfg)","    {","        this.drawCircle(cfg.x, cfg.y, cfg.radius);","    }"," });","","CircleGroup.ATTRS = Y.merge(Y.ShapeGroup.ATTRS, {","    dimensions: {","        getter: function()","        {","            var dimensions = this._dimensions,","                radius,","                yRadius,","                width,","                height;","            if(dimensions.hasOwnProperty(\"radius\"))","            {","                return dimensions;","            }","            else","            {","                width = dimensions.width;","                height = dimensions.height;","                radius = Y_Lang.isArray(width) ? this._getRadiusCollection(width) : (width * 0.5);","                yRadius = radius;","                return {","                    width: width,","                    height: height,","                    radius: radius,","                    yRadius: yRadius","                };","            }","        }","    }","});","    ","CircleGroup.ATTRS = Y.ShapeGroup.ATTRS;","Y.CircleGroup = CircleGroup;","/**"," * Abstract class for creating groups of rects with the same styles and dimensions."," *"," * @module charts"," * @submodule charts-base"," * @class GroupRect"," * @constructor"," */"," RectGroup = function(cfg)"," {","    RectGroup.superclass.constructor.apply(this, arguments);"," };","    "," RectGroup.NAME = \"rectGroup\";",""," Y.extend(RectGroup, Y.ShapeGroup, {    ","    /**","     * Updates the rect.","     *","     * @method _draw","     * @private","     */","    drawShape: function(cfg)","    {","        this.drawRect(cfg.x, cfg.y, cfg.width, cfg.height);","    }"," });","    ","RectGroup.ATTRS = Y.ShapeGroup.ATTRS;","Y.RectGroup = RectGroup;","/**"," * Abstract class for creating groups of diamonds with the same styles and dimensions."," *"," * @module charts"," * @submodule charts-base"," * @class GroupDiamond"," * @constructor"," */"," DiamondGroup = function(cfg)"," {","    DiamondGroup.superclass.constructor.apply(this, arguments);"," };","    "," DiamondGroup.NAME = \"diamondGroup\";",""," Y.extend(DiamondGroup, Y.ShapeGroup, {    ","    /**","     * Updates the diamond.","     *","     * @method _draw","     * @private","     */","    drawShape: function(cfg)","    {","        this.drawDiamond(cfg.x, cfg.y, cfg.width, cfg.height);","    }"," });","    ","DiamondGroup.ATTRS = Y.ShapeGroup.ATTRS;","Y.DiamondGroup = DiamondGroup;","/**"," * Abstract class for creating groups of diamonds with the same styles and dimensions."," *"," * @module charts"," * @submodule charts-base"," * @class EllipseGroup"," * @constructor"," */"," EllipseGroup = function(cfg)"," {","    EllipseGroup.superclass.constructor.apply(this, arguments);"," };","    "," EllipseGroup.NAME = \"diamondGroup\";",""," Y.extend(EllipseGroup, Y.ShapeGroup, {    ","    /**","     * Updates the diamond.","     *","     * @method _draw","     * @private","     */","    drawShape: function(cfg)","    {","        this.drawEllipse(cfg.x, cfg.y, cfg.width, cfg.height);","    }"," });","    ","EllipseGroup.ATTRS = Y.ShapeGroup.ATTRS;","Y.EllipseGroup = EllipseGroup;","/**"," * The Renderer class is a base class for chart components that use the `styles`"," * attribute."," *"," * @module charts"," * @submodule charts-base"," * @class Renderer"," * @constructor"," */","function Renderer(){}","","Renderer.ATTRS = {","        /**","         * Style properties for class","         * ","         * @attribute styles","         * @type Object","         */","        styles:","        {","            getter: function()","            {","                this._styles = this._styles || this._getDefaultStyles();","                return this._styles;","            },","","            setter: function(val)","            {","                this._styles = this._setStyles(val);","            }","        },","        ","        /**","         * The graphic in which drawings will be rendered.","         *","         * @attribute graphic","         * @type Graphic","         */","        graphic: {}","};","Renderer.NAME = \"renderer\";","","Renderer.prototype = {","    /**","     * Storage for `styles` attribute.","     *","     * @property _styles","     * @type Object","     * @private","     */","	_styles: null,","	","    /**","     * Method used by `styles` setter.","     *","     * @method _setStyles","     * @param {Object} newStyles Hash of properties to update.","     * @return Object","     * @protected","     */","	_setStyles: function(newstyles)","	{","		var styles = this.get(\"styles\");","        return this._mergeStyles(newstyles, styles);","	},","    ","    /**","     * Merges to object literals so that only specified properties are ","     * overwritten.","     *","     * @method _mergeStyles","     * @param {Object} a Hash of new styles","     * @param {Object} b Hash of original styles","     * @return Object","     * @protected","     */","    _mergeStyles: function(a, b)","    {","        if(!b)","        {","            b = {};","        }","        var newstyles = Y.merge(b, {});","        Y.Object.each(a, function(value, key, a)","        {","            if(b.hasOwnProperty(key) && Y_Lang.isObject(value) && !Y_Lang.isFunction(value) && !Y_Lang.isArray(value))","            {","                newstyles[key] = this._mergeStyles(value, b[key]);","            }","            else","            {","                newstyles[key] = value;","            }","        }, this);","        return newstyles;","    },","","    /**","     * Gets the default value for the `styles` attribute. ","     *","     * @method _getDefaultStyles","     * @return Object","     * @protected","     */","    _getDefaultStyles: function()","    {","        return {padding:{","            top:0,","            right: 0,","            bottom: 0,","            left: 0","        }};","    }","};","","Y.augment(Renderer, Y.Attribute);","Y.Renderer = Renderer;","","/**"," * Algorithmic strategy for rendering a left axis."," *"," * @module charts"," * @submodule charts-base"," * @class LeftAxisLayout"," * @constructor"," */","LeftAxisLayout = function() {};","","LeftAxisLayout.prototype = {","    /**","     *  Default margins for text fields.","     *","     *  @private","     *  @method _getDefaultMargins","     *  @return Object","     */","    _getDefaultMargins: function() ","    {","        return {","            top: 0,","            left: 0,","            right: 4,","            bottom: 0","        };","    },","","    /**","     * Sets the length of the tick on either side of the axis line.","     *","     * @method setTickOffset","     * @protected","     */","    setTickOffsets: function()","    {","        var host = this,","            majorTicks = host.get(\"styles\").majorTicks,","            tickLength = majorTicks.length,","            halfTick = tickLength * 0.5,","            display = majorTicks.display;","        host.set(\"topTickOffset\",  0);","        host.set(\"bottomTickOffset\",  0);","        ","        switch(display)","        {","            case \"inside\" :","                host.set(\"rightTickOffset\",  tickLength);","                host.set(\"leftTickOffset\", 0);","            break;","            case \"outside\" : ","                host.set(\"rightTickOffset\", 0);","                host.set(\"leftTickOffset\",  tickLength);","            break;","            case \"cross\":","                host.set(\"rightTickOffset\", halfTick); ","                host.set(\"leftTickOffset\",  halfTick);","            break;","            default:","                host.set(\"rightTickOffset\", 0);","                host.set(\"leftTickOffset\", 0);","            break;","        }","    },","    ","    /**","     * Draws a tick","     *","     * @method drawTick","     * @param {Path} path reference to the path `Path` element in which to draw the tick.","     * @param {Object} pt Point on the axis in which the tick will intersect.","     * @param {Object} tickStyle Hash of properties to apply to the tick.","     * @protected","     */","    drawTick: function(path, pt, tickStyles)","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            tickLength = tickStyles.length,","            start = {x:padding.left, y:pt.y},","            end = {x:tickLength + padding.left, y:pt.y};","        host.drawLine(path, start, end);","    },","","    /**","     * Calculates the coordinates for the first point on an axis.","     *","     * @method getLineStart","     * @return {Object}","     * @protected","     */","    getLineStart: function()","    {","        var style = this.get(\"styles\"),","            padding = style.padding,","            majorTicks = style.majorTicks,","            tickLength = majorTicks.length,","            display = majorTicks.display,","            pt = {x:padding.left, y:0};","        if(display === \"outside\")","        {","            pt.x += tickLength;","        }","        else if(display === \"cross\")","        {","            pt.x += tickLength/2;","        }","        return pt; ","    },","    ","    /**","     * Calculates the point for a label.","     *","     * @method getLabelPoint","     * @param {Object} point Point on the axis in which the tick will intersect.","     * @return {Object} ","     * @protected","     */","    getLabelPoint: function(point)","    {","        return {x:point.x - this.get(\"leftTickOffset\"), y:point.y};","    },","    ","    /**","     * Updates the value for the `maxLabelSize` for use in calculating total size.","     *","     * @method updateMaxLabelSize","     * @param {HTMLElement} label to measure","     * @protected","     */","    updateMaxLabelSize: function(labelWidth, labelHeight)","    {","        var host = this,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            sinRadians = props.sinRadians,","            cosRadians = props.cosRadians,","            max;","        if(rot === 0)","        {","            max = labelWidth;","        }","        else if(absRot === 90)","        {","            max = labelHeight;","        }","        else","        {","            max = (cosRadians * labelWidth) + (sinRadians * labelHeight);","        }","        host._maxLabelSize = Math.max(host._maxLabelSize, max);","    },","    ","    /**","     * Determines the available label width when the axis width has been explicitly set.","     *","     * @method getExplicitlySized","     * @return Boolean","     * @protected","     */","    getExplicitlySized: function(styles)","    {","        if(this._explicitWidth)","        {","            var host = this,","                w = host._explicitWidth,","                totalTitleSize = host._totalTitleSize,","                leftTickOffset = host.get(\"leftTickOffset\"),","                margin = styles.label.margin.right;","            host._maxLabelSize =  w - (leftTickOffset + margin + totalTitleSize);","            return true;","        }","        return false;","    },","","    /**","     * Rotate and position title.","     *","     * @method positionTitle","     * @param {HTMLElement} label to rotate position","     * @protected","     */","    positionTitle: function(label)","    {","        var host = this,","            bounds = host._titleBounds,","            margin = host.get(\"styles\").title.margin,","            props = host._titleRotationProps,","            w = bounds.right - bounds.left,","            labelWidth = label.offsetWidth,","            labelHeight = label.offsetHeight,","            x = (labelWidth * -0.5) + (w * 0.5),","            y = (host.get(\"height\") * 0.5) - (labelHeight * 0.5);","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        if(margin && margin.left)","        {","            x += margin.left;","        }","        props.x = x;","        props.y = y;","        props.transformOrigin = [0.5, 0.5];","        host._rotate(label, props);","    },","","    /**","     * Rotate and position labels.","     *","     * @method positionLabel","     * @param {HTMLElement} label to rotate position","     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned","     * against.","     * @protected","     */","    positionLabel: function(label, pt, styles, i)","    {","        var host = this,","            tickOffset = host.get(\"leftTickOffset\"),","            totalTitleSize = this._totalTitleSize,","            leftOffset = pt.x + totalTitleSize - tickOffset,","            topOffset = pt.y,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            maxLabelSize = host._maxLabelSize,","            labelWidth = this._labelWidths[i],","            labelHeight = this._labelHeights[i];","        if(rot === 0)","        {","            leftOffset -= labelWidth;","            topOffset -= labelHeight * 0.5;","        }","        else if(rot === 90)","        {","            leftOffset -= labelWidth * 0.5;","        }","        else if(rot === -90)","        {","            leftOffset -= labelWidth * 0.5;","            topOffset -= labelHeight;","        }","        else","        {","            leftOffset -= labelWidth + (labelHeight * absRot/360);","            topOffset -= labelHeight * 0.5;","        }","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        props.x = Math.round(maxLabelSize + leftOffset);","        props.y = Math.round(topOffset);","        this._rotate(label, props);","    },","","    /**","     * Adjusts the coordinates of an axis label based on the rotation.","     *","     * @method _setRotationCoords","     * @param {Object} props Coordinates, dimension and rotation properties of the label.","     * @protected","     */","    _setRotationCoords: function(props)","    {","        var rot = props.rot,","            absRot = props.absRot,","            leftOffset,","            topOffset,","            labelWidth = props.labelWidth,","            labelHeight = props.labelHeight;","        if(rot === 0)","        {","            leftOffset = labelWidth;","            topOffset = labelHeight * 0.5;","        }","        else if(rot === 90)","        {","            topOffset = 0;","            leftOffset = labelWidth * 0.5;","        }","        else if(rot === -90)","        {","            leftOffset = labelWidth * 0.5;","            topOffset = labelHeight;","        }","        else","        {","            leftOffset = labelWidth + (labelHeight * absRot/360);","            topOffset = labelHeight * 0.5;","        }","        props.x -= leftOffset;","        props.y -= topOffset;","    },","","    /**","     * Returns the transformOrigin to use for an axis label based on the position of the axis ","     * and the rotation of the label.","     *","     * @method _getTransformOrigin","     * @param {Number} rot The rotation (in degrees) of the label.","     * @return Array","     * @protected","     */","    _getTransformOrigin: function(rot)","    {","        var transformOrigin;","        if(rot === 0)","        {","            transformOrigin = [0, 0];","        }","        else if(rot === 90)","        {","            transformOrigin = [0.5, 0];","        }","        else if(rot === -90)","        {","            transformOrigin = [0.5, 1];","        }","        else","        {","            transformOrigin = [1, 0.5];","        }","        return transformOrigin;","    },","","    /**","     * Adjust the position of the Axis widget's content box for internal axes.","     *","     * @method offsetNodeForTick","     * @param {Node} cb Content box of the Axis.","     * @protected","     */","    offsetNodeForTick: function(cb)","    {","    },","","    /**","     * Sets the width of the axis based on its contents.","     *","     * @method setCalculatedSize","     * @protected","     */","    setCalculatedSize: function()","    {","        var host = this,","            graphic = this.get(\"graphic\"),","            style = host.get(\"styles\"),","            label = style.label,","            tickOffset = host.get(\"leftTickOffset\"),","            max = host._maxLabelSize,","            totalTitleSize = this._totalTitleSize,","            ttl = Math.round(totalTitleSize + tickOffset + max + label.margin.right);","        if(this._explicitWidth)","        {","            ttl = this._explicitWidth;","        }","        this.set(\"calculatedWidth\", ttl);","        graphic.set(\"x\", ttl - tickOffset);","    }","};","","Y.LeftAxisLayout = LeftAxisLayout;","/**"," * RightAxisLayout contains algorithms for rendering a right axis."," *"," * @module charts"," * @submodule charts-base"," * @class RightAxisLayout"," * @constructor"," */","RightAxisLayout = function(){};","","RightAxisLayout.prototype = {","    /**","     *  Default margins for text fields.","     *","     *  @private","     *  @method _getDefaultMargins","     *  @return Object","     */","    _getDefaultMargins: function() ","    {","        return {","            top: 0,","            left: 4,","            right: 0,","            bottom: 0","        };","    },","","    /**","     * Sets the length of the tick on either side of the axis line.","     *","     * @method setTickOffset","     * @protected","     */","    setTickOffsets: function()","    {","        var host = this,","            majorTicks = host.get(\"styles\").majorTicks,","            tickLength = majorTicks.length,","            halfTick = tickLength * 0.5,","            display = majorTicks.display;","        host.set(\"topTickOffset\",  0);","        host.set(\"bottomTickOffset\",  0);","        ","        switch(display)","        {","            case \"inside\" :","                host.set(\"leftTickOffset\", tickLength);","                host.set(\"rightTickOffset\", 0);","            break;","            case \"outside\" : ","                host.set(\"leftTickOffset\", 0);","                host.set(\"rightTickOffset\", tickLength);","            break;","            case \"cross\" :","                host.set(\"rightTickOffset\", halfTick);","                host.set(\"leftTickOffset\", halfTick);","            break;","            default:","                host.set(\"leftTickOffset\", 0);","                host.set(\"rightTickOffset\", 0);","            break;","        }","    },","","    /**","     * Draws a tick","     *","     * @method drawTick","     * @param {Path} path reference to the path `Path` element in which to draw the tick.","     * @param {Object} pt Point on the axis in which the tick will intersect.","     * @param {Object) tickStyle Hash of properties to apply to the tick.","     * @protected","     */","    drawTick: function(path, pt, tickStyles)","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            tickLength = tickStyles.length,","            start = {x:padding.left, y:pt.y},","            end = {x:padding.left + tickLength, y:pt.y};","        host.drawLine(path, start, end);","    },","    ","    /**","     * Calculates the coordinates for the first point on an axis.","     *","     * @method getLineStart","     * @return {Object}","     * @protected","     */","    getLineStart: function()","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            majorTicks = style.majorTicks,","            tickLength = majorTicks.length,","            display = majorTicks.display,","            pt = {x:padding.left, y:padding.top};","        if(display === \"inside\")","        {","            pt.x += tickLength;","        }","        else if(display === \"cross\")","        {","            pt.x += tickLength/2;","        }","        return pt;","    },","    ","    /**","     * Calculates the point for a label.","     *","     * @method getLabelPoint","     * @param {Object} point Point on the axis in which the tick will intersect.","     * @return {Object} ","     * @protected","     */","    getLabelPoint: function(point)","    {","        return {x:point.x + this.get(\"rightTickOffset\"), y:point.y};","    },","    ","    /**","     * Updates the value for the `maxLabelSize` for use in calculating total size.","     *","     * @method updateMaxLabelSize","     * @param {HTMLElement} label to measure","     * @protected","     */","    updateMaxLabelSize: function(labelWidth, labelHeight)","    {","        var host = this,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            sinRadians = props.sinRadians,","            cosRadians = props.cosRadians,","            max;","        if(rot === 0)","        {","            max = labelWidth;","        }","        else if(absRot === 90)","        {","            max = labelHeight;","        }","        else","        {","            max = (cosRadians * labelWidth) + (sinRadians * labelHeight);","        }","        host._maxLabelSize = Math.max(host._maxLabelSize, max);","    },","    ","    /**","     * Determines the available label width when the axis width has been explicitly set.","     *","     * @method getExplicitlySized","     * @return Boolean","     * @protected","     */","    getExplicitlySized: function(styles)","    {","        if(this._explicitWidth)","        {","            var host = this,","                w = host._explicitWidth,","                totalTitleSize = this._totalTitleSize,","                rightTickOffset = host.get(\"rightTickOffset\"),","                margin = styles.label.margin.right;","            host._maxLabelSize =  w - (rightTickOffset + margin + totalTitleSize);","            return true;","        }","        return false;","    },","","    /**","     * Rotate and position title.","     *","     * @method positionTitle","     * @param {HTMLElement} label to rotate position","     * @protected","     */","    positionTitle: function(label)","    {","        var host = this,","            bounds = host._titleBounds,","            margin = host.get(\"styles\").title.margin,","            props = host._titleRotationProps,","            labelWidth = label.offsetWidth,","            labelHeight = label.offsetHeight,","            w = bounds.right - bounds.left,","            x = this.get(\"width\") - (labelWidth * 0.5) - (w * 0.5),","            y = (host.get(\"height\") * 0.5) - (labelHeight * 0.5);","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        if(margin && margin.right)","        {","            x -= margin.left;","        }","        props.x = x;","        props.y = y;","        props.transformOrigin = [0.5, 0.5];","        host._rotate(label, props);","    },","","    /**","     * Rotate and position labels.","     *","     * @method positionLabel","     * @param {HTMLElement} label to rotate position","     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned","     * against.","     * @protected","     */","    positionLabel: function(label, pt, styles, i)","    {","        var host = this,","            tickOffset = host.get(\"rightTickOffset\"),","            labelStyles = styles.label,","            margin = 0,","            leftOffset = pt.x,","            topOffset = pt.y,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            labelWidth = this._labelWidths[i],","            labelHeight = this._labelHeights[i];","        if(labelStyles.margin && labelStyles.margin.left)","        {","            margin = labelStyles.margin.left;","        }","        if(rot === 0)","        {","            topOffset -= labelHeight * 0.5;","        }","        else if(rot === 90)","        {","            leftOffset -= labelWidth * 0.5;","            topOffset -= labelHeight;","        }","        else if(rot === -90)","        {","            leftOffset -= labelWidth * 0.5;","        }","        else","        {","            topOffset -= labelHeight * 0.5;","            leftOffset += labelHeight/2 * absRot/90;","        }","        leftOffset += margin;","        leftOffset += tickOffset;","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        props.x = Math.round(leftOffset);","        props.y = Math.round(topOffset);","        this._rotate(label, props);","    },"," ","    /**","     * Adjusts the coordinates of an axis label based on the rotation.","     *","     * @method _setRotationCoords","     * @param {Object} props Coordinates, dimension and rotation properties of the label.","     * @protected","     */","    _setRotationCoords: function(props)","    {","        var rot = props.rot,","            absRot = props.absRot,","            leftOffset = 0,","            topOffset = 0,","            labelWidth = props.labelWidth,","            labelHeight = props.labelHeight;","        if(rot === 0)","        {","            topOffset = labelHeight * 0.5;","        }","        else if(rot === 90)","        {","            leftOffset = labelWidth * 0.5;","            topOffset = labelHeight;","        }","        else if(rot === -90)","        {","            leftOffset = labelWidth * 0.5;","        }","        else","        {","            topOffset = labelHeight * 0.5;","            leftOffset = labelHeight/2 * absRot/90;","        }","        props.x -= leftOffset;","        props.y -= topOffset;","    },","   ","    /**","     * Returns the transformOrigin to use for an axis label based on the position of the axis ","     * and the rotation of the label.","     *","     * @method _getTransformOrigin","     * @param {Number} rot The rotation (in degrees) of the label.","     * @return Array","     * @protected","     */","    _getTransformOrigin: function(rot)","    {","        var transformOrigin;","        if(rot === 0)","        {","            transformOrigin = [0, 0];","        }","        else if(rot === 90)","        {","            transformOrigin = [0.5, 1];","        }","        else if(rot === -90)","        {","            transformOrigin = [0.5, 0];","        }","        else","        {","            transformOrigin = [0, 0.5];","        }","        return transformOrigin;","    },","","    /**","     * Adjusts position for inner ticks.","     *","     * @method offsetNodeForTick","     * @param {Node} cb contentBox of the axis","     * @protected","     */","    offsetNodeForTick: function(cb)","    {","        var host = this,","            tickOffset = host.get(\"leftTickOffset\"),","            offset = 0 - tickOffset;","        cb.setStyle(\"left\", offset);","    },","","    /**","     * Assigns a height based on the size of the contents.","     *","     * @method setCalculatedSize","     * @protected","     */","    setCalculatedSize: function()","    {","        var host = this,","            styles = host.get(\"styles\"),","            labelStyle = styles.label,","            totalTitleSize = this._totalTitleSize,","            ttl = Math.round(host.get(\"rightTickOffset\") + host._maxLabelSize + totalTitleSize + labelStyle.margin.left);","        if(this._explicitWidth)","        {","            ttl = this._explicitWidth;","        }","        host.set(\"calculatedWidth\", ttl);","        host.get(\"contentBox\").setStyle(\"width\", ttl);","    }","};","","Y.RightAxisLayout = RightAxisLayout;","/**"," * Contains algorithms for rendering a bottom axis."," *"," * @module charts"," * @submodule charts-base"," * @class BottomAxisLayout"," * @Constructor"," */","BottomAxisLayout = function(){};","","BottomAxisLayout.prototype = {","    /**","     *  Default margins for text fields.","     *","     *  @private","     *  @method _getDefaultMargins","     *  @return Object","     */","    _getDefaultMargins: function() ","    {","        return {","            top: 4,","            left: 0,","            right: 0,","            bottom: 0","        };","    },","","    /**","     * Sets the length of the tick on either side of the axis line.","     *","     * @method setTickOffsets","     * @protected","     */","    setTickOffsets: function()","    {","        var host = this,","            majorTicks = host.get(\"styles\").majorTicks,","            tickLength = majorTicks.length,","            halfTick = tickLength * 0.5,","            display = majorTicks.display;","        host.set(\"leftTickOffset\",  0);","        host.set(\"rightTickOffset\",  0);","","        switch(display)","        {","            case \"inside\" :","                host.set(\"topTickOffset\", tickLength);","                host.set(\"bottomTickOffset\", 0);","            break;","            case \"outside\" : ","                host.set(\"topTickOffset\", 0);","                host.set(\"bottomTickOffset\", tickLength);","            break;","            case \"cross\":","                host.set(\"topTickOffset\",  halfTick);","                host.set(\"bottomTickOffset\",  halfTick);","            break;","            default:","                host.set(\"topTickOffset\", 0);","                host.set(\"bottomTickOffset\", 0);","            break;","        }","    },","","    /**","     * Calculates the coordinates for the first point on an axis.","     *","     * @method getLineStart","     * @protected","     */","    getLineStart: function()","    {","        var style = this.get(\"styles\"),","            padding = style.padding,","            majorTicks = style.majorTicks,","            tickLength = majorTicks.length,","            display = majorTicks.display,","            pt = {x:0, y:padding.top};","        if(display === \"inside\")","        {","            pt.y += tickLength;","        }","        else if(display === \"cross\")","        {","            pt.y += tickLength/2;","        }","        return pt; ","    },","    ","    /**","     * Draws a tick","     *","     * @method drawTick","     * @param {Path} path reference to the path `Path` element in which to draw the tick.","     * @param {Object} pt hash containing x and y coordinates","     * @param {Object} tickStyles hash of properties used to draw the tick","     * @protected","     */","    drawTick: function(path, pt, tickStyles)","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            tickLength = tickStyles.length,","            start = {x:pt.x, y:padding.top},","            end = {x:pt.x, y:tickLength + padding.top};","        host.drawLine(path, start, end);","    },","","    /**","     * Calculates the point for a label.","     *","     * @method getLabelPoint","     * @param {Object} pt Object containing x and y coordinates","     * @return Object","     * @protected","     */","    getLabelPoint: function(point)","    {","        return {x:point.x, y:point.y + this.get(\"bottomTickOffset\")};","    },","    ","    /**","     * Updates the value for the `maxLabelSize` for use in calculating total size.","     *","     * @method updateMaxLabelSize","     * @param {HTMLElement} label to measure","     * @protected","     */","    updateMaxLabelSize: function(labelWidth, labelHeight)","    {","        var host = this,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            sinRadians = props.sinRadians,","            cosRadians = props.cosRadians,","            max;","        if(rot === 0)","        {","            max = labelHeight;","        }","        else if(absRot === 90)","        {","            max = labelWidth;","        }","        else","        {","            max = (sinRadians * labelWidth) + (cosRadians * labelHeight); ","        }","        host._maxLabelSize = Math.max(host._maxLabelSize, max);","    },","    ","    /**","     * Determines the available label height when the axis width has been explicitly set.","     *","     * @method getExplicitlySized","     * @return Boolean","     * @protected","     */","    getExplicitlySized: function(styles)","    {","        if(this._explicitHeight)","        {","            var host = this,","                h = host._explicitHeight,","                totalTitleSize = host._totalTitleSize,","                bottomTickOffset = host.get(\"bottomTickOffset\"),","                margin = styles.label.margin.right;","            host._maxLabelSize =  h - (bottomTickOffset + margin + totalTitleSize);","            return true;","        }","        return false;","    },","","    /**","     * Rotate and position title.","     *","     * @method positionTitle","     * @param {HTMLElement} label to rotate position","     * @protected","     */","    positionTitle: function(label)","    {","        var host = this,","            bounds = host._titleBounds,","            margin = host.get(\"styles\").title.margin,","            props = host._titleRotationProps,","            h = bounds.bottom - bounds.top,","            labelWidth = label.offsetWidth,","            labelHeight = label.offsetHeight,","            x = (host.get(\"width\") * 0.5) - (labelWidth * 0.5),","            y = host.get(\"height\") - labelHeight/2 - h/2;","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        if(margin && margin.bottom)","        {","            y -= margin.bottom;","        }","        props.x = x;","        props.y = y;","        props.transformOrigin = [0.5, 0.5];","        host._rotate(label, props);","    },","    ","    /**","     * Rotate and position labels.","     *","     * @method positionLabel","     * @param {HTMLElement} label to rotate position","     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned","     * against.","     * @protected","     */","    positionLabel: function(label, pt, styles, i)","    {","        var host = this,","            tickOffset = host.get(\"bottomTickOffset\"),","            labelStyles = styles.label,","            margin = 0,","            props = host._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            leftOffset = Math.round(pt.x),","            topOffset = Math.round(pt.y),","            labelWidth = host._labelWidths[i],","            labelHeight = host._labelHeights[i];","        if(labelStyles.margin && labelStyles.margin.top)","        {","            margin = labelStyles.margin.top;","        }","        if(rot > 0)","        {","            topOffset -= labelHeight/2 * rot/90;","        }","        else if(rot < 0)","        {","            leftOffset -= labelWidth;","            topOffset -= labelHeight/2 * absRot/90;","        }","        else","        {","            leftOffset -= labelWidth * 0.5;","        }","        topOffset += margin;","        topOffset += tickOffset;","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        props.x = leftOffset;","        props.y = topOffset;","        host._rotate(label, props);","    },","    ","    /**","     * Adjusts the coordinates of an axis label based on the rotation.","     *","     * @method _setRotationCoords","     * @param {Object} props Coordinates, dimension and rotation properties of the label.","     * @protected","     */","    _setRotationCoords: function(props)","    {","        var rot = props.rot,","            absRot = props.absRot,","            labelWidth = props.labelWidth,","            labelHeight = props.labelHeight,","            leftOffset,","            topOffset;","","        if(rot > 0)","        {","            leftOffset = 0;","            topOffset = labelHeight/2 * rot/90;","        }","        else if(rot < 0)","        {","            leftOffset = labelWidth;","            topOffset = labelHeight/2 * absRot/90;","        }","        else","        {","            leftOffset = labelWidth * 0.5;","            topOffset = 0;","        }","        props.x -= leftOffset;","        props.y -= topOffset;","    },","","    /**","     * Returns the transformOrigin to use for an axis label based on the position of the axis ","     * and the rotation of the label.","     *","     * @method _getTransformOrigin","     * @param {Number} rot The rotation (in degrees) of the label.","     * @return Array","     * @protected","     */","    _getTransformOrigin: function(rot)","    {","        var transformOrigin;","        if(rot > 0)","        {","            transformOrigin = [0, 0.5];","        }","        else if(rot < 0)","        {","            transformOrigin = [1, 0.5];","        }","        else","        {","            transformOrigin = [0, 0];","        }","        return transformOrigin;","    },","","    /**","     * Adjusts position for inner ticks.","     *","     * @method offsetNodeForTick","     * @param {Node} cb contentBox of the axis","     * @protected","     */","    offsetNodeForTick: function(cb)","    {","        var host = this;","        host.get(\"contentBox\").setStyle(\"top\", 0 - host.get(\"topTickOffset\"));","    },","","    /**","     * Assigns a height based on the size of the contents.","     *","     * @method setCalculatedSize","     * @protected","     */","    setCalculatedSize: function()","    {","        var host = this,","            styles = host.get(\"styles\"),","            labelStyle = styles.label,","            totalTitleSize = host._totalTitleSize,","            ttl = Math.round(host.get(\"bottomTickOffset\") + host._maxLabelSize + labelStyle.margin.top + totalTitleSize);","        if(host._explicitHeight)","        {","            ttl = host._explicitHeight;","        }","        host.set(\"calculatedHeight\", ttl);","    }","};","Y.BottomAxisLayout = BottomAxisLayout;","/**"," * Contains algorithms for rendering a top axis."," *"," * @module charts"," * @submodule charts-base"," * @class TopAxisLayout"," * @constructor"," */","TopAxisLayout = function(){};","","TopAxisLayout.prototype = {","    /**","     *  Default margins for text fields.","     *","     *  @private","     *  @method _getDefaultMargins","     *  @return Object","     */","    _getDefaultMargins: function() ","    {","        return {","            top: 0,","            left: 0,","            right: 0,","            bottom: 4","        };","    },","    ","    /**","     * Sets the length of the tick on either side of the axis line.","     *","     * @method setTickOffsets","     * @protected","     */","    setTickOffsets: function()","    {","        var host = this,","            majorTicks = host.get(\"styles\").majorTicks,","            tickLength = majorTicks.length,","            halfTick = tickLength * 0.5,","            display = majorTicks.display;","        host.set(\"leftTickOffset\",  0);","        host.set(\"rightTickOffset\",  0);","        switch(display)","        {","            case \"inside\" :","                host.set(\"bottomTickOffset\", tickLength);","                host.set(\"topTickOffset\", 0);","            break;","            case \"outside\" : ","                host.set(\"bottomTickOffset\", 0);","                host.set(\"topTickOffset\",  tickLength);","            break;","            case \"cross\" :","                host.set(\"topTickOffset\", halfTick);","                host.set(\"bottomTickOffset\", halfTick);","            break;","            default:","                host.set(\"topTickOffset\", 0);","                host.set(\"bottomTickOffset\", 0);","            break;","        }","    },","","    /**","     * Calculates the coordinates for the first point on an axis.","     *","     * @method getLineStart","     * @protected","     */","    getLineStart: function()","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            majorTicks = style.majorTicks,","            tickLength = majorTicks.length,","            display = majorTicks.display,","            pt = {x:0, y:padding.top};","        if(display === \"outside\")","        {","            pt.y += tickLength;","        }","        else if(display === \"cross\")","        {","            pt.y += tickLength/2;","        }","        return pt; ","    },","    ","    /**","     * Draws a tick","     *","     * @method drawTick","     * @param {Path} path reference to the path `Path` element in which to draw the tick.","     * @param {Object} pt hash containing x and y coordinates","     * @param {Object} tickStyles hash of properties used to draw the tick","     * @protected","     */","    drawTick: function(path, pt, tickStyles)","    {","        var host = this,","            style = host.get(\"styles\"),","            padding = style.padding,","            tickLength = tickStyles.length,","            start = {x:pt.x, y:padding.top},","            end = {x:pt.x, y:tickLength + padding.top};","        host.drawLine(path, start, end);","    },","    ","    /**","     * Calculates the point for a label.","     *","     * @method getLabelPoint","     * @param {Object} pt hash containing x and y coordinates","     * @return Object","     * @protected","     */","    getLabelPoint: function(pt)","    {","        return {x:pt.x, y:pt.y - this.get(\"topTickOffset\")};","    },","    ","    /**","     * Updates the value for the `maxLabelSize` for use in calculating total size.","     *","     * @method updateMaxLabelSize","     * @param {HTMLElement} label to measure","     * @protected","     */","    updateMaxLabelSize: function(labelWidth, labelHeight)","    {","        var host = this,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            sinRadians = props.sinRadians,","            cosRadians = props.cosRadians,","            max;","        if(rot === 0)","        {","            max = labelHeight;","        }","        else if(absRot === 90)","        {","            max = labelWidth;","        }","        else","        {","            max = (sinRadians * labelWidth) + (cosRadians * labelHeight); ","        }","        host._maxLabelSize = Math.max(host._maxLabelSize, max);","    },","","    /**","     * Determines the available label height when the axis width has been explicitly set.","     *","     * @method getExplicitlySized","     * @return Boolean","     * @protected","     */","    getExplicitlySized: function(styles)","    {","        if(this._explicitHeight)","        {","            var host = this,","                h = host._explicitHeight,","                totalTitleSize = host._totalTitleSize,","                topTickOffset = host.get(\"topTickOffset\"),","                margin = styles.label.margin.right;","            host._maxLabelSize =  h - (topTickOffset + margin + totalTitleSize);","            return true;","        }","        return false;","    },","","    /**","     * Rotate and position title.","     *","     * @method positionTitle","     * @param {HTMLElement} label to rotate position","     * @protected","     */","    positionTitle: function(label)","    {","        var host = this,","            bounds = host._titleBounds,","            margin = host.get(\"styles\").title.margin,","            props = host._titleRotationProps,","            labelWidth = label.offsetWidth,","            labelHeight = label.offsetHeight,","            h = bounds.bottom - bounds.top,","            x = (host.get(\"width\") * 0.5) - (labelWidth * 0.5),","            y = h/2 - labelHeight/2;","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        if(margin && margin.top)","        {","            y += margin.top;","        }","        props.x = x;","        props.y = y;","        props.transformOrigin = [0.5, 0.5];","        host._rotate(label, props);","    },","","    /**","     * Rotate and position labels.","     *","     * @method positionLabel","     * @param {HTMLElement} label to rotate position","     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned","     * against.","     * @protected","     */","    positionLabel: function(label, pt, styles, i)","    {","        var host = this,","            totalTitleSize = this._totalTitleSize,","            maxLabelSize = host._maxLabelSize,","            leftOffset = pt.x,","            topOffset = pt.y + totalTitleSize + maxLabelSize,","            props = this._labelRotationProps,","            rot = props.rot,","            absRot = props.absRot,","            labelWidth = this._labelWidths[i],","            labelHeight = this._labelHeights[i];","        if(rot === 0)","        {","            leftOffset -= labelWidth * 0.5;","            topOffset -= labelHeight;","        }","        else","        {","            if(rot === 90)","            {","                leftOffset -= labelWidth;","                topOffset -= (labelHeight * 0.5);","            }","            else if (rot === -90)","            {","                topOffset -= (labelHeight * 0.5);","            }    ","            else if(rot > 0)","            {","                leftOffset -= labelWidth;","                topOffset -= labelHeight - (labelHeight * rot/180);","            }","            else","            {","                topOffset -= labelHeight - (labelHeight * absRot/180);","            }","        }","        props.x = Math.round(leftOffset);","        props.y = Math.round(topOffset);","        props.labelWidth = labelWidth;","        props.labelHeight = labelHeight;","        this._rotate(label, props);","    },","","    /**","     * Adjusts the coordinates of an axis label based on the rotation.","     *","     * @method _setRotationCoords","     * @param {Object} props Coordinates, dimension and rotation properties of the label.","     * @protected","     */","    _setRotationCoords: function(props)","    {","        var rot = props.rot,","            absRot = props.absRot,","            labelWidth = props.labelWidth,","            labelHeight = props.labelHeight,","            leftOffset,","            topOffset;","        if(rot === 0)","        {","            leftOffset = labelWidth * 0.5;","            topOffset = labelHeight;","        }","        else","        {","            if(rot === 90)","            {","                leftOffset = labelWidth;","                topOffset = (labelHeight * 0.5);","            }","            else if (rot === -90)","            {","                topOffset = (labelHeight * 0.5);","            }    ","            else if(rot > 0)","            {","                leftOffset = labelWidth;","                topOffset = labelHeight - (labelHeight * rot/180);","            }","            else","            {","                topOffset = labelHeight - (labelHeight * absRot/180);","            }","        }","        props.x -= leftOffset;","        props.y -= topOffset;","    },","","    /**","     * Returns the transformOrigin to use for an axis label based on the position of the axis ","     * and the rotation of the label.","     *","     * @method _getTransformOrigin","     * @param {Number} rot The rotation (in degrees) of the label.","     * @return Array","     * @protected","     */","    _getTransformOrigin: function(rot)","    {","        var transformOrigin;","        if(rot === 0)","        {","            transformOrigin = [0, 0];","        }","        else","        {","            if(rot === 90)","            {","                transformOrigin = [1, 0.5];","            }","            else if (rot === -90)","            {","                transformOrigin = [0, 0.5];","            }    ","            else if(rot > 0)","            {","                transformOrigin = [1, 0.5];","            }","            else","            {","                transformOrigin = [0, 0.5];","            }","        }","        return transformOrigin;","    },","","    /**","     * Adjusts position for inner ticks.","     *","     * @method offsetNodeForTick","     * @param {Node} cb contentBox of the axis","     * @protected","     */","    offsetNodeForTick: function(cb)","    {","    },","","    /**","     * Assigns a height based on the size of the contents.","     *","     * @method setCalculatedSize","     * @protected","     */","    setCalculatedSize: function()","    {","        var host = this,","            graphic = host.get(\"graphic\"),","            styles = host.get(\"styles\"),","            labelMargin = styles.label.margin,","            totalLabelSize = labelMargin.bottom + host._maxLabelSize,","            totalTitleSize = host._totalTitleSize,","            topTickOffset = this.get(\"topTickOffset\"),","            ttl = Math.round(topTickOffset + totalLabelSize + totalTitleSize);","        if(this._explicitHeight)","        {","           ttl = this._explicitWidth; ","        }","        host.set(\"calculatedHeight\", ttl);","        graphic.set(\"y\", ttl - topTickOffset);","    }","};","Y.TopAxisLayout = TopAxisLayout;","","/**"," * The Axis class. Generates axes for a chart."," *"," * @module charts"," * @submodule charts-base"," * @class Axis"," * @extends Widget"," * @uses Renderer"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," */","Y.Axis = Y.Base.create(\"axis\", Y.Widget, [Y.Renderer], {","    /**","     * Storage for calculatedWidth value.","     *","     * @property _calculatedWidth","     * @type Number","     * @private","     */","    _calculatedWidth: 0,","","    /**","     * Storage for calculatedHeight value.","     *","     * @property _calculatedHeight","     * @type Number","     * @private","     */","    _calculatedHeight: 0,","","    /**","     * Handles change to the dataProvider","     * ","     * @method _dataChangeHandler","     * @param {Object} e Event object","     * @private","     */","    _dataChangeHandler: function(e)","    {","        if(this.get(\"rendered\"))","        {","            this._drawAxis();","        }","    },","","    /**","     * Handles change to the position attribute","     *","     * @method _positionChangeHandler","     * @param {Object} e Event object","     * @private","     */","    _positionChangeHandler: function(e)","    {","        this._updateGraphic(e.newVal);","        this._updateHandler();","    },","","    /**","     * Updates the the Graphic instance","     *","     * @method _updateGraphic","     * @param {String} position Position of axis ","     * @private","     */","    _updateGraphic: function(position)","    {","        var graphic = this.get(\"graphic\");","        if(position == \"none\")","        {","            if(graphic)","            {","                graphic.destroy();","            }","        }","        else","        {","            if(!graphic)","            {","                this._setCanvas();","            }","        }","    },","","    /**","     * Handles changes to axis.","     *","     * @method _updateHandler","     * @param {Object} e Event object","     * @private","     */","    _updateHandler: function(e)","    {","        if(this.get(\"rendered\"))","        {","            this._drawAxis();","        }","    },","   ","    /**","     * @method renderUI","     * @private","     */","    renderUI: function()","    {","        this._updateGraphic(this.get(\"position\"));","    },","","    /**","     * @method syncUI","     * @private","     */","    syncUI: function()","    {","        var layout = this._layout,","            defaultMargins,","            styles,","            label,","            title,","            i;","        if(layout)","        {","            defaultMargins = layout._getDefaultMargins();","            styles = this.get(\"styles\");","            label = styles.label.margin;","            title =styles.title.margin;","            //need to defaultMargins method to the layout classes.","            for(i in defaultMargins)","            {","                if(defaultMargins.hasOwnProperty(i))","                {","                    label[i] = label[i] === undefined ? defaultMargins[i] : label[i];","                    title[i] = title[i] === undefined ? defaultMargins[i] : title[i];","                }","            }","        }","        this._drawAxis();","    },","","    /**","     * Creates a graphic instance to be used for the axis line and ticks.","     *","     * @method _setCanvas","     * @private","     */","    _setCanvas: function()","    {","        var cb = this.get(\"contentBox\"),","            bb = this.get(\"boundingBox\"),","            p = this.get(\"position\"),","            pn = this._parentNode,","            w = this.get(\"width\"),","            h = this.get(\"height\");","        bb.setStyle(\"position\", \"absolute\");","        bb.setStyle(\"zIndex\", 2);","        w = w ? w + \"px\" : pn.getStyle(\"width\");","        h = h ? h + \"px\" : pn.getStyle(\"height\");","        if(p === \"top\" || p === \"bottom\")","        {","            cb.setStyle(\"width\", w);","        }","        else","        {","            cb.setStyle(\"height\", h);","        }","        cb.setStyle(\"position\", \"relative\");","        cb.setStyle(\"left\", \"0px\");","        cb.setStyle(\"top\", \"0px\");","        this.set(\"graphic\", new Y.Graphic());","        this.get(\"graphic\").render(cb);","    },","	","    /**","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     * @protected","     */","    _getDefaultStyles: function()","    {","        var axisstyles = {","            majorTicks: {","                display:\"inside\",","                length:4,","                color:\"#dad8c9\",","                weight:1,","                alpha:1","            },","            minorTicks: {","                display:\"none\",","                length:2,","                color:\"#dad8c9\",","                weight:1","            },","            line: {","                weight:1,","                color:\"#dad8c9\",","                alpha:1","            },","            majorUnit: {","                determinant:\"count\",","                count:11,","                distance:75","            },","            top: \"0px\",","            left: \"0px\",","            width: \"100px\",","            height: \"100px\",","            label: {","                color:\"#808080\",","                alpha: 1,","                fontSize:\"85%\",","                rotation: 0,","                margin: {","                    top: undefined,","                    right: undefined,","                    bottom: undefined,","                    left: undefined","                }","            },","            title: {","                color:\"#808080\",","                alpha: 1,","                fontSize:\"85%\",","                rotation: undefined,","                margin: {","                    top: undefined,","                    right: undefined,","                    bottom: undefined,","                    left: undefined","                }","            },","            hideOverlappingLabelTicks: false","        };","        ","        return Y.merge(Y.Renderer.prototype._getDefaultStyles(), axisstyles); ","    },","","    /**","     * Updates the axis when the size changes.","     *","     * @method _handleSizeChange","     * @param {Object} e Event object.","     * @private","     */","    _handleSizeChange: function(e)","    {","        var attrName = e.attrName,","            pos = this.get(\"position\"),","            vert = pos == \"left\" || pos == \"right\",","            cb = this.get(\"contentBox\"),","            hor = pos == \"bottom\" || pos == \"top\";","        cb.setStyle(\"width\", this.get(\"width\"));","        cb.setStyle(\"height\", this.get(\"height\"));","        if((hor && attrName == \"width\") || (vert && attrName == \"height\"))","        {","            this._drawAxis();","        }","    },","   ","    /**","     * Maps key values to classes containing layout algorithms","     *","     * @property _layoutClasses","     * @type Object","     * @private","     */","    _layoutClasses: ","    {","        top : TopAxisLayout,","        bottom: BottomAxisLayout,","        left: LeftAxisLayout,","        right : RightAxisLayout","    },","    ","    /**","     * Draws a line segment between 2 points","     *","     * @method drawLine","     * @param {Object} startPoint x and y coordinates for the start point of the line segment","     * @param {Object} endPoint x and y coordinates for the for the end point of the line segment","     * @param {Object} line styles (weight, color and alpha to be applied to the line segment)","     * @private","     */","    drawLine: function(path, startPoint, endPoint)","    {","        path.moveTo(startPoint.x, startPoint.y);","        path.lineTo(endPoint.x, endPoint.y);","    },","","    /**","     * Generates the properties necessary for rotating and positioning a text field.","     *","     * @method _getTextRotationProps","     * @param {Object} styles properties for the text field","     * @return Object","     * @private","     */","    _getTextRotationProps: function(styles)","    {","        if(styles.rotation === undefined)","        {","            switch(this.get(\"position\"))","            {","                case \"left\" :","                    styles.rotation = -90;","                break; ","                case \"right\" : ","                    styles.rotation = 90;","                break;","                default :","                    styles.rotation = 0;","                break;","            }","        }","        var rot =  Math.min(90, Math.max(-90, styles.rotation)),","            absRot = Math.abs(rot),","            radCon = Math.PI/180,","            sinRadians = parseFloat(parseFloat(Math.sin(absRot * radCon)).toFixed(8)),","            cosRadians = parseFloat(parseFloat(Math.cos(absRot * radCon)).toFixed(8));","        return {","            rot: rot,","            absRot: absRot,","            radCon: radCon,","            sinRadians: sinRadians,","            cosRadians: cosRadians,","            textAlpha: styles.alpha","        };","    },","","    /**","     * Draws an axis. ","     *","     * @method _drawAxis","     * @private","     */","    _drawAxis: function ()","    {","        if(this._drawing)","        {","            this._callLater = true;","            return;","        }","        this._drawing = true;","        this._callLater = false;","        if(this._layout)","        {","            var styles = this.get(\"styles\"),","                line = styles.line,","                labelStyles = styles.label,","                majorTickStyles = styles.majorTicks,","                drawTicks = majorTickStyles.display != \"none\",","                tickPoint,","                majorUnit = styles.majorUnit,","                len,","                majorUnitDistance,","                i = 0,","                layout = this._layout,","                layoutLength,","                position,","                lineStart,","                label,","                labelWidth,","                labelHeight,","                labelFunction = this.get(\"labelFunction\"),","                labelFunctionScope = this.get(\"labelFunctionScope\"),","                labelFormat = this.get(\"labelFormat\"),","                graphic = this.get(\"graphic\"),","                path = this.get(\"path\"),","                tickPath,","                explicitlySized;","            this._labelWidths = [];","            this._labelHeights = [];","            graphic.set(\"autoDraw\", false);","            path.clear();","            path.set(\"stroke\", {","                weight: line.weight, ","                color: line.color, ","                opacity: line.alpha","            });","            this._labelRotationProps = this._getTextRotationProps(labelStyles);","            this._labelRotationProps.transformOrigin = layout._getTransformOrigin(this._labelRotationProps.rot);","            layout.setTickOffsets.apply(this);","            layoutLength = this.getLength();","            lineStart = layout.getLineStart.apply(this);","            len = this.getTotalMajorUnits(majorUnit);","            majorUnitDistance = this.getMajorUnitDistance(len, layoutLength, majorUnit);","            this.set(\"edgeOffset\", this.getEdgeOffset(len, layoutLength) * 0.5);","            if(len < 1)","            {","                this._clearLabelCache();","            }","            else","            {","                tickPoint = this.getFirstPoint(lineStart);","                this.drawLine(path, lineStart, this.getLineEnd(tickPoint));","                if(drawTicks) ","                {","                    tickPath = this.get(\"tickPath\");","                    tickPath.clear();","                    tickPath.set(\"stroke\", {","                        weight: majorTickStyles.weight,","                        color: majorTickStyles.color,","                        opacity: majorTickStyles.alpha","                    });","                   layout.drawTick.apply(this, [tickPath, tickPoint, majorTickStyles]);","                }","                this._createLabelCache();","                this._tickPoints = [];","                this._maxLabelSize = 0; ","                this._totalTitleSize = 0;","                this._titleSize = 0;","                this._setTitle();","                explicitlySized = layout.getExplicitlySized.apply(this, [styles]);","                for(; i < len; ++i)","                {","                    if(drawTicks) ","                    {","                        layout.drawTick.apply(this, [tickPath, tickPoint, majorTickStyles]);","                    }","                    position = this.getPosition(tickPoint);","                    label = this.getLabel(tickPoint, labelStyles);","                    this._labels.push(label);","                    this._tickPoints.push({x:tickPoint.x, y:tickPoint.y});","                    this.get(\"appendLabelFunction\")(label, labelFunction.apply(labelFunctionScope, [this.getLabelByIndex(i, len), labelFormat]));","                    labelWidth = Math.round(label.offsetWidth);","                    labelHeight = Math.round(label.offsetHeight);","                    if(!explicitlySized)","                    {","                        this._layout.updateMaxLabelSize.apply(this, [labelWidth, labelHeight]);","                    }","                    this._labelWidths.push(labelWidth);","                    this._labelHeights.push(labelHeight);","                    tickPoint = this.getNextPoint(tickPoint, majorUnitDistance);","                }","                this._clearLabelCache();","                if(this.get(\"overlapGraph\"))","                {","                   layout.offsetNodeForTick.apply(this, [this.get(\"contentBox\")]);","                }","                layout.setCalculatedSize.apply(this);","                if(this._titleTextField)","                {","                    this._layout.positionTitle.apply(this, [this._titleTextField]);","                }","                for(i = 0; i < len; ++i)","                {","                    layout.positionLabel.apply(this, [this.get(\"labels\")[i], this._tickPoints[i], styles, i]);","                }","            }","        }","        this._drawing = false;","        if(this._callLater)","        {","            this._drawAxis();","        }","        else","        {","            this._updatePathElement();","            this.fire(\"axisRendered\");","        }","    },","    ","    /**","     * Calculates and sets the total size of a title.","     *","     * @method _setTotalTitleSize","     * @param {Object} styles Properties for the title field.","     * @private","     */","    _setTotalTitleSize: function(styles)","    {","        var title = this._titleTextField,","            w = title.offsetWidth,","            h = title.offsetHeight,","            rot = this._titleRotationProps.rot,","            bounds,","            size,","            margin = styles.margin,","            position = this.get(\"position\"),","            matrix = new Y.Matrix();","        matrix.rotate(rot);","        bounds = matrix.getContentRect(w, h);","        if(position == \"left\" || position == \"right\")","        {","            size = bounds.right - bounds.left;","            if(margin)","            {","                size += margin.left + margin.right;","            }","        }","        else","        {","            size = bounds.bottom - bounds.top;","            if(margin)","            {","                size += margin.top + margin.bottom;","            }","        }","        this._titleBounds = bounds;","        this._totalTitleSize = size;","    },","","    /**","     *  Updates path.","     *","     *  @method _updatePathElement","     *  @private","     */","    _updatePathElement: function()","    {","        var path = this._path,","            tickPath = this._tickPath,","            redrawGraphic = false,","            graphic = this.get(\"graphic\");","        if(path)","        {","            redrawGraphic = true;","            path.end();","        }","        if(tickPath)","        {","            redrawGraphic = true;","            tickPath.end();","        }","        if(redrawGraphic)","        {","            graphic._redraw();","        }","    },","","    /**","     * Updates the content and style properties for a title field.","     *","     * @method _updateTitle","     * @private","     */","    _setTitle: function()","    {","        var i,","            styles,","            customStyles,","            title = this.get(\"title\"),","            titleTextField = this._titleTextField,","            parentNode;","        if(title !== null && title !== undefined)","        {","            customStyles = {","                    rotation: \"rotation\",","                    margin: \"margin\",","                    alpha: \"alpha\"","            };","            styles = this.get(\"styles\").title;","            if(!titleTextField)","            {","                titleTextField = DOCUMENT.createElement('span');","                titleTextField.style.display = \"block\";","                titleTextField.style.whiteSpace = \"nowrap\";","                titleTextField.setAttribute(\"class\", \"axisTitle\");","                this.get(\"contentBox\").append(titleTextField);","            }","            else if(!DOCUMENT.createElementNS)","            {","                if(titleTextField.style.filter)","                {","                    titleTextField.style.filter = null;","                }","            }","            titleTextField.style.position = \"absolute\";","            for(i in styles)","            {","                if(styles.hasOwnProperty(i) && !customStyles.hasOwnProperty(i))","                {","                    titleTextField.style[i] = styles[i];","                }","            }","            this.get(\"appendTitleFunction\")(titleTextField, title);","            this._titleTextField = titleTextField;","            this._titleRotationProps = this._getTextRotationProps(styles);","            this._setTotalTitleSize(styles);","        }","        else if(titleTextField)","        {","            parentNode = titleTextField.parentNode;","            if(parentNode)","            {","                parentNode.removeChild(titleTextField);","            }","            this._titleTextField = null;","            this._totalTitleSize = 0;","        }","    },","","    /**","     * Creates or updates an axis label.","     *","     * @method getLabel","     * @param {Object} pt x and y coordinates for the label","     * @param {Object} styles styles applied to label","     * @return HTMLElement ","     * @private","     */","    getLabel: function(pt, styles)","    {","        var i,","            label,","            labelCache = this._labelCache,","            customStyles = {","                rotation: \"rotation\",","                margin: \"margin\",","                alpha: \"alpha\"","            };","        if(labelCache && labelCache.length > 0)","        {","            label = labelCache.shift();","        }","        else","        {","            label = DOCUMENT.createElement(\"span\");","            label.className = Y.Lang.trim([label.className, \"axisLabel\"].join(' '));","            this.get(\"contentBox\").append(label);","        }","        if(!DOCUMENT.createElementNS)","        {","            if(label.style.filter)","            {","                label.style.filter = null;","            }","        }","        label.style.display = \"block\";","        label.style.whiteSpace = \"nowrap\";","        label.style.position = \"absolute\";","        for(i in styles)","        {","            if(styles.hasOwnProperty(i) && !customStyles.hasOwnProperty(i))","            {","                label.style[i] = styles[i];","            }","        }","        return label;","    },","","    /**","     * Creates a cache of labels that can be re-used when the axis redraws.","     *","     * @method _createLabelCache","     * @private","     */","    _createLabelCache: function()","    {","        if(this._labels)","        {","            while(this._labels.length > 0)","            {","                this._labelCache.push(this._labels.shift());","            }","        }","        else","        {","            this._clearLabelCache();","        }","        this._labels = [];","    },","    ","    /**","     * Removes axis labels from the dom and clears the label cache.","     *","     * @method _clearLabelCache","     * @private","     */","    _clearLabelCache: function()","    {","        if(this._labelCache)","        {","            var len = this._labelCache.length,","                i = 0,","                label;","            for(; i < len; ++i)","            {","                label = this._labelCache[i];","                this._removeChildren(label);","                Y.Event.purgeElement(label, true);","                label.parentNode.removeChild(label);","            }","        }","        this._labelCache = [];","    },","","    /**","     * Gets the end point of an axis.","     *","     * @method getLineEnd","     * @return Object","     * @private ","     */","    getLineEnd: function(pt)","    {","        var w = this.get(\"width\"),","            h = this.get(\"height\"),","            pos = this.get(\"position\");","        if(pos === \"top\" || pos === \"bottom\")","        {","            return {x:w, y:pt.y};","        }","        else","        {","            return {x:pt.x, y:h};","        }","    },","","    /**","     * Calcuates the width or height of an axis depending on its direction.","     *","     * @method getLength","     * @return Number","     * @private","     */","    getLength: function()","    {","        var l,","            style = this.get(\"styles\"),","            padding = style.padding,","            w = this.get(\"width\"),","            h = this.get(\"height\"),","            pos = this.get(\"position\");","        if(pos === \"top\" || pos === \"bottom\")","        {","            l = w - (padding.left + padding.right);","        }","        else","        {","            l = h - (padding.top + padding.bottom);","        }","        return l;","    },","","    /**","     * Gets the position of the first point on an axis.","     *","     * @method getFirstPoint","     * @param {Object} pt Object containing x and y coordinates.","     * @return Object","     * @private","     */","    getFirstPoint:function(pt)","    {","        var style = this.get(\"styles\"),","            pos = this.get(\"position\"),","            padding = style.padding,","            np = {x:pt.x, y:pt.y};","        if(pos === \"top\" || pos === \"bottom\")","        {","            np.x += padding.left + this.get(\"edgeOffset\");","        }","        else","        {","            np.y += this.get(\"height\") - (padding.top + this.get(\"edgeOffset\"));","        }","        return np;","    },","","    /**","     * Gets the position of the next point on an axis.","     *","     * @method getNextPoint","     * @param {Object} point Object containing x and y coordinates.","     * @param {Number} majorUnitDistance Distance in pixels between ticks.","     * @return Object","     * @private","     */","    getNextPoint: function(point, majorUnitDistance)","    {","        var pos = this.get(\"position\");","        if(pos === \"top\" || pos === \"bottom\")","        {","            point.x = point.x + majorUnitDistance;		","        }","        else","        {","            point.y = point.y - majorUnitDistance;","        }","        return point;","    },","","    /**","     * Calculates the placement of last tick on an axis.","     *","     * @method getLastPoint","     * @return Object","     * @private ","     */","    getLastPoint: function()","    {","        var style = this.get(\"styles\"),","            padding = style.padding,","            w = this.get(\"width\"),","            pos = this.get(\"position\");","        if(pos === \"top\" || pos === \"bottom\")","        {","            return {x:w - padding.right, y:padding.top};","        }","        else","        {","            return {x:padding.left, y:padding.top};","        }","    },","","    /**","     * Calculates position on the axis.","     *","     * @method getPosition","     * @param {Object} point contains x and y values","     * @private ","     */","    getPosition: function(point)","    {","        var p,","            h = this.get(\"height\"),","            style = this.get(\"styles\"),","            padding = style.padding,","            pos = this.get(\"position\"),","            dataType = this.get(\"dataType\");","        if(pos === \"left\" || pos === \"right\") ","        {","            //Numeric data on a vertical axis is displayed from bottom to top.","            //Categorical and Timeline data is displayed from top to bottom.","            if(dataType === \"numeric\")","            {","                p = (h - (padding.top + padding.bottom)) - (point.y - padding.top);","            }","            else","            {","                p = point.y - padding.top;","            }","        }","        else","        {","            p = point.x - padding.left;","        }","        return p;","    },","","    /**","     * Rotates and positions a text field.","     *","     * @method _rotate","     * @param {HTMLElement} label text field to rotate and position","     * @param {Object} props properties to be applied to the text field. ","     * @private","     */","    _rotate: function(label, props)","    {","        var rot = props.rot,","            x = props.x,","            y = props.y,","            filterString,","            textAlpha,","            matrix = new Y.Matrix(),","            transformOrigin = props.transformOrigin || [0, 0],","            offsetRect;","        if(DOCUMENT.createElementNS)","        {","            matrix.translate(x, y);","            matrix.rotate(rot);","            Y_DOM.setStyle(label, \"transformOrigin\", (transformOrigin[0] * 100) + \"% \" + (transformOrigin[1] * 100) + \"%\");","            Y_DOM.setStyle(label, \"transform\", matrix.toCSSText());","        }","        else","        {","            textAlpha = props.textAlpha;","            if(Y_Lang.isNumber(textAlpha) && textAlpha < 1 && textAlpha > -1 && !isNaN(textAlpha))","            {","                filterString = \"progid:DXImageTransform.Microsoft.Alpha(Opacity=\" + Math.round(textAlpha * 100) + \")\";","            }","            if(rot !== 0)","            {","                //ms filters kind of, sort of uses a transformOrigin of 0, 0. ","                //we'll translate the difference to create a true 0, 0 origin.","                matrix.rotate(rot);","                offsetRect = matrix.getContentRect(props.labelWidth, props.labelHeight);","                matrix.init();","                matrix.translate(offsetRect.left, offsetRect.top);","                matrix.translate(x, y);","                this._simulateRotateWithTransformOrigin(matrix, rot, transformOrigin, props.labelWidth, props.labelHeight);","                if(filterString)","                {","                    filterString += \" \";","                }","                else","                {","                    filterString = \"\"; ","                }","                filterString += matrix.toFilterText();","                label.style.left = matrix.dx + \"px\";","                label.style.top = matrix.dy + \"px\";","            }","            else","            {","                label.style.left = x + \"px\";","                label.style.top = y + \"px\";","            }","            if(filterString)","            {","                label.style.filter = filterString;","            }","        }","    },","    ","    /**","     * Simulates a rotation with a specified transformOrigin. ","     *","     * @method _simulateTransformOrigin","     * @param {Matrix} matrix Reference to a `Matrix` instance.","     * @param {Number} rot The rotation (in degrees) that will be performed on a matrix.","     * @param {Array} transformOrigin An array represeniting the origin in which to perform the transform. The first ","     * index represents the x origin and the second index represents the y origin.","     * @param {Number} w The width of the object that will be transformed.","     * @param {Number} h The height of the object that will be transformed.","     * @private","     */","    _simulateRotateWithTransformOrigin: function(matrix, rot, transformOrigin, w, h)","    {","        var transformX = transformOrigin[0] * w,","            transformY = transformOrigin[1] * h;","        transformX = !isNaN(transformX) ? transformX : 0;","        transformY = !isNaN(transformY) ? transformY : 0;","        matrix.translate(transformX, transformY);","        matrix.rotate(rot);","        matrix.translate(-transformX, -transformY);","    },","","    /**","     * Returns the coordinates (top, right, bottom, left) for the bounding box of the last label. ","     *","     * @method getMaxLabelBounds","     * @return Object","     */","    getMaxLabelBounds: function()","    {","        return this._getLabelBounds(this.getMaximumValue());","    },","","    /**","     * Returns the coordinates (top, right, bottom, left) for the bounding box of the first label. ","     *","     * @method getMinLabelBounds","     * @return Object","     */","    getMinLabelBounds: function()","    {","        return this._getLabelBounds(this.getMinimumValue());","    },","    ","    /**","     * Returns the coordinates (top, right, bottom, left) for the bounding box of a label. ","     *","     * @method _getLabelBounds","     * @param {String} Value of the label","     * @return Object","     * @private","     */","    _getLabelBounds: function(val)","    {","        var layout = this._layout,","            labelStyles = this.get(\"styles\").label,","            matrix = new Y.Matrix(),","            label,","            props = this._getTextRotationProps(labelStyles);","            props.transformOrigin = layout._getTransformOrigin(props.rot);","        label = this.getLabel({x: 0, y: 0}, labelStyles);","        this.get(\"appendLabelFunction\")(label, this.get(\"labelFunction\").apply(this, [val, this.get(\"labelFormat\")]));","        props.labelWidth = label.offsetWidth;","        props.labelHeight = label.offsetHeight;","        this._removeChildren(label);","        Y.Event.purgeElement(label, true);","        label.parentNode.removeChild(label);","        props.x = 0;","        props.y = 0;","        layout._setRotationCoords(props);","        matrix.translate(props.x, props.y);","        this._simulateRotateWithTransformOrigin(matrix, props.rot, props.transformOrigin, props.labelWidth, props.labelHeight);","        return matrix.getContentRect(props.labelWidth, props.labelHeight);","    },","","    /**","     * Removes all DOM elements from an HTML element. Used to clear out labels during detruction","     * phase.","     *","     * @method _removeChildren","     * @private","     */","    _removeChildren: function(node)","    {","        if(node.hasChildNodes())","        {","            var child;","            while(node.firstChild)","            {","                child = node.firstChild;","                this._removeChildren(child);","                node.removeChild(child);","            }","        }","    },","    ","    /**","     * Destructor implementation Axis class. Removes all labels and the Graphic instance from the widget.","     *","     * @method destructor","     * @protected","     */","    destructor: function()","    {","        var cb = this.get(\"contentBox\").getDOMNode(),","            labels = this.get(\"labels\"),","            graphic = this.get(\"graphic\"),","            label,","            len = labels ? labels.length : 0;","        if(len > 0)","        {","            while(labels.length > 0)","            {","                label = labels.shift();","                this._removeChildren(label);","                cb.removeChild(label);","                label = null;","            }","        }","        if(graphic)","        {","            graphic.destroy();","        }","    },","","    /**","     * Length in pixels of largest text bounding box. Used to calculate the height of the axis.","     *","     * @property maxLabelSize","     * @type Number","     * @protected","     */","    _maxLabelSize: 0,","    ","    /**","     * Updates the content of text field. This method writes a value into a text field using ","     * `appendChild`. If the value is a `String`, it is converted to a `TextNode` first. ","     *","     * @method _setText","     * @param label {HTMLElement} label to be updated","     * @param val {String} value with which to update the label","     * @private","     */","    _setText: function(textField, val)","    { ","        textField.innerHTML = \"\";","        if(Y_Lang.isNumber(val))","        {","            val = val + \"\";","        }","        else if(!val)","        {","            val = \"\";","        }","        if(IS_STRING(val))","        {","            val = DOCUMENT.createTextNode(val);","        }","        textField.appendChild(val);","    }","}, {","    ATTRS: ","    {","        /**","         * When set, defines the width of a vertical axis instance. By default, vertical axes automatically size based on their contents. When the","         * width attribute is set, the axis will not calculate its width. When the width attribute is explicitly set, axis labels will postion themselves off of the ","         * the inner edge of the axis and the title, if present, will position itself off of the outer edge. If a specified width is less than the sum of ","         * the axis' contents, excess content will overflow.","         *","         * @attribute width","         * @type Number","         */","        width: {","            lazyAdd: false,","","            getter: function() ","            {","                if(this._explicitWidth)","                {","                    return this._explicitWidth;        ","                }","                return this._calculatedWidth;","            },","","            setter: function(val)","            {","                this._explicitWidth = val;","                return val;","            }","        },","","        /**","         * When set, defines the height of a horizontal axis instance. By default, horizontal axes automatically size based on their contents. When the","         * height attribute is set, the axis will not calculate its height. When the height attribute is explicitly set, axis labels will postion themselves off of the ","         * the inner edge of the axis and the title, if present, will position itself off of the outer edge. If a specified height is less than the sum of ","         * the axis' contents, excess content will overflow.","         *","         * @attribute height","         * @type Number","         */","        height: {","            lazyAdd: false,","","            getter: function() ","            {","                if(this._explicitHeight)","                {","                    return this._explicitHeight;        ","                }","                return this._calculatedHeight;","            },","","            setter: function(val)","            {","                this._explicitHeight = val;","                return val;","            }","        },","","        /**","         * Calculated value of an axis' width. By default, the value is used internally for vertical axes. If the `width` attribute is explicitly set, this value will be ignored.","         *","         * @attribute calculatedWidth","         * @type Number","         * @private","         */","        calculatedWidth: {","            getter: function()","            {","                return this._calculatedWidth;","            },","","            setter: function(val)","            {","                this._calculatedWidth = val;","                return val;","            }","        },","","        /**","         * Calculated value of an axis' height. By default, the value is used internally for horizontal axes. If the `height` attribute is explicitly set, this value will be ignored.","         *","         * @attribute calculatedHeight","         * @type Number","         * @private","         */","        calculatedHeight: {","            getter: function()","            {","                return this._calculatedHeight;","            },","","            setter: function(val)","            {","                this._calculatedHeight = val;","                return val;","            }","        },","","        /**","         * Difference betweend the first/last tick and edge of axis.","         *","         * @attribute edgeOffset","         * @type Number","         * @protected","         */","        edgeOffset: ","        {","            value: 0","        },","","        /**","         * The graphic in which the axis line and ticks will be rendered.","         *","         * @attribute graphic","         * @type Graphic","         */","        graphic: {},","    ","        /**","         *  @attribute path","         *  @type Shape","         *  @readOnly","         *  @private","         */","        path: {","            readOnly: true,","","            getter: function()","            {","                if(!this._path)","                {","                    var graphic = this.get(\"graphic\");","                    if(graphic)","                    {","                        this._path = graphic.addShape({type:\"path\"});","                    }","                }","                return this._path;","            }","        },","","        /**","         *  @attribute tickPath","         *  @type Shape","         *  @readOnly","         *  @private","         */","        tickPath: {","            readOnly: true,","","            getter: function()","            {","                if(!this._tickPath)","                {","                    var graphic = this.get(\"graphic\");","                    if(graphic)","                    {","                        this._tickPath = graphic.addShape({type:\"path\"});","                    }","                }","                return this._tickPath;","            }","        },","        ","        /**","         * Contains the contents of the axis. ","         *","         * @attribute node","         * @type HTMLElement","         */","        node: {},","","        /**","         * Direction of the axis.","         *","         * @attribute position","         * @type String","         */","        position: {","            setter: function(val)","            {","                var layoutClass = this._layoutClasses[val];","                if(val && val != \"none\")","                {","                    this._layout = new layoutClass();","                }","                return val;","            }","        },","","        /**","         * Distance determined by the tick styles used to calculate the distance between the axis","         * line in relation to the top of the axis.","         *","         * @attribute topTickOffset","         * @type Number","         */","        topTickOffset: {","            value: 0","        },","","        /**","         * Distance determined by the tick styles used to calculate the distance between the axis","         * line in relation to the bottom of the axis.","         *","         * @attribute bottomTickOffset","         * @type Number","         */","        bottomTickOffset: {","            value: 0","        },","","        /**","         * Distance determined by the tick styles used to calculate the distance between the axis","         * line in relation to the left of the axis.","         *","         * @attribute leftTickOffset","         * @type Number","         */","        leftTickOffset: {","            value: 0","        },","","        /**","         * Distance determined by the tick styles used to calculate the distance between the axis","         * line in relation to the right side of the axis.","         *","         * @attribute rightTickOffset","         * @type Number","         */","        rightTickOffset: {","            value: 0","        },","        ","        /**","         * Collection of labels used to render the axis.","         *","         * @attribute labels","         * @type Array","         */","        labels: {","            readOnly: true,","            getter: function()","            {","                return this._labels;","            }","        },","","        /**","         * Collection of points used for placement of labels and ticks along the axis.","         *","         * @attribute tickPoints","         * @type Array","         */","        tickPoints: {","            readOnly: true,","","            getter: function()","            {","                if(this.get(\"position\") == \"none\")","                {","                    return this.get(\"styles\").majorUnit.count;","                }","                return this._tickPoints;","            }","        },","","        /**","         * Indicates whether the axis overlaps the graph. If an axis is the inner most axis on a given","         * position and the tick position is inside or cross, the axis will need to overlap the graph.","         *","         * @attribute overlapGraph","         * @type Boolean","         */","        overlapGraph: {","            value:true,","","            validator: function(val)","            {","                return Y_Lang.isBoolean(val);","            }","        },","","        /**","         * Object which should have by the labelFunction","         *","         * @attribute labelFunctionScope","         * @type Object","         */","        labelFunctionScope: {},","        ","        /**","         * Length in pixels of largest text bounding box. Used to calculate the height of the axis.","         *","         * @attribute maxLabelSize","         * @type Number","         * @protected","         */","        maxLabelSize: {","            getter: function()","            {","                return this._maxLabelSize;","            },","","            setter: function(val)","            {","                this._maxLabelSize = val;","                return val; ","            }","        },","        ","        /**","         *  Title for the axis. When specified, the title will display. The position of the title is determined by the axis position. ","         *  <dl>","         *      <dt>top</dt><dd>Appears above the axis and it labels. The default rotation is 0.</dd>","         *      <dt>right</dt><dd>Appears to the right of the axis and its labels. The default rotation is 90.</dd>","         *      <dt>bottom</dt><dd>Appears below the axis and its labels. The default rotation is 0.</dd>","         *      <dt>left</dt><dd>Appears to the left of the axis and its labels. The default rotation is -90.</dd>","         *  </dl>","         *","         *  @attribute title","         *  @type String","         */","        title: {","            value: null","        },","        ","        /**","         * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need","         * to implement the arguments below and return a `String` or `HTMLElement`. ","         * <dl>","         *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>","         *      <dt>format</dt><dd>Template for formatting label. (optional)</dd>","         * </dl>","         *","         * @attribute labelFunction","         * @type Function","         */","        labelFunction: {","            value: function(val, format)","            {","                return val;","            }","        },","        ","        /**","         * Function used to append an axis value to an axis label. This function has the following signature:","         *  <dl>","         *      <dt>textField</dt><dd>The axis label to be appended. (`HTMLElement`)</dd>","         *      <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`","         *      or a `String`. This method does not use (`HTMLElement` | `String`)</dd>","         *  </dl>","         * The default method appends a value to the `HTMLElement` using the `appendChild` method. If the given ","         * value is a `String`, the method will convert the the value to a `textNode` before appending to the ","         * `HTMLElement`. This method will not convert an `HTMLString` to an `HTMLElement`. ","         *","         * @attribute appendLabelFunction","         * @type Function","         */","        appendLabelFunction: {","            valueFn: function()","            {","                return this._setText;","            }","        },","        ","        /**","         * Function used to append a title value to the title object. This function has the following signature:","         *  <dl>","         *      <dt>textField</dt><dd>The title text field to be appended. (`HTMLElement`)</dd>","         *      <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`","         *      or a `String`. This method does not use (`HTMLElement` | `String`)</dd>","         *  </dl>","         * The default method appends a value to the `HTMLElement` using the `appendChild` method. If the given ","         * value is a `String`, the method will convert the the value to a `textNode` before appending to the ","         * `HTMLElement` element. This method will not convert an `HTMLString` to an `HTMLElement`. ","         *","         * @attribute appendTitleFunction","         * @type Function","         */","        appendTitleFunction: {","            valueFn: function()","            {","                return this._setText;","            }","        }","            ","        /**","         * Style properties used for drawing an axis. This attribute is inherited from `Renderer`. Below are the default values:","         *  <dl>","         *      <dt>majorTicks</dt><dd>Properties used for drawing ticks.","         *          <dl>","         *              <dt>display</dt><dd>Position of the tick. Possible values are `inside`, `outside`, `cross` and `none`. The","         *              default value is `inside`.</dd>","         *              <dt>length</dt><dd>The length (in pixels) of the tick. The default value is 4.</dd>","         *              <dt>color</dt><dd>The color of the tick. The default value is `#dad8c9`</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the tick. The default value is 1.</dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>line</dt><dd>Properties used for drawing the axis line. ","         *          <dl>","         *              <dt>weight</dt><dd>Number indicating the width of the axis line. The default value is 1.</dd>","         *              <dt>color</dt><dd>The color of the axis line. The default value is `#dad8c9`.</dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>majorUnit</dt><dd>Properties used to calculate the `majorUnit` for the axis. ","         *          <dl>","         *              <dt>determinant</dt><dd>The algorithm used for calculating distance between ticks. The possible options are `count` and `distance`. If","         *              the `determinant` is `count`, the axis ticks will spaced so that a specified number of ticks appear on the axis. If the `determinant`","         *              is `distance`, the axis ticks will spaced out according to the specified distance. The default value is `count`.</dd>","         *              <dt>count</dt><dd>Number of ticks to appear on the axis when the `determinant` is `count`. The default value is 11.</dd>","         *              <dt>distance</dt><dd>The distance (in pixels) between ticks when the `determinant` is `distance`. The default value is 75.</dd>","         *          </dl>","         *      </dd>","         *      <dt>label</dt><dd>Properties and styles applied to the axis labels.","         *          <dl>","         *              <dt>color</dt><dd>The color of the labels. The default value is `#808080`.</dd>","         *              <dt>alpha</dt><dd>Number between 0 and 1 indicating the opacity of the labels. The default value is 1.</dd>","         *              <dt>fontSize</dt><dd>The font-size of the labels. The default value is 85%</dd>","         *              <dt>rotation</dt><dd>The rotation, in degrees (between -90 and 90) of the labels. The default value is 0.</dd>","         *              <dt>margin</dt><dd>The distance between the label and the axis/tick. Depending on the position of the `Axis`, only one of the properties used.","         *                  <dl>","         *                      <dt>top</dt><dd>Pixel value used for an axis with a `position` of `bottom`. The default value is 4.</dd>","         *                      <dt>right</dt><dd>Pixel value used for an axis with a `position` of `left`. The default value is 4.</dd>","         *                      <dt>bottom</dt><dd>Pixel value used for an axis with a `position` of `top`. The default value is 4.</dd>","         *                      <dt>left</dt><dd>Pixel value used for an axis with a `position` of `right`. The default value is 4.</dd>","         *                  </dl>","         *              </dd>","         *          </dl>","         *      </dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","/**"," * AxisType is an abstract class that manages the data for an axis."," *"," * @module charts"," * @submodule charts-base"," * @class AxisType"," * @constructor"," * @extends Axis"," */","Y.AxisType = Y.Base.create(\"baseAxis\", Y.Axis, [], {","    /**","     * @method initializer","     * @private","     */","    initializer: function()","    {","        this.after(\"dataReady\", Y.bind(this._dataChangeHandler, this));","        this.after(\"dataUpdate\", Y.bind(this._dataChangeHandler, this));","        this.after(\"minimumChange\", Y.bind(this._keyChangeHandler, this));","        this.after(\"maximumChange\", Y.bind(this._keyChangeHandler, this));","        this.after(\"keysChange\", this._keyChangeHandler);","        this.after(\"dataProviderChange\", this._dataProviderChangeHandler);","        this.after(\"alwaysShowZeroChange\", this._keyChangeHandler);","        this.after(\"roundingMethodChange\", this._keyChangeHandler);","    },","","    /**","     * @method bindUI","     * @private","     */","    bindUI: function()","    {","        this.after(\"stylesChange\", this._updateHandler);","        this.after(\"overlapGraphChange\", this._updateHandler);","        this.after(\"positionChange\", this._positionChangeHandler);","        this.after(\"widthChange\", this._handleSizeChange);","        this.after(\"heightChange\", this._handleSizeChange);","        this.after(\"calculatedWidthChange\", this._handleSizeChange);","        this.after(\"calculatedHeightChange\", this._handleSizeChange);","    },","","    /**","     * Handles changes to `dataProvider`.","     *","     * @method _dataProviderChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _dataProviderChangeHandler: function(e)","    {","        var keyCollection = this.get(\"keyCollection\").concat(),","            keys = this.get(\"keys\"),","            i;","        if(keys)","        {","            for(i in keys)","            {","                if(keys.hasOwnProperty(i))","                {","                    delete keys[i];","                }","            }","        }","        if(keyCollection && keyCollection.length)","        {","            this.set(\"keys\", keyCollection);","        }","    },","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuibaseaxis\",","	","    /**","     * Type of data used in `Axis`.","     *","     * @property _type","     * @type String ","     * @readOnly","     * @private","     */","    _type: null,","	","    /**","     * Storage for `setMaximum` attribute.","     *","     * @property _setMaximum","     * @type Object","     * @private","     */","    _setMaximum: null,","	","    /**","     * Storage for `dataMaximum` attribute.","     *","     * @property _dataMaximum","     * @type Object","     * @private","     */","    _dataMaximum: null,","	","    /**","     * Storage for `setMinimum` attribute.","     *","     * @property _setMinimum","     * @type Object","     * @private","     */","    _setMinimum: null,","	","    /**","     * Reference to data array.","     *","     * @property _data","     * @type Array","     * @private","     */","    _data: null,","","    /**","     * Indicates whether the all data is up to date.","     *","     * @property _updateTotalDataFlag","     * @type Boolean","     * @private","     */","    _updateTotalDataFlag: true,","","    /**","     * Storage for `dataReady` attribute.","     *","     * @property _dataReady","     * @type Boolean","     * @readOnly","     * @private","     */","    _dataReady: false,","	","    /**","     * Adds an array to the key hash.","     *","     * @method addKey","     * @param value Indicates what key to use in retrieving","     * the array.","     */","    addKey: function (value)","	{","        this.set(\"keys\", value);","	},","","    /**","     * Gets an array of values based on a key.","     *","     * @method _getKeyArray","     * @param {String} key Value key associated with the data array.","     * @param {Array} data Array in which the data resides.","     * @return Array","     * @private","     */","    _getKeyArray: function(key, data)","    {","        var i = 0,","            obj,","            keyArray = [],","            len = data.length;","        for(; i < len; ++i)","        {","            obj = data[i];","            keyArray[i] = obj[key];","        }","        return keyArray;","    },","","    /**","     * Sets data by key","     *","     * @method _setDataByKey","     * @param {String} key Key value to use.","     * @param {Array} data Array to use.","     * @private ","     */","    _setDataByKey: function(key, data)","    {","        var i,","            obj, ","            arr = [], ","            dv = this._dataClone.concat(), ","            len = dv.length;","        for(i = 0; i < len; ++i)","        {","            obj = dv[i];","            arr[i] = obj[key];","        }","        this.get(\"keys\")[key] = arr;","        this._updateTotalDataFlag = true;","    },","","    /**","     * Updates the total data array.","     *","     * @method _updateTotalData","     * @private","     */","    _updateTotalData: function()","    {","		var keys = this.get(\"keys\"),","            i;","        this._data = [];","        for(i in keys)","        {","            if(keys.hasOwnProperty(i))","            {","                this._data = this._data.concat(keys[i]);","            }","        }","        this._updateTotalDataFlag = false;","    },","","    /**","     * Removes an array from the key hash.","     * ","     * @method removeKey","     * @param {String} value Indicates what key to use in removing from ","     * the hash.","     */","    removeKey: function(value)","    {","        var keys = this.get(\"keys\");","        if(keys.hasOwnProperty(value)) ","        {","            delete keys[value];","            this._keyChangeHandler();","        }","    },","","    /**","     * Returns a value based of a key value and an index.","     *","     * @method getKeyValueAt","     * @param {String} key value used to look up the correct array","     * @param {Number} index within the array","     * @return Number ","     */","    getKeyValueAt: function(key, index)","    {","        var value = NaN,","            keys = this.get(\"keys\");","        if(keys[key] && Y_Lang.isNumber(parseFloat(keys[key][index])))","        {","            value = keys[key][index];","        }","        return parseFloat(value);","    },","","    /**","     * Returns an array of values based on an identifier key.","     *","     * @method getDataByKey","     * @param {String} value value used to identify the array","     * @return Object","     */","    getDataByKey: function (value)","    {","        var keys = this.get(\"keys\");","        if(keys[value])","        {","            return keys[value];","        }","        return null;","    },","","    /**","     * Calculates the maximum and minimum values for the `Axis`.","     *","     * @method _updateMinAndMax","     * @private ","     */","    _updateMinAndMax: function() ","    {","        var data = this.get(\"data\"),","            max = 0,","            min = 0,","            len,","            num,","            i;","        if(data && data.length && data.length > 0)","        {","            len = data.length;","            max = min = data[0];","            if(len > 1)","            {","                for(i = 1; i < len; i++)","                {	","                    num = data[i];","                    if(isNaN(num))","                    {","                        continue;","                    }","                    max = Math.max(num, max);","                    min = Math.min(num, min);","                }","            }","        }","        this._dataMaximum = max;","        this._dataMinimum = min;","    },","","    /**","     * Returns the total number of majorUnits that will appear on an axis.","     *","     * @method getTotalMajorUnits","     * @return Number","     */","    getTotalMajorUnits: function()","    {","        var units,","            majorUnit = this.get(\"styles\").majorUnit,","            len = this.get(\"length\");","        if(majorUnit.determinant === \"count\") ","        {","            units = majorUnit.count;","        }","        else if(majorUnit.determinant === \"distance\") ","        {","            units = (len/majorUnit.distance) + 1;","        }","        return units; ","    },","","    /**","     * Returns the distance between major units on an axis.","     *","     * @method getMajorUnitDistance","     * @param {Number} len Number of ticks","     * @param {Number} uiLen Size of the axis.","     * @param {Object} majorUnit Hash of properties used to determine the majorUnit","     * @return Number","     */","    getMajorUnitDistance: function(len, uiLen, majorUnit)","    {","        var dist;","        if(majorUnit.determinant === \"count\")","        {","            dist = uiLen/(len - 1);","        }","        else if(majorUnit.determinant === \"distance\")","        {","            dist = majorUnit.distance;","        }","        return dist;","    },","    ","    /**","     * Gets the distance that the first and last ticks are offset from there respective","     * edges.","     *","     * @method getEdgeOffset","     * @param {Number} ct Number of ticks on the axis.","     * @param {Number} l Length (in pixels) of the axis.","     * @return Number","     */","    getEdgeOffset: function(ct, l)","    {","        return 0;","    },","","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     */","    getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            increm = (max - min)/(l-1),","            label;","            l -= 1;","        label = min + (i * increm);","        return label;","    },","","    /**","     * Updates the `Axis` after a change in keys.","     *","     * @method _keyChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _keyChangeHandler: function(e)","    {","        this._updateMinAndMax();","        this.fire(\"dataUpdate\");","    },","","    /**","     * Checks to see if data extends beyond the range of the axis. If so,","     * that data will need to be hidden. This method is internal, temporary and subject","     * to removal in the future.","     *","     * @method _hasDataOverflow","     * @protected","     * @return Boolean","     */","    _hasDataOverflow: function()","    {","        if(this.get(\"setMin\") || this.get(\"setMax\"))","        {","            return true;","        }","        return false;","    },","","    /**","     * Returns a string corresponding to the first label on an ","     * axis.","     *","     * @method getMinimumValue","     * @return String","     */","    getMinimumValue: function()","    {","        return this.get(\"minimum\");","    },","","    /**","     * Returns a string corresponding to the last label on an ","     * axis.","     *","     * @method getMaximumValue","     * @return String","     */","    getMaximumValue: function()","    {","        return this.get(\"maximum\");","    }","}, {","    ATTRS: {","        /**","         * Hash of array identifed by a string value.","         *","         * @attribute keys","         * @type Object","         */","        keys: {","            value: {},","","            setter: function(val)","            {","                var keys = {},","                    i, ","                    len,","                    data = this.get(\"dataProvider\");","                if(Y_Lang.isArray(val))","                {","                    len = val.length;","                    for(i = 0; i < len; ++i)","                    {","                        keys[val[i]] = this._getKeyArray(val[i], data);   ","                    }","                    ","                }","                else if(Y_Lang.isString(val))","                {","                    keys = this.get(\"keys\");","                    keys[val] = this._getKeyArray(val, data);","                }","                else","                {","                    for(i in val)","                    {","                        if(val.hasOwnProperty(i))","                        {","                            keys[i] = this._getKeyArray(i, data);","                        }","                    }","                }","	            this._updateTotalDataFlag = true;","                return keys;","            }","        },","","        /**","         *Indicates how to round unit values.","         *  <dl>","         *      <dt>niceNumber</dt><dd>Units will be smoothed based on the number of ticks and data range.</dd>","         *      <dt>auto</dt><dd>If the range is greater than 1, the units will be rounded.</dd>","         *      <dt>numeric value</dt><dd>Units will be equal to the numeric value.</dd>","         *      <dt>null</dt><dd>No rounding will occur.</dd>","         *  </dl>","         *","         * @attribute roundingMethod","         * @type String","         * @default niceNumber","         */","        roundingMethod: {","            value: \"niceNumber\"","        },","","        /**","         *Returns the type of axis data","         *  <dl>","         *      <dt>time</dt><dd>Manages time data</dd>","         *      <dt>stacked</dt><dd>Manages stacked numeric data</dd>      ","         *      <dt>numeric</dt><dd>Manages numeric data</dd>","         *      <dt>category</dt><dd>Manages categorical data</dd>","         *  </dl>","         *","         * @attribute type","         * @type String","         */","        type:","        {","            readOnly: true,","","            getter: function ()","            {","                return this._type;","            }","        },","","        /**","         * Instance of `ChartDataProvider` that the class uses","         * to build its own data.","         *","         * @attribute dataProvider","         * @type Array","         */","        dataProvider:{","            setter: function (value)","            {","                return value;","            }","        },","","        /**","         * The maximum value contained in the `data` array. Used for","         * `maximum` when `autoMax` is true.","         *","         * @attribute dataMaximum","         * @type Number","         */","        dataMaximum: {","            getter: function ()","            {","                if(!this._dataMaximum)","                {   ","                    this._updateMinAndMax();","                }","                return this._dataMaximum;","            }","        },","","        /**","         * The maximum value that will appear on an axis.","         *","         * @attribute maximum","         * @type Number","         */","        maximum: {","            lazyAdd: false,","","            getter: function ()","            {","                var max = this.get(\"dataMaximum\"),","                    min = this.get(\"minimum\");","                //If all values are zero, force a range so that the Axis and related series","                //will still render.","                if(min === 0 && max === 0)","                {","                    max = 10;","                }","                if(Y_Lang.isNumber(this._setMaximum))","                {","                    max = this._setMaximum;","                }","                return parseFloat(max);","            },","            setter: function (value)","            {","                this._setMaximum = parseFloat(value);","                return value;","            }","        },","","        /**","         * The minimum value contained in the `data` array. Used for","         * `minimum` when `autoMin` is true.","         *","         * @attribute dataMinimum","         * @type Number","         */","        dataMinimum: {","            getter: function ()","            {","                if(!this._dataMinimum)","                {","                    this._updateMinAndMax();","                }","                return this._dataMinimum;","            }","        },","","        /**","         * The minimum value that will appear on an axis.","         *","         * @attribute minimum","         * @type Number","         */","        minimum: {","            lazyAdd: false,","","            getter: function ()","            {","                var min = this.get(\"dataMinimum\");","                if(Y_Lang.isNumber(this._setMinimum))","                {","                    min = this._setMinimum;","                }","                return parseFloat(min);","            },","            setter: function(val)","            {","                this._setMinimum = parseFloat(val);","                return val;","            }","        },","","        /**","         * Determines whether the maximum is calculated or explicitly ","         * set by the user.","         *","         * @attribute setMax","         * @type Boolean","         */","        setMax: {","            readOnly: true,","","            getter: function()","            {","                return Y_Lang.isNumber(this._setMaximum);","            }","        },","","        /**","         * Determines whether the minimum is calculated or explicitly","         * set by the user.","         *","         * @attribute setMin","         * @type Boolean","         */","        setMin: {","            readOnly: true,","","            getter: function()","            {","                return Y_Lang.isNumber(this._setMinimum);","            }","        },","","        /**","         * Array of axis data","         *","         * @attribute data","         * @type Array","         */","        data: {","            getter: function ()","            {","                if(!this._data || this._updateTotalDataFlag)","                {","                    this._updateTotalData();","                }","                return this._data;","            }","        },","","        /**","         * Array containing all the keys in the axis.","        ","         * @attribute keyCollection","         * @type Array","         */","        keyCollection: {","            getter: function()","            {","                var keys = this.get(\"keys\"),","                    i, ","                    col = [];","                for(i in keys)","                {","                    if(keys.hasOwnProperty(i))","                    {","                        col.push(i);","                    }","                }","                return col;","            },","            readOnly: true","        }","    }","});","/**"," * NumericAxis manages numeric data on an axis."," *"," * @module charts"," * @submodule charts-base"," * @class NumericAxis"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," * @extends AxisType"," */","function NumericAxis(config)","{","	NumericAxis.superclass.constructor.apply(this, arguments);","}","","NumericAxis.NAME = \"numericAxis\";","","NumericAxis.ATTRS = {","    /**","     * Indicates whether 0 should always be displayed.","     *","     * @attribute alwaysShowZero","     * @type Boolean","     */","	alwaysShowZero: {","	    value: true	","	},","    ","    /**","     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need","     * to implement the arguments below and return a `String` or an `HTMLElement`. The default implementation of the method returns a `String`. The output of this method","     * will be rendered to the DOM using `appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override the Axis' ","     * `appendLabelFunction` to accept html as a `String`.","     * <dl>","     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>","     *      <dt>format</dt><dd>Object containing properties used to format the label. (optional)</dd>","     * </dl>","     *","     * @attribute labelFunction","     * @type Function","     */","    labelFunction: { ","        value: function(val, format)","        {","            if(format)","            {","                return Y.DataType.Number.format(val, format);","            }","            return val;","        }","    },","","    /**","     * Object containing properties used by the `labelFunction` to format a","     * label.","     *","     * @attribute labelFormat","     * @type Object","     */","    labelFormat: {","        value: {","            prefix: \"\",","            thousandsSeparator: \"\",","            decimalSeparator: \"\",","            decimalPlaces: \"0\",","            suffix: \"\"","        }","    }","};","","Y.extend(NumericAxis, Y.AxisType,","{","    /**","     * Formats a label based on the axis type and optionally specified format.","     *","     * @method formatLabel","     * @param {Object} value","     * @param {Object} format Pattern used to format the value.","     * @return String","     */","    formatLabel: function(val, format)","    {","        if(format)","        {","            return Y.DataType.Number.format(val, format);","        }","        return val;","    },","","    /**","     * Returns the sum of all values per key.","     *","     * @method getTotalByKey","     * @param {String} key The identifier for the array whose values will be calculated.","     * @return Number","     */","    getTotalByKey: function(key)","    {","        var total = 0,","            values = this.getDataByKey(key),","            i = 0,","            val,","            len = values ? values.length : 0;","        for(; i < len; ++i)","        {","           val = parseFloat(values[i]);","           if(!isNaN(val))","           {","                total += val;","           }","        }","        return total;","    },","","    /**","     * Type of data used in `Axis`.","     *","     * @property _type","     * @readOnly","     * @private","     */","    _type: \"numeric\",","","    /**","     * Helper method for getting a `roundingUnit` when calculating the minimum and maximum values.","     *","     * @method _getMinimumUnit","     * @param {Number} max Maximum number","     * @param {Number} min Minimum number","     * @param {Number} units Number of units on the axis","     * @return Number","     * @private","     */","    _getMinimumUnit:function(max, min, units)","    {","        return this._getNiceNumber(Math.ceil((max - min)/units));","    },","","    /**","     * Calculates a nice rounding unit based on the range.","     *","     * @method _getNiceNumber","     * @param {Number} roundingUnit The calculated rounding unit.","     * @return Number","     * @private","     */","    _getNiceNumber: function(roundingUnit)","    {","        var tempMajorUnit = roundingUnit,","            order = Math.ceil(Math.log(tempMajorUnit) * 0.4342944819032518),","            roundedMajorUnit = Math.pow(10, order),","            roundedDiff;","","        if (roundedMajorUnit / 2 >= tempMajorUnit) ","        {","            roundedDiff = Math.floor((roundedMajorUnit / 2 - tempMajorUnit) / (Math.pow(10,order-1)/2));","            tempMajorUnit = roundedMajorUnit/2 - roundedDiff*Math.pow(10,order-1)/2;","        }","        else ","        {","            tempMajorUnit = roundedMajorUnit;","        }","        if(!isNaN(tempMajorUnit))","        {","            return tempMajorUnit;","        }","        return roundingUnit;","","    },","","    /**","     * Calculates the maximum and minimum values for the `Axis`.","     *","     * @method _updateMinAndMax","     * @private ","     */","    _updateMinAndMax: function()","    {","        var data = this.get(\"data\"),","            max, ","            min,","            len,","            num,","            i = 0,","            key,","            setMax = this.get(\"setMax\"),","            setMin = this.get(\"setMin\");","        if(!setMax || !setMin)","        {","            if(data && data.length && data.length > 0)","            {","                len = data.length;","                for(; i < len; i++)","                {	","                    num = data[i];","                    if(isNaN(num))","                    {","                        if(Y_Lang.isObject(num))","                        {","                            min = max = 0;","                            //hloc values","                            for(key in num)","                            {","                               if(num.hasOwnProperty(key))","                               {","                                    max = Math.max(num[key], max);","                                    min = Math.min(num[key], min);","                               }","                            }","                        }","                        max = setMax ? this._setMaximum : max;","                        min = setMin ? this._setMinimum : min;","                        continue;","                    }","                    ","                    if(setMin)","                    {","                        min = this._setMinimum;","                    }","                    else if(min === undefined)","                    {","                        min = num;","                    }","                    else","                    {","                        min = Math.min(num, min); ","                    }","                    if(setMax)","                    {","                        max = this._setMaximum;","                    }","                    else if(max === undefined)","                    {","                        max = num;","                    }","                    else","                    {","                        max = Math.max(num, max);","                    }","                    ","                    this._actualMaximum = max;","                    this._actualMinimum = min;","                }","            }","            this._roundMinAndMax(min, max, setMin, setMax);","        }","    },","","    /**","     * Rounds the mimimum and maximum values based on the `roundingUnit` attribute.","     *","     * @method _roundMinAndMax","     * @param {Number} min Minimum value","     * @param {Number} max Maximum value","     * @private","     */","    _roundMinAndMax: function(min, max, setMin, setMax)","    {","        var roundingUnit,","            minimumRange,","            minGreaterThanZero = min >= 0,","            maxGreaterThanZero = max > 0,","            dataRangeGreater,","            maxRound,","            minRound,","            topTicks,","            botTicks,","            tempMax,","            tempMin,","            units = this.getTotalMajorUnits() - 1,","            alwaysShowZero = this.get(\"alwaysShowZero\"),","            roundingMethod = this.get(\"roundingMethod\"),","            useIntegers = (max - min)/units >= 1;","        if(roundingMethod)","        {","            if(roundingMethod == \"niceNumber\")","            {","                roundingUnit = this._getMinimumUnit(max, min, units);","                if(minGreaterThanZero && maxGreaterThanZero)","                {","                    if((alwaysShowZero || min < roundingUnit) && !setMin)","                    {","                        min = 0;","                        roundingUnit = this._getMinimumUnit(max, min, units);","                    }","                    else","                    {","                       min = this._roundDownToNearest(min, roundingUnit);","                    }","                    if(setMax)","                    {","                        if(!alwaysShowZero)","                        {","                            min = max - (roundingUnit * units);","                        }","                    }","                    else if(setMin)","                    {","                        max = min + (roundingUnit * units);","                    }","                    else","                    {","                        max = this._roundUpToNearest(max, roundingUnit);","                    }","                }","                else if(maxGreaterThanZero && !minGreaterThanZero)","                {","                    if(alwaysShowZero)","                    {","                        topTicks = Math.round(units/((-1 * min)/max + 1));","                        topTicks = Math.max(Math.min(topTicks, units - 1), 1);","                        botTicks = units - topTicks;","                        tempMax = Math.ceil( max/topTicks );","                        tempMin = Math.floor( min/botTicks ) * -1;","                        ","                        if(setMin)","                        {","                            while(tempMin < tempMax && botTicks >= 0)","                            {","                                botTicks--;","                                topTicks++;","                                tempMax = Math.ceil( max/topTicks );","                                tempMin = Math.floor( min/botTicks ) * -1;","                            }","                            //if there are any bottom ticks left calcualate the maximum by multiplying by the tempMin value","                            //if not, it's impossible to ensure that a zero is shown. skip it","                            if(botTicks > 0)","                            {","                                max = tempMin * topTicks;","                            }","                            else","                            {","                                max = min + (roundingUnit * units);","                            }","                        }","                        else if(setMax)","                        {","                            while(tempMax < tempMin && topTicks >= 0)","                            {","                                botTicks++;","                                topTicks--;","                                tempMin = Math.floor( min/botTicks ) * -1;","                                tempMax = Math.ceil( max/topTicks );","                            }","                            //if there are any top ticks left calcualate the minimum by multiplying by the tempMax value","                            //if not, it's impossible to ensure that a zero is shown. skip it","                            if(topTicks > 0)","                            {","                                min = tempMax * botTicks * -1;","                            }","                            else","                            {","                                min = max - (roundingUnit * units);","                            }","                        }","                        else","                        {","                            roundingUnit = Math.max(tempMax, tempMin);","                            roundingUnit = this._getNiceNumber(roundingUnit);  ","                            max = roundingUnit * topTicks;","                            min = roundingUnit * botTicks * -1;","                        }","                    }","                    else ","                    {","                        if(setMax)","                        {","                            min = max - (roundingUnit * units);","                        }","                        else if(setMin)","                        {","                            max = min + (roundingUnit * units);","                        }","                        else","                        {","                            min = this._roundDownToNearest(min, roundingUnit);","                            max = this._roundUpToNearest(max, roundingUnit);","                        }","                    }","                }","                else","                {","                    if(setMin)","                    {","                        if(alwaysShowZero)","                        {","                            max = 0;","                        }","                        else","                        {","                            max = min + (roundingUnit * units);","                        }","                    }","                    else if(!setMax)","                    {","                        if(alwaysShowZero || max === 0 || max + roundingUnit > 0)","                        {","                            max = 0;","                            roundingUnit = this._getMinimumUnit(max, min, units);","                            min = max - (roundingUnit * units);","                        }","                        else","                        {","                            min = this._roundDownToNearest(min, roundingUnit);","                            max = this._roundUpToNearest(max, roundingUnit);","                        }","                    }","                    else","                    {","                        min = max - (roundingUnit * units);","                    }","                }","            }","            else if(roundingMethod == \"auto\") ","            {","                if(minGreaterThanZero && maxGreaterThanZero)","                {","                    if((alwaysShowZero || min < (max-min)/units) && !setMin)","                    {","                        min = 0;","                    }","                ","                    roundingUnit = (max - min)/units;","                    if(useIntegers)","                    {","                        roundingUnit = Math.ceil(roundingUnit);","                    }","                    max = min + (roundingUnit * units);","                }","                else if(maxGreaterThanZero && !minGreaterThanZero)","                {","                    if(alwaysShowZero)","                    {","                        topTicks = Math.round( units / ( (-1 * min) /max + 1) );","                        topTicks = Math.max(Math.min(topTicks, units - 1), 1);","                        botTicks = units - topTicks;","","                        if(useIntegers)","                        {","                            tempMax = Math.ceil( max/topTicks );","                            tempMin = Math.floor( min/botTicks ) * -1;","                        }","                        else","                        {","                            tempMax = max/topTicks;","                            tempMin = min/botTicks * -1;","                        }","                        roundingUnit = Math.max(tempMax, tempMin);","                        max = roundingUnit * topTicks;","                        min = roundingUnit * botTicks * -1;","                    }","                    else","                    {","                        roundingUnit = (max - min)/units;","                        if(useIntegers)","                        {","                            roundingUnit = Math.ceil(roundingUnit);","                        }","                        min = this._roundDownToNearest(min, roundingUnit);","                        max = this._roundUpToNearest(max, roundingUnit);","                    }","                }","                else","                {","                    roundingUnit = (max - min)/units;","                    if(useIntegers)","                    {   ","                        roundingUnit = Math.ceil(roundingUnit);","                    }","                    if(alwaysShowZero || max === 0 || max + roundingUnit > 0)","                    {","                        max = 0;","                        roundingUnit = (max - min)/units;","                        if(useIntegers)","                        {","                            Math.ceil(roundingUnit);","                        }","                        min = max - (roundingUnit * units);","                    }","                    else","                    {","                        min = this._roundDownToNearest(min, roundingUnit);","                        max = this._roundUpToNearest(max, roundingUnit);","                    }","","                }","            }","            else if(!isNaN(roundingMethod) && isFinite(roundingMethod))","            {","                roundingUnit = roundingMethod;","                minimumRange = roundingUnit * units;","                dataRangeGreater = (max - min) > minimumRange;","                minRound = this._roundDownToNearest(min, roundingUnit);","                maxRound = this._roundUpToNearest(max, roundingUnit);","                if(setMax)","                {","                    min = max - minimumRange;","                }","                else if(setMin)","                {","                    max = min + minimumRange;","                }","                else if(minGreaterThanZero && maxGreaterThanZero)","                {","                    if(alwaysShowZero || minRound <= 0)","                    {","                        min = 0;","                    }","                    else","                    {","                        min = minRound;","                    }","                    max = min + minimumRange;","                }","                else if(maxGreaterThanZero && !minGreaterThanZero)","                {","                    min = minRound;","                    max = maxRound;","                }","                else","                {","                    if(alwaysShowZero || maxRound >= 0)","                    {","                        max = 0;","                    }","                    else","                    {","                        max = maxRound;","                    }","                    min = max - minimumRange;","                }","            }","        }","        this._dataMaximum = max;","        this._dataMinimum = min;","    },","","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     */","    getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            increm = (max - min)/(l-1),","            label,","            roundingMethod = this.get(\"roundingMethod\");","            l -= 1;","        //respect the min and max. calculate all other labels.","        if(i === 0)","        {","            label = min;","        }","        else if(i === l)","        {","            label = max;","        }","        else","        {","            label = (i * increm);","            if(roundingMethod == \"niceNumber\")","            {","                label = this._roundToNearest(label, increm);","            }","            label += min;","        }","        return parseFloat(label);","    },","","    /**","     * Rounds a Number to the nearest multiple of an input. For example, by rounding","     * 16 to the nearest 10, you will receive 20. Similar to the built-in function Math.round().","     *","     * @method _roundToNearest","     * @param {Number} number Number to round","     * @param {Number} nearest Multiple to round towards.","     * @return Number","     * @private","     */","    _roundToNearest: function(number, nearest)","    {","        nearest = nearest || 1;","        if(nearest === 0)","        {","            return number;","        }","        var roundedNumber = Math.round(this._roundToPrecision(number / nearest, 10)) * nearest;","        return this._roundToPrecision(roundedNumber, 10);","    },","	","    /**","     * Rounds a Number up to the nearest multiple of an input. For example, by rounding","     * 16 up to the nearest 10, you will receive 20. Similar to the built-in function Math.ceil().","     *","     * @method _roundUpToNearest","     * @param {Number} number Number to round","     * @param {Number} nearest Multiple to round towards.","     * @return Number","     * @private","     */","    _roundUpToNearest: function(number, nearest)","    {","        nearest = nearest || 1;","        if(nearest === 0)","        {","            return number;","        }","        return Math.ceil(this._roundToPrecision(number / nearest, 10)) * nearest;","    },","	","    /**","     * Rounds a Number down to the nearest multiple of an input. For example, by rounding","     * 16 down to the nearest 10, you will receive 10. Similar to the built-in function Math.floor().","     *","     * @method _roundDownToNearest","     * @param {Number} number Number to round","     * @param {Number} nearest Multiple to round towards.","     * @return Number","     * @private","     */","    _roundDownToNearest: function(number, nearest)","    {","        nearest = nearest || 1;","        if(nearest === 0)","        {","            return number;","        }","        return Math.floor(this._roundToPrecision(number / nearest, 10)) * nearest;","    },","","    /**","     * Rounds a number to a certain level of precision. Useful for limiting the number of","     * decimal places on a fractional number.","     *","     * @method _roundToPrecision","     * @param {Number} number Number to round","     * @param {Number} precision Multiple to round towards.","     * @return Number","     * @private","     */","    _roundToPrecision: function(number, precision)","    {","        precision = precision || 0;","        var decimalPlaces = Math.pow(10, precision);","        return Math.round(decimalPlaces * number) / decimalPlaces;","    },","    ","    /**","     * Checks to see if data extends beyond the range of the axis. If so,","     * that data will need to be hidden. This method is internal, temporary and subject","     * to removal in the future.","     *","     * @method _hasDataOverflow","     * @protected","     * @return Boolean","     */","    _hasDataOverflow: function()","    {","        var roundingMethod,","            min,","            max;","        if(this.get(\"setMin\") || this.get(\"setMax\"))","        {","            return true;","        }","        roundingMethod = this.get(\"roundingMethod\");","        min = this._actualMinimum;","        max = this._actualMaximum;","        if(Y_Lang.isNumber(roundingMethod) && ((Y_Lang.isNumber(max) && max > this._dataMaximum) || (Y_Lang.isNumber(min) && min < this._dataMinimum)))","        {","            return true;","        }","        return false;","    }","});","","Y.NumericAxis = NumericAxis;","		","/**"," * StackedAxis manages stacked numeric data on an axis."," *"," * @module charts"," * @submodule charts-base"," * @class StackedAxis"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," * @extends NumericAxis"," */","function StackedAxis(config)","{","	StackedAxis.superclass.constructor.apply(this, arguments);","}","","StackedAxis.NAME = \"stackedAxis\";","","","Y.extend(StackedAxis, Y.NumericAxis,","{","    /**","     * Calculates the maximum and minimum values for the `Axis`.","     *","     * @method _updateMinAndMax","     * @private ","     */","    _updateMinAndMax: function()","    {","        var max = 0,","            min = 0,","            pos = 0,","            neg = 0,","            len = 0,","            i = 0,","            key,","            num,","            keys = this.get(\"keys\"),","            setMin = this.get(\"setMin\"),","            setMax = this.get(\"setMax\");","","        for(key in keys)","        {","            if(keys.hasOwnProperty(key))","            {","                len = Math.max(len, keys[key].length);","            }","        }","        for(; i < len; ++i)","        {","            pos = 0;","            neg = 0;","            for(key in keys)","            {","                if(keys.hasOwnProperty(key))","                {","                    num = keys[key][i];","                    if(isNaN(num))","                    {","                        continue;","                    }","                    if(num >= 0)","                    {","                        pos += num;","                    }","                    else","                    {","                        neg += num;","                    }","                }","            }","            if(pos > 0)","            {","                max = Math.max(max, pos);","            }","            else ","            {","                max = Math.max(max, neg);","            }","            if(neg < 0)","            {","                min = Math.min(min, neg);","            }","            else","            {","                min = Math.min(min, pos);","            }","        }","        this._actualMaximum = max;","        this._actualMinimum = min;","        if(setMax)","        {","            max = this._setMaximum;","        }","        if(setMin)","        {","            min = this._setMinimum;","        }","        this._roundMinAndMax(min, max, setMin, setMax);","    }","});","","Y.StackedAxis = StackedAxis;","		","/**"," * TimeAxis manages time data on an axis."," *"," * @module charts"," * @submodule charts-base"," * @class TimeAxis"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," * @extends AxisType"," */","function TimeAxis(config)","{","	TimeAxis.superclass.constructor.apply(this, arguments);","}","","TimeAxis.NAME = \"timeAxis\";","","TimeAxis.ATTRS = ","{","    /**","     * Indicates whether the maximum is calculated or explicitly set. ","     *","     * @attribute setMax","     * @readOnly","     * @type Boolean","     * @private","     */","    setMax: {","        readOnly: true,","","        getter: function()","        {","            var max = this._getNumber(this._setMaximum);","            return (Y_Lang.isNumber(max));","        }","    },","","    /**","     * Indicates whether the minimum is calculated or explicitly set. ","     *","     * @attribute setMin","     * @readOnly","     * @type Boolean","     * @private","     */","    setMin: {","        readOnly: true,","","        getter: function()","        {","            var min = this._getNumber(this._setMinimum);","            return (Y_Lang.isNumber(min));","        }","    },","","    /**","     * The maximum value that will appear on an axis. Unless explicitly set, this value is calculated by the `Axis`.","     *","     * @attribute maximum","     * @type Number","     */","    maximum: {","        getter: function ()","        {","            var max = this._getNumber(this._setMaximum);","            if(!Y_Lang.isNumber(max))","            {","                max = this._getNumber(this.get(\"dataMaximum\"));","            }","            return parseFloat(max);","        },","        setter: function (value)","        {","            this._setMaximum = this._getNumber(value);","            return value;","        }","    },","","    /**","     * The minimum value that will appear on an axis. Unless explicitly set, this value is calculated by the `Axis`.","     *","     * @attribute minimum","     * @type Number","     */","    minimum: {","        getter: function ()","        {","            var min = this._getNumber(this._setMinimum);","            if(!Y_Lang.isNumber(min)) ","            {","                min = this._getNumber(this.get(\"dataMinimum\"));","            }","            return parseFloat(min);","        },","        setter: function (value)","        {","            this._setMinimum = this._getNumber(value);","            return value;","        }","    },","","    /**","     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need","     * to implement the arguments below and return a `String` or an `HTMLElement`. The default implementation of the method returns a `String`. The output of this method","     * will be rendered to the DOM using `appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override the Axis' ","     * `appendLabelFunction` to accept html as a `String`.","     * <dl>","     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>","     *      <dt>format</dt><dd>STRFTime string used to format the label. (optional)</dd>","     * </dl>","     *","     * @attribute labelFunction","     * @type Function","     */","    labelFunction: {","        value: function(val, format)","        {","            val = Y.DataType.Date.parse(val);","            if(format)","            {","                return Y.DataType.Date.format(val, {format:format});","            }","            return val;","        }","    },","","    /**","     * Pattern used by the `labelFunction` to format a label.","     *","     * @attribute labelFormat","     * @type String","     */","    labelFormat: {","        value: \"%b %d, %y\"","    }","};","","Y.extend(TimeAxis, Y.AxisType, {","    /**","     * Formats a label based on the axis type and optionally specified format.","     *","     * @method formatLabel","     * @param {Object} value","     * @param {Object} format Pattern used to format the value.","     * @return String","     */","    formatLabel: function(val, format)","    {","        val = Y.DataType.Date.parse(val);","        if(format)","        {","            return Y.DataType.Date.format(val, {format:format});","        }","        return val;","    },","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuitimeaxis\",","	","    /**","     * Type of data used in `Axis`.","     *","     * @property _dataType","     * @readOnly","     * @private","     */","    _dataType: \"time\",","	","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     */","    getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            position = this.get(\"position\"),","            increm,","            label;","            l -= 1;","        increm = ((max - min)/l) * i;","        if(position == \"bottom\" || position == \"top\")","        {","            label = min + increm;","        }","        else","        {","            label = max - increm;","        }","        return label;","    },","","    /**","     * Gets an array of values based on a key.","     *","     * @method _getKeyArray","     * @param {String} key Value key associated with the data array.","     * @param {Array} data Array in which the data resides.","     * @return Array","     * @private","     */","    _getKeyArray: function(key, data)","    {","        var obj,","            keyArray = [],","            i = 0,","            val,","            len = data.length;","        for(; i < len; ++i)","        {","            obj = data[i][key];","            if(Y_Lang.isDate(obj))","            {   ","                val = obj.valueOf();","            }","            else","            {","                val = new Date(obj);","                if(Y_Lang.isDate(val))","                {","                    val = val.valueOf();","                }","                else if(!Y_Lang.isNumber(obj))","                {","                    if(Y_Lang.isNumber(parseFloat(obj)))","                    {","                        val = parseFloat(obj);","                    }","                    else","                    {","                        if(typeof obj != \"string\")","                        {","                            obj = obj;","                        }","                        val = new Date(obj).valueOf();","                    }","                }","                else","                {","                    val = obj;","                }","            }","            keyArray[i] = val;","        }","        return keyArray;","    },","","    /**","     * Sets data by key","     *","     * @method _setDataByKey","     * @param {String} key Key value to use.","     * @param {Array} data Array to use.","     * @private ","     */","    _setDataByKey: function(key, data)","    {","        var obj, ","            arr = [], ","            dv = this._dataClone.concat(), ","            i, ","            val,","            len = dv.length;","        for(i = 0; i < len; ++i)","        {","            obj = dv[i][key];","            if(Y_Lang.isDate(obj))","            {   ","                val = obj.valueOf();","            }","            else","            {","                val = new Date(obj);","                if(Y_Lang.isDate(val))","                {","                    val = val.valueOf();","                }","                else if(!Y_Lang.isNumber(obj))","                {","                    if(Y_Lang.isNumber(parseFloat(obj)))","                    {","                        val = parseFloat(obj);","                    }","                    else","                    {","                        if(typeof obj != \"string\")","                        {","                            obj = obj.toString();","                        }","                        val = new Date(obj).valueOf();","                    }","                }","                else","                {","                    val = obj;","                }","            }","            arr[i] = val;","        }","        this.get(\"keys\")[key] = arr;","        this._updateTotalDataFlag = true;","    },","","    /**","     * Parses value into a number.","     *","     * @method _getNumber","     * @param val {Object} Value to parse into a number","     * @return Number","     * @private","     */","    _getNumber: function(val)","    {","        if(Y_Lang.isDate(val))","        {","            val = val.valueOf();","        }","        else if(!Y_Lang.isNumber(val) && val)","        {","            val = new Date(val).valueOf();","        }","","        return val;","    }","});","","Y.TimeAxis = TimeAxis;","		","/**"," * CategoryAxis manages category data on an axis."," *"," * @module charts"," * @submodule charts-base"," * @class CategoryAxis"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," * @extends AxisType"," */","function CategoryAxis(config)","{","	CategoryAxis.superclass.constructor.apply(this, arguments);","}","","CategoryAxis.NAME = \"categoryAxis\";","","Y.extend(CategoryAxis, Y.AxisType,","{","    /**","     * Formats a label based on the axis type and optionally specified format.","     *","     * @method formatLabel","     * @param {Object} value","     * @param {Object} format Pattern used to format the value.","     * @return String","     */","    formatLabel: function(val, format)","    {","        return val;","    },","","    /**","     * Object storing key data.","     *","     * @property _indices","     * @private","     */","    _indices: null,","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuicategoryaxis\",","","    /**","     * Type of data used in `Axis`.","     *","     * @property _dataType","     * @readOnly","     * @private","     */","    _type: \"category\",","        ","    /**","     * Calculates the maximum and minimum values for the `Axis`.","     *","     * @method _updateMinAndMax","     * @private ","     */","    _updateMinAndMax: function()","    {","        this._dataMaximum = Math.max(this.get(\"data\").length - 1, 0);","        this._dataMinimum = 0;","    },","","    /**","     * Gets an array of values based on a key.","     *","     * @method _getKeyArray","     * @param {String} key Value key associated with the data array.","     * @param {Array} data Array in which the data resides.","     * @return Array","     * @private","     */","    _getKeyArray: function(key, data)","    {","        var i = 0,","            obj,","            keyArr = [],","            labels = [],","            len = data.length;","        if(!this._indices)","        {","            this._indices = {};","        }","        for(; i < len; ++i)","        {","            obj = data[i];","            keyArr[i] = i;","            labels[i] = obj[key];","        }","        this._indices[key] = keyArr;","        return labels;","    },","","    /**","     * Sets data by key","     *","     * @method _setDataByKey","     * @param {String} key Key value to use.","     * @param {Array} data Array to use.","     * @private ","     */","    _setDataByKey: function(key)","    {","        var i,","            obj, ","            arr = [], ","            labels = [], ","            dv = this._dataClone.concat(), ","            len = dv.length;","        if(!this._indices)","        {","            this._indices = {};","        }","        for(i = 0; i < len; ++i)","        {","            obj = dv[i];","            arr[i] = i;","            labels[i] = obj[key];","        }","        this._indices[key] = arr;","        this.get(\"keys\")[key] = labels.concat();","        this._updateTotalDataFlag = true;","    },","","    /**","     * Returns an array of values based on an identifier key.","     *","     * @method getDataByKey","     * @param {String} value value used to identify the array","     * @return Array","     */","    getDataByKey: function (value)","    {","        if(!this._indices)","        {","            this.get(\"keys\");","        }","        var keys = this._indices;","        if(keys[value])","        {","            return keys[value];","        }","        return null;","    },","","    /**","     * Returns the total number of majorUnits that will appear on an axis.","     *","     * @method getTotalMajorUnits","     * @param {Object} majorUnit Object containing properties related to the majorUnit.","     * @param {Number} len Length of the axis.","     * @return Number","     */","    getTotalMajorUnits: function(majorUnit, len)","    {","        return this.get(\"data\").length;","    },","    ","    /**","     * Returns the distance between major units on an axis.","     *","     * @method getMajorUnitDistance","     * @param {Number} len Number of ticks","     * @param {Number} uiLen Size of the axis.","     * @param {Object} majorUnit Hash of properties used to determine the majorUnit","     * @return Number","     */","    getMajorUnitDistance: function(len, uiLen, majorUnit)","    {","        var dist;","        if(majorUnit.determinant === \"count\")","        {","            dist = uiLen/len;","        }","        else if(majorUnit.determinant === \"distance\")","        {","            dist = majorUnit.distance;","        }","        return dist;","    },","   ","    /**","     * Gets the distance that the first and last ticks are offset from there respective","     * edges.","     *","     * @method getEdgeOffset","     * @param {Number} ct Number of ticks on the axis.","     * @param {Number} l Length (in pixels) of the axis.","     * @return Number","     */","    getEdgeOffset: function(ct, l)","    {","        return l/ct;","    },","","    /**","     * Returns a value based of a key value and an index.","     *","     * @method getKeyValueAt","     * @param {String} key value used to look up the correct array","     * @param {Number} index within the array","     * @return String ","     */","    getKeyValueAt: function(key, index)","    {","        var value = NaN,","            keys = this.get(\"keys\");","        if(keys[key] && keys[key][index]) ","        {","            value = keys[key][index];","        }","        return value;","    },","   ","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     */","    getLabelByIndex: function(i, l)","    {","        var label,","            data = this.get(\"data\"),","            position = this.get(\"position\");","        if(position == \"bottom\" || position == \"top\")","        {","            label = data[i];","        }","        else","        {","            label = data[l - (i + 1)];","        }   ","        return label;","    },","","    /**","     * Returns a string corresponding to the first label on an ","     * axis.","     *","     * @method getMinimumValue","     * @return String","     */","    getMinimumValue: function()","    {","        var data = this.get(\"data\"),","            label = data[0];","        return label;","    },","","    /**","     * Returns a string corresponding to the last label on an ","     * axis.","     *","     * @method getMaximumValue","     * @return String","     */","    getMaximumValue: function()","    {","        var data = this.get(\"data\"),","            len = data.length - 1,","            label = data[len];","        return label;","    }","});","","Y.CategoryAxis = CategoryAxis;","		","/**"," * Utility class used for calculating curve points."," *"," * @module charts"," * @submodule charts-base"," * @class CurveUtil"," * @constructor"," */","function CurveUtil()","{","}","","CurveUtil.prototype = {","    /**","     * Creates an array of start, end and control points for splines.","     *","     * @method getCurveControlPoints","     * @param {Array} xcoords Collection of x-coordinates used for calculate the curves","     * @param {Array} ycoords Collection of y-coordinates used for calculate the curves","     * @return Object","     * @protected","     */","    getCurveControlPoints: function(xcoords, ycoords) ","    {","		var outpoints = [],","            i = 1,","            l = xcoords.length - 1,","		    xvals = [],","		    yvals = [];","		","		","		// Too few points, need at least two","		if (l < 1) ","        {","			return null;","		} ","        ","        outpoints[0] = {","            startx: xcoords[0], ","            starty: ycoords[0],","            endx: xcoords[1],","            endy: ycoords[1]","        };","        ","		// Special case, the Bezier should be a straight line","        if (l === 1) ","        {","			outpoints[0].ctrlx1 = (2.0*xcoords[0] + xcoords[1])/3.0;  ","			outpoints[0].ctrly2 = (2.0*ycoords[0] + ycoords[1])/3.0;","			outpoints[0].ctrlx2 = 2.0*outpoints[0].ctrlx1 - xcoords[0];","            outpoints[0].ctrly2 = 2.0*outpoints[0].ctrly1 - ycoords[0];","            return outpoints;","		}","","		for (; i < l; ++i) ","        {","			outpoints.push({startx: Math.round(xcoords[i]), starty: Math.round(ycoords[i]), endx: Math.round(xcoords[i+1]), endy: Math.round(ycoords[i+1])});","			xvals[i] = 4.0 * xcoords[i] + 2*xcoords[i+1];","			yvals[i] = 4.0*ycoords[i] + 2*ycoords[i+1];","		}","		","		xvals[0] = xcoords[0] + (2.0 * xcoords[1]);","		xvals[l-1] = (8.0 * xcoords[l-1] + xcoords[l]) / 2.0;","		xvals = this.getControlPoints(xvals.concat());","        yvals[0] = ycoords[0] + (2.0 * ycoords[1]);","		yvals[l-1] = (8.0 * ycoords[l-1] + ycoords[l]) / 2.0;	","		yvals = this.getControlPoints(yvals.concat());","		","        for (i = 0; i < l; ++i) ","        {","			outpoints[i].ctrlx1 = Math.round(xvals[i]);","            outpoints[i].ctrly1 = Math.round(yvals[i]);","			","			if (i < l-1) ","            {","				outpoints[i].ctrlx2 = Math.round(2*xcoords[i+1] - xvals[i+1]);","                outpoints[i].ctrly2 = Math.round(2*ycoords[i+1] - yvals[i+1]);","			}","			else ","            {","				outpoints[i].ctrlx2 = Math.round((xcoords[l] + xvals[l-1])/2);","                outpoints[i].ctrly2 = Math.round((ycoords[l] + yvals[l-1])/2);","			}","		}","		","		return outpoints;	","	},","","    /**","     * Gets the control points for the curve.","     *","     * @method getControlPoints","     * @param {Array} vals Collection of values coords used to generate control points.","     * @return Array","     * @private","     */","	getControlPoints: function(vals) ","    {","		var l = vals.length,","            x = [],","            tmp = [],","            b = 2.0,","            i = 1;","		x[0] = vals[0] / b;","		for (; i < l; ++i) ","        {","			tmp[i] = 1/b;","			b = (i < l-1 ? 4.0 : 3.5) - tmp[i];","			x[i] = (vals[i] - x[i-1]) / b;","		}","		","		for (i = 1; i < l; ++i) ","        {","			x[l-i-1] -= tmp[l-i] * x[l-i];","		}","		","		return x;","	}","};","Y.CurveUtil = CurveUtil;","/**"," * Utility class used for creating stacked series."," *"," * @module charts"," * @submodule charts-base"," * @class StackingUtil"," * @constructor"," */","function StackingUtil(){}","","StackingUtil.prototype = {","    /**","     * Indicates whether the series is stacked.","     *","     * @property _stacked","     * @private","     */","    _stacked: true,","","    /**","     * @protected","     *","     * Adjusts coordinate values for stacked series.","     *","     * @method _stackCoordinates","     */","    _stackCoordinates: function() ","    {","        if(this.get(\"direction\") == \"vertical\")","        {","            this._stackXCoords();","        }","        else","        {","            this._stackYCoords();","        }","    },","","    /**","     * Stacks coordinates for a stacked vertical series.","     *","     * @method _stackXCoords","     * @protected","     */","    _stackXCoords: function()","    {","        var order = this.get(\"order\"),","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            seriesCollection = graph.seriesTypes[type],","            i = 0,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            len,","            coord,","            prevCoord,","            prevOrder,","            stackedXCoords = xcoords.concat(),","            prevXCoords,","            prevYCoords,","            nullIndices = [],","            nullIndex;","        if(order > 0)","        {","            prevXCoords = seriesCollection[order - 1].get(\"stackedXCoords\");","            prevYCoords = seriesCollection[order - 1].get(\"stackedYCoords\");","            len = prevXCoords.length;","        }","        else","        {","            len = xcoords.length;","        }","        for(; i < len; i = i + 1)","        {","            if(Y_Lang.isNumber(xcoords[i]))","            {","                if(order > 0)","                {","                    prevCoord = prevXCoords[i];","                    if(!Y_Lang.isNumber(prevCoord))","                    {","                        prevOrder = order;","                        while(prevOrder >  - 1 && !Y_Lang.isNumber(prevCoord))","                        {","                            prevOrder = prevOrder - 1;","                            if(prevOrder > -1)","                            {","                                prevCoord = seriesCollection[prevOrder].get(\"stackedXCoords\")[i];","                            }","                            else","                            {","                                prevCoord = this._leftOrigin;","                            }","                        }","                    }","                    xcoords[i] = xcoords[i] + prevCoord;","                }","                stackedXCoords[i] = xcoords[i];","            }","            else","            {","                nullIndices.push(i);","            }","        }","        this._cleanXNaN(stackedXCoords, ycoords);","        len = nullIndices.length;","        if(len > 0)","        {","            for(i = 0; i < len; i = i + 1)","            {","                nullIndex = nullIndices[i];","                coord = order > 0 ? prevXCoords[nullIndex] : this._leftOrigin;","                stackedXCoords[nullIndex] =  Math.max(stackedXCoords[nullIndex], coord);","            }","        }","        this.set(\"stackedXCoords\", stackedXCoords);","        this.set(\"stackedYCoords\", ycoords);","    },","","    /**","     * Stacks coordinates for a stacked horizontal series.","     *","     * @method _stackYCoords","     * @protected","     */","    _stackYCoords: function()","    {","        var order = this.get(\"order\"),","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            h = graph.get(\"height\"), ","            seriesCollection = graph.seriesTypes[type],","            i = 0,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            len,","            coord,","            prevCoord,","            prevOrder,","            stackedYCoords = ycoords.concat(),","            prevXCoords,","            prevYCoords,","            nullIndices = [],","            nullIndex;","        if(order > 0)","        {","            prevXCoords = seriesCollection[order - 1].get(\"stackedXCoords\");","            prevYCoords = seriesCollection[order - 1].get(\"stackedYCoords\");","            len = prevYCoords.length;","        }","        else","        {","            len = ycoords.length;","        }","        for(; i < len; i = i + 1)","        {","            if(Y_Lang.isNumber(ycoords[i]))","            {","                if(order > 0)","                {","                    prevCoord = prevYCoords[i];","                    if(!Y_Lang.isNumber(prevCoord))","                    {","                        prevOrder = order;","                        while(prevOrder >  - 1 && !Y_Lang.isNumber(prevCoord))","                        {","                            prevOrder = prevOrder - 1;","                            if(prevOrder > -1)","                            {","                                prevCoord = seriesCollection[prevOrder].get(\"stackedYCoords\")[i];","                            }","                            else","                            {","                                prevCoord = this._bottomOrigin;","                            }","                        }","                    }","                    ycoords[i] = prevCoord - (h - ycoords[i]);","                }","                stackedYCoords[i] = ycoords[i];","            }","            else","            {","                nullIndices.push(i);","            }","        }","        this._cleanYNaN(xcoords, stackedYCoords);","        len = nullIndices.length;","        if(len > 0)","        {","            for(i = 0; i < len; i = i + 1)","            {","                nullIndex = nullIndices[i];","                coord = order > 0 ? prevYCoords[nullIndex] : h;","                stackedYCoords[nullIndex] =  Math.min(stackedYCoords[nullIndex], coord);","            }","        }","        this.set(\"stackedXCoords\", xcoords);","        this.set(\"stackedYCoords\", stackedYCoords);","    },","","    /**","     * Cleans invalid x-coordinates by calculating their value based on the corresponding y-coordinate, the previous valid x-coordinate with its ","     * corresponding y-coordinate and the next valid x-coordinate with its corresponding y-coordinate. If there is no previous or next valid x-coordinate,","     * the value will not be altered.","     *","     * @method _cleanXNaN","     * @param {Array} xcoords An array of x-coordinate values","     * @param {Array} ycoords An arry of y-coordinate values","     * @private","     */","    _cleanXNaN: function(xcoords, ycoords)","    {","        var previousValidIndex,","            nextValidIndex,","            previousValidX,","            previousValidY,","            x,","            y,","            nextValidX,","            nextValidY,","            isNumber = Y_Lang.isNumber,","            m,","            i = 0,","            len = ycoords.length;","        for(; i < len; ++i)","        {","            x = xcoords[i];","            y = ycoords[i];","            //if x is invalid, calculate where it should be","            if(!isNumber(x) && i > 0 && i < len - 1)","            {","                previousValidY = ycoords[i - 1];","                //check to see if the previous value is valid","                previousValidX = this._getPreviousValidCoordValue(xcoords, i);","                nextValidY = ycoords[i + 1];","                nextValidX = this._getNextValidCoordValue(xcoords, i);","                //check to see if the next value is valid","                if(isNumber(previousValidX) && isNumber(nextValidX))","                {","                    //calculate slope and solve for x","                    m = (nextValidY - previousValidY) / (nextValidX - previousValidX);","                    xcoords[i] = (y + (m * previousValidX) - previousValidY)/m;","                }","                previousValidIndex = NaN;","                nextValidIndex = NaN;","            }","        }","    },","","    /**","     * Returns the previous valid (numeric) value in an array if available.","     *","     * @method _getPreviousValidCoordValue","     * @param {Array} coords Array of values","     * @param {Number} index The index in the array in which to begin searching.","     * @return Number","     * @private","     */","    _getPreviousValidCoordValue: function(coords, index)","    {","        var coord,","            isNumber = Y_Lang.isNumber,","            limit = -1;","        while(!isNumber(coord) && index > limit)","        {","            index = index - 1;","            coord = coords[index];","        }","        return coord;","    },","","    /**","     * Returns the next valid (numeric) value in an array if available.","     *","     * @method _getNextValidCoordValue","     * @param {Array} coords Array of values","     * @param {Number} index The index in the array in which to begin searching.","     * @return Number","     * @private","     */","    _getNextValidCoordValue: function(coords, index)","    {","        var coord,","            isNumber = Y_Lang.isNumber,","            limit = coords.length;","        while(!isNumber(coord) && index < limit)","        {","            index = index + 1;","            coord = coords[index];","        }","        return coord;","    },","","    /**","     * Cleans invalid y-coordinates by calculating their value based on the corresponding x-coordinate, the previous valid y-coordinate with its ","     * corresponding x-coordinate and the next valid y-coordinate with its corresponding x-coordinate. If there is no previous or next valid y-coordinate,","     * the value will not be altered.","     *","     * @method _cleanYNaN","     * @param {Array} xcoords An array of x-coordinate values","     * @param {Array} ycoords An arry of y-coordinate values","     * @private","     */","    _cleanYNaN: function(xcoords, ycoords)","    {","        var previousValidIndex,","            nextValidIndex,","            previousValidX,","            previousValidY,","            x,","            y,","            nextValidX,","            nextValidY,","            isNumber = Y_Lang.isNumber,","            m,","            i = 0,","            len = xcoords.length;","        for(; i < len; ++i)","        {","            x = xcoords[i];","            y = ycoords[i];","            //if y is invalid, calculate where it should be","            if(!isNumber(y) && i > 0 && i < len - 1)","            {","                //check to see if the previous value is valid","                previousValidX = xcoords[i - 1];","                previousValidY = this._getPreviousValidCoordValue(ycoords, i);","                //check to see if the next value is valid","                nextValidX = xcoords[i + 1];","                nextValidY = this._getNextValidCoordValue(ycoords, i);","                if(isNumber(previousValidY) && isNumber(nextValidY))","                {","                    //calculate slope and solve for y","                    m = (nextValidY - previousValidY) / (nextValidX - previousValidX);","                    ycoords[i] = previousValidY + ((m * x) - (m * previousValidX));","                }","                previousValidIndex = NaN;","                nextValidIndex = NaN;","            }","        }","    }","};","Y.StackingUtil = StackingUtil;","/**"," * Utility class used for drawing lines."," *"," * @module charts"," * @submodule charts-base"," * @class Lines"," * @constructor"," */","function Lines(){}","","Lines.prototype = {","    /**","     * @property _lineDefaults","     * @type Object","     * @private","     */","    _lineDefaults: null,","    ","    /**","     * Creates a graphic in which to draw a series.","     *","     * @method _getGraphic","     * @return Graphic","     * @private","     */","    _getGraphic: function()","    {","        var graphic = this.get(\"graphic\") || this.get(\"graph\").get(\"graphic\");","        if(!this._lineGraphic)","        {","            this._lineGraphic = graphic.addShape({type: \"path\"});","        }","        this._lineGraphic.clear();","        return this._lineGraphic;","    },","    ","    /**","     * Toggles visibility","     *","     * @method _toggleVisible","     * @param {Boolean} visible indicates visibilitye","     * @private","     */","    _toggleVisible: function(visible)","    {","        if(this._lineGraphic)","        {","            this._lineGraphic.set(\"visible\", visible);","        }","    },","","    /**","     * Draws lines for the series.","     *","     * @method drawLines","     * @protected","     */","    drawLines: function()","    {","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var isNumber = Y_Lang.isNumber,","            xcoords,","            ycoords,","            direction = this.get(\"direction\"),","            len,","            lastPointValid,","            pointValid,","            noPointsRendered = true,","            lastValidX,","            lastValidY,","            nextX,","            nextY,","            i,","            styles = this.get(\"styles\").line,","            lineType = styles.lineType,","            lc = styles.color || this._getDefaultColor(this.get(\"graphOrder\"), \"line\"),","            lineAlpha = styles.alpha,","            dashLength = styles.dashLength,","            gapSpace = styles.gapSpace,","            connectDiscontinuousPoints = styles.connectDiscontinuousPoints,","            discontinuousType = styles.discontinuousType,","            discontinuousDashLength = styles.discontinuousDashLength,","            discontinuousGapSpace = styles.discontinuousGapSpace,","            path = this._getGraphic();","        if(this._stacked)","        {","            xcoords = this.get(\"stackedXCoords\");","            ycoords = this.get(\"stackedYCoords\");","        }","        else","        {","            xcoords = this.get(\"xcoords\");","            ycoords = this.get(\"ycoords\");","        }","        len = direction === \"vertical\" ? ycoords.length : xcoords.length;","        path.set(\"stroke\", {","            weight: styles.weight, ","            color: lc, ","            opacity: lineAlpha","        });","        for(i = 0; i < len; i = ++i)","        {","            nextX = xcoords[i];","            nextY = ycoords[i];","            pointValid = isNumber(nextX) && isNumber(nextY); ","            if(!pointValid)","            {","                lastPointValid = pointValid;","                continue;","            }","            if(noPointsRendered)","            {","                noPointsRendered = false;","                path.moveTo(nextX, nextY);","            }","            else if(lastPointValid)","            {","                if(lineType != \"dashed\")","                {","                    path.lineTo(nextX, nextY);","                }","                else","                {","                    this.drawDashedLine(path, lastValidX, lastValidY, nextX, nextY, ","                                                dashLength, ","                                                gapSpace);","                }","            }","            else if(!connectDiscontinuousPoints)","            {","                path.moveTo(nextX, nextY);","            }","            else","            {","                if(discontinuousType != \"solid\")","                {","                    this.drawDashedLine(path, lastValidX, lastValidY, nextX, nextY, ","                                                discontinuousDashLength, ","                                                discontinuousGapSpace);","                }","                else","                {","                    path.lineTo(nextX, nextY);","                }","            }","            lastValidX = nextX;","            lastValidY = nextY;","            lastPointValid = true;","        }","        path.end();","    },","    ","    /**","     * Connects data points with a consistent curve for a series.","     * ","     * @method drawSpline","     * @protected","     */","    drawSpline: function()","    {","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            curvecoords = this.getCurveControlPoints(xcoords, ycoords),","            len = curvecoords.length,","            cx1,","            cx2,","            cy1,","            cy2,","            x,","            y,","            i = 0,","            styles = this.get(\"styles\").line,","            path = this._getGraphic(),","            lineAlpha = styles.alpha,","            color = styles.color || this._getDefaultColor(this.get(\"graphOrder\"), \"line\");","        path.set(\"stroke\", { ","            weight: styles.weight, ","            color: color, ","            opacity: lineAlpha","        });","        path.moveTo(xcoords[0], ycoords[0]);","        for(; i < len; i = ++i)","        {","            x = curvecoords[i].endx;","            y = curvecoords[i].endy;","            cx1 = curvecoords[i].ctrlx1;","            cx2 = curvecoords[i].ctrlx2;","            cy1 = curvecoords[i].ctrly1;","            cy2 = curvecoords[i].ctrly2;","            path.curveTo(cx1, cy1, cx2, cy2, x, y);","        }","        path.end();","    },","","    /**","     * Draws a dashed line between two points.","     * ","     * @method drawDashedLine","     * @param {Number} xStart	The x position of the start of the line","     * @param {Number} yStart	The y position of the start of the line","     * @param {Number} xEnd		The x position of the end of the line","     * @param {Number} yEnd		The y position of the end of the line","     * @param {Number} dashSize	the size of dashes, in pixels","     * @param {Number} gapSize	the size of gaps between dashes, in pixels","     * @private","     */","    drawDashedLine: function(path, xStart, yStart, xEnd, yEnd, dashSize, gapSize)","    {","        dashSize = dashSize || 10;","        gapSize = gapSize || 10;","        var segmentLength = dashSize + gapSize,","            xDelta = xEnd - xStart,","            yDelta = yEnd - yStart,","            delta = Math.sqrt(Math.pow(xDelta, 2) + Math.pow(yDelta, 2)),","            segmentCount = Math.floor(Math.abs(delta / segmentLength)),","            radians = Math.atan2(yDelta, xDelta),","            xCurrent = xStart,","            yCurrent = yStart,","            i;","        xDelta = Math.cos(radians) * segmentLength;","        yDelta = Math.sin(radians) * segmentLength;","        ","        for(i = 0; i < segmentCount; ++i)","        {","            path.moveTo(xCurrent, yCurrent);","            path.lineTo(xCurrent + Math.cos(radians) * dashSize, yCurrent + Math.sin(radians) * dashSize);","            xCurrent += xDelta;","            yCurrent += yDelta;","        }","        ","        path.moveTo(xCurrent, yCurrent);","        delta = Math.sqrt((xEnd - xCurrent) * (xEnd - xCurrent) + (yEnd - yCurrent) * (yEnd - yCurrent));","        ","        if(delta > dashSize)","        {","            path.lineTo(xCurrent + Math.cos(radians) * dashSize, yCurrent + Math.sin(radians) * dashSize);","        }","        else if(delta > 0)","        {","            path.lineTo(xCurrent + Math.cos(radians) * delta, yCurrent + Math.sin(radians) * delta);","        }","        ","        path.moveTo(xEnd, yEnd);","    },","","    /**","     * Default values for `styles` attribute.","     *","     * @method _getLineDefaults","     * @return Object","     * @protected","     */","    _getLineDefaults: function()","    {","        return {","            alpha: 1,","            weight: 6,","            lineType:\"solid\", ","            dashLength:10, ","            gapSpace:10, ","            connectDiscontinuousPoints:true, ","            discontinuousType:\"solid\", ","            discontinuousDashLength:10, ","            discontinuousGapSpace:10","        };","    }","};","Y.augment(Lines, Y.Attribute);","Y.Lines = Lines;","/**"," * Utility class used for drawing area fills."," *"," * @module charts"," * @class Fills"," * @constructor"," */","function Fills(cfg)","{","    var attrs = {","        area: {","            getter: function()","            {","                return this._defaults || this._getAreaDefaults();","            },","","            setter: function(val)","            {","                var defaults = this._defaults || this._getAreaDefaults();","                this._defaults = Y.merge(defaults, val);","            }","        }","    };","    this.addAttrs(attrs, cfg);","    this.get(\"styles\");","}","","Fills.prototype = {","    /**","     * Returns a path shape used for drawing fills.","     *","     * @method _getPath","     * @return Path","     * @private","     */","    _getPath: function()","    {","        var path = this._path;","        if(!path)","        {","            path = this.get(\"graph\").get(\"graphic\").addShape({type:\"path\"});","            this._path = path;","        }","        return path;","    },","    ","    /**","     * Toggles visibility","     *","     * @method _toggleVisible","     * @param {Boolean} visible indicates visibilitye","     * @private","     */","    _toggleVisible: function(visible)","    {   ","        if(this._path)","        {","            this._path.set(\"visible\", visible);","        }","    },","","    /**","     * Draws fill","     *","     * @method drawFill","     * @param {Array} xcoords The x-coordinates for the series.","     * @param {Array} ycoords The y-coordinates for the series.","     * @protected","     */","    drawFill: function(xcoords, ycoords)","    {","        if(xcoords.length < 1) ","        {","            return;","        }","        var isNumber = Y_Lang.isNumber,","            len = xcoords.length,","            firstX = xcoords[0],","            firstY = ycoords[0],","            lastValidX = firstX,","            lastValidY = firstY,","            nextX,","            nextY,","            pointValid,","            noPointsRendered = true,","            i = 0,","            styles = this.get(\"styles\").area,","            path = this._getPath(),","            color = styles.color || this._getDefaultColor(this.get(\"graphOrder\"), \"slice\");","        path.clear();","        path.set(\"fill\", {","            color: color, ","            opacity: styles.alpha","        });","        path.set(\"stroke\", {weight: 0});","        for(; i < len; i = ++i)","        {","            nextX = xcoords[i];","            nextY = ycoords[i];","            pointValid = isNumber(nextX) && isNumber(nextY); ","            if(!pointValid)","            {","                continue;","            }","            if(noPointsRendered)","            {","                this._firstValidX = nextX;","                this._firstValidY = nextY;","                noPointsRendered = false;","                path.moveTo(nextX, nextY);","            }","            else","            {","                path.lineTo(nextX, nextY);","            }","            lastValidX = nextX;","            lastValidY = nextY;","        }","        this._lastValidX = lastValidX;","        this._lastValidY = lastValidY;","        path.end();","    },","	","    /**","     * Draws a fill for a spline","     *","     * @method drawAreaSpline","     * @protected","     */","    drawAreaSpline: function()","    {","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            curvecoords = this.getCurveControlPoints(xcoords, ycoords),","            len = curvecoords.length,","            cx1,","            cx2,","            cy1,","            cy2,","            x,","            y,","            i = 0,","            firstX = xcoords[0],","            firstY = ycoords[0],","            styles = this.get(\"styles\").area,","            path = this._getPath(),","            color = styles.color || this._getDefaultColor(this.get(\"graphOrder\"), \"slice\");","        path.set(\"fill\", {","            color: color, ","            opacity: styles.alpha","        });","        path.set(\"stroke\", {weight: 0});","        path.moveTo(firstX, firstY);","        for(; i < len; i = ++i)","        {","            x = curvecoords[i].endx;","            y = curvecoords[i].endy;","            cx1 = curvecoords[i].ctrlx1;","            cx2 = curvecoords[i].ctrlx2;","            cy1 = curvecoords[i].ctrly1;","            cy2 = curvecoords[i].ctrly2;","            path.curveTo(cx1, cy1, cx2, cy2, x, y);","        }","        if(this.get(\"direction\") === \"vertical\")","        {","            path.lineTo(this._leftOrigin, y);","            path.lineTo(this._leftOrigin, firstY);","        }","        else","        {","            path.lineTo(x, this._bottomOrigin);","            path.lineTo(firstX, this._bottomOrigin);","        }","        path.lineTo(firstX, firstY);","        path.end();","    },","    ","    /**","     * Draws a a stacked area spline","     *","     * @method drawStackedAreaSpline","     * @protected","     */","    drawStackedAreaSpline: function()","    {","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            curvecoords,","            order = this.get(\"order\"),","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            seriesCollection = graph.seriesTypes[type],","            prevXCoords,","            prevYCoords,","            len,","            cx1,","            cx2,","            cy1,","            cy2,","            x,","            y,","            i = 0,","            firstX,","            firstY,","            styles = this.get(\"styles\").area,","            path = this._getPath(),","            color = styles.color || this._getDefaultColor(this.get(\"graphOrder\"), \"slice\");","        firstX = xcoords[0];","        firstY = ycoords[0];","        curvecoords = this.getCurveControlPoints(xcoords, ycoords);","        len = curvecoords.length;","        path.set(\"fill\", {","            color: color, ","            opacity: styles.alpha","        });","        path.set(\"stroke\", {weight: 0});","        path.moveTo(firstX, firstY);","        for(; i < len; i = ++i)","        {","            x = curvecoords[i].endx;","            y = curvecoords[i].endy;","            cx1 = curvecoords[i].ctrlx1;","            cx2 = curvecoords[i].ctrlx2;","            cy1 = curvecoords[i].ctrly1;","            cy2 = curvecoords[i].ctrly2;","            path.curveTo(cx1, cy1, cx2, cy2, x, y);","        }","        if(order > 0)","        {","            prevXCoords = seriesCollection[order - 1].get(\"xcoords\").concat().reverse();","            prevYCoords = seriesCollection[order - 1].get(\"ycoords\").concat().reverse();","            curvecoords = this.getCurveControlPoints(prevXCoords, prevYCoords);","            i = 0;","            len = curvecoords.length;","            path.lineTo(prevXCoords[0], prevYCoords[0]);","            for(; i < len; i = ++i)","            {","                x = curvecoords[i].endx;","                y = curvecoords[i].endy;","                cx1 = curvecoords[i].ctrlx1;","                cx2 = curvecoords[i].ctrlx2;","                cy1 = curvecoords[i].ctrly1;","                cy2 = curvecoords[i].ctrly2;","                path.curveTo(cx1, cy1, cx2, cy2, x, y);","            }","        }","        else","        {","            if(this.get(\"direction\") === \"vertical\")","            {","                path.lineTo(this._leftOrigin, ycoords[ycoords.length-1]);","                path.lineTo(this._leftOrigin, firstY);","            }","            else","            {","                path.lineTo(xcoords[xcoords.length-1], this._bottomOrigin);","                path.lineTo(firstX, this._bottomOrigin);","            }","","        }","        path.lineTo(firstX, firstY);","        path.end();","    },","    ","    /**","     * Storage for default area styles.","     *","     * @property _defaults","     * @type Object","     * @private","     */","    _defaults: null,","","    /**","     * Concatenates coordinate array with correct coordinates for closing an area fill.","     *","     * @method _getClosingPoints","     * @return Array","     * @protected","     */","    _getClosingPoints: function()","    {","        var xcoords = this.get(\"xcoords\").concat(),","            ycoords = this.get(\"ycoords\").concat(),","            firstValidIndex,","            lastValidIndex;","        if(this.get(\"direction\") === \"vertical\")","        {","            lastValidIndex = this._getLastValidIndex(xcoords);","            firstValidIndex = this._getFirstValidIndex(xcoords);","            ycoords.push(ycoords[lastValidIndex]);","            ycoords.push(ycoords[firstValidIndex]);","            xcoords.push(this._leftOrigin);","            xcoords.push(this._leftOrigin);","        }","        else","        {","            lastValidIndex = this._getLastValidIndex(ycoords);","            firstValidIndex = this._getFirstValidIndex(ycoords);","            xcoords.push(xcoords[lastValidIndex]);","            xcoords.push(xcoords[firstValidIndex]);","            ycoords.push(this._bottomOrigin);","            ycoords.push(this._bottomOrigin);","        }","        xcoords.push(xcoords[0]);","        ycoords.push(ycoords[0]);","        return [xcoords, ycoords];","    },","","    /**","     * Returns the order of the series closest to the current series that has a valid value for the current index.","     *","     * @method _getHighestValidOrder","     * @param {Array} seriesCollection Array of series of a given type.","     * @param {Number} index Index of the series item.","     * @param {Number} order Index of the the series in the seriesCollection","     * @param {String} direction Indicates the direction of the series","     * @return Number","     * @private","     */","    _getHighestValidOrder: function(seriesCollection, index, order, direction)","    {","        var coords = direction == \"vertical\" ? \"stackedXCoords\" : \"stackedYCoords\",","            coord;","        while(isNaN(coord) && order > -1)","        {","          order = order - 1;","          if(order > -1)","          {","            coord = seriesCollection[order].get(coords)[index];","          }","        }","        return order;","    },","    ","    /**","     * Returns an array containing the x and y coordinates for a given series and index.","     *","     * @method _getCoordsByOrderAndIndex","     * @param {Array} seriesCollection Array of series of a given type.","     * @param {Number} index Index of the series item.","     * @param {Number} order Index of the the series in the seriesCollection","     * @param {String} direction Indicates the direction of the series","     * @return Array","     * @private","     */","    _getCoordsByOrderAndIndex: function(seriesCollection, index, order, direction)","    {","        var xcoord,","            ycoord;","        if(direction == \"vertical\")","        {","            xcoord = order < 0 ? this._leftOrigin : seriesCollection[order].get(\"stackedXCoords\")[index];","            ycoord = this.get(\"stackedYCoords\")[index];","        }","        else","        {","            xcoord = this.get(\"stackedXCoords\")[index];","            ycoord = order < 0 ? this._bottomOrigin : seriesCollection[order].get(\"stackedYCoords\")[index];","        }","        return [xcoord, ycoord];","    },","    ","    /**","     * Concatenates coordinate array with the correct coordinates for closing an area stack.","     *","     * @method _getStackedClosingPoints","     * @return Array","     * @protected","     */","    _getStackedClosingPoints: function()","    {","        var order = this.get(\"order\"),","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            direction = this.get(\"direction\"),","            seriesCollection = graph.seriesTypes[type],","            firstValidIndex,","            lastValidIndex,","            xcoords = this.get(\"stackedXCoords\"),","            ycoords = this.get(\"stackedYCoords\"),","            limit,","            previousSeries,","            previousSeriesFirstValidIndex,","            previousSeriesLastValidIndex,","            previousXCoords,","            previousYCoords,","            coords,","            closingXCoords,","            closingYCoords,","            currentIndex,","            highestValidOrder,","            oldOrder;","        if(order < 1)","        {    ","          return this._getClosingPoints();","        }","        ","        previousSeries = seriesCollection[order - 1];","        previousXCoords = previousSeries.get(\"stackedXCoords\").concat();","        previousYCoords = previousSeries.get(\"stackedYCoords\").concat();","        if(direction == \"vertical\")","        {","            firstValidIndex = this._getFirstValidIndex(xcoords);","            lastValidIndex = this._getLastValidIndex(xcoords);","            previousSeriesFirstValidIndex = previousSeries._getFirstValidIndex(previousXCoords);","            previousSeriesLastValidIndex = previousSeries._getLastValidIndex(previousXCoords);","        }","        else","        {","            firstValidIndex = this._getFirstValidIndex(ycoords);","            lastValidIndex = this._getLastValidIndex(ycoords);","            previousSeriesFirstValidIndex = previousSeries._getFirstValidIndex(previousYCoords);","            previousSeriesLastValidIndex = previousSeries._getLastValidIndex(previousYCoords);","        }","        if(previousSeriesLastValidIndex >= firstValidIndex && previousSeriesFirstValidIndex <= lastValidIndex)","        {","            previousSeriesFirstValidIndex = Math.max(firstValidIndex, previousSeriesFirstValidIndex);","            previousSeriesLastValidIndex = Math.min(lastValidIndex, previousSeriesLastValidIndex);","            previousXCoords = previousXCoords.slice(previousSeriesFirstValidIndex, previousSeriesLastValidIndex + 1);","            previousYCoords = previousYCoords.slice(previousSeriesFirstValidIndex, previousSeriesLastValidIndex + 1);","            limit = previousSeriesFirstValidIndex;","        }","        else","        {","            limit = lastValidIndex;","        }","","        closingXCoords = [xcoords[firstValidIndex]];","        closingYCoords = [ycoords[firstValidIndex]];","        currentIndex = firstValidIndex;","        while((isNaN(highestValidOrder) || highestValidOrder < order - 1) && currentIndex <= limit)","        {","            oldOrder = highestValidOrder;","            highestValidOrder = this._getHighestValidOrder(seriesCollection, currentIndex, order, direction);","            if(!isNaN(oldOrder) && highestValidOrder > oldOrder)","            {","                coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, oldOrder, direction);","                closingXCoords.push(coords[0]);","                closingYCoords.push(coords[1]);","            }","            coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, highestValidOrder, direction);","            closingXCoords.push(coords[0]);","            closingYCoords.push(coords[1]);","            currentIndex = currentIndex + 1;","        }","        if(previousXCoords && previousXCoords.length > 0 && previousSeriesLastValidIndex > firstValidIndex && previousSeriesFirstValidIndex < lastValidIndex)","        {","            closingXCoords = closingXCoords.concat(previousXCoords);","            closingYCoords = closingYCoords.concat(previousYCoords);","            highestValidOrder = order -1; ","        }","        currentIndex = Math.max(firstValidIndex, previousSeriesLastValidIndex);","        order = order - 1;","        highestValidOrder = NaN;","        while(currentIndex <= lastValidIndex)","        {","            oldOrder = highestValidOrder;","            highestValidOrder = this._getHighestValidOrder(seriesCollection, currentIndex, order, direction);","            if(!isNaN(oldOrder))","            {","                if(highestValidOrder > oldOrder)","                {","                    coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, oldOrder, direction);","                    closingXCoords.push(coords[0]);","                    closingYCoords.push(coords[1]);","                }","                else if(highestValidOrder < oldOrder)","                {","                    coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex - 1, highestValidOrder, direction);","                    closingXCoords.push(coords[0]);","                    closingYCoords.push(coords[1]);","                }","            }","            coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, highestValidOrder, direction);","            closingXCoords.push(coords[0]);","            closingYCoords.push(coords[1]);","            currentIndex = currentIndex + 1;","        }","","        closingXCoords.reverse();","        closingYCoords.reverse();","        return [xcoords.concat(closingXCoords), ycoords.concat(closingYCoords)];","    },","","    /**","     * Returns default values for area styles.","     *","     * @method _getAreaDefaults","     * @return Object","     * @private","     */","    _getAreaDefaults: function()","    {","        return {","        };","    }","};","Y.augment(Fills, Y.Attribute);","Y.Fills = Fills;","/**"," * Utility class used for drawing markers."," *"," * @module charts"," * @submodule charts-base"," * @class Plots"," * @constructor"," */","function Plots(cfg)","{","    var attrs = { ","        markers: {","            getter: function()","            {","                return this._markers;","            }","        }","    };","    this.addAttrs(attrs, cfg);","}","","Plots.prototype = {","    /**","     * Storage for default marker styles.","     *","     * @property _plotDefaults","     * @type Object","     * @private","     */","    _plotDefaults: null,","","    /**","     * Draws the markers","     *","     * @method drawPlots","     * @protected","     */","    drawPlots: function()","    {","        if(!this.get(\"xcoords\") || this.get(\"xcoords\").length < 1) ","		{","			return;","		}","        var isNumber = Y_Lang.isNumber,","            style = Y.clone(this.get(\"styles\").marker),","            w = style.width,","            h = style.height,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            i = 0,","            len = xcoords.length,","            top = ycoords[0],","            left,","            marker,","            offsetWidth = w/2,","            offsetHeight = h/2,","            xvalues,","            yvalues,","            fillColors = null,","            borderColors = null,","            graphOrder = this.get(\"graphOrder\"),","            groupMarkers = this.get(\"groupMarkers\");","        if(groupMarkers)","        {","            xvalues = [];","            yvalues = [];","            for(; i < len; ++i)","            {","                xvalues.push(parseFloat(xcoords[i] - offsetWidth));","                yvalues.push(parseFloat(ycoords[i] - offsetHeight));","            }","            this._createGroupMarker({","                xvalues: xvalues,","                yvalues: yvalues,","                fill: style.fill,","                border: style.border,","                dimensions: {","                    width: w,","                    height: h","                },","                graphOrder: graphOrder,","                shape: style.shape","            });","            return;","        }","        if(Y_Lang.isArray(style.fill.color))","        {","            fillColors = style.fill.color.concat(); ","        }","        if(Y_Lang.isArray(style.border.color))","        {","            borderColors = style.border.color.concat();","        }","        this._createMarkerCache();","        for(; i < len; ++i)","        {","            top = parseFloat(ycoords[i] - offsetHeight);","            left = parseFloat(xcoords[i] - offsetWidth);            ","            if(!isNumber(left) || !isNumber(top))","            {","                this._markers.push(null);","                continue;","            }","            if(fillColors)","            {","                style.fill.color = fillColors[i % fillColors.length];","            }","            if(borderColors)","            {","                style.border.color = borderColors[i % borderColors.length];","            }","","            style.x = left;","            style.y = top;","            marker = this.getMarker(style, graphOrder, i);","        }","        this._clearMarkerCache();","    },","","    /**","     * Pre-defined group shapes.","     *","     * @property _groupShapes","     * @private","     */","    _groupShapes: {","        circle: Y.CircleGroup,","        rect: Y.RectGroup,","        ellipse: Y.EllipseGroup,","        diamond: Y.DiamondGroup","    },","","    /**","     * Returns the correct group shape class.","     *","     * @method _getGroupShape","     * @param {Shape | String} shape Indicates which shape class. ","     * @return Function","     * @protected","     */","    _getGroupShape: function(shape)","    {","        if(Y_Lang.isString(shape))","        {","            shape = this._groupShapes[shape];","        }","        return shape;","    },","","    /**","     * Gets the default values for series that use the utility. This method is used by","     * the class' `styles` attribute's getter to get build default values.","     *","     * @method _getPlotDefaults","     * @return Object","     * @protected","     */","    _getPlotDefaults: function()","    {","        var defs = {","            fill:{","                type: \"solid\",","                alpha: 1,","                colors:null,","                alphas: null,","                ratios: null","            },","            border:{","                weight: 1,","                alpha: 1","            },","            width: 10,","            height: 10,","            shape: \"circle\"","        };","        defs.fill.color = this._getDefaultColor(this.get(\"graphOrder\"), \"fill\");","        defs.border.color = this._getDefaultColor(this.get(\"graphOrder\"), \"border\");","        return defs;","    },","","    /**","     * Collection of markers to be used in the series.","     *","     * @property _markers","     * @type Array","     * @private","     */","    _markers: null,","","    /**","     * Collection of markers to be re-used on a series redraw.","     *","     * @property _markerCache","     * @type Array","     * @private","     */","    _markerCache: null,","   ","    /**","     * Gets and styles a marker. If there is a marker in cache, it will use it. Otherwise","     * it will create one.","     *","     * @method getMarker","     * @param {Object} styles Hash of style properties.","     * @param {Number} order Order of the series.","     * @param {Number} index Index within the series associated with the marker.","     * @return Shape","     * @protected","     */","    getMarker: function(styles, order, index)","    {","        var marker,","            border = styles.border;","        styles.id = this.get(\"chart\").get(\"id\") + \"_\" + order + \"_\" + index;","        //fix name differences between graphic layer","        border.opacity = border.alpha;","        styles.stroke = border;","        styles.fill.opacity = styles.fill.alpha;","        if(this._markerCache.length > 0)","        {","            while(!marker)","            {","                if(this._markerCache.length < 1)","                {","                    marker = this._createMarker(styles, order, index);","                    break;","                }","                marker = this._markerCache.shift();","","            }","            marker.set(styles);","        }","        else","        {","            marker = this._createMarker(styles, order, index);","        }","        this._markers.push(marker);","        return marker;","    },","    ","    /**","     * Creates a shape to be used as a marker.","     *","     * @method _createMarker","     * @param {Object} styles Hash of style properties.","     * @param {Number} order Order of the series.","     * @param {Number} index Index within the series associated with the marker.","     * @return Shape","     * @private","     */","    _createMarker: function(styles, order, index)","    {","        var graphic = this.get(\"graphic\"),","            marker,","            cfg = Y.clone(styles);","        graphic.set(\"autoDraw\", false);","        cfg.type = cfg.shape;","        marker = graphic.addShape(cfg); ","        marker.addClass(SERIES_MARKER);","        return marker;","    },","    ","    /**","     * Creates a cache of markers for reuse.","     *","     * @method _createMarkerCache","     * @private","     */","    _createMarkerCache: function()","    {","        if(this._groupMarker)","        {","            this._groupMarker.destroy();","            this._groupMarker = null;","        }","        if(this._markers && this._markers.length > 0)","        {","            this._markerCache = this._markers.concat();","        }","        else","        {","            this._markerCache = [];","        }","        this._markers = [];","    },","  ","    /**","     * Draws a series of markers in a single shape instance.","     *","     * @method _createGroupMarkers","     * @param {Object} styles Set of configuration properties used to create the markers.","     * @protected","     */","    _createGroupMarker: function(styles)","    {","        var marker,","            markers = this.get(\"markers\"),","            border = styles.border,","            graphic,","            cfg,","            shape;","        if(markers && markers.length > 0)","        {","            while(markers.length > 0)","            {","                marker = markers.shift();","                marker.destroy();","            }","            this.set(\"markers\", []);","        }","        //fix name differences between graphic layer","        border.opacity = border.alpha;","        cfg = {","            id: this.get(\"chart\").get(\"id\") + \"_\" + styles.graphOrder,","            stroke: border,","            fill: styles.fill,","            dimensions: styles.dimensions,","            xvalues: styles.xvalues,","            yvalues: styles.yvalues","        };","        cfg.fill.opacity = styles.fill.alpha;","        shape = this._getGroupShape(styles.shape);","        if(shape)","        {","            cfg.type = shape;","        }","        if(styles.hasOwnProperty(\"radius\") && !isNaN(styles.radius))","        {","            cfg.dimensions.radius = styles.radius;","        }","        if(this._groupMarker)","        {","            this._groupMarker.destroy();","        }","        graphic = this.get(\"graphic\");","        this._groupMarker = graphic.addShape(cfg);","        graphic._redraw();","    },","","    /**","     * Toggles visibility","     *","     * @method _toggleVisible","     * @param {Boolean} visible indicates visibilitye","     * @private","     */","    _toggleVisible: function(visible)","    {","        var marker,","            markers = this.get(\"markers\"),","            i = 0,","            len;","        if(markers)","        {","            len = markers.length;","            for(; i < len; ++i)","            {","                marker = markers[i];","                if(marker)","                {","                    marker.set(\"visible\", visible);","                }","            }","        }","    },","","    /**","     * Removes unused markers from the marker cache","     *","     * @method _clearMarkerCache","     * @private","     */","    _clearMarkerCache: function()","    {","        var marker;","        while(this._markerCache.length > 0)","        {","            marker = this._markerCache.shift();","            if(marker)","            {","                marker.destroy();","            }","        }","    },","","    /**","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     * @protected","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers && this._markers[i])","        {","            var w,","                h,","                styles = Y.clone(this.get(\"styles\").marker),","                state = this._getState(type),","                xcoords = this.get(\"xcoords\"),","                ycoords = this.get(\"ycoords\"),","                marker = this._markers[i],","                markerStyles = state == \"off\" || !styles[state] ? styles : styles[state]; ","                markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);","                markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);","                markerStyles.stroke = markerStyles.border;","                marker.set(markerStyles);","                w = markerStyles.width;","                h = markerStyles.height;","                marker.set(\"x\", (xcoords[i] - w/2));","                marker.set(\"y\",  (ycoords[i] - h/2));","                marker.set(\"visible\", this.get(\"visible\"));","        }","    },","","    /**","     * Parses a color from an array.","     *","     * @method _getItemColor","     * @param {Array} val collection of colors","     * @param {Number} i index of the item","     * @return String","     * @protected","     */","    _getItemColor: function(val, i)","    {","        if(Y_Lang.isArray(val))","        {","            return val[i % val.length];","        }","        return val;","    },","","    /**","     * Method used by `styles` setter. Overrides base implementation.","     *","     * @method _setStyles","     * @param {Object} newStyles Hash of properties to update.","     * @return Object","     * @protected","     */","    _setStyles: function(val)","    {","        val = this._parseMarkerStyles(val);","        return Y.Renderer.prototype._setStyles.apply(this, [val]);","    },","","    /**","     * Combines new styles with existing styles.","     *","     * @method _parseMarkerStyles","     * @param {Object} Object containing style properties for the marker.","     * @return Object","     * @private","     */","    _parseMarkerStyles: function(val)","    {","        if(val.marker)","        {","            var defs = this._getPlotDefaults();","            val.marker = this._mergeStyles(val.marker, defs);","            if(val.marker.over)","            {","                val.marker.over = this._mergeStyles(val.marker.over, val.marker);","            }","            if(val.marker.down)","            {","                val.marker.down = this._mergeStyles(val.marker.down, val.marker);","            }","        }","        return val;","    },","","    /**","     * Returns marker state based on event type","     *","     * @method _getState","     * @param {String} type event type","     * @return String","     * @protected","     */","    _getState: function(type)","    {","        var state;","        switch(type)","        {","            case \"mouseout\" :","                state = \"off\";","            break;","            case \"mouseover\" :","                state = \"over\";","            break;","            case \"mouseup\" :","                state = \"over\";","            break;","            case \"mousedown\" :","                state = \"down\";","            break;","        }","        return state;","    },","    ","    /**","     * @property _statSyles","     * @type Object","     * @private","     */","    _stateSyles: null","};","","Y.augment(Plots, Y.Attribute);","Y.Plots = Plots;","/**"," * Histogram is the base class for Column and Bar series."," *"," * @module charts"," * @submodule charts-base"," * @class Histogram"," * @constructor"," */","function Histogram(){}","","Histogram.prototype = {","    /**","     * Draws the series.","     *","     * @method drawSeries","     * @protected","     */","    drawSeries: function()","    {","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var style = Y.clone(this.get(\"styles\").marker),","            setSize,","            calculatedSize,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            i = 0,","            len = xcoords.length,","            top = ycoords[0],","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            seriesCollection = graph.seriesTypes[type],","            seriesLen = seriesCollection.length,","            seriesSize = 0,","            totalSize = 0,","            offset = 0,","            ratio,","            renderer,","            order = this.get(\"order\"),","            graphOrder = this.get(\"graphOrder\"),","            left,","            marker,","            setSizeKey,","            calculatedSizeKey,","            config,","            fillColors = null,","            borderColors = null,","            xMarkerPlane = [],","            yMarkerPlane = [],","            xMarkerPlaneLeft,","            xMarkerPlaneRight,","            yMarkerPlaneTop,","            yMarkerPlaneBottom,","            dimensions = {","                width: [],","                height: []","            },","            xvalues = [],","            yvalues = [],","            groupMarkers = this.get(\"groupMarkers\");","        if(Y_Lang.isArray(style.fill.color))","        {","            fillColors = style.fill.color.concat(); ","        }","        if(Y_Lang.isArray(style.border.color))","        {","            borderColors = style.border.color.concat();","        }","        if(this.get(\"direction\") == \"vertical\")","        {","            setSizeKey = \"height\";","            calculatedSizeKey = \"width\";","        }","        else","        {","            setSizeKey = \"width\";","            calculatedSizeKey = \"height\";","        }","        setSize = style[setSizeKey];","        calculatedSize = style[calculatedSizeKey];","        this._createMarkerCache();","        for(; i < seriesLen; ++i)","        {","            renderer = seriesCollection[i];","            seriesSize += renderer.get(\"styles\").marker[setSizeKey];","            if(order > i) ","            {","                offset = seriesSize;","            }","        }","        totalSize = len * seriesSize;","        this._maxSize = graph.get(setSizeKey);","        if(totalSize > this._maxSize)","        {","            ratio = graph.get(setSizeKey)/totalSize;","            seriesSize *= ratio;","            offset *= ratio;","            setSize *= ratio;","            setSize = Math.max(setSize, 1);","            this._maxSize = setSize;","        }","        offset -= seriesSize/2;","        for(i = 0; i < len; ++i)","        {","            xMarkerPlaneLeft = xcoords[i] - seriesSize/2;","            xMarkerPlaneRight = xMarkerPlaneLeft + seriesSize;","            yMarkerPlaneTop = ycoords[i] - seriesSize/2;","            yMarkerPlaneBottom = yMarkerPlaneTop + seriesSize;","            xMarkerPlane.push({start: xMarkerPlaneLeft, end: xMarkerPlaneRight});","            yMarkerPlane.push({start: yMarkerPlaneTop, end: yMarkerPlaneBottom});","            if(isNaN(xcoords[i]) || isNaN(ycoords[i]))","            {","                this._markers.push(null);","                continue;","            }","            config = this._getMarkerDimensions(xcoords[i], ycoords[i], calculatedSize, offset);","            if(!isNaN(config.calculatedSize) && config.calculatedSize > 0)","            {","                top = config.top;","                left = config.left;","","                if(groupMarkers)","                {","                    dimensions[setSizeKey][i] = setSize;","                    dimensions[calculatedSizeKey][i] = config.calculatedSize;","                    xvalues.push(left);","                    yvalues.push(top);","                }","                else","                {","                    style[setSizeKey] = setSize;","                    style[calculatedSizeKey] = config.calculatedSize;","                    style.x = left;","                    style.y = top;","                    if(fillColors)","                    {","                        style.fill.color = fillColors[i % fillColors.length];","                    }","                    if(borderColors)","                    {","                        style.border.color = borderColors[i % borderColors.length];","                    }","                    marker = this.getMarker(style, graphOrder, i);","                }","","            }","            else if(!groupMarkers)","            {","                this._markers.push(null);","            }","        }","        this.set(\"xMarkerPlane\", xMarkerPlane);","        this.set(\"yMarkerPlane\", yMarkerPlane);","        if(groupMarkers)","        {","            this._createGroupMarker({","                fill: style.fill,","                border: style.border,","                dimensions: dimensions,","                xvalues: xvalues,","                yvalues: yvalues,","                shape: style.shape","            });","        }","        else","        {","            this._clearMarkerCache();","        }","    },","    ","    /**","     * Collection of default colors used for marker fills in a series when not specified by user.","     *","     * @property _defaultFillColors","     * @type Array","     * @protected","     */","    _defaultFillColors: [\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"],","    ","    /**","     * Gets the default style values for the markers.","     *","     * @method _getPlotDefaults","     * @return Object","     * @private","     */","    _getPlotDefaults: function()","    {","        var defs = {","            fill:{","                type: \"solid\",","                alpha: 1,","                colors:null,","                alphas: null,","                ratios: null","            },","            border:{","                weight: 0,","                alpha: 1","            },","            width: 12,","            height: 12,","            shape: \"rect\",","","            padding:{","                top: 0,","                left: 0,","                right: 0,","                bottom: 0","            }","        };","        defs.fill.color = this._getDefaultColor(this.get(\"graphOrder\"), \"fill\");","        defs.border.color = this._getDefaultColor(this.get(\"graphOrder\"), \"border\");","        return defs;","    }","};","","Y.Histogram = Histogram;","/**"," * The CartesianSeries class creates a chart with horizontal and vertical axes."," *"," * @module charts"," * @submodule charts-base"," * @class CartesianSeries"," * @extends Base"," * @uses Renderer"," * @constructor"," */","Y.CartesianSeries = Y.Base.create(\"cartesianSeries\", Y.Base, [Y.Renderer], {","    /**","     * Storage for `xDisplayName` attribute.","     *","     * @property _xDisplayName","     * @type String","     * @private","     */","    _xDisplayName: null,","","    /**","     * Storage for `yDisplayName` attribute.","     *","     * @property _yDisplayName","     * @type String","     * @private","     */","    _yDisplayName: null,","    ","    /**","     * Th x-coordinate for the left edge of the series.","     *","     * @property _leftOrigin","     * @type String","     * @private","     */","    _leftOrigin: null,","","    /**","     * The y-coordinate for the bottom edge of the series.","     * ","     * @property _bottomOrigin","     * @type String","     * @private","     */","    _bottomOrigin: null,","","    /**","     * @method render","     * @private","     */","    render: function()","    {","        this._setCanvas();","        this.addListeners();","        this.set(\"rendered\", true);","        this.validate();","    },","","    /**","     * Adds event listeners.","     *","     * @method addListeners","     * @private","     */","    addListeners: function()","    {","        var xAxis = this.get(\"xAxis\"),","            yAxis = this.get(\"yAxis\");","        if(xAxis)","        {","            this._xDataReadyHandle = xAxis.after(\"dataReady\", Y.bind(this._xDataChangeHandler, this));","            this._xDataUpdateHandle = xAxis.after(\"dataUpdate\", Y.bind(this._xDataChangeHandler, this));","        }","        if(yAxis)","        {","            this._yDataReadyHandle = yAxis.after(\"dataReady\", Y.bind(this._yDataChangeHandler, this));","            this._yDataUpdateHandle = yAxis.after(\"dataUpdate\", Y.bind(this._yDataChangeHandler, this));","        }","        this._xAxisChangeHandle = this.after(\"xAxisChange\", this._xAxisChangeHandler);","        this._yAxisChangeHandle = this.after(\"yAxisChange\", this._yAxisChangeHandler);","        this._stylesChangeHandle = this.after(\"stylesChange\", function(e) {","            var axesReady = this._updateAxisData();","            if(axesReady)","            {","                this.draw();","            }","        });","        this._widthChangeHandle = this.after(\"widthChange\", function(e) {","            var axesReady = this._updateAxisData();","            if(axesReady)","            {","                this.draw();","            }","        });","        this._heightChangeHandle = this.after(\"heightChange\", function(e) {","            var axesReady = this._updateAxisData();","            if(axesReady)","            {","                this.draw();","            }","        });","        this._visibleChangeHandle = this.after(\"visibleChange\", this._handleVisibleChange);","    },","  ","    /**","     * Event handler for the xAxisChange event.","     *","     * @method _xAxisChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _xAxisChangeHandler: function(e)","    {","        var xAxis = this.get(\"xAxis\");","        xAxis.after(\"dataReady\", Y.bind(this._xDataChangeHandler, this));","        xAxis.after(\"dataUpdate\", Y.bind(this._xDataChangeHandler, this));","    },","    ","    /**","     * Event handler the yAxisChange event.","     *","     * @method _yAxisChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _yAxisChangeHandler: function(e)","    {","        var yAxis = this.get(\"yAxis\");","        yAxis.after(\"dataReady\", Y.bind(this._yDataChangeHandler, this));","        yAxis.after(\"dataUpdate\", Y.bind(this._yDataChangeHandler, this));","    },","","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"yuicartesianseries\",","","    /**","     * Event handler for xDataChange event.","     *","     * @method _xDataChangeHandler","     * @param {Object} event Event object.","     * @private ","     */","    _xDataChangeHandler: function(event)","    {","        var axesReady = this._updateAxisData();","        if(axesReady)","        {","            this.draw();","        }","    },","","    /**","     * Event handler for yDataChange event.","     *","     * @method _yDataChangeHandler","     * @param {Object} event Event object.","     * @private ","     */","    _yDataChangeHandler: function(event)","    {","        var axesReady = this._updateAxisData();","        if(axesReady)","        {","            this.draw();","        }","    },","","    /**","     * Checks to ensure that both xAxis and yAxis data are available. If so, set the `xData` and `yData` attributes and return `true`. Otherwise, return `false`.","     *","     * @method _updateAxisData","     * @return Boolean","     * @private ","     */","    _updateAxisData: function()","    {","        var xAxis = this.get(\"xAxis\"),","            yAxis = this.get(\"yAxis\"),","            xKey = this.get(\"xKey\"),","            yKey = this.get(\"yKey\"),","            yData,","            xData;","        if(!xAxis || !yAxis || !xKey || !yKey)","        {","            return false;","        }","        xData = xAxis.getDataByKey(xKey);","        yData = yAxis.getDataByKey(yKey);","        if(!xData || !yData)","        {","            return false;","        }","        this.set(\"xData\", xData.concat());","        this.set(\"yData\", yData.concat());","        return true;","    },","","    /**","     * Draws the series is the xAxis and yAxis data are both available.","     *","     * @method validate","     * @private","     */","    validate: function()","    {","        if((this.get(\"xData\") && this.get(\"yData\")) || this._updateAxisData())","        {","            this.draw();","        }","        else","        {","            this.fire(\"drawingComplete\");","        }","    },","","    /**","     * Creates a `Graphic` instance.","     *","     * @method _setCanvas","     * @protected","     */","    _setCanvas: function()","    {","        var graph = this.get(\"graph\"),","            graphic = graph.get(\"graphic\");","        this.set(\"graphic\", graphic);","    },","","    /**","     * Calculates the coordinates for the series.","     *","     * @method setAreaData","     * @protected","     */","    setAreaData: function()","    {","        var isNumber = Y_Lang.isNumber,","            nextX, nextY,","            graph = this.get(\"graph\"),","            w = graph.get(\"width\"),","            h = graph.get(\"height\"),","            xAxis = this.get(\"xAxis\"),","            yAxis = this.get(\"yAxis\"),","            xData = this.get(\"xData\").concat(),","            yData = this.get(\"yData\").concat(),","            xValue,","            yValue,","            xOffset = xAxis.getEdgeOffset(xData.length, w),","            yOffset = yAxis.getEdgeOffset(yData.length, h),","            padding = this.get(\"styles\").padding,","			leftPadding = padding.left,","			topPadding = padding.top,","			dataWidth = w - (leftPadding + padding.right + xOffset),","			dataHeight = h - (topPadding + padding.bottom + yOffset),","			xcoords = [],","			ycoords = [],","			xMax = xAxis.get(\"maximum\"),","			xMin = xAxis.get(\"minimum\"),","			yMax = yAxis.get(\"maximum\"),","			yMin = yAxis.get(\"minimum\"),","            xScaleFactor = dataWidth / (xMax - xMin),","			yScaleFactor = dataHeight / (yMax - yMin),","            dataLength,","            direction = this.get(\"direction\"),","            i = 0,","            xMarkerPlane = [],","            yMarkerPlane = [],","            xMarkerPlaneOffset = this.get(\"xMarkerPlaneOffset\"),","            yMarkerPlaneOffset = this.get(\"yMarkerPlaneOffset\"),","            graphic = this.get(\"graphic\");","        graphic.set(\"width\", w);","        graphic.set(\"height\", h);","        dataLength = xData.length;","        xOffset *= 0.5;","        yOffset *= 0.5;","        //Assuming a vertical graph has a range/category for its vertical axis.    ","        if(direction === \"vertical\")","        {","            yData = yData.reverse();","        }","        this._leftOrigin = Math.round(((0 - xMin) * xScaleFactor) + leftPadding + xOffset);","        this._bottomOrigin = Math.round((dataHeight + topPadding + yOffset)); ","        if(yMin < 0)","        {","            this._bottomOrigin = this._bottomOrigin - ((0 - yMin) * yScaleFactor);","        }","        for (; i < dataLength; ++i) ","		{","            xValue = parseFloat(xData[i]);","            yValue = parseFloat(yData[i]);","            if(isNumber(xValue))","            {","                nextX = (((xValue - xMin) * xScaleFactor) + leftPadding + xOffset);","            }","            else","            {","                nextX = NaN;","            }","            if(isNumber(yValue))","            {","			    nextY = ((dataHeight + topPadding + yOffset) - (yValue - yMin) * yScaleFactor);","            }","            else","            {","                nextY = NaN;","            }","            xcoords.push(nextX);","            ycoords.push(nextY);","            xMarkerPlane.push({start:nextX - xMarkerPlaneOffset, end: nextX + xMarkerPlaneOffset});","            yMarkerPlane.push({start:nextY - yMarkerPlaneOffset, end: nextY + yMarkerPlaneOffset});","        }","        this.set(\"xcoords\", xcoords);","		this.set(\"ycoords\", ycoords);","        this.set(\"xMarkerPlane\", xMarkerPlane);","        this.set(\"yMarkerPlane\", yMarkerPlane);","        this._dataLength = dataLength;","    },","","    /**","     * Finds the first valid index of an array coordinates.","     *","     * @method _getFirstValidIndex","     * @param {Array} coords An array of x or y coordinates.","     * @return Number","     * @private","     */","    _getFirstValidIndex: function(coords)","    {","        var coord,","            i = -1,","            limit = coords.length;","        while(!Y_Lang.isNumber(coord) && i < limit)","        {","            i += 1;","            coord = coords[i];","        }","        return i;","    },","","    /**","     * Finds the last valid index of an array coordinates.","     *","     * @method _getLastValidIndex","     * @param {Array} coords An array of x or y coordinates.","     * @return Number","     * @private","     */","    _getLastValidIndex: function(coords)","    {","        var coord,","            i = coords.length,","            limit = -1;","        while(!Y_Lang.isNumber(coord) && i > limit)","        {","            i -= 1;","            coord = coords[i];","        }","        return i;","    },","","    /**","     * Draws the series.","     *","     * @method draw","     * @protected","     */","    draw: function()","    {","        var graph = this.get(\"graph\"),","            w = graph.get(\"width\"),","            h = graph.get(\"height\");","        if(this.get(\"rendered\"))","        {","            if((isFinite(w) && isFinite(h) && w > 0 && h > 0) && ((this.get(\"xData\") && this.get(\"yData\")) || this._updateAxisData()))","            {","                if(this._drawing)","                {","                    this._callLater = true;","                    return;","                }","                this._drawing = true;","                this._callLater = false;","                this.setAreaData();","                if(this.get(\"xcoords\") && this.get(\"ycoords\"))","                {","                    this.drawSeries();","                }","                this._drawing = false;","                if(this._callLater)","                {","                    this.draw();","                }","                else","                {","                    this._toggleVisible(this.get(\"visible\"));","                    this.fire(\"drawingComplete\");","                }","            }","        }","    },","    ","    /**","     * Default value for plane offsets when the parent chart's `interactiveType` is `planar`. ","     *","     * @property _defaultPlaneOffset","     * @type Number","     * @private","     */","    _defaultPlaneOffset: 4,","    ","    /**","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     * @protected","     */","    _getDefaultStyles: function()","    {","        return {padding:{","                top: 0,","                left: 0,","                right: 0,","                bottom: 0","            }};","    },","","    /**","     * Collection of default colors used for lines in a series when not specified by user.","     *","     * @property _defaultLineColors","     * @type Array","     * @protected","     */","    _defaultLineColors:[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"],","","    /**","     * Collection of default colors used for marker fills in a series when not specified by user.","     *","     * @property _defaultFillColors","     * @type Array","     * @protected","     */","    _defaultFillColors:[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"],","    ","    /**","     * Collection of default colors used for marker borders in a series when not specified by user.","     *","     * @property _defaultBorderColors","     * @type Array","     * @protected","     */","    _defaultBorderColors:[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"],","    ","    /**","     * Collection of default colors used for area fills, histogram fills and pie fills in a series when not specified by user.","     *","     * @property _defaultSliceColors","     * @type Array","     * @protected","     */","    _defaultSliceColors: [\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"],","","    /**","     * Parses a color based on a series order and type.","     *","     * @method _getDefaultColor","     * @param {Number} index Index indicating the series order.","     * @param {String} type Indicates which type of object needs the color.","     * @return String","     * @protected","     */","    _getDefaultColor: function(index, type)","    {","        var colors = {","                line: this._defaultLineColors,","                fill: this._defaultFillColors,","                border: this._defaultBorderColors,","                slice: this._defaultSliceColors","            },","            col = colors[type],","            l = col.length;","        index = index || 0;","        if(index >= l)","        {","            index = index % l;","        }","        type = type || \"fill\";","        return colors[type][index];","    },","    ","    /**","     * Shows/hides contents of the series.","     *","     * @method _handleVisibleChange","     * @param {Object} e Event object.","     * @protected","     */","    _handleVisibleChange: function(e) ","    {","        this._toggleVisible(this.get(\"visible\"));","    },","","    /**","     * Returns the sum of all values for the series.","     *","     * @method getTotalValues","     * @return Number","     */","    getTotalValues: function()","    {","        var total = this.get(\"valueAxis\").getTotalByKey(this.get(\"valueKey\"));","        return total;","    },","","    /**","     * Destructor implementation for the CartesianSeries class. Calls destroy on all Graphic instances.","     *","     * @method destructor","     * @protected","     */","    destructor: function()","    {","        var marker,","            markers = this.get(\"markers\");","        if(this.get(\"rendered\"))","        {","            if(this._xDataReadyHandle)","            {","                this._xDataReadyHandle.detach();","            }","            if(this._xDataUpdateHandle)","            {","                this._xDataUpdateHandle.detach();","            }","            if(this._yDataReadyHandle)","            {","                this._yDataReadyHandle.detach();","            }","            if(this._yDataUpdateHandle)","            {","                this._yDataUpdateHandle.detach();","            }","            this._xAxisChangeHandle.detach();","            this._yAxisChangeHandle.detach();","            this._stylesChangeHandle.detach();","            this._widthChangeHandle.detach();","            this._heightChangeHandle.detach();","            this._visibleChangeHandle.detach();","        }","        while(markers && markers.length > 0)","        {","            marker = markers.shift();","            if(marker && marker instanceof Y.Shape)","            {","                marker.destroy();","            }","        }","        if(this._path)","        {","            this._path.destroy();","            this._path = null;","        }","        if(this._lineGraphic)","        {","            this._lineGraphic.destroy();","            this._lineGraphic = null;","        }","        if(this._groupMarker)","        {","            this._groupMarker.destroy();","            this._groupMarker = null;","        }","    }","        /**","         * Event handle for the x-axis' dataReady event.","         * ","         * @property _xDataReadyHandle","         * @type {EventHandle}","         * @private","         */","        ","        /**","         * Event handle for the x-axis dataUpdate event.","         *","         * @property _xDataUpdateHandle","         * @type {EventHandle}","         * @private","         */","        ","        /**","         * Event handle for the y-axis dataReady event.","         *","         * @property _yDataReadyHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the y-axis dataUpdate event.","         * @property _yDataUpdateHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the xAxisChange event.","         * @property _xAxisChangeHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the yAxisChange event.","         * @property _yAxisChangeHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the stylesChange event.","         * @property _stylesChangeHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the widthChange event.","         * @property _widthChangeHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the heightChange event.","         * @property _heightChangeHandle","         * @type {EventHandle}","         * @private","         */","","        /**","         * Event handle for the visibleChange event.","         * @property _visibleChangeHandle","         * @type {EventHandle}","         * @private","         */","}, {","    ATTRS: {","        /**","         * Name used for for displaying data related to the x-coordinate.","         *","         * @attribute xDisplayName","         * @type String","         */","        xDisplayName: {","            getter: function()","            {","                return this._xDisplayName || this.get(\"xKey\");","            },","","            setter: function(val)","            {","                this._xDisplayName = val.toString();","                return val;","            }","        },","","        /**","         * Name used for for displaying data related to the y-coordinate.","         *","         * @attribute yDisplayName","         * @type String","         */","        yDisplayName: {","            getter: function()","            {","                return this._yDisplayName || this.get(\"yKey\");","            },","","            setter: function(val)","            {","                this._yDisplayName = val.toString();","                return val;","            }","        },","        ","        /**","         * Name used for for displaying category data","         *","         * @attribute categoryDisplayName","         * @type String","         * @readOnly","         */","        categoryDisplayName: {","            lazyAdd: false,","","            getter: function()","            {","                return this.get(\"direction\") == \"vertical\" ? this.get(\"yDisplayName\") : this.get(\"xDisplayName\");","           },","","            setter: function(val)","            {","                if(this.get(\"direction\") == \"vertical\")","                {","                    this._yDisplayName = val;","                }","                else","                {","                    this._xDisplayName = val;","                }","                return val;","            }","        },","","        /**","         * Name used for for displaying value data","         *","         * @attribute valueDisplayName","         * @type String","         * @readOnly","         */","        valueDisplayName: {","            lazyAdd: false,","","            getter: function()","            {","                return this.get(\"direction\") == \"vertical\" ? this.get(\"xDisplayName\") : this.get(\"yDisplayName\");","            },","","            setter: function(val)","            {","                if(this.get(\"direction\") == \"vertical\")","                {","                    this._xDisplayName = val;","                }","                else","                {","                    this._yDisplayName = val;","                }","                return val;","            }","        },","        ","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default cartesian","         */","        type: {		","            value: \"cartesian\"","        },","","        /**","         * Order of this instance of this `type`.","         *","         * @attribute order","         * @type Number","         */","        order: {},","","        /**","         * Order of the instance","         *","         * @attribute graphOrder","         * @type Number","         */","        graphOrder: {},","","        /**","         * x coordinates for the series.","         *","         * @attribute xcoords","         * @type Array","         */","        xcoords: {},","        ","        /**","         * y coordinates for the series","         *","         * @attribute ycoords","         * @type Array","         */","        ycoords: {},","","        /**","         * Reference to the `Chart` application.","         *","         * @attribute chart","         * @type ChartBase","         * @readOnly","         */","        chart: {","            readOnly: true,","","            getter: function()","            {","                return this.get(\"graph\").get(\"chart\");","            }","        },","        ","        /**","         * Reference to the `Graph` in which the series is drawn into.","         *","         * @attribute graph","         * @type Graph","         */","        graph: {},","","        /**","         * Reference to the `Axis` instance used for assigning ","         * x-values to the graph.","         *","         * @attribute xAxis","         * @type Axis","         */","        xAxis: {},","        ","        /**","         * Reference to the `Axis` instance used for assigning ","         * y-values to the graph.","         *","         * @attribute yAxis","         * @type Axis","         */","        yAxis: {},","        ","        /**","         * Indicates which array to from the hash of value arrays in ","         * the x-axis `Axis` instance.","         *","         * @attribute xKey","         * @type String","         */","        xKey: {","            setter: function(val)","            {","                return val.toString();","            }","        },","","        /**","         * Indicates which array to from the hash of value arrays in ","         * the y-axis `Axis` instance.","         *","         * @attribute yKey","         * @type String","         */","        yKey: {","            setter: function(val)","            {","                return val.toString();","            }","        },","","        /**","         * Array of x values for the series.","         *","         * @attribute xData","         * @type Array","         */","        xData: {},","","        /**","         * Array of y values for the series.","         *","         * @attribute yData","         * @type Array","         */","        yData: {},","       ","        /**","         * Indicates whether the Series has been through its initial set up.","         *","         * @attribute rendered","         * @type Boolean","         */","        rendered: {","            value: false","        },","","        /*","         * Returns the width of the parent graph","         *","         * @attribute width","         * @type Number","         */","        width: {","            readOnly: true,","            ","            getter: function()","            {","                this.get(\"graph\").get(\"width\");","            }","        },","","        /**","         * Returns the height of the parent graph","         *","         * @attribute height","         * @type Number","         */","        height: {","            readOnly: true,","            ","            getter: function()","            {","                this.get(\"graph\").get(\"height\");","            }","        },","","        /**","         * Indicates whether to show the series","         *","         * @attribute visible","         * @type Boolean","         * @default true","         */","        visible: {","            value: true","        },","","        /**","         * Collection of area maps along the xAxis. Used to determine mouseover for multiple","         * series.","         *","         * @attribute xMarkerPlane","         * @type Array","         */","        xMarkerPlane: {},","        ","        /**","         * Collection of area maps along the yAxis. Used to determine mouseover for multiple","         * series.","         *","         * @attribute yMarkerPlane","         * @type Array","         */","        yMarkerPlane: {},","","        /**","         * Distance from a data coordinate to the left/right for setting a hotspot.","         *","         * @attribute xMarkerPlaneOffset","         * @type Number","         */","        xMarkerPlaneOffset: {","            getter: function() {","                var marker = this.get(\"styles\").marker;","                if(marker && marker.width && isFinite(marker.width))","                {","                    return marker.width * 0.5;","                }","                return this._defaultPlaneOffset;","            }","        },","","        /**","         * Distance from a data coordinate to the top/bottom for setting a hotspot.","         *","         * @attribute yMarkerPlaneOffset","         * @type Number","         */","        yMarkerPlaneOffset: {","            getter: function() {","                var marker = this.get(\"styles\").marker;","                if(marker && marker.height && isFinite(marker.height))","                {","                    return marker.height * 0.5;","                }","                return this._defaultPlaneOffset;","            }","        },","","        /**","         * Direction of the series","         *","         * @attribute direction","         * @type String","         */","        direction: {","            value: \"horizontal\"","        },","","        /**","         * Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.","         *","         * @attribute groupMarkers","         * @type Boolean","         */","        groupMarkers: {","            getter: function()","            {","                if(this._groupMarkers === undefined)","                {","                    return this.get(\"graph\").get(\"groupMarkers\");","                }","                else","                {","                    return this._groupMarkers;","                }","            },","","            setter: function(val)","            {","                this._groupMarkers = val;","                return val;","            }","        }","    }","});","/**"," * The MarkerSeries class renders quantitative data by plotting relevant data points "," * on a graph."," *"," * @module charts"," * @submodule charts-base"," * @class MarkerSeries"," * @extends CartesianSeries"," * @uses Plots"," * @constructor"," */","Y.MarkerSeries = Y.Base.create(\"markerSeries\", Y.CartesianSeries, [Y.Plots], {","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this.drawPlots();","    },","    ","    /**","     * @protected","     *","     * Method used by `styles` setter. Overrides base implementation.","     *","     * @method _setStyles","     * @param {Object} newStyles Hash of properties to update.","     * @return Object","     */","    _setStyles: function(val)","    {","        if(!val.marker)","        {","            val = {marker:val};","        }","        val = this._parseMarkerStyles(val);","        return Y.MarkerSeries.superclass._mergeStyles.apply(this, [val, this._getDefaultStyles()]);","    },","    ","    /**","     * @protected","     *","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     */","    _getDefaultStyles: function()","    {","        var styles = this._mergeStyles({marker:this._getPlotDefaults()}, Y.MarkerSeries.superclass._getDefaultStyles());","        return styles;","    }","},{","    ATTRS : {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default marker","         */","        type: {","            value:\"marker\"","        }","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `Renderer`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>","         *      <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","/**"," * The LineSeries class renders quantitative data on a graph by connecting relevant data points."," *"," * @module charts"," * @submodule charts-base"," * @class LineSeries"," * @extends CartesianSeries"," * @uses Lines"," * @constructor"," */","Y.LineSeries = Y.Base.create(\"lineSeries\", Y.CartesianSeries, [Y.Lines], {","    /**","     * @protected","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this.drawLines();","    },","","    /**","     * @protected","     *","     * Method used by `styles` setter. Overrides base implementation.","     *","     * @method _setStyles","     * @param {Object} newStyles Hash of properties to update.","     * @return Object","     */","    _setStyles: function(val)","    {","        if(!val.line)","        {","            val = {line:val};","        }","        return Y.LineSeries.superclass._setStyles.apply(this, [val]);","    },","","    /**","     * @protected","     *","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     */","    _getDefaultStyles: function()","    {","        var styles = this._mergeStyles({line:this._getLineDefaults()}, Y.LineSeries.superclass._getDefaultStyles());","        return styles;","    }","},","{","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default line","         */","        type: {","            value:\"line\"","        }","","        /**","         * Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the default values:","         *  <dl>","         *      <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color will be","         *      retrieved from the following array: ","         *      `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`","         *      <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>","         *      <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd> ","         *      <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *      <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value between points. The default value is true.</dd> ","         *      <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default value is solid.</dd>","         *      <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","","","		","","		","/**"," * SplineSeries renders a graph with data points connected by a curve."," *"," * @module charts"," * @submodule charts-base"," * @class SplineSeries"," * @constructor"," * @extends CartesianSeries"," * @uses CurveUtil"," * @uses Lines"," */","Y.SplineSeries = Y.Base.create(\"splineSeries\",  Y.LineSeries, [Y.CurveUtil, Y.Lines], {","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this.drawSpline();","    }","}, {","	ATTRS : {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default spline","         */","        type : {","            value:\"spline\"","        }","","        /**","         * Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the default values:","         *  <dl>","         *      <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color will be","         *      retrieved from the following array: ","         *      `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`","         *      <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>","         *      <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd> ","         *      <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *      <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value between points. The default value is true.</dd> ","         *      <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default value is solid.</dd>","         *      <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","","","		","","		","/**"," * StackedSplineSeries creates spline graphs in which the different series are stacked along a value axis"," * to indicate their contribution to a cumulative total."," *"," * @module charts"," * @submodule charts-base"," * @class StackedSplineSeries"," * @constructor"," * @extends SplineSeries"," * @extends StackingUtil"," */","Y.StackedSplineSeries = Y.Base.create(\"stackedSplineSeries\", Y.SplineSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Calculates the coordinates for the series. Overrides base implementation.","     *","     * @method setAreaData","     */","    setAreaData: function()","    {   ","        Y.StackedSplineSeries.superclass.setAreaData.apply(this);","        this._stackCoordinates.apply(this);","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedSpline","         */","        type: {","            value:\"stackedSpline\"","        }","    }","});","","/**"," * StackedMarkerSeries plots markers with different series stacked along the value axis to indicate each"," * series' contribution to a cumulative total."," *"," * @module charts"," * @submodule charts-base"," * @class StackedMarkerSeries"," * @constructor"," * @extends MarkerSeries"," * @extends StackingUtil"," */","Y.StackedMarkerSeries = Y.Base.create(\"stackedMarkerSeries\", Y.MarkerSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Calculates the coordinates for the series. Overrides base implementation.","     *","     * @method setAreaData","     */","    setAreaData: function()","    {   ","        Y.StackedMarkerSeries.superclass.setAreaData.apply(this);","        this._stackCoordinates.apply(this);","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedMarker","         */","        type: {","            value:\"stackedMarker\"","        }","    }","});","","/**"," * The ColumnSeries class renders columns positioned horizontally along a category or time axis. The columns'"," * lengths are proportional to the values they represent along a vertical axis."," * and the relevant data points."," *"," * @module charts"," * @submodule charts-base"," * @class ColumnSeries"," * @extends MarkerSeries"," * @uses Histogram"," * @constructor"," */","Y.ColumnSeries = Y.Base.create(\"columnSeries\", Y.MarkerSeries, [Y.Histogram], {","    /**","     * Helper method for calculating the size of markers. ","     *","     * @method _getMarkerDimensions","     * @param {Number} xcoord The x-coordinate representing the data point for the marker.","     * @param {Number} ycoord The y-coordinate representing the data point for the marker.","     * @param {Number} calculatedSize The calculated size for the marker. For a `BarSeries` is it the width. For a `ColumnSeries` it is the height.","     * @param {Number} offset Distance of position offset dictated by other marker series in the same graph.","     * @return Object","     * @private","     */","    _getMarkerDimensions: function(xcoord, ycoord, calculatedSize, offset)","    {","        var config = {","            left: xcoord + offset","        };","        if(this._bottomOrigin >= ycoord)","        {","            config.top = ycoord;","            config.calculatedSize = this._bottomOrigin - config.top;","        }","        else","        {","            config.top = this._bottomOrigin;","            config.calculatedSize = ycoord - this._bottomOrigin;","        }","        return config;","    },","","    /**","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     * @protected","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers && this._markers[i])","        {","            var styles = Y.clone(this.get(\"styles\").marker),","                markerStyles,","                state = this._getState(type),","                xcoords = this.get(\"xcoords\"),","                ycoords = this.get(\"ycoords\"),","                marker = this._markers[i],","                markers,","                graph = this.get(\"graph\"),","                seriesStyles,","                seriesCollection = graph.seriesTypes[this.get(\"type\")],","                seriesLen = seriesCollection.length,","                seriesSize = 0,","                offset = 0,","                renderer,","                n = 0,","                xs = [],","                order = this.get(\"order\"),","                config;","            markerStyles = state == \"off\" || !styles[state] ? Y.clone(styles) : Y.clone(styles[state]); ","            markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);","            markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);","            config = this._getMarkerDimensions(xcoords[i], ycoords[i], styles.width, offset);","            markerStyles.height = config.calculatedSize;","            markerStyles.width = Math.min(this._maxSize, markerStyles.width);","            marker.set(markerStyles);","            for(; n < seriesLen; ++n)","            {","                xs[n] = xcoords[i] + seriesSize;","                seriesStyles = seriesCollection[n].get(\"styles\").marker;","                seriesSize += Math.min(this._maxSize, seriesStyles.width);","                if(order > n)","                {","                    offset = seriesSize;","                }","                offset -= seriesSize/2;","            }","            for(n = 0; n < seriesLen; ++n)","            {","                markers = seriesCollection[n].get(\"markers\");","                if(markers)","                {","                    renderer = markers[i];","                    if(renderer && renderer !== undefined)","                    {","                        renderer.set(\"x\", (xs[n] - seriesSize/2));","                    }","                }","            }","        }","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @readOnly","         * @default column","         */","        type: {","            value: \"column\"","        }","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 12.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","/**"," * The BarSeries class renders bars positioned vertically along a category or time axis. The bars'"," * lengths are proportional to the values they represent along a horizontal axis."," * and the relevant data points."," *"," * @module charts"," * @submodule charts-base"," * @class BarSeries"," * @extends MarkerSeries"," * @uses Histogram"," * @constructor"," */","Y.BarSeries = Y.Base.create(\"barSeries\", Y.MarkerSeries, [Y.Histogram], {","    /**","     * Helper method for calculating the size of markers. ","     *","     * @method _getMarkerDimensions","     * @param {Number} xcoord The x-coordinate representing the data point for the marker.","     * @param {Number} ycoord The y-coordinate representing the data point for the marker.","     * @param {Number} calculatedSize The calculated size for the marker. For a `BarSeries` is it the width. For a `ColumnSeries` it is the height.","     * @param {Number} offset Distance of position offset dictated by other marker series in the same graph.","     * @return Object","     * @private","     */","    _getMarkerDimensions: function(xcoord, ycoord, calculatedSize, offset)","    {","        var config = {","            top: ycoord + offset","        };","        if(xcoord >= this._leftOrigin)","        {","            config.left = this._leftOrigin;","            config.calculatedSize = xcoord - config.left;","        }","        else","        {","            config.left = xcoord;","            config.calculatedSize = this._leftOrigin - xcoord;","        }","        return config;","    },","    ","    /**","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     * @protected","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers && this._markers[i])","        {","            var styles = Y.clone(this.get(\"styles\").marker),","                markerStyles,","                state = this._getState(type),","                xcoords = this.get(\"xcoords\"),","                ycoords = this.get(\"ycoords\"),","                marker = this._markers[i],","                markers,","                graph = this.get(\"graph\"),","                seriesCollection = graph.seriesTypes[this.get(\"type\")],","                seriesLen = seriesCollection.length,","                seriesStyles,","                seriesSize = 0,","                offset = 0,","                renderer,","                n = 0,","                ys = [],","                order = this.get(\"order\"),","                config;","            markerStyles = state == \"off\" || !styles[state] ? styles : styles[state]; ","            markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);","            markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);","            config = this._getMarkerDimensions(xcoords[i], ycoords[i], styles.height, offset);","            markerStyles.width = config.calculatedSize;","            markerStyles.height = Math.min(this._maxSize, markerStyles.height);","            marker.set(markerStyles);","            for(; n < seriesLen; ++n)","            {","                ys[n] = ycoords[i] + seriesSize;","                seriesStyles = seriesCollection[n].get(\"styles\").marker;","                seriesSize += Math.min(this._maxSize, seriesStyles.height); ","                if(order > n)","                {","                    offset = seriesSize;","                }","                offset -= seriesSize/2;","            }","            for(n = 0; n < seriesLen; ++n)","            {","                markers = seriesCollection[n].get(\"markers\");","                if(markers)","                {","                    renderer = markers[i];","                    if(renderer && renderer !== undefined)","                    {","                        renderer.set(\"y\", (ys[n] - seriesSize/2));","                    }","                }","            }","        }","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default bar","         */","        type: {","            value: \"bar\"","        },","","        /**","         * Indicates the direction of the category axis that the bars are plotted against.","         *","         * @attribute direction","         * @type String","         */","        direction: {","            value: \"vertical\"","        }","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>height</dt><dd>indicates the width of the marker. The default value is 12.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","/**"," * The AreaSeries class renders quantitative data on a graph by creating a fill between 0"," * and the relevant data points."," *"," * @module charts"," * @submodule charts-base"," * @class AreaSeries"," * @extends CartesianSeries"," * @uses Fills"," * @constructor"," */","Y.AreaSeries = Y.Base.create(\"areaSeries\", Y.CartesianSeries, [Y.Fills], {","    /**","     * @protected","     *","     * Renders the series. ","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this.drawFill.apply(this, this._getClosingPoints());","    },","    ","    /**","     * @protected","     *","     * Method used by `styles` setter. Overrides base implementation.","     *","     * @method _setStyles","     * @param {Object} newStyles Hash of properties to update.","     * @return Object","     */","    _setStyles: function(val)","    {","        if(!val.area)","        {","            val = {area:val};","        }","        return Y.AreaSeries.superclass._setStyles.apply(this, [val]);","    },","","    /**","     * @protected","     *","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     */","    _getDefaultStyles: function()","    {","        var styles = this._mergeStyles({area:this._getAreaDefaults()}, Y.AreaSeries.superclass._getDefaultStyles());","        return styles;","    }","},","{","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default area","         */","        type: {","            value:\"area\"","        }","        ","        /**","         * Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:","         *","         *  <dl>","         *      <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be ","         *      retrieved from the following array:","         *      `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *      </dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","","","		","","		","/**"," * AreaSplineSeries renders an area graph with data points connected by a curve."," *"," * @module charts"," * @submodule charts-base"," * @class AreaSplineSeries"," * @constructor"," * @extends CartesianSeries"," * @uses Fills"," * @uses CurveUtil"," */","Y.AreaSplineSeries = Y.Base.create(\"areaSplineSeries\", Y.AreaSeries, [Y.CurveUtil], {","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this.drawAreaSpline();","    }","}, {","	ATTRS : {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default areaSpline","         */","        type: {","            value:\"areaSpline\"","        }","        ","        /**","         * Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:","         *","         *  <dl>","         *      <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be ","         *      retrieved from the following array:","         *      `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *      </dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","/**"," * StackedAreaSplineSeries creates a stacked area chart with points data points connected by a curve."," *"," * @module charts"," * @submodule charts-base"," * @class StackedAreaSplineSeries"," * @constructor"," * @extends AreaSeries"," * @uses CurveUtil"," * @uses StackingUtil"," */","Y.StackedAreaSplineSeries = Y.Base.create(\"stackedAreaSplineSeries\", Y.AreaSeries, [Y.CurveUtil, Y.StackingUtil], {","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        this._stackCoordinates();","        this.drawStackedAreaSpline();","    }","}, {","    ATTRS : {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedAreaSpline","         */","        type: {","            value:\"stackedAreaSpline\"","        }","    }","});","","/**"," * The ComboSeries class renders a combination of lines, plots and area fills in a single series. Each"," * series type has a corresponding boolean attribute indicating if it is rendered. By default, lines and plots "," * are rendered and area is not. "," *"," * @module charts"," * @submodule charts-base"," * @class ComboSeries"," * @extends CartesianSeries "," * @uses Fills"," * @uses Lines"," * @uses Plots"," * @constructor"," */","Y.ComboSeries = Y.Base.create(\"comboSeries\", Y.CartesianSeries, [Y.Fills, Y.Lines, Y.Plots], {","	/**","     * @protected","     * ","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        if(this.get(\"showAreaFill\"))","        {","            this.drawFill.apply(this, this._getClosingPoints());","        }","        if(this.get(\"showLines\")) ","        {","            this.drawLines();","        }","        if(this.get(\"showMarkers\"))","        {","            this.drawPlots();","        }   ","    },","    ","    /**","     * Toggles visibility","     *","     * @method _toggleVisible","     * @param {Boolean} visible indicates visibilitye","     * @private","     */","    _toggleVisible: function(visible)","    {","        var markers,","            marker,","            len,","            i;","        if(this.get(\"showAreaFill\") && this._path)","        {","            this._path.set(\"visible\", visible);","        }","        if(this.get(\"showLines\") && this._lineGraphic)","        {","            this._lineGraphic.set(\"visible\", visible);","        }","        if(this.get(\"showMarkers\"))","        {","            markers = this.get(\"markers\");","            if(markers)","            {","                i = 0;","                len = markers.length;","                for(; i < len; ++i)","                {","                    marker = markers[i];","                    if(marker)","                    {","                        marker.set(\"visible\", visible);","                    }","                }","            }","        }","    },","","    /**","     * @protected","     *","     * Returns the default hash for the `styles` attribute.","     *","     * @method _getDefaultStyles","     * @return Object","     */","    _getDefaultStyles: function()","    {","        var styles = Y.ComboSeries.superclass._getDefaultStyles();","        styles.line = this._getLineDefaults();","        styles.marker = this._getPlotDefaults();","        styles.area = this._getAreaDefaults();","        return styles;","    }","},","{","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default combo","         */","        type: {","            value:\"combo\"","        },","","        /**","         * Indicates whether a fill is displayed.","         *","         * @attribute showAreaFill","         * @type Boolean","         * @default false","         */","        showAreaFill: {","            value: false","        },","","        /**","         * Indicates whether lines are displayed.","         *","         * @attribute showLines","         * @type Boolean","         * @default true","         */","        showLines: {","            value: true","        },","","        /**","         * Indicates whether markers are displayed.","         *","         * @attribute showMarkers","         * @type Boolean","         * @default true","         */","        showMarkers: {","            value: true","        },","","        /**","         * Reference to the styles of the markers. These styles can also","         * be accessed through the `styles` attribute. Below are default","         * values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>","         *      <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute marker","         * @type Object","         */","        marker: {","            lazyAdd: false,","            getter: function()","            {","                return this.get(\"styles\").marker;","            },","            setter: function(val)","            {","                this.set(\"styles\", {marker:val});","            }","        },","        ","        /**","         * Reference to the styles of the lines. These styles can also be accessed through the `styles` attribute.","         * Below are the default values:","         *  <dl>","         *      <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color will be","         *      retrieved from the following array: ","         *      `[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"]`","         *      <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>","         *      <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd> ","         *      <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *      <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value between points. The default value is true.</dd> ","         *      <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default value is solid.</dd>","         *      <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default value is 10.</dd>","         *      <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default value is 10.</dd>","         *  </dl>","         *","         * @attribute line","         * @type Object","         */","        line: {","            lazyAdd: false,","            getter: function()","            {","                return this.get(\"styles\").line;","            },","            setter: function(val)","            {","                this.set(\"styles\", {line:val});","            }","        },","        ","        /**","         * Reference to the styles of the area fills. These styles can also be accessed through the `styles` attribute.","         * Below are the default values:","         *","         *  <dl>","         *      <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be ","         *      retrieved from the following array:","         *      `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *      </dd>","         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>","         *  </dl>","         *","         * @attribute area","         * @type Object","         */","        area: {","            lazyAdd: false,","            getter: function()","            {","                return this.get(\"styles\").area;","            },","            setter: function(val)","            {","                this.set(\"styles\", {area:val});","            }","        }","","        /**","         * Style properties for the series. Contains a key indexed hash of the following:","         *  <dl>","         *      <dt>marker</dt><dd>Style properties for the markers in the series. Specific style attributes are listed","         *      <a href=\"#attr_marker\">here</a>.</dd>","         *      <dt>line</dt><dd>Style properties for the lines in the series. Specific","         *      style attributes are listed <a href=\"#attr_line\">here</a>.</dd>","         *      <dt>area</dt><dd>Style properties for the area fills in the series. Specific style attributes are listed","         *      <a href=\"#attr_area\">here</a>.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","","","		","","		","/**"," * The StackedComboSeries class renders a combination of lines, plots and area fills in a single series. Series"," * are stacked along the value axis to indicate each series contribution to a cumulative total. Each"," * series type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are"," * rendered.  "," *"," * @module charts"," * @submodule charts-base"," * @class StackedComboSeries"," * @extends ComboSeries"," * @uses StackingUtil"," * @constructor"," */","Y.StackedComboSeries = Y.Base.create(\"stackedComboSeries\", Y.ComboSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Calculates the coordinates for the series. Overrides base implementation.","     *","     * @method setAreaData","     */","    setAreaData: function()","    {   ","        Y.StackedComboSeries.superclass.setAreaData.apply(this);","        this._stackCoordinates.apply(this);","    },","	","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        if(this.get(\"showAreaFill\"))","        {","            this.drawFill.apply(this, this._getStackedClosingPoints());","        }","        if(this.get(\"showLines\")) ","        {","            this.drawLines();","        }","        if(this.get(\"showMarkers\"))","        {","            this.drawPlots();","        }   ","    }","    ","}, {","    ATTRS : {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedCombo","         */","        type: {","            value: \"stackedCombo\"","        },","","        /**","         * Indicates whether a fill is displayed.","         *","         * @attribute showAreaFill","         * @type Boolean","         * @default true","         */","        showAreaFill: {","            value: true","        }","    }","});","/**"," * The ComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Each"," * series type has a corresponding boolean attribute indicating if it is rendered. By default, splines and plots "," * are rendered and areaspline is not. "," *"," * @module charts"," * @submodule charts-base"," * @class ComboSplineSeries"," * @extends ComboSeries"," * @extends CurveUtil"," * @constructor"," */","Y.ComboSplineSeries = Y.Base.create(\"comboSplineSeries\", Y.ComboSeries, [Y.CurveUtil], {","    /**","     * @protected","     * ","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","    {","        if(this.get(\"showAreaFill\"))","        {","            this.drawAreaSpline();","        }","        if(this.get(\"showLines\")) ","        {","            this.drawSpline();","        }","        if(this.get(\"showMarkers\"))","        {","            this.drawPlots();","        }   ","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default comboSpline","         */","        type: {","            value : \"comboSpline\"","        }","    }","});","/**"," * The StackedComboSplineSeries class renders a combination of splines, plots and areaspline fills in a single series. Series"," * are stacked along the value axis to indicate each series contribution to a cumulative total. Each"," * series type has a corresponding boolean attribute indicating if it is rendered. By default, all three types are"," * rendered.  "," *"," * @module charts"," * @submodule charts-base"," * @class StackedComboSplineSeries"," * @extends StackedComboSeries"," * @uses CurveUtil"," * @constructor"," */","Y.StackedComboSplineSeries = Y.Base.create(\"stackedComboSplineSeries\", Y.StackedComboSeries, [Y.CurveUtil], {","    /**","	 * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","	 */","	drawSeries: function()","    {","        if(this.get(\"showAreaFill\"))","        {","            this.drawStackedAreaSpline();","        }","        if(this.get(\"showLines\")) ","        {","            this.drawSpline();","        }","        if(this.get(\"showMarkers\"))","        {","            this.drawPlots();","        }   ","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedComboSpline","         */","        type : {","            value : \"stackedComboSpline\"","        },","","        /**","         * Indicates whether a fill is displayed.","         *","         * @attribute showAreaFill","         * @type Boolean","         * @default true","         */","        showAreaFill: {","            value: true","        }","    }","});","/**"," * StackedLineSeries creates line graphs in which the different series are stacked along a value axis"," * to indicate their contribution to a cumulative total."," *"," * @module charts"," * @submodule charts-base"," * @class StackedLineSeries"," * @constructor"," * @extends  LineSeries"," * @uses StackingUtil"," */","Y.StackedLineSeries = Y.Base.create(\"stackedLineSeries\", Y.LineSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Calculates the coordinates for the series. Overrides base implementation.","     *","     * @method setAreaData","     */","    setAreaData: function()","    {   ","        Y.StackedLineSeries.superclass.setAreaData.apply(this);","        this._stackCoordinates.apply(this);","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedLine","         */","        type: {","            value:\"stackedLine\"","        }","    }","});","/**"," * StackedAreaSeries area fills to display data showing its contribution to a whole."," *"," * @module charts"," * @submodule charts-base"," * @class StackedAreaSeries"," * @constructor"," * @param {Object} config (optional) Configuration parameters for the Chart."," * @extends AreaSeries"," * @uses StackingUtil"," */","Y.StackedAreaSeries = Y.Base.create(\"stackedAreaSeries\", Y.AreaSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Calculates the coordinates for the series. Overrides base implementation.","     *","     * @method setAreaData","     */","    setAreaData: function()","    {   ","        Y.StackedAreaSeries.superclass.setAreaData.apply(this);","        this._stackCoordinates.apply(this);","    },","","    /**","     * @protected","     *","     * Draws the series","     *","     * @method drawSeries","     */","	drawSeries: function()","    {","        this.drawFill.apply(this, this._getStackedClosingPoints());","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedArea","         */","        type: {","            value:\"stackedArea\"","        }","    }","});","/**"," * The StackedColumnSeries renders column chart in which series are stacked vertically to show"," * their contribution to the cumulative total."," *"," * @module charts"," * @submodule charts-base"," * @class StackedColumnSeries"," * @extends ColumnSeries"," * @uses StackingUtil"," * @constructor"," */","Y.StackedColumnSeries = Y.Base.create(\"stackedColumnSeries\", Y.ColumnSeries, [Y.StackingUtil], {","    /**","     * Draws the series.","     *","     * @method drawSeries","	 * @protected","	 */","	drawSeries: function()","	{","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","        var isNumber = Y_Lang.isNumber,","            style = Y.clone(this.get(\"styles\").marker), ","            w = style.width,","            h = style.height,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            i = 0,","            len = xcoords.length,","            top = ycoords[0],","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            seriesCollection = graph.seriesTypes[type],","            ratio,","            order = this.get(\"order\"),","            graphOrder = this.get(\"graphOrder\"),","            left,","            marker,","            fillColors,","            borderColors,","            lastCollection,","            negativeBaseValues,","            positiveBaseValues,","            useOrigin = order === 0,","            totalWidth = len * w,","            dimensions = {","                width: [],","                height: []","            },","            xvalues = [],","            yvalues = [],","            groupMarkers = this.get(\"groupMarkers\");","        if(Y_Lang.isArray(style.fill.color))","        {","            fillColors = style.fill.color.concat(); ","        }","        if(Y_Lang.isArray(style.border.color))","        {","            borderColors = style.border.color.concat();","        }","        this._createMarkerCache();","        if(totalWidth > this.get(\"width\"))","        {","            ratio = this.width/totalWidth;","            w *= ratio;","            w = Math.max(w, 1);","        }","        if(!useOrigin)","        {","            lastCollection = seriesCollection[order - 1];","            negativeBaseValues = lastCollection.get(\"negativeBaseValues\");","            positiveBaseValues = lastCollection.get(\"positiveBaseValues\");","            if(!negativeBaseValues || !positiveBaseValues)","            {","                useOrigin = true;","                positiveBaseValues = [];","                negativeBaseValues = [];","            }","        }","        else","        {","            negativeBaseValues = [];","            positiveBaseValues = [];","        }","        this.set(\"negativeBaseValues\", negativeBaseValues);","        this.set(\"positiveBaseValues\", positiveBaseValues);","        for(i = 0; i < len; ++i)","        {","            left = xcoords[i];","            top = ycoords[i];","            ","            if(!isNumber(top) || !isNumber(left))","            {","                if(useOrigin)","                {","                    negativeBaseValues[i] = this._bottomOrigin;","                    positiveBaseValues[i] = this._bottomOrigin;","                }","                this._markers.push(null); ","                continue;","            }","            if(useOrigin)","            {","                h = Math.abs(this._bottomOrigin - top);","                if(top < this._bottomOrigin)","                {","                    positiveBaseValues[i] = top;","                    negativeBaseValues[i] = this._bottomOrigin;","                }","                else if(top > this._bottomOrigin)","                {","                    positiveBaseValues[i] = this._bottomOrigin;","                    negativeBaseValues[i] = top;","                    top -= h;","                }","                else","                {","                    positiveBaseValues[i] = top;","                    negativeBaseValues[i] = top;","                }","            }","            else ","            {","                if(top > this._bottomOrigin)","                {","                    top += (negativeBaseValues[i] - this._bottomOrigin);","                    h = top - negativeBaseValues[i];","                    negativeBaseValues[i] = top;","                    top -= h;","                }","                else if(top <= this._bottomOrigin)","                {","                    top = positiveBaseValues[i] - (this._bottomOrigin - top);","                    h = positiveBaseValues[i] - top;","                    positiveBaseValues[i] = top;","                }","            }","            if(!isNaN(h) && h > 0)","            {","                left -= w/2;","                if(groupMarkers)","                {","                    dimensions.width[i] = w;","                    dimensions.height[i] = h;","                    xvalues.push(left);","                    yvalues.push(top);","                }","                else","                {","                    style.width = w;","                    style.height = h;","                    style.x = left;","                    style.y = top;","                    if(fillColors)","                    {","                        style.fill.color = fillColors[i % fillColors.length];","                    }","                    if(borderColors)","                    {","                        style.border.color = borderColors[i % borderColors.length];","                    }","                    marker = this.getMarker(style, graphOrder, i);","                }","            }","            else if(!groupMarkers)","            {","               this._markers.push(null);","            }","        }","        if(groupMarkers)","        {","            this._createGroupMarker({","                fill: style.fill,","                border: style.border,","                dimensions: dimensions,","                xvalues: xvalues,","                yvalues: yvalues,","                shape: style.shape","            });","        }","        else","        {","            this._clearMarkerCache();","        }","    },","","    /**","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     * @protected","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers && this._markers[i])","        {","            var styles,","                markerStyles,","                state = this._getState(type),","                xcoords = this.get(\"xcoords\"),","                marker = this._markers[i],","                offset = 0,","                fillColor,","                borderColor;        ","            styles = this.get(\"styles\").marker;","            offset = styles.width * 0.5;","            markerStyles = state == \"off\" || !styles[state] ? Y.clone(styles) : Y.clone(styles[state]); ","            markerStyles.height = marker.get(\"height\");","            markerStyles.x = (xcoords[i] - offset);","            markerStyles.y = marker.get(\"y\");","            markerStyles.id = marker.get(\"id\");","            fillColor = markerStyles.fill.color; ","            borderColor = markerStyles.border.color;","            if(Y_Lang.isArray(fillColor))","            {","                markerStyles.fill.color = fillColor[i % fillColor.length];","            }","            else","            {","                markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);","            }","            if(Y_Lang.isArray(borderColor))","            {","                markerStyles.border.color = borderColor[i % borderColor.length];","            }","            else","            {","                markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);","            }","            marker.set(markerStyles);","        }","    },","	","    /**","     * Gets the default values for the markers. ","     *","     * @method _getPlotDefaults","     * @return Object","     * @protected","     */","    _getPlotDefaults: function()","    {","        var defs = {","            fill:{","                type: \"solid\",","                alpha: 1,","                colors:null,","                alphas: null,","                ratios: null","            },","            border:{","                weight: 0,","                alpha: 1","            },","            width: 24,","            height: 24,","            shape: \"rect\",","","            padding:{","                top: 0,","                left: 0,","                right: 0,","                bottom: 0","            }","        };","        defs.fill.color = this._getDefaultColor(this.get(\"graphOrder\"), \"fill\");","        defs.border.color = this._getDefaultColor(this.get(\"graphOrder\"), \"border\");","        return defs;","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedColumn","         */","        type: {","            value: \"stackedColumn\"","        },","","        /**","         * @attribute negativeBaseValues","         * @type Array","         * @default null","         * @private","         */","        negativeBaseValues: {","            value: null","        },","","        /**","         * @attribute positiveBaseValues","         * @type Array","         * @default null","         * @private","         */","        positiveBaseValues: {","            value: null","        }","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `ColumnSeries`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 24.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","/**"," * The StackedBarSeries renders bar chart in which series are stacked horizontally to show"," * their contribution to the cumulative total."," *"," * @module charts"," * @submodule charts-base"," * @class StackedBarSeries"," * @extends BarSeries"," * @uses StackingUtil"," * @constructor"," */","Y.StackedBarSeries = Y.Base.create(\"stackedBarSeries\", Y.BarSeries, [Y.StackingUtil], {","    /**","     * @protected","     *","     * Draws the series.","     *","     * @method drawSeries","     */","    drawSeries: function()","	{","        if(this.get(\"xcoords\").length < 1) ","        {","            return;","        }","","        var isNumber = Y_Lang.isNumber,","            style = Y.clone(this.get(\"styles\").marker),","            w = style.width,","            h = style.height,","            xcoords = this.get(\"xcoords\"),","            ycoords = this.get(\"ycoords\"),","            i = 0,","            len = xcoords.length,","            top = ycoords[0],","            type = this.get(\"type\"),","            graph = this.get(\"graph\"),","            seriesCollection = graph.seriesTypes[type],","            ratio,","            order = this.get(\"order\"),","            graphOrder = this.get(\"graphOrder\"),","            left,","            marker,","            lastCollection,","            negativeBaseValues,","            positiveBaseValues,","            fillColors,","            borderColors,","            useOrigin = order === 0,","            totalHeight = len * h,","            dimensions = {","                width: [],","                height: []","            },","            xvalues = [],","            yvalues = [],","            groupMarkers = this.get(\"groupMarkers\");","        if(Y_Lang.isArray(style.fill.color))","        {","            fillColors = style.fill.color.concat(); ","        }","        if(Y_Lang.isArray(style.border.color))","        {","            borderColors = style.border.color.concat();","        }","        this._createMarkerCache();","        if(totalHeight > this.get(\"height\"))","        {","            ratio = this.height/totalHeight;","            h *= ratio;","            h = Math.max(h, 1);","        }","        if(!useOrigin)","        {","            lastCollection = seriesCollection[order - 1];","            negativeBaseValues = lastCollection.get(\"negativeBaseValues\");","            positiveBaseValues = lastCollection.get(\"positiveBaseValues\");","            if(!negativeBaseValues || !positiveBaseValues)","            {","                useOrigin = true;","                positiveBaseValues = [];","                negativeBaseValues = [];","            }","        }","        else","        {","            negativeBaseValues = [];","            positiveBaseValues = [];","        }","        this.set(\"negativeBaseValues\", negativeBaseValues);","        this.set(\"positiveBaseValues\", positiveBaseValues);","        for(i = 0; i < len; ++i)","        {","            top = ycoords[i];","            left = xcoords[i];","            if(!isNumber(top) || !isNumber(left))","            {","                if(useOrigin)","                {","                    positiveBaseValues[i] = this._leftOrigin;","                    negativeBaseValues[i] = this._leftOrigin;","                }","                this._markers.push(null);","                continue;","            }","            if(useOrigin)","            {","                w = Math.abs(left - this._leftOrigin);","                if(left > this._leftOrigin)","                {","                    positiveBaseValues[i] = left;","                    negativeBaseValues[i] = this._leftOrigin;","                    left -= w;","                }","                else if(left < this._leftOrigin)","                {   ","                    positiveBaseValues[i] = this._leftOrigin;","                    negativeBaseValues[i] = left;","                }","                else","                {","                    positiveBaseValues[i] = left;","                    negativeBaseValues[i] = this._leftOrigin;","                }","            }","            else","            {","                if(left < this._leftOrigin)","                {","                    left = negativeBaseValues[i] - (this._leftOrigin - xcoords[i]);","                    w = negativeBaseValues[i] - left;","                    negativeBaseValues[i] = left;","                }","                else if(left >= this._leftOrigin)","                {","                    left += (positiveBaseValues[i] - this._leftOrigin);","                    w = left - positiveBaseValues[i];","                    positiveBaseValues[i] = left;","                    left -= w;","                }","            }","            if(!isNaN(w) && w > 0)","            {","                top -= h/2;","                if(groupMarkers)","                {","                    dimensions.width[i] = w;","                    dimensions.height[i] = h;","                    xvalues.push(left);","                    yvalues.push(top);","                }","                else","                {","                    style.width = w;","                    style.height = h;","                    style.x = left;","                    style.y = top;","                    if(fillColors)","                    {","                        style.fill.color = fillColors[i % fillColors.length];","                    }","                    if(borderColors)","                    {","                        style.border.color = borderColors[i % borderColors.length];","                    }","                    marker = this.getMarker(style, graphOrder, i);","                }","            }","            else if(!groupMarkers)","            {","                this._markers.push(null);","            }","        }","        if(groupMarkers)","        {","            this._createGroupMarker({","                fill: style.fill,","                border: style.border,","                dimensions: dimensions,","                xvalues: xvalues,","                yvalues: yvalues,","                shape: style.shape","            });","        }","        else","        {","            this._clearMarkerCache();","        }","    },","","    /**","     * @protected","     *","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers[i])","        {","            var state = this._getState(type),","                ycoords = this.get(\"ycoords\"),","                marker = this._markers[i],","                styles = this.get(\"styles\").marker,","                h = styles.height,","                markerStyles = state == \"off\" || !styles[state] ? Y.clone(styles) : Y.clone(styles[state]), ","                fillColor,","                borderColor;        ","            markerStyles.y = (ycoords[i] - h/2);","            markerStyles.x = marker.get(\"x\");","            markerStyles.width = marker.get(\"width\");","            markerStyles.id = marker.get(\"id\");","            fillColor = markerStyles.fill.color; ","            borderColor = markerStyles.border.color;","            if(Y_Lang.isArray(fillColor))","            {","                markerStyles.fill.color = fillColor[i % fillColor.length];","            }","            else","            {","                markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);","            }","            if(Y_Lang.isArray(borderColor))","            {","                markerStyles.border.color = borderColor[i % borderColor.length];","            }","            else","            {","                markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);","            }","            marker.set(markerStyles);","        }","    },","	","    /**","     * @protected","     *","     * Returns default values for the `styles` attribute.","     * ","     * @method _getPlotDefaults","     * @return Object","     */","    _getPlotDefaults: function()","    {","        var defs = {","            fill:{","                type: \"solid\",","                alpha: 1,","                colors:null,","                alphas: null,","                ratios: null","            },","            border:{","                weight: 0,","                alpha: 1","            },","            width: 24,","            height: 24,","            shape: \"rect\",","","            padding:{","                top: 0,","                left: 0,","                right: 0,","                bottom: 0","            }","        };","        defs.fill.color = this._getDefaultColor(this.get(\"graphOrder\"), \"fill\");","        defs.border.color = this._getDefaultColor(this.get(\"graphOrder\"), \"border\");","        return defs;","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default stackedBar","         */","        type: {","            value: \"stackedBar\"","        },","","        /**","         * Direction of the series","         *","         * @attribute direction","         * @type String","         * @default vertical","         */","        direction: {","            value: \"vertical\"","        },","","        /**","         * @private","         *","         * @attribute negativeBaseValues","         * @type Array","         * @default null","         */","        negativeBaseValues: {","            value: null","        },","","        /**","         * @private","         *","         * @attribute positiveBaseValues","         * @type Array","         * @default null","         */","        positiveBaseValues: {","            value: null","        }","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `BarSeries`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *              </dd>","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color","         *              will be retrieved from the below array:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>height</dt><dd>indicates the width of the marker. The default value is 24.</dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","","/**"," * PieSeries visualizes data as a circular chart divided into wedges which represent data as a "," * percentage of a whole."," *"," * @module charts"," * @submodule charts-base"," * @class PieSeries"," * @constructor"," * @extends MarkerSeries"," */","Y.PieSeries = Y.Base.create(\"pieSeries\", Y.MarkerSeries, [], { ","    /**","     * Image map used for interactivity when rendered with canvas.","     *","     * @property _map","     * @type HTMLElement","     * @private","     */","    _map: null,","","    /**","     * Image used for image map when rendered with canvas.","     *","     * @property _image","     * @type HTMLElement","     * @private","     */","    _image: null,","","    /**","     * Creates or updates the image map when rendered with canvas.","     *","     * @method _setMap","     * @private","     */","    _setMap: function()","    {","        var id = \"pieHotSpotMapi_\" + Math.round(100000 * Math.random()),","            cb = this.get(\"graph\").get(\"contentBox\"),","            areaNode;","        if(this._image)","        {","            cb.removeChild(this._image);","            while(this._areaNodes && this._areaNodes.length > 0)","            {","                areaNode = this._areaNodes.shift();","                this._map.removeChild(areaNode);","            }","            cb.removeChild(this._map);","        }","        this._image = DOCUMENT.createElement(\"img\"); ","        this._image.src = \"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAYAAAABCAYAAAD9yd/wAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAABJJREFUeNpiZGBgSGPAAgACDAAIkABoFyloZQAAAABJRU5ErkJggg==\";","        cb.appendChild(this._image);","        this._image.setAttribute(\"usemap\", \"#\" + id);","        this._image.style.zIndex = 3;","        this._image.style.opacity = 0;","        this._image.setAttribute(\"alt\", \"imagemap\");","        this._map = DOCUMENT.createElement(\"map\");","        this._map.style.zIndex = 5;","        cb.appendChild(this._map);","        this._map.setAttribute(\"name\", id);","        this._map.setAttribute(\"id\", id);","        this._areaNodes = [];","    },","","    /**","     * Storage for `categoryDisplayName` attribute.","     *","     * @property _categoryDisplayName","     * @private","     */","    _categoryDisplayName: null,","    ","    /**","     * Storage for `valueDisplayName` attribute.","     *","     * @property _valueDisplayName","     * @private","     */","    _valueDisplayName: null,","","    /**","     * Adds event listeners.","     *","     * @method addListeners","     * @private","     */","    addListeners: function()","    {","        var categoryAxis = this.get(\"categoryAxis\"),","            valueAxis = this.get(\"valueAxis\");","        if(categoryAxis)","        {","            categoryAxis.after(\"dataReady\", Y.bind(this._categoryDataChangeHandler, this));","            categoryAxis.after(\"dataUpdate\", Y.bind(this._categoryDataChangeHandler, this));","        }","        if(valueAxis)","        {","            valueAxis.after(\"dataReady\", Y.bind(this._valueDataChangeHandler, this));","            valueAxis.after(\"dataUpdate\", Y.bind(this._valueDataChangeHandler, this));","        }","        this.after(\"categoryAxisChange\", this.categoryAxisChangeHandler);","        this.after(\"valueAxisChange\", this.valueAxisChangeHandler);","        this.after(\"stylesChange\", this._updateHandler);","    },","    ","    /**","     * Draws the series.","     *","     * @method validate","     * @private","     */","    validate: function()","    {","        this.draw();","        this._renderered = true;","    },","","    /**","     * Event handler for the categoryAxisChange event.","     *","     * @method _categoryAxisChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _categoryAxisChangeHandler: function(e)","    {","        var categoryAxis = this.get(\"categoryAxis\");","        categoryAxis.after(\"dataReady\", Y.bind(this._categoryDataChangeHandler, this));","        categoryAxis.after(\"dataUpdate\", Y.bind(this._categoryDataChangeHandler, this));","    },","    ","    /**","     * Event handler for the valueAxisChange event.","     *","     * @method _valueAxisChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _valueAxisChangeHandler: function(e)","    {","        var valueAxis = this.get(\"valueAxis\");","        valueAxis.after(\"dataReady\", Y.bind(this._valueDataChangeHandler, this));","        valueAxis.after(\"dataUpdate\", Y.bind(this._valueDataChangeHandler, this));","    },","	","    /**","     * Constant used to generate unique id.","     *","     * @property GUID","     * @type String","     * @private","     */","    GUID: \"pieseries\",","	","    /**","     * Event handler for categoryDataChange event.","     *","     * @method _categoryDataChangeHandler","     * @param {Object} event Event object.","     * @private ","     */","    _categoryDataChangeHandler: function(event)","    {","       if(this._rendered && this.get(\"categoryKey\") && this.get(\"valueKey\"))","        {","            this.draw();","        }","    },","","    /**","     * Event handler for valueDataChange event.","     *","     * @method _valueDataChangeHandler","     * @param {Object} event Event object.","     * @private ","     */","    _valueDataChangeHandler: function(event)","    {","        if(this._rendered && this.get(\"categoryKey\") && this.get(\"valueKey\"))","        {","            this.draw();","        }","    },","   ","    /**","     * Draws the series. Overrides the base implementation.","     *","     * @method draw","     * @protected","     */","    draw: function()","    {","        var graph = this.get(\"graph\"),","            w = graph.get(\"width\"),","            h = graph.get(\"height\");","        if(isFinite(w) && isFinite(h) && w > 0 && h > 0)","        {   ","            this._rendered = true;","            if(this._drawing)","            {","                this._callLater = true;","                return;","            }","            this._drawing = true;","            this._callLater = false;","            this.drawSeries();","            this._drawing = false;","            if(this._callLater)","            {","                this.draw();","            }","            else","            {","                this.fire(\"drawingComplete\");","            }","        }","    },","","    /**","     * Draws the markers","     *","     * @method drawPlots","     * @protected","     */","    drawPlots: function()","    {","        var values = this.get(\"valueAxis\").getDataByKey(this.get(\"valueKey\")).concat(),","            catValues = this.get(\"categoryAxis\").getDataByKey(this.get(\"categoryKey\")).concat(),","            totalValue = 0,","            itemCount = values.length,","            styles = this.get(\"styles\").marker,","            fillColors = styles.fill.colors,","            fillAlphas = styles.fill.alphas || [\"1\"],","            borderColors = styles.border.colors,","            borderWeights = [styles.border.weight],","            borderAlphas = [styles.border.alpha],","            tbw = borderWeights.concat(),","            tbc = borderColors.concat(),","            tba = borderAlphas.concat(),","            tfc,","            tfa,","            padding = styles.padding,","            graph = this.get(\"graph\"),","            minDimension = Math.min(graph.get(\"width\"), graph.get(\"height\")),","            w = minDimension - (padding.left + padding.right),","            h = minDimension - (padding.top + padding.bottom),","            startAngle = -90,","            halfWidth = w / 2,","            halfHeight = h / 2,","            radius = Math.min(halfWidth, halfHeight),","            i = 0,","            value,","            angle = 0,","            lc,","            la,","            lw,","            wedgeStyle,","            marker,","            graphOrder = this.get(\"graphOrder\"),","            isCanvas = Y.Graphic.NAME == \"canvasGraphic\";","        for(; i < itemCount; ++i)","        {","            value = parseFloat(values[i]);","            ","            values.push(value);","            if(!isNaN(value))","            {","                totalValue += value;","            }","        }","        ","        tfc = fillColors ? fillColors.concat() : null;","        tfa = fillAlphas ? fillAlphas.concat() : null;","        this._createMarkerCache();","        if(isCanvas)","        {","            this._setMap();","            this._image.width = w;","            this._image.height = h;","        }","        for(i = 0; i < itemCount; i++)","        {","            value = values[i];","            if(totalValue === 0)","            {","                angle = 360 / values.length;","            }","            else","            {","                angle = 360 * (value / totalValue);","            }","            if(tfc && tfc.length < 1)","            {","                tfc = fillColors.concat();","            }","            if(tfa && tfa.length < 1)","            {","                tfa = fillAlphas.concat();","            }","            if(tbw && tbw.length < 1)","            {","                tbw = borderWeights.concat();","            }","            if(tbw && tbc.length < 1)","            {","                tbc = borderColors.concat();","            }","            if(tba && tba.length < 1)","            {","                tba = borderAlphas.concat();","            }","            lw = tbw ? tbw.shift() : null;","            lc = tbc ? tbc.shift() : null;","            la = tba ? tba.shift() : null;","            startAngle += angle;","            wedgeStyle = {","                border: {","                    color:lc,","                    weight:lw,","                    alpha:la","                },","                fill: {","                    color:tfc ? tfc.shift() : this._getDefaultColor(i, \"slice\"),","                    alpha:tfa ? tfa.shift() : null","                },","                type: \"pieslice\",","                arc: angle,","                radius: radius,","                startAngle: startAngle,","                cx: halfWidth,","                cy: halfHeight,","                width: w,","                height: h","            };","            marker = this.getMarker(wedgeStyle, graphOrder, i);","            if(isCanvas)","            {","                this._addHotspot(wedgeStyle, graphOrder, i);","            }","        }","        this._clearMarkerCache();","    },","","    /**","     *  Adds an interactive map when rendering in canvas.","     *","     *  @method _addHotspot","     *  @param {Object} cfg Object containing data used to draw the hotspot","     *  @param {Number} seriesIndex Index of series in the `seriesCollection`.","     *  @param {Number} index Index of the marker using the hotspot.","     *  @private","     */","    _addHotspot: function(cfg, seriesIndex, index)","    {","        var areaNode = DOCUMENT.createElement(\"area\"),","            i = 1,","            x = cfg.cx,","            y = cfg.cy, ","            arc = cfg.arc,","            startAngle = cfg.startAngle - arc, ","            endAngle = cfg.startAngle,","            radius = cfg.radius, ","            ax = x + Math.cos(startAngle / 180 * Math.PI) * radius,","            ay = y + Math.sin(startAngle / 180 * Math.PI) * radius,","            bx = x + Math.cos(endAngle / 180 * Math.PI) * radius,","            by = y + Math.sin(endAngle / 180 * Math.PI) * radius,","            numPoints = Math.floor(arc/10) - 1,","            divAngle = (arc/(Math.floor(arc/10)) / 180) * Math.PI,","            angleCoord = Math.atan((ay - y)/(ax - x)),","            pts = x + \", \" + y + \", \" + ax + \", \" + ay,","            cosAng,","            sinAng,","            multDivAng;","        for(i = 1; i <= numPoints; ++i)","        {","            multDivAng = divAngle * i;","            cosAng = Math.cos(angleCoord + multDivAng);","            sinAng = Math.sin(angleCoord + multDivAng);","            if(startAngle <= 90)","            {","                pts += \", \" + (x + (radius * Math.cos(angleCoord + (divAngle * i))));","                pts += \", \" + (y + (radius * Math.sin(angleCoord + (divAngle * i))));","            }","            else","            {","                pts += \", \" + (x - (radius * Math.cos(angleCoord + (divAngle * i))));","                pts += \", \" + (y - (radius * Math.sin(angleCoord + (divAngle * i))));","            }","        }","        pts += \", \" + bx + \", \" + by;","        pts += \", \" + x + \", \" + y;","        this._map.appendChild(areaNode);","        areaNode.setAttribute(\"class\", SERIES_MARKER);","        areaNode.setAttribute(\"id\", \"hotSpot_\" + seriesIndex + \"_\" + index);","        areaNode.setAttribute(\"shape\", \"polygon\");","        areaNode.setAttribute(\"coords\", pts);","        this._areaNodes.push(areaNode);","","    },","","    /**","     * Resizes and positions markers based on a mouse interaction.","     *","     * @method updateMarkerState","     * @param {String} type state of the marker","     * @param {Number} i index of the marker","     * @protected","     */","    updateMarkerState: function(type, i)","    {","        if(this._markers[i])","        {","            var state = this._getState(type),","                markerStyles,","                indexStyles,","                marker = this._markers[i],","                styles = this.get(\"styles\").marker; ","            markerStyles = state == \"off\" || !styles[state] ? styles : styles[state]; ","            indexStyles = this._mergeStyles(markerStyles, {});","            indexStyles.fill.color = indexStyles.fill.colors[i % indexStyles.fill.colors.length];","            indexStyles.fill.alpha = indexStyles.fill.alphas[i % indexStyles.fill.alphas.length];","            marker.set(indexStyles);","        }","    },","    ","    /**","     * Creates a shape to be used as a marker.","     *","     * @method _createMarker","     * @param {Object} styles Hash of style properties.","     * @param {Number} order Order of the series.","     * @param {Number} index Index within the series associated with the marker.","     * @return Shape","     * @private","     */","    _createMarker: function(styles, order, index)","    {","        var graphic = this.get(\"graphic\"),","            marker,","            cfg = Y.clone(styles);","        graphic.set(\"autoDraw\", false);","        marker = graphic.addShape(cfg); ","        marker.addClass(SERIES_MARKER);","        return marker;","    },","    ","    /**","     * Creates a cache of markers for reuse.","     *","     * @method _createMarkerCache","     * @private","     */","    _clearMarkerCache: function()","    {","        var len = this._markerCache.length,","            i = 0,","            marker;","        for(; i < len; ++i)","        {","            marker = this._markerCache[i];","            if(marker)","            {","                marker.destroy();","            }","        }","        this._markerCache = [];","    },","","    /**","     * Gets the default style values for the markers.","     *","     * @method _getPlotDefaults","     * @return Object","     * @private","     */","    _getPlotDefaults: function()","    {","         var defs = {","            padding:{","                top: 0,","                left: 0,","                right: 0,","                bottom: 0","            },","            fill:{","                alphas:[\"1\"]","            },","            border: {","                weight: 0,","                alpha: 1","            }","        };","        defs.fill.colors = this._defaultSliceColors;","        defs.border.colors = this._defaultBorderColors;","        return defs;","    },","","    /**","     * Collection of default colors used for lines in a series when not specified by user.","     *","     * @property _defaultLineColors","     * @type Array","     * @protected","     */","    _defaultLineColors:[\"#426ab3\", \"#d09b2c\", \"#000000\", \"#b82837\", \"#b384b5\", \"#ff7200\", \"#779de3\", \"#cbc8ba\", \"#7ed7a6\", \"#007a6c\"],","","    /**","     * Collection of default colors used for marker fills in a series when not specified by user.","     *","     * @property _defaultFillColors","     * @type Array","     * @protected","     */","    _defaultFillColors:[\"#6084d0\", \"#eeb647\", \"#6c6b5f\", \"#d6484f\", \"#ce9ed1\", \"#ff9f3b\", \"#93b7ff\", \"#e0ddd0\", \"#94ecba\", \"#309687\"],","    ","    /**","     * Collection of default colors used for marker borders in a series when not specified by user.","     *","     * @property _defaultBorderColors","     * @type Array","     * @protected","     */","    _defaultBorderColors:[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"],","    ","    /**","     * Collection of default colors used for area fills, histogram fills and pie fills in a series when not specified by user.","     *","     * @property _defaultSliceColors","     * @type Array","     * @protected","     */","    _defaultSliceColors: [\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"],","","    /**","     * Colors used if style colors are not specified","     *","     * @method _getDefaultColor","     * @param {Number} index Index indicating the series order.","     * @param {String} type Indicates which type of object needs the color.","     * @return String","     * @protected","     */","    _getDefaultColor: function(index, type)","    {","        var colors = {","                line: this._defaultLineColors,","                fill: this._defaultFillColors,","                border: this._defaultBorderColors,","                slice: this._defaultSliceColors","            },","            col = colors[type],","            l = col.length;","        index = index || 0;","        if(index >= l)","        {","            index = index % l;","        }","        type = type || \"fill\";","        return colors[type][index];","    }","}, {","    ATTRS: {","        /**","         * Read-only attribute indicating the type of series.","         *","         * @attribute type","         * @type String","         * @default pie","         */","        type: {		","            value: \"pie\"","        },","        ","        /**","         * Order of this instance of this `type`.","         *","         * @attribute order","         * @type Number","         */","        order: {},","","        /**","         * Reference to the `Graph` in which the series is drawn into.","         *","         * @attribute graph","         * @type Graph","         */","        graph: {},","        ","        /**","         * Reference to the `Axis` instance used for assigning ","         * category values to the graph.","         *","         * @attribute categoryAxis","         * @type Axis","         */","        categoryAxis: {","            value: null,","","            validator: function(value)","            {","                return value !== this.get(\"categoryAxis\");","            }","        },","        ","        /**","         * Reference to the `Axis` instance used for assigning ","         * series values to the graph.","         *","         * @attribute categoryAxis","         * @type Axis","         */","        valueAxis: {","            value: null,","","            validator: function(value)","            {","                return value !== this.get(\"valueAxis\");","            }","        },","","        /**","         * Indicates which array to from the hash of value arrays in ","         * the category `Axis` instance.","         *","         * @attribute categoryKey","         * @type String","         */","        categoryKey: {","            value: null,","","            validator: function(value)","            {","                return value !== this.get(\"categoryKey\");","            }","        },","        /**","         * Indicates which array to from the hash of value arrays in ","         * the value `Axis` instance.","         *","         * @attribute valueKey","         * @type String","         */","        valueKey: {","            value: null,","","            validator: function(value)","            {","                return value !== this.get(\"valueKey\");","            }","        },","","        /**","         * Name used for for displaying category data","         *","         * @attribute categoryDisplayName","         * @type String","         */","        categoryDisplayName: {","            setter: function(val)","            {","                this._categoryDisplayName = val;","                return val;","            },","","            getter: function()","            {","                return this._categoryDisplayName || this.get(\"categoryKey\");","            }","        },","","        /**","         * Name used for for displaying value data","         *","         * @attribute valueDisplayName","         * @type String","         */","        valueDisplayName: {","            setter: function(val)","            {","                this._valueDisplayName = val;","                return val;","            },","","            getter: function()","            {","                return this._valueDisplayName || this.get(\"valueKey\");","            }","        },","        ","        /**","         * @attribute slices","         * @type Array","         * @private","         */","        slices: null","        ","        /**","         * Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:","         *  <dl>","         *      <dt>fill</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>colors</dt><dd>An array of colors to be used for the marker fills. The color for each marker is retrieved from the ","         *              array below:<br/>","         *              `[\"#66007f\", \"#a86f41\", \"#295454\", \"#996ab2\", \"#e8cdb7\", \"#90bdbd\",\"#000000\",\"#c3b8ca\", \"#968373\", \"#678585\"]`","         *              </dd>","         *              <dt>alphas</dt><dd>An array of alpha references (Number from 0 to 1) indicating the opacity of each marker fill. The default value is [1].</dd>","         *          </dl>","         *      </dd>","         *      <dt>border</dt><dd>A hash containing the following values:","         *          <dl>","         *              <dt>color</dt><dd>An array of colors to be used for the marker borders. The color for each marker is retrieved from the","         *              array below:<br/>","         *              `[\"#205096\", \"#b38206\", \"#000000\", \"#94001e\", \"#9d6fa0\", \"#e55b00\", \"#5e85c9\", \"#adab9e\", \"#6ac291\", \"#006457\"]`","         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *          </dl>","         *      </dd>","         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default ","         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,","         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","/**"," * Gridlines draws gridlines on a Graph."," *"," * @module charts"," * @submodule charts-base"," * @class Gridlines"," * @constructor"," * @extends Base"," * @uses Renderer"," */","Y.Gridlines = Y.Base.create(\"gridlines\", Y.Base, [Y.Renderer], {","    /**","     * Reference to the `Path` element used for drawing Gridlines.","     *","     * @property _path","     * @type Path","     * @private","     */","    _path: null,","","    /**","     * Removes the Gridlines.","     *","     * @method remove","     * @private","     */","    remove: function()","    {","        var path = this._path;","        if(path)","        {","            path.destroy();","        }","    },","","    /**","     * Draws the gridlines","     *","     * @method draw","     * @protected","     */","    draw: function()","    {","        if(this.get(\"axis\") && this.get(\"graph\"))","        {","            this._drawGridlines();","        }","    },","","    /**","     * Algorithm for drawing gridlines","     *","     * @method _drawGridlines","     * @private","     */","    _drawGridlines: function()","    {","        var path,","            axis = this.get(\"axis\"),","            axisPosition = axis.get(\"position\"),","            points,","            i = 0,","            l,","            direction = this.get(\"direction\"),","            graph = this.get(\"graph\"),","            w = graph.get(\"width\"),","            h = graph.get(\"height\"),","            line = this.get(\"styles\").line,","            color = line.color,","            weight = line.weight,","            alpha = line.alpha,","            lineFunction = direction == \"vertical\" ? this._verticalLine : this._horizontalLine;","        if(isFinite(w) && isFinite(h) && w > 0 && h > 0)","        {","            if(axisPosition != \"none\" && axis && axis.get(\"tickPoints\"))","            {","                points = axis.get(\"tickPoints\");","                l = points.length;","            }","            else","            {","                points = [];","                l = axis.get(\"styles\").majorUnit.count;","                for(; i < l; ++i)","                {","                    points[i] = {","                        x: w * (i/(l-1)),","                        y: h * (i/(l-1))","                    };","                }","                i = 0;","            }","            path = graph.get(\"gridlines\");","            path.set(\"width\", w);","            path.set(\"height\", h);","            path.set(\"stroke\", {","                weight: weight,","                color: color,","                opacity: alpha","            });","            for(; i < l; ++i)","            {","                lineFunction(path, points[i], w, h);","            }","            path.end();","        }","    },","","    /**","     * Algorithm for horizontal lines.","     *","     * @method _horizontalLine","     * @param {Path} path Reference to path element","     * @param {Object} pt Coordinates corresponding to a major unit of an axis.","     * @param {Number} w Width of the Graph","     * @param {Number} h Height of the Graph","     * @private","     */","    _horizontalLine: function(path, pt, w, h)","    {","        path.moveTo(0, pt.y);","        path.lineTo(w, pt.y);","    },","","    /**","     * Algorithm for vertical lines.","     *","     * @method _verticalLine","     * @param {Path} path Reference to path element","     * @param {Object} pt Coordinates corresponding to a major unit of an axis.","     * @param {Number} w Width of the Graph","     * @param {Number} h Height of the Graph","     * @private","     */","    _verticalLine: function(path, pt, w, h)","    {","        path.moveTo(pt.x, 0);","        path.lineTo(pt.x, h);","    },","    ","    /**","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     * @protected","     */","    _getDefaultStyles: function()","    {","        var defs = {","            line: {","                color:\"#f0efe9\",","                weight: 1,","                alpha: 1","            }","        };","        return defs;","    }","","},","{","    ATTRS: {","        /**","         * Indicates the direction of the gridline.","         *","         * @attribute direction","         * @type String","         */","        direction: {},","        ","        /**","         * Indicate the `Axis` in which to bind","         * the gridlines.","         *","         * @attribute axis","         * @type Axis","         */","        axis: {},","        ","        /**","         * Indicates the `Graph` in which the gridlines ","         * are drawn.","         *","         * @attribute graph","         * @type Graph","         */","        graph: {}","    }","});","/**"," * Graph manages and contains series instances for a `CartesianChart`"," * instance."," *"," * @module charts"," * @submodule charts-base"," * @class Graph"," * @constructor"," * @extends Widget"," * @uses Renderer"," */","Y.Graph = Y.Base.create(\"graph\", Y.Widget, [Y.Renderer], {","    /**","     * @method bindUI","     * @private","     */","    bindUI: function()","    {","        var bb = this.get(\"boundingBox\");","        bb.setStyle(\"position\", \"absolute\");","        this.after(\"widthChange\", this._sizeChangeHandler);","        this.after(\"heightChange\", this._sizeChangeHandler);","        this.after(\"stylesChange\", this._updateStyles);","        this.after(\"groupMarkersChange\", this._drawSeries);","    },","","    /**","     * @method syncUI","     * @private","     */","    syncUI: function()","    {","        var background,","            cb,","            bg,","            sc = this.get(\"seriesCollection\"),","            series,","            i = 0,","            len = sc ? sc.length : 0,","            hgl = this.get(\"horizontalGridlines\"),","            vgl = this.get(\"verticalGridlines\");","        if(this.get(\"showBackground\"))","        {","            background = this.get(\"background\");","            cb = this.get(\"contentBox\");","            bg = this.get(\"styles\").background;","            bg.stroke = bg.border;","            bg.stroke.opacity = bg.stroke.alpha;","            bg.fill.opacity = bg.fill.alpha;","            bg.width = this.get(\"width\");","            bg.height = this.get(\"height\");","            bg.type = bg.shape;","            background.set(bg);","        }","        for(; i < len; ++i)","        {","            series = sc[i];","            if(series instanceof Y.CartesianSeries)","            {","                series.render();","            }","        }","        if(hgl && hgl instanceof Y.Gridlines)","        {","            hgl.draw();","        }","        if(vgl && vgl instanceof Y.Gridlines)","        {","            vgl.draw();","        }","    },","   ","    /**","     * Object of arrays containing series mapped to a series type.","     *","     * @property seriesTypes","     * @type Object","     * @private","     */","    seriesTypes: null,","","    /**","     * Returns a series instance based on an index.","     * ","     * @method getSeriesByIndex","     * @param {Number} val index of the series","     * @return CartesianSeries","     */","    getSeriesByIndex: function(val)","    {","        var col = this.get(\"seriesCollection\"),","            series;","        if(col && col.length > val)","        {","            series = col[val];","        }","        return series;","    },","","    /**","     * Returns a series instance based on a key value.","     * ","     * @method getSeriesByKey","     * @param {String} val key value of the series","     * @return CartesianSeries","     */","    getSeriesByKey: function(val)","    {","        var obj = this._seriesDictionary,","            series;","        if(obj && obj.hasOwnProperty(val))","        {","            series = obj[val];","        }","        return series;","    },","","    /**","     * Adds dispatcher to a `_dispatcher` used to","     * to ensure all series have redrawn before for firing event.","     *","     * @method addDispatcher","     * @param {CartesianSeries} val series instance to add","     * @protected","     */","    addDispatcher: function(val)","    {","        if(!this._dispatchers)","        {","            this._dispatchers = [];","        }","        this._dispatchers.push(val);","    },","","    /**","     * Collection of series to be displayed in the graph.","     *","     * @property _seriesCollection","     * @type Array","     * @private ","     */","    _seriesCollection: null,","    ","    /**","     * Object containing key value pairs of `CartesianSeries` instances.","     *","     * @property _seriesDictionary","     * @type Object","     * @private","     */","    _seriesDictionary: null,","","    /**","     * Parses series instances to be displayed in the graph.","     *","     * @method _parseSeriesCollection","     * @param {Array} Collection of `CartesianSeries` instances or objects container `CartesianSeries` attributes values.","     * @private","     */","    _parseSeriesCollection: function(val)","    {","        if(!val)","        {","            return;","        }	","        var len = val.length,","            i = 0,","            series,","            seriesKey;","        this._seriesCollection = [];","        this._seriesDictionary = {};","        this.seriesTypes = [];","        for(; i < len; ++i)","        {	","            series = val[i];","            if(!(series instanceof Y.CartesianSeries) && !(series instanceof Y.PieSeries))","            {","                this._createSeries(series);","                continue;","            }","            this._addSeries(series);","        }","        len = this._seriesCollection.length;","        for(i = 0; i < len; ++i)","        {","            series = this.get(\"seriesCollection\")[i];","            seriesKey = series.get(\"direction\") == \"horizontal\" ? \"yKey\" : \"xKey\";","            this._seriesDictionary[series.get(seriesKey)] = series;","        }","    },","","    /**","     * Adds a series to the graph.","     *","     * @method _addSeries","     * @param {CartesianSeries} series Series to add to the graph.","     * @private","     */","    _addSeries: function(series)","    {","        var type = series.get(\"type\"),","            seriesCollection = this.get(\"seriesCollection\"),","            graphSeriesLength = seriesCollection.length,","            seriesTypes = this.seriesTypes,","            typeSeriesCollection;	","        if(!series.get(\"graph\")) ","        {","            series.set(\"graph\", this);","        }","        seriesCollection.push(series);","        if(!seriesTypes.hasOwnProperty(type))","        {","            this.seriesTypes[type] = [];","        }","        typeSeriesCollection = this.seriesTypes[type];","        series.set(\"graphOrder\", graphSeriesLength);","        series.set(\"order\", typeSeriesCollection.length);","        typeSeriesCollection.push(series);","        this.addDispatcher(series);","        series.after(\"drawingComplete\", Y.bind(this._drawingCompleteHandler, this));","        this.fire(\"seriesAdded\", series);","    },","","    /**","     * Creates a `CartesianSeries` instance from an object containing attribute key value pairs. The key value pairs include attributes for the specific series and a type value which defines the type of","     * series to be used. ","     *","     * @method createSeries","     * @param {Object} seriesData Series attribute key value pairs.","     * @private","     */","    _createSeries: function(seriesData)","    {","        var type = seriesData.type,","            seriesCollection = this.get(\"seriesCollection\"),","            seriesTypes = this.seriesTypes,","            typeSeriesCollection,","            seriesType,","            series;","            seriesData.graph = this;","        if(!seriesTypes.hasOwnProperty(type))","        {","            seriesTypes[type] = [];","        }","        typeSeriesCollection = seriesTypes[type];","        seriesData.graph = this;","        seriesData.order = typeSeriesCollection.length;","        seriesData.graphOrder = seriesCollection.length;","        seriesType = this._getSeries(seriesData.type);","        series = new seriesType(seriesData);","        this.addDispatcher(series);","        series.after(\"drawingComplete\", Y.bind(this._drawingCompleteHandler, this));","        typeSeriesCollection.push(series);","        seriesCollection.push(series);","        if(this.get(\"rendered\"))","        {","            series.render();","        }","    },","    ","    /**","     * String reference for pre-defined `Series` classes.","     *","     * @property _seriesMap","     * @type Object","     * @private","     */","    _seriesMap: {","        line : Y.LineSeries,","        column : Y.ColumnSeries,","        bar : Y.BarSeries,","        area :  Y.AreaSeries,","        candlestick : Y.CandlestickSeries,","        ohlc : Y.OHLCSeries,","        stackedarea : Y.StackedAreaSeries,","        stackedline : Y.StackedLineSeries,","        stackedcolumn : Y.StackedColumnSeries,","        stackedbar : Y.StackedBarSeries,","        markerseries : Y.MarkerSeries,","        spline : Y.SplineSeries,","        areaspline : Y.AreaSplineSeries,","        stackedspline : Y.StackedSplineSeries,","        stackedareaspline : Y.StackedAreaSplineSeries,","        stackedmarkerseries : Y.StackedMarkerSeries,","        pie : Y.PieSeries,","        combo : Y.ComboSeries,","        stackedcombo : Y.StackedComboSeries,","        combospline : Y.ComboSplineSeries,","        stackedcombospline : Y.StackedComboSplineSeries","    },","","    /**","     * Returns a specific `CartesianSeries` class based on key value from a look up table of a direct reference to a class. When specifying a key value, the following options","     * are available:","     *","     *  <table>","     *      <tr><th>Key Value</th><th>Class</th></tr>","     *      <tr><td>line</td><td>Y.LineSeries</td></tr>    ","     *      <tr><td>column</td><td>Y.ColumnSeries</td></tr>    ","     *      <tr><td>bar</td><td>Y.BarSeries</td></tr>    ","     *      <tr><td>area</td><td>Y.AreaSeries</td></tr>    ","     *      <tr><td>stackedarea</td><td>Y.StackedAreaSeries</td></tr>    ","     *      <tr><td>stackedline</td><td>Y.StackedLineSeries</td></tr>    ","     *      <tr><td>stackedcolumn</td><td>Y.StackedColumnSeries</td></tr>    ","     *      <tr><td>stackedbar</td><td>Y.StackedBarSeries</td></tr>    ","     *      <tr><td>markerseries</td><td>Y.MarkerSeries</td></tr>    ","     *      <tr><td>spline</td><td>Y.SplineSeries</td></tr>    ","     *      <tr><td>areaspline</td><td>Y.AreaSplineSeries</td></tr>    ","     *      <tr><td>stackedspline</td><td>Y.StackedSplineSeries</td></tr>","     *      <tr><td>stackedareaspline</td><td>Y.StackedAreaSplineSeries</td></tr>","     *      <tr><td>stackedmarkerseries</td><td>Y.StackedMarkerSeries</td></tr>","     *      <tr><td>pie</td><td>Y.PieSeries</td></tr>","     *      <tr><td>combo</td><td>Y.ComboSeries</td></tr>","     *      <tr><td>stackedcombo</td><td>Y.StackedComboSeries</td></tr>","     *      <tr><td>combospline</td><td>Y.ComboSplineSeries</td></tr>","     *      <tr><td>stackedcombospline</td><td>Y.StackedComboSplineSeries</td></tr>","     *  </table>","     * ","     * When referencing a class directly, you can specify any of the above classes or any custom class that extends `CartesianSeries` or `PieSeries`.","     *","     * @method _getSeries","     * @param {String | Object} type Series type.","     * @return CartesianSeries","     * @private","     */","    _getSeries: function(type)","    {","        var seriesClass;","        if(Y_Lang.isString(type))","        {","            seriesClass = this._seriesMap[type];","        }","        else ","        {","            seriesClass = type;","        }","        return seriesClass;","    },","","    /**","     * Event handler for marker events.","     *","     * @method _markerEventHandler","     * @param {Object} e Event object.","     * @private","     */","    _markerEventHandler: function(e)","    {","        var type = e.type,","            markerNode = e.currentTarget,","            strArr = markerNode.getAttribute(\"id\").split(\"_\"),","            series = this.getSeriesByIndex(strArr[1]),","            index = strArr[2];","        series.updateMarkerState(type, index);","    },","","    /**","     * Collection of `CartesianSeries` instances to be redrawn.","     *","     * @property _dispatchers","     * @type Array","     * @private","     */","    _dispatchers: null,","","    /**","     * Updates the `Graph` styles.","     *","     * @method _updateStyles","     * @private","     */","    _updateStyles: function()","    {","        var styles = this.get(\"styles\").background,","            border = styles.border;","            border.opacity = border.alpha;","            styles.stroke = border;","            styles.fill.opacity = styles.fill.alpha;","        this.get(\"background\").set(styles);","        this._sizeChangeHandler();","    },","","    /**","     * Event handler for size changes.","     *","     * @method _sizeChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _sizeChangeHandler: function(e)","    {","        var hgl = this.get(\"horizontalGridlines\"),","            vgl = this.get(\"verticalGridlines\"),","            w = this.get(\"width\"),","            h = this.get(\"height\"),","            bg = this.get(\"styles\").background,","            weight,","            background;","        if(bg && bg.border)","        {","            weight = bg.border.weight || 0;","        }","        if(this.get(\"showBackground\"))","        {","            background = this.get(\"background\");","            if(w && h)","            {","                background.set(\"width\", w);","                background.set(\"height\", h);","            }","        }","        if(this._gridlines)","        {","            this._gridlines.clear();","        }","        if(hgl && hgl instanceof Y.Gridlines)","        {","            hgl.draw();","        }","        if(vgl && vgl instanceof Y.Gridlines)","        {","            vgl.draw();","        }","        this._drawSeries();","    },","","    /**","     * Draws each series.","     *","     * @method _drawSeries","     * @private","     */","    _drawSeries: function()","    {","        if(this._drawing)","        {","            this._callLater = true;","            return;","        }","        var sc,","            i,","            len,","            graphic = this.get(\"graphic\");","        graphic.set(\"autoDraw\", false);","        this._callLater = false;","        this._drawing = true;","        sc = this.get(\"seriesCollection\");","        i = 0;","        len = sc ? sc.length : 0;","        for(; i < len; ++i)","        {","            sc[i].draw();","            if((!sc[i].get(\"xcoords\") || !sc[i].get(\"ycoords\")) && !sc[i] instanceof Y.PieSeries)","            {","                this._callLater = true;","                break;","            }","        }","        this._drawing = false;","        if(this._callLater)","        {","            this._drawSeries();","        }","    },  ","","    /**","     * Event handler for series drawingComplete event.","     *","     * @method _drawingCompleteHandler","     * @param {Object} e Event object.","     * @private","     */","    _drawingCompleteHandler: function(e)","    {","        var series = e.currentTarget,","            graphic,","            index = Y.Array.indexOf(this._dispatchers, series);","        if(index > -1)","        {","            this._dispatchers.splice(index, 1);","        }","        if(this._dispatchers.length < 1)","        {","            graphic = this.get(\"graphic\");","            if(!graphic.get(\"autoDraw\"))","            {","                graphic._redraw();","            }","            this.fire(\"chartRendered\");","        }","    },","","    /**","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     * @protected","     */","    _getDefaultStyles: function()","    {","        var defs = {","            background: {","                shape: \"rect\",","                fill:{","                    color:\"#faf9f2\"","                },","                border: {","                    color:\"#dad8c9\",","                    weight: 1","                }","            }","        };","        return defs;","    },","","    /**","     * Destructor implementation Graph class. Removes all Graphic instances from the widget.","     *","     * @method destructor","     * @protected","     */","    destructor: function()","    {","        if(this._graphic)","        {","            this._graphic.destroy();","            this._graphic = null;","        }","        if(this._background)","        {","            this._background.get(\"graphic\").destroy();","            this._background = null;","        }","        if(this._gridlines)","        {","            this._gridlines.get(\"graphic\").destroy();","            this._gridlines = null;","        }","    }","}, {","    ATTRS: {","        /**","         * The x-coordinate for the graph.","         *","         * @attribute x","         * @type Number","         * @protected","         */","        x: {","            setter: function(val)","            {","                this.get(\"boundingBox\").setStyle(\"left\", val + \"px\");","                return val;","            }","        },","","        /**","         * The y-coordinate for the graph.","         *","         * @attribute y","         * @type Number","         * @protected","         */","        y: {","            setter: function(val)","            {","                this.get(\"boundingBox\").setStyle(\"top\", val + \"px\");","                return val;","            }","        },","","        /**","         * Reference to the chart instance using the graph.","         *","         * @attribute chart","         * @type ChartBase","         * @readOnly","         */","        chart: {},","","        /**","         * Collection of series. When setting the `seriesCollection` the array can contain a combination of either","         * `CartesianSeries` instances or object literals with properties that will define a series.","         *","         * @attribute seriesCollection","         * @type CartesianSeries","         */","        seriesCollection: {","            getter: function()","            {","                return this._seriesCollection;","            },","","            setter: function(val)","            {","                this._parseSeriesCollection(val);","                return this._seriesCollection;","            }","        },","       ","        /**","         * Indicates whether the `Graph` has a background.","         *","         * @attribute showBackground","         * @type Boolean","         * @default true","         */","        showBackground: {","            value: true","        },","","        /**","         * Read-only hash lookup for all series on in the `Graph`.","         *","         * @attribute seriesDictionary","         * @type Object","         * @readOnly","         */","        seriesDictionary: {","            readOnly: true,","","            getter: function()","            {","                return this._seriesDictionary;","            }","        },","","        /**","         * Reference to the horizontal `Gridlines` instance.","         *","         * @attribute horizontalGridlines","         * @type Gridlines","         * @default null","         */","        horizontalGridlines: {","            value: null,","","            setter: function(val)","            {","                var gl = this.get(\"horizontalGridlines\");","                if(gl && gl instanceof Y.Gridlines)","                {","                    gl.remove();","                }","                if(val instanceof Y.Gridlines)","                {","                    gl = val;","                    val.set(\"graph\", this);","                    return val;","                }","                else if(val && val.axis)","                {","                    gl = new Y.Gridlines({direction:\"horizontal\", axis:val.axis, graph:this, styles:val.styles});","                    return gl;","                }","            }","        },","        ","        /**","         * Reference to the vertical `Gridlines` instance.","         *","         * @attribute verticalGridlines","         * @type Gridlines","         * @default null","         */","        verticalGridlines: {","            value: null,","","            setter: function(val)","            {","                var gl = this.get(\"verticalGridlines\");","                if(gl && gl instanceof Y.Gridlines)","                {","                    gl.remove();","                }","                if(val instanceof Y.Gridlines)","                {","                    gl = val;","                    val.set(\"graph\", this);","                    return val;","                }","                else if(val && val.axis)","                {","                    gl = new Y.Gridlines({direction:\"vertical\", axis:val.axis, graph:this, styles:val.styles});","                    return gl;","                }","            }","        },","","        /**","         * Reference to graphic instance used for the background.","         *","         * @attribute background","         * @type Graphic","         * @readOnly","         */","        background: {","            getter: function()","            {","                if(!this._background)","                {","                    this._backgroundGraphic = new Y.Graphic({render:this.get(\"contentBox\")});","                    this._backgroundGraphic.get(\"node\").style.zIndex = 0; ","                    this._background = this._backgroundGraphic.addShape({type: \"rect\"});","                }","                return this._background;","            }","        },","","        /**","         * Reference to graphic instance used for gridlines.","         *","         * @attribute gridlines","         * @type Graphic","         * @readOnly","         */","        gridlines: {","            readOnly: true,","","            getter: function()","            {","                if(!this._gridlines)","                {","                    this._gridlinesGraphic = new Y.Graphic({render:this.get(\"contentBox\")});","                    this._gridlinesGraphic.get(\"node\").style.zIndex = 1; ","                    this._gridlines = this._gridlinesGraphic.addShape({type: \"path\"});","                }","                return this._gridlines;","            }","        },","        ","        /**","         * Reference to graphic instance used for series.","         *","         * @attribute graphic","         * @type Graphic","         * @readOnly","         */","        graphic: {","            readOnly: true,","","            getter: function() ","            {","                if(!this._graphic)","                {","                    this._graphic = new Y.Graphic({render:this.get(\"contentBox\")});","                    this._graphic.get(\"node\").style.zIndex = 2; ","                    this._graphic.set(\"autoDraw\", false);","                }","                return this._graphic;","            }","        },","","        /**","         * Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.","         *","         * @attribute groupMarkers","         * @type Boolean","         */","        groupMarkers: {","            value: false","        }","","        /**","         * Style properties used for drawing a background. Below are the default values:","         *  <dl>","         *      <dt>background</dt><dd>An object containing the following values:","         *          <dl>","         *              <dt>fill</dt><dd>Defines the style properties for the fill. Contains the following values:","         *                  <dl>","         *                      <dt>color</dt><dd>Color of the fill. The default value is #faf9f2.</dd>","         *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background fill. The default value is 1.</dd>","         *                  </dl>","         *              </dd>","         *              <dt>border</dt><dd>Defines the style properties for the border. Contains the following values:","         *                  <dl>","         *                      <dt>color</dt><dd>Color of the border. The default value is #dad8c9.</dd>","         *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the background border. The default value is 1.</dd>","         *                      <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>","         *                  </dl>","         *              </dd>","         *          </dl>","         *      </dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","    }","});","/**"," * The ChartBase class is an abstract class used to create charts."," *"," * @module charts"," * @submodule charts-base"," * @class ChartBase"," * @constructor"," */","function ChartBase() {}","","ChartBase.ATTRS = {","    /**","     * Data used to generate the chart.","     * ","     * @attribute dataProvider","     * @type Array","     */","    dataProvider: {","        lazyAdd: false,","","        valueFn: function()","        {","            var defDataProvider = [];","            if(!this._seriesKeysExplicitlySet)","            {","                this._seriesKeys = this._buildSeriesKeys(defDataProvider);","            }","            return defDataProvider;","        },","","        setter: function(val)","        {","            var dataProvider = this._setDataValues(val);","            if(!this._seriesKeysExplicitlySet)","            {","                this._seriesKeys = this._buildSeriesKeys(dataProvider);","            }","            return dataProvider;","        }","    },","","    /**","     * A collection of keys that map to the series axes. If no keys are set,","     * they will be generated automatically depending on the data structure passed into ","     * the chart.","     *","     * @attribute seriesKeys","     * @type Array","     */","    seriesKeys: {","        getter: function()","        {","            return this._seriesKeys;","        },","","        setter: function(val)","        {","            this._seriesKeysExplicitlySet = true;","            this._seriesKeys = val;","            return val;","        }","    },","","    /**","     * Sets the `aria-label` for the chart.","     *","     * @attribute ariaLabel","     * @type String","     */","    ariaLabel: {","        value: \"Chart Application\",","","        setter: function(val)","        {","            var cb = this.get(\"contentBox\");","            if(cb)","            {","                cb.setAttribute(\"aria-label\", val);","            }","            return val;","        }","    },","    ","    /**","     * Sets the aria description for the chart.","     *","     * @attribute ariaDescription","     * @type String","     */","    ariaDescription: {","        value: \"Use the up and down keys to navigate between series. Use the left and right keys to navigate through items in a series.\",","","        setter: function(val)","        {","            if(this._description)","            {","                this._description.setContent(\"\");","                this._description.appendChild(DOCUMENT.createTextNode(val));","            }","            return val;","        }","    },","    ","    /**","     * Reference to the default tooltip available for the chart.","     * <p>Contains the following properties:</p>","     *  <dl>","     *      <dt>node</dt><dd>Reference to the actual dom node</dd>","     *      <dt>showEvent</dt><dd>Event that should trigger the tooltip</dd>","     *      <dt>hideEvent</dt><dd>Event that should trigger the removal of a tooltip (can be an event or an array of events)</dd>","     *      <dt>styles</dt><dd>A hash of style properties that will be applied to the tooltip node</dd>","     *      <dt>show</dt><dd>Indicates whether or not to show the tooltip</dd>","     *      <dt>markerEventHandler</dt><dd>Displays and hides tooltip based on marker events</dd>","     *      <dt>planarEventHandler</dt><dd>Displays and hides tooltip based on planar events</dd>","     *      <dt>markerLabelFunction</dt><dd>Reference to the function used to format a marker event triggered tooltip's text. The method contains ","     *      the following arguments:","     *  <dl>","     *      <dt>categoryItem</dt><dd>An object containing the following:","     *  <dl>","     *      <dt>axis</dt><dd>The axis to which the category is bound.</dd>","     *      <dt>displayName</dt><dd>The display name set to the category (defaults to key if not provided).</dd>","     *      <dt>key</dt><dd>The key of the category.</dd>","     *      <dt>value</dt><dd>The value of the category.</dd>","     *  </dl>","     *  </dd>","     *  <dt>valueItem</dt><dd>An object containing the following:","     *      <dl>","     *          <dt>axis</dt><dd>The axis to which the item's series is bound.</dd>","     *          <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>","     *          <dt>key</dt><dd>The key for the series.</dd>","     *          <dt>value</dt><dd>The value for the series item.</dd> ","     *      </dl>","     *  </dd>","     *  <dt>itemIndex</dt><dd>The index of the item within the series.</dd>","     *  <dt>series</dt><dd> The `CartesianSeries` instance of the item.</dd>","     *  <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>","     *  </dl>","     *  The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose to return an html string, you","     *  will also need to override the tooltip's `setTextFunction` method to accept an html string.","     *  </dd>","     *  <dt>planarLabelFunction</dt><dd>Reference to the function used to format a planar event triggered tooltip's text","     *  <dl>","     *      <dt>categoryAxis</dt><dd> `CategoryAxis` Reference to the categoryAxis of the chart.","     *      <dt>valueItems</dt><dd>Array of objects for each series that has a data point in the coordinate plane of the event. Each object contains the following data:","     *  <dl>","     *      <dt>axis</dt><dd>The value axis of the series.</dd>","     *      <dt>key</dt><dd>The key for the series.</dd>","     *      <dt>value</dt><dd>The value for the series item.</dd>","     *      <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>","     *  </dl> ","     *  </dd>","     *      <dt>index</dt><dd>The index of the item within its series.</dd>","     *      <dt>seriesArray</dt><dd>Array of series instances for each value item.</dd>","     *      <dt>seriesIndex</dt><dd>The index of the series in the `seriesCollection`.</dd>","     *  </dl>","     *  </dd>","     *  </dl>","     *  The method returns an `HTMLElement` which is written into the DOM using `appendChild`. If you override this method and choose to return an html string, you","     *  will also need to override the tooltip's `setTextFunction` method to accept an html string.","     *  </dd>","     *  <dt>setTextFunction</dt><dd>Method that writes content returned from `planarLabelFunction` or `markerLabelFunction` into the the tooltip node.","     *  has the following signature:","     *  <dl>","     *      <dt>label</dt><dd>The `HTMLElement` that the content is to be added.</dd>","     *      <dt>val</dt><dd>The content to be rendered into tooltip. This can be a `String` or `HTMLElement`. If an HTML string is used, it will be rendered as a","     *      string.</dd>","     *  </dl>","     *  </dd>","     *  </dl>","     * @attribute tooltip","     * @type Object","     */ ","    tooltip: {","        valueFn: \"_getTooltip\",","","        setter: function(val)","        {","            return this._updateTooltip(val);","        }","    },","","    /** ","     * The key value used for the chart's category axis. ","     *","     * @attribute categoryKey","     * @type String","     * @default category","     */","    categoryKey: {","        value: \"category\"","    },","        ","    /**","     * Indicates the type of axis to use for the category axis.","     *","     *  <dl>","     *      <dt>category</dt><dd>Specifies a `CategoryAxis`.</dd>","     *      <dt>time</dt><dd>Specifies a `TimeAxis</dd>","     *  </dl>","     *","     * @attribute categoryType","     * @type String","     * @default category","     */","    categoryType:{","        value:\"category\"","    },","","    /**","     * Indicates the the type of interactions that will fire events.","     *","     *  <dl>","     *      <dt>marker</dt><dd>Events will be broadcasted when the mouse interacts with individual markers.</dd>","     *      <dt>planar</dt><dd>Events will be broadcasted when the mouse intersects the plane of any markers on the chart.</dd>","     *      <dt>none</dt><dd>No events will be broadcasted.</dd>","     *  </dl>","     *","     * @attribute interactionType","     * @type String","     * @default marker","     */","    interactionType: {","        value: \"marker\"","    },","","    /**","     * Reference to all the axes in the chart.","     *","     * @attribute axesCollection","     * @type Array","     */","    axesCollection: {},","","    /**","     * Reference to graph instance.","     * ","     * @attribute graph","     * @type Graph ","     */","    graph: {","        valueFn: \"_getGraph\"","    },","","    /**","     * Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.","     *","     * @attribute groupMarkers","     * @type Boolean","     */","    groupMarkers: {","        value: false","    }","};","","ChartBase.prototype = {","    /**","     * Handles groupMarkers change event.","     *","     * @method _groupMarkersChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _groupMarkersChangeHandler: function(e)","    {","        var graph = this.get(\"graph\"),","            useGroupMarkers = e.newVal;","        if(graph)","        {","            graph.set(\"groupMarkers\", useGroupMarkers);","        }","    },","","    /**","     * Handler for itemRendered event.","     *","     * @method _itemRendered","     * @param {Object} e Event object.","     * @private","     */","    _itemRendered: function(e)","    {","        this._itemRenderQueue = this._itemRenderQueue.splice(1 + Y.Array.indexOf(this._itemRenderQueue, e.currentTarget), 1);","        if(this._itemRenderQueue.length < 1)","        {","            this._redraw();","        }","    },","","    /**","     * Default value function for the `Graph` attribute.","     *","     * @method _getGraph","     * @return Graph","     * @private","     */","    _getGraph: function()","    {","        var graph = new Y.Graph({","            chart:this,","            groupMarkers: this.get(\"groupMarkers\")    ","        });","        graph.after(\"chartRendered\", Y.bind(function(e) {","            this.fire(\"chartRendered\");","        }, this));","        return graph; ","    },","","    /**","     * Returns a series instance by index or key value.","     *","     * @method getSeries","     * @param val","     * @return CartesianSeries","     */","    getSeries: function(val)","    {","        var series = null, ","            graph = this.get(\"graph\");","        if(graph)","        {","            if(Y_Lang.isNumber(val))","            {","                series = graph.getSeriesByIndex(val);","            }","            else","            {","                series = graph.getSeriesByKey(val);","            }","        }","        return series;","    },","","    /**","     * Returns an `Axis` instance by key reference. If the axis was explicitly set through the `axes` attribute,","     * the key will be the same as the key used in the `axes` object. For default axes, the key for","     * the category axis is the value of the `categoryKey` (`category`). For the value axis, the default ","     * key is `values`.","     *","     * @method getAxisByKey","     * @param {String} val Key reference used to look up the axis.","     * @return Axis","     */","    getAxisByKey: function(val)","    {","        var axis,","            axes = this.get(\"axes\");","        if(axes && axes.hasOwnProperty(val))","        {","            axis = axes[val];","        }","        return axis;","    },","","    /**","     * Returns the category axis for the chart.","     *","     * @method getCategoryAxis","     * @return Axis","     */","    getCategoryAxis: function()","    {","        var axis,","            key = this.get(\"categoryKey\"),","            axes = this.get(\"axes\");","        if(axes.hasOwnProperty(key))","        {","            axis = axes[key];","        }","        return axis;","    },","","    /**","     * Default direction of the chart.","     *","     * @property _direction","     * @type String","     * @default horizontal","     * @private","     */","    _direction: \"horizontal\",","    ","    /**","     * Storage for the `dataProvider` attribute.","     *","     * @property _dataProvider","     * @type Array","     * @private","     */","    _dataProvider: null,","","    /**","     * Setter method for `dataProvider` attribute.","     *","     * @method _setDataValues","     * @param {Array} val Array to be set as `dataProvider`.","     * @return Array","     * @private","     */","    _setDataValues: function(val)","    {","        if(Y_Lang.isArray(val[0]))","        {","            var hash, ","                dp = [], ","                cats = val[0], ","                i = 0, ","                l = cats.length, ","                n, ","                sl = val.length;","            for(; i < l; ++i)","            {","                hash = {category:cats[i]};","                for(n = 1; n < sl; ++n)","                {","                    hash[\"series\" + n] = val[n][i];","                }","                dp[i] = hash; ","            }","            return dp;","        }","        return val;","    },","","    /**","     * Storage for `seriesCollection` attribute.","     *","     * @property _seriesCollection","     * @type Array","     * @private ","     */","    _seriesCollection: null,","","    /**","     * Setter method for `seriesCollection` attribute.","     *","     * @property _setSeriesCollection","     * @param {Array} val Array of either `CartesianSeries` instances or objects containing series attribute key value pairs.","     * @private","     */","    _setSeriesCollection: function(val)","    {","        this._seriesCollection = val;","    },","    /**","     * Helper method that returns the axis class that a key references.","     *","     * @method _getAxisClass","     * @param {String} t The type of axis.","     * @return Axis","     * @private","     */","    _getAxisClass: function(t)","    {","        return this._axisClass[t];","    },","  ","    /**","     * Key value pairs of axis types. ","     *","     * @property _axisClass","     * @type Object","     * @private","     */","    _axisClass: {","        stacked: Y.StackedAxis,","        numeric: Y.NumericAxis,","        category: Y.CategoryAxis,","        time: Y.TimeAxis","    },","","    /**","     * Collection of axes.","     *","     * @property _axes","     * @type Array","     * @private","     */","    _axes: null,","","    /**","     * @method initializer","     * @private","     */","    initializer: function()","    {","        this._itemRenderQueue = [];","        this._seriesIndex = -1;","        this._itemIndex = -1;","        this.after(\"dataProviderChange\", this._dataProviderChangeHandler);","    },","","    /**","     * @method renderUI","     * @private","     */","    renderUI: function()","    {","        var tt = this.get(\"tooltip\"),","            bb = this.get(\"boundingBox\"),","            cb = this.get(\"contentBox\");","        //move the position = absolute logic to a class file","        bb.setStyle(\"position\", \"absolute\");","        cb.setStyle(\"position\", \"absolute\");","        this._addAxes();","        this._addSeries();","        if(tt && tt.show)","        {","            this._addTooltip();","        }","        this._setAriaElements(bb, cb);","    },","   ","    /**","     * Creates an aria `live-region`, `aria-label` and `aria-describedby` for the Chart.","     *","     * @method _setAriaElements","     * @param {Node} cb Reference to the Chart's `contentBox` attribute.","     * @private","     */","    _setAriaElements: function(bb, cb)","    {","        var description = this._getAriaOffscreenNode(),","            id = this.get(\"id\") + \"_description\",","            liveRegion = this._getAriaOffscreenNode();","        cb.set(\"tabIndex\", 0);","        cb.set(\"role\", \"img\");","        cb.setAttribute(\"aria-label\", this.get(\"ariaLabel\"));","        cb.setAttribute(\"aria-describedby\", id);","        description.set(\"id\", id);","        description.set(\"tabIndex\", -1);","        description.appendChild(DOCUMENT.createTextNode(this.get(\"ariaDescription\")));","        liveRegion.set(\"id\", \"live-region\");","        liveRegion.set(\"aria-live\", \"polite\");","        liveRegion.set(\"aria-atomic\", \"true\");","        liveRegion.set(\"role\", \"status\");","        bb.setAttribute(\"role\", \"application\");","        bb.appendChild(description);","        bb.appendChild(liveRegion);","        this._description = description;","        this._liveRegion = liveRegion;","    },","","    /**","     * Sets a node offscreen for use as aria-description or aria-live-regin.","     *","     * @method _setOffscreen","     * @return Node ","     * @private","     */","    _getAriaOffscreenNode: function()  ","    {","        var node = Y.Node.create(\"<div></div>\"),","            ie = Y.UA.ie,","            clipRect = (ie && ie < 8) ? \"rect(1px 1px 1px 1px)\" : \"rect(1px, 1px, 1px, 1px)\";","        node.setStyle(\"position\", \"absolute\");","        node.setStyle(\"height\", \"1px\"); ","        node.setStyle(\"width\", \"1px\"); ","        node.setStyle(\"overflow\", \"hidden\");","        node.setStyle(\"clip\", clipRect); ","        return node;","    },","  ","    /**","     * @method syncUI","     * @private","     */","    syncUI: function()","    {","        this._redraw();","    },","","    /**","     * @method bindUI","     * @private","     */","    bindUI: function()","    {","        this.after(\"tooltipChange\", Y.bind(this._tooltipChangeHandler, this));","        this.after(\"widthChange\", this._sizeChanged);","        this.after(\"heightChange\", this._sizeChanged);","        this.after(\"groupMarkersChange\", this._groupMarkersChangeHandler);","        var tt = this.get(\"tooltip\"),","            hideEvent = \"mouseout\",","            showEvent = \"mouseover\",","            cb = this.get(\"contentBox\"),","            interactionType = this.get(\"interactionType\"),","            i = 0,","            len,","            markerClassName = \".\" + SERIES_MARKER,","            isTouch = ((WINDOW && (\"ontouchstart\" in WINDOW)) && !(Y.UA.chrome && Y.UA.chrome < 6));","        Y.on(\"keydown\", Y.bind(function(e) {","            var key = e.keyCode,","                numKey = parseFloat(key),","                msg;","            if(numKey > 36 && numKey < 41)","            {","                e.halt();","                msg = this._getAriaMessage(numKey);","                this._liveRegion.setContent(\"\");","                this._liveRegion.appendChild(DOCUMENT.createTextNode(msg));","            }","        }, this), this.get(\"contentBox\"));","        if(interactionType == \"marker\")","        {","            //if touch capabilities, toggle tooltip on touchend. otherwise, the tooltip attribute's hideEvent/showEvent types.","            hideEvent = tt.hideEvent;","            showEvent = tt.showEvent;","            if(isTouch)","            {","                Y.delegate(\"touchend\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                //hide active tooltip if the chart is touched","                Y.on(\"touchend\", Y.bind(function(e) {","                    e.halt(true);","                    if(this._activeMarker)","                    {","                        this._activeMarker = null;","                        this.hideTooltip(e);","                    }","                }, this));","            }","            else","            {","                Y.delegate(\"mouseenter\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                Y.delegate(\"mousedown\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                Y.delegate(\"mouseup\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                Y.delegate(\"mouseleave\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                Y.delegate(\"click\", Y.bind(this._markerEventDispatcher, this), cb, markerClassName);","                Y.delegate(\"mousemove\", Y.bind(this._positionTooltip, this), cb, markerClassName);","            }","        }","        else if(interactionType == \"planar\")","        {","            if(isTouch)","            {","                this._overlay.on(\"touchend\", Y.bind(this._planarEventDispatcher, this));","            }","            else","            {","                this._overlay.on(\"mousemove\", Y.bind(this._planarEventDispatcher, this));","                this.on(\"mouseout\", this.hideTooltip);","            }","        }","        if(tt)","        {","            this.on(\"markerEvent:touchend\", Y.bind(function(e) {","                var marker = e.series.get(\"markers\")[e.index];","                if(this._activeMarker && marker === this._activeMarker)","                {","                    this._activeMarker = null;","                    this.hideTooltip(e);","                }","                else","                {","","                    this._activeMarker = marker;","                    tt.markerEventHandler.apply(this, [e]);","                }","            }, this));","            if(hideEvent && showEvent && hideEvent == showEvent)","            {","                this.on(interactionType + \"Event:\" + hideEvent, this.toggleTooltip);","            }","            else","            {","                if(showEvent)","                {","                    this.on(interactionType + \"Event:\" + showEvent, tt[interactionType + \"EventHandler\"]);","                }","                if(hideEvent)","                {","                    if(Y_Lang.isArray(hideEvent))","                    {","                        len = hideEvent.length;","                        for(; i < len; ++i)","                        {","                            this.on(interactionType + \"Event:\" + hideEvent[i], this.hideTooltip);","                        }","                    }","                    this.on(interactionType + \"Event:\" + hideEvent, this.hideTooltip);","                }","            }","        }","    },","    ","    /**","     * Event handler for marker events.","     *","     * @method _markerEventDispatcher","     * @param {Object} e Event object.","     * @private","     */","    _markerEventDispatcher: function(e)","    {","        var type = e.type,","            cb = this.get(\"contentBox\"),","            markerNode = e.currentTarget,","            strArr = markerNode.getAttribute(\"id\").split(\"_\"),","            index = strArr.pop(),","            seriesIndex = strArr.pop(),","            series = this.getSeries(parseInt(seriesIndex, 10)),","            items = this.getSeriesItems(series, index),","            isTouch = e && e.hasOwnProperty(\"changedTouches\"),","            pageX = isTouch ? e.changedTouches[0].pageX : e.pageX,","            pageY = isTouch ? e.changedTouches[0].pageY : e.pageY,","            x = pageX - cb.getX(),","            y = pageY - cb.getY();","        if(type == \"mouseenter\")","        {","            type = \"mouseover\";","        }","        else if(type == \"mouseleave\")","        {","            type = \"mouseout\";","        }","        series.updateMarkerState(type, index);","        e.halt();","        /**","         * Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseover event.","         * ","         *","         * @event markerEvent:mouseover","         * @preventable false","         * @param {EventFacade} e Event facade with the following additional","         *   properties:","         *  <dl>","         *      <dt>categoryItem</dt><dd>Hash containing information about the category `Axis`.</dd>","         *      <dt>valueItem</dt><dd>Hash containing information about the value `Axis`.</dd>","         *      <dt>node</dt><dd>The dom node of the marker.</dd>","         *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>series</dt><dd>Reference to the series of the marker.</dd>","         *      <dt>index</dt><dd>Index of the marker in the series.</dd>","         *      <dt>seriesIndex</dt><dd>The `order` of the marker's series.</dd>","         *  </dl>","         */","        /**","         * Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseout event.","         *","         * @event markerEvent:mouseout","         * @preventable false","         * @param {EventFacade} e Event facade with the following additional","         *   properties:","         *  <dl>","         *      <dt>categoryItem</dt><dd>Hash containing information about the category `Axis`.</dd>","         *      <dt>valueItem</dt><dd>Hash containing information about the value `Axis`.</dd>","         *      <dt>node</dt><dd>The dom node of the marker.</dd>","         *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>series</dt><dd>Reference to the series of the marker.</dd>","         *      <dt>index</dt><dd>Index of the marker in the series.</dd>","         *      <dt>seriesIndex</dt><dd>The `order` of the marker's series.</dd>","         *  </dl>","         */","        /**","         * Broadcasts when `interactionType` is set to `marker` and a series marker has received a mousedown event.","         *","         * @event markerEvent:mousedown","         * @preventable false","         * @param {EventFacade} e Event facade with the following additional","         *   properties:","         *  <dl>","         *      <dt>categoryItem</dt><dd>Hash containing information about the category `Axis`.</dd>","         *      <dt>valueItem</dt><dd>Hash containing information about the value `Axis`.</dd>","         *      <dt>node</dt><dd>The dom node of the marker.</dd>","         *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>series</dt><dd>Reference to the series of the marker.</dd>","         *      <dt>index</dt><dd>Index of the marker in the series.</dd>","         *      <dt>seriesIndex</dt><dd>The `order` of the marker's series.</dd>","         *  </dl>","         */","        /**","         * Broadcasts when `interactionType` is set to `marker` and a series marker has received a mouseup event.","         *","         * @event markerEvent:mouseup","         * @preventable false","         * @param {EventFacade} e Event facade with the following additional","         *   properties:","         *  <dl>","         *      <dt>categoryItem</dt><dd>Hash containing information about the category `Axis`.</dd>","         *      <dt>valueItem</dt><dd>Hash containing information about the value `Axis`.</dd>","         *      <dt>node</dt><dd>The dom node of the marker.</dd>","         *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>series</dt><dd>Reference to the series of the marker.</dd>","         *      <dt>index</dt><dd>Index of the marker in the series.</dd>","         *      <dt>seriesIndex</dt><dd>The `order` of the marker's series.</dd>","         *  </dl>","         */","        /**","         * Broadcasts when `interactionType` is set to `marker` and a series marker has received a click event.","         *","         * @event markerEvent:click","         * @preventable false","         * @param {EventFacade} e Event facade with the following additional","         *   properties:","         *  <dl>","         *      <dt>categoryItem</dt><dd>Hash containing information about the category `Axis`.</dd>","         *      <dt>valueItem</dt><dd>Hash containing information about the value `Axis`.</dd>","         *      <dt>node</dt><dd>The dom node of the marker.</dd>","         *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","         *      <dt>pageX</dt><dd>The x location of the event on the page (including scroll)</dd>","         *      <dt>pageY</dt><dd>The y location of the event on the page (including scroll)</dd>","         *      <dt>series</dt><dd>Reference to the series of the marker.</dd>","         *      <dt>index</dt><dd>Index of the marker in the series.</dd>","         *      <dt>seriesIndex</dt><dd>The `order` of the marker's series.</dd>","         *      <dt>originEvent</dt><dd>Underlying dom event.</dd>","         *  </dl>","         */","        this.fire(\"markerEvent:\" + type, {","            originEvent: e,","            pageX:pageX, ","            pageY:pageY, ","            categoryItem:items.category, ","            valueItem:items.value, ","            node:markerNode, ","            x:x, ","            y:y, ","            series:series, ","            index:index, ","            seriesIndex:seriesIndex","        });","    },","","    /**","     * Event handler for dataProviderChange.","     *","     * @method _dataProviderChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _dataProviderChangeHandler: function(e)","    {","        var dataProvider = e.newVal,","            axes,","            i,","            axis;","        this._seriesIndex = -1;","        this._itemIndex = -1;","        if(this instanceof Y.CartesianChart)","        {","            this.set(\"axes\", this.get(\"axes\"));","            this.set(\"seriesCollection\", this.get(\"seriesCollection\"));","        }","        axes = this.get(\"axes\");","        if(axes)","        {","            for(i in axes)","            {","                if(axes.hasOwnProperty(i))","                {","                    axis = axes[i];","                    if(axis instanceof Y.Axis)","                    {","                        if(axis.get(\"position\") != \"none\")","                        {","                            this._addToAxesRenderQueue(axis);","                        }","                        axis.set(\"dataProvider\", dataProvider);","                    }","                }","            }","        }","    },","    ","    /**","     * Event listener for toggling the tooltip. If a tooltip is visible, hide it. If not, it ","     * will create and show a tooltip based on the event object.","     * ","     * @method toggleTooltip","     * @param {Object} e Event object.","     */","    toggleTooltip: function(e)","    {","        var tt = this.get(\"tooltip\");","        if(tt.visible)","        {","            this.hideTooltip();","        }","        else","        {","            tt.markerEventHandler.apply(this, [e]);","        }","    },","","    /**","     * Shows a tooltip","     *","     * @method _showTooltip","     * @param {String} msg Message to dispaly in the tooltip.","     * @param {Number} x x-coordinate ","     * @param {Number} y y-coordinate","     * @private","     */","    _showTooltip: function(msg, x, y)","    {","        var tt = this.get(\"tooltip\"),","            node = tt.node;","        if(msg)","        {","            tt.visible = true;","            tt.setTextFunction(node, msg);","            node.setStyle(\"top\", y + \"px\");","            node.setStyle(\"left\", x + \"px\");","            node.setStyle(\"visibility\", \"visible\");","        }","    },","","    /**","     * Positions the tooltip","     *","     * @method _positionTooltip","     * @param {Object} e Event object.","     * @private","     */","    _positionTooltip: function(e)","    {","        var tt = this.get(\"tooltip\"),","            node = tt.node,","            cb = this.get(\"contentBox\"),","            x = (e.pageX + 10) - cb.getX(),","            y = (e.pageY + 10) - cb.getY();","        if(node)","        {","            node.setStyle(\"left\", x + \"px\");","            node.setStyle(\"top\", y + \"px\");","        }","    },","","    /**","     * Hides the default tooltip","     *","     * @method hideTooltip","     */","    hideTooltip: function()","    {","        var tt = this.get(\"tooltip\"),","            node = tt.node;","        tt.visible = false;","        node.set(\"innerHTML\", \"\");","        node.setStyle(\"left\", -10000);","        node.setStyle(\"top\", -10000);","        node.setStyle(\"visibility\", \"hidden\");","    },","","    /**","     * Adds a tooltip to the dom.","     *","     * @method _addTooltip","     * @private","     */","    _addTooltip: function()","    {","        var tt = this.get(\"tooltip\"),","            id = this.get(\"id\") + \"_tooltip\",","            cb = this.get(\"contentBox\"),","            oldNode = DOCUMENT.getElementById(id);","        if(oldNode)","        {","            cb.removeChild(oldNode);","        }","        tt.node.set(\"id\", id);","        tt.node.setStyle(\"visibility\", \"hidden\");","        cb.appendChild(tt.node);","    },","","    /**","     * Updates the tooltip attribute.","     *","     * @method _updateTooltip","     * @param {Object} val Object containing properties for the tooltip.","     * @return Object","     * @private","     */","    _updateTooltip: function(val)","    {","        var tt = this.get(\"tooltip\") || this._getTooltip(),","            i,","            styles,","            node,","            props = {","                markerLabelFunction:\"markerLabelFunction\",","                planarLabelFunction:\"planarLabelFunction\",","                setTextFunction:\"setTextFunction\",","                showEvent:\"showEvent\",","                hideEvent:\"hideEvent\",","                markerEventHandler:\"markerEventHandler\",","                planarEventHandler:\"planarEventHandler\",","                show:\"show\"","            };","        if(Y_Lang.isObject(val))","        {","            styles = val.styles;","            node = Y.one(val.node) || tt.node;","            if(styles)","            {","                for(i in styles)","                {","                    if(styles.hasOwnProperty(i))","                    {","                        node.setStyle(i, styles[i]);","                    }","                }","            }","            for(i in props)","            {","                if(val.hasOwnProperty(i))","                {","                    tt[i] = val[i];","                }","            }","            tt.node = node;","        }","        return tt;","    },","","    /**","     * Default getter for `tooltip` attribute.","     *","     * @method _getTooltip","     * @return Object","     * @private","     */","    _getTooltip: function()","    {","        var node = DOCUMENT.createElement(\"div\"),","            tooltipClass = _getClassName(\"chart-tooltip\"),","            tt = {","                setTextFunction: this._setText,","                markerLabelFunction: this._tooltipLabelFunction,","                planarLabelFunction: this._planarLabelFunction,","                show: true,","                hideEvent: \"mouseout\",","                showEvent: \"mouseover\",","                markerEventHandler: function(e)","                {","                    var tt = this.get(\"tooltip\"),","                    msg = tt.markerLabelFunction.apply(this, [e.categoryItem, e.valueItem, e.index, e.series, e.seriesIndex]);","                    this._showTooltip(msg, e.x + 10, e.y + 10);","                },","                planarEventHandler: function(e)","                {","                    var tt = this.get(\"tooltip\"),","                        msg ,","                        categoryAxis = this.get(\"categoryAxis\");","                    msg = tt.planarLabelFunction.apply(this, [categoryAxis, e.valueItem, e.index, e.items, e.seriesIndex]);","                    this._showTooltip(msg, e.x + 10, e.y + 10);","                }","            };","        node = Y.one(node);","        node.set(\"id\", this.get(\"id\") + \"_tooltip\");","        node.setStyle(\"fontSize\", \"85%\");","        node.setStyle(\"opacity\", \"0.83\");","        node.setStyle(\"position\", \"absolute\");","        node.setStyle(\"paddingTop\", \"2px\");","        node.setStyle(\"paddingRight\", \"5px\");","        node.setStyle(\"paddingBottom\", \"4px\");","        node.setStyle(\"paddingLeft\", \"2px\");","        node.setStyle(\"backgroundColor\", \"#fff\");","        node.setStyle(\"border\", \"1px solid #dbdccc\");","        node.setStyle(\"pointerEvents\", \"none\");","        node.setStyle(\"zIndex\", 3);","        node.setStyle(\"whiteSpace\", \"noWrap\");","        node.setStyle(\"visibility\", \"hidden\");","        node.addClass(tooltipClass);","        tt.node = Y.one(node);","        return tt;","    },","","    /**","     * Formats tooltip text when `interactionType` is `planar`.","     *","     * @method _planarLabelFunction","     * @param {Axis} categoryAxis Reference to the categoryAxis of the chart.","     * @param {Array} valueItems Array of objects for each series that has a data point in the coordinate plane of the event. Each object contains the following data:","     *  <dl>","     *      <dt>axis</dt><dd>The value axis of the series.</dd>","     *      <dt>key</dt><dd>The key for the series.</dd>","     *      <dt>value</dt><dd>The value for the series item.</dd>","     *      <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>","     *  </dl> ","     *  @param {Number} index The index of the item within its series.","     *  @param {Array} seriesArray Array of series instances for each value item.","     *  @param {Number} seriesIndex The index of the series in the `seriesCollection`.","     *  @return {String | HTML} ","     * @private","     */","    _planarLabelFunction: function(categoryAxis, valueItems, index, seriesArray, seriesIndex)","    {","        var msg = DOCUMENT.createElement(\"div\"),","            valueItem,","            i = 0,","            len = seriesArray.length,","            axis,","            categoryValue,","            seriesValue,","            series;","        if(categoryAxis)","        {","            categoryValue = categoryAxis.get(\"labelFunction\").apply(this, [categoryAxis.getKeyValueAt(this.get(\"categoryKey\"), index), categoryAxis.get(\"labelFormat\")]);","            if(!Y_Lang.isObject(categoryValue))","            {","                categoryValue = DOCUMENT.createTextNode(categoryValue);","            }","            msg.appendChild(categoryValue);","        }","","        for(; i < len; ++i)","        {","            series = seriesArray[i];","            if(series.get(\"visible\"))","            {","                valueItem = valueItems[i];","                axis = valueItem.axis;","                seriesValue =  axis.get(\"labelFunction\").apply(this, [axis.getKeyValueAt(valueItem.key, index), axis.get(\"labelFormat\")]);","                msg.appendChild(DOCUMENT.createElement(\"br\"));","                msg.appendChild(DOCUMENT.createTextNode(valueItem.displayName));","                msg.appendChild(DOCUMENT.createTextNode(\": \"));","                if(!Y_Lang.isObject(seriesValue))","                {","                    seriesValue = DOCUMENT.createTextNode(seriesValue);","                }","                msg.appendChild(seriesValue);","            }","        }","        return msg;","    },","","    /**","     * Formats tooltip text when `interactionType` is `marker`.","     *","     * @method _tooltipLabelFunction","     * @param {Object} categoryItem An object containing the following:","     *  <dl>","     *      <dt>axis</dt><dd>The axis to which the category is bound.</dd>","     *      <dt>displayName</dt><dd>The display name set to the category (defaults to key if not provided)</dd>","     *      <dt>key</dt><dd>The key of the category.</dd>","     *      <dt>value</dt><dd>The value of the category</dd>","     *  </dl>","     * @param {Object} valueItem An object containing the following:","     *  <dl>","     *      <dt>axis</dt><dd>The axis to which the item's series is bound.</dd>","     *      <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>","     *      <dt>key</dt><dd>The key for the series.</dd>","     *      <dt>value</dt><dd>The value for the series item.</dd> ","     *  </dl>","     * @param {Number} itemIndex The index of the item within the series.","     * @param {CartesianSeries} series The `CartesianSeries` instance of the item.","     * @param {Number} seriesIndex The index of the series in the `seriesCollection`.","     * @return {String | HTML}","     * @private","     */","    _tooltipLabelFunction: function(categoryItem, valueItem, itemIndex, series, seriesIndex)","    {","        var msg = DOCUMENT.createElement(\"div\"),","            categoryValue = categoryItem.axis.get(\"labelFunction\").apply(this, [categoryItem.value, categoryItem.axis.get(\"labelFormat\")]),","            seriesValue = valueItem.axis.get(\"labelFunction\").apply(this, [valueItem.value, valueItem.axis.get(\"labelFormat\")]);","        msg.appendChild(DOCUMENT.createTextNode(categoryItem.displayName)); ","        msg.appendChild(DOCUMENT.createTextNode(\": \")); ","        if(!Y_Lang.isObject(categoryValue))","        {","            categoryValue = DOCUMENT.createTextNode(categoryValue);","        }","        msg.appendChild(categoryValue);","        msg.appendChild(DOCUMENT.createElement(\"br\"));","        msg.appendChild(DOCUMENT.createTextNode(valueItem.displayName)); ","        msg.appendChild(DOCUMENT.createTextNode(\": \")); ","        if(!Y_Lang.isObject(seriesValue))","        {","            seriesValue = DOCUMENT.createTextNode(seriesValue);","        }","        msg.appendChild(seriesValue);","        return msg; ","    },","","    /**","     * Event handler for the tooltipChange.","     *","     * @method _tooltipChangeHandler","     * @param {Object} e Event object.","     * @private","     */","    _tooltipChangeHandler: function(e)","    {","        if(this.get(\"tooltip\"))","        {","            var tt = this.get(\"tooltip\"),","                node = tt.node,","                show = tt.show,","                cb = this.get(\"contentBox\");","            if(node && show)","            {","                if(!cb.contains(node))","                {","                    this._addTooltip();","                }","            }","        }","    },","    ","    /**","     * Updates the content of text field. This method writes a value into a text field using ","     * `appendChild`. If the value is a `String`, it is converted to a `TextNode` first. ","     *","     * @method _setText","     * @param label {HTMLElement} label to be updated","     * @param val {String} value with which to update the label","     * @private","     */","    _setText: function(textField, val)","    { ","        textField.setContent(\"\");","        if(Y_Lang.isNumber(val))","        {","            val = val + \"\";","        }","        else if(!val)","        {","            val = \"\";","        }","        if(IS_STRING(val))","        {","            val = DOCUMENT.createTextNode(val);","        }","        textField.appendChild(val);","    },","","    /**","     * Returns all the keys contained in a  `dataProvider`.","     *","     * @method _getAllKeys","     * @param {Array} dp Collection of objects to be parsed.","     * @return Object","     */","    _getAllKeys: function(dp)","    {","        var i = 0,","            len = dp.length,","            item,","            key,","            keys = {};","        for(; i < len; ++i)","        {","            item = dp[i];","            for(key in item)","            {","                if(item.hasOwnProperty(key))","                {","                    keys[key] = true;","                }","            }","        }","        return keys;","    },","    ","    /**","     * Constructs seriesKeys if not explicitly specified.","     *","     * @method _buildSeriesKeys","     * @param {Array} dataProvider The dataProvider for the chart.","     * @return Array","     * @private","     */","    _buildSeriesKeys: function(dataProvider)","    {","        var allKeys,","            catKey = this.get(\"categoryKey\"),","            keys = [],","            i;","        if(this._seriesKeysExplicitlySet)","        {","            return this._seriesKeys;","        }","        allKeys = this._getAllKeys(dataProvider);","        for(i in allKeys)","        {","            if(allKeys.hasOwnProperty(i) && i != catKey)","            {","                keys.push(i);","            }","        }","        return keys;","    }","};","Y.ChartBase = ChartBase;","/**"," * The CartesianChart class creates a chart with horizontal and vertical axes."," *"," * @module charts"," * @submodule charts-base"," * @class CartesianChart"," * @extends ChartBase"," * @constructor"," */","Y.CartesianChart = Y.Base.create(\"cartesianChart\", Y.Widget, [Y.ChartBase], {","    /**","     * @method renderUI","     * @private","     */","    renderUI: function()","    {","        var bb = this.get(\"boundingBox\"),","            cb = this.get(\"contentBox\"),","            tt = this.get(\"tooltip\"),","            overlay,","            overlayClass = _getClassName(\"overlay\");","        //move the position = absolute logic to a class file","        bb.setStyle(\"position\", \"absolute\");","        cb.setStyle(\"position\", \"absolute\");","        this._addAxes();","        this._addGridlines();","        this._addSeries();","        if(tt && tt.show)","        {","            this._addTooltip();","        }","        //If there is a style definition. Force them to set.","        this.get(\"styles\");","        if(this.get(\"interactionType\") == \"planar\")","        {","            overlay = DOCUMENT.createElement(\"div\");","            this.get(\"contentBox\").appendChild(overlay);","            this._overlay = Y.one(overlay); ","            this._overlay.set(\"id\", this.get(\"id\") + \"_overlay\");","            this._overlay.setStyle(\"position\", \"absolute\");","            this._overlay.setStyle(\"background\", \"#fff\");","            this._overlay.setStyle(\"opacity\", 0);","            this._overlay.addClass(overlayClass);","            this._overlay.setStyle(\"zIndex\", 4);","        }","        this._setAriaElements(bb, cb);","        this._redraw();","    },","","    /**","     * When `interactionType` is set to `planar`, listens for mouse move events and fires `planarEvent:mouseover` or `planarEvent:mouseout` depending on the position of the mouse in relation to ","     * data points on the `Chart`.","     *","     * @method _planarEventDispatcher","     * @param {Object} e Event object.","     * @private","     */","    _planarEventDispatcher: function(e)","    {","        var graph = this.get(\"graph\"),","            bb = this.get(\"boundingBox\"),","            cb = graph.get(\"contentBox\"),","            isTouch = e && e.hasOwnProperty(\"changedTouches\"),","            pageX = isTouch ? e.changedTouches[0].pageX : e.pageX,","            pageY = isTouch ? e.changedTouches[0].pageY : e.pageY,","            posX = pageX - bb.getX(),","            posY = pageY - bb.getY(),","            offset = {","                x: pageX - cb.getX(),","                y: pageY - cb.getY()","            },","            sc = graph.get(\"seriesCollection\"),","            series,","            i = 0,","            index,","            oldIndex = this._selectedIndex,","            item,","            items = [],","            categoryItems = [],","            valueItems = [],","            direction = this.get(\"direction\"),","            hasMarkers,","            catAxis,","            valAxis,","            coord,","            //data columns and area data could be created on a graph level","            markerPlane,","            len,","            coords;","        e.halt(true);","        if(direction == \"horizontal\")","        {","            catAxis = \"x\";","            valAxis = \"y\";","        }","        else","        {","            valAxis = \"x\";","            catAxis = \"y\";","        }","        coord = offset[catAxis];","        if(sc)","        {","            len = sc.length;","            while(i < len && !markerPlane)","            {","                if(sc[i])","                {","                    markerPlane = sc[i].get(catAxis + \"MarkerPlane\");","                }","                i++;","            }","        }","        if(markerPlane)","        {","            len = markerPlane.length;","            for(i = 0; i < len; ++i)","            {","                if(coord <= markerPlane[i].end && coord >= markerPlane[i].start)","                {","                    index = i;","                    break;","                }","            }","            len = sc.length;","            for(i = 0; i < len; ++i)","            {","                series = sc[i];","                coords = series.get(valAxis + \"coords\");","                hasMarkers = series.get(\"markers\");","                if(hasMarkers && !isNaN(oldIndex) && oldIndex > -1)","                {","                    series.updateMarkerState(\"mouseout\", oldIndex);","                }","                if(coords && coords[index] > -1)","                {","                    if(hasMarkers && !isNaN(index) && index > -1)","                    {","                        series.updateMarkerState(\"mouseover\", index);","                    }","                    item = this.getSeriesItems(series, index);","                    categoryItems.push(item.category);","                    valueItems.push(item.value);","                    items.push(series);","                }","                    ","            }","            this._selectedIndex = index;","","            /**","             * Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseover event.","             * ","             *","             * @event planarEvent:mouseover","             * @preventable false","             * @param {EventFacade} e Event facade with the following additional","             *   properties:","             *  <dl>","             *      <dt>categoryItem</dt><dd>An array of hashes, each containing information about the category `Axis` of each marker whose plane has been intersected.</dd>","             *      <dt>valueItem</dt><dd>An array of hashes, each containing information about the value `Axis` of each marker whose plane has been intersected.</dd>","             *      <dt>x</dt><dd>The x-coordinate of the mouse in relation to the Chart.</dd>","             *      <dt>y</dt><dd>The y-coordinate of the mouse in relation to the Chart.</dd>","             *      <dt>pageX</dt><dd>The x location of the event on the page (including scroll)</dd>","             *      <dt>pageY</dt><dd>The y location of the event on the page (including scroll)</dd>","             *      <dt>items</dt><dd>An array including all the series which contain a marker whose plane has been intersected.</dd>","             *      <dt>index</dt><dd>Index of the markers in their respective series.</dd>","             *      <dt>originEvent</dt><dd>Underlying dom event.</dd>","             *  </dl>","             */","            /**","             * Broadcasts when `interactionType` is set to `planar` and a series' marker plane has received a mouseout event.","             *","             * @event planarEvent:mouseout","             * @preventable false","             * @param {EventFacade} e ","             */","            if(index > -1)","            {","                this.fire(\"planarEvent:mouseover\", {","                    categoryItem:categoryItems, ","                    valueItem:valueItems, ","                    x:posX, ","                    y:posY, ","                    pageX:pageX,","                    pageY:pageY,","                    items:items, ","                    index:index,","                    originEvent:e","                });","            }","            else","            {","                this.fire(\"planarEvent:mouseout\");","            }","        }","    },","","    /**","     * Indicates the default series type for the chart.","     *","     * @property _type","     * @type {String}","     * @private","     */","    _type: \"combo\",","","    /**","     * Queue of axes instances that will be updated. This method is used internally to determine when all axes have been updated.","     *","     * @property _itemRenderQueue","     * @type Array","     * @private","     */","    _itemRenderQueue: null,","","    /**","     * Adds an `Axis` instance to the `_itemRenderQueue`.","     *","     * @method _addToAxesRenderQueue","     * @param {Axis} axis An `Axis` instance.","     * @private ","     */","    _addToAxesRenderQueue: function(axis)","    {","        if(!this._itemRenderQueue)","        {","            this._itemRenderQueue = [];","        }","        if(Y.Array.indexOf(this._itemRenderQueue, axis) < 0)","        {","            this._itemRenderQueue.push(axis);","        }","    },","","    /**","     * Adds axis instance to the appropriate array based on position","     *","     * @method _addToAxesCollection","     * @param {String} position The position of the axis","     * @param {Axis} axis The `Axis` instance","     */","    _addToAxesCollection: function(position, axis)","    {","        var axesCollection = this.get(position + \"AxesCollection\");","        if(!axesCollection)","        {","            axesCollection = [];","            this.set(position + \"AxesCollection\", axesCollection);","        }","        axesCollection.push(axis);","    },","","    /**","     * Returns the default value for the `seriesCollection` attribute.","     *","     * @method _getDefaultSeriesCollection","     * @param {Array} val Array containing either `CartesianSeries` instances or objects containing data to construct series instances.","     * @return Array","     * @private","     */","    _getDefaultSeriesCollection: function()","    {","        var seriesCollection,","            dataProvider = this.get(\"dataProvider\");","        if(dataProvider)","        {","            seriesCollection = this._parseSeriesCollection();","        }","        return seriesCollection;","    },","","    /**","     * Parses and returns a series collection from an object and default properties.","     *","     * @method _parseSeriesCollection","     * @param {Object} val Object contain properties for series being set.","     * @return Object","     * @private","     */","    _parseSeriesCollection: function(val)","    {","        var dir = this.get(\"direction\"), ","            sc = [], ","            catAxis,","            valAxis,","            tempKeys = [],","            series,","            seriesKeys = this.get(\"seriesKeys\").concat(),","            i,","            index,","            l,","            type = this.get(\"type\"),","            key,","            catKey,","            seriesKey,","            graph,","            orphans = [],","            categoryKey = this.get(\"categoryKey\"),","            showMarkers = this.get(\"showMarkers\"),","            showAreaFill = this.get(\"showAreaFill\"),","            showLines = this.get(\"showLines\");","        val = val || []; ","        if(dir == \"vertical\")","        {","            catAxis = \"yAxis\";","            catKey = \"yKey\";","            valAxis = \"xAxis\";","            seriesKey = \"xKey\";","        }","        else","        {","            catAxis = \"xAxis\";","            catKey = \"xKey\";","            valAxis = \"yAxis\";","            seriesKey = \"yKey\";","        }","        l = val.length;","        while(val && val.length > 0)","        {","            series = val.shift();","            key = this._getBaseAttribute(series, seriesKey);","            if(key)","            {","                index = Y.Array.indexOf(seriesKeys, key);","                if(index > -1)","                {","                    seriesKeys.splice(index, 1);","                    tempKeys.push(key);","                    sc.push(series);","                }","                else","                {","                    orphans.push(series);","                }","            }","            else","            {","                orphans.push(series);","            }","        }","        while(orphans.length > 0)","        {","            series = orphans.shift();","            if(seriesKeys.length > 0)","            {","                key = seriesKeys.shift();","                this._setBaseAttribute(series, seriesKey, key);","                tempKeys.push(key);","                sc.push(series);","            }","            else if(series instanceof Y.CartesianSeries)","            {","                series.destroy(true);","            }","        }","        if(seriesKeys.length > 0)","        {","            tempKeys = tempKeys.concat(seriesKeys);","        }","        l = tempKeys.length;","        for(i = 0; i < l; ++i)","        {","            series = sc[i] || {type:type};","            if(series instanceof Y.CartesianSeries)","            {","                this._parseSeriesAxes(series);","                continue;","            }","","            series[catKey] = series[catKey] || categoryKey;","            series[seriesKey] = series[seriesKey] || seriesKeys.shift();","            series[catAxis] = this._getCategoryAxis();","            series[valAxis] = this._getSeriesAxis(series[seriesKey]);","                ","            series.type = series.type || type;","            series.direction = series.direction || dir;","            ","            if((series.type == \"combo\" || series.type == \"stackedcombo\" || series.type == \"combospline\" || series.type == \"stackedcombospline\"))","            {","                if(showAreaFill !== null)","                {","                    series.showAreaFill = (series.showAreaFill !== null && series.showAreaFill !== undefined) ? series.showAreaFill : showAreaFill;","                }","                if(showMarkers !== null)","                {","                    series.showMarkers = (series.showMarkers !== null && series.showMarkers !== undefined) ? series.showMarkers : showMarkers;","                }","                if(showLines !== null)","                {","                    series.showLines = (series.showLines !== null && series.showLines !== undefined) ? series.showLines : showLines;","                }","            }","            sc[i] = series;","        }","        if(sc)","        {","            graph = this.get(\"graph\");","            graph.set(\"seriesCollection\", sc);","            sc = graph.get(\"seriesCollection\");","        }","        return sc;","    },","","    /**","     * Parse and sets the axes for a series instance.","     *","     * @method _parseSeriesAxes","     * @param {CartesianSeries} series A `CartesianSeries` instance.","     * @private","     */","    _parseSeriesAxes: function(series)","    {","        var axes = this.get(\"axes\"),","            xAxis = series.get(\"xAxis\"),","            yAxis = series.get(\"yAxis\"),","            YAxis = Y.Axis,","            axis;","        if(xAxis && !(xAxis instanceof YAxis) && Y_Lang.isString(xAxis) && axes.hasOwnProperty(xAxis))","        {","            axis = axes[xAxis];","            if(axis instanceof YAxis)","            {","                series.set(\"xAxis\", axis);","            }","        }","        if(yAxis && !(yAxis instanceof YAxis) && Y_Lang.isString(yAxis) && axes.hasOwnProperty(yAxis))","        {   ","            axis = axes[yAxis];","            if(axis instanceof YAxis)","            {","                series.set(\"yAxis\", axis);","            }","        }","","    },","","    /**","     * Returns the category axis instance for the chart.","     *","     * @method _getCategoryAxis","     * @return Axis","     * @private","     */","    _getCategoryAxis: function()","    {","        var axis,","            axes = this.get(\"axes\"),","            categoryAxisName = this.get(\"categoryAxisName\") || this.get(\"categoryKey\");","        axis = axes[categoryAxisName];","        return axis;","    },","","    /**","     * Returns the value axis for a series.","     *","     * @method _getSeriesAxis","     * @param {String} key The key value used to determine the axis instance.","     * @return Axis","     * @private","     */","    _getSeriesAxis:function(key, axisName)","    {","        var axes = this.get(\"axes\"),","            i,","            keys,","            axis;","        if(axes)","        {","            if(axisName && axes.hasOwnProperty(axisName))","            {","                axis = axes[axisName];","            }","            else","            {","                for(i in axes)","                {","                    if(axes.hasOwnProperty(i))","                    {","                        keys = axes[i].get(\"keys\");","                        if(keys && keys.hasOwnProperty(key))","                        {","                            axis = axes[i];","                            break;","                        }","                    }","                }","            }","        }","        return axis;","    },","","    /**","     * Gets an attribute from an object, using a getter for Base objects and a property for object","     * literals. Used for determining attributes from series/axis references which can be an actual class instance","     * or a hash of properties that will be used to create a class instance.","     *","     * @method _getBaseAttribute","     * @param {Object} item Object or instance in which the attribute resides.","     * @param {String} key Attribute whose value will be returned.","     * @return Object","     * @private","     */","    _getBaseAttribute: function(item, key)","    {","        if(item instanceof Y.Base)","        {","            return item.get(key);","        }","        if(item.hasOwnProperty(key))","        {","            return item[key];","        }","        return null;","    },","","    /**","     * Sets an attribute on an object, using a setter of Base objects and a property for object","     * literals. Used for setting attributes on a Base class, either directly or to be stored in an object literal","     * for use at instantiation.","     *","     * @method _setBaseAttribute","     * @param {Object} item Object or instance in which the attribute resides.","     * @param {String} key Attribute whose value will be assigned.","     * @param {Object} value Value to be assigned to the attribute.","     * @private","     */","    _setBaseAttribute: function(item, key, value)","    {","        if(item instanceof Y.Base)","        {","            item.set(key, value);","        }","        else","        {","            item[key] = value;","        }","    },","","    /**","     * Creates `Axis` instances.","     *","     * @method _setAxes","     * @param {Object} val Object containing `Axis` instances or objects in which to construct `Axis` instances.","     * @return Object","     * @private","     */","    _setAxes: function(val)","    {","        var hash = this._parseAxes(val),","            axes = {},","            axesAttrs = {","                edgeOffset: \"edgeOffset\", ","                position: \"position\",","                overlapGraph:\"overlapGraph\",","                labelFunction:\"labelFunction\",","                labelFunctionScope:\"labelFunctionScope\",","                labelFormat:\"labelFormat\",","                appendLabelFunction: \"appendLabelFunction\",","                appendTitleFunction: \"appendTitleFunction\",","                maximum:\"maximum\",","                minimum:\"minimum\", ","                roundingMethod:\"roundingMethod\",","                alwaysShowZero:\"alwaysShowZero\",","                title:\"title\",","                width:\"width\",","                height:\"height\"","            },","            dp = this.get(\"dataProvider\"),","            ai,","            i, ","            pos, ","            axis,","            axisPosition,","            dh, ","            axisClass, ","            config,","            axesCollection;","        for(i in hash)","        {","            if(hash.hasOwnProperty(i))","            {","                dh = hash[i];","                if(dh instanceof Y.Axis)","                {","                    axis = dh;","                }","                else","                {","                    axis = null;","                    config = {};","                    config.dataProvider = dh.dataProvider || dp;","                    config.keys = dh.keys;","                    ","                    if(dh.hasOwnProperty(\"roundingUnit\"))","                    {","                        config.roundingUnit = dh.roundingUnit;","                    }","                    pos = dh.position;","                    if(dh.styles)","                    {","                        config.styles = dh.styles;","                    }","                    config.position = dh.position;","                    for(ai in axesAttrs)","                    {","                        if(axesAttrs.hasOwnProperty(ai) && dh.hasOwnProperty(ai))","                        {","                            config[ai] = dh[ai];","                        }","                    }","                   ","                    //only check for existing axis if we constructed the default axes already","                    if(val)","                    {","                        axis = this.getAxisByKey(i);","                    }","                    ","                    if(axis && axis instanceof Y.Axis)","                    {","                        axisPosition = axis.get(\"position\");","                        if(pos != axisPosition)","                        {","                            if(axisPosition != \"none\")","                            {","                                axesCollection = this.get(axisPosition + \"AxesCollection\");","                                axesCollection.splice(Y.Array.indexOf(axesCollection, axis), 1);","                            }","                            if(pos != \"none\")","                            {","                                this._addToAxesCollection(pos, axis);","                            }","                        }","                        axis.setAttrs(config);","                    }","                    else","                    {","                        axisClass = this._getAxisClass(dh.type);","                        axis = new axisClass(config);","                        axis.after(\"axisRendered\", Y.bind(this._itemRendered, this));","                    }","                }","","                if(axis)","                {","                    axesCollection = this.get(pos + \"AxesCollection\");","                    if(axesCollection && Y.Array.indexOf(axesCollection, axis) > 0)","                    {","                        axis.set(\"overlapGraph\", false);","                    }","                    axes[i] = axis;","                }","            }","        }","        return axes;","    },","    ","    /**","     * Adds axes to the chart.","     *","     * @method _addAxes","     * @private","     */","    _addAxes: function()","    {","        var axes = this.get(\"axes\"),","            i, ","            axis, ","            pos,","            w = this.get(\"width\"),","            h = this.get(\"height\"),","            node = Y.Node.one(this._parentNode);","        if(!this._axesCollection)","        {   ","            this._axesCollection = [];","        }","        for(i in axes)","        {","            if(axes.hasOwnProperty(i))","            {","                axis = axes[i];","                if(axis instanceof Y.Axis)","                {","                    if(!w)","                    {","                        this.set(\"width\", node.get(\"offsetWidth\"));","                        w = this.get(\"width\");","                    }","                    if(!h)","                    {","                        this.set(\"height\", node.get(\"offsetHeight\"));","                        h = this.get(\"height\");","                    }","                    this._addToAxesRenderQueue(axis);","                    pos = axis.get(\"position\");","                    if(!this.get(pos + \"AxesCollection\"))","                    {","                        this.set(pos + \"AxesCollection\", [axis]);","                    }","                    else","                    {","                        this.get(pos + \"AxesCollection\").push(axis);","                    }","                    this._axesCollection.push(axis);","                    if(axis.get(\"keys\").hasOwnProperty(this.get(\"categoryKey\")))","                    {","                        this.set(\"categoryAxis\", axis);","                    }","                    axis.render(this.get(\"contentBox\"));","                }","            }","        }","    },","","    /**","     * Renders the Graph.","     *","     * @method _addSeries","     * @private","     */","    _addSeries: function()","    {","        var graph = this.get(\"graph\"),","            sc = this.get(\"seriesCollection\");","        graph.render(this.get(\"contentBox\"));","","    },","","    /**","     * Adds gridlines to the chart.","     *","     * @method _addGridlines","     * @private","     */","    _addGridlines: function()","    {","        var graph = this.get(\"graph\"),","            hgl = this.get(\"horizontalGridlines\"),","            vgl = this.get(\"verticalGridlines\"),","            direction = this.get(\"direction\"),","            leftAxesCollection = this.get(\"leftAxesCollection\"),","            rightAxesCollection = this.get(\"rightAxesCollection\"),","            bottomAxesCollection = this.get(\"bottomAxesCollection\"),","            topAxesCollection = this.get(\"topAxesCollection\"),","            seriesAxesCollection,","            catAxis = this.get(\"categoryAxis\"),","            hAxis,","            vAxis;","        if(this._axesCollection)","        {","            seriesAxesCollection = this._axesCollection.concat();","            seriesAxesCollection.splice(Y.Array.indexOf(seriesAxesCollection, catAxis), 1);","        }","        if(hgl)","        {","            if(leftAxesCollection && leftAxesCollection[0])","            {","                hAxis = leftAxesCollection[0];","            }","            else if(rightAxesCollection && rightAxesCollection[0])","            {","                hAxis = rightAxesCollection[0];","            }","            else ","            {","                hAxis = direction == \"horizontal\" ? catAxis : seriesAxesCollection[0];","            }","            if(!this._getBaseAttribute(hgl, \"axis\") && hAxis)","            {","                this._setBaseAttribute(hgl, \"axis\", hAxis);","            }","            if(this._getBaseAttribute(hgl, \"axis\"))","            {","                graph.set(\"horizontalGridlines\", hgl);","            }","        }","        if(vgl)","        {","            if(bottomAxesCollection && bottomAxesCollection[0])","            {","                vAxis = bottomAxesCollection[0];","            }","            else if (topAxesCollection && topAxesCollection[0])","            {","                vAxis = topAxesCollection[0];","            }","            else ","            {","                vAxis = direction == \"vertical\" ? catAxis : seriesAxesCollection[0];","            }","            if(!this._getBaseAttribute(vgl, \"axis\") && vAxis)","            {","                this._setBaseAttribute(vgl, \"axis\", vAxis);","            }","            if(this._getBaseAttribute(vgl, \"axis\"))","            {","                graph.set(\"verticalGridlines\", vgl);","            }","        }","    },","    ","    /**","     * Default Function for the axes attribute.","     *","     * @method _getDefaultAxes","     * @return Object","     * @private","     */","    _getDefaultAxes: function()","    {","        var axes;","        if(this.get(\"dataProvider\"))","        {","            axes = this._parseAxes();","        }","        return axes;","    },","","    /**","     * Generates and returns a key-indexed object containing `Axis` instances or objects used to create `Axis` instances.","     *","     * @method _parseAxes","     * @param {Object} axes Object containing `Axis` instances or `Axis` attributes.","     * @return Object","     * @private","     */","    _parseAxes: function(axes)","    {","        var catKey = this.get(\"categoryKey\"),","            axis,","            attr,","            keys,","            newAxes = {},","            claimedKeys = [],","            categoryAxisName = this.get(\"categoryAxisName\") || this.get(\"categoryKey\"),","            valueAxisName = this.get(\"valueAxisName\"),","            seriesKeys = this.get(\"seriesKeys\").concat(),","            i, ","            l,","            ii,","            ll,","            cIndex,","            direction = this.get(\"direction\"),","            seriesPosition,","            categoryPosition,","            valueAxes = [],","            seriesAxis = this.get(\"stacked\") ? \"stacked\" : \"numeric\";","        if(direction == \"vertical\")","        {","            seriesPosition = \"bottom\";","            categoryPosition = \"left\";","        }","        else","        {","            seriesPosition = \"left\";","            categoryPosition = \"bottom\";","        }","        if(axes)","        {","            for(i in axes)","            {","                if(axes.hasOwnProperty(i))","                {","                    axis = axes[i];","                    keys = this._getBaseAttribute(axis, \"keys\");","                    attr = this._getBaseAttribute(axis, \"type\");","                    if(attr == \"time\" || attr == \"category\")","                    {","                        categoryAxisName = i;","                        this.set(\"categoryAxisName\", i);","                        if(Y_Lang.isArray(keys) && keys.length > 0)","                        {","                            catKey = keys[0];","                            this.set(\"categoryKey\", catKey);","                        }","                        newAxes[i] = axis;","                    }","                    else if(i == categoryAxisName)","                    {","                        newAxes[i] = axis;","                    }","                    else ","                    {","                        newAxes[i] = axis;","                        if(i != valueAxisName && keys && Y_Lang.isArray(keys))","                        {","                            ll = keys.length;","                            for(ii = 0; ii < ll; ++ii)","                            {","                                claimedKeys.push(keys[ii]);","                            }","                            valueAxes.push(newAxes[i]);","                        }","                        if(!(this._getBaseAttribute(newAxes[i], \"type\")))","                        {","                            this._setBaseAttribute(newAxes[i], \"type\", seriesAxis);","                        }","                        if(!(this._getBaseAttribute(newAxes[i], \"position\")))","                        {","                            this._setBaseAttribute(newAxes[i], \"position\", this._getDefaultAxisPosition(newAxes[i], valueAxes, seriesPosition));","                        }","                    }","                }","            }","        }","        cIndex = Y.Array.indexOf(seriesKeys, catKey);","        if(cIndex > -1)","        {","            seriesKeys.splice(cIndex, 1);","        }","        l = claimedKeys.length;","        for(i = 0; i < l; ++i)","        {","            cIndex = Y.Array.indexOf(seriesKeys, claimedKeys[i]); ","            if(cIndex > -1)","            {","                seriesKeys.splice(cIndex, 1);","            }","        }","        if(!newAxes.hasOwnProperty(categoryAxisName))","        {","            newAxes[categoryAxisName] = {};","        }","        if(!(this._getBaseAttribute(newAxes[categoryAxisName], \"keys\")))","        {","            this._setBaseAttribute(newAxes[categoryAxisName], \"keys\", [catKey]);","        }","        ","        if(!(this._getBaseAttribute(newAxes[categoryAxisName], \"position\")))","        {","            this._setBaseAttribute(newAxes[categoryAxisName], \"position\", categoryPosition);","        }","         ","        if(!(this._getBaseAttribute(newAxes[categoryAxisName], \"type\")))","        {","            this._setBaseAttribute(newAxes[categoryAxisName], \"type\", this.get(\"categoryType\"));","        }","        if(!newAxes.hasOwnProperty(valueAxisName) && seriesKeys && seriesKeys.length > 0)","        {","            newAxes[valueAxisName] = {keys:seriesKeys};","            valueAxes.push(newAxes[valueAxisName]);","        }","        if(claimedKeys.length > 0)","        {","            if(seriesKeys.length > 0)","            {","                seriesKeys = claimedKeys.concat(seriesKeys);","            }","            else","            {","                seriesKeys = claimedKeys;","            }","        }","        if(newAxes.hasOwnProperty(valueAxisName))","        {","            if(!(this._getBaseAttribute(newAxes[valueAxisName], \"position\")))","            {","                this._setBaseAttribute(newAxes[valueAxisName], \"position\", this._getDefaultAxisPosition(newAxes[valueAxisName], valueAxes, seriesPosition));","            }","            this._setBaseAttribute(newAxes[valueAxisName], \"type\", seriesAxis);","            this._setBaseAttribute(newAxes[valueAxisName], \"keys\", seriesKeys);","        } ","        if(!this._seriesKeysExplicitlySet)","        {","            this._seriesKeys = seriesKeys;","        }","        return newAxes;","    },","","    /**","     * Determines the position of an axis when one is not specified.","     *","     * @method _getDefaultAxisPosition","     * @param {Axis} axis `Axis` instance.","     * @param {Array} valueAxes Array of `Axis` instances.","     * @param {String} position Default position depending on the direction of the chart and type of axis.","     * @return String","     * @private","     */","    _getDefaultAxisPosition: function(axis, valueAxes, position)","    {","        var direction = this.get(\"direction\"),","            i = Y.Array.indexOf(valueAxes, axis);","        ","        if(valueAxes[i - 1] && valueAxes[i - 1].position)","        {","            if(direction == \"horizontal\")","            {","                if(valueAxes[i - 1].position == \"left\")","                {","                    position = \"right\";","                }","                else if(valueAxes[i - 1].position == \"right\")","                {","                    position = \"left\";","                }","            }","            else","            {","                if (valueAxes[i -1].position == \"bottom\")","                {","                    position = \"top\";","                }       ","                else","                {","                    position = \"bottom\";","                }","            }","        }","        return position;","    },","","   ","    /**","     * Returns an object literal containing a categoryItem and a valueItem for a given series index. Below is the structure of each:","     * ","     * @method getSeriesItems","     * @param {CartesianSeries} series Reference to a series.","     * @param {Number} index Index of the specified item within a series.","     * @return Object An object literal containing the following:","     *","     *  <dl>","     *      <dt>categoryItem</dt><dd>Object containing the following data related to the category axis of the series.","     *  <dl>","     *      <dt>axis</dt><dd>Reference to the category axis of the series.</dd>","     *      <dt>key</dt><dd>Category key for the series.</dd>","     *      <dt>value</dt><dd>Value on the axis corresponding to the series index.</dd>","     *  </dl>","     *      </dd>","     *      <dt>valueItem</dt><dd>Object containing the following data related to the category axis of the series.","     *  <dl>","     *      <dt>axis</dt><dd>Reference to the value axis of the series.</dd>","     *      <dt>key</dt><dd>Value key for the series.</dd>","     *      <dt>value</dt><dd>Value on the axis corresponding to the series index.</dd>","     *  </dl>","     *      </dd>","     *  </dl>","     */","    getSeriesItems: function(series, index)","    {","        var xAxis = series.get(\"xAxis\"),","            yAxis = series.get(\"yAxis\"),","            xKey = series.get(\"xKey\"),","            yKey = series.get(\"yKey\"),","            categoryItem,","            valueItem;","        if(this.get(\"direction\") == \"vertical\")","        {","            categoryItem = {","                axis:yAxis,","                key:yKey,","                value:yAxis.getKeyValueAt(yKey, index)","            };","            valueItem = {","                axis:xAxis,","                key:xKey,","                value: xAxis.getKeyValueAt(xKey, index)","            };","        }","        else","        {","            valueItem = {","                axis:yAxis,","                key:yKey,","                value:yAxis.getKeyValueAt(yKey, index)","            };","            categoryItem = {","                axis:xAxis,","                key:xKey,","                value: xAxis.getKeyValueAt(xKey, index)","            };","        }","        categoryItem.displayName = series.get(\"categoryDisplayName\");","        valueItem.displayName = series.get(\"valueDisplayName\");","        categoryItem.value = categoryItem.axis.getKeyValueAt(categoryItem.key, index);","        valueItem.value = valueItem.axis.getKeyValueAt(valueItem.key, index);","        return {category:categoryItem, value:valueItem};","    },","","    /**","     * Handler for sizeChanged event.","     *","     * @method _sizeChanged","     * @param {Object} e Event object.","     * @private","     */","    _sizeChanged: function(e)","    {","        if(this._axesCollection)","        {","            var ac = this._axesCollection,","                i = 0,","                l = ac.length;","            for(; i < l; ++i)","            {","                this._addToAxesRenderQueue(ac[i]);","            }","            this._redraw();","        }","    },","    ","    /**","     * Returns the maximum distance in pixels that the extends outside the top bounds of all vertical axes.","     *","     * @method _getTopOverflow","     * @param {Array} set1 Collection of axes to check.","     * @param {Array} set2 Seconf collection of axes to check.","     * @param {Number} width Width of the axes","     * @return Number","     * @private","     */","    _getTopOverflow: function(set1, set2, height)","    {","        var i = 0,","            len,","            overflow = 0,","            axis;","        if(set1)","        {","            len = set1.length;","            for(; i < len; ++i)","            {","                axis = set1[i];","                overflow = Math.max(overflow, Math.abs(axis.getMaxLabelBounds().top) - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, height) * 0.5));","            }","        }","        if(set2)","        {","            i = 0;","            len = set2.length;","            for(; i < len; ++i)","            {","                axis = set2[i];","                overflow = Math.max(overflow, Math.abs(axis.getMaxLabelBounds().top) - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, height) * 0.5));","            }","        }","        return overflow;","    },","    ","    /**","     * Returns the maximum distance in pixels that the extends outside the right bounds of all horizontal axes.","     *","     * @method _getRightOverflow","     * @param {Array} set1 Collection of axes to check.","     * @param {Array} set2 Seconf collection of axes to check.","     * @param {Number} width Width of the axes","     * @return Number","     * @private","     */","    _getRightOverflow: function(set1, set2, width)","    {","        var i = 0,","            len,","            overflow = 0,","            axis;","        if(set1)","        {","            len = set1.length;","            for(; i < len; ++i)","            {","                axis = set1[i];","                overflow = Math.max(overflow, axis.getMaxLabelBounds().right - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, width) * 0.5));","            }","        }","        if(set2)","        {","            i = 0;","            len = set2.length;","            for(; i < len; ++i)","            {","                axis = set2[i];","                overflow = Math.max(overflow, axis.getMaxLabelBounds().right - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, width) * 0.5));","            }","        }","        return overflow;","    },","    ","    /**","     * Returns the maximum distance in pixels that the extends outside the left bounds of all horizontal axes.","     *","     * @method _getLeftOverflow","     * @param {Array} set1 Collection of axes to check.","     * @param {Array} set2 Seconf collection of axes to check.","     * @param {Number} width Width of the axes","     * @return Number","     * @private","     */","    _getLeftOverflow: function(set1, set2, width)","    {","        var i = 0,","            len,","            overflow = 0,","            axis;","        if(set1)","        {","            len = set1.length;","            for(; i < len; ++i)","            {","                axis = set1[i];","                overflow = Math.max(overflow, Math.abs(axis.getMinLabelBounds().left) - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, width) * 0.5));","            }","        }","        if(set2)","        {","            i = 0;","            len = set2.length;","            for(; i < len; ++i)","            {","                axis = set2[i];","                overflow = Math.max(overflow, Math.abs(axis.getMinLabelBounds().left) - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, width) * 0.5));","            }","        }","        return overflow;","    },","    ","    /**","     * Returns the maximum distance in pixels that the extends outside the bottom bounds of all vertical axes.","     *","     * @method _getBottomOverflow","     * @param {Array} set1 Collection of axes to check.","     * @param {Array} set2 Seconf collection of axes to check.","     * @param {Number} height Height of the axes","     * @return Number","     * @private","     */","    _getBottomOverflow: function(set1, set2, height)","    {","        var i = 0,","            len,","            overflow = 0,","            axis;","        if(set1)","        {","            len = set1.length;","            for(; i < len; ++i)","            {","                axis = set1[i];","                overflow = Math.max(overflow, axis.getMinLabelBounds().bottom - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, height) * 0.5));","            }","        }","        if(set2)","        {","            i = 0;","            len = set2.length;","            for(; i < len; ++i)","            {","                axis = set2[i];","                overflow = Math.max(overflow, axis.getMinLabelBounds().bottom - (axis.getEdgeOffset(axis.get(\"styles\").majorTicks.count, height) * 0.5));","            }","        }","        return overflow;","    },","","    /**","     * Redraws and position all the components of the chart instance.","     *","     * @method _redraw","     * @private","     */","    _redraw: function()","    {","        if(this._drawing)","        {","            this._callLater = true;","            return;","        }","        this._drawing = true;","        this._callLater = false;","        var w = this.get(\"width\"),","            h = this.get(\"height\"),","            leftPaneWidth = 0,","            rightPaneWidth = 0,","            topPaneHeight = 0,","            bottomPaneHeight = 0,","            leftAxesCollection = this.get(\"leftAxesCollection\"),","            rightAxesCollection = this.get(\"rightAxesCollection\"),","            topAxesCollection = this.get(\"topAxesCollection\"),","            bottomAxesCollection = this.get(\"bottomAxesCollection\"),","            i = 0,","            l,","            axis,","            graphOverflow = \"visible\",","            graph = this.get(\"graph\"),","            topOverflow,","            bottomOverflow,","            leftOverflow,","            rightOverflow,","            graphWidth,","            graphHeight,","            graphX,","            graphY,","            allowContentOverflow = this.get(\"allowContentOverflow\"),","            diff,","            rightAxesXCoords,","            leftAxesXCoords,","            topAxesYCoords,","            bottomAxesYCoords,","            graphRect = {};","        if(leftAxesCollection)","        {","            leftAxesXCoords = [];","            l = leftAxesCollection.length;","            for(i = l - 1; i > -1; --i)","            {","                leftAxesXCoords.unshift(leftPaneWidth);","                leftPaneWidth += leftAxesCollection[i].get(\"width\");","            }","        }","        if(rightAxesCollection)","        {","            rightAxesXCoords = [];","            l = rightAxesCollection.length;","            i = 0;","            for(i = l - 1; i > -1; --i)","            {","                rightPaneWidth += rightAxesCollection[i].get(\"width\");","                rightAxesXCoords.unshift(w - rightPaneWidth);","            }","        }","        if(topAxesCollection)","        {","            topAxesYCoords = [];","            l = topAxesCollection.length;","            for(i = l - 1; i > -1; --i)","            {","                topAxesYCoords.unshift(topPaneHeight);","                topPaneHeight += topAxesCollection[i].get(\"height\");","            }","        }","        if(bottomAxesCollection)","        {","            bottomAxesYCoords = [];","            l = bottomAxesCollection.length;","            for(i = l - 1; i > -1; --i)","            {","                bottomPaneHeight += bottomAxesCollection[i].get(\"height\");","                bottomAxesYCoords.unshift(h - bottomPaneHeight);","            }","        }","        ","        graphWidth = w - (leftPaneWidth + rightPaneWidth);","        graphHeight = h - (bottomPaneHeight + topPaneHeight);","        graphRect.left = leftPaneWidth;","        graphRect.top = topPaneHeight;","        graphRect.bottom = h - bottomPaneHeight;","        graphRect.right = w - rightPaneWidth;","        if(!allowContentOverflow)","        {","            topOverflow = this._getTopOverflow(leftAxesCollection, rightAxesCollection);","            bottomOverflow = this._getBottomOverflow(leftAxesCollection, rightAxesCollection);","            leftOverflow = this._getLeftOverflow(bottomAxesCollection, topAxesCollection);","            rightOverflow = this._getRightOverflow(bottomAxesCollection, topAxesCollection);","            ","            diff = topOverflow - topPaneHeight;","            if(diff > 0)","            {","                graphRect.top = topOverflow;","                if(topAxesYCoords)","                {","                    i = 0;","                    l = topAxesYCoords.length;","                    for(; i < l; ++i)","                    {","                        topAxesYCoords[i] += diff;","                    }","                }","            }","","            diff = bottomOverflow - bottomPaneHeight;","            if(diff > 0)","            {","                graphRect.bottom = h - bottomOverflow;","                if(bottomAxesYCoords)","                {","                    i = 0;","                    l = bottomAxesYCoords.length;","                    for(; i < l; ++i)","                    {","                        bottomAxesYCoords[i] -= diff;","                    }","                }","            }","","            diff = leftOverflow - leftPaneWidth;","            if(diff > 0)","            {","                graphRect.left = leftOverflow;","                if(leftAxesXCoords)","                {","                    i = 0;","                    l = leftAxesXCoords.length;","                    for(; i < l; ++i)","                    {","                        leftAxesXCoords[i] += diff;","                    }","                }","            }","","            diff = rightOverflow - rightPaneWidth;","            if(diff > 0)","            {","                graphRect.right = w - rightOverflow;","                if(rightAxesXCoords)","                {","                    i = 0;","                    l = rightAxesXCoords.length;","                    for(; i < l; ++i)","                    {","                        rightAxesXCoords[i] -= diff;","                    }","                }","            }","        }","        graphWidth = graphRect.right - graphRect.left;","        graphHeight = graphRect.bottom - graphRect.top;","        graphX = graphRect.left;","        graphY = graphRect.top;","        if(topAxesCollection)","        {","            l = topAxesCollection.length;","            i = 0;","            for(; i < l; i++)","            {","                axis = topAxesCollection[i];","                if(axis.get(\"width\") !== graphWidth)","                {","                    axis.set(\"width\", graphWidth);","                }","                axis.get(\"boundingBox\").setStyle(\"left\", graphX + \"px\");","                axis.get(\"boundingBox\").setStyle(\"top\", topAxesYCoords[i] + \"px\");","            }","            if(axis._hasDataOverflow())","            {","                graphOverflow = \"hidden\";","            }","        }","        if(bottomAxesCollection)","        {","            l = bottomAxesCollection.length;","            i = 0;","            for(; i < l; i++)","            {","                axis = bottomAxesCollection[i];","                if(axis.get(\"width\") !== graphWidth)","                {","                    axis.set(\"width\", graphWidth);","                }","                axis.get(\"boundingBox\").setStyle(\"left\", graphX + \"px\");","                axis.get(\"boundingBox\").setStyle(\"top\", bottomAxesYCoords[i] + \"px\");","            }","            if(axis._hasDataOverflow())","            {","                graphOverflow = \"hidden\";","            }","        }","        if(leftAxesCollection)","        {","            l = leftAxesCollection.length;","            i = 0;","            for(; i < l; ++i)","            {","                axis = leftAxesCollection[i];","                axis.get(\"boundingBox\").setStyle(\"top\", graphY + \"px\");","                axis.get(\"boundingBox\").setStyle(\"left\", leftAxesXCoords[i] + \"px\");","                if(axis.get(\"height\") !== graphHeight)","                {","                    axis.set(\"height\", graphHeight);","                }","            }","            if(axis._hasDataOverflow())","            {","                graphOverflow = \"hidden\";","            }","        }","        if(rightAxesCollection)","        {","            l = rightAxesCollection.length;","            i = 0;","            for(; i < l; ++i)","            {","                axis = rightAxesCollection[i];","                axis.get(\"boundingBox\").setStyle(\"top\", graphY + \"px\");","                axis.get(\"boundingBox\").setStyle(\"left\", rightAxesXCoords[i] + \"px\");","                if(axis.get(\"height\") !== graphHeight)","                {","                    axis.set(\"height\", graphHeight);","                }","            }","            if(axis._hasDataOverflow())","            {","                graphOverflow = \"hidden\";","            }","        }","        this._drawing = false;","        if(this._callLater)","        {","            this._redraw();","            return;","        }","        if(graph)","        {","            graph.get(\"boundingBox\").setStyle(\"left\", graphX + \"px\");","            graph.get(\"boundingBox\").setStyle(\"top\", graphY + \"px\");","            graph.set(\"width\", graphWidth);","            graph.set(\"height\", graphHeight);","            graph.get(\"boundingBox\").setStyle(\"overflow\", graphOverflow);","        }","","        if(this._overlay)","        {","            this._overlay.setStyle(\"left\", graphX + \"px\");","            this._overlay.setStyle(\"top\", graphY + \"px\");","            this._overlay.setStyle(\"width\", graphWidth + \"px\");","            this._overlay.setStyle(\"height\", graphHeight + \"px\");","        }","    },","","    /**","     * Destructor implementation for the CartesianChart class. Calls destroy on all axes, series and the Graph instance.","     * Removes the tooltip and overlay HTML elements.","     *","     * @method destructor","     * @protected","     */","    destructor: function()","    {","        var graph = this.get(\"graph\"),","            i = 0,","            len,","            seriesCollection = this.get(\"seriesCollection\"),","            axesCollection = this._axesCollection,","            tooltip = this.get(\"tooltip\").node;","        if(this._description)","        {","            this._description.empty();","            this._description.remove(true);","        }","        if(this._liveRegion)","        {","            this._liveRegion.empty();","            this._liveRegion.remove(true);","        }","        len = seriesCollection ? seriesCollection.length : 0;","        for(; i < len; ++i)","        {","            if(seriesCollection[i] instanceof Y.CartesianSeries)","            {","                seriesCollection[i].destroy(true);","            }","        }","        len = axesCollection ? axesCollection.length : 0;","        for(i = 0; i < len; ++i)","        {","            if(axesCollection[i] instanceof Y.Axis)","            {","                axesCollection[i].destroy(true);","            }","        }","        if(graph)","        {","            graph.destroy(true);","        }","        if(tooltip)","        {","            tooltip.empty();","            tooltip.remove(true);","        }","        if(this._overlay)","        {","            this._overlay.empty();","            this._overlay.remove(true);","        }","    },","","    /**","     * Returns the appropriate message based on the key press.","     *","     * @method _getAriaMessage","     * @param {Number} key The keycode that was pressed.","     * @return String","     */","    _getAriaMessage: function(key)","    {","        var msg = \"\",","            series,","            items,","            categoryItem,","            valueItem,","            seriesIndex = this._seriesIndex,","            itemIndex = this._itemIndex,","            seriesCollection = this.get(\"seriesCollection\"),","            len = seriesCollection.length,","            dataLength;","        if(key % 2 === 0)","        {","            if(len > 1)","            {","                if(key === 38)","                {","                    seriesIndex = seriesIndex < 1 ? len - 1 : seriesIndex - 1;","                }","                else if(key === 40)","                {","                    seriesIndex = seriesIndex >= len - 1 ? 0 : seriesIndex + 1;","                }","                this._itemIndex = -1;","            }","            else","            {","                seriesIndex = 0;","            }","            this._seriesIndex = seriesIndex;","            series = this.getSeries(parseInt(seriesIndex, 10));","            msg = series.get(\"valueDisplayName\") + \" series.\";","        }","        else","        {","            if(seriesIndex > -1)","            {","                msg = \"\";","                series = this.getSeries(parseInt(seriesIndex, 10));","            }","            else","            {","                seriesIndex = 0;","                this._seriesIndex = seriesIndex;","                series = this.getSeries(parseInt(seriesIndex, 10));","                msg = series.get(\"valueDisplayName\") + \" series.\";","            }","            dataLength = series._dataLength ? series._dataLength : 0;","            if(key === 37)","            {","                itemIndex = itemIndex > 0 ? itemIndex - 1 : dataLength - 1;","            }","            else if(key === 39)","            {","                itemIndex = itemIndex >= dataLength - 1 ? 0 : itemIndex + 1;","            }","            this._itemIndex = itemIndex;","            items = this.getSeriesItems(series, itemIndex);","            categoryItem = items.category;","            valueItem = items.value;","            if(categoryItem && valueItem && categoryItem.value && valueItem.value)","            {","                msg += categoryItem.displayName + \": \" + categoryItem.axis.formatLabel.apply(this, [categoryItem.value, categoryItem.axis.get(\"labelFormat\")]) + \", \";","                msg += valueItem.displayName + \": \" + valueItem.axis.formatLabel.apply(this, [valueItem.value, valueItem.axis.get(\"labelFormat\")]) + \", \"; ","            }","           else","            {","                msg += \"No data available.\";","            }","            msg += (itemIndex + 1) + \" of \" + dataLength + \". \";","        }","        return msg;","    }","}, {","    ATTRS: {","        /**","         * Indicates whether axis labels are allowed to overflow beyond the bounds of the chart's content box.","         *","         * @attribute allowContentOverflow","         * @type Boolean","         */","        allowContentOverflow: {","            value: false","        },","","        /**","         * Style object for the axes.","         *","         * @attribute axesStyles","         * @type Object","         * @private","         */","        axesStyles: {","            getter: function()","            {","                var axes = this.get(\"axes\"),","                    i,","                    styles = this._axesStyles;","                if(axes)","                {","                    for(i in axes)","                    {","                        if(axes.hasOwnProperty(i) && axes[i] instanceof Y.Axis)","                        {","                            if(!styles)","                            {","                                styles = {};","                            }","                            styles[i] = axes[i].get(\"styles\");","                        }","                    }","                }","                return styles;","            },","            ","            setter: function(val)","            {","                var axes = this.get(\"axes\"),","                    i;","                for(i in val)","                {","                    if(val.hasOwnProperty(i) && axes.hasOwnProperty(i))","                    {","                        this._setBaseAttribute(axes[i], \"styles\", val[i]);","                    }","                }","            }","        },","","        /**","         * Style object for the series","         *","         * @attribute seriesStyles","         * @type Object","         * @private","         */","        seriesStyles: {","            getter: function()","            {","                var styles = this._seriesStyles,","                    graph = this.get(\"graph\"),","                    dict,","                    i;","                if(graph)","                {","                    dict = graph.get(\"seriesDictionary\");","                    if(dict)","                    {","                        styles = {};","                        for(i in dict)","                        {","                            if(dict.hasOwnProperty(i))","                            {","                                styles[i] = dict[i].get(\"styles\");","                            }","                        }","                    }","                }","                return styles;","            },","            ","            setter: function(val)","            {","                var i,","                    l,","                    s;","    ","                if(Y_Lang.isArray(val))","                {","                    s = this.get(\"seriesCollection\");","                    i = 0;","                    l = val.length;","","                    for(; i < l; ++i)","                    {","                        this._setBaseAttribute(s[i], \"styles\", val[i]);","                    }","                }","                else","                {","                    for(i in val)","                    {","                        if(val.hasOwnProperty(i))","                        {","                            s = this.getSeries(i);","                            this._setBaseAttribute(s, \"styles\", val[i]);","                        }","                    }","                }","            }","        },","","        /**","         * Styles for the graph.","         *","         * @attribute graphStyles","         * @type Object","         * @private","         */","        graphStyles: {","            getter: function()","            {","                var graph = this.get(\"graph\");","                if(graph)","                {","                    return(graph.get(\"styles\"));","                }","                return this._graphStyles;","            },","","            setter: function(val)","            {","                var graph = this.get(\"graph\");","                this._setBaseAttribute(graph, \"styles\", val);","            }","","        },","","        /**","         * Style properties for the chart. Contains a key indexed hash of the following:","         *  <dl>","         *      <dt>series</dt><dd>A key indexed hash containing references to the `styles` attribute for each series in the chart.","         *      Specific style attributes vary depending on the series:","         *      <ul>","         *          <li><a href=\"AreaSeries.html#attr_styles\">AreaSeries</a></li>","         *          <li><a href=\"BarSeries.html#attr_styles\">BarSeries</a></li>","         *          <li><a href=\"ColumnSeries.html#attr_styles\">ColumnSeries</a></li>","         *          <li><a href=\"ComboSeries.html#attr_styles\">ComboSeries</a></li>","         *          <li><a href=\"LineSeries.html#attr_styles\">LineSeries</a></li>","         *          <li><a href=\"MarkerSeries.html#attr_styles\">MarkerSeries</a></li>","         *          <li><a href=\"SplineSeries.html#attr_styles\">SplineSeries</a></li>","         *      </ul>","         *      </dd>","         *      <dt>axes</dt><dd>A key indexed hash containing references to the `styles` attribute for each axes in the chart. Specific","         *      style attributes can be found in the <a href=\"Axis.html#attr_styles\">Axis</a> class.</dd>","         *      <dt>graph</dt><dd>A reference to the `styles` attribute in the chart. Specific style attributes can be found in the","         *      <a href=\"Graph.html#attr_styles\">Graph</a> class.</dd>","         *  </dl>","         *","         * @attribute styles","         * @type Object","         */","        styles: {","            getter: function()","            {","                var styles = { ","                    axes: this.get(\"axesStyles\"),","                    series: this.get(\"seriesStyles\"),","                    graph: this.get(\"graphStyles\")","                };","                return styles;","            },","            setter: function(val)","            {","                if(val.hasOwnProperty(\"axes\"))","                {","                    if(this.get(\"axesStyles\"))","                    {","                        this.set(\"axesStyles\", val.axes);","                    }","                    else","                    {","                        this._axesStyles = val.axes;","                    }","                }","                if(val.hasOwnProperty(\"series\"))","                {","                    if(this.get(\"seriesStyles\"))","                    {","                        this.set(\"seriesStyles\", val.series);","                    }","                    else","                    {","                        this._seriesStyles = val.series;","                    }","                }","                if(val.hasOwnProperty(\"graph\"))","                {","                    this.set(\"graphStyles\", val.graph);","                }","            }","        },","","        /**","         * Axes to appear in the chart. This can be a key indexed hash of axis instances or object literals","         * used to construct the appropriate axes.","         *","         * @attribute axes","         * @type Object","         */","        axes: {","            valueFn: \"_getDefaultAxes\",","","            setter: function(val)","            {","                if(this.get(\"dataProvider\"))","                {","                    val = this._setAxes(val);","                }","                return val;","            }","        },","","        /**","         * Collection of series to appear on the chart. This can be an array of Series instances or object literals","         * used to construct the appropriate series.","         *","         * @attribute seriesCollection","         * @type Array","         */","        seriesCollection: {","            valueFn: \"_getDefaultSeriesCollection\",","            ","            setter: function(val)","            {","                if(this.get(\"dataProvider\"))","                {","                    val = this._parseSeriesCollection(val);","                }","                return val;","            }","        },","","        /**","         * Reference to the left-aligned axes for the chart.","         *","         * @attribute leftAxesCollection","         * @type Array","         * @private","         */","        leftAxesCollection: {},","","        /**","         * Reference to the bottom-aligned axes for the chart.","         *","         * @attribute bottomAxesCollection","         * @type Array","         * @private","         */","        bottomAxesCollection: {},","","        /**","         * Reference to the right-aligned axes for the chart.","         *","         * @attribute rightAxesCollection","         * @type Array","         * @private","         */","        rightAxesCollection: {},","","        /**","         * Reference to the top-aligned axes for the chart.","         *","         * @attribute topAxesCollection","         * @type Array","         * @private","         */","        topAxesCollection: {},","        ","        /**","         * Indicates whether or not the chart is stacked.","         *","         * @attribute stacked","         * @type Boolean","         */","        stacked: {","            value: false","        },","","        /**","         * Direction of chart's category axis when there is no series collection specified. Charts can","         * be horizontal or vertical. When the chart type is column, the chart is horizontal.","         * When the chart type is bar, the chart is vertical. ","         *","         * @attribute direction","         * @type String","         */","        direction: {","            getter: function()","            {","                var type = this.get(\"type\");","                if(type == \"bar\")","                {   ","                    return \"vertical\";","                }","                else if(type == \"column\")","                {","                    return \"horizontal\";","                }","                return this._direction;","            },","","            setter: function(val)","            {","                this._direction = val;","                return this._direction;","            }","        },","","        /**","         * Indicates whether or not an area is filled in a combo chart.","         * ","         * @attribute showAreaFill","         * @type Boolean","         */","        showAreaFill: {},","","        /**","         * Indicates whether to display markers in a combo chart.","         *","         * @attribute showMarkers","         * @type Boolean","         */","        showMarkers:{},","","        /**","         * Indicates whether to display lines in a combo chart.","         *","         * @attribute showLines","         * @type Boolean","         */","        showLines:{},","","        /**","         * Indicates the key value used to identify a category axis in the `axes` hash. If","         * not specified, the categoryKey attribute value will be used.","         * ","         * @attribute categoryAxisName","         * @type String","         */","        categoryAxisName: {","        },","","        /**","         * Indicates the key value used to identify a the series axis when an axis not generated.","         *","         * @attribute valueAxisName","         * @type String","         */","        valueAxisName: {","            value: \"values\"","        },","","        /**","         * Reference to the horizontalGridlines for the chart.","         *","         * @attribute horizontalGridlines","         * @type Gridlines","         */","        horizontalGridlines: {","            getter: function()","            {","                var graph = this.get(\"graph\");","                if(graph)","                {","                    return graph.get(\"horizontalGridlines\");","                }","                return this._horizontalGridlines;","            },","            setter: function(val)","            {","                var graph = this.get(\"graph\");","                if(val && !Y_Lang.isObject(val))","                {","                    val = {};","                }","                if(graph)","                {","                    graph.set(\"horizontalGridlines\", val);","                }","                else","                {","                    this._horizontalGridlines = val;","                }","            }","        },","","        /**","         * Reference to the verticalGridlines for the chart.","         *","         * @attribute verticalGridlines","         * @type Gridlines","         */","        verticalGridlines: {","            getter: function()","            {","                var graph = this.get(\"graph\");","                if(graph)","                {","                    return graph.get(\"verticalGridlines\");","                }","                return this._verticalGridlines;","            },","            setter: function(val)","            {","                var graph = this.get(\"graph\");","                if(val && !Y_Lang.isObject(val))","                {","                    val = {};","                }","                if(graph)","                {","                    graph.set(\"verticalGridlines\", val);","                }","                else","                {","                    this._verticalGridlines = val;","                }","            }","        },","        ","        /**","         * Type of chart when there is no series collection specified.","         *","         * @attribute type","         * @type String ","         */","        type: {","            getter: function()","            {","                if(this.get(\"stacked\"))","                {","                    return \"stacked\" + this._type;","                }","                return this._type;","            },","","            setter: function(val)","            {","                if(this._type == \"bar\")","                {","                    if(val != \"bar\")","                    {","                        this.set(\"direction\", \"horizontal\");","                    }","                }","                else","                {","                    if(val == \"bar\")","                    {","                        this.set(\"direction\", \"vertical\");","                    }","                }","                this._type = val;","                return this._type;","            }","        },","        ","        /**","         * Reference to the category axis used by the chart.","         *","         * @attribute categoryAxis","         * @type Axis","         */","        categoryAxis:{}","    }","});","/**"," * The PieChart class creates a pie chart"," *"," * @module charts"," * @submodule charts-base"," * @class PieChart"," * @extends ChartBase"," * @constructor"," */","Y.PieChart = Y.Base.create(\"pieChart\", Y.Widget, [Y.ChartBase], {","    /**","     * Calculates and returns a `seriesCollection`.","     *","     * @method _getSeriesCollection","     * @return Array","     * @private","     */","    _getSeriesCollection: function()","    {","        if(this._seriesCollection)","        {","            return this._seriesCollection;","        }","        var axes = this.get(\"axes\"),","            sc = [], ","            seriesKeys,","            i = 0,","            l,","            type = this.get(\"type\"),","            key,","            catAxis = \"categoryAxis\",","            catKey = \"categoryKey\",","            valAxis = \"valueAxis\",","            seriesKey = \"valueKey\";","        if(axes)","        {","            seriesKeys = axes.values.get(\"keyCollection\");","            key = axes.category.get(\"keyCollection\")[0];","            l = seriesKeys.length;","            for(; i < l; ++i)","            {","                sc[i] = {type:type};","                sc[i][catAxis] = \"category\";","                sc[i][valAxis] = \"values\";","                sc[i][catKey] = key;","                sc[i][seriesKey] = seriesKeys[i];","            }","        }","        this._seriesCollection = sc;","        return sc;","    },","","    /**","     * Creates `Axis` instances.","     *","     * @method _parseAxes","     * @param {Object} val Object containing `Axis` instances or objects in which to construct `Axis` instances.","     * @return Object","     * @private","     */","    _parseAxes: function(hash)","    {","        if(!this._axes)","        {","            this._axes = {};","        }","        var i, pos, axis, dh, config, axisClass,","            type = this.get(\"type\"),","            w = this.get(\"width\"),","            h = this.get(\"height\"),","            node = Y.Node.one(this._parentNode);","        if(!w)","        {","            this.set(\"width\", node.get(\"offsetWidth\"));","            w = this.get(\"width\");","        }","        if(!h)","        {","            this.set(\"height\", node.get(\"offsetHeight\"));","            h = this.get(\"height\");","        }","        for(i in hash)","        {","            if(hash.hasOwnProperty(i))","            {","                dh = hash[i];","                pos = type == \"pie\" ? \"none\" : dh.position;","                axisClass = this._getAxisClass(dh.type);","                config = {dataProvider:this.get(\"dataProvider\")};","                if(dh.hasOwnProperty(\"roundingUnit\"))","                {","                    config.roundingUnit = dh.roundingUnit;","                }","                config.keys = dh.keys;","                config.width = w;","                config.height = h;","                config.position = pos;","                config.styles = dh.styles;","                axis = new axisClass(config);","                axis.on(\"axisRendered\", Y.bind(this._itemRendered, this));","                this._axes[i] = axis;","            }","        }","    },","","    /**","     * Adds axes to the chart.","     *","     * @method _addAxes","     * @private","     */","    _addAxes: function()","    {","        var axes = this.get(\"axes\"),","            i, ","            axis, ","            p;","        if(!axes)","        {","            this.set(\"axes\", this._getDefaultAxes());","            axes = this.get(\"axes\");","        }","        if(!this._axesCollection)","        {   ","            this._axesCollection = [];","        }","        for(i in axes)","        {","            if(axes.hasOwnProperty(i))","            {","                axis = axes[i];","                p = axis.get(\"position\");","                if(!this.get(p + \"AxesCollection\"))","                {","                    this.set(p + \"AxesCollection\", [axis]);","                }","                else","                {","                    this.get(p + \"AxesCollection\").push(axis);","                }","                this._axesCollection.push(axis);","            }","        }","    },","","    /**","     * Renders the Graph.","     *","     * @method _addSeries","     * @private","     */","    _addSeries: function()","    {","        var graph = this.get(\"graph\"),","            seriesCollection = this.get(\"seriesCollection\");","        this._parseSeriesAxes(seriesCollection);","        graph.set(\"showBackground\", false);","        graph.set(\"width\", this.get(\"width\"));","        graph.set(\"height\", this.get(\"height\"));","        graph.set(\"seriesCollection\", seriesCollection);","        this._seriesCollection = graph.get(\"seriesCollection\");","        graph.render(this.get(\"contentBox\"));","    },","","    /**","     * Parse and sets the axes for the chart.","     *","     * @method _parseSeriesAxes","     * @param {Array} c A collection `PieSeries` instance.","     * @private","     */","    _parseSeriesAxes: function(c)","    {","        var i = 0, ","            len = c.length, ","            s,","            axes = this.get(\"axes\"),","            axis;","        for(; i < len; ++i)","        {","            s = c[i];","            if(s)","            {","                //If series is an actual series instance, ","                //replace axes attribute string ids with axes","                if(s instanceof Y.PieSeries)","                {","                    axis = s.get(\"categoryAxis\");","                    if(axis && !(axis instanceof Y.Axis))","                    {","                        s.set(\"categoryAxis\", axes[axis]);","                    }","                    axis = s.get(\"valueAxis\");","                    if(axis && !(axis instanceof Y.Axis))","                    {","                        s.set(\"valueAxis\", axes[axis]);","                    }","                    continue;","                }","                s.categoryAxis = axes.category;","                s.valueAxis = axes.values;","                if(!s.type)","                {","                    s.type = this.get(\"type\");","                }","            }","        }","    },","","    /**","     * Generates and returns a key-indexed object containing `Axis` instances or objects used to create `Axis` instances.","     *","     * @method _getDefaultAxes","     * @return Object","     * @private","     */","    _getDefaultAxes: function()","    {","        var catKey = this.get(\"categoryKey\"),","            seriesKeys = this.get(\"seriesKeys\").concat(), ","            seriesAxis = \"numeric\";","        return {","            values:{","                keys:seriesKeys,","                type:seriesAxis","            },","            category:{","                keys:[catKey],","                type:this.get(\"categoryType\")","            }","        };","    },","        ","    /**","     * Returns an object literal containing a categoryItem and a valueItem for a given series index.","     *","     * @method getSeriesItem","     * @param series Reference to a series.","     * @param index Index of the specified item within a series.","     * @return Object","     */","    getSeriesItems: function(series, index)","    {","        var categoryItem = {","                axis: series.get(\"categoryAxis\"),","                key: series.get(\"categoryKey\"),","                displayName: series.get(\"categoryDisplayName\")","            },","            valueItem = {","                axis: series.get(\"valueAxis\"),","                key: series.get(\"valueKey\"),","                displayName: series.get(\"valueDisplayName\")","            };","        categoryItem.value = categoryItem.axis.getKeyValueAt(categoryItem.key, index);","        valueItem.value = valueItem.axis.getKeyValueAt(valueItem.key, index);","        return {category:categoryItem, value:valueItem};","    },","","    /**","     * Handler for sizeChanged event.","     *","     * @method _sizeChanged","     * @param {Object} e Event object.","     * @private","     */","    _sizeChanged: function(e)","    {","        this._redraw();","    },","","    /**","     * Redraws the chart instance.","     *","     * @method _redraw","     * @private","     */","    _redraw: function()","    {","        var graph = this.get(\"graph\"),","            w = this.get(\"width\"),","            h = this.get(\"height\"),","            dimension;","        if(graph)","        {","            dimension = Math.min(w, h);","            graph.set(\"width\", dimension);","            graph.set(\"height\", dimension);","        }","    },","    ","    /**","     * Formats tooltip text for a pie chart.","     *","     * @method _tooltipLabelFunction","     * @param {Object} categoryItem An object containing the following:","     *  <dl>","     *      <dt>axis</dt><dd>The axis to which the category is bound.</dd>","     *      <dt>displayName</dt><dd>The display name set to the category (defaults to key if not provided)</dd>","     *      <dt>key</dt><dd>The key of the category.</dd>","     *      <dt>value</dt><dd>The value of the category</dd>","     *  </dl>","     * @param {Object} valueItem An object containing the following:","     *  <dl>","     *      <dt>axis</dt><dd>The axis to which the item's series is bound.</dd>","     *      <dt>displayName</dt><dd>The display name of the series. (defaults to key if not provided)</dd>","     *      <dt>key</dt><dd>The key for the series.</dd>","     *      <dt>value</dt><dd>The value for the series item.</dd> ","     *  </dl>","     * @param {Number} itemIndex The index of the item within the series.","     * @param {CartesianSeries} series The `PieSeries` instance of the item.","     * @param {Number} seriesIndex The index of the series in the `seriesCollection`.","     * @return {HTML}","     * @private","     */","    _tooltipLabelFunction: function(categoryItem, valueItem, itemIndex, series, seriesIndex)","    {","        var msg = DOCUMENT.createElement(\"div\"),","            total = series.getTotalValues(),","            pct = Math.round((valueItem.value / total) * 10000)/100;","        msg.appendChild(DOCUMENT.createTextNode(categoryItem.displayName +","        \": \" + categoryItem.axis.get(\"labelFunction\").apply(this, [categoryItem.value, categoryItem.axis.get(\"labelFormat\")]))); ","        msg.appendChild(DOCUMENT.createElement(\"br\"));","        msg.appendChild(DOCUMENT.createTextNode(valueItem.displayName + ","        \": \" + valueItem.axis.get(\"labelFunction\").apply(this, [valueItem.value, valueItem.axis.get(\"labelFormat\")])));","        msg.appendChild(DOCUMENT.createElement(\"br\"));","        msg.appendChild(DOCUMENT.createTextNode(pct + \"%\")); ","        return msg; ","    },","","    /**","     * Returns the appropriate message based on the key press.","     *","     * @method _getAriaMessage","     * @param {Number} key The keycode that was pressed.","     * @return String","     */","    _getAriaMessage: function(key)","    {","        var msg = \"\",","            categoryItem,","            items,","            series,","            valueItem,","            seriesIndex = 0,","            itemIndex = this._itemIndex,","            seriesCollection = this.get(\"seriesCollection\"),","            len,","            total,","            pct,","            markers;","        series = this.getSeries(parseInt(seriesIndex, 10));","        markers = series.get(\"markers\");","        len = markers && markers.length ? markers.length : 0;","        if(key === 37)","        {","            itemIndex = itemIndex > 0 ? itemIndex - 1 : len - 1;","        }","        else if(key === 39)","        {","            itemIndex = itemIndex >= len - 1 ? 0 : itemIndex + 1;","        }","        this._itemIndex = itemIndex;","        items = this.getSeriesItems(series, itemIndex);","        categoryItem = items.category;","        valueItem = items.value;","        total = series.getTotalValues();","        pct = Math.round((valueItem.value / total) * 10000)/100;","        if(categoryItem && valueItem)","        {","            msg += categoryItem.displayName + \": \" + categoryItem.axis.formatLabel.apply(this, [categoryItem.value, categoryItem.axis.get(\"labelFormat\")]) + \", \";","            msg += valueItem.displayName + \": \" + valueItem.axis.formatLabel.apply(this, [valueItem.value, valueItem.axis.get(\"labelFormat\")]) + \", \"; ","            msg += \"Percent of total \" + valueItem.displayName + \": \" + pct + \"%,\"; ","        }","        else","        {","            msg += \"No data available,\";","        }","        msg += (itemIndex + 1) + \" of \" + len + \". \";","        return msg;","    }","}, {","    ATTRS: {","        /**","         * Sets the aria description for the chart.","         *","         * @attribute ariaDescription","         * @type String","         */","        ariaDescription: {","            value: \"Use the left and right keys to navigate through items.\",","","            setter: function(val)","            {","                if(this._description)","                {","                    this._description.setContent(\"\");","                    this._description.appendChild(DOCUMENT.createTextNode(val));","                }","                return val;","            }","        },","        ","        /**","         * Axes to appear in the chart. ","         *","         * @attribute axes","         * @type Object","         */","        axes: {","            getter: function()","            {","                return this._axes;","            },","","            setter: function(val)","            {","                this._parseAxes(val);","            }","        },","","        /**","         * Collection of series to appear on the chart. This can be an array of Series instances or object literals","         * used to describe a Series instance.","         *","         * @attribute seriesCollection","         * @type Array","         */","        seriesCollection: {","            getter: function()","            {","                return this._getSeriesCollection();","            },","            ","            setter: function(val)","            {","                return this._setSeriesCollection(val);","            }","        },","        ","        /**","         * Type of chart when there is no series collection specified.","         *","         * @attribute type","         * @type String ","         */","        type: {","            value: \"pie\"","        }","    }","});","","","}, '3.7.3', {\"requires\": [\"dom\", \"datatype-number\", \"datatype-date\", \"event-custom\", \"event-mouseenter\", \"event-touch\", \"widget\", \"widget-position\", \"widget-stack\", \"graphics\"]});"];
_yuitest_coverage["build/charts-base/charts-base.js"].lines = {"1":0,"17":0,"41":0,"43":0,"46":0,"48":0,"57":0,"77":0,"79":0,"81":0,"82":0,"84":0,"85":0,"86":0,"87":0,"88":0,"90":0,"98":0,"99":0,"107":0,"121":0,"124":0,"126":0,"128":0,"132":0,"136":0,"141":0,"143":0,"147":0,"148":0,"149":0,"150":0,"151":0,"162":0,"163":0,"169":0,"173":0,"179":0,"183":0,"187":0,"196":0,"198":0,"201":0,"203":0,"212":0,"216":0,"220":0,"225":0,"227":0,"231":0,"232":0,"233":0,"234":0,"235":0,"246":0,"247":0,"256":0,"258":0,"261":0,"263":0,"272":0,"276":0,"277":0,"286":0,"288":0,"291":0,"293":0,"302":0,"306":0,"307":0,"316":0,"318":0,"321":0,"323":0,"332":0,"336":0,"337":0,"347":0,"349":0,"360":0,"361":0,"366":0,"378":0,"380":0,"400":0,"401":0,"416":0,"418":0,"420":0,"421":0,"423":0,"425":0,"429":0,"432":0,"444":0,"453":0,"454":0,"464":0,"466":0,"476":0,"492":0,"497":0,"498":0,"500":0,"503":0,"504":0,"505":0,"507":0,"508":0,"509":0,"511":0,"512":0,"513":0,"515":0,"516":0,"517":0,"532":0,"538":0,"550":0,"556":0,"558":0,"560":0,"562":0,"564":0,"577":0,"589":0,"596":0,"598":0,"600":0,"602":0,"606":0,"608":0,"620":0,"622":0,"627":0,"628":0,"630":0,"642":0,"651":0,"652":0,"653":0,"655":0,"657":0,"658":0,"659":0,"660":0,"674":0,"685":0,"687":0,"688":0,"690":0,"692":0,"694":0,"696":0,"697":0,"701":0,"702":0,"704":0,"705":0,"706":0,"707":0,"708":0,"720":0,"726":0,"728":0,"729":0,"731":0,"733":0,"734":0,"736":0,"738":0,"739":0,"743":0,"744":0,"746":0,"747":0,"761":0,"762":0,"764":0,"766":0,"768":0,"770":0,"772":0,"776":0,"778":0,"800":0,"808":0,"810":0,"812":0,"813":0,"817":0,"826":0,"828":0,"838":0,"854":0,"859":0,"860":0,"862":0,"865":0,"866":0,"867":0,"869":0,"870":0,"871":0,"873":0,"874":0,"875":0,"877":0,"878":0,"879":0,"894":0,"900":0,"912":0,"919":0,"921":0,"923":0,"925":0,"927":0,"940":0,"952":0,"959":0,"961":0,"963":0,"965":0,"969":0,"971":0,"983":0,"985":0,"990":0,"991":0,"993":0,"1005":0,"1014":0,"1015":0,"1016":0,"1018":0,"1020":0,"1021":0,"1022":0,"1023":0,"1037":0,"1048":0,"1050":0,"1052":0,"1054":0,"1056":0,"1058":0,"1059":0,"1061":0,"1063":0,"1067":0,"1068":0,"1070":0,"1071":0,"1072":0,"1073":0,"1074":0,"1075":0,"1076":0,"1088":0,"1094":0,"1096":0,"1098":0,"1100":0,"1101":0,"1103":0,"1105":0,"1109":0,"1110":0,"1112":0,"1113":0,"1127":0,"1128":0,"1130":0,"1132":0,"1134":0,"1136":0,"1138":0,"1142":0,"1144":0,"1156":0,"1159":0,"1170":0,"1175":0,"1177":0,"1179":0,"1180":0,"1184":0,"1193":0,"1195":0,"1205":0,"1221":0,"1226":0,"1227":0,"1229":0,"1232":0,"1233":0,"1234":0,"1236":0,"1237":0,"1238":0,"1240":0,"1241":0,"1242":0,"1244":0,"1245":0,"1246":0,"1258":0,"1264":0,"1266":0,"1268":0,"1270":0,"1272":0,"1286":0,"1292":0,"1305":0,"1317":0,"1324":0,"1326":0,"1328":0,"1330":0,"1334":0,"1336":0,"1348":0,"1350":0,"1355":0,"1356":0,"1358":0,"1370":0,"1379":0,"1380":0,"1381":0,"1383":0,"1385":0,"1386":0,"1387":0,"1388":0,"1402":0,"1413":0,"1415":0,"1417":0,"1419":0,"1421":0,"1423":0,"1424":0,"1428":0,"1430":0,"1431":0,"1432":0,"1433":0,"1434":0,"1435":0,"1436":0,"1448":0,"1455":0,"1457":0,"1458":0,"1460":0,"1462":0,"1463":0,"1467":0,"1468":0,"1470":0,"1471":0,"1485":0,"1486":0,"1488":0,"1490":0,"1492":0,"1496":0,"1498":0,"1510":0,"1511":0,"1522":0,"1527":0,"1529":0,"1531":0,"1534":0,"1543":0,"1545":0,"1555":0,"1571":0,"1576":0,"1577":0,"1578":0,"1581":0,"1582":0,"1583":0,"1585":0,"1586":0,"1587":0,"1589":0,"1590":0,"1591":0,"1593":0,"1594":0,"1595":0,"1607":0,"1614":0,"1616":0,"1618":0,"1620":0,"1622":0,"1636":0,"1642":0,"1655":0,"1667":0,"1674":0,"1676":0,"1678":0,"1680":0,"1684":0,"1686":0,"1698":0,"1700":0,"1705":0,"1706":0,"1708":0,"1720":0,"1729":0,"1730":0,"1731":0,"1733":0,"1735":0,"1736":0,"1737":0,"1738":0,"1752":0,"1762":0,"1764":0,"1765":0,"1769":0,"1771":0,"1772":0,"1774":0,"1776":0,"1778":0,"1780":0,"1781":0,"1785":0,"1788":0,"1789":0,"1790":0,"1791":0,"1792":0,"1804":0,"1810":0,"1812":0,"1813":0,"1817":0,"1819":0,"1820":0,"1822":0,"1824":0,"1826":0,"1828":0,"1829":0,"1833":0,"1836":0,"1837":0,"1851":0,"1852":0,"1854":0,"1858":0,"1860":0,"1862":0,"1864":0,"1866":0,"1868":0,"1872":0,"1875":0,"1897":0,"1905":0,"1907":0,"1909":0,"1910":0,"1913":0,"1926":0,"1954":0,"1956":0,"1969":0,"1970":0,"1982":0,"1983":0,"1985":0,"1987":0,"1992":0,"1994":0,"2008":0,"2010":0,"2020":0,"2029":0,"2035":0,"2037":0,"2038":0,"2039":0,"2040":0,"2042":0,"2044":0,"2046":0,"2047":0,"2051":0,"2062":0,"2068":0,"2069":0,"2070":0,"2071":0,"2072":0,"2074":0,"2078":0,"2080":0,"2081":0,"2082":0,"2083":0,"2084":0,"2097":0,"2152":0,"2164":0,"2169":0,"2170":0,"2171":0,"2173":0,"2203":0,"2204":0,"2217":0,"2219":0,"2222":0,"2223":0,"2225":0,"2226":0,"2228":0,"2229":0,"2232":0,"2237":0,"2255":0,"2257":0,"2258":0,"2260":0,"2261":0,"2262":0,"2264":0,"2288":0,"2289":0,"2290":0,"2291":0,"2292":0,"2297":0,"2298":0,"2299":0,"2300":0,"2301":0,"2302":0,"2303":0,"2304":0,"2305":0,"2307":0,"2311":0,"2312":0,"2313":0,"2315":0,"2316":0,"2317":0,"2322":0,"2324":0,"2325":0,"2326":0,"2327":0,"2328":0,"2329":0,"2330":0,"2331":0,"2333":0,"2335":0,"2337":0,"2338":0,"2339":0,"2340":0,"2341":0,"2342":0,"2343":0,"2344":0,"2346":0,"2348":0,"2349":0,"2350":0,"2352":0,"2353":0,"2355":0,"2357":0,"2358":0,"2360":0,"2362":0,"2364":0,"2368":0,"2369":0,"2371":0,"2375":0,"2376":0,"2389":0,"2398":0,"2399":0,"2400":0,"2402":0,"2403":0,"2405":0,"2410":0,"2411":0,"2413":0,"2416":0,"2417":0,"2428":0,"2432":0,"2434":0,"2435":0,"2437":0,"2439":0,"2440":0,"2442":0,"2444":0,"2456":0,"2462":0,"2464":0,"2469":0,"2470":0,"2472":0,"2473":0,"2474":0,"2475":0,"2476":0,"2478":0,"2480":0,"2482":0,"2485":0,"2486":0,"2488":0,"2490":0,"2493":0,"2494":0,"2495":0,"2496":0,"2498":0,"2500":0,"2501":0,"2503":0,"2505":0,"2506":0,"2521":0,"2529":0,"2531":0,"2535":0,"2536":0,"2537":0,"2539":0,"2541":0,"2543":0,"2546":0,"2547":0,"2548":0,"2549":0,"2551":0,"2553":0,"2556":0,"2567":0,"2569":0,"2571":0,"2576":0,"2578":0,"2589":0,"2591":0,"2594":0,"2596":0,"2597":0,"2598":0,"2599":0,"2602":0,"2614":0,"2617":0,"2619":0,"2623":0,"2636":0,"2642":0,"2644":0,"2648":0,"2650":0,"2663":0,"2667":0,"2669":0,"2673":0,"2675":0,"2689":0,"2690":0,"2692":0,"2696":0,"2698":0,"2710":0,"2714":0,"2716":0,"2720":0,"2733":0,"2739":0,"2743":0,"2745":0,"2749":0,"2754":0,"2756":0,"2769":0,"2777":0,"2779":0,"2780":0,"2781":0,"2782":0,"2786":0,"2787":0,"2789":0,"2791":0,"2795":0,"2796":0,"2797":0,"2798":0,"2799":0,"2800":0,"2801":0,"2803":0,"2807":0,"2809":0,"2810":0,"2811":0,"2815":0,"2816":0,"2818":0,"2820":0,"2839":0,"2841":0,"2842":0,"2843":0,"2844":0,"2845":0,"2856":0,"2867":0,"2880":0,"2885":0,"2886":0,"2887":0,"2888":0,"2889":0,"2890":0,"2891":0,"2892":0,"2893":0,"2894":0,"2895":0,"2896":0,"2897":0,"2898":0,"2910":0,"2912":0,"2913":0,"2915":0,"2916":0,"2917":0,"2930":0,"2935":0,"2937":0,"2939":0,"2940":0,"2941":0,"2942":0,"2945":0,"2947":0,"2971":0,"2972":0,"2974":0,"2976":0,"2978":0,"2980":0,"2982":0,"2984":0,"3003":0,"3005":0,"3007":0,"3012":0,"3013":0,"3031":0,"3033":0,"3035":0,"3040":0,"3041":0,"3055":0,"3060":0,"3061":0,"3075":0,"3080":0,"3081":0,"3116":0,"3118":0,"3119":0,"3121":0,"3124":0,"3139":0,"3141":0,"3142":0,"3144":0,"3147":0,"3168":0,"3169":0,"3171":0,"3173":0,"3231":0,"3246":0,"3248":0,"3250":0,"3266":0,"3288":0,"3293":0,"3294":0,"3328":0,"3349":0,"3370":0,"3435":0,"3442":0,"3443":0,"3444":0,"3445":0,"3446":0,"3447":0,"3448":0,"3449":0,"3458":0,"3459":0,"3460":0,"3461":0,"3462":0,"3463":0,"3464":0,"3476":0,"3479":0,"3481":0,"3483":0,"3485":0,"3489":0,"3491":0,"3578":0,"3592":0,"3596":0,"3598":0,"3599":0,"3601":0,"3614":0,"3619":0,"3621":0,"3622":0,"3624":0,"3625":0,"3636":0,"3638":0,"3639":0,"3641":0,"3643":0,"3646":0,"3658":0,"3659":0,"3661":0,"3662":0,"3676":0,"3678":0,"3680":0,"3682":0,"3694":0,"3695":0,"3697":0,"3699":0,"3710":0,"3716":0,"3718":0,"3719":0,"3720":0,"3722":0,"3724":0,"3725":0,"3727":0,"3729":0,"3730":0,"3734":0,"3735":0,"3746":0,"3749":0,"3751":0,"3753":0,"3755":0,"3757":0,"3771":0,"3772":0,"3774":0,"3776":0,"3778":0,"3780":0,"3794":0,"3808":0,"3812":0,"3813":0,"3814":0,"3826":0,"3827":0,"3841":0,"3843":0,"3845":0,"3857":0,"3869":0,"3884":0,"3888":0,"3890":0,"3891":0,"3893":0,"3897":0,"3899":0,"3900":0,"3904":0,"3906":0,"3908":0,"3912":0,"3913":0,"3952":0,"3966":0,"3980":0,"3982":0,"3984":0,"3999":0,"4003":0,"4005":0,"4007":0,"4009":0,"4011":0,"4015":0,"4016":0,"4030":0,"4032":0,"4034":0,"4049":0,"4050":0,"4052":0,"4054":0,"4058":0,"4059":0,"4075":0,"4091":0,"4104":0,"4106":0,"4108":0,"4121":0,"4124":0,"4126":0,"4128":0,"4131":0,"4147":0,"4149":0,"4152":0,"4154":0,"4181":0,"4183":0,"4185":0,"4207":0,"4219":0,"4221":0,"4223":0,"4235":0,"4240":0,"4242":0,"4243":0,"4245":0,"4248":0,"4272":0,"4285":0,"4290":0,"4292":0,"4293":0,"4297":0,"4299":0,"4301":0,"4303":0,"4315":0,"4324":0,"4326":0,"4328":0,"4329":0,"4331":0,"4332":0,"4334":0,"4336":0,"4338":0,"4340":0,"4342":0,"4343":0,"4347":0,"4348":0,"4349":0,"4352":0,"4354":0,"4356":0,"4358":0,"4362":0,"4364":0,"4366":0,"4368":0,"4370":0,"4374":0,"4377":0,"4378":0,"4381":0,"4395":0,"4410":0,"4412":0,"4414":0,"4415":0,"4417":0,"4419":0,"4420":0,"4424":0,"4426":0,"4428":0,"4430":0,"4433":0,"4435":0,"4439":0,"4442":0,"4444":0,"4446":0,"4447":0,"4448":0,"4449":0,"4450":0,"4452":0,"4454":0,"4456":0,"4457":0,"4458":0,"4459":0,"4463":0,"4465":0,"4469":0,"4472":0,"4474":0,"4476":0,"4477":0,"4478":0,"4479":0,"4483":0,"4485":0,"4489":0,"4494":0,"4495":0,"4496":0,"4497":0,"4502":0,"4504":0,"4506":0,"4508":0,"4512":0,"4513":0,"4519":0,"4521":0,"4523":0,"4527":0,"4530":0,"4532":0,"4534":0,"4535":0,"4536":0,"4540":0,"4541":0,"4546":0,"4550":0,"4552":0,"4554":0,"4556":0,"4559":0,"4560":0,"4562":0,"4564":0,"4566":0,"4568":0,"4570":0,"4571":0,"4572":0,"4574":0,"4576":0,"4577":0,"4581":0,"4582":0,"4584":0,"4585":0,"4586":0,"4590":0,"4591":0,"4593":0,"4595":0,"4596":0,"4601":0,"4602":0,"4604":0,"4606":0,"4608":0,"4609":0,"4610":0,"4612":0,"4614":0,"4618":0,"4619":0,"4624":0,"4626":0,"4627":0,"4628":0,"4629":0,"4630":0,"4631":0,"4633":0,"4635":0,"4637":0,"4639":0,"4641":0,"4643":0,"4647":0,"4649":0,"4651":0,"4653":0,"4654":0,"4658":0,"4660":0,"4664":0,"4666":0,"4670":0,"4671":0,"4685":0,"4690":0,"4692":0,"4694":0,"4696":0,"4698":0,"4702":0,"4703":0,"4705":0,"4707":0,"4709":0,"4724":0,"4725":0,"4727":0,"4729":0,"4730":0,"4745":0,"4746":0,"4748":0,"4750":0,"4765":0,"4766":0,"4768":0,"4770":0,"4785":0,"4786":0,"4787":0,"4801":0,"4804":0,"4806":0,"4808":0,"4809":0,"4810":0,"4811":0,"4813":0,"4815":0,"4819":0,"4831":0,"4833":0,"4836":0,"4839":0,"4849":0,"4861":0,"4863":0,"4865":0,"4868":0,"4870":0,"4871":0,"4872":0,"4874":0,"4876":0,"4877":0,"4879":0,"4881":0,"4883":0,"4887":0,"4891":0,"4893":0,"4897":0,"4899":0,"4901":0,"4905":0,"4908":0,"4909":0,"4910":0,"4912":0,"4914":0,"4916":0,"4918":0,"4922":0,"4934":0,"4936":0,"4939":0,"4941":0,"4956":0,"4957":0,"4974":0,"4975":0,"4988":0,"4989":0,"4991":0,"4993":0,"4997":0,"4998":0,"5011":0,"5012":0,"5014":0,"5016":0,"5020":0,"5021":0,"5041":0,"5042":0,"5044":0,"5046":0,"5061":0,"5072":0,"5073":0,"5075":0,"5077":0,"5109":0,"5114":0,"5115":0,"5116":0,"5118":0,"5122":0,"5124":0,"5138":0,"5143":0,"5145":0,"5146":0,"5148":0,"5152":0,"5153":0,"5155":0,"5157":0,"5159":0,"5161":0,"5165":0,"5167":0,"5169":0,"5174":0,"5177":0,"5179":0,"5192":0,"5198":0,"5200":0,"5201":0,"5203":0,"5207":0,"5208":0,"5210":0,"5212":0,"5214":0,"5216":0,"5220":0,"5222":0,"5224":0,"5229":0,"5232":0,"5234":0,"5235":0,"5248":0,"5250":0,"5252":0,"5254":0,"5257":0,"5261":0,"5273":0,"5275":0,"5278":0,"5280":0,"5292":0,"5329":0,"5330":0,"5344":0,"5349":0,"5351":0,"5353":0,"5355":0,"5356":0,"5357":0,"5359":0,"5360":0,"5373":0,"5379":0,"5381":0,"5383":0,"5385":0,"5386":0,"5387":0,"5389":0,"5390":0,"5391":0,"5403":0,"5405":0,"5407":0,"5408":0,"5410":0,"5412":0,"5425":0,"5439":0,"5440":0,"5442":0,"5444":0,"5446":0,"5448":0,"5462":0,"5475":0,"5477":0,"5479":0,"5481":0,"5495":0,"5498":0,"5500":0,"5504":0,"5506":0,"5518":0,"5520":0,"5532":0,"5535":0,"5539":0,"5549":0,"5553":0,"5565":0,"5573":0,"5575":0,"5578":0,"5586":0,"5588":0,"5589":0,"5590":0,"5591":0,"5592":0,"5595":0,"5597":0,"5598":0,"5599":0,"5602":0,"5603":0,"5604":0,"5605":0,"5606":0,"5607":0,"5609":0,"5611":0,"5612":0,"5614":0,"5616":0,"5617":0,"5621":0,"5622":0,"5626":0,"5639":0,"5644":0,"5645":0,"5647":0,"5648":0,"5649":0,"5652":0,"5654":0,"5657":0,"5660":0,"5669":0,"5671":0,"5689":0,"5691":0,"5695":0,"5707":0,"5723":0,"5725":0,"5726":0,"5727":0,"5731":0,"5733":0,"5735":0,"5737":0,"5739":0,"5740":0,"5742":0,"5743":0,"5745":0,"5746":0,"5748":0,"5752":0,"5756":0,"5758":0,"5762":0,"5765":0,"5766":0,"5767":0,"5769":0,"5771":0,"5772":0,"5773":0,"5776":0,"5777":0,"5788":0,"5805":0,"5807":0,"5808":0,"5809":0,"5813":0,"5815":0,"5817":0,"5819":0,"5821":0,"5822":0,"5824":0,"5825":0,"5827":0,"5828":0,"5830":0,"5834":0,"5838":0,"5840":0,"5844":0,"5847":0,"5848":0,"5849":0,"5851":0,"5853":0,"5854":0,"5855":0,"5858":0,"5859":0,"5874":0,"5886":0,"5888":0,"5889":0,"5891":0,"5893":0,"5895":0,"5896":0,"5897":0,"5899":0,"5902":0,"5903":0,"5905":0,"5906":0,"5922":0,"5925":0,"5927":0,"5928":0,"5930":0,"5944":0,"5947":0,"5949":0,"5950":0,"5952":0,"5967":0,"5979":0,"5981":0,"5982":0,"5984":0,"5987":0,"5988":0,"5990":0,"5991":0,"5992":0,"5995":0,"5996":0,"5998":0,"5999":0,"6004":0,"6013":0,"6015":0,"6032":0,"6033":0,"6035":0,"6037":0,"6038":0,"6050":0,"6052":0,"6064":0,"6066":0,"6068":0,"6092":0,"6094":0,"6095":0,"6099":0,"6100":0,"6102":0,"6103":0,"6108":0,"6110":0,"6111":0,"6112":0,"6113":0,"6115":0,"6116":0,"6118":0,"6120":0,"6121":0,"6123":0,"6125":0,"6127":0,"6131":0,"6136":0,"6138":0,"6142":0,"6144":0,"6150":0,"6153":0,"6154":0,"6155":0,"6157":0,"6168":0,"6170":0,"6172":0,"6187":0,"6192":0,"6193":0,"6195":0,"6196":0,"6197":0,"6198":0,"6199":0,"6200":0,"6201":0,"6203":0,"6220":0,"6221":0,"6222":0,"6231":0,"6232":0,"6234":0,"6236":0,"6237":0,"6238":0,"6239":0,"6242":0,"6243":0,"6245":0,"6247":0,"6249":0,"6251":0,"6254":0,"6266":0,"6279":0,"6280":0,"6288":0,"6290":0,"6294":0,"6299":0,"6300":0,"6304":0,"6305":0,"6308":0,"6318":0,"6319":0,"6321":0,"6322":0,"6324":0,"6336":0,"6338":0,"6352":0,"6354":0,"6356":0,"6370":0,"6371":0,"6375":0,"6376":0,"6378":0,"6379":0,"6380":0,"6381":0,"6383":0,"6385":0,"6387":0,"6388":0,"6389":0,"6390":0,"6394":0,"6396":0,"6397":0,"6399":0,"6400":0,"6401":0,"6412":0,"6414":0,"6416":0,"6432":0,"6436":0,"6437":0,"6438":0,"6440":0,"6441":0,"6442":0,"6443":0,"6444":0,"6445":0,"6446":0,"6448":0,"6450":0,"6451":0,"6455":0,"6456":0,"6458":0,"6459":0,"6470":0,"6472":0,"6474":0,"6496":0,"6497":0,"6498":0,"6499":0,"6500":0,"6504":0,"6505":0,"6506":0,"6508":0,"6509":0,"6510":0,"6511":0,"6512":0,"6513":0,"6514":0,"6516":0,"6518":0,"6519":0,"6520":0,"6521":0,"6522":0,"6523":0,"6524":0,"6526":0,"6527":0,"6528":0,"6529":0,"6530":0,"6531":0,"6532":0,"6537":0,"6539":0,"6540":0,"6544":0,"6545":0,"6549":0,"6550":0,"6571":0,"6575":0,"6577":0,"6578":0,"6579":0,"6580":0,"6581":0,"6582":0,"6586":0,"6587":0,"6588":0,"6589":0,"6590":0,"6591":0,"6593":0,"6594":0,"6595":0,"6611":0,"6613":0,"6615":0,"6616":0,"6618":0,"6621":0,"6637":0,"6639":0,"6641":0,"6642":0,"6646":0,"6647":0,"6649":0,"6661":0,"6682":0,"6684":0,"6687":0,"6688":0,"6689":0,"6690":0,"6692":0,"6693":0,"6694":0,"6695":0,"6699":0,"6700":0,"6701":0,"6702":0,"6704":0,"6706":0,"6707":0,"6708":0,"6709":0,"6710":0,"6714":0,"6717":0,"6718":0,"6719":0,"6720":0,"6722":0,"6723":0,"6724":0,"6726":0,"6727":0,"6728":0,"6730":0,"6731":0,"6732":0,"6733":0,"6735":0,"6737":0,"6738":0,"6739":0,"6741":0,"6742":0,"6743":0,"6744":0,"6746":0,"6747":0,"6748":0,"6750":0,"6752":0,"6753":0,"6754":0,"6756":0,"6758":0,"6759":0,"6760":0,"6763":0,"6764":0,"6765":0,"6766":0,"6769":0,"6770":0,"6771":0,"6783":0,"6787":0,"6788":0,"6797":0,"6799":0,"6803":0,"6807":0,"6810":0,"6828":0,"6830":0,"6832":0,"6851":0,"6853":0,"6854":0,"6855":0,"6857":0,"6858":0,"6860":0,"6872":0,"6874":0,"6876":0,"6878":0,"6880":0,"6882":0,"6883":0,"6885":0,"6886":0,"6887":0,"6889":0,"6890":0,"6892":0,"6894":0,"6896":0,"6898":0,"6901":0,"6902":0,"6903":0,"6905":0,"6931":0,"6933":0,"6935":0,"6948":0,"6964":0,"6965":0,"6966":0,"7000":0,"7002":0,"7004":0,"7005":0,"7006":0,"7007":0,"7009":0,"7011":0,"7013":0,"7014":0,"7016":0,"7019":0,"7023":0,"7025":0,"7026":0,"7041":0,"7044":0,"7045":0,"7046":0,"7047":0,"7048":0,"7059":0,"7061":0,"7062":0,"7064":0,"7066":0,"7070":0,"7072":0,"7084":0,"7090":0,"7092":0,"7094":0,"7095":0,"7097":0,"7100":0,"7101":0,"7109":0,"7110":0,"7111":0,"7113":0,"7115":0,"7117":0,"7119":0,"7121":0,"7123":0,"7124":0,"7125":0,"7137":0,"7141":0,"7143":0,"7144":0,"7146":0,"7147":0,"7149":0,"7163":0,"7164":0,"7166":0,"7167":0,"7169":0,"7184":0,"7186":0,"7194":0,"7195":0,"7196":0,"7197":0,"7198":0,"7199":0,"7200":0,"7201":0,"7202":0,"7217":0,"7219":0,"7221":0,"7234":0,"7235":0,"7248":0,"7250":0,"7251":0,"7252":0,"7254":0,"7256":0,"7258":0,"7261":0,"7274":0,"7275":0,"7278":0,"7279":0,"7281":0,"7282":0,"7284":0,"7285":0,"7287":0,"7288":0,"7290":0,"7301":0,"7302":0,"7311":0,"7313":0,"7322":0,"7324":0,"7326":0,"7365":0,"7367":0,"7369":0,"7371":0,"7373":0,"7375":0,"7376":0,"7380":0,"7381":0,"7383":0,"7384":0,"7385":0,"7386":0,"7388":0,"7389":0,"7390":0,"7392":0,"7395":0,"7396":0,"7397":0,"7399":0,"7400":0,"7401":0,"7402":0,"7403":0,"7404":0,"7406":0,"7407":0,"7409":0,"7410":0,"7411":0,"7412":0,"7413":0,"7414":0,"7415":0,"7417":0,"7418":0,"7420":0,"7421":0,"7423":0,"7424":0,"7426":0,"7428":0,"7429":0,"7430":0,"7431":0,"7435":0,"7436":0,"7437":0,"7438":0,"7439":0,"7441":0,"7443":0,"7445":0,"7447":0,"7451":0,"7453":0,"7456":0,"7457":0,"7458":0,"7460":0,"7471":0,"7493":0,"7516":0,"7517":0,"7518":0,"7522":0,"7533":0,"7576":0,"7577":0,"7578":0,"7579":0,"7590":0,"7592":0,"7594":0,"7595":0,"7597":0,"7599":0,"7600":0,"7602":0,"7603":0,"7604":0,"7605":0,"7606":0,"7608":0,"7611":0,"7612":0,"7613":0,"7615":0,"7618":0,"7619":0,"7620":0,"7622":0,"7625":0,"7637":0,"7638":0,"7639":0,"7651":0,"7652":0,"7653":0,"7674":0,"7675":0,"7677":0,"7690":0,"7691":0,"7693":0,"7706":0,"7712":0,"7714":0,"7716":0,"7717":0,"7718":0,"7720":0,"7722":0,"7723":0,"7724":0,"7735":0,"7737":0,"7741":0,"7753":0,"7755":0,"7766":0,"7800":0,"7801":0,"7802":0,"7803":0,"7804":0,"7806":0,"7808":0,"7810":0,"7811":0,"7812":0,"7814":0,"7816":0,"7818":0,"7819":0,"7820":0,"7822":0,"7826":0,"7828":0,"7830":0,"7834":0,"7836":0,"7837":0,"7838":0,"7839":0,"7841":0,"7842":0,"7843":0,"7844":0,"7845":0,"7858":0,"7861":0,"7863":0,"7864":0,"7866":0,"7879":0,"7882":0,"7884":0,"7885":0,"7887":0,"7898":0,"7901":0,"7903":0,"7905":0,"7907":0,"7908":0,"7910":0,"7911":0,"7912":0,"7913":0,"7915":0,"7917":0,"7918":0,"7920":0,"7924":0,"7925":0,"7950":0,"8005":0,"8013":0,"8014":0,"8016":0,"8018":0,"8019":0,"8031":0,"8042":0,"8043":0,"8054":0,"8056":0,"8058":0,"8060":0,"8062":0,"8064":0,"8066":0,"8068":0,"8070":0,"8072":0,"8074":0,"8075":0,"8076":0,"8077":0,"8078":0,"8079":0,"8081":0,"8083":0,"8084":0,"8086":0,"8089":0,"8091":0,"8092":0,"8094":0,"8096":0,"8097":0,"8099":0,"8101":0,"8102":0,"8188":0,"8193":0,"8194":0,"8207":0,"8212":0,"8213":0,"8229":0,"8234":0,"8236":0,"8240":0,"8242":0,"8258":0,"8263":0,"8265":0,"8269":0,"8271":0,"8330":0,"8370":0,"8384":0,"8425":0,"8440":0,"8481":0,"8482":0,"8484":0,"8486":0,"8498":0,"8499":0,"8501":0,"8503":0,"8526":0,"8528":0,"8532":0,"8538":0,"8539":0,"8555":0,"8565":0,"8579":0,"8581":0,"8583":0,"8584":0,"8598":0,"8599":0,"8658":0,"8666":0,"8680":0,"8682":0,"8684":0,"8698":0,"8699":0,"8754":0,"8764":0,"8818":0,"8828":0,"8829":0,"8857":0,"8867":0,"8868":0,"8897":0,"8911":0,"8914":0,"8916":0,"8917":0,"8921":0,"8922":0,"8924":0,"8937":0,"8939":0,"8957":0,"8958":0,"8959":0,"8960":0,"8961":0,"8962":0,"8963":0,"8964":0,"8966":0,"8967":0,"8968":0,"8969":0,"8971":0,"8973":0,"8975":0,"8977":0,"8978":0,"8980":0,"8981":0,"8983":0,"9047":0,"9061":0,"9064":0,"9066":0,"9067":0,"9071":0,"9072":0,"9074":0,"9087":0,"9089":0,"9107":0,"9108":0,"9109":0,"9110":0,"9111":0,"9112":0,"9113":0,"9114":0,"9116":0,"9117":0,"9118":0,"9119":0,"9121":0,"9123":0,"9125":0,"9127":0,"9128":0,"9130":0,"9131":0,"9133":0,"9205":0,"9215":0,"9229":0,"9231":0,"9233":0,"9247":0,"9248":0,"9297":0,"9307":0,"9350":0,"9360":0,"9361":0,"9392":0,"9402":0,"9404":0,"9406":0,"9408":0,"9410":0,"9412":0,"9425":0,"9429":0,"9431":0,"9433":0,"9435":0,"9437":0,"9439":0,"9440":0,"9442":0,"9443":0,"9444":0,"9446":0,"9447":0,"9449":0,"9466":0,"9467":0,"9468":0,"9469":0,"9470":0,"9556":0,"9560":0,"9589":0,"9593":0,"9616":0,"9620":0,"9659":0,"9669":0,"9670":0,"9682":0,"9684":0,"9686":0,"9688":0,"9690":0,"9692":0,"9733":0,"9743":0,"9745":0,"9747":0,"9749":0,"9751":0,"9753":0,"9783":0,"9793":0,"9795":0,"9797":0,"9799":0,"9801":0,"9803":0,"9842":0,"9852":0,"9853":0,"9880":0,"9890":0,"9891":0,"9903":0,"9930":0,"9939":0,"9941":0,"9943":0,"9974":0,"9976":0,"9978":0,"9980":0,"9982":0,"9983":0,"9985":0,"9986":0,"9987":0,"9989":0,"9991":0,"9992":0,"9993":0,"9994":0,"9996":0,"9997":0,"9998":0,"10003":0,"10004":0,"10006":0,"10007":0,"10008":0,"10010":0,"10011":0,"10013":0,"10015":0,"10017":0,"10018":0,"10020":0,"10021":0,"10023":0,"10025":0,"10026":0,"10028":0,"10029":0,"10031":0,"10033":0,"10034":0,"10035":0,"10039":0,"10040":0,"10045":0,"10047":0,"10048":0,"10049":0,"10050":0,"10052":0,"10054":0,"10055":0,"10056":0,"10059":0,"10061":0,"10062":0,"10064":0,"10065":0,"10066":0,"10067":0,"10071":0,"10072":0,"10073":0,"10074":0,"10075":0,"10077":0,"10079":0,"10081":0,"10083":0,"10086":0,"10088":0,"10091":0,"10093":0,"10104":0,"10118":0,"10120":0,"10128":0,"10129":0,"10130":0,"10131":0,"10132":0,"10133":0,"10134":0,"10135":0,"10136":0,"10137":0,"10139":0,"10143":0,"10145":0,"10147":0,"10151":0,"10153":0,"10166":0,"10189":0,"10190":0,"10191":0,"10270":0,"10280":0,"10282":0,"10285":0,"10316":0,"10318":0,"10320":0,"10322":0,"10324":0,"10325":0,"10327":0,"10328":0,"10329":0,"10331":0,"10333":0,"10334":0,"10335":0,"10336":0,"10338":0,"10339":0,"10340":0,"10345":0,"10346":0,"10348":0,"10349":0,"10350":0,"10352":0,"10353":0,"10354":0,"10356":0,"10358":0,"10359":0,"10361":0,"10362":0,"10364":0,"10366":0,"10367":0,"10369":0,"10370":0,"10371":0,"10373":0,"10375":0,"10376":0,"10380":0,"10381":0,"10386":0,"10388":0,"10389":0,"10390":0,"10392":0,"10394":0,"10395":0,"10396":0,"10397":0,"10400":0,"10402":0,"10403":0,"10405":0,"10406":0,"10407":0,"10408":0,"10412":0,"10413":0,"10414":0,"10415":0,"10416":0,"10418":0,"10420":0,"10422":0,"10424":0,"10427":0,"10429":0,"10432":0,"10434":0,"10445":0,"10460":0,"10462":0,"10470":0,"10471":0,"10472":0,"10473":0,"10474":0,"10475":0,"10476":0,"10478":0,"10482":0,"10484":0,"10486":0,"10490":0,"10492":0,"10506":0,"10529":0,"10530":0,"10531":0,"10622":0,"10649":0,"10652":0,"10654":0,"10655":0,"10657":0,"10658":0,"10660":0,"10662":0,"10663":0,"10664":0,"10665":0,"10666":0,"10667":0,"10668":0,"10669":0,"10670":0,"10671":0,"10672":0,"10673":0,"10674":0,"10701":0,"10703":0,"10705":0,"10706":0,"10708":0,"10710":0,"10711":0,"10713":0,"10714":0,"10715":0,"10726":0,"10727":0,"10739":0,"10740":0,"10741":0,"10753":0,"10754":0,"10755":0,"10776":0,"10778":0,"10791":0,"10793":0,"10805":0,"10808":0,"10810":0,"10811":0,"10813":0,"10814":0,"10816":0,"10817":0,"10818":0,"10819":0,"10820":0,"10822":0,"10826":0,"10839":0,"10873":0,"10875":0,"10877":0,"10878":0,"10880":0,"10884":0,"10885":0,"10886":0,"10887":0,"10889":0,"10890":0,"10891":0,"10893":0,"10895":0,"10896":0,"10898":0,"10902":0,"10904":0,"10906":0,"10908":0,"10910":0,"10912":0,"10914":0,"10916":0,"10918":0,"10920":0,"10922":0,"10924":0,"10925":0,"10926":0,"10927":0,"10928":0,"10947":0,"10948":0,"10950":0,"10953":0,"10967":0,"10986":0,"10988":0,"10989":0,"10990":0,"10991":0,"10993":0,"10994":0,"10998":0,"10999":0,"11002":0,"11003":0,"11004":0,"11005":0,"11006":0,"11007":0,"11008":0,"11009":0,"11023":0,"11025":0,"11030":0,"11031":0,"11032":0,"11033":0,"11034":0,"11050":0,"11053":0,"11054":0,"11055":0,"11056":0,"11067":0,"11070":0,"11072":0,"11073":0,"11075":0,"11078":0,"11090":0,"11105":0,"11106":0,"11107":0,"11157":0,"11165":0,"11166":0,"11168":0,"11170":0,"11171":0,"11214":0,"11230":0,"11246":0,"11261":0,"11274":0,"11275":0,"11280":0,"11293":0,"11294":0,"11299":0,"11351":0,"11369":0,"11370":0,"11372":0,"11384":0,"11386":0,"11398":0,"11413":0,"11415":0,"11417":0,"11418":0,"11422":0,"11423":0,"11424":0,"11426":0,"11431":0,"11433":0,"11434":0,"11435":0,"11436":0,"11441":0,"11443":0,"11445":0,"11461":0,"11462":0,"11477":0,"11478":0,"11491":0,"11498":0,"11542":0,"11549":0,"11550":0,"11551":0,"11552":0,"11553":0,"11554":0,"11563":0,"11572":0,"11574":0,"11575":0,"11576":0,"11577":0,"11578":0,"11579":0,"11580":0,"11581":0,"11582":0,"11583":0,"11585":0,"11587":0,"11588":0,"11590":0,"11593":0,"11595":0,"11597":0,"11599":0,"11621":0,"11623":0,"11625":0,"11627":0,"11639":0,"11641":0,"11643":0,"11645":0,"11658":0,"11660":0,"11662":0,"11692":0,"11694":0,"11696":0,"11700":0,"11701":0,"11702":0,"11703":0,"11705":0,"11706":0,"11708":0,"11709":0,"11711":0,"11713":0,"11714":0,"11716":0,"11717":0,"11718":0,"11731":0,"11736":0,"11738":0,"11740":0,"11741":0,"11743":0,"11745":0,"11746":0,"11747":0,"11748":0,"11749":0,"11750":0,"11751":0,"11764":0,"11770":0,"11771":0,"11773":0,"11775":0,"11776":0,"11777":0,"11778":0,"11779":0,"11780":0,"11781":0,"11782":0,"11783":0,"11784":0,"11785":0,"11787":0,"11858":0,"11859":0,"11861":0,"11865":0,"11867":0,"11879":0,"11884":0,"11904":0,"11906":0,"11907":0,"11908":0,"11909":0,"11910":0,"11922":0,"11929":0,"11931":0,"11933":0,"11935":0,"11936":0,"11938":0,"11939":0,"11942":0,"11944":0,"11946":0,"11948":0,"11950":0,"11952":0,"11954":0,"11965":0,"11967":0,"11968":0,"11970":0,"11974":0,"11975":0,"11976":0,"11977":0,"11978":0,"11979":0,"11980":0,"11982":0,"11983":0,"11985":0,"11986":0,"11989":0,"11990":0,"11992":0,"12005":0,"12008":0,"12010":0,"12012":0,"12014":0,"12015":0,"12017":0,"12019":0,"12033":0,"12045":0,"12056":0,"12058":0,"12059":0,"12061":0,"12063":0,"12064":0,"12066":0,"12068":0,"12069":0,"12084":0,"12085":0,"12099":0,"12100":0,"12123":0,"12128":0,"12129":0,"12156":0,"12172":0,"12173":0,"12175":0,"12177":0,"12179":0,"12180":0,"12181":0,"12183":0,"12185":0,"12186":0,"12203":0,"12204":0,"12206":0,"12208":0,"12210":0,"12211":0,"12212":0,"12214":0,"12216":0,"12217":0,"12232":0,"12234":0,"12235":0,"12236":0,"12238":0,"12254":0,"12256":0,"12257":0,"12258":0,"12260":0,"12276":0,"12278":0,"12279":0,"12280":0,"12282":0,"12331":0,"12333":0,"12345":0,"12346":0,"12348":0,"12350":0,"12355":0,"12356":0,"12358":0,"12360":0,"12375":0,"12380":0,"12381":0,"12382":0,"12397":0,"12398":0,"12400":0,"12402":0,"12417":0,"12419":0,"12420":0,"12422":0,"12500":0,"12577":0,"12587":0,"12589":0,"12591":0,"12604":0,"12605":0,"12607":0,"12620":0,"12624":0,"12625":0,"12627":0,"12639":0,"12641":0,"12643":0,"12645":0,"12649":0,"12652":0,"12667":0,"12669":0,"12671":0,"12673":0,"12684":0,"12687":0,"12689":0,"12691":0,"12723":0,"12725":0,"12732":0,"12734":0,"12735":0,"12737":0,"12739":0,"12741":0,"12743":0,"12764":0,"12776":0,"12808":0,"12809":0,"12810":0,"12811":0,"12820":0,"12824":0,"12825":0,"12826":0,"12827":0,"12828":0,"12830":0,"12832":0,"12844":0,"12847":0,"12848":0,"12849":0,"12850":0,"12851":0,"12852":0,"12853":0,"12854":0,"12855":0,"12856":0,"12857":0,"12858":0,"12859":0,"12860":0,"12861":0,"12862":0,"12874":0,"12877":0,"12878":0,"12879":0,"12880":0,"12881":0,"12882":0,"12891":0,"12900":0,"12901":0,"12902":0,"12903":0,"12904":0,"12913":0,"12914":0,"12917":0,"12919":0,"12920":0,"12921":0,"12922":0,"12925":0,"12928":0,"12929":0,"12930":0,"12932":0,"12934":0,"12935":0,"12936":0,"12938":0,"12939":0,"12945":0,"12946":0,"12947":0,"12948":0,"12949":0,"12950":0,"12953":0,"12955":0,"12957":0,"12961":0,"12962":0,"12965":0,"12967":0,"12968":0,"12969":0,"12971":0,"12972":0,"12977":0,"12978":0,"12981":0,"12983":0,"12987":0,"12989":0,"12991":0,"12993":0,"12995":0,"12996":0,"12998":0,"13001":0,"13016":0,"13029":0,"13031":0,"13033":0,"13035":0,"13037":0,"13038":0,"13133":0,"13157":0,"13161":0,"13162":0,"13163":0,"13165":0,"13166":0,"13168":0,"13169":0,"13171":0,"13173":0,"13175":0,"13176":0,"13178":0,"13180":0,"13182":0,"13198":0,"13199":0,"13201":0,"13205":0,"13220":0,"13222":0,"13224":0,"13225":0,"13226":0,"13227":0,"13228":0,"13241":0,"13246":0,"13248":0,"13249":0,"13260":0,"13262":0,"13263":0,"13264":0,"13265":0,"13266":0,"13277":0,"13281":0,"13283":0,"13285":0,"13286":0,"13287":0,"13300":0,"13314":0,"13316":0,"13317":0,"13318":0,"13320":0,"13322":0,"13324":0,"13328":0,"13330":0,"13332":0,"13335":0,"13337":0,"13349":0,"13360":0,"13362":0,"13366":0,"13369":0,"13370":0,"13373":0,"13374":0,"13375":0,"13376":0,"13377":0,"13378":0,"13379":0,"13380":0,"13381":0,"13382":0,"13383":0,"13384":0,"13385":0,"13386":0,"13387":0,"13388":0,"13389":0,"13390":0,"13413":0,"13421":0,"13423":0,"13424":0,"13426":0,"13428":0,"13431":0,"13433":0,"13434":0,"13436":0,"13437":0,"13438":0,"13439":0,"13440":0,"13441":0,"13442":0,"13444":0,"13446":0,"13449":0,"13478":0,"13481":0,"13482":0,"13483":0,"13485":0,"13487":0,"13488":0,"13489":0,"13490":0,"13491":0,"13493":0,"13495":0,"13496":0,"13508":0,"13510":0,"13514":0,"13516":0,"13518":0,"13535":0,"13536":0,"13538":0,"13540":0,"13542":0,"13544":0,"13546":0,"13548":0,"13560":0,"13565":0,"13567":0,"13568":0,"13570":0,"13572":0,"13576":0,"13589":0,"13593":0,"13595":0,"13597":0,"13598":0,"13600":0,"13602":0,"13605":0,"13608":0,"13618":0,"13625":0,"13631":0,"13632":0,"13633":0,"13634":0,"13635":0,"13636":0,"13638":0,"13641":0,"13642":0,"13644":0,"13645":0,"13646":0,"13647":0,"13648":0,"13649":0,"13650":0,"13651":0,"13652":0,"13654":0,"13655":0,"13668":0,"13698":0,"13699":0,"13701":0,"13702":0,"13706":0,"13707":0,"13709":0,"13710":0,"13712":0,"13713":0,"13715":0,"13717":0,"13719":0,"13722":0,"13724":0,"13725":0,"13727":0,"13729":0,"13730":0,"13733":0,"13734":0,"13736":0,"13737":0,"13738":0,"13739":0,"13741":0,"13743":0,"13745":0,"13747":0,"13749":0,"13750":0,"13751":0,"13752":0,"13756":0,"13785":0,"13787":0,"13801":0,"13833":0,"13835":0,"13837":0,"13839":0,"13852":0,"13853":0,"13855":0,"13856":0,"13858":0,"13871":0,"13873":0,"13875":0,"13877":0,"13890":0,"13910":0,"13911":0,"13913":0,"13914":0,"13915":0,"13916":0,"13920":0,"13921":0,"13922":0,"13923":0,"13925":0,"13926":0,"13928":0,"13929":0,"13930":0,"13932":0,"13933":0,"13935":0,"13936":0,"13937":0,"13941":0,"13946":0,"13949":0,"13951":0,"13952":0,"13954":0,"13955":0,"13956":0,"13957":0,"13959":0,"13961":0,"13964":0,"13966":0,"13968":0,"13969":0,"13971":0,"13972":0,"13974":0,"13975":0,"13978":0,"13979":0,"13980":0,"13981":0,"13983":0,"13984":0,"13986":0,"13988":0,"13990":0,"13992":0,"13994":0,"13996":0,"13998":0,"14001":0,"14003":0,"14005":0,"14006":0,"14007":0,"14009":0,"14021":0,"14026":0,"14028":0,"14029":0,"14031":0,"14034":0,"14036":0,"14037":0,"14039":0,"14054":0,"14057":0,"14058":0,"14071":0,"14075":0,"14077":0,"14079":0,"14083":0,"14085":0,"14087":0,"14088":0,"14090":0,"14091":0,"14097":0,"14113":0,"14115":0,"14117":0,"14119":0,"14121":0,"14137":0,"14139":0,"14143":0,"14157":0,"14186":0,"14188":0,"14190":0,"14191":0,"14193":0,"14197":0,"14198":0,"14199":0,"14200":0,"14202":0,"14204":0,"14206":0,"14207":0,"14209":0,"14211":0,"14212":0,"14214":0,"14216":0,"14221":0,"14223":0,"14226":0,"14228":0,"14229":0,"14231":0,"14233":0,"14234":0,"14236":0,"14238":0,"14241":0,"14245":0,"14246":0,"14247":0,"14251":0,"14253":0,"14254":0,"14256":0,"14258":0,"14262":0,"14273":0,"14280":0,"14282":0,"14284":0,"14286":0,"14288":0,"14289":0,"14291":0,"14293":0,"14294":0,"14296":0,"14298":0,"14299":0,"14301":0,"14302":0,"14303":0,"14305":0,"14309":0,"14311":0,"14312":0,"14314":0,"14316":0,"14330":0,"14332":0,"14344":0,"14356":0,"14358":0,"14359":0,"14361":0,"14363":0,"14365":0,"14367":0,"14369":0,"14373":0,"14375":0,"14377":0,"14379":0,"14381":0,"14384":0,"14386":0,"14388":0,"14390":0,"14392":0,"14396":0,"14398":0,"14400":0,"14402":0,"14404":0,"14418":0,"14419":0,"14421":0,"14423":0,"14436":0,"14455":0,"14457":0,"14458":0,"14462":0,"14463":0,"14465":0,"14467":0,"14469":0,"14471":0,"14472":0,"14473":0,"14474":0,"14476":0,"14477":0,"14478":0,"14480":0,"14481":0,"14483":0,"14485":0,"14487":0,"14491":0,"14492":0,"14494":0,"14495":0,"14497":0,"14499":0,"14501":0,"14503":0,"14505":0,"14507":0,"14513":0,"14514":0,"14516":0,"14518":0,"14519":0,"14521":0,"14522":0,"14524":0,"14527":0,"14529":0,"14531":0,"14533":0,"14536":0,"14538":0,"14541":0,"14543":0,"14545":0,"14547":0,"14548":0,"14550":0,"14552":0,"14554":0,"14558":0,"14561":0,"14563":0,"14565":0,"14567":0,"14568":0,"14570":0,"14572":0,"14574":0,"14589":0,"14592":0,"14594":0,"14596":0,"14598":0,"14600":0,"14602":0,"14607":0,"14609":0,"14613":0,"14617":0,"14648":0,"14654":0,"14656":0,"14661":0,"14669":0,"14674":0,"14680":0,"14681":0,"14682":0,"14683":0,"14684":0,"14696":0,"14698":0,"14701":0,"14703":0,"14705":0,"14721":0,"14725":0,"14727":0,"14728":0,"14730":0,"14731":0,"14734":0,"14736":0,"14737":0,"14738":0,"14740":0,"14741":0,"14744":0,"14759":0,"14763":0,"14765":0,"14766":0,"14768":0,"14769":0,"14772":0,"14774":0,"14775":0,"14776":0,"14778":0,"14779":0,"14782":0,"14797":0,"14801":0,"14803":0,"14804":0,"14806":0,"14807":0,"14810":0,"14812":0,"14813":0,"14814":0,"14816":0,"14817":0,"14820":0,"14835":0,"14839":0,"14841":0,"14842":0,"14844":0,"14845":0,"14848":0,"14850":0,"14851":0,"14852":0,"14854":0,"14855":0,"14858":0,"14869":0,"14871":0,"14872":0,"14874":0,"14875":0,"14876":0,"14906":0,"14908":0,"14909":0,"14910":0,"14912":0,"14913":0,"14916":0,"14918":0,"14919":0,"14920":0,"14921":0,"14923":0,"14924":0,"14927":0,"14929":0,"14930":0,"14931":0,"14933":0,"14934":0,"14937":0,"14939":0,"14940":0,"14941":0,"14943":0,"14944":0,"14948":0,"14949":0,"14950":0,"14951":0,"14952":0,"14953":0,"14954":0,"14956":0,"14957":0,"14958":0,"14959":0,"14961":0,"14962":0,"14964":0,"14965":0,"14967":0,"14968":0,"14969":0,"14971":0,"14976":0,"14977":0,"14979":0,"14980":0,"14982":0,"14983":0,"14984":0,"14986":0,"14991":0,"14992":0,"14994":0,"14995":0,"14997":0,"14998":0,"14999":0,"15001":0,"15006":0,"15007":0,"15009":0,"15010":0,"15012":0,"15013":0,"15014":0,"15016":0,"15021":0,"15022":0,"15023":0,"15024":0,"15025":0,"15027":0,"15028":0,"15029":0,"15031":0,"15032":0,"15034":0,"15036":0,"15037":0,"15039":0,"15041":0,"15044":0,"15046":0,"15047":0,"15048":0,"15050":0,"15051":0,"15053":0,"15055":0,"15056":0,"15058":0,"15060":0,"15063":0,"15065":0,"15066":0,"15067":0,"15069":0,"15070":0,"15071":0,"15072":0,"15074":0,"15077":0,"15079":0,"15082":0,"15084":0,"15085":0,"15086":0,"15088":0,"15089":0,"15090":0,"15091":0,"15093":0,"15096":0,"15098":0,"15101":0,"15102":0,"15104":0,"15105":0,"15107":0,"15109":0,"15110":0,"15111":0,"15112":0,"15113":0,"15116":0,"15118":0,"15119":0,"15120":0,"15121":0,"15134":0,"15140":0,"15142":0,"15143":0,"15145":0,"15147":0,"15148":0,"15150":0,"15151":0,"15153":0,"15155":0,"15158":0,"15159":0,"15161":0,"15163":0,"15166":0,"15168":0,"15170":0,"15172":0,"15173":0,"15175":0,"15177":0,"15178":0,"15191":0,"15201":0,"15203":0,"15205":0,"15207":0,"15209":0,"15211":0,"15213":0,"15217":0,"15219":0,"15220":0,"15221":0,"15225":0,"15227":0,"15228":0,"15232":0,"15233":0,"15234":0,"15235":0,"15237":0,"15238":0,"15240":0,"15242":0,"15244":0,"15246":0,"15247":0,"15248":0,"15249":0,"15250":0,"15252":0,"15253":0,"15257":0,"15259":0,"15261":0,"15285":0,"15288":0,"15290":0,"15292":0,"15294":0,"15296":0,"15298":0,"15302":0,"15307":0,"15309":0,"15311":0,"15313":0,"15329":0,"15333":0,"15335":0,"15336":0,"15338":0,"15339":0,"15341":0,"15343":0,"15348":0,"15353":0,"15357":0,"15359":0,"15360":0,"15361":0,"15363":0,"15365":0,"15370":0,"15372":0,"15374":0,"15375":0,"15392":0,"15393":0,"15395":0,"15397":0,"15402":0,"15403":0,"15435":0,"15440":0,"15444":0,"15446":0,"15448":0,"15452":0,"15455":0,"15457":0,"15459":0,"15463":0,"15466":0,"15468":0,"15485":0,"15487":0,"15489":0,"15505":0,"15507":0,"15509":0,"15570":0,"15571":0,"15573":0,"15575":0,"15577":0,"15579":0,"15584":0,"15585":0,"15642":0,"15643":0,"15645":0,"15647":0,"15651":0,"15652":0,"15654":0,"15656":0,"15658":0,"15662":0,"15676":0,"15677":0,"15679":0,"15681":0,"15685":0,"15686":0,"15688":0,"15690":0,"15692":0,"15696":0,"15710":0,"15712":0,"15714":0,"15719":0,"15721":0,"15723":0,"15728":0,"15730":0,"15733":0,"15734":0,"15756":0,"15766":0,"15768":0,"15770":0,"15781":0,"15783":0,"15784":0,"15785":0,"15786":0,"15788":0,"15789":0,"15790":0,"15791":0,"15792":0,"15795":0,"15796":0,"15809":0,"15811":0,"15813":0,"15818":0,"15820":0,"15821":0,"15823":0,"15825":0,"15826":0,"15828":0,"15830":0,"15832":0,"15833":0,"15834":0,"15835":0,"15836":0,"15838":0,"15840":0,"15841":0,"15842":0,"15843":0,"15844":0,"15845":0,"15846":0,"15847":0,"15860":0,"15864":0,"15866":0,"15867":0,"15869":0,"15871":0,"15873":0,"15875":0,"15877":0,"15878":0,"15879":0,"15881":0,"15885":0,"15887":0,"15900":0,"15902":0,"15903":0,"15904":0,"15905":0,"15906":0,"15907":0,"15908":0,"15920":0,"15925":0,"15927":0,"15928":0,"15932":0,"15934":0,"15935":0,"15937":0,"15939":0,"15940":0,"15942":0,"15944":0,"15946":0,"15947":0,"15948":0,"15950":0,"15965":0,"15968":0,"15990":0,"16000":0,"16001":0,"16002":0,"16014":0,"16025":0,"16029":0,"16031":0,"16032":0,"16033":0,"16063":0,"16066":0,"16068":0,"16069":0,"16071":0,"16072":0,"16073":0,"16085":0,"16097":0,"16098":0,"16099":0,"16100":0,"16102":0,"16104":0,"16106":0,"16108":0,"16109":0,"16110":0,"16111":0,"16112":0,"16113":0,"16114":0,"16116":0,"16117":0,"16118":0,"16122":0,"16124":0,"16125":0,"16140":0,"16142":0,"16143":0,"16145":0,"16158":0,"16163":0,"16177":0,"16182":0};
_yuitest_coverage["build/charts-base/charts-base.js"].functions = {"ShapeGroup:41":0,"_draw:55":0,"_getRadiusCollection:119":0,"getter:134":0,"setter:160":0,"getter:167":0,"setter:171":0,"getter:177":0,"setter:181":0,"CircleGroup:196":0,"drawShape:210":0,"getter:218":0,"RectGroup:256":0,"drawShape:270":0,"DiamondGroup:286":0,"drawShape:300":0,"EllipseGroup:316":0,"drawShape:330":0,"Renderer:347":0,"getter:358":0,"setter:364":0,"_setStyles:398":0,"(anonymous 2):421":0,"_mergeStyles:414":0,"_getDefaultStyles:442":0,"_getDefaultMargins:474":0,"setTickOffsets:490":0,"drawTick:530":0,"getLineStart:548":0,"getLabelPoint:575":0,"updateMaxLabelSize:587":0,"getExplicitlySized:618":0,"positionTitle:640":0,"positionLabel:672":0,"_setRotationCoords:718":0,"_getTransformOrigin:759":0,"setCalculatedSize:798":0,"_getDefaultMargins:836":0,"setTickOffsets:852":0,"drawTick:892":0,"getLineStart:910":0,"getLabelPoint:938":0,"updateMaxLabelSize:950":0,"getExplicitlySized:981":0,"positionTitle:1003":0,"positionLabel:1035":0,"_setRotationCoords:1086":0,"_getTransformOrigin:1125":0,"offsetNodeForTick:1154":0,"setCalculatedSize:1168":0,"_getDefaultMargins:1203":0,"setTickOffsets:1219":0,"getLineStart:1256":0,"drawTick:1284":0,"getLabelPoint:1303":0,"updateMaxLabelSize:1315":0,"getExplicitlySized:1346":0,"positionTitle:1368":0,"positionLabel:1400":0,"_setRotationCoords:1446":0,"_getTransformOrigin:1483":0,"offsetNodeForTick:1508":0,"setCalculatedSize:1520":0,"_getDefaultMargins:1553":0,"setTickOffsets:1569":0,"getLineStart:1605":0,"drawTick:1634":0,"getLabelPoint:1653":0,"updateMaxLabelSize:1665":0,"getExplicitlySized:1696":0,"positionTitle:1718":0,"positionLabel:1750":0,"_setRotationCoords:1802":0,"_getTransformOrigin:1849":0,"setCalculatedSize:1895":0,"_dataChangeHandler:1952":0,"_positionChangeHandler:1967":0,"_updateGraphic:1980":0,"_updateHandler:2006":0,"renderUI:2018":0,"syncUI:2027":0,"_setCanvas:2060":0,"_getDefaultStyles:2095":0,"_handleSizeChange:2162":0,"drawLine:2201":0,"_getTextRotationProps:2215":0,"_drawAxis:2253":0,"_setTotalTitleSize:2387":0,"_updatePathElement:2426":0,"_setTitle:2454":0,"getLabel:2519":0,"_createLabelCache:2565":0,"_clearLabelCache:2587":0,"getLineEnd:2612":0,"getLength:2634":0,"getFirstPoint:2661":0,"getNextPoint:2687":0,"getLastPoint:2708":0,"getPosition:2731":0,"_rotate:2767":0,"_simulateRotateWithTransformOrigin:2837":0,"getMaxLabelBounds:2854":0,"getMinLabelBounds:2865":0,"_getLabelBounds:2878":0,"_removeChildren:2908":0,"destructor:2928":0,"_setText:2969":0,"getter:3001":0,"setter:3010":0,"getter:3029":0,"setter:3038":0,"getter:3053":0,"setter:3058":0,"getter:3073":0,"setter:3078":0,"getter:3114":0,"getter:3137":0,"setter:3166":0,"getter:3229":0,"getter:3244":0,"validator:3264":0,"getter:3286":0,"setter:3291":0,"value:3326":0,"valueFn:3347":0,"valueFn:3368":0,"initializer:3440":0,"bindUI:3456":0,"_dataProviderChangeHandler:3474":0,"addKey:3576":0,"_getKeyArray:3590":0,"_setDataByKey:3612":0,"_updateTotalData:3634":0,"removeKey:3656":0,"getKeyValueAt:3674":0,"getDataByKey:3692":0,"_updateMinAndMax:3708":0,"getTotalMajorUnits:3744":0,"getMajorUnitDistance:3769":0,"getEdgeOffset:3792":0,"getLabelByIndex:3806":0,"_keyChangeHandler:3824":0,"_hasDataOverflow:3839":0,"getMinimumValue:3855":0,"getMaximumValue:3867":0,"setter:3882":0,"getter:3950":0,"setter:3964":0,"getter:3978":0,"getter:3997":0,"setter:4013":0,"getter:4028":0,"getter:4047":0,"setter:4056":0,"getter:4073":0,"getter:4089":0,"getter:4102":0,"getter:4119":0,"NumericAxis:4147":0,"value:4179":0,"formatLabel:4217":0,"getTotalByKey:4233":0,"_getMinimumUnit:4270":0,"_getNiceNumber:4283":0,"_updateMinAndMax:4313":0,"_roundMinAndMax:4393":0,"getLabelByIndex:4683":0,"_roundToNearest:4722":0,"_roundUpToNearest:4743":0,"_roundDownToNearest:4763":0,"_roundToPrecision:4783":0,"_hasDataOverflow:4799":0,"StackedAxis:4831":0,"_updateMinAndMax:4847":0,"TimeAxis:4934":0,"getter:4954":0,"getter:4972":0,"getter:4986":0,"setter:4995":0,"getter:5009":0,"setter:5018":0,"value:5039":0,"formatLabel:5070":0,"getLabelByIndex:5107":0,"_getKeyArray:5136":0,"_setDataByKey:5190":0,"_getNumber:5246":0,"CategoryAxis:5273":0,"formatLabel:5290":0,"_updateMinAndMax:5327":0,"_getKeyArray:5342":0,"_setDataByKey:5371":0,"getDataByKey:5401":0,"getTotalMajorUnits:5423":0,"getMajorUnitDistance:5437":0,"getEdgeOffset:5460":0,"getKeyValueAt:5473":0,"getLabelByIndex:5493":0,"getMinimumValue:5516":0,"getMaximumValue:5530":0,"CurveUtil:5549":0,"getCurveControlPoints:5563":0,"getControlPoints:5637":0,"StackingUtil:5669":0,"_stackCoordinates:5687":0,"_stackXCoords:5705":0,"_stackYCoords:5786":0,"_cleanXNaN:5872":0,"_getPreviousValidCoordValue:5920":0,"_getNextValidCoordValue:5942":0,"_cleanYNaN:5965":0,"Lines:6013":0,"_getGraphic:6030":0,"_toggleVisible:6048":0,"drawLines:6062":0,"drawSpline:6166":0,"drawDashedLine:6218":0,"_getLineDefaults:6264":0,"getter:6292":0,"setter:6297":0,"Fills:6288":0,"_getPath:6316":0,"_toggleVisible:6334":0,"drawFill:6350":0,"drawAreaSpline:6410":0,"drawStackedAreaSpline:6468":0,"_getClosingPoints:6569":0,"_getHighestValidOrder:6609":0,"_getCoordsByOrderAndIndex:6635":0,"_getStackedClosingPoints:6659":0,"_getAreaDefaults:6781":0,"getter:6801":0,"Plots:6797":0,"drawPlots:6826":0,"_getGroupShape:6929":0,"_getPlotDefaults:6946":0,"getMarker:6998":0,"_createMarker:7039":0,"_createMarkerCache:7057":0,"_createGroupMarker:7082":0,"_toggleVisible:7135":0,"_clearMarkerCache:7161":0,"updateMarkerState:7182":0,"_getItemColor:7215":0,"_setStyles:7232":0,"_parseMarkerStyles:7246":0,"_getState:7272":0,"Histogram:7311":0,"drawSeries:7320":0,"_getPlotDefaults:7491":0,"render:7574":0,"(anonymous 3):7604":0,"(anonymous 4):7611":0,"(anonymous 5):7618":0,"addListeners:7588":0,"_xAxisChangeHandler:7635":0,"_yAxisChangeHandler:7649":0,"_xDataChangeHandler:7672":0,"_yDataChangeHandler:7688":0,"_updateAxisData:7704":0,"validate:7733":0,"_setCanvas:7751":0,"setAreaData:7764":0,"_getFirstValidIndex:7856":0,"_getLastValidIndex:7877":0,"draw:7896":0,"_getDefaultStyles:7948":0,"_getDefaultColor:8003":0,"_handleVisibleChange:8029":0,"getTotalValues:8040":0,"destructor:8052":0,"getter:8186":0,"setter:8191":0,"getter:8205":0,"setter:8210":0,"getter:8227":0,"setter:8232":0,"getter:8256":0,"setter:8261":0,"getter:8328":0,"setter:8368":0,"setter:8382":0,"getter:8423":0,"getter:8438":0,"getter:8480":0,"getter:8497":0,"getter:8524":0,"setter:8536":0,"drawSeries:8563":0,"_setStyles:8577":0,"_getDefaultStyles:8596":0,"drawSeries:8664":0,"_setStyles:8678":0,"_getDefaultStyles:8696":0,"drawSeries:8762":0,"setAreaData:8826":0,"setAreaData:8865":0,"_getMarkerDimensions:8909":0,"updateMarkerState:8935":0,"_getMarkerDimensions:9059":0,"updateMarkerState:9085":0,"drawSeries:9213":0,"_setStyles:9227":0,"_getDefaultStyles:9245":0,"drawSeries:9305":0,"drawSeries:9358":0,"drawSeries:9400":0,"_toggleVisible:9423":0,"_getDefaultStyles:9464":0,"getter:9554":0,"setter:9558":0,"getter:9587":0,"setter:9591":0,"getter:9614":0,"setter:9618":0,"setAreaData:9667":0,"drawSeries:9680":0,"drawSeries:9741":0,"drawSeries:9791":0,"setAreaData:9850":0,"setAreaData:9888":0,"drawSeries:9901":0,"drawSeries:9937":0,"updateMarkerState:10116":0,"_getPlotDefaults:10164":0,"drawSeries:10278":0,"updateMarkerState:10458":0,"_getPlotDefaults:10504":0,"_setMap:10647":0,"addListeners:10699":0,"validate:10724":0,"_categoryAxisChangeHandler:10737":0,"_valueAxisChangeHandler:10751":0,"_categoryDataChangeHandler:10774":0,"_valueDataChangeHandler:10789":0,"draw:10803":0,"drawPlots:10837":0,"_addHotspot:10965":0,"updateMarkerState:11021":0,"_createMarker:11048":0,"_clearMarkerCache:11065":0,"_getPlotDefaults:11088":0,"_getDefaultColor:11155":0,"validator:11212":0,"validator:11228":0,"validator:11244":0,"validator:11259":0,"setter:11272":0,"getter:11278":0,"setter:11291":0,"getter:11297":0,"remove:11367":0,"draw:11382":0,"_drawGridlines:11396":0,"_horizontalLine:11459":0,"_verticalLine:11475":0,"_getDefaultStyles:11489":0,"bindUI:11547":0,"syncUI:11561":0,"getSeriesByIndex:11619":0,"getSeriesByKey:11637":0,"addDispatcher:11656":0,"_parseSeriesCollection:11690":0,"_addSeries:11729":0,"_createSeries:11762":0,"_getSeries:11856":0,"_markerEventHandler:11877":0,"_updateStyles:11902":0,"_sizeChangeHandler:11920":0,"_drawSeries:11963":0,"_drawingCompleteHandler:12003":0,"_getDefaultStyles:12031":0,"destructor:12054":0,"setter:12082":0,"setter:12097":0,"getter:12121":0,"setter:12126":0,"getter:12154":0,"setter:12170":0,"setter:12201":0,"getter:12230":0,"getter:12252":0,"getter:12274":0,"ChartBase:12331":0,"valueFn:12343":0,"setter:12353":0,"getter:12373":0,"setter:12378":0,"setter:12395":0,"setter:12415":0,"setter:12498":0,"_groupMarkersChangeHandler:12585":0,"_itemRendered:12602":0,"(anonymous 6):12624":0,"_getGraph:12618":0,"getSeries:12637":0,"getAxisByKey:12665":0,"getCategoryAxis:12682":0,"_setDataValues:12721":0,"_setSeriesCollection:12762":0,"_getAxisClass:12774":0,"initializer:12806":0,"renderUI:12818":0,"_setAriaElements:12842":0,"_getAriaOffscreenNode:12872":0,"syncUI:12889":0,"(anonymous 7):12913":0,"(anonymous 8):12934":0,"(anonymous 9):12967":0,"bindUI:12898":0,"_markerEventDispatcher:13014":0,"_dataProviderChangeHandler:13155":0,"toggleTooltip:13196":0,"_showTooltip:13218":0,"_positionTooltip:13239":0,"hideTooltip:13258":0,"_addTooltip:13275":0,"_updateTooltip:13298":0,"markerEventHandler:13358":0,"planarEventHandler:13364":0,"_getTooltip:13347":0,"_planarLabelFunction:13411":0,"_tooltipLabelFunction:13476":0,"_tooltipChangeHandler:13506":0,"_setText:13533":0,"_getAllKeys:13558":0,"_buildSeriesKeys:13587":0,"renderUI:13623":0,"_planarEventDispatcher:13666":0,"_addToAxesRenderQueue:13831":0,"_addToAxesCollection:13850":0,"_getDefaultSeriesCollection:13869":0,"_parseSeriesCollection:13888":0,"_parseSeriesAxes:14019":0,"_getCategoryAxis:14052":0,"_getSeriesAxis:14069":0,"_getBaseAttribute:14111":0,"_setBaseAttribute:14135":0,"_setAxes:14155":0,"_addAxes:14271":0,"_addSeries:14328":0,"_addGridlines:14342":0,"_getDefaultAxes:14416":0,"_parseAxes:14434":0,"_getDefaultAxisPosition:14587":0,"getSeriesItems:14646":0,"_sizeChanged:14694":0,"_getTopOverflow:14719":0,"_getRightOverflow:14757":0,"_getLeftOverflow:14795":0,"_getBottomOverflow:14833":0,"_redraw:14867":0,"destructor:15132":0,"_getAriaMessage:15189":0,"getter:15283":0,"setter:15305":0,"getter:15327":0,"setter:15351":0,"getter:15390":0,"setter:15400":0,"getter:15433":0,"setter:15442":0,"setter:15483":0,"setter:15503":0,"getter:15568":0,"setter:15582":0,"getter:15640":0,"setter:15649":0,"getter:15674":0,"setter:15683":0,"getter:15708":0,"setter:15717":0,"_getSeriesCollection:15764":0,"_parseAxes:15807":0,"_addAxes:15858":0,"_addSeries:15898":0,"_parseSeriesAxes:15918":0,"_getDefaultAxes:15963":0,"getSeriesItems:15988":0,"_sizeChanged:16012":0,"_redraw:16023":0,"_tooltipLabelFunction:16061":0,"_getAriaMessage:16083":0,"setter:16138":0,"getter:16156":0,"setter:16161":0,"getter:16175":0,"setter:16180":0,"(anonymous 1):1":0};
_yuitest_coverage["build/charts-base/charts-base.js"].coveredLines = 3961;
_yuitest_coverage["build/charts-base/charts-base.js"].coveredFunctions = 489;
_yuitest_coverline("build/charts-base/charts-base.js", 1);
YUI.add('charts-base', function (Y, NAME) {

/**
 * The Charts widget provides an api for displaying data
 * graphically.
 *
 * @module charts
 * @main charts
 */

/**
 * The charts-base submodule contains the core functionality for the charts module.
 *
 * @module charts
 * @submodule charts-base
 */
_yuitest_coverfunc("build/charts-base/charts-base.js", "(anonymous 1)", 1);
_yuitest_coverline("build/charts-base/charts-base.js", 17);
var CONFIG = Y.config,
    WINDOW = CONFIG.win,
    DOCUMENT = CONFIG.doc,
    Y_Lang = Y.Lang,
    IS_STRING = Y_Lang.isString,
    Y_DOM = Y.DOM,
    LeftAxisLayout,
    RightAxisLayout,
    BottomAxisLayout,
    TopAxisLayout,
    _getClassName = Y.ClassNameManager.getClassName,
    SERIES_MARKER = _getClassName("seriesmarker"),
    ShapeGroup,
    CircleGroup,
    RectGroup,
    EllipseGroup,
    DiamondGroup;

/**
 * Abstract class for creating groups of shapes with the same styles and dimensions.
 *
 * @class ShapeGroup
 * @constructor
 */
 _yuitest_coverline("build/charts-base/charts-base.js", 41);
ShapeGroup = function(cfg)
 {
    _yuitest_coverfunc("build/charts-base/charts-base.js", "ShapeGroup", 41);
_yuitest_coverline("build/charts-base/charts-base.js", 43);
ShapeGroup.superclass.constructor.apply(this, arguments);
 };
    
 _yuitest_coverline("build/charts-base/charts-base.js", 46);
ShapeGroup.NAME = "shapeGroup";

 _yuitest_coverline("build/charts-base/charts-base.js", 48);
Y.extend(ShapeGroup, Y.Path, {    
    /**
     * Updates the shape.
     *
     * @method _draw
     * @private
     */
    _draw: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_draw", 55);
_yuitest_coverline("build/charts-base/charts-base.js", 57);
var xvalues = this.get("xvalues"),
            yvalues = this.get("yvalues"),
            x,
            y,
            xRad,
            yRad,
            i = 0,
            len,
            attrs = [],
            dimensions = this.get("dimensions"),
            width = dimensions.width,
            height = dimensions.height,
            radius = dimensions.radius,
            yRadius = dimensions.yRadius,
            id = this.get("id"),
            className = this.node.className,
            widthIsArray = Y_Lang.isArray(width),
            heightIsArray = Y_Lang.isArray(height),
            radiusIsArray = Y_Lang.isArray(radius),
            yRadiusIsArray = Y_Lang.isArray(yRadius);
        _yuitest_coverline("build/charts-base/charts-base.js", 77);
if(xvalues && yvalues && xvalues.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 79);
this.clear();

            _yuitest_coverline("build/charts-base/charts-base.js", 81);
len = xvalues.length;
            _yuitest_coverline("build/charts-base/charts-base.js", 82);
for(; i < len; ++i)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 84);
x = xvalues[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 85);
y = yvalues[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 86);
xRad = radiusIsArray ? radius[i] : radius;
                _yuitest_coverline("build/charts-base/charts-base.js", 87);
yRad = yRadiusIsArray ? yRadius[i] : yRadius;
                _yuitest_coverline("build/charts-base/charts-base.js", 88);
if(!isNaN(x) && !isNaN(y) && !isNaN(xRad))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 90);
this.drawShape({
                        x: x,
                        y: y,
                        width: widthIsArray ? width[i] : width,
                        height: heightIsArray ? height[i] : height,
                        radius: xRad,
                        yRadius: yRad 
                    });
                    _yuitest_coverline("build/charts-base/charts-base.js", 98);
this.closePath();
                    _yuitest_coverline("build/charts-base/charts-base.js", 99);
attrs[i] = {
                        id: id + "_" + i,
                        className: className,
                        coords: (x - this._left) + ", " + (y - this._top)  + ", " + radius,
                        shape: "circle"
                    };
                }
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 107);
this._closePath();
        }
    },

    /**
     * Parses and array of lengths into radii
     *
     * @method _getRadiusCollection
     * @param {Array} val Array of lengths
     * @return Array
     * @private
     */
    _getRadiusCollection: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getRadiusCollection", 119);
_yuitest_coverline("build/charts-base/charts-base.js", 121);
var i = 0,
            len = val.length,
            radii = [];
        _yuitest_coverline("build/charts-base/charts-base.js", 124);
for(; i < len; ++i)
        {   
            _yuitest_coverline("build/charts-base/charts-base.js", 126);
radii[i] = val[i] * 0.5;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 128);
return radii;
    }
 });
    
_yuitest_coverline("build/charts-base/charts-base.js", 132);
ShapeGroup.ATTRS = Y.merge(Y.Path.ATTRS, {
    dimensions: {
        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 134);
_yuitest_coverline("build/charts-base/charts-base.js", 136);
var dimensions = this._dimensions,
                radius,
                yRadius,
                width,
                height;
            _yuitest_coverline("build/charts-base/charts-base.js", 141);
if(dimensions.hasOwnProperty("radius"))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 143);
return dimensions;
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 147);
width = dimensions.width;
                _yuitest_coverline("build/charts-base/charts-base.js", 148);
height = dimensions.height;
                _yuitest_coverline("build/charts-base/charts-base.js", 149);
radius = Y_Lang.isArray(width) ? this._getRadiusCollection(width) : (width * 0.5);
                _yuitest_coverline("build/charts-base/charts-base.js", 150);
yRadius = Y_Lang.isArray(height) ? this._getRadiusCollection(height) : (height * 0.5);
                _yuitest_coverline("build/charts-base/charts-base.js", 151);
return {
                    width: width,
                    height: height,
                    radius: radius,
                    yRadius: yRadius
                };
            }
        },

        setter: function(val)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 160);
_yuitest_coverline("build/charts-base/charts-base.js", 162);
this._dimensions = val;
            _yuitest_coverline("build/charts-base/charts-base.js", 163);
return val;
        }
    },
    xvalues: {
        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 167);
_yuitest_coverline("build/charts-base/charts-base.js", 169);
return this._xvalues;
        },
        setter: function(val)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 171);
_yuitest_coverline("build/charts-base/charts-base.js", 173);
this._xvalues = val;
        }
    },
    yvalues: {
        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 177);
_yuitest_coverline("build/charts-base/charts-base.js", 179);
return this._yvalues;
        },
        setter: function(val)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 181);
_yuitest_coverline("build/charts-base/charts-base.js", 183);
this._yvalues = val;
        }
    }
});
_yuitest_coverline("build/charts-base/charts-base.js", 187);
Y.ShapeGroup = ShapeGroup;
/**
 * Abstract class for creating groups of circles with the same styles and dimensions.
 *
 * @module charts
 * @submodule charts-base
 * @class CircleGroup
 * @constructor
 */
 _yuitest_coverline("build/charts-base/charts-base.js", 196);
CircleGroup = function(cfg)
 {
    _yuitest_coverfunc("build/charts-base/charts-base.js", "CircleGroup", 196);
_yuitest_coverline("build/charts-base/charts-base.js", 198);
CircleGroup.superclass.constructor.apply(this, arguments);
 };
    
 _yuitest_coverline("build/charts-base/charts-base.js", 201);
CircleGroup.NAME = "circleGroup";

 _yuitest_coverline("build/charts-base/charts-base.js", 203);
Y.extend(CircleGroup, Y.ShapeGroup, {    
    /**
     * Algorithm for drawing shape.
     *
     * @method drawShape
     * @param {Object} cfg Parameters used to draw the shape.
     */
    drawShape: function(cfg)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawShape", 210);
_yuitest_coverline("build/charts-base/charts-base.js", 212);
this.drawCircle(cfg.x, cfg.y, cfg.radius);
    }
 });

_yuitest_coverline("build/charts-base/charts-base.js", 216);
CircleGroup.ATTRS = Y.merge(Y.ShapeGroup.ATTRS, {
    dimensions: {
        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 218);
_yuitest_coverline("build/charts-base/charts-base.js", 220);
var dimensions = this._dimensions,
                radius,
                yRadius,
                width,
                height;
            _yuitest_coverline("build/charts-base/charts-base.js", 225);
if(dimensions.hasOwnProperty("radius"))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 227);
return dimensions;
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 231);
width = dimensions.width;
                _yuitest_coverline("build/charts-base/charts-base.js", 232);
height = dimensions.height;
                _yuitest_coverline("build/charts-base/charts-base.js", 233);
radius = Y_Lang.isArray(width) ? this._getRadiusCollection(width) : (width * 0.5);
                _yuitest_coverline("build/charts-base/charts-base.js", 234);
yRadius = radius;
                _yuitest_coverline("build/charts-base/charts-base.js", 235);
return {
                    width: width,
                    height: height,
                    radius: radius,
                    yRadius: yRadius
                };
            }
        }
    }
});
    
_yuitest_coverline("build/charts-base/charts-base.js", 246);
CircleGroup.ATTRS = Y.ShapeGroup.ATTRS;
_yuitest_coverline("build/charts-base/charts-base.js", 247);
Y.CircleGroup = CircleGroup;
/**
 * Abstract class for creating groups of rects with the same styles and dimensions.
 *
 * @module charts
 * @submodule charts-base
 * @class GroupRect
 * @constructor
 */
 _yuitest_coverline("build/charts-base/charts-base.js", 256);
RectGroup = function(cfg)
 {
    _yuitest_coverfunc("build/charts-base/charts-base.js", "RectGroup", 256);
_yuitest_coverline("build/charts-base/charts-base.js", 258);
RectGroup.superclass.constructor.apply(this, arguments);
 };
    
 _yuitest_coverline("build/charts-base/charts-base.js", 261);
RectGroup.NAME = "rectGroup";

 _yuitest_coverline("build/charts-base/charts-base.js", 263);
Y.extend(RectGroup, Y.ShapeGroup, {    
    /**
     * Updates the rect.
     *
     * @method _draw
     * @private
     */
    drawShape: function(cfg)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawShape", 270);
_yuitest_coverline("build/charts-base/charts-base.js", 272);
this.drawRect(cfg.x, cfg.y, cfg.width, cfg.height);
    }
 });
    
_yuitest_coverline("build/charts-base/charts-base.js", 276);
RectGroup.ATTRS = Y.ShapeGroup.ATTRS;
_yuitest_coverline("build/charts-base/charts-base.js", 277);
Y.RectGroup = RectGroup;
/**
 * Abstract class for creating groups of diamonds with the same styles and dimensions.
 *
 * @module charts
 * @submodule charts-base
 * @class GroupDiamond
 * @constructor
 */
 _yuitest_coverline("build/charts-base/charts-base.js", 286);
DiamondGroup = function(cfg)
 {
    _yuitest_coverfunc("build/charts-base/charts-base.js", "DiamondGroup", 286);
_yuitest_coverline("build/charts-base/charts-base.js", 288);
DiamondGroup.superclass.constructor.apply(this, arguments);
 };
    
 _yuitest_coverline("build/charts-base/charts-base.js", 291);
DiamondGroup.NAME = "diamondGroup";

 _yuitest_coverline("build/charts-base/charts-base.js", 293);
Y.extend(DiamondGroup, Y.ShapeGroup, {    
    /**
     * Updates the diamond.
     *
     * @method _draw
     * @private
     */
    drawShape: function(cfg)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawShape", 300);
_yuitest_coverline("build/charts-base/charts-base.js", 302);
this.drawDiamond(cfg.x, cfg.y, cfg.width, cfg.height);
    }
 });
    
_yuitest_coverline("build/charts-base/charts-base.js", 306);
DiamondGroup.ATTRS = Y.ShapeGroup.ATTRS;
_yuitest_coverline("build/charts-base/charts-base.js", 307);
Y.DiamondGroup = DiamondGroup;
/**
 * Abstract class for creating groups of diamonds with the same styles and dimensions.
 *
 * @module charts
 * @submodule charts-base
 * @class EllipseGroup
 * @constructor
 */
 _yuitest_coverline("build/charts-base/charts-base.js", 316);
EllipseGroup = function(cfg)
 {
    _yuitest_coverfunc("build/charts-base/charts-base.js", "EllipseGroup", 316);
_yuitest_coverline("build/charts-base/charts-base.js", 318);
EllipseGroup.superclass.constructor.apply(this, arguments);
 };
    
 _yuitest_coverline("build/charts-base/charts-base.js", 321);
EllipseGroup.NAME = "diamondGroup";

 _yuitest_coverline("build/charts-base/charts-base.js", 323);
Y.extend(EllipseGroup, Y.ShapeGroup, {    
    /**
     * Updates the diamond.
     *
     * @method _draw
     * @private
     */
    drawShape: function(cfg)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawShape", 330);
_yuitest_coverline("build/charts-base/charts-base.js", 332);
this.drawEllipse(cfg.x, cfg.y, cfg.width, cfg.height);
    }
 });
    
_yuitest_coverline("build/charts-base/charts-base.js", 336);
EllipseGroup.ATTRS = Y.ShapeGroup.ATTRS;
_yuitest_coverline("build/charts-base/charts-base.js", 337);
Y.EllipseGroup = EllipseGroup;
/**
 * The Renderer class is a base class for chart components that use the `styles`
 * attribute.
 *
 * @module charts
 * @submodule charts-base
 * @class Renderer
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 347);
function Renderer(){}

_yuitest_coverline("build/charts-base/charts-base.js", 349);
Renderer.ATTRS = {
        /**
         * Style properties for class
         * 
         * @attribute styles
         * @type Object
         */
        styles:
        {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 358);
_yuitest_coverline("build/charts-base/charts-base.js", 360);
this._styles = this._styles || this._getDefaultStyles();
                _yuitest_coverline("build/charts-base/charts-base.js", 361);
return this._styles;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 364);
_yuitest_coverline("build/charts-base/charts-base.js", 366);
this._styles = this._setStyles(val);
            }
        },
        
        /**
         * The graphic in which drawings will be rendered.
         *
         * @attribute graphic
         * @type Graphic
         */
        graphic: {}
};
_yuitest_coverline("build/charts-base/charts-base.js", 378);
Renderer.NAME = "renderer";

_yuitest_coverline("build/charts-base/charts-base.js", 380);
Renderer.prototype = {
    /**
     * Storage for `styles` attribute.
     *
     * @property _styles
     * @type Object
     * @private
     */
	_styles: null,
	
    /**
     * Method used by `styles` setter.
     *
     * @method _setStyles
     * @param {Object} newStyles Hash of properties to update.
     * @return Object
     * @protected
     */
	_setStyles: function(newstyles)
	{
		_yuitest_coverfunc("build/charts-base/charts-base.js", "_setStyles", 398);
_yuitest_coverline("build/charts-base/charts-base.js", 400);
var styles = this.get("styles");
        _yuitest_coverline("build/charts-base/charts-base.js", 401);
return this._mergeStyles(newstyles, styles);
	},
    
    /**
     * Merges to object literals so that only specified properties are 
     * overwritten.
     *
     * @method _mergeStyles
     * @param {Object} a Hash of new styles
     * @param {Object} b Hash of original styles
     * @return Object
     * @protected
     */
    _mergeStyles: function(a, b)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_mergeStyles", 414);
_yuitest_coverline("build/charts-base/charts-base.js", 416);
if(!b)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 418);
b = {};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 420);
var newstyles = Y.merge(b, {});
        _yuitest_coverline("build/charts-base/charts-base.js", 421);
Y.Object.each(a, function(value, key, a)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "(anonymous 2)", 421);
_yuitest_coverline("build/charts-base/charts-base.js", 423);
if(b.hasOwnProperty(key) && Y_Lang.isObject(value) && !Y_Lang.isFunction(value) && !Y_Lang.isArray(value))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 425);
newstyles[key] = this._mergeStyles(value, b[key]);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 429);
newstyles[key] = value;
            }
        }, this);
        _yuitest_coverline("build/charts-base/charts-base.js", 432);
return newstyles;
    },

    /**
     * Gets the default value for the `styles` attribute. 
     *
     * @method _getDefaultStyles
     * @return Object
     * @protected
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 442);
_yuitest_coverline("build/charts-base/charts-base.js", 444);
return {padding:{
            top:0,
            right: 0,
            bottom: 0,
            left: 0
        }};
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 453);
Y.augment(Renderer, Y.Attribute);
_yuitest_coverline("build/charts-base/charts-base.js", 454);
Y.Renderer = Renderer;

/**
 * Algorithmic strategy for rendering a left axis.
 *
 * @module charts
 * @submodule charts-base
 * @class LeftAxisLayout
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 464);
LeftAxisLayout = function() {};

_yuitest_coverline("build/charts-base/charts-base.js", 466);
LeftAxisLayout.prototype = {
    /**
     *  Default margins for text fields.
     *
     *  @private
     *  @method _getDefaultMargins
     *  @return Object
     */
    _getDefaultMargins: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultMargins", 474);
_yuitest_coverline("build/charts-base/charts-base.js", 476);
return {
            top: 0,
            left: 0,
            right: 4,
            bottom: 0
        };
    },

    /**
     * Sets the length of the tick on either side of the axis line.
     *
     * @method setTickOffset
     * @protected
     */
    setTickOffsets: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setTickOffsets", 490);
_yuitest_coverline("build/charts-base/charts-base.js", 492);
var host = this,
            majorTicks = host.get("styles").majorTicks,
            tickLength = majorTicks.length,
            halfTick = tickLength * 0.5,
            display = majorTicks.display;
        _yuitest_coverline("build/charts-base/charts-base.js", 497);
host.set("topTickOffset",  0);
        _yuitest_coverline("build/charts-base/charts-base.js", 498);
host.set("bottomTickOffset",  0);
        
        _yuitest_coverline("build/charts-base/charts-base.js", 500);
switch(display)
        {
            case "inside" :
                _yuitest_coverline("build/charts-base/charts-base.js", 503);
host.set("rightTickOffset",  tickLength);
                _yuitest_coverline("build/charts-base/charts-base.js", 504);
host.set("leftTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 505);
break;
            case "outside" : 
                _yuitest_coverline("build/charts-base/charts-base.js", 507);
host.set("rightTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 508);
host.set("leftTickOffset",  tickLength);
            _yuitest_coverline("build/charts-base/charts-base.js", 509);
break;
            case "cross":
                _yuitest_coverline("build/charts-base/charts-base.js", 511);
host.set("rightTickOffset", halfTick); 
                _yuitest_coverline("build/charts-base/charts-base.js", 512);
host.set("leftTickOffset",  halfTick);
            _yuitest_coverline("build/charts-base/charts-base.js", 513);
break;
            default:
                _yuitest_coverline("build/charts-base/charts-base.js", 515);
host.set("rightTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 516);
host.set("leftTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 517);
break;
        }
    },
    
    /**
     * Draws a tick
     *
     * @method drawTick
     * @param {Path} path reference to the path `Path` element in which to draw the tick.
     * @param {Object} pt Point on the axis in which the tick will intersect.
     * @param {Object} tickStyle Hash of properties to apply to the tick.
     * @protected
     */
    drawTick: function(path, pt, tickStyles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawTick", 530);
_yuitest_coverline("build/charts-base/charts-base.js", 532);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            tickLength = tickStyles.length,
            start = {x:padding.left, y:pt.y},
            end = {x:tickLength + padding.left, y:pt.y};
        _yuitest_coverline("build/charts-base/charts-base.js", 538);
host.drawLine(path, start, end);
    },

    /**
     * Calculates the coordinates for the first point on an axis.
     *
     * @method getLineStart
     * @return {Object}
     * @protected
     */
    getLineStart: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLineStart", 548);
_yuitest_coverline("build/charts-base/charts-base.js", 550);
var style = this.get("styles"),
            padding = style.padding,
            majorTicks = style.majorTicks,
            tickLength = majorTicks.length,
            display = majorTicks.display,
            pt = {x:padding.left, y:0};
        _yuitest_coverline("build/charts-base/charts-base.js", 556);
if(display === "outside")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 558);
pt.x += tickLength;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 560);
if(display === "cross")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 562);
pt.x += tickLength/2;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 564);
return pt; 
    },
    
    /**
     * Calculates the point for a label.
     *
     * @method getLabelPoint
     * @param {Object} point Point on the axis in which the tick will intersect.
     * @return {Object} 
     * @protected
     */
    getLabelPoint: function(point)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelPoint", 575);
_yuitest_coverline("build/charts-base/charts-base.js", 577);
return {x:point.x - this.get("leftTickOffset"), y:point.y};
    },
    
    /**
     * Updates the value for the `maxLabelSize` for use in calculating total size.
     *
     * @method updateMaxLabelSize
     * @param {HTMLElement} label to measure
     * @protected
     */
    updateMaxLabelSize: function(labelWidth, labelHeight)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMaxLabelSize", 587);
_yuitest_coverline("build/charts-base/charts-base.js", 589);
var host = this,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            sinRadians = props.sinRadians,
            cosRadians = props.cosRadians,
            max;
        _yuitest_coverline("build/charts-base/charts-base.js", 596);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 598);
max = labelWidth;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 600);
if(absRot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 602);
max = labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 606);
max = (cosRadians * labelWidth) + (sinRadians * labelHeight);
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 608);
host._maxLabelSize = Math.max(host._maxLabelSize, max);
    },
    
    /**
     * Determines the available label width when the axis width has been explicitly set.
     *
     * @method getExplicitlySized
     * @return Boolean
     * @protected
     */
    getExplicitlySized: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getExplicitlySized", 618);
_yuitest_coverline("build/charts-base/charts-base.js", 620);
if(this._explicitWidth)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 622);
var host = this,
                w = host._explicitWidth,
                totalTitleSize = host._totalTitleSize,
                leftTickOffset = host.get("leftTickOffset"),
                margin = styles.label.margin.right;
            _yuitest_coverline("build/charts-base/charts-base.js", 627);
host._maxLabelSize =  w - (leftTickOffset + margin + totalTitleSize);
            _yuitest_coverline("build/charts-base/charts-base.js", 628);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 630);
return false;
    },

    /**
     * Rotate and position title.
     *
     * @method positionTitle
     * @param {HTMLElement} label to rotate position
     * @protected
     */
    positionTitle: function(label)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionTitle", 640);
_yuitest_coverline("build/charts-base/charts-base.js", 642);
var host = this,
            bounds = host._titleBounds,
            margin = host.get("styles").title.margin,
            props = host._titleRotationProps,
            w = bounds.right - bounds.left,
            labelWidth = label.offsetWidth,
            labelHeight = label.offsetHeight,
            x = (labelWidth * -0.5) + (w * 0.5),
            y = (host.get("height") * 0.5) - (labelHeight * 0.5);
        _yuitest_coverline("build/charts-base/charts-base.js", 651);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 652);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 653);
if(margin && margin.left)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 655);
x += margin.left;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 657);
props.x = x;
        _yuitest_coverline("build/charts-base/charts-base.js", 658);
props.y = y;
        _yuitest_coverline("build/charts-base/charts-base.js", 659);
props.transformOrigin = [0.5, 0.5];
        _yuitest_coverline("build/charts-base/charts-base.js", 660);
host._rotate(label, props);
    },

    /**
     * Rotate and position labels.
     *
     * @method positionLabel
     * @param {HTMLElement} label to rotate position
     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned
     * against.
     * @protected
     */
    positionLabel: function(label, pt, styles, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionLabel", 672);
_yuitest_coverline("build/charts-base/charts-base.js", 674);
var host = this,
            tickOffset = host.get("leftTickOffset"),
            totalTitleSize = this._totalTitleSize,
            leftOffset = pt.x + totalTitleSize - tickOffset,
            topOffset = pt.y,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            maxLabelSize = host._maxLabelSize,
            labelWidth = this._labelWidths[i],
            labelHeight = this._labelHeights[i];
        _yuitest_coverline("build/charts-base/charts-base.js", 685);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 687);
leftOffset -= labelWidth;
            _yuitest_coverline("build/charts-base/charts-base.js", 688);
topOffset -= labelHeight * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 690);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 692);
leftOffset -= labelWidth * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 694);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 696);
leftOffset -= labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 697);
topOffset -= labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 701);
leftOffset -= labelWidth + (labelHeight * absRot/360);
            _yuitest_coverline("build/charts-base/charts-base.js", 702);
topOffset -= labelHeight * 0.5;
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 704);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 705);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 706);
props.x = Math.round(maxLabelSize + leftOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 707);
props.y = Math.round(topOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 708);
this._rotate(label, props);
    },

    /**
     * Adjusts the coordinates of an axis label based on the rotation.
     *
     * @method _setRotationCoords
     * @param {Object} props Coordinates, dimension and rotation properties of the label.
     * @protected
     */
    _setRotationCoords: function(props)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setRotationCoords", 718);
_yuitest_coverline("build/charts-base/charts-base.js", 720);
var rot = props.rot,
            absRot = props.absRot,
            leftOffset,
            topOffset,
            labelWidth = props.labelWidth,
            labelHeight = props.labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 726);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 728);
leftOffset = labelWidth;
            _yuitest_coverline("build/charts-base/charts-base.js", 729);
topOffset = labelHeight * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 731);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 733);
topOffset = 0;
            _yuitest_coverline("build/charts-base/charts-base.js", 734);
leftOffset = labelWidth * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 736);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 738);
leftOffset = labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 739);
topOffset = labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 743);
leftOffset = labelWidth + (labelHeight * absRot/360);
            _yuitest_coverline("build/charts-base/charts-base.js", 744);
topOffset = labelHeight * 0.5;
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 746);
props.x -= leftOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 747);
props.y -= topOffset;
    },

    /**
     * Returns the transformOrigin to use for an axis label based on the position of the axis 
     * and the rotation of the label.
     *
     * @method _getTransformOrigin
     * @param {Number} rot The rotation (in degrees) of the label.
     * @return Array
     * @protected
     */
    _getTransformOrigin: function(rot)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getTransformOrigin", 759);
_yuitest_coverline("build/charts-base/charts-base.js", 761);
var transformOrigin;
        _yuitest_coverline("build/charts-base/charts-base.js", 762);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 764);
transformOrigin = [0, 0];
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 766);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 768);
transformOrigin = [0.5, 0];
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 770);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 772);
transformOrigin = [0.5, 1];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 776);
transformOrigin = [1, 0.5];
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 778);
return transformOrigin;
    },

    /**
     * Adjust the position of the Axis widget's content box for internal axes.
     *
     * @method offsetNodeForTick
     * @param {Node} cb Content box of the Axis.
     * @protected
     */
    offsetNodeForTick: function(cb)
    {
    },

    /**
     * Sets the width of the axis based on its contents.
     *
     * @method setCalculatedSize
     * @protected
     */
    setCalculatedSize: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setCalculatedSize", 798);
_yuitest_coverline("build/charts-base/charts-base.js", 800);
var host = this,
            graphic = this.get("graphic"),
            style = host.get("styles"),
            label = style.label,
            tickOffset = host.get("leftTickOffset"),
            max = host._maxLabelSize,
            totalTitleSize = this._totalTitleSize,
            ttl = Math.round(totalTitleSize + tickOffset + max + label.margin.right);
        _yuitest_coverline("build/charts-base/charts-base.js", 808);
if(this._explicitWidth)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 810);
ttl = this._explicitWidth;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 812);
this.set("calculatedWidth", ttl);
        _yuitest_coverline("build/charts-base/charts-base.js", 813);
graphic.set("x", ttl - tickOffset);
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 817);
Y.LeftAxisLayout = LeftAxisLayout;
/**
 * RightAxisLayout contains algorithms for rendering a right axis.
 *
 * @module charts
 * @submodule charts-base
 * @class RightAxisLayout
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 826);
RightAxisLayout = function(){};

_yuitest_coverline("build/charts-base/charts-base.js", 828);
RightAxisLayout.prototype = {
    /**
     *  Default margins for text fields.
     *
     *  @private
     *  @method _getDefaultMargins
     *  @return Object
     */
    _getDefaultMargins: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultMargins", 836);
_yuitest_coverline("build/charts-base/charts-base.js", 838);
return {
            top: 0,
            left: 4,
            right: 0,
            bottom: 0
        };
    },

    /**
     * Sets the length of the tick on either side of the axis line.
     *
     * @method setTickOffset
     * @protected
     */
    setTickOffsets: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setTickOffsets", 852);
_yuitest_coverline("build/charts-base/charts-base.js", 854);
var host = this,
            majorTicks = host.get("styles").majorTicks,
            tickLength = majorTicks.length,
            halfTick = tickLength * 0.5,
            display = majorTicks.display;
        _yuitest_coverline("build/charts-base/charts-base.js", 859);
host.set("topTickOffset",  0);
        _yuitest_coverline("build/charts-base/charts-base.js", 860);
host.set("bottomTickOffset",  0);
        
        _yuitest_coverline("build/charts-base/charts-base.js", 862);
switch(display)
        {
            case "inside" :
                _yuitest_coverline("build/charts-base/charts-base.js", 865);
host.set("leftTickOffset", tickLength);
                _yuitest_coverline("build/charts-base/charts-base.js", 866);
host.set("rightTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 867);
break;
            case "outside" : 
                _yuitest_coverline("build/charts-base/charts-base.js", 869);
host.set("leftTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 870);
host.set("rightTickOffset", tickLength);
            _yuitest_coverline("build/charts-base/charts-base.js", 871);
break;
            case "cross" :
                _yuitest_coverline("build/charts-base/charts-base.js", 873);
host.set("rightTickOffset", halfTick);
                _yuitest_coverline("build/charts-base/charts-base.js", 874);
host.set("leftTickOffset", halfTick);
            _yuitest_coverline("build/charts-base/charts-base.js", 875);
break;
            default:
                _yuitest_coverline("build/charts-base/charts-base.js", 877);
host.set("leftTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 878);
host.set("rightTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 879);
break;
        }
    },

    /**
     * Draws a tick
     *
     * @method drawTick
     * @param {Path} path reference to the path `Path` element in which to draw the tick.
     * @param {Object} pt Point on the axis in which the tick will intersect.
     * @param {Object) tickStyle Hash of properties to apply to the tick.
     * @protected
     */
    drawTick: function(path, pt, tickStyles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawTick", 892);
_yuitest_coverline("build/charts-base/charts-base.js", 894);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            tickLength = tickStyles.length,
            start = {x:padding.left, y:pt.y},
            end = {x:padding.left + tickLength, y:pt.y};
        _yuitest_coverline("build/charts-base/charts-base.js", 900);
host.drawLine(path, start, end);
    },
    
    /**
     * Calculates the coordinates for the first point on an axis.
     *
     * @method getLineStart
     * @return {Object}
     * @protected
     */
    getLineStart: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLineStart", 910);
_yuitest_coverline("build/charts-base/charts-base.js", 912);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            majorTicks = style.majorTicks,
            tickLength = majorTicks.length,
            display = majorTicks.display,
            pt = {x:padding.left, y:padding.top};
        _yuitest_coverline("build/charts-base/charts-base.js", 919);
if(display === "inside")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 921);
pt.x += tickLength;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 923);
if(display === "cross")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 925);
pt.x += tickLength/2;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 927);
return pt;
    },
    
    /**
     * Calculates the point for a label.
     *
     * @method getLabelPoint
     * @param {Object} point Point on the axis in which the tick will intersect.
     * @return {Object} 
     * @protected
     */
    getLabelPoint: function(point)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelPoint", 938);
_yuitest_coverline("build/charts-base/charts-base.js", 940);
return {x:point.x + this.get("rightTickOffset"), y:point.y};
    },
    
    /**
     * Updates the value for the `maxLabelSize` for use in calculating total size.
     *
     * @method updateMaxLabelSize
     * @param {HTMLElement} label to measure
     * @protected
     */
    updateMaxLabelSize: function(labelWidth, labelHeight)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMaxLabelSize", 950);
_yuitest_coverline("build/charts-base/charts-base.js", 952);
var host = this,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            sinRadians = props.sinRadians,
            cosRadians = props.cosRadians,
            max;
        _yuitest_coverline("build/charts-base/charts-base.js", 959);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 961);
max = labelWidth;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 963);
if(absRot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 965);
max = labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 969);
max = (cosRadians * labelWidth) + (sinRadians * labelHeight);
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 971);
host._maxLabelSize = Math.max(host._maxLabelSize, max);
    },
    
    /**
     * Determines the available label width when the axis width has been explicitly set.
     *
     * @method getExplicitlySized
     * @return Boolean
     * @protected
     */
    getExplicitlySized: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getExplicitlySized", 981);
_yuitest_coverline("build/charts-base/charts-base.js", 983);
if(this._explicitWidth)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 985);
var host = this,
                w = host._explicitWidth,
                totalTitleSize = this._totalTitleSize,
                rightTickOffset = host.get("rightTickOffset"),
                margin = styles.label.margin.right;
            _yuitest_coverline("build/charts-base/charts-base.js", 990);
host._maxLabelSize =  w - (rightTickOffset + margin + totalTitleSize);
            _yuitest_coverline("build/charts-base/charts-base.js", 991);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 993);
return false;
    },

    /**
     * Rotate and position title.
     *
     * @method positionTitle
     * @param {HTMLElement} label to rotate position
     * @protected
     */
    positionTitle: function(label)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionTitle", 1003);
_yuitest_coverline("build/charts-base/charts-base.js", 1005);
var host = this,
            bounds = host._titleBounds,
            margin = host.get("styles").title.margin,
            props = host._titleRotationProps,
            labelWidth = label.offsetWidth,
            labelHeight = label.offsetHeight,
            w = bounds.right - bounds.left,
            x = this.get("width") - (labelWidth * 0.5) - (w * 0.5),
            y = (host.get("height") * 0.5) - (labelHeight * 0.5);
        _yuitest_coverline("build/charts-base/charts-base.js", 1014);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1015);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1016);
if(margin && margin.right)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1018);
x -= margin.left;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1020);
props.x = x;
        _yuitest_coverline("build/charts-base/charts-base.js", 1021);
props.y = y;
        _yuitest_coverline("build/charts-base/charts-base.js", 1022);
props.transformOrigin = [0.5, 0.5];
        _yuitest_coverline("build/charts-base/charts-base.js", 1023);
host._rotate(label, props);
    },

    /**
     * Rotate and position labels.
     *
     * @method positionLabel
     * @param {HTMLElement} label to rotate position
     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned
     * against.
     * @protected
     */
    positionLabel: function(label, pt, styles, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionLabel", 1035);
_yuitest_coverline("build/charts-base/charts-base.js", 1037);
var host = this,
            tickOffset = host.get("rightTickOffset"),
            labelStyles = styles.label,
            margin = 0,
            leftOffset = pt.x,
            topOffset = pt.y,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            labelWidth = this._labelWidths[i],
            labelHeight = this._labelHeights[i];
        _yuitest_coverline("build/charts-base/charts-base.js", 1048);
if(labelStyles.margin && labelStyles.margin.left)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1050);
margin = labelStyles.margin.left;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1052);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1054);
topOffset -= labelHeight * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1056);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1058);
leftOffset -= labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1059);
topOffset -= labelHeight;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1061);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1063);
leftOffset -= labelWidth * 0.5;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1067);
topOffset -= labelHeight * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1068);
leftOffset += labelHeight/2 * absRot/90;
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 1070);
leftOffset += margin;
        _yuitest_coverline("build/charts-base/charts-base.js", 1071);
leftOffset += tickOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1072);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1073);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1074);
props.x = Math.round(leftOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 1075);
props.y = Math.round(topOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 1076);
this._rotate(label, props);
    },
 
    /**
     * Adjusts the coordinates of an axis label based on the rotation.
     *
     * @method _setRotationCoords
     * @param {Object} props Coordinates, dimension and rotation properties of the label.
     * @protected
     */
    _setRotationCoords: function(props)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setRotationCoords", 1086);
_yuitest_coverline("build/charts-base/charts-base.js", 1088);
var rot = props.rot,
            absRot = props.absRot,
            leftOffset = 0,
            topOffset = 0,
            labelWidth = props.labelWidth,
            labelHeight = props.labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1094);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1096);
topOffset = labelHeight * 0.5;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1098);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1100);
leftOffset = labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1101);
topOffset = labelHeight;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1103);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1105);
leftOffset = labelWidth * 0.5;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1109);
topOffset = labelHeight * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1110);
leftOffset = labelHeight/2 * absRot/90;
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 1112);
props.x -= leftOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1113);
props.y -= topOffset;
    },
   
    /**
     * Returns the transformOrigin to use for an axis label based on the position of the axis 
     * and the rotation of the label.
     *
     * @method _getTransformOrigin
     * @param {Number} rot The rotation (in degrees) of the label.
     * @return Array
     * @protected
     */
    _getTransformOrigin: function(rot)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getTransformOrigin", 1125);
_yuitest_coverline("build/charts-base/charts-base.js", 1127);
var transformOrigin;
        _yuitest_coverline("build/charts-base/charts-base.js", 1128);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1130);
transformOrigin = [0, 0];
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1132);
if(rot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1134);
transformOrigin = [0.5, 1];
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1136);
if(rot === -90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1138);
transformOrigin = [0.5, 0];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1142);
transformOrigin = [0, 0.5];
        }}}
        _yuitest_coverline("build/charts-base/charts-base.js", 1144);
return transformOrigin;
    },

    /**
     * Adjusts position for inner ticks.
     *
     * @method offsetNodeForTick
     * @param {Node} cb contentBox of the axis
     * @protected
     */
    offsetNodeForTick: function(cb)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "offsetNodeForTick", 1154);
_yuitest_coverline("build/charts-base/charts-base.js", 1156);
var host = this,
            tickOffset = host.get("leftTickOffset"),
            offset = 0 - tickOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1159);
cb.setStyle("left", offset);
    },

    /**
     * Assigns a height based on the size of the contents.
     *
     * @method setCalculatedSize
     * @protected
     */
    setCalculatedSize: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setCalculatedSize", 1168);
_yuitest_coverline("build/charts-base/charts-base.js", 1170);
var host = this,
            styles = host.get("styles"),
            labelStyle = styles.label,
            totalTitleSize = this._totalTitleSize,
            ttl = Math.round(host.get("rightTickOffset") + host._maxLabelSize + totalTitleSize + labelStyle.margin.left);
        _yuitest_coverline("build/charts-base/charts-base.js", 1175);
if(this._explicitWidth)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1177);
ttl = this._explicitWidth;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1179);
host.set("calculatedWidth", ttl);
        _yuitest_coverline("build/charts-base/charts-base.js", 1180);
host.get("contentBox").setStyle("width", ttl);
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 1184);
Y.RightAxisLayout = RightAxisLayout;
/**
 * Contains algorithms for rendering a bottom axis.
 *
 * @module charts
 * @submodule charts-base
 * @class BottomAxisLayout
 * @Constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 1193);
BottomAxisLayout = function(){};

_yuitest_coverline("build/charts-base/charts-base.js", 1195);
BottomAxisLayout.prototype = {
    /**
     *  Default margins for text fields.
     *
     *  @private
     *  @method _getDefaultMargins
     *  @return Object
     */
    _getDefaultMargins: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultMargins", 1203);
_yuitest_coverline("build/charts-base/charts-base.js", 1205);
return {
            top: 4,
            left: 0,
            right: 0,
            bottom: 0
        };
    },

    /**
     * Sets the length of the tick on either side of the axis line.
     *
     * @method setTickOffsets
     * @protected
     */
    setTickOffsets: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setTickOffsets", 1219);
_yuitest_coverline("build/charts-base/charts-base.js", 1221);
var host = this,
            majorTicks = host.get("styles").majorTicks,
            tickLength = majorTicks.length,
            halfTick = tickLength * 0.5,
            display = majorTicks.display;
        _yuitest_coverline("build/charts-base/charts-base.js", 1226);
host.set("leftTickOffset",  0);
        _yuitest_coverline("build/charts-base/charts-base.js", 1227);
host.set("rightTickOffset",  0);

        _yuitest_coverline("build/charts-base/charts-base.js", 1229);
switch(display)
        {
            case "inside" :
                _yuitest_coverline("build/charts-base/charts-base.js", 1232);
host.set("topTickOffset", tickLength);
                _yuitest_coverline("build/charts-base/charts-base.js", 1233);
host.set("bottomTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 1234);
break;
            case "outside" : 
                _yuitest_coverline("build/charts-base/charts-base.js", 1236);
host.set("topTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 1237);
host.set("bottomTickOffset", tickLength);
            _yuitest_coverline("build/charts-base/charts-base.js", 1238);
break;
            case "cross":
                _yuitest_coverline("build/charts-base/charts-base.js", 1240);
host.set("topTickOffset",  halfTick);
                _yuitest_coverline("build/charts-base/charts-base.js", 1241);
host.set("bottomTickOffset",  halfTick);
            _yuitest_coverline("build/charts-base/charts-base.js", 1242);
break;
            default:
                _yuitest_coverline("build/charts-base/charts-base.js", 1244);
host.set("topTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 1245);
host.set("bottomTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 1246);
break;
        }
    },

    /**
     * Calculates the coordinates for the first point on an axis.
     *
     * @method getLineStart
     * @protected
     */
    getLineStart: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLineStart", 1256);
_yuitest_coverline("build/charts-base/charts-base.js", 1258);
var style = this.get("styles"),
            padding = style.padding,
            majorTicks = style.majorTicks,
            tickLength = majorTicks.length,
            display = majorTicks.display,
            pt = {x:0, y:padding.top};
        _yuitest_coverline("build/charts-base/charts-base.js", 1264);
if(display === "inside")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1266);
pt.y += tickLength;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1268);
if(display === "cross")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1270);
pt.y += tickLength/2;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1272);
return pt; 
    },
    
    /**
     * Draws a tick
     *
     * @method drawTick
     * @param {Path} path reference to the path `Path` element in which to draw the tick.
     * @param {Object} pt hash containing x and y coordinates
     * @param {Object} tickStyles hash of properties used to draw the tick
     * @protected
     */
    drawTick: function(path, pt, tickStyles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawTick", 1284);
_yuitest_coverline("build/charts-base/charts-base.js", 1286);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            tickLength = tickStyles.length,
            start = {x:pt.x, y:padding.top},
            end = {x:pt.x, y:tickLength + padding.top};
        _yuitest_coverline("build/charts-base/charts-base.js", 1292);
host.drawLine(path, start, end);
    },

    /**
     * Calculates the point for a label.
     *
     * @method getLabelPoint
     * @param {Object} pt Object containing x and y coordinates
     * @return Object
     * @protected
     */
    getLabelPoint: function(point)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelPoint", 1303);
_yuitest_coverline("build/charts-base/charts-base.js", 1305);
return {x:point.x, y:point.y + this.get("bottomTickOffset")};
    },
    
    /**
     * Updates the value for the `maxLabelSize` for use in calculating total size.
     *
     * @method updateMaxLabelSize
     * @param {HTMLElement} label to measure
     * @protected
     */
    updateMaxLabelSize: function(labelWidth, labelHeight)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMaxLabelSize", 1315);
_yuitest_coverline("build/charts-base/charts-base.js", 1317);
var host = this,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            sinRadians = props.sinRadians,
            cosRadians = props.cosRadians,
            max;
        _yuitest_coverline("build/charts-base/charts-base.js", 1324);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1326);
max = labelHeight;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1328);
if(absRot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1330);
max = labelWidth;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1334);
max = (sinRadians * labelWidth) + (cosRadians * labelHeight); 
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1336);
host._maxLabelSize = Math.max(host._maxLabelSize, max);
    },
    
    /**
     * Determines the available label height when the axis width has been explicitly set.
     *
     * @method getExplicitlySized
     * @return Boolean
     * @protected
     */
    getExplicitlySized: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getExplicitlySized", 1346);
_yuitest_coverline("build/charts-base/charts-base.js", 1348);
if(this._explicitHeight)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1350);
var host = this,
                h = host._explicitHeight,
                totalTitleSize = host._totalTitleSize,
                bottomTickOffset = host.get("bottomTickOffset"),
                margin = styles.label.margin.right;
            _yuitest_coverline("build/charts-base/charts-base.js", 1355);
host._maxLabelSize =  h - (bottomTickOffset + margin + totalTitleSize);
            _yuitest_coverline("build/charts-base/charts-base.js", 1356);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1358);
return false;
    },

    /**
     * Rotate and position title.
     *
     * @method positionTitle
     * @param {HTMLElement} label to rotate position
     * @protected
     */
    positionTitle: function(label)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionTitle", 1368);
_yuitest_coverline("build/charts-base/charts-base.js", 1370);
var host = this,
            bounds = host._titleBounds,
            margin = host.get("styles").title.margin,
            props = host._titleRotationProps,
            h = bounds.bottom - bounds.top,
            labelWidth = label.offsetWidth,
            labelHeight = label.offsetHeight,
            x = (host.get("width") * 0.5) - (labelWidth * 0.5),
            y = host.get("height") - labelHeight/2 - h/2;
        _yuitest_coverline("build/charts-base/charts-base.js", 1379);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1380);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1381);
if(margin && margin.bottom)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1383);
y -= margin.bottom;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1385);
props.x = x;
        _yuitest_coverline("build/charts-base/charts-base.js", 1386);
props.y = y;
        _yuitest_coverline("build/charts-base/charts-base.js", 1387);
props.transformOrigin = [0.5, 0.5];
        _yuitest_coverline("build/charts-base/charts-base.js", 1388);
host._rotate(label, props);
    },
    
    /**
     * Rotate and position labels.
     *
     * @method positionLabel
     * @param {HTMLElement} label to rotate position
     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned
     * against.
     * @protected
     */
    positionLabel: function(label, pt, styles, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionLabel", 1400);
_yuitest_coverline("build/charts-base/charts-base.js", 1402);
var host = this,
            tickOffset = host.get("bottomTickOffset"),
            labelStyles = styles.label,
            margin = 0,
            props = host._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            leftOffset = Math.round(pt.x),
            topOffset = Math.round(pt.y),
            labelWidth = host._labelWidths[i],
            labelHeight = host._labelHeights[i];
        _yuitest_coverline("build/charts-base/charts-base.js", 1413);
if(labelStyles.margin && labelStyles.margin.top)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1415);
margin = labelStyles.margin.top;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1417);
if(rot > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1419);
topOffset -= labelHeight/2 * rot/90;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1421);
if(rot < 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1423);
leftOffset -= labelWidth;
            _yuitest_coverline("build/charts-base/charts-base.js", 1424);
topOffset -= labelHeight/2 * absRot/90;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1428);
leftOffset -= labelWidth * 0.5;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1430);
topOffset += margin;
        _yuitest_coverline("build/charts-base/charts-base.js", 1431);
topOffset += tickOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1432);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1433);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1434);
props.x = leftOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1435);
props.y = topOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1436);
host._rotate(label, props);
    },
    
    /**
     * Adjusts the coordinates of an axis label based on the rotation.
     *
     * @method _setRotationCoords
     * @param {Object} props Coordinates, dimension and rotation properties of the label.
     * @protected
     */
    _setRotationCoords: function(props)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setRotationCoords", 1446);
_yuitest_coverline("build/charts-base/charts-base.js", 1448);
var rot = props.rot,
            absRot = props.absRot,
            labelWidth = props.labelWidth,
            labelHeight = props.labelHeight,
            leftOffset,
            topOffset;

        _yuitest_coverline("build/charts-base/charts-base.js", 1455);
if(rot > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1457);
leftOffset = 0;
            _yuitest_coverline("build/charts-base/charts-base.js", 1458);
topOffset = labelHeight/2 * rot/90;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1460);
if(rot < 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1462);
leftOffset = labelWidth;
            _yuitest_coverline("build/charts-base/charts-base.js", 1463);
topOffset = labelHeight/2 * absRot/90;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1467);
leftOffset = labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1468);
topOffset = 0;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1470);
props.x -= leftOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1471);
props.y -= topOffset;
    },

    /**
     * Returns the transformOrigin to use for an axis label based on the position of the axis 
     * and the rotation of the label.
     *
     * @method _getTransformOrigin
     * @param {Number} rot The rotation (in degrees) of the label.
     * @return Array
     * @protected
     */
    _getTransformOrigin: function(rot)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getTransformOrigin", 1483);
_yuitest_coverline("build/charts-base/charts-base.js", 1485);
var transformOrigin;
        _yuitest_coverline("build/charts-base/charts-base.js", 1486);
if(rot > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1488);
transformOrigin = [0, 0.5];
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1490);
if(rot < 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1492);
transformOrigin = [1, 0.5];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1496);
transformOrigin = [0, 0];
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1498);
return transformOrigin;
    },

    /**
     * Adjusts position for inner ticks.
     *
     * @method offsetNodeForTick
     * @param {Node} cb contentBox of the axis
     * @protected
     */
    offsetNodeForTick: function(cb)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "offsetNodeForTick", 1508);
_yuitest_coverline("build/charts-base/charts-base.js", 1510);
var host = this;
        _yuitest_coverline("build/charts-base/charts-base.js", 1511);
host.get("contentBox").setStyle("top", 0 - host.get("topTickOffset"));
    },

    /**
     * Assigns a height based on the size of the contents.
     *
     * @method setCalculatedSize
     * @protected
     */
    setCalculatedSize: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setCalculatedSize", 1520);
_yuitest_coverline("build/charts-base/charts-base.js", 1522);
var host = this,
            styles = host.get("styles"),
            labelStyle = styles.label,
            totalTitleSize = host._totalTitleSize,
            ttl = Math.round(host.get("bottomTickOffset") + host._maxLabelSize + labelStyle.margin.top + totalTitleSize);
        _yuitest_coverline("build/charts-base/charts-base.js", 1527);
if(host._explicitHeight)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1529);
ttl = host._explicitHeight;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1531);
host.set("calculatedHeight", ttl);
    }
};
_yuitest_coverline("build/charts-base/charts-base.js", 1534);
Y.BottomAxisLayout = BottomAxisLayout;
/**
 * Contains algorithms for rendering a top axis.
 *
 * @module charts
 * @submodule charts-base
 * @class TopAxisLayout
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 1543);
TopAxisLayout = function(){};

_yuitest_coverline("build/charts-base/charts-base.js", 1545);
TopAxisLayout.prototype = {
    /**
     *  Default margins for text fields.
     *
     *  @private
     *  @method _getDefaultMargins
     *  @return Object
     */
    _getDefaultMargins: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultMargins", 1553);
_yuitest_coverline("build/charts-base/charts-base.js", 1555);
return {
            top: 0,
            left: 0,
            right: 0,
            bottom: 4
        };
    },
    
    /**
     * Sets the length of the tick on either side of the axis line.
     *
     * @method setTickOffsets
     * @protected
     */
    setTickOffsets: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setTickOffsets", 1569);
_yuitest_coverline("build/charts-base/charts-base.js", 1571);
var host = this,
            majorTicks = host.get("styles").majorTicks,
            tickLength = majorTicks.length,
            halfTick = tickLength * 0.5,
            display = majorTicks.display;
        _yuitest_coverline("build/charts-base/charts-base.js", 1576);
host.set("leftTickOffset",  0);
        _yuitest_coverline("build/charts-base/charts-base.js", 1577);
host.set("rightTickOffset",  0);
        _yuitest_coverline("build/charts-base/charts-base.js", 1578);
switch(display)
        {
            case "inside" :
                _yuitest_coverline("build/charts-base/charts-base.js", 1581);
host.set("bottomTickOffset", tickLength);
                _yuitest_coverline("build/charts-base/charts-base.js", 1582);
host.set("topTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 1583);
break;
            case "outside" : 
                _yuitest_coverline("build/charts-base/charts-base.js", 1585);
host.set("bottomTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 1586);
host.set("topTickOffset",  tickLength);
            _yuitest_coverline("build/charts-base/charts-base.js", 1587);
break;
            case "cross" :
                _yuitest_coverline("build/charts-base/charts-base.js", 1589);
host.set("topTickOffset", halfTick);
                _yuitest_coverline("build/charts-base/charts-base.js", 1590);
host.set("bottomTickOffset", halfTick);
            _yuitest_coverline("build/charts-base/charts-base.js", 1591);
break;
            default:
                _yuitest_coverline("build/charts-base/charts-base.js", 1593);
host.set("topTickOffset", 0);
                _yuitest_coverline("build/charts-base/charts-base.js", 1594);
host.set("bottomTickOffset", 0);
            _yuitest_coverline("build/charts-base/charts-base.js", 1595);
break;
        }
    },

    /**
     * Calculates the coordinates for the first point on an axis.
     *
     * @method getLineStart
     * @protected
     */
    getLineStart: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLineStart", 1605);
_yuitest_coverline("build/charts-base/charts-base.js", 1607);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            majorTicks = style.majorTicks,
            tickLength = majorTicks.length,
            display = majorTicks.display,
            pt = {x:0, y:padding.top};
        _yuitest_coverline("build/charts-base/charts-base.js", 1614);
if(display === "outside")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1616);
pt.y += tickLength;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1618);
if(display === "cross")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1620);
pt.y += tickLength/2;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1622);
return pt; 
    },
    
    /**
     * Draws a tick
     *
     * @method drawTick
     * @param {Path} path reference to the path `Path` element in which to draw the tick.
     * @param {Object} pt hash containing x and y coordinates
     * @param {Object} tickStyles hash of properties used to draw the tick
     * @protected
     */
    drawTick: function(path, pt, tickStyles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawTick", 1634);
_yuitest_coverline("build/charts-base/charts-base.js", 1636);
var host = this,
            style = host.get("styles"),
            padding = style.padding,
            tickLength = tickStyles.length,
            start = {x:pt.x, y:padding.top},
            end = {x:pt.x, y:tickLength + padding.top};
        _yuitest_coverline("build/charts-base/charts-base.js", 1642);
host.drawLine(path, start, end);
    },
    
    /**
     * Calculates the point for a label.
     *
     * @method getLabelPoint
     * @param {Object} pt hash containing x and y coordinates
     * @return Object
     * @protected
     */
    getLabelPoint: function(pt)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelPoint", 1653);
_yuitest_coverline("build/charts-base/charts-base.js", 1655);
return {x:pt.x, y:pt.y - this.get("topTickOffset")};
    },
    
    /**
     * Updates the value for the `maxLabelSize` for use in calculating total size.
     *
     * @method updateMaxLabelSize
     * @param {HTMLElement} label to measure
     * @protected
     */
    updateMaxLabelSize: function(labelWidth, labelHeight)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMaxLabelSize", 1665);
_yuitest_coverline("build/charts-base/charts-base.js", 1667);
var host = this,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            sinRadians = props.sinRadians,
            cosRadians = props.cosRadians,
            max;
        _yuitest_coverline("build/charts-base/charts-base.js", 1674);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1676);
max = labelHeight;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 1678);
if(absRot === 90)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1680);
max = labelWidth;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1684);
max = (sinRadians * labelWidth) + (cosRadians * labelHeight); 
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 1686);
host._maxLabelSize = Math.max(host._maxLabelSize, max);
    },

    /**
     * Determines the available label height when the axis width has been explicitly set.
     *
     * @method getExplicitlySized
     * @return Boolean
     * @protected
     */
    getExplicitlySized: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getExplicitlySized", 1696);
_yuitest_coverline("build/charts-base/charts-base.js", 1698);
if(this._explicitHeight)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1700);
var host = this,
                h = host._explicitHeight,
                totalTitleSize = host._totalTitleSize,
                topTickOffset = host.get("topTickOffset"),
                margin = styles.label.margin.right;
            _yuitest_coverline("build/charts-base/charts-base.js", 1705);
host._maxLabelSize =  h - (topTickOffset + margin + totalTitleSize);
            _yuitest_coverline("build/charts-base/charts-base.js", 1706);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1708);
return false;
    },

    /**
     * Rotate and position title.
     *
     * @method positionTitle
     * @param {HTMLElement} label to rotate position
     * @protected
     */
    positionTitle: function(label)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionTitle", 1718);
_yuitest_coverline("build/charts-base/charts-base.js", 1720);
var host = this,
            bounds = host._titleBounds,
            margin = host.get("styles").title.margin,
            props = host._titleRotationProps,
            labelWidth = label.offsetWidth,
            labelHeight = label.offsetHeight,
            h = bounds.bottom - bounds.top,
            x = (host.get("width") * 0.5) - (labelWidth * 0.5),
            y = h/2 - labelHeight/2;
        _yuitest_coverline("build/charts-base/charts-base.js", 1729);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1730);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1731);
if(margin && margin.top)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1733);
y += margin.top;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1735);
props.x = x;
        _yuitest_coverline("build/charts-base/charts-base.js", 1736);
props.y = y;
        _yuitest_coverline("build/charts-base/charts-base.js", 1737);
props.transformOrigin = [0.5, 0.5];
        _yuitest_coverline("build/charts-base/charts-base.js", 1738);
host._rotate(label, props);
    },

    /**
     * Rotate and position labels.
     *
     * @method positionLabel
     * @param {HTMLElement} label to rotate position
     * @param {Object} pt hash containing the x and y coordinates in which the label will be positioned
     * against.
     * @protected
     */
    positionLabel: function(label, pt, styles, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "positionLabel", 1750);
_yuitest_coverline("build/charts-base/charts-base.js", 1752);
var host = this,
            totalTitleSize = this._totalTitleSize,
            maxLabelSize = host._maxLabelSize,
            leftOffset = pt.x,
            topOffset = pt.y + totalTitleSize + maxLabelSize,
            props = this._labelRotationProps,
            rot = props.rot,
            absRot = props.absRot,
            labelWidth = this._labelWidths[i],
            labelHeight = this._labelHeights[i];
        _yuitest_coverline("build/charts-base/charts-base.js", 1762);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1764);
leftOffset -= labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1765);
topOffset -= labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1769);
if(rot === 90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1771);
leftOffset -= labelWidth;
                _yuitest_coverline("build/charts-base/charts-base.js", 1772);
topOffset -= (labelHeight * 0.5);
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1774);
if (rot === -90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1776);
topOffset -= (labelHeight * 0.5);
            }    
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1778);
if(rot > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1780);
leftOffset -= labelWidth;
                _yuitest_coverline("build/charts-base/charts-base.js", 1781);
topOffset -= labelHeight - (labelHeight * rot/180);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1785);
topOffset -= labelHeight - (labelHeight * absRot/180);
            }}}
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1788);
props.x = Math.round(leftOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 1789);
props.y = Math.round(topOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 1790);
props.labelWidth = labelWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 1791);
props.labelHeight = labelHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 1792);
this._rotate(label, props);
    },

    /**
     * Adjusts the coordinates of an axis label based on the rotation.
     *
     * @method _setRotationCoords
     * @param {Object} props Coordinates, dimension and rotation properties of the label.
     * @protected
     */
    _setRotationCoords: function(props)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setRotationCoords", 1802);
_yuitest_coverline("build/charts-base/charts-base.js", 1804);
var rot = props.rot,
            absRot = props.absRot,
            labelWidth = props.labelWidth,
            labelHeight = props.labelHeight,
            leftOffset,
            topOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1810);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1812);
leftOffset = labelWidth * 0.5;
            _yuitest_coverline("build/charts-base/charts-base.js", 1813);
topOffset = labelHeight;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1817);
if(rot === 90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1819);
leftOffset = labelWidth;
                _yuitest_coverline("build/charts-base/charts-base.js", 1820);
topOffset = (labelHeight * 0.5);
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1822);
if (rot === -90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1824);
topOffset = (labelHeight * 0.5);
            }    
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1826);
if(rot > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1828);
leftOffset = labelWidth;
                _yuitest_coverline("build/charts-base/charts-base.js", 1829);
topOffset = labelHeight - (labelHeight * rot/180);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1833);
topOffset = labelHeight - (labelHeight * absRot/180);
            }}}
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1836);
props.x -= leftOffset;
        _yuitest_coverline("build/charts-base/charts-base.js", 1837);
props.y -= topOffset;
    },

    /**
     * Returns the transformOrigin to use for an axis label based on the position of the axis 
     * and the rotation of the label.
     *
     * @method _getTransformOrigin
     * @param {Number} rot The rotation (in degrees) of the label.
     * @return Array
     * @protected
     */
    _getTransformOrigin: function(rot)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getTransformOrigin", 1849);
_yuitest_coverline("build/charts-base/charts-base.js", 1851);
var transformOrigin;
        _yuitest_coverline("build/charts-base/charts-base.js", 1852);
if(rot === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1854);
transformOrigin = [0, 0];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1858);
if(rot === 90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1860);
transformOrigin = [1, 0.5];
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1862);
if (rot === -90)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1864);
transformOrigin = [0, 0.5];
            }    
            else {_yuitest_coverline("build/charts-base/charts-base.js", 1866);
if(rot > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1868);
transformOrigin = [1, 0.5];
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1872);
transformOrigin = [0, 0.5];
            }}}
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1875);
return transformOrigin;
    },

    /**
     * Adjusts position for inner ticks.
     *
     * @method offsetNodeForTick
     * @param {Node} cb contentBox of the axis
     * @protected
     */
    offsetNodeForTick: function(cb)
    {
    },

    /**
     * Assigns a height based on the size of the contents.
     *
     * @method setCalculatedSize
     * @protected
     */
    setCalculatedSize: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setCalculatedSize", 1895);
_yuitest_coverline("build/charts-base/charts-base.js", 1897);
var host = this,
            graphic = host.get("graphic"),
            styles = host.get("styles"),
            labelMargin = styles.label.margin,
            totalLabelSize = labelMargin.bottom + host._maxLabelSize,
            totalTitleSize = host._totalTitleSize,
            topTickOffset = this.get("topTickOffset"),
            ttl = Math.round(topTickOffset + totalLabelSize + totalTitleSize);
        _yuitest_coverline("build/charts-base/charts-base.js", 1905);
if(this._explicitHeight)
        {
           _yuitest_coverline("build/charts-base/charts-base.js", 1907);
ttl = this._explicitWidth; 
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 1909);
host.set("calculatedHeight", ttl);
        _yuitest_coverline("build/charts-base/charts-base.js", 1910);
graphic.set("y", ttl - topTickOffset);
    }
};
_yuitest_coverline("build/charts-base/charts-base.js", 1913);
Y.TopAxisLayout = TopAxisLayout;

/**
 * The Axis class. Generates axes for a chart.
 *
 * @module charts
 * @submodule charts-base
 * @class Axis
 * @extends Widget
 * @uses Renderer
 * @constructor
 * @param {Object} config (optional) Configuration parameters for the Chart.
 */
_yuitest_coverline("build/charts-base/charts-base.js", 1926);
Y.Axis = Y.Base.create("axis", Y.Widget, [Y.Renderer], {
    /**
     * Storage for calculatedWidth value.
     *
     * @property _calculatedWidth
     * @type Number
     * @private
     */
    _calculatedWidth: 0,

    /**
     * Storage for calculatedHeight value.
     *
     * @property _calculatedHeight
     * @type Number
     * @private
     */
    _calculatedHeight: 0,

    /**
     * Handles change to the dataProvider
     * 
     * @method _dataChangeHandler
     * @param {Object} e Event object
     * @private
     */
    _dataChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_dataChangeHandler", 1952);
_yuitest_coverline("build/charts-base/charts-base.js", 1954);
if(this.get("rendered"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1956);
this._drawAxis();
        }
    },

    /**
     * Handles change to the position attribute
     *
     * @method _positionChangeHandler
     * @param {Object} e Event object
     * @private
     */
    _positionChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_positionChangeHandler", 1967);
_yuitest_coverline("build/charts-base/charts-base.js", 1969);
this._updateGraphic(e.newVal);
        _yuitest_coverline("build/charts-base/charts-base.js", 1970);
this._updateHandler();
    },

    /**
     * Updates the the Graphic instance
     *
     * @method _updateGraphic
     * @param {String} position Position of axis 
     * @private
     */
    _updateGraphic: function(position)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateGraphic", 1980);
_yuitest_coverline("build/charts-base/charts-base.js", 1982);
var graphic = this.get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 1983);
if(position == "none")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1985);
if(graphic)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1987);
graphic.destroy();
            }
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 1992);
if(!graphic)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 1994);
this._setCanvas();
            }
        }
    },

    /**
     * Handles changes to axis.
     *
     * @method _updateHandler
     * @param {Object} e Event object
     * @private
     */
    _updateHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateHandler", 2006);
_yuitest_coverline("build/charts-base/charts-base.js", 2008);
if(this.get("rendered"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2010);
this._drawAxis();
        }
    },
   
    /**
     * @method renderUI
     * @private
     */
    renderUI: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "renderUI", 2018);
_yuitest_coverline("build/charts-base/charts-base.js", 2020);
this._updateGraphic(this.get("position"));
    },

    /**
     * @method syncUI
     * @private
     */
    syncUI: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "syncUI", 2027);
_yuitest_coverline("build/charts-base/charts-base.js", 2029);
var layout = this._layout,
            defaultMargins,
            styles,
            label,
            title,
            i;
        _yuitest_coverline("build/charts-base/charts-base.js", 2035);
if(layout)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2037);
defaultMargins = layout._getDefaultMargins();
            _yuitest_coverline("build/charts-base/charts-base.js", 2038);
styles = this.get("styles");
            _yuitest_coverline("build/charts-base/charts-base.js", 2039);
label = styles.label.margin;
            _yuitest_coverline("build/charts-base/charts-base.js", 2040);
title =styles.title.margin;
            //need to defaultMargins method to the layout classes.
            _yuitest_coverline("build/charts-base/charts-base.js", 2042);
for(i in defaultMargins)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2044);
if(defaultMargins.hasOwnProperty(i))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2046);
label[i] = label[i] === undefined ? defaultMargins[i] : label[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 2047);
title[i] = title[i] === undefined ? defaultMargins[i] : title[i];
                }
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2051);
this._drawAxis();
    },

    /**
     * Creates a graphic instance to be used for the axis line and ticks.
     *
     * @method _setCanvas
     * @private
     */
    _setCanvas: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setCanvas", 2060);
_yuitest_coverline("build/charts-base/charts-base.js", 2062);
var cb = this.get("contentBox"),
            bb = this.get("boundingBox"),
            p = this.get("position"),
            pn = this._parentNode,
            w = this.get("width"),
            h = this.get("height");
        _yuitest_coverline("build/charts-base/charts-base.js", 2068);
bb.setStyle("position", "absolute");
        _yuitest_coverline("build/charts-base/charts-base.js", 2069);
bb.setStyle("zIndex", 2);
        _yuitest_coverline("build/charts-base/charts-base.js", 2070);
w = w ? w + "px" : pn.getStyle("width");
        _yuitest_coverline("build/charts-base/charts-base.js", 2071);
h = h ? h + "px" : pn.getStyle("height");
        _yuitest_coverline("build/charts-base/charts-base.js", 2072);
if(p === "top" || p === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2074);
cb.setStyle("width", w);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2078);
cb.setStyle("height", h);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2080);
cb.setStyle("position", "relative");
        _yuitest_coverline("build/charts-base/charts-base.js", 2081);
cb.setStyle("left", "0px");
        _yuitest_coverline("build/charts-base/charts-base.js", 2082);
cb.setStyle("top", "0px");
        _yuitest_coverline("build/charts-base/charts-base.js", 2083);
this.set("graphic", new Y.Graphic());
        _yuitest_coverline("build/charts-base/charts-base.js", 2084);
this.get("graphic").render(cb);
    },
	
    /**
     * Gets the default value for the `styles` attribute. Overrides
     * base implementation.
     *
     * @method _getDefaultStyles
     * @return Object
     * @protected
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 2095);
_yuitest_coverline("build/charts-base/charts-base.js", 2097);
var axisstyles = {
            majorTicks: {
                display:"inside",
                length:4,
                color:"#dad8c9",
                weight:1,
                alpha:1
            },
            minorTicks: {
                display:"none",
                length:2,
                color:"#dad8c9",
                weight:1
            },
            line: {
                weight:1,
                color:"#dad8c9",
                alpha:1
            },
            majorUnit: {
                determinant:"count",
                count:11,
                distance:75
            },
            top: "0px",
            left: "0px",
            width: "100px",
            height: "100px",
            label: {
                color:"#808080",
                alpha: 1,
                fontSize:"85%",
                rotation: 0,
                margin: {
                    top: undefined,
                    right: undefined,
                    bottom: undefined,
                    left: undefined
                }
            },
            title: {
                color:"#808080",
                alpha: 1,
                fontSize:"85%",
                rotation: undefined,
                margin: {
                    top: undefined,
                    right: undefined,
                    bottom: undefined,
                    left: undefined
                }
            },
            hideOverlappingLabelTicks: false
        };
        
        _yuitest_coverline("build/charts-base/charts-base.js", 2152);
return Y.merge(Y.Renderer.prototype._getDefaultStyles(), axisstyles); 
    },

    /**
     * Updates the axis when the size changes.
     *
     * @method _handleSizeChange
     * @param {Object} e Event object.
     * @private
     */
    _handleSizeChange: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_handleSizeChange", 2162);
_yuitest_coverline("build/charts-base/charts-base.js", 2164);
var attrName = e.attrName,
            pos = this.get("position"),
            vert = pos == "left" || pos == "right",
            cb = this.get("contentBox"),
            hor = pos == "bottom" || pos == "top";
        _yuitest_coverline("build/charts-base/charts-base.js", 2169);
cb.setStyle("width", this.get("width"));
        _yuitest_coverline("build/charts-base/charts-base.js", 2170);
cb.setStyle("height", this.get("height"));
        _yuitest_coverline("build/charts-base/charts-base.js", 2171);
if((hor && attrName == "width") || (vert && attrName == "height"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2173);
this._drawAxis();
        }
    },
   
    /**
     * Maps key values to classes containing layout algorithms
     *
     * @property _layoutClasses
     * @type Object
     * @private
     */
    _layoutClasses: 
    {
        top : TopAxisLayout,
        bottom: BottomAxisLayout,
        left: LeftAxisLayout,
        right : RightAxisLayout
    },
    
    /**
     * Draws a line segment between 2 points
     *
     * @method drawLine
     * @param {Object} startPoint x and y coordinates for the start point of the line segment
     * @param {Object} endPoint x and y coordinates for the for the end point of the line segment
     * @param {Object} line styles (weight, color and alpha to be applied to the line segment)
     * @private
     */
    drawLine: function(path, startPoint, endPoint)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawLine", 2201);
_yuitest_coverline("build/charts-base/charts-base.js", 2203);
path.moveTo(startPoint.x, startPoint.y);
        _yuitest_coverline("build/charts-base/charts-base.js", 2204);
path.lineTo(endPoint.x, endPoint.y);
    },

    /**
     * Generates the properties necessary for rotating and positioning a text field.
     *
     * @method _getTextRotationProps
     * @param {Object} styles properties for the text field
     * @return Object
     * @private
     */
    _getTextRotationProps: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getTextRotationProps", 2215);
_yuitest_coverline("build/charts-base/charts-base.js", 2217);
if(styles.rotation === undefined)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2219);
switch(this.get("position"))
            {
                case "left" :
                    _yuitest_coverline("build/charts-base/charts-base.js", 2222);
styles.rotation = -90;
                _yuitest_coverline("build/charts-base/charts-base.js", 2223);
break; 
                case "right" : 
                    _yuitest_coverline("build/charts-base/charts-base.js", 2225);
styles.rotation = 90;
                _yuitest_coverline("build/charts-base/charts-base.js", 2226);
break;
                default :
                    _yuitest_coverline("build/charts-base/charts-base.js", 2228);
styles.rotation = 0;
                _yuitest_coverline("build/charts-base/charts-base.js", 2229);
break;
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2232);
var rot =  Math.min(90, Math.max(-90, styles.rotation)),
            absRot = Math.abs(rot),
            radCon = Math.PI/180,
            sinRadians = parseFloat(parseFloat(Math.sin(absRot * radCon)).toFixed(8)),
            cosRadians = parseFloat(parseFloat(Math.cos(absRot * radCon)).toFixed(8));
        _yuitest_coverline("build/charts-base/charts-base.js", 2237);
return {
            rot: rot,
            absRot: absRot,
            radCon: radCon,
            sinRadians: sinRadians,
            cosRadians: cosRadians,
            textAlpha: styles.alpha
        };
    },

    /**
     * Draws an axis. 
     *
     * @method _drawAxis
     * @private
     */
    _drawAxis: function ()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_drawAxis", 2253);
_yuitest_coverline("build/charts-base/charts-base.js", 2255);
if(this._drawing)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2257);
this._callLater = true;
            _yuitest_coverline("build/charts-base/charts-base.js", 2258);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2260);
this._drawing = true;
        _yuitest_coverline("build/charts-base/charts-base.js", 2261);
this._callLater = false;
        _yuitest_coverline("build/charts-base/charts-base.js", 2262);
if(this._layout)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2264);
var styles = this.get("styles"),
                line = styles.line,
                labelStyles = styles.label,
                majorTickStyles = styles.majorTicks,
                drawTicks = majorTickStyles.display != "none",
                tickPoint,
                majorUnit = styles.majorUnit,
                len,
                majorUnitDistance,
                i = 0,
                layout = this._layout,
                layoutLength,
                position,
                lineStart,
                label,
                labelWidth,
                labelHeight,
                labelFunction = this.get("labelFunction"),
                labelFunctionScope = this.get("labelFunctionScope"),
                labelFormat = this.get("labelFormat"),
                graphic = this.get("graphic"),
                path = this.get("path"),
                tickPath,
                explicitlySized;
            _yuitest_coverline("build/charts-base/charts-base.js", 2288);
this._labelWidths = [];
            _yuitest_coverline("build/charts-base/charts-base.js", 2289);
this._labelHeights = [];
            _yuitest_coverline("build/charts-base/charts-base.js", 2290);
graphic.set("autoDraw", false);
            _yuitest_coverline("build/charts-base/charts-base.js", 2291);
path.clear();
            _yuitest_coverline("build/charts-base/charts-base.js", 2292);
path.set("stroke", {
                weight: line.weight, 
                color: line.color, 
                opacity: line.alpha
            });
            _yuitest_coverline("build/charts-base/charts-base.js", 2297);
this._labelRotationProps = this._getTextRotationProps(labelStyles);
            _yuitest_coverline("build/charts-base/charts-base.js", 2298);
this._labelRotationProps.transformOrigin = layout._getTransformOrigin(this._labelRotationProps.rot);
            _yuitest_coverline("build/charts-base/charts-base.js", 2299);
layout.setTickOffsets.apply(this);
            _yuitest_coverline("build/charts-base/charts-base.js", 2300);
layoutLength = this.getLength();
            _yuitest_coverline("build/charts-base/charts-base.js", 2301);
lineStart = layout.getLineStart.apply(this);
            _yuitest_coverline("build/charts-base/charts-base.js", 2302);
len = this.getTotalMajorUnits(majorUnit);
            _yuitest_coverline("build/charts-base/charts-base.js", 2303);
majorUnitDistance = this.getMajorUnitDistance(len, layoutLength, majorUnit);
            _yuitest_coverline("build/charts-base/charts-base.js", 2304);
this.set("edgeOffset", this.getEdgeOffset(len, layoutLength) * 0.5);
            _yuitest_coverline("build/charts-base/charts-base.js", 2305);
if(len < 1)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2307);
this._clearLabelCache();
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2311);
tickPoint = this.getFirstPoint(lineStart);
                _yuitest_coverline("build/charts-base/charts-base.js", 2312);
this.drawLine(path, lineStart, this.getLineEnd(tickPoint));
                _yuitest_coverline("build/charts-base/charts-base.js", 2313);
if(drawTicks) 
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2315);
tickPath = this.get("tickPath");
                    _yuitest_coverline("build/charts-base/charts-base.js", 2316);
tickPath.clear();
                    _yuitest_coverline("build/charts-base/charts-base.js", 2317);
tickPath.set("stroke", {
                        weight: majorTickStyles.weight,
                        color: majorTickStyles.color,
                        opacity: majorTickStyles.alpha
                    });
                   _yuitest_coverline("build/charts-base/charts-base.js", 2322);
layout.drawTick.apply(this, [tickPath, tickPoint, majorTickStyles]);
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 2324);
this._createLabelCache();
                _yuitest_coverline("build/charts-base/charts-base.js", 2325);
this._tickPoints = [];
                _yuitest_coverline("build/charts-base/charts-base.js", 2326);
this._maxLabelSize = 0; 
                _yuitest_coverline("build/charts-base/charts-base.js", 2327);
this._totalTitleSize = 0;
                _yuitest_coverline("build/charts-base/charts-base.js", 2328);
this._titleSize = 0;
                _yuitest_coverline("build/charts-base/charts-base.js", 2329);
this._setTitle();
                _yuitest_coverline("build/charts-base/charts-base.js", 2330);
explicitlySized = layout.getExplicitlySized.apply(this, [styles]);
                _yuitest_coverline("build/charts-base/charts-base.js", 2331);
for(; i < len; ++i)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2333);
if(drawTicks) 
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 2335);
layout.drawTick.apply(this, [tickPath, tickPoint, majorTickStyles]);
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 2337);
position = this.getPosition(tickPoint);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2338);
label = this.getLabel(tickPoint, labelStyles);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2339);
this._labels.push(label);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2340);
this._tickPoints.push({x:tickPoint.x, y:tickPoint.y});
                    _yuitest_coverline("build/charts-base/charts-base.js", 2341);
this.get("appendLabelFunction")(label, labelFunction.apply(labelFunctionScope, [this.getLabelByIndex(i, len), labelFormat]));
                    _yuitest_coverline("build/charts-base/charts-base.js", 2342);
labelWidth = Math.round(label.offsetWidth);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2343);
labelHeight = Math.round(label.offsetHeight);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2344);
if(!explicitlySized)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 2346);
this._layout.updateMaxLabelSize.apply(this, [labelWidth, labelHeight]);
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 2348);
this._labelWidths.push(labelWidth);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2349);
this._labelHeights.push(labelHeight);
                    _yuitest_coverline("build/charts-base/charts-base.js", 2350);
tickPoint = this.getNextPoint(tickPoint, majorUnitDistance);
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 2352);
this._clearLabelCache();
                _yuitest_coverline("build/charts-base/charts-base.js", 2353);
if(this.get("overlapGraph"))
                {
                   _yuitest_coverline("build/charts-base/charts-base.js", 2355);
layout.offsetNodeForTick.apply(this, [this.get("contentBox")]);
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 2357);
layout.setCalculatedSize.apply(this);
                _yuitest_coverline("build/charts-base/charts-base.js", 2358);
if(this._titleTextField)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2360);
this._layout.positionTitle.apply(this, [this._titleTextField]);
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 2362);
for(i = 0; i < len; ++i)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2364);
layout.positionLabel.apply(this, [this.get("labels")[i], this._tickPoints[i], styles, i]);
                }
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2368);
this._drawing = false;
        _yuitest_coverline("build/charts-base/charts-base.js", 2369);
if(this._callLater)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2371);
this._drawAxis();
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2375);
this._updatePathElement();
            _yuitest_coverline("build/charts-base/charts-base.js", 2376);
this.fire("axisRendered");
        }
    },
    
    /**
     * Calculates and sets the total size of a title.
     *
     * @method _setTotalTitleSize
     * @param {Object} styles Properties for the title field.
     * @private
     */
    _setTotalTitleSize: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setTotalTitleSize", 2387);
_yuitest_coverline("build/charts-base/charts-base.js", 2389);
var title = this._titleTextField,
            w = title.offsetWidth,
            h = title.offsetHeight,
            rot = this._titleRotationProps.rot,
            bounds,
            size,
            margin = styles.margin,
            position = this.get("position"),
            matrix = new Y.Matrix();
        _yuitest_coverline("build/charts-base/charts-base.js", 2398);
matrix.rotate(rot);
        _yuitest_coverline("build/charts-base/charts-base.js", 2399);
bounds = matrix.getContentRect(w, h);
        _yuitest_coverline("build/charts-base/charts-base.js", 2400);
if(position == "left" || position == "right")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2402);
size = bounds.right - bounds.left;
            _yuitest_coverline("build/charts-base/charts-base.js", 2403);
if(margin)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2405);
size += margin.left + margin.right;
            }
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2410);
size = bounds.bottom - bounds.top;
            _yuitest_coverline("build/charts-base/charts-base.js", 2411);
if(margin)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2413);
size += margin.top + margin.bottom;
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2416);
this._titleBounds = bounds;
        _yuitest_coverline("build/charts-base/charts-base.js", 2417);
this._totalTitleSize = size;
    },

    /**
     *  Updates path.
     *
     *  @method _updatePathElement
     *  @private
     */
    _updatePathElement: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updatePathElement", 2426);
_yuitest_coverline("build/charts-base/charts-base.js", 2428);
var path = this._path,
            tickPath = this._tickPath,
            redrawGraphic = false,
            graphic = this.get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 2432);
if(path)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2434);
redrawGraphic = true;
            _yuitest_coverline("build/charts-base/charts-base.js", 2435);
path.end();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2437);
if(tickPath)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2439);
redrawGraphic = true;
            _yuitest_coverline("build/charts-base/charts-base.js", 2440);
tickPath.end();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2442);
if(redrawGraphic)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2444);
graphic._redraw();
        }
    },

    /**
     * Updates the content and style properties for a title field.
     *
     * @method _updateTitle
     * @private
     */
    _setTitle: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setTitle", 2454);
_yuitest_coverline("build/charts-base/charts-base.js", 2456);
var i,
            styles,
            customStyles,
            title = this.get("title"),
            titleTextField = this._titleTextField,
            parentNode;
        _yuitest_coverline("build/charts-base/charts-base.js", 2462);
if(title !== null && title !== undefined)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2464);
customStyles = {
                    rotation: "rotation",
                    margin: "margin",
                    alpha: "alpha"
            };
            _yuitest_coverline("build/charts-base/charts-base.js", 2469);
styles = this.get("styles").title;
            _yuitest_coverline("build/charts-base/charts-base.js", 2470);
if(!titleTextField)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2472);
titleTextField = DOCUMENT.createElement('span');
                _yuitest_coverline("build/charts-base/charts-base.js", 2473);
titleTextField.style.display = "block";
                _yuitest_coverline("build/charts-base/charts-base.js", 2474);
titleTextField.style.whiteSpace = "nowrap";
                _yuitest_coverline("build/charts-base/charts-base.js", 2475);
titleTextField.setAttribute("class", "axisTitle");
                _yuitest_coverline("build/charts-base/charts-base.js", 2476);
this.get("contentBox").append(titleTextField);
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 2478);
if(!DOCUMENT.createElementNS)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2480);
if(titleTextField.style.filter)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2482);
titleTextField.style.filter = null;
                }
            }}
            _yuitest_coverline("build/charts-base/charts-base.js", 2485);
titleTextField.style.position = "absolute";
            _yuitest_coverline("build/charts-base/charts-base.js", 2486);
for(i in styles)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2488);
if(styles.hasOwnProperty(i) && !customStyles.hasOwnProperty(i))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2490);
titleTextField.style[i] = styles[i];
                }
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 2493);
this.get("appendTitleFunction")(titleTextField, title);
            _yuitest_coverline("build/charts-base/charts-base.js", 2494);
this._titleTextField = titleTextField;
            _yuitest_coverline("build/charts-base/charts-base.js", 2495);
this._titleRotationProps = this._getTextRotationProps(styles);
            _yuitest_coverline("build/charts-base/charts-base.js", 2496);
this._setTotalTitleSize(styles);
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 2498);
if(titleTextField)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2500);
parentNode = titleTextField.parentNode;
            _yuitest_coverline("build/charts-base/charts-base.js", 2501);
if(parentNode)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2503);
parentNode.removeChild(titleTextField);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 2505);
this._titleTextField = null;
            _yuitest_coverline("build/charts-base/charts-base.js", 2506);
this._totalTitleSize = 0;
        }}
    },

    /**
     * Creates or updates an axis label.
     *
     * @method getLabel
     * @param {Object} pt x and y coordinates for the label
     * @param {Object} styles styles applied to label
     * @return HTMLElement 
     * @private
     */
    getLabel: function(pt, styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabel", 2519);
_yuitest_coverline("build/charts-base/charts-base.js", 2521);
var i,
            label,
            labelCache = this._labelCache,
            customStyles = {
                rotation: "rotation",
                margin: "margin",
                alpha: "alpha"
            };
        _yuitest_coverline("build/charts-base/charts-base.js", 2529);
if(labelCache && labelCache.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2531);
label = labelCache.shift();
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2535);
label = DOCUMENT.createElement("span");
            _yuitest_coverline("build/charts-base/charts-base.js", 2536);
label.className = Y.Lang.trim([label.className, "axisLabel"].join(' '));
            _yuitest_coverline("build/charts-base/charts-base.js", 2537);
this.get("contentBox").append(label);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2539);
if(!DOCUMENT.createElementNS)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2541);
if(label.style.filter)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2543);
label.style.filter = null;
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2546);
label.style.display = "block";
        _yuitest_coverline("build/charts-base/charts-base.js", 2547);
label.style.whiteSpace = "nowrap";
        _yuitest_coverline("build/charts-base/charts-base.js", 2548);
label.style.position = "absolute";
        _yuitest_coverline("build/charts-base/charts-base.js", 2549);
for(i in styles)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2551);
if(styles.hasOwnProperty(i) && !customStyles.hasOwnProperty(i))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2553);
label.style[i] = styles[i];
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2556);
return label;
    },

    /**
     * Creates a cache of labels that can be re-used when the axis redraws.
     *
     * @method _createLabelCache
     * @private
     */
    _createLabelCache: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_createLabelCache", 2565);
_yuitest_coverline("build/charts-base/charts-base.js", 2567);
if(this._labels)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2569);
while(this._labels.length > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2571);
this._labelCache.push(this._labels.shift());
            }
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2576);
this._clearLabelCache();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2578);
this._labels = [];
    },
    
    /**
     * Removes axis labels from the dom and clears the label cache.
     *
     * @method _clearLabelCache
     * @private
     */
    _clearLabelCache: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_clearLabelCache", 2587);
_yuitest_coverline("build/charts-base/charts-base.js", 2589);
if(this._labelCache)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2591);
var len = this._labelCache.length,
                i = 0,
                label;
            _yuitest_coverline("build/charts-base/charts-base.js", 2594);
for(; i < len; ++i)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2596);
label = this._labelCache[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 2597);
this._removeChildren(label);
                _yuitest_coverline("build/charts-base/charts-base.js", 2598);
Y.Event.purgeElement(label, true);
                _yuitest_coverline("build/charts-base/charts-base.js", 2599);
label.parentNode.removeChild(label);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2602);
this._labelCache = [];
    },

    /**
     * Gets the end point of an axis.
     *
     * @method getLineEnd
     * @return Object
     * @private 
     */
    getLineEnd: function(pt)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLineEnd", 2612);
_yuitest_coverline("build/charts-base/charts-base.js", 2614);
var w = this.get("width"),
            h = this.get("height"),
            pos = this.get("position");
        _yuitest_coverline("build/charts-base/charts-base.js", 2617);
if(pos === "top" || pos === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2619);
return {x:w, y:pt.y};
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2623);
return {x:pt.x, y:h};
        }
    },

    /**
     * Calcuates the width or height of an axis depending on its direction.
     *
     * @method getLength
     * @return Number
     * @private
     */
    getLength: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLength", 2634);
_yuitest_coverline("build/charts-base/charts-base.js", 2636);
var l,
            style = this.get("styles"),
            padding = style.padding,
            w = this.get("width"),
            h = this.get("height"),
            pos = this.get("position");
        _yuitest_coverline("build/charts-base/charts-base.js", 2642);
if(pos === "top" || pos === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2644);
l = w - (padding.left + padding.right);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2648);
l = h - (padding.top + padding.bottom);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2650);
return l;
    },

    /**
     * Gets the position of the first point on an axis.
     *
     * @method getFirstPoint
     * @param {Object} pt Object containing x and y coordinates.
     * @return Object
     * @private
     */
    getFirstPoint:function(pt)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getFirstPoint", 2661);
_yuitest_coverline("build/charts-base/charts-base.js", 2663);
var style = this.get("styles"),
            pos = this.get("position"),
            padding = style.padding,
            np = {x:pt.x, y:pt.y};
        _yuitest_coverline("build/charts-base/charts-base.js", 2667);
if(pos === "top" || pos === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2669);
np.x += padding.left + this.get("edgeOffset");
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2673);
np.y += this.get("height") - (padding.top + this.get("edgeOffset"));
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2675);
return np;
    },

    /**
     * Gets the position of the next point on an axis.
     *
     * @method getNextPoint
     * @param {Object} point Object containing x and y coordinates.
     * @param {Number} majorUnitDistance Distance in pixels between ticks.
     * @return Object
     * @private
     */
    getNextPoint: function(point, majorUnitDistance)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getNextPoint", 2687);
_yuitest_coverline("build/charts-base/charts-base.js", 2689);
var pos = this.get("position");
        _yuitest_coverline("build/charts-base/charts-base.js", 2690);
if(pos === "top" || pos === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2692);
point.x = point.x + majorUnitDistance;		
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2696);
point.y = point.y - majorUnitDistance;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2698);
return point;
    },

    /**
     * Calculates the placement of last tick on an axis.
     *
     * @method getLastPoint
     * @return Object
     * @private 
     */
    getLastPoint: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLastPoint", 2708);
_yuitest_coverline("build/charts-base/charts-base.js", 2710);
var style = this.get("styles"),
            padding = style.padding,
            w = this.get("width"),
            pos = this.get("position");
        _yuitest_coverline("build/charts-base/charts-base.js", 2714);
if(pos === "top" || pos === "bottom")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2716);
return {x:w - padding.right, y:padding.top};
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2720);
return {x:padding.left, y:padding.top};
        }
    },

    /**
     * Calculates position on the axis.
     *
     * @method getPosition
     * @param {Object} point contains x and y values
     * @private 
     */
    getPosition: function(point)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getPosition", 2731);
_yuitest_coverline("build/charts-base/charts-base.js", 2733);
var p,
            h = this.get("height"),
            style = this.get("styles"),
            padding = style.padding,
            pos = this.get("position"),
            dataType = this.get("dataType");
        _yuitest_coverline("build/charts-base/charts-base.js", 2739);
if(pos === "left" || pos === "right") 
        {
            //Numeric data on a vertical axis is displayed from bottom to top.
            //Categorical and Timeline data is displayed from top to bottom.
            _yuitest_coverline("build/charts-base/charts-base.js", 2743);
if(dataType === "numeric")
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2745);
p = (h - (padding.top + padding.bottom)) - (point.y - padding.top);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2749);
p = point.y - padding.top;
            }
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2754);
p = point.x - padding.left;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2756);
return p;
    },

    /**
     * Rotates and positions a text field.
     *
     * @method _rotate
     * @param {HTMLElement} label text field to rotate and position
     * @param {Object} props properties to be applied to the text field. 
     * @private
     */
    _rotate: function(label, props)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_rotate", 2767);
_yuitest_coverline("build/charts-base/charts-base.js", 2769);
var rot = props.rot,
            x = props.x,
            y = props.y,
            filterString,
            textAlpha,
            matrix = new Y.Matrix(),
            transformOrigin = props.transformOrigin || [0, 0],
            offsetRect;
        _yuitest_coverline("build/charts-base/charts-base.js", 2777);
if(DOCUMENT.createElementNS)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2779);
matrix.translate(x, y);
            _yuitest_coverline("build/charts-base/charts-base.js", 2780);
matrix.rotate(rot);
            _yuitest_coverline("build/charts-base/charts-base.js", 2781);
Y_DOM.setStyle(label, "transformOrigin", (transformOrigin[0] * 100) + "% " + (transformOrigin[1] * 100) + "%");
            _yuitest_coverline("build/charts-base/charts-base.js", 2782);
Y_DOM.setStyle(label, "transform", matrix.toCSSText());
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2786);
textAlpha = props.textAlpha;
            _yuitest_coverline("build/charts-base/charts-base.js", 2787);
if(Y_Lang.isNumber(textAlpha) && textAlpha < 1 && textAlpha > -1 && !isNaN(textAlpha))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2789);
filterString = "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + Math.round(textAlpha * 100) + ")";
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 2791);
if(rot !== 0)
            {
                //ms filters kind of, sort of uses a transformOrigin of 0, 0. 
                //we'll translate the difference to create a true 0, 0 origin.
                _yuitest_coverline("build/charts-base/charts-base.js", 2795);
matrix.rotate(rot);
                _yuitest_coverline("build/charts-base/charts-base.js", 2796);
offsetRect = matrix.getContentRect(props.labelWidth, props.labelHeight);
                _yuitest_coverline("build/charts-base/charts-base.js", 2797);
matrix.init();
                _yuitest_coverline("build/charts-base/charts-base.js", 2798);
matrix.translate(offsetRect.left, offsetRect.top);
                _yuitest_coverline("build/charts-base/charts-base.js", 2799);
matrix.translate(x, y);
                _yuitest_coverline("build/charts-base/charts-base.js", 2800);
this._simulateRotateWithTransformOrigin(matrix, rot, transformOrigin, props.labelWidth, props.labelHeight);
                _yuitest_coverline("build/charts-base/charts-base.js", 2801);
if(filterString)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2803);
filterString += " ";
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 2807);
filterString = ""; 
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 2809);
filterString += matrix.toFilterText();
                _yuitest_coverline("build/charts-base/charts-base.js", 2810);
label.style.left = matrix.dx + "px";
                _yuitest_coverline("build/charts-base/charts-base.js", 2811);
label.style.top = matrix.dy + "px";
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2815);
label.style.left = x + "px";
                _yuitest_coverline("build/charts-base/charts-base.js", 2816);
label.style.top = y + "px";
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 2818);
if(filterString)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2820);
label.style.filter = filterString;
            }
        }
    },
    
    /**
     * Simulates a rotation with a specified transformOrigin. 
     *
     * @method _simulateTransformOrigin
     * @param {Matrix} matrix Reference to a `Matrix` instance.
     * @param {Number} rot The rotation (in degrees) that will be performed on a matrix.
     * @param {Array} transformOrigin An array represeniting the origin in which to perform the transform. The first 
     * index represents the x origin and the second index represents the y origin.
     * @param {Number} w The width of the object that will be transformed.
     * @param {Number} h The height of the object that will be transformed.
     * @private
     */
    _simulateRotateWithTransformOrigin: function(matrix, rot, transformOrigin, w, h)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_simulateRotateWithTransformOrigin", 2837);
_yuitest_coverline("build/charts-base/charts-base.js", 2839);
var transformX = transformOrigin[0] * w,
            transformY = transformOrigin[1] * h;
        _yuitest_coverline("build/charts-base/charts-base.js", 2841);
transformX = !isNaN(transformX) ? transformX : 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 2842);
transformY = !isNaN(transformY) ? transformY : 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 2843);
matrix.translate(transformX, transformY);
        _yuitest_coverline("build/charts-base/charts-base.js", 2844);
matrix.rotate(rot);
        _yuitest_coverline("build/charts-base/charts-base.js", 2845);
matrix.translate(-transformX, -transformY);
    },

    /**
     * Returns the coordinates (top, right, bottom, left) for the bounding box of the last label. 
     *
     * @method getMaxLabelBounds
     * @return Object
     */
    getMaxLabelBounds: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMaxLabelBounds", 2854);
_yuitest_coverline("build/charts-base/charts-base.js", 2856);
return this._getLabelBounds(this.getMaximumValue());
    },

    /**
     * Returns the coordinates (top, right, bottom, left) for the bounding box of the first label. 
     *
     * @method getMinLabelBounds
     * @return Object
     */
    getMinLabelBounds: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMinLabelBounds", 2865);
_yuitest_coverline("build/charts-base/charts-base.js", 2867);
return this._getLabelBounds(this.getMinimumValue());
    },
    
    /**
     * Returns the coordinates (top, right, bottom, left) for the bounding box of a label. 
     *
     * @method _getLabelBounds
     * @param {String} Value of the label
     * @return Object
     * @private
     */
    _getLabelBounds: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getLabelBounds", 2878);
_yuitest_coverline("build/charts-base/charts-base.js", 2880);
var layout = this._layout,
            labelStyles = this.get("styles").label,
            matrix = new Y.Matrix(),
            label,
            props = this._getTextRotationProps(labelStyles);
            _yuitest_coverline("build/charts-base/charts-base.js", 2885);
props.transformOrigin = layout._getTransformOrigin(props.rot);
        _yuitest_coverline("build/charts-base/charts-base.js", 2886);
label = this.getLabel({x: 0, y: 0}, labelStyles);
        _yuitest_coverline("build/charts-base/charts-base.js", 2887);
this.get("appendLabelFunction")(label, this.get("labelFunction").apply(this, [val, this.get("labelFormat")]));
        _yuitest_coverline("build/charts-base/charts-base.js", 2888);
props.labelWidth = label.offsetWidth;
        _yuitest_coverline("build/charts-base/charts-base.js", 2889);
props.labelHeight = label.offsetHeight;
        _yuitest_coverline("build/charts-base/charts-base.js", 2890);
this._removeChildren(label);
        _yuitest_coverline("build/charts-base/charts-base.js", 2891);
Y.Event.purgeElement(label, true);
        _yuitest_coverline("build/charts-base/charts-base.js", 2892);
label.parentNode.removeChild(label);
        _yuitest_coverline("build/charts-base/charts-base.js", 2893);
props.x = 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 2894);
props.y = 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 2895);
layout._setRotationCoords(props);
        _yuitest_coverline("build/charts-base/charts-base.js", 2896);
matrix.translate(props.x, props.y);
        _yuitest_coverline("build/charts-base/charts-base.js", 2897);
this._simulateRotateWithTransformOrigin(matrix, props.rot, props.transformOrigin, props.labelWidth, props.labelHeight);
        _yuitest_coverline("build/charts-base/charts-base.js", 2898);
return matrix.getContentRect(props.labelWidth, props.labelHeight);
    },

    /**
     * Removes all DOM elements from an HTML element. Used to clear out labels during detruction
     * phase.
     *
     * @method _removeChildren
     * @private
     */
    _removeChildren: function(node)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_removeChildren", 2908);
_yuitest_coverline("build/charts-base/charts-base.js", 2910);
if(node.hasChildNodes())
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2912);
var child;
            _yuitest_coverline("build/charts-base/charts-base.js", 2913);
while(node.firstChild)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2915);
child = node.firstChild;
                _yuitest_coverline("build/charts-base/charts-base.js", 2916);
this._removeChildren(child);
                _yuitest_coverline("build/charts-base/charts-base.js", 2917);
node.removeChild(child);
            }
        }
    },
    
    /**
     * Destructor implementation Axis class. Removes all labels and the Graphic instance from the widget.
     *
     * @method destructor
     * @protected
     */
    destructor: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "destructor", 2928);
_yuitest_coverline("build/charts-base/charts-base.js", 2930);
var cb = this.get("contentBox").getDOMNode(),
            labels = this.get("labels"),
            graphic = this.get("graphic"),
            label,
            len = labels ? labels.length : 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 2935);
if(len > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2937);
while(labels.length > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 2939);
label = labels.shift();
                _yuitest_coverline("build/charts-base/charts-base.js", 2940);
this._removeChildren(label);
                _yuitest_coverline("build/charts-base/charts-base.js", 2941);
cb.removeChild(label);
                _yuitest_coverline("build/charts-base/charts-base.js", 2942);
label = null;
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2945);
if(graphic)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2947);
graphic.destroy();
        }
    },

    /**
     * Length in pixels of largest text bounding box. Used to calculate the height of the axis.
     *
     * @property maxLabelSize
     * @type Number
     * @protected
     */
    _maxLabelSize: 0,
    
    /**
     * Updates the content of text field. This method writes a value into a text field using 
     * `appendChild`. If the value is a `String`, it is converted to a `TextNode` first. 
     *
     * @method _setText
     * @param label {HTMLElement} label to be updated
     * @param val {String} value with which to update the label
     * @private
     */
    _setText: function(textField, val)
    { 
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setText", 2969);
_yuitest_coverline("build/charts-base/charts-base.js", 2971);
textField.innerHTML = "";
        _yuitest_coverline("build/charts-base/charts-base.js", 2972);
if(Y_Lang.isNumber(val))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2974);
val = val + "";
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 2976);
if(!val)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2978);
val = "";
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 2980);
if(IS_STRING(val))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 2982);
val = DOCUMENT.createTextNode(val);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 2984);
textField.appendChild(val);
    }
}, {
    ATTRS: 
    {
        /**
         * When set, defines the width of a vertical axis instance. By default, vertical axes automatically size based on their contents. When the
         * width attribute is set, the axis will not calculate its width. When the width attribute is explicitly set, axis labels will postion themselves off of the 
         * the inner edge of the axis and the title, if present, will position itself off of the outer edge. If a specified width is less than the sum of 
         * the axis' contents, excess content will overflow.
         *
         * @attribute width
         * @type Number
         */
        width: {
            lazyAdd: false,

            getter: function() 
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3001);
_yuitest_coverline("build/charts-base/charts-base.js", 3003);
if(this._explicitWidth)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3005);
return this._explicitWidth;        
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3007);
return this._calculatedWidth;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3010);
_yuitest_coverline("build/charts-base/charts-base.js", 3012);
this._explicitWidth = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 3013);
return val;
            }
        },

        /**
         * When set, defines the height of a horizontal axis instance. By default, horizontal axes automatically size based on their contents. When the
         * height attribute is set, the axis will not calculate its height. When the height attribute is explicitly set, axis labels will postion themselves off of the 
         * the inner edge of the axis and the title, if present, will position itself off of the outer edge. If a specified height is less than the sum of 
         * the axis' contents, excess content will overflow.
         *
         * @attribute height
         * @type Number
         */
        height: {
            lazyAdd: false,

            getter: function() 
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3029);
_yuitest_coverline("build/charts-base/charts-base.js", 3031);
if(this._explicitHeight)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3033);
return this._explicitHeight;        
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3035);
return this._calculatedHeight;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3038);
_yuitest_coverline("build/charts-base/charts-base.js", 3040);
this._explicitHeight = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 3041);
return val;
            }
        },

        /**
         * Calculated value of an axis' width. By default, the value is used internally for vertical axes. If the `width` attribute is explicitly set, this value will be ignored.
         *
         * @attribute calculatedWidth
         * @type Number
         * @private
         */
        calculatedWidth: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3053);
_yuitest_coverline("build/charts-base/charts-base.js", 3055);
return this._calculatedWidth;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3058);
_yuitest_coverline("build/charts-base/charts-base.js", 3060);
this._calculatedWidth = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 3061);
return val;
            }
        },

        /**
         * Calculated value of an axis' height. By default, the value is used internally for horizontal axes. If the `height` attribute is explicitly set, this value will be ignored.
         *
         * @attribute calculatedHeight
         * @type Number
         * @private
         */
        calculatedHeight: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3073);
_yuitest_coverline("build/charts-base/charts-base.js", 3075);
return this._calculatedHeight;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3078);
_yuitest_coverline("build/charts-base/charts-base.js", 3080);
this._calculatedHeight = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 3081);
return val;
            }
        },

        /**
         * Difference betweend the first/last tick and edge of axis.
         *
         * @attribute edgeOffset
         * @type Number
         * @protected
         */
        edgeOffset: 
        {
            value: 0
        },

        /**
         * The graphic in which the axis line and ticks will be rendered.
         *
         * @attribute graphic
         * @type Graphic
         */
        graphic: {},
    
        /**
         *  @attribute path
         *  @type Shape
         *  @readOnly
         *  @private
         */
        path: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3114);
_yuitest_coverline("build/charts-base/charts-base.js", 3116);
if(!this._path)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3118);
var graphic = this.get("graphic");
                    _yuitest_coverline("build/charts-base/charts-base.js", 3119);
if(graphic)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 3121);
this._path = graphic.addShape({type:"path"});
                    }
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3124);
return this._path;
            }
        },

        /**
         *  @attribute tickPath
         *  @type Shape
         *  @readOnly
         *  @private
         */
        tickPath: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3137);
_yuitest_coverline("build/charts-base/charts-base.js", 3139);
if(!this._tickPath)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3141);
var graphic = this.get("graphic");
                    _yuitest_coverline("build/charts-base/charts-base.js", 3142);
if(graphic)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 3144);
this._tickPath = graphic.addShape({type:"path"});
                    }
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3147);
return this._tickPath;
            }
        },
        
        /**
         * Contains the contents of the axis. 
         *
         * @attribute node
         * @type HTMLElement
         */
        node: {},

        /**
         * Direction of the axis.
         *
         * @attribute position
         * @type String
         */
        position: {
            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3166);
_yuitest_coverline("build/charts-base/charts-base.js", 3168);
var layoutClass = this._layoutClasses[val];
                _yuitest_coverline("build/charts-base/charts-base.js", 3169);
if(val && val != "none")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3171);
this._layout = new layoutClass();
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3173);
return val;
            }
        },

        /**
         * Distance determined by the tick styles used to calculate the distance between the axis
         * line in relation to the top of the axis.
         *
         * @attribute topTickOffset
         * @type Number
         */
        topTickOffset: {
            value: 0
        },

        /**
         * Distance determined by the tick styles used to calculate the distance between the axis
         * line in relation to the bottom of the axis.
         *
         * @attribute bottomTickOffset
         * @type Number
         */
        bottomTickOffset: {
            value: 0
        },

        /**
         * Distance determined by the tick styles used to calculate the distance between the axis
         * line in relation to the left of the axis.
         *
         * @attribute leftTickOffset
         * @type Number
         */
        leftTickOffset: {
            value: 0
        },

        /**
         * Distance determined by the tick styles used to calculate the distance between the axis
         * line in relation to the right side of the axis.
         *
         * @attribute rightTickOffset
         * @type Number
         */
        rightTickOffset: {
            value: 0
        },
        
        /**
         * Collection of labels used to render the axis.
         *
         * @attribute labels
         * @type Array
         */
        labels: {
            readOnly: true,
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3229);
_yuitest_coverline("build/charts-base/charts-base.js", 3231);
return this._labels;
            }
        },

        /**
         * Collection of points used for placement of labels and ticks along the axis.
         *
         * @attribute tickPoints
         * @type Array
         */
        tickPoints: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3244);
_yuitest_coverline("build/charts-base/charts-base.js", 3246);
if(this.get("position") == "none")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3248);
return this.get("styles").majorUnit.count;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3250);
return this._tickPoints;
            }
        },

        /**
         * Indicates whether the axis overlaps the graph. If an axis is the inner most axis on a given
         * position and the tick position is inside or cross, the axis will need to overlap the graph.
         *
         * @attribute overlapGraph
         * @type Boolean
         */
        overlapGraph: {
            value:true,

            validator: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "validator", 3264);
_yuitest_coverline("build/charts-base/charts-base.js", 3266);
return Y_Lang.isBoolean(val);
            }
        },

        /**
         * Object which should have by the labelFunction
         *
         * @attribute labelFunctionScope
         * @type Object
         */
        labelFunctionScope: {},
        
        /**
         * Length in pixels of largest text bounding box. Used to calculate the height of the axis.
         *
         * @attribute maxLabelSize
         * @type Number
         * @protected
         */
        maxLabelSize: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3286);
_yuitest_coverline("build/charts-base/charts-base.js", 3288);
return this._maxLabelSize;
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3291);
_yuitest_coverline("build/charts-base/charts-base.js", 3293);
this._maxLabelSize = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 3294);
return val; 
            }
        },
        
        /**
         *  Title for the axis. When specified, the title will display. The position of the title is determined by the axis position. 
         *  <dl>
         *      <dt>top</dt><dd>Appears above the axis and it labels. The default rotation is 0.</dd>
         *      <dt>right</dt><dd>Appears to the right of the axis and its labels. The default rotation is 90.</dd>
         *      <dt>bottom</dt><dd>Appears below the axis and its labels. The default rotation is 0.</dd>
         *      <dt>left</dt><dd>Appears to the left of the axis and its labels. The default rotation is -90.</dd>
         *  </dl>
         *
         *  @attribute title
         *  @type String
         */
        title: {
            value: null
        },
        
        /**
         * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need
         * to implement the arguments below and return a `String` or `HTMLElement`. 
         * <dl>
         *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>
         *      <dt>format</dt><dd>Template for formatting label. (optional)</dd>
         * </dl>
         *
         * @attribute labelFunction
         * @type Function
         */
        labelFunction: {
            value: function(val, format)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "value", 3326);
_yuitest_coverline("build/charts-base/charts-base.js", 3328);
return val;
            }
        },
        
        /**
         * Function used to append an axis value to an axis label. This function has the following signature:
         *  <dl>
         *      <dt>textField</dt><dd>The axis label to be appended. (`HTMLElement`)</dd>
         *      <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`
         *      or a `String`. This method does not use (`HTMLElement` | `String`)</dd>
         *  </dl>
         * The default method appends a value to the `HTMLElement` using the `appendChild` method. If the given 
         * value is a `String`, the method will convert the the value to a `textNode` before appending to the 
         * `HTMLElement`. This method will not convert an `HTMLString` to an `HTMLElement`. 
         *
         * @attribute appendLabelFunction
         * @type Function
         */
        appendLabelFunction: {
            valueFn: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "valueFn", 3347);
_yuitest_coverline("build/charts-base/charts-base.js", 3349);
return this._setText;
            }
        },
        
        /**
         * Function used to append a title value to the title object. This function has the following signature:
         *  <dl>
         *      <dt>textField</dt><dd>The title text field to be appended. (`HTMLElement`)</dd>
         *      <dt>val</dt><dd>The value to attach to the text field. This method will accept an `HTMLELement`
         *      or a `String`. This method does not use (`HTMLElement` | `String`)</dd>
         *  </dl>
         * The default method appends a value to the `HTMLElement` using the `appendChild` method. If the given 
         * value is a `String`, the method will convert the the value to a `textNode` before appending to the 
         * `HTMLElement` element. This method will not convert an `HTMLString` to an `HTMLElement`. 
         *
         * @attribute appendTitleFunction
         * @type Function
         */
        appendTitleFunction: {
            valueFn: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "valueFn", 3368);
_yuitest_coverline("build/charts-base/charts-base.js", 3370);
return this._setText;
            }
        }
            
        /**
         * Style properties used for drawing an axis. This attribute is inherited from `Renderer`. Below are the default values:
         *  <dl>
         *      <dt>majorTicks</dt><dd>Properties used for drawing ticks.
         *          <dl>
         *              <dt>display</dt><dd>Position of the tick. Possible values are `inside`, `outside`, `cross` and `none`. The
         *              default value is `inside`.</dd>
         *              <dt>length</dt><dd>The length (in pixels) of the tick. The default value is 4.</dd>
         *              <dt>color</dt><dd>The color of the tick. The default value is `#dad8c9`</dd>
         *              <dt>weight</dt><dd>Number indicating the width of the tick. The default value is 1.</dd>
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>line</dt><dd>Properties used for drawing the axis line. 
         *          <dl>
         *              <dt>weight</dt><dd>Number indicating the width of the axis line. The default value is 1.</dd>
         *              <dt>color</dt><dd>The color of the axis line. The default value is `#dad8c9`.</dd>
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the tick. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>majorUnit</dt><dd>Properties used to calculate the `majorUnit` for the axis. 
         *          <dl>
         *              <dt>determinant</dt><dd>The algorithm used for calculating distance between ticks. The possible options are `count` and `distance`. If
         *              the `determinant` is `count`, the axis ticks will spaced so that a specified number of ticks appear on the axis. If the `determinant`
         *              is `distance`, the axis ticks will spaced out according to the specified distance. The default value is `count`.</dd>
         *              <dt>count</dt><dd>Number of ticks to appear on the axis when the `determinant` is `count`. The default value is 11.</dd>
         *              <dt>distance</dt><dd>The distance (in pixels) between ticks when the `determinant` is `distance`. The default value is 75.</dd>
         *          </dl>
         *      </dd>
         *      <dt>label</dt><dd>Properties and styles applied to the axis labels.
         *          <dl>
         *              <dt>color</dt><dd>The color of the labels. The default value is `#808080`.</dd>
         *              <dt>alpha</dt><dd>Number between 0 and 1 indicating the opacity of the labels. The default value is 1.</dd>
         *              <dt>fontSize</dt><dd>The font-size of the labels. The default value is 85%</dd>
         *              <dt>rotation</dt><dd>The rotation, in degrees (between -90 and 90) of the labels. The default value is 0.</dd>
         *              <dt>margin</dt><dd>The distance between the label and the axis/tick. Depending on the position of the `Axis`, only one of the properties used.
         *                  <dl>
         *                      <dt>top</dt><dd>Pixel value used for an axis with a `position` of `bottom`. The default value is 4.</dd>
         *                      <dt>right</dt><dd>Pixel value used for an axis with a `position` of `left`. The default value is 4.</dd>
         *                      <dt>bottom</dt><dd>Pixel value used for an axis with a `position` of `top`. The default value is 4.</dd>
         *                      <dt>left</dt><dd>Pixel value used for an axis with a `position` of `right`. The default value is 4.</dd>
         *                  </dl>
         *              </dd>
         *          </dl>
         *      </dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});
/**
 * AxisType is an abstract class that manages the data for an axis.
 *
 * @module charts
 * @submodule charts-base
 * @class AxisType
 * @constructor
 * @extends Axis
 */
_yuitest_coverline("build/charts-base/charts-base.js", 3435);
Y.AxisType = Y.Base.create("baseAxis", Y.Axis, [], {
    /**
     * @method initializer
     * @private
     */
    initializer: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "initializer", 3440);
_yuitest_coverline("build/charts-base/charts-base.js", 3442);
this.after("dataReady", Y.bind(this._dataChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 3443);
this.after("dataUpdate", Y.bind(this._dataChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 3444);
this.after("minimumChange", Y.bind(this._keyChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 3445);
this.after("maximumChange", Y.bind(this._keyChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 3446);
this.after("keysChange", this._keyChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3447);
this.after("dataProviderChange", this._dataProviderChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3448);
this.after("alwaysShowZeroChange", this._keyChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3449);
this.after("roundingMethodChange", this._keyChangeHandler);
    },

    /**
     * @method bindUI
     * @private
     */
    bindUI: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "bindUI", 3456);
_yuitest_coverline("build/charts-base/charts-base.js", 3458);
this.after("stylesChange", this._updateHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3459);
this.after("overlapGraphChange", this._updateHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3460);
this.after("positionChange", this._positionChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 3461);
this.after("widthChange", this._handleSizeChange);
        _yuitest_coverline("build/charts-base/charts-base.js", 3462);
this.after("heightChange", this._handleSizeChange);
        _yuitest_coverline("build/charts-base/charts-base.js", 3463);
this.after("calculatedWidthChange", this._handleSizeChange);
        _yuitest_coverline("build/charts-base/charts-base.js", 3464);
this.after("calculatedHeightChange", this._handleSizeChange);
    },

    /**
     * Handles changes to `dataProvider`.
     *
     * @method _dataProviderChangeHandler
     * @param {Object} e Event object.
     * @private
     */
    _dataProviderChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_dataProviderChangeHandler", 3474);
_yuitest_coverline("build/charts-base/charts-base.js", 3476);
var keyCollection = this.get("keyCollection").concat(),
            keys = this.get("keys"),
            i;
        _yuitest_coverline("build/charts-base/charts-base.js", 3479);
if(keys)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3481);
for(i in keys)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 3483);
if(keys.hasOwnProperty(i))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3485);
delete keys[i];
                }
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3489);
if(keyCollection && keyCollection.length)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3491);
this.set("keys", keyCollection);
        }
    },

    /**
     * Constant used to generate unique id.
     *
     * @property GUID
     * @type String
     * @private
     */
    GUID: "yuibaseaxis",
	
    /**
     * Type of data used in `Axis`.
     *
     * @property _type
     * @type String 
     * @readOnly
     * @private
     */
    _type: null,
	
    /**
     * Storage for `setMaximum` attribute.
     *
     * @property _setMaximum
     * @type Object
     * @private
     */
    _setMaximum: null,
	
    /**
     * Storage for `dataMaximum` attribute.
     *
     * @property _dataMaximum
     * @type Object
     * @private
     */
    _dataMaximum: null,
	
    /**
     * Storage for `setMinimum` attribute.
     *
     * @property _setMinimum
     * @type Object
     * @private
     */
    _setMinimum: null,
	
    /**
     * Reference to data array.
     *
     * @property _data
     * @type Array
     * @private
     */
    _data: null,

    /**
     * Indicates whether the all data is up to date.
     *
     * @property _updateTotalDataFlag
     * @type Boolean
     * @private
     */
    _updateTotalDataFlag: true,

    /**
     * Storage for `dataReady` attribute.
     *
     * @property _dataReady
     * @type Boolean
     * @readOnly
     * @private
     */
    _dataReady: false,
	
    /**
     * Adds an array to the key hash.
     *
     * @method addKey
     * @param value Indicates what key to use in retrieving
     * the array.
     */
    addKey: function (value)
	{
        _yuitest_coverfunc("build/charts-base/charts-base.js", "addKey", 3576);
_yuitest_coverline("build/charts-base/charts-base.js", 3578);
this.set("keys", value);
	},

    /**
     * Gets an array of values based on a key.
     *
     * @method _getKeyArray
     * @param {String} key Value key associated with the data array.
     * @param {Array} data Array in which the data resides.
     * @return Array
     * @private
     */
    _getKeyArray: function(key, data)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getKeyArray", 3590);
_yuitest_coverline("build/charts-base/charts-base.js", 3592);
var i = 0,
            obj,
            keyArray = [],
            len = data.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 3596);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3598);
obj = data[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 3599);
keyArray[i] = obj[key];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3601);
return keyArray;
    },

    /**
     * Sets data by key
     *
     * @method _setDataByKey
     * @param {String} key Key value to use.
     * @param {Array} data Array to use.
     * @private 
     */
    _setDataByKey: function(key, data)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setDataByKey", 3612);
_yuitest_coverline("build/charts-base/charts-base.js", 3614);
var i,
            obj, 
            arr = [], 
            dv = this._dataClone.concat(), 
            len = dv.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 3619);
for(i = 0; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3621);
obj = dv[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 3622);
arr[i] = obj[key];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3624);
this.get("keys")[key] = arr;
        _yuitest_coverline("build/charts-base/charts-base.js", 3625);
this._updateTotalDataFlag = true;
    },

    /**
     * Updates the total data array.
     *
     * @method _updateTotalData
     * @private
     */
    _updateTotalData: function()
    {
		_yuitest_coverfunc("build/charts-base/charts-base.js", "_updateTotalData", 3634);
_yuitest_coverline("build/charts-base/charts-base.js", 3636);
var keys = this.get("keys"),
            i;
        _yuitest_coverline("build/charts-base/charts-base.js", 3638);
this._data = [];
        _yuitest_coverline("build/charts-base/charts-base.js", 3639);
for(i in keys)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3641);
if(keys.hasOwnProperty(i))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 3643);
this._data = this._data.concat(keys[i]);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3646);
this._updateTotalDataFlag = false;
    },

    /**
     * Removes an array from the key hash.
     * 
     * @method removeKey
     * @param {String} value Indicates what key to use in removing from 
     * the hash.
     */
    removeKey: function(value)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "removeKey", 3656);
_yuitest_coverline("build/charts-base/charts-base.js", 3658);
var keys = this.get("keys");
        _yuitest_coverline("build/charts-base/charts-base.js", 3659);
if(keys.hasOwnProperty(value)) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3661);
delete keys[value];
            _yuitest_coverline("build/charts-base/charts-base.js", 3662);
this._keyChangeHandler();
        }
    },

    /**
     * Returns a value based of a key value and an index.
     *
     * @method getKeyValueAt
     * @param {String} key value used to look up the correct array
     * @param {Number} index within the array
     * @return Number 
     */
    getKeyValueAt: function(key, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getKeyValueAt", 3674);
_yuitest_coverline("build/charts-base/charts-base.js", 3676);
var value = NaN,
            keys = this.get("keys");
        _yuitest_coverline("build/charts-base/charts-base.js", 3678);
if(keys[key] && Y_Lang.isNumber(parseFloat(keys[key][index])))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3680);
value = keys[key][index];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3682);
return parseFloat(value);
    },

    /**
     * Returns an array of values based on an identifier key.
     *
     * @method getDataByKey
     * @param {String} value value used to identify the array
     * @return Object
     */
    getDataByKey: function (value)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getDataByKey", 3692);
_yuitest_coverline("build/charts-base/charts-base.js", 3694);
var keys = this.get("keys");
        _yuitest_coverline("build/charts-base/charts-base.js", 3695);
if(keys[value])
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3697);
return keys[value];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3699);
return null;
    },

    /**
     * Calculates the maximum and minimum values for the `Axis`.
     *
     * @method _updateMinAndMax
     * @private 
     */
    _updateMinAndMax: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateMinAndMax", 3708);
_yuitest_coverline("build/charts-base/charts-base.js", 3710);
var data = this.get("data"),
            max = 0,
            min = 0,
            len,
            num,
            i;
        _yuitest_coverline("build/charts-base/charts-base.js", 3716);
if(data && data.length && data.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3718);
len = data.length;
            _yuitest_coverline("build/charts-base/charts-base.js", 3719);
max = min = data[0];
            _yuitest_coverline("build/charts-base/charts-base.js", 3720);
if(len > 1)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 3722);
for(i = 1; i < len; i++)
                {	
                    _yuitest_coverline("build/charts-base/charts-base.js", 3724);
num = data[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 3725);
if(isNaN(num))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 3727);
continue;
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 3729);
max = Math.max(num, max);
                    _yuitest_coverline("build/charts-base/charts-base.js", 3730);
min = Math.min(num, min);
                }
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3734);
this._dataMaximum = max;
        _yuitest_coverline("build/charts-base/charts-base.js", 3735);
this._dataMinimum = min;
    },

    /**
     * Returns the total number of majorUnits that will appear on an axis.
     *
     * @method getTotalMajorUnits
     * @return Number
     */
    getTotalMajorUnits: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getTotalMajorUnits", 3744);
_yuitest_coverline("build/charts-base/charts-base.js", 3746);
var units,
            majorUnit = this.get("styles").majorUnit,
            len = this.get("length");
        _yuitest_coverline("build/charts-base/charts-base.js", 3749);
if(majorUnit.determinant === "count") 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3751);
units = majorUnit.count;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 3753);
if(majorUnit.determinant === "distance") 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3755);
units = (len/majorUnit.distance) + 1;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 3757);
return units; 
    },

    /**
     * Returns the distance between major units on an axis.
     *
     * @method getMajorUnitDistance
     * @param {Number} len Number of ticks
     * @param {Number} uiLen Size of the axis.
     * @param {Object} majorUnit Hash of properties used to determine the majorUnit
     * @return Number
     */
    getMajorUnitDistance: function(len, uiLen, majorUnit)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMajorUnitDistance", 3769);
_yuitest_coverline("build/charts-base/charts-base.js", 3771);
var dist;
        _yuitest_coverline("build/charts-base/charts-base.js", 3772);
if(majorUnit.determinant === "count")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3774);
dist = uiLen/(len - 1);
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 3776);
if(majorUnit.determinant === "distance")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3778);
dist = majorUnit.distance;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 3780);
return dist;
    },
    
    /**
     * Gets the distance that the first and last ticks are offset from there respective
     * edges.
     *
     * @method getEdgeOffset
     * @param {Number} ct Number of ticks on the axis.
     * @param {Number} l Length (in pixels) of the axis.
     * @return Number
     */
    getEdgeOffset: function(ct, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getEdgeOffset", 3792);
_yuitest_coverline("build/charts-base/charts-base.js", 3794);
return 0;
    },

    /**
     * Calculates and returns a value based on the number of labels and the index of
     * the current label.
     *
     * @method getLabelByIndex
     * @param {Number} i Index of the label.
     * @param {Number} l Total number of labels.
     * @return String
     */
    getLabelByIndex: function(i, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelByIndex", 3806);
_yuitest_coverline("build/charts-base/charts-base.js", 3808);
var min = this.get("minimum"),
            max = this.get("maximum"),
            increm = (max - min)/(l-1),
            label;
            _yuitest_coverline("build/charts-base/charts-base.js", 3812);
l -= 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 3813);
label = min + (i * increm);
        _yuitest_coverline("build/charts-base/charts-base.js", 3814);
return label;
    },

    /**
     * Updates the `Axis` after a change in keys.
     *
     * @method _keyChangeHandler
     * @param {Object} e Event object.
     * @private
     */
    _keyChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_keyChangeHandler", 3824);
_yuitest_coverline("build/charts-base/charts-base.js", 3826);
this._updateMinAndMax();
        _yuitest_coverline("build/charts-base/charts-base.js", 3827);
this.fire("dataUpdate");
    },

    /**
     * Checks to see if data extends beyond the range of the axis. If so,
     * that data will need to be hidden. This method is internal, temporary and subject
     * to removal in the future.
     *
     * @method _hasDataOverflow
     * @protected
     * @return Boolean
     */
    _hasDataOverflow: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_hasDataOverflow", 3839);
_yuitest_coverline("build/charts-base/charts-base.js", 3841);
if(this.get("setMin") || this.get("setMax"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 3843);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 3845);
return false;
    },

    /**
     * Returns a string corresponding to the first label on an 
     * axis.
     *
     * @method getMinimumValue
     * @return String
     */
    getMinimumValue: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMinimumValue", 3855);
_yuitest_coverline("build/charts-base/charts-base.js", 3857);
return this.get("minimum");
    },

    /**
     * Returns a string corresponding to the last label on an 
     * axis.
     *
     * @method getMaximumValue
     * @return String
     */
    getMaximumValue: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMaximumValue", 3867);
_yuitest_coverline("build/charts-base/charts-base.js", 3869);
return this.get("maximum");
    }
}, {
    ATTRS: {
        /**
         * Hash of array identifed by a string value.
         *
         * @attribute keys
         * @type Object
         */
        keys: {
            value: {},

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3882);
_yuitest_coverline("build/charts-base/charts-base.js", 3884);
var keys = {},
                    i, 
                    len,
                    data = this.get("dataProvider");
                _yuitest_coverline("build/charts-base/charts-base.js", 3888);
if(Y_Lang.isArray(val))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3890);
len = val.length;
                    _yuitest_coverline("build/charts-base/charts-base.js", 3891);
for(i = 0; i < len; ++i)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 3893);
keys[val[i]] = this._getKeyArray(val[i], data);   
                    }
                    
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 3897);
if(Y_Lang.isString(val))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3899);
keys = this.get("keys");
                    _yuitest_coverline("build/charts-base/charts-base.js", 3900);
keys[val] = this._getKeyArray(val, data);
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 3904);
for(i in val)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 3906);
if(val.hasOwnProperty(i))
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 3908);
keys[i] = this._getKeyArray(i, data);
                        }
                    }
                }}
	            _yuitest_coverline("build/charts-base/charts-base.js", 3912);
this._updateTotalDataFlag = true;
                _yuitest_coverline("build/charts-base/charts-base.js", 3913);
return keys;
            }
        },

        /**
         *Indicates how to round unit values.
         *  <dl>
         *      <dt>niceNumber</dt><dd>Units will be smoothed based on the number of ticks and data range.</dd>
         *      <dt>auto</dt><dd>If the range is greater than 1, the units will be rounded.</dd>
         *      <dt>numeric value</dt><dd>Units will be equal to the numeric value.</dd>
         *      <dt>null</dt><dd>No rounding will occur.</dd>
         *  </dl>
         *
         * @attribute roundingMethod
         * @type String
         * @default niceNumber
         */
        roundingMethod: {
            value: "niceNumber"
        },

        /**
         *Returns the type of axis data
         *  <dl>
         *      <dt>time</dt><dd>Manages time data</dd>
         *      <dt>stacked</dt><dd>Manages stacked numeric data</dd>      
         *      <dt>numeric</dt><dd>Manages numeric data</dd>
         *      <dt>category</dt><dd>Manages categorical data</dd>
         *  </dl>
         *
         * @attribute type
         * @type String
         */
        type:
        {
            readOnly: true,

            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3950);
_yuitest_coverline("build/charts-base/charts-base.js", 3952);
return this._type;
            }
        },

        /**
         * Instance of `ChartDataProvider` that the class uses
         * to build its own data.
         *
         * @attribute dataProvider
         * @type Array
         */
        dataProvider:{
            setter: function (value)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 3964);
_yuitest_coverline("build/charts-base/charts-base.js", 3966);
return value;
            }
        },

        /**
         * The maximum value contained in the `data` array. Used for
         * `maximum` when `autoMax` is true.
         *
         * @attribute dataMaximum
         * @type Number
         */
        dataMaximum: {
            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3978);
_yuitest_coverline("build/charts-base/charts-base.js", 3980);
if(!this._dataMaximum)
                {   
                    _yuitest_coverline("build/charts-base/charts-base.js", 3982);
this._updateMinAndMax();
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 3984);
return this._dataMaximum;
            }
        },

        /**
         * The maximum value that will appear on an axis.
         *
         * @attribute maximum
         * @type Number
         */
        maximum: {
            lazyAdd: false,

            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 3997);
_yuitest_coverline("build/charts-base/charts-base.js", 3999);
var max = this.get("dataMaximum"),
                    min = this.get("minimum");
                //If all values are zero, force a range so that the Axis and related series
                //will still render.
                _yuitest_coverline("build/charts-base/charts-base.js", 4003);
if(min === 0 && max === 0)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4005);
max = 10;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4007);
if(Y_Lang.isNumber(this._setMaximum))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4009);
max = this._setMaximum;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4011);
return parseFloat(max);
            },
            setter: function (value)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 4013);
_yuitest_coverline("build/charts-base/charts-base.js", 4015);
this._setMaximum = parseFloat(value);
                _yuitest_coverline("build/charts-base/charts-base.js", 4016);
return value;
            }
        },

        /**
         * The minimum value contained in the `data` array. Used for
         * `minimum` when `autoMin` is true.
         *
         * @attribute dataMinimum
         * @type Number
         */
        dataMinimum: {
            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4028);
_yuitest_coverline("build/charts-base/charts-base.js", 4030);
if(!this._dataMinimum)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4032);
this._updateMinAndMax();
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4034);
return this._dataMinimum;
            }
        },

        /**
         * The minimum value that will appear on an axis.
         *
         * @attribute minimum
         * @type Number
         */
        minimum: {
            lazyAdd: false,

            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4047);
_yuitest_coverline("build/charts-base/charts-base.js", 4049);
var min = this.get("dataMinimum");
                _yuitest_coverline("build/charts-base/charts-base.js", 4050);
if(Y_Lang.isNumber(this._setMinimum))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4052);
min = this._setMinimum;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4054);
return parseFloat(min);
            },
            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 4056);
_yuitest_coverline("build/charts-base/charts-base.js", 4058);
this._setMinimum = parseFloat(val);
                _yuitest_coverline("build/charts-base/charts-base.js", 4059);
return val;
            }
        },

        /**
         * Determines whether the maximum is calculated or explicitly 
         * set by the user.
         *
         * @attribute setMax
         * @type Boolean
         */
        setMax: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4073);
_yuitest_coverline("build/charts-base/charts-base.js", 4075);
return Y_Lang.isNumber(this._setMaximum);
            }
        },

        /**
         * Determines whether the minimum is calculated or explicitly
         * set by the user.
         *
         * @attribute setMin
         * @type Boolean
         */
        setMin: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4089);
_yuitest_coverline("build/charts-base/charts-base.js", 4091);
return Y_Lang.isNumber(this._setMinimum);
            }
        },

        /**
         * Array of axis data
         *
         * @attribute data
         * @type Array
         */
        data: {
            getter: function ()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4102);
_yuitest_coverline("build/charts-base/charts-base.js", 4104);
if(!this._data || this._updateTotalDataFlag)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4106);
this._updateTotalData();
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4108);
return this._data;
            }
        },

        /**
         * Array containing all the keys in the axis.
        
         * @attribute keyCollection
         * @type Array
         */
        keyCollection: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4119);
_yuitest_coverline("build/charts-base/charts-base.js", 4121);
var keys = this.get("keys"),
                    i, 
                    col = [];
                _yuitest_coverline("build/charts-base/charts-base.js", 4124);
for(i in keys)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4126);
if(keys.hasOwnProperty(i))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4128);
col.push(i);
                    }
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 4131);
return col;
            },
            readOnly: true
        }
    }
});
/**
 * NumericAxis manages numeric data on an axis.
 *
 * @module charts
 * @submodule charts-base
 * @class NumericAxis
 * @constructor
 * @param {Object} config (optional) Configuration parameters for the Chart.
 * @extends AxisType
 */
_yuitest_coverline("build/charts-base/charts-base.js", 4147);
function NumericAxis(config)
{
	_yuitest_coverfunc("build/charts-base/charts-base.js", "NumericAxis", 4147);
_yuitest_coverline("build/charts-base/charts-base.js", 4149);
NumericAxis.superclass.constructor.apply(this, arguments);
}

_yuitest_coverline("build/charts-base/charts-base.js", 4152);
NumericAxis.NAME = "numericAxis";

_yuitest_coverline("build/charts-base/charts-base.js", 4154);
NumericAxis.ATTRS = {
    /**
     * Indicates whether 0 should always be displayed.
     *
     * @attribute alwaysShowZero
     * @type Boolean
     */
	alwaysShowZero: {
	    value: true	
	},
    
    /**
     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need
     * to implement the arguments below and return a `String` or an `HTMLElement`. The default implementation of the method returns a `String`. The output of this method
     * will be rendered to the DOM using `appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override the Axis' 
     * `appendLabelFunction` to accept html as a `String`.
     * <dl>
     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>
     *      <dt>format</dt><dd>Object containing properties used to format the label. (optional)</dd>
     * </dl>
     *
     * @attribute labelFunction
     * @type Function
     */
    labelFunction: { 
        value: function(val, format)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "value", 4179);
_yuitest_coverline("build/charts-base/charts-base.js", 4181);
if(format)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4183);
return Y.DataType.Number.format(val, format);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4185);
return val;
        }
    },

    /**
     * Object containing properties used by the `labelFunction` to format a
     * label.
     *
     * @attribute labelFormat
     * @type Object
     */
    labelFormat: {
        value: {
            prefix: "",
            thousandsSeparator: "",
            decimalSeparator: "",
            decimalPlaces: "0",
            suffix: ""
        }
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 4207);
Y.extend(NumericAxis, Y.AxisType,
{
    /**
     * Formats a label based on the axis type and optionally specified format.
     *
     * @method formatLabel
     * @param {Object} value
     * @param {Object} format Pattern used to format the value.
     * @return String
     */
    formatLabel: function(val, format)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "formatLabel", 4217);
_yuitest_coverline("build/charts-base/charts-base.js", 4219);
if(format)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4221);
return Y.DataType.Number.format(val, format);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4223);
return val;
    },

    /**
     * Returns the sum of all values per key.
     *
     * @method getTotalByKey
     * @param {String} key The identifier for the array whose values will be calculated.
     * @return Number
     */
    getTotalByKey: function(key)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getTotalByKey", 4233);
_yuitest_coverline("build/charts-base/charts-base.js", 4235);
var total = 0,
            values = this.getDataByKey(key),
            i = 0,
            val,
            len = values ? values.length : 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 4240);
for(; i < len; ++i)
        {
           _yuitest_coverline("build/charts-base/charts-base.js", 4242);
val = parseFloat(values[i]);
           _yuitest_coverline("build/charts-base/charts-base.js", 4243);
if(!isNaN(val))
           {
                _yuitest_coverline("build/charts-base/charts-base.js", 4245);
total += val;
           }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4248);
return total;
    },

    /**
     * Type of data used in `Axis`.
     *
     * @property _type
     * @readOnly
     * @private
     */
    _type: "numeric",

    /**
     * Helper method for getting a `roundingUnit` when calculating the minimum and maximum values.
     *
     * @method _getMinimumUnit
     * @param {Number} max Maximum number
     * @param {Number} min Minimum number
     * @param {Number} units Number of units on the axis
     * @return Number
     * @private
     */
    _getMinimumUnit:function(max, min, units)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getMinimumUnit", 4270);
_yuitest_coverline("build/charts-base/charts-base.js", 4272);
return this._getNiceNumber(Math.ceil((max - min)/units));
    },

    /**
     * Calculates a nice rounding unit based on the range.
     *
     * @method _getNiceNumber
     * @param {Number} roundingUnit The calculated rounding unit.
     * @return Number
     * @private
     */
    _getNiceNumber: function(roundingUnit)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getNiceNumber", 4283);
_yuitest_coverline("build/charts-base/charts-base.js", 4285);
var tempMajorUnit = roundingUnit,
            order = Math.ceil(Math.log(tempMajorUnit) * 0.4342944819032518),
            roundedMajorUnit = Math.pow(10, order),
            roundedDiff;

        _yuitest_coverline("build/charts-base/charts-base.js", 4290);
if (roundedMajorUnit / 2 >= tempMajorUnit) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4292);
roundedDiff = Math.floor((roundedMajorUnit / 2 - tempMajorUnit) / (Math.pow(10,order-1)/2));
            _yuitest_coverline("build/charts-base/charts-base.js", 4293);
tempMajorUnit = roundedMajorUnit/2 - roundedDiff*Math.pow(10,order-1)/2;
        }
        else 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4297);
tempMajorUnit = roundedMajorUnit;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4299);
if(!isNaN(tempMajorUnit))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4301);
return tempMajorUnit;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4303);
return roundingUnit;

    },

    /**
     * Calculates the maximum and minimum values for the `Axis`.
     *
     * @method _updateMinAndMax
     * @private 
     */
    _updateMinAndMax: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateMinAndMax", 4313);
_yuitest_coverline("build/charts-base/charts-base.js", 4315);
var data = this.get("data"),
            max, 
            min,
            len,
            num,
            i = 0,
            key,
            setMax = this.get("setMax"),
            setMin = this.get("setMin");
        _yuitest_coverline("build/charts-base/charts-base.js", 4324);
if(!setMax || !setMin)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4326);
if(data && data.length && data.length > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4328);
len = data.length;
                _yuitest_coverline("build/charts-base/charts-base.js", 4329);
for(; i < len; i++)
                {	
                    _yuitest_coverline("build/charts-base/charts-base.js", 4331);
num = data[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 4332);
if(isNaN(num))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4334);
if(Y_Lang.isObject(num))
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4336);
min = max = 0;
                            //hloc values
                            _yuitest_coverline("build/charts-base/charts-base.js", 4338);
for(key in num)
                            {
                               _yuitest_coverline("build/charts-base/charts-base.js", 4340);
if(num.hasOwnProperty(key))
                               {
                                    _yuitest_coverline("build/charts-base/charts-base.js", 4342);
max = Math.max(num[key], max);
                                    _yuitest_coverline("build/charts-base/charts-base.js", 4343);
min = Math.min(num[key], min);
                               }
                            }
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 4347);
max = setMax ? this._setMaximum : max;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4348);
min = setMin ? this._setMinimum : min;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4349);
continue;
                    }
                    
                    _yuitest_coverline("build/charts-base/charts-base.js", 4352);
if(setMin)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4354);
min = this._setMinimum;
                    }
                    else {_yuitest_coverline("build/charts-base/charts-base.js", 4356);
if(min === undefined)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4358);
min = num;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4362);
min = Math.min(num, min); 
                    }}
                    _yuitest_coverline("build/charts-base/charts-base.js", 4364);
if(setMax)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4366);
max = this._setMaximum;
                    }
                    else {_yuitest_coverline("build/charts-base/charts-base.js", 4368);
if(max === undefined)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4370);
max = num;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4374);
max = Math.max(num, max);
                    }}
                    
                    _yuitest_coverline("build/charts-base/charts-base.js", 4377);
this._actualMaximum = max;
                    _yuitest_coverline("build/charts-base/charts-base.js", 4378);
this._actualMinimum = min;
                }
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4381);
this._roundMinAndMax(min, max, setMin, setMax);
        }
    },

    /**
     * Rounds the mimimum and maximum values based on the `roundingUnit` attribute.
     *
     * @method _roundMinAndMax
     * @param {Number} min Minimum value
     * @param {Number} max Maximum value
     * @private
     */
    _roundMinAndMax: function(min, max, setMin, setMax)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_roundMinAndMax", 4393);
_yuitest_coverline("build/charts-base/charts-base.js", 4395);
var roundingUnit,
            minimumRange,
            minGreaterThanZero = min >= 0,
            maxGreaterThanZero = max > 0,
            dataRangeGreater,
            maxRound,
            minRound,
            topTicks,
            botTicks,
            tempMax,
            tempMin,
            units = this.getTotalMajorUnits() - 1,
            alwaysShowZero = this.get("alwaysShowZero"),
            roundingMethod = this.get("roundingMethod"),
            useIntegers = (max - min)/units >= 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 4410);
if(roundingMethod)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4412);
if(roundingMethod == "niceNumber")
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4414);
roundingUnit = this._getMinimumUnit(max, min, units);
                _yuitest_coverline("build/charts-base/charts-base.js", 4415);
if(minGreaterThanZero && maxGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4417);
if((alwaysShowZero || min < roundingUnit) && !setMin)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4419);
min = 0;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4420);
roundingUnit = this._getMinimumUnit(max, min, units);
                    }
                    else
                    {
                       _yuitest_coverline("build/charts-base/charts-base.js", 4424);
min = this._roundDownToNearest(min, roundingUnit);
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4426);
if(setMax)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4428);
if(!alwaysShowZero)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4430);
min = max - (roundingUnit * units);
                        }
                    }
                    else {_yuitest_coverline("build/charts-base/charts-base.js", 4433);
if(setMin)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4435);
max = min + (roundingUnit * units);
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4439);
max = this._roundUpToNearest(max, roundingUnit);
                    }}
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 4442);
if(maxGreaterThanZero && !minGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4444);
if(alwaysShowZero)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4446);
topTicks = Math.round(units/((-1 * min)/max + 1));
                        _yuitest_coverline("build/charts-base/charts-base.js", 4447);
topTicks = Math.max(Math.min(topTicks, units - 1), 1);
                        _yuitest_coverline("build/charts-base/charts-base.js", 4448);
botTicks = units - topTicks;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4449);
tempMax = Math.ceil( max/topTicks );
                        _yuitest_coverline("build/charts-base/charts-base.js", 4450);
tempMin = Math.floor( min/botTicks ) * -1;
                        
                        _yuitest_coverline("build/charts-base/charts-base.js", 4452);
if(setMin)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4454);
while(tempMin < tempMax && botTicks >= 0)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4456);
botTicks--;
                                _yuitest_coverline("build/charts-base/charts-base.js", 4457);
topTicks++;
                                _yuitest_coverline("build/charts-base/charts-base.js", 4458);
tempMax = Math.ceil( max/topTicks );
                                _yuitest_coverline("build/charts-base/charts-base.js", 4459);
tempMin = Math.floor( min/botTicks ) * -1;
                            }
                            //if there are any bottom ticks left calcualate the maximum by multiplying by the tempMin value
                            //if not, it's impossible to ensure that a zero is shown. skip it
                            _yuitest_coverline("build/charts-base/charts-base.js", 4463);
if(botTicks > 0)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4465);
max = tempMin * topTicks;
                            }
                            else
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4469);
max = min + (roundingUnit * units);
                            }
                        }
                        else {_yuitest_coverline("build/charts-base/charts-base.js", 4472);
if(setMax)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4474);
while(tempMax < tempMin && topTicks >= 0)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4476);
botTicks++;
                                _yuitest_coverline("build/charts-base/charts-base.js", 4477);
topTicks--;
                                _yuitest_coverline("build/charts-base/charts-base.js", 4478);
tempMin = Math.floor( min/botTicks ) * -1;
                                _yuitest_coverline("build/charts-base/charts-base.js", 4479);
tempMax = Math.ceil( max/topTicks );
                            }
                            //if there are any top ticks left calcualate the minimum by multiplying by the tempMax value
                            //if not, it's impossible to ensure that a zero is shown. skip it
                            _yuitest_coverline("build/charts-base/charts-base.js", 4483);
if(topTicks > 0)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4485);
min = tempMax * botTicks * -1;
                            }
                            else
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 4489);
min = max - (roundingUnit * units);
                            }
                        }
                        else
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4494);
roundingUnit = Math.max(tempMax, tempMin);
                            _yuitest_coverline("build/charts-base/charts-base.js", 4495);
roundingUnit = this._getNiceNumber(roundingUnit);  
                            _yuitest_coverline("build/charts-base/charts-base.js", 4496);
max = roundingUnit * topTicks;
                            _yuitest_coverline("build/charts-base/charts-base.js", 4497);
min = roundingUnit * botTicks * -1;
                        }}
                    }
                    else 
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4502);
if(setMax)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4504);
min = max - (roundingUnit * units);
                        }
                        else {_yuitest_coverline("build/charts-base/charts-base.js", 4506);
if(setMin)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4508);
max = min + (roundingUnit * units);
                        }
                        else
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4512);
min = this._roundDownToNearest(min, roundingUnit);
                            _yuitest_coverline("build/charts-base/charts-base.js", 4513);
max = this._roundUpToNearest(max, roundingUnit);
                        }}
                    }
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4519);
if(setMin)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4521);
if(alwaysShowZero)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4523);
max = 0;
                        }
                        else
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4527);
max = min + (roundingUnit * units);
                        }
                    }
                    else {_yuitest_coverline("build/charts-base/charts-base.js", 4530);
if(!setMax)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4532);
if(alwaysShowZero || max === 0 || max + roundingUnit > 0)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4534);
max = 0;
                            _yuitest_coverline("build/charts-base/charts-base.js", 4535);
roundingUnit = this._getMinimumUnit(max, min, units);
                            _yuitest_coverline("build/charts-base/charts-base.js", 4536);
min = max - (roundingUnit * units);
                        }
                        else
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4540);
min = this._roundDownToNearest(min, roundingUnit);
                            _yuitest_coverline("build/charts-base/charts-base.js", 4541);
max = this._roundUpToNearest(max, roundingUnit);
                        }
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4546);
min = max - (roundingUnit * units);
                    }}
                }}
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 4550);
if(roundingMethod == "auto") 
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4552);
if(minGreaterThanZero && maxGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4554);
if((alwaysShowZero || min < (max-min)/units) && !setMin)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4556);
min = 0;
                    }
                
                    _yuitest_coverline("build/charts-base/charts-base.js", 4559);
roundingUnit = (max - min)/units;
                    _yuitest_coverline("build/charts-base/charts-base.js", 4560);
if(useIntegers)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4562);
roundingUnit = Math.ceil(roundingUnit);
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4564);
max = min + (roundingUnit * units);
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 4566);
if(maxGreaterThanZero && !minGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4568);
if(alwaysShowZero)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4570);
topTicks = Math.round( units / ( (-1 * min) /max + 1) );
                        _yuitest_coverline("build/charts-base/charts-base.js", 4571);
topTicks = Math.max(Math.min(topTicks, units - 1), 1);
                        _yuitest_coverline("build/charts-base/charts-base.js", 4572);
botTicks = units - topTicks;

                        _yuitest_coverline("build/charts-base/charts-base.js", 4574);
if(useIntegers)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4576);
tempMax = Math.ceil( max/topTicks );
                            _yuitest_coverline("build/charts-base/charts-base.js", 4577);
tempMin = Math.floor( min/botTicks ) * -1;
                        }
                        else
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4581);
tempMax = max/topTicks;
                            _yuitest_coverline("build/charts-base/charts-base.js", 4582);
tempMin = min/botTicks * -1;
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 4584);
roundingUnit = Math.max(tempMax, tempMin);
                        _yuitest_coverline("build/charts-base/charts-base.js", 4585);
max = roundingUnit * topTicks;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4586);
min = roundingUnit * botTicks * -1;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4590);
roundingUnit = (max - min)/units;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4591);
if(useIntegers)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4593);
roundingUnit = Math.ceil(roundingUnit);
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 4595);
min = this._roundDownToNearest(min, roundingUnit);
                        _yuitest_coverline("build/charts-base/charts-base.js", 4596);
max = this._roundUpToNearest(max, roundingUnit);
                    }
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4601);
roundingUnit = (max - min)/units;
                    _yuitest_coverline("build/charts-base/charts-base.js", 4602);
if(useIntegers)
                    {   
                        _yuitest_coverline("build/charts-base/charts-base.js", 4604);
roundingUnit = Math.ceil(roundingUnit);
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4606);
if(alwaysShowZero || max === 0 || max + roundingUnit > 0)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4608);
max = 0;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4609);
roundingUnit = (max - min)/units;
                        _yuitest_coverline("build/charts-base/charts-base.js", 4610);
if(useIntegers)
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 4612);
Math.ceil(roundingUnit);
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 4614);
min = max - (roundingUnit * units);
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4618);
min = this._roundDownToNearest(min, roundingUnit);
                        _yuitest_coverline("build/charts-base/charts-base.js", 4619);
max = this._roundUpToNearest(max, roundingUnit);
                    }

                }}
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 4624);
if(!isNaN(roundingMethod) && isFinite(roundingMethod))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4626);
roundingUnit = roundingMethod;
                _yuitest_coverline("build/charts-base/charts-base.js", 4627);
minimumRange = roundingUnit * units;
                _yuitest_coverline("build/charts-base/charts-base.js", 4628);
dataRangeGreater = (max - min) > minimumRange;
                _yuitest_coverline("build/charts-base/charts-base.js", 4629);
minRound = this._roundDownToNearest(min, roundingUnit);
                _yuitest_coverline("build/charts-base/charts-base.js", 4630);
maxRound = this._roundUpToNearest(max, roundingUnit);
                _yuitest_coverline("build/charts-base/charts-base.js", 4631);
if(setMax)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4633);
min = max - minimumRange;
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 4635);
if(setMin)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4637);
max = min + minimumRange;
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 4639);
if(minGreaterThanZero && maxGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4641);
if(alwaysShowZero || minRound <= 0)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4643);
min = 0;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4647);
min = minRound;
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4649);
max = min + minimumRange;
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 4651);
if(maxGreaterThanZero && !minGreaterThanZero)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4653);
min = minRound;
                    _yuitest_coverline("build/charts-base/charts-base.js", 4654);
max = maxRound;
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4658);
if(alwaysShowZero || maxRound >= 0)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4660);
max = 0;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4664);
max = maxRound;
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4666);
min = max - minimumRange;
                }}}}
            }}}
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4670);
this._dataMaximum = max;
        _yuitest_coverline("build/charts-base/charts-base.js", 4671);
this._dataMinimum = min;
    },

    /**
     * Calculates and returns a value based on the number of labels and the index of
     * the current label.
     *
     * @method getLabelByIndex
     * @param {Number} i Index of the label.
     * @param {Number} l Total number of labels.
     * @return String
     */
    getLabelByIndex: function(i, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelByIndex", 4683);
_yuitest_coverline("build/charts-base/charts-base.js", 4685);
var min = this.get("minimum"),
            max = this.get("maximum"),
            increm = (max - min)/(l-1),
            label,
            roundingMethod = this.get("roundingMethod");
            _yuitest_coverline("build/charts-base/charts-base.js", 4690);
l -= 1;
        //respect the min and max. calculate all other labels.
        _yuitest_coverline("build/charts-base/charts-base.js", 4692);
if(i === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4694);
label = min;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 4696);
if(i === l)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4698);
label = max;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4702);
label = (i * increm);
            _yuitest_coverline("build/charts-base/charts-base.js", 4703);
if(roundingMethod == "niceNumber")
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4705);
label = this._roundToNearest(label, increm);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4707);
label += min;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 4709);
return parseFloat(label);
    },

    /**
     * Rounds a Number to the nearest multiple of an input. For example, by rounding
     * 16 to the nearest 10, you will receive 20. Similar to the built-in function Math.round().
     *
     * @method _roundToNearest
     * @param {Number} number Number to round
     * @param {Number} nearest Multiple to round towards.
     * @return Number
     * @private
     */
    _roundToNearest: function(number, nearest)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_roundToNearest", 4722);
_yuitest_coverline("build/charts-base/charts-base.js", 4724);
nearest = nearest || 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 4725);
if(nearest === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4727);
return number;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4729);
var roundedNumber = Math.round(this._roundToPrecision(number / nearest, 10)) * nearest;
        _yuitest_coverline("build/charts-base/charts-base.js", 4730);
return this._roundToPrecision(roundedNumber, 10);
    },
	
    /**
     * Rounds a Number up to the nearest multiple of an input. For example, by rounding
     * 16 up to the nearest 10, you will receive 20. Similar to the built-in function Math.ceil().
     *
     * @method _roundUpToNearest
     * @param {Number} number Number to round
     * @param {Number} nearest Multiple to round towards.
     * @return Number
     * @private
     */
    _roundUpToNearest: function(number, nearest)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_roundUpToNearest", 4743);
_yuitest_coverline("build/charts-base/charts-base.js", 4745);
nearest = nearest || 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 4746);
if(nearest === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4748);
return number;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4750);
return Math.ceil(this._roundToPrecision(number / nearest, 10)) * nearest;
    },
	
    /**
     * Rounds a Number down to the nearest multiple of an input. For example, by rounding
     * 16 down to the nearest 10, you will receive 10. Similar to the built-in function Math.floor().
     *
     * @method _roundDownToNearest
     * @param {Number} number Number to round
     * @param {Number} nearest Multiple to round towards.
     * @return Number
     * @private
     */
    _roundDownToNearest: function(number, nearest)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_roundDownToNearest", 4763);
_yuitest_coverline("build/charts-base/charts-base.js", 4765);
nearest = nearest || 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 4766);
if(nearest === 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4768);
return number;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4770);
return Math.floor(this._roundToPrecision(number / nearest, 10)) * nearest;
    },

    /**
     * Rounds a number to a certain level of precision. Useful for limiting the number of
     * decimal places on a fractional number.
     *
     * @method _roundToPrecision
     * @param {Number} number Number to round
     * @param {Number} precision Multiple to round towards.
     * @return Number
     * @private
     */
    _roundToPrecision: function(number, precision)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_roundToPrecision", 4783);
_yuitest_coverline("build/charts-base/charts-base.js", 4785);
precision = precision || 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 4786);
var decimalPlaces = Math.pow(10, precision);
        _yuitest_coverline("build/charts-base/charts-base.js", 4787);
return Math.round(decimalPlaces * number) / decimalPlaces;
    },
    
    /**
     * Checks to see if data extends beyond the range of the axis. If so,
     * that data will need to be hidden. This method is internal, temporary and subject
     * to removal in the future.
     *
     * @method _hasDataOverflow
     * @protected
     * @return Boolean
     */
    _hasDataOverflow: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_hasDataOverflow", 4799);
_yuitest_coverline("build/charts-base/charts-base.js", 4801);
var roundingMethod,
            min,
            max;
        _yuitest_coverline("build/charts-base/charts-base.js", 4804);
if(this.get("setMin") || this.get("setMax"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4806);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4808);
roundingMethod = this.get("roundingMethod");
        _yuitest_coverline("build/charts-base/charts-base.js", 4809);
min = this._actualMinimum;
        _yuitest_coverline("build/charts-base/charts-base.js", 4810);
max = this._actualMaximum;
        _yuitest_coverline("build/charts-base/charts-base.js", 4811);
if(Y_Lang.isNumber(roundingMethod) && ((Y_Lang.isNumber(max) && max > this._dataMaximum) || (Y_Lang.isNumber(min) && min < this._dataMinimum)))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4813);
return true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4815);
return false;
    }
});

_yuitest_coverline("build/charts-base/charts-base.js", 4819);
Y.NumericAxis = NumericAxis;
		
/**
 * StackedAxis manages stacked numeric data on an axis.
 *
 * @module charts
 * @submodule charts-base
 * @class StackedAxis
 * @constructor
 * @param {Object} config (optional) Configuration parameters for the Chart.
 * @extends NumericAxis
 */
_yuitest_coverline("build/charts-base/charts-base.js", 4831);
function StackedAxis(config)
{
	_yuitest_coverfunc("build/charts-base/charts-base.js", "StackedAxis", 4831);
_yuitest_coverline("build/charts-base/charts-base.js", 4833);
StackedAxis.superclass.constructor.apply(this, arguments);
}

_yuitest_coverline("build/charts-base/charts-base.js", 4836);
StackedAxis.NAME = "stackedAxis";


_yuitest_coverline("build/charts-base/charts-base.js", 4839);
Y.extend(StackedAxis, Y.NumericAxis,
{
    /**
     * Calculates the maximum and minimum values for the `Axis`.
     *
     * @method _updateMinAndMax
     * @private 
     */
    _updateMinAndMax: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateMinAndMax", 4847);
_yuitest_coverline("build/charts-base/charts-base.js", 4849);
var max = 0,
            min = 0,
            pos = 0,
            neg = 0,
            len = 0,
            i = 0,
            key,
            num,
            keys = this.get("keys"),
            setMin = this.get("setMin"),
            setMax = this.get("setMax");

        _yuitest_coverline("build/charts-base/charts-base.js", 4861);
for(key in keys)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4863);
if(keys.hasOwnProperty(key))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4865);
len = Math.max(len, keys[key].length);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4868);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4870);
pos = 0;
            _yuitest_coverline("build/charts-base/charts-base.js", 4871);
neg = 0;
            _yuitest_coverline("build/charts-base/charts-base.js", 4872);
for(key in keys)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4874);
if(keys.hasOwnProperty(key))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 4876);
num = keys[key][i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 4877);
if(isNaN(num))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4879);
continue;
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 4881);
if(num >= 0)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4883);
pos += num;
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 4887);
neg += num;
                    }
                }
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4891);
if(pos > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4893);
max = Math.max(max, pos);
            }
            else 
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4897);
max = Math.max(max, neg);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4899);
if(neg < 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4901);
min = Math.min(min, neg);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4905);
min = Math.min(min, pos);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4908);
this._actualMaximum = max;
        _yuitest_coverline("build/charts-base/charts-base.js", 4909);
this._actualMinimum = min;
        _yuitest_coverline("build/charts-base/charts-base.js", 4910);
if(setMax)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4912);
max = this._setMaximum;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4914);
if(setMin)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 4916);
min = this._setMinimum;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 4918);
this._roundMinAndMax(min, max, setMin, setMax);
    }
});

_yuitest_coverline("build/charts-base/charts-base.js", 4922);
Y.StackedAxis = StackedAxis;
		
/**
 * TimeAxis manages time data on an axis.
 *
 * @module charts
 * @submodule charts-base
 * @class TimeAxis
 * @constructor
 * @param {Object} config (optional) Configuration parameters for the Chart.
 * @extends AxisType
 */
_yuitest_coverline("build/charts-base/charts-base.js", 4934);
function TimeAxis(config)
{
	_yuitest_coverfunc("build/charts-base/charts-base.js", "TimeAxis", 4934);
_yuitest_coverline("build/charts-base/charts-base.js", 4936);
TimeAxis.superclass.constructor.apply(this, arguments);
}

_yuitest_coverline("build/charts-base/charts-base.js", 4939);
TimeAxis.NAME = "timeAxis";

_yuitest_coverline("build/charts-base/charts-base.js", 4941);
TimeAxis.ATTRS = 
{
    /**
     * Indicates whether the maximum is calculated or explicitly set. 
     *
     * @attribute setMax
     * @readOnly
     * @type Boolean
     * @private
     */
    setMax: {
        readOnly: true,

        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4954);
_yuitest_coverline("build/charts-base/charts-base.js", 4956);
var max = this._getNumber(this._setMaximum);
            _yuitest_coverline("build/charts-base/charts-base.js", 4957);
return (Y_Lang.isNumber(max));
        }
    },

    /**
     * Indicates whether the minimum is calculated or explicitly set. 
     *
     * @attribute setMin
     * @readOnly
     * @type Boolean
     * @private
     */
    setMin: {
        readOnly: true,

        getter: function()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4972);
_yuitest_coverline("build/charts-base/charts-base.js", 4974);
var min = this._getNumber(this._setMinimum);
            _yuitest_coverline("build/charts-base/charts-base.js", 4975);
return (Y_Lang.isNumber(min));
        }
    },

    /**
     * The maximum value that will appear on an axis. Unless explicitly set, this value is calculated by the `Axis`.
     *
     * @attribute maximum
     * @type Number
     */
    maximum: {
        getter: function ()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 4986);
_yuitest_coverline("build/charts-base/charts-base.js", 4988);
var max = this._getNumber(this._setMaximum);
            _yuitest_coverline("build/charts-base/charts-base.js", 4989);
if(!Y_Lang.isNumber(max))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 4991);
max = this._getNumber(this.get("dataMaximum"));
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 4993);
return parseFloat(max);
        },
        setter: function (value)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 4995);
_yuitest_coverline("build/charts-base/charts-base.js", 4997);
this._setMaximum = this._getNumber(value);
            _yuitest_coverline("build/charts-base/charts-base.js", 4998);
return value;
        }
    },

    /**
     * The minimum value that will appear on an axis. Unless explicitly set, this value is calculated by the `Axis`.
     *
     * @attribute minimum
     * @type Number
     */
    minimum: {
        getter: function ()
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 5009);
_yuitest_coverline("build/charts-base/charts-base.js", 5011);
var min = this._getNumber(this._setMinimum);
            _yuitest_coverline("build/charts-base/charts-base.js", 5012);
if(!Y_Lang.isNumber(min)) 
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5014);
min = this._getNumber(this.get("dataMinimum"));
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 5016);
return parseFloat(min);
        },
        setter: function (value)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 5018);
_yuitest_coverline("build/charts-base/charts-base.js", 5020);
this._setMinimum = this._getNumber(value);
            _yuitest_coverline("build/charts-base/charts-base.js", 5021);
return value;
        }
    },

    /**
     * Method used for formatting a label. This attribute allows for the default label formatting method to overridden. The method use would need
     * to implement the arguments below and return a `String` or an `HTMLElement`. The default implementation of the method returns a `String`. The output of this method
     * will be rendered to the DOM using `appendChild`. If you override the `labelFunction` method and return an html string, you will also need to override the Axis' 
     * `appendLabelFunction` to accept html as a `String`.
     * <dl>
     *      <dt>val</dt><dd>Label to be formatted. (`String`)</dd>
     *      <dt>format</dt><dd>STRFTime string used to format the label. (optional)</dd>
     * </dl>
     *
     * @attribute labelFunction
     * @type Function
     */
    labelFunction: {
        value: function(val, format)
        {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "value", 5039);
_yuitest_coverline("build/charts-base/charts-base.js", 5041);
val = Y.DataType.Date.parse(val);
            _yuitest_coverline("build/charts-base/charts-base.js", 5042);
if(format)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5044);
return Y.DataType.Date.format(val, {format:format});
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 5046);
return val;
        }
    },

    /**
     * Pattern used by the `labelFunction` to format a label.
     *
     * @attribute labelFormat
     * @type String
     */
    labelFormat: {
        value: "%b %d, %y"
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 5061);
Y.extend(TimeAxis, Y.AxisType, {
    /**
     * Formats a label based on the axis type and optionally specified format.
     *
     * @method formatLabel
     * @param {Object} value
     * @param {Object} format Pattern used to format the value.
     * @return String
     */
    formatLabel: function(val, format)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "formatLabel", 5070);
_yuitest_coverline("build/charts-base/charts-base.js", 5072);
val = Y.DataType.Date.parse(val);
        _yuitest_coverline("build/charts-base/charts-base.js", 5073);
if(format)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5075);
return Y.DataType.Date.format(val, {format:format});
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5077);
return val;
    },

    /**
     * Constant used to generate unique id.
     *
     * @property GUID
     * @type String
     * @private
     */
    GUID: "yuitimeaxis",
	
    /**
     * Type of data used in `Axis`.
     *
     * @property _dataType
     * @readOnly
     * @private
     */
    _dataType: "time",
	
    /**
     * Calculates and returns a value based on the number of labels and the index of
     * the current label.
     *
     * @method getLabelByIndex
     * @param {Number} i Index of the label.
     * @param {Number} l Total number of labels.
     * @return String
     */
    getLabelByIndex: function(i, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelByIndex", 5107);
_yuitest_coverline("build/charts-base/charts-base.js", 5109);
var min = this.get("minimum"),
            max = this.get("maximum"),
            position = this.get("position"),
            increm,
            label;
            _yuitest_coverline("build/charts-base/charts-base.js", 5114);
l -= 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 5115);
increm = ((max - min)/l) * i;
        _yuitest_coverline("build/charts-base/charts-base.js", 5116);
if(position == "bottom" || position == "top")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5118);
label = min + increm;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5122);
label = max - increm;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5124);
return label;
    },

    /**
     * Gets an array of values based on a key.
     *
     * @method _getKeyArray
     * @param {String} key Value key associated with the data array.
     * @param {Array} data Array in which the data resides.
     * @return Array
     * @private
     */
    _getKeyArray: function(key, data)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getKeyArray", 5136);
_yuitest_coverline("build/charts-base/charts-base.js", 5138);
var obj,
            keyArray = [],
            i = 0,
            val,
            len = data.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5143);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5145);
obj = data[i][key];
            _yuitest_coverline("build/charts-base/charts-base.js", 5146);
if(Y_Lang.isDate(obj))
            {   
                _yuitest_coverline("build/charts-base/charts-base.js", 5148);
val = obj.valueOf();
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5152);
val = new Date(obj);
                _yuitest_coverline("build/charts-base/charts-base.js", 5153);
if(Y_Lang.isDate(val))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5155);
val = val.valueOf();
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 5157);
if(!Y_Lang.isNumber(obj))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5159);
if(Y_Lang.isNumber(parseFloat(obj)))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5161);
val = parseFloat(obj);
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5165);
if(typeof obj != "string")
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 5167);
obj = obj;
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 5169);
val = new Date(obj).valueOf();
                    }
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5174);
val = obj;
                }}
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 5177);
keyArray[i] = val;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5179);
return keyArray;
    },

    /**
     * Sets data by key
     *
     * @method _setDataByKey
     * @param {String} key Key value to use.
     * @param {Array} data Array to use.
     * @private 
     */
    _setDataByKey: function(key, data)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setDataByKey", 5190);
_yuitest_coverline("build/charts-base/charts-base.js", 5192);
var obj, 
            arr = [], 
            dv = this._dataClone.concat(), 
            i, 
            val,
            len = dv.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5198);
for(i = 0; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5200);
obj = dv[i][key];
            _yuitest_coverline("build/charts-base/charts-base.js", 5201);
if(Y_Lang.isDate(obj))
            {   
                _yuitest_coverline("build/charts-base/charts-base.js", 5203);
val = obj.valueOf();
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5207);
val = new Date(obj);
                _yuitest_coverline("build/charts-base/charts-base.js", 5208);
if(Y_Lang.isDate(val))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5210);
val = val.valueOf();
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 5212);
if(!Y_Lang.isNumber(obj))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5214);
if(Y_Lang.isNumber(parseFloat(obj)))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5216);
val = parseFloat(obj);
                    }
                    else
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5220);
if(typeof obj != "string")
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 5222);
obj = obj.toString();
                        }
                        _yuitest_coverline("build/charts-base/charts-base.js", 5224);
val = new Date(obj).valueOf();
                    }
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5229);
val = obj;
                }}
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 5232);
arr[i] = val;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5234);
this.get("keys")[key] = arr;
        _yuitest_coverline("build/charts-base/charts-base.js", 5235);
this._updateTotalDataFlag = true;
    },

    /**
     * Parses value into a number.
     *
     * @method _getNumber
     * @param val {Object} Value to parse into a number
     * @return Number
     * @private
     */
    _getNumber: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getNumber", 5246);
_yuitest_coverline("build/charts-base/charts-base.js", 5248);
if(Y_Lang.isDate(val))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5250);
val = val.valueOf();
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 5252);
if(!Y_Lang.isNumber(val) && val)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5254);
val = new Date(val).valueOf();
        }}

        _yuitest_coverline("build/charts-base/charts-base.js", 5257);
return val;
    }
});

_yuitest_coverline("build/charts-base/charts-base.js", 5261);
Y.TimeAxis = TimeAxis;
		
/**
 * CategoryAxis manages category data on an axis.
 *
 * @module charts
 * @submodule charts-base
 * @class CategoryAxis
 * @constructor
 * @param {Object} config (optional) Configuration parameters for the Chart.
 * @extends AxisType
 */
_yuitest_coverline("build/charts-base/charts-base.js", 5273);
function CategoryAxis(config)
{
	_yuitest_coverfunc("build/charts-base/charts-base.js", "CategoryAxis", 5273);
_yuitest_coverline("build/charts-base/charts-base.js", 5275);
CategoryAxis.superclass.constructor.apply(this, arguments);
}

_yuitest_coverline("build/charts-base/charts-base.js", 5278);
CategoryAxis.NAME = "categoryAxis";

_yuitest_coverline("build/charts-base/charts-base.js", 5280);
Y.extend(CategoryAxis, Y.AxisType,
{
    /**
     * Formats a label based on the axis type and optionally specified format.
     *
     * @method formatLabel
     * @param {Object} value
     * @param {Object} format Pattern used to format the value.
     * @return String
     */
    formatLabel: function(val, format)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "formatLabel", 5290);
_yuitest_coverline("build/charts-base/charts-base.js", 5292);
return val;
    },

    /**
     * Object storing key data.
     *
     * @property _indices
     * @private
     */
    _indices: null,

    /**
     * Constant used to generate unique id.
     *
     * @property GUID
     * @type String
     * @private
     */
    GUID: "yuicategoryaxis",

    /**
     * Type of data used in `Axis`.
     *
     * @property _dataType
     * @readOnly
     * @private
     */
    _type: "category",
        
    /**
     * Calculates the maximum and minimum values for the `Axis`.
     *
     * @method _updateMinAndMax
     * @private 
     */
    _updateMinAndMax: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateMinAndMax", 5327);
_yuitest_coverline("build/charts-base/charts-base.js", 5329);
this._dataMaximum = Math.max(this.get("data").length - 1, 0);
        _yuitest_coverline("build/charts-base/charts-base.js", 5330);
this._dataMinimum = 0;
    },

    /**
     * Gets an array of values based on a key.
     *
     * @method _getKeyArray
     * @param {String} key Value key associated with the data array.
     * @param {Array} data Array in which the data resides.
     * @return Array
     * @private
     */
    _getKeyArray: function(key, data)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getKeyArray", 5342);
_yuitest_coverline("build/charts-base/charts-base.js", 5344);
var i = 0,
            obj,
            keyArr = [],
            labels = [],
            len = data.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5349);
if(!this._indices)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5351);
this._indices = {};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5353);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5355);
obj = data[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 5356);
keyArr[i] = i;
            _yuitest_coverline("build/charts-base/charts-base.js", 5357);
labels[i] = obj[key];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5359);
this._indices[key] = keyArr;
        _yuitest_coverline("build/charts-base/charts-base.js", 5360);
return labels;
    },

    /**
     * Sets data by key
     *
     * @method _setDataByKey
     * @param {String} key Key value to use.
     * @param {Array} data Array to use.
     * @private 
     */
    _setDataByKey: function(key)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setDataByKey", 5371);
_yuitest_coverline("build/charts-base/charts-base.js", 5373);
var i,
            obj, 
            arr = [], 
            labels = [], 
            dv = this._dataClone.concat(), 
            len = dv.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5379);
if(!this._indices)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5381);
this._indices = {};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5383);
for(i = 0; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5385);
obj = dv[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 5386);
arr[i] = i;
            _yuitest_coverline("build/charts-base/charts-base.js", 5387);
labels[i] = obj[key];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5389);
this._indices[key] = arr;
        _yuitest_coverline("build/charts-base/charts-base.js", 5390);
this.get("keys")[key] = labels.concat();
        _yuitest_coverline("build/charts-base/charts-base.js", 5391);
this._updateTotalDataFlag = true;
    },

    /**
     * Returns an array of values based on an identifier key.
     *
     * @method getDataByKey
     * @param {String} value value used to identify the array
     * @return Array
     */
    getDataByKey: function (value)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getDataByKey", 5401);
_yuitest_coverline("build/charts-base/charts-base.js", 5403);
if(!this._indices)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5405);
this.get("keys");
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5407);
var keys = this._indices;
        _yuitest_coverline("build/charts-base/charts-base.js", 5408);
if(keys[value])
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5410);
return keys[value];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5412);
return null;
    },

    /**
     * Returns the total number of majorUnits that will appear on an axis.
     *
     * @method getTotalMajorUnits
     * @param {Object} majorUnit Object containing properties related to the majorUnit.
     * @param {Number} len Length of the axis.
     * @return Number
     */
    getTotalMajorUnits: function(majorUnit, len)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getTotalMajorUnits", 5423);
_yuitest_coverline("build/charts-base/charts-base.js", 5425);
return this.get("data").length;
    },
    
    /**
     * Returns the distance between major units on an axis.
     *
     * @method getMajorUnitDistance
     * @param {Number} len Number of ticks
     * @param {Number} uiLen Size of the axis.
     * @param {Object} majorUnit Hash of properties used to determine the majorUnit
     * @return Number
     */
    getMajorUnitDistance: function(len, uiLen, majorUnit)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMajorUnitDistance", 5437);
_yuitest_coverline("build/charts-base/charts-base.js", 5439);
var dist;
        _yuitest_coverline("build/charts-base/charts-base.js", 5440);
if(majorUnit.determinant === "count")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5442);
dist = uiLen/len;
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 5444);
if(majorUnit.determinant === "distance")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5446);
dist = majorUnit.distance;
        }}
        _yuitest_coverline("build/charts-base/charts-base.js", 5448);
return dist;
    },
   
    /**
     * Gets the distance that the first and last ticks are offset from there respective
     * edges.
     *
     * @method getEdgeOffset
     * @param {Number} ct Number of ticks on the axis.
     * @param {Number} l Length (in pixels) of the axis.
     * @return Number
     */
    getEdgeOffset: function(ct, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getEdgeOffset", 5460);
_yuitest_coverline("build/charts-base/charts-base.js", 5462);
return l/ct;
    },

    /**
     * Returns a value based of a key value and an index.
     *
     * @method getKeyValueAt
     * @param {String} key value used to look up the correct array
     * @param {Number} index within the array
     * @return String 
     */
    getKeyValueAt: function(key, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getKeyValueAt", 5473);
_yuitest_coverline("build/charts-base/charts-base.js", 5475);
var value = NaN,
            keys = this.get("keys");
        _yuitest_coverline("build/charts-base/charts-base.js", 5477);
if(keys[key] && keys[key][index]) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5479);
value = keys[key][index];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5481);
return value;
    },
   
    /**
     * Calculates and returns a value based on the number of labels and the index of
     * the current label.
     *
     * @method getLabelByIndex
     * @param {Number} i Index of the label.
     * @param {Number} l Total number of labels.
     * @return String
     */
    getLabelByIndex: function(i, l)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getLabelByIndex", 5493);
_yuitest_coverline("build/charts-base/charts-base.js", 5495);
var label,
            data = this.get("data"),
            position = this.get("position");
        _yuitest_coverline("build/charts-base/charts-base.js", 5498);
if(position == "bottom" || position == "top")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5500);
label = data[i];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5504);
label = data[l - (i + 1)];
        }   
        _yuitest_coverline("build/charts-base/charts-base.js", 5506);
return label;
    },

    /**
     * Returns a string corresponding to the first label on an 
     * axis.
     *
     * @method getMinimumValue
     * @return String
     */
    getMinimumValue: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMinimumValue", 5516);
_yuitest_coverline("build/charts-base/charts-base.js", 5518);
var data = this.get("data"),
            label = data[0];
        _yuitest_coverline("build/charts-base/charts-base.js", 5520);
return label;
    },

    /**
     * Returns a string corresponding to the last label on an 
     * axis.
     *
     * @method getMaximumValue
     * @return String
     */
    getMaximumValue: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMaximumValue", 5530);
_yuitest_coverline("build/charts-base/charts-base.js", 5532);
var data = this.get("data"),
            len = data.length - 1,
            label = data[len];
        _yuitest_coverline("build/charts-base/charts-base.js", 5535);
return label;
    }
});

_yuitest_coverline("build/charts-base/charts-base.js", 5539);
Y.CategoryAxis = CategoryAxis;
		
/**
 * Utility class used for calculating curve points.
 *
 * @module charts
 * @submodule charts-base
 * @class CurveUtil
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 5549);
function CurveUtil()
{
}

_yuitest_coverline("build/charts-base/charts-base.js", 5553);
CurveUtil.prototype = {
    /**
     * Creates an array of start, end and control points for splines.
     *
     * @method getCurveControlPoints
     * @param {Array} xcoords Collection of x-coordinates used for calculate the curves
     * @param {Array} ycoords Collection of y-coordinates used for calculate the curves
     * @return Object
     * @protected
     */
    getCurveControlPoints: function(xcoords, ycoords) 
    {
		_yuitest_coverfunc("build/charts-base/charts-base.js", "getCurveControlPoints", 5563);
_yuitest_coverline("build/charts-base/charts-base.js", 5565);
var outpoints = [],
            i = 1,
            l = xcoords.length - 1,
		    xvals = [],
		    yvals = [];
		
		
		// Too few points, need at least two
		_yuitest_coverline("build/charts-base/charts-base.js", 5573);
if (l < 1) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5575);
return null;
		} 
        
        _yuitest_coverline("build/charts-base/charts-base.js", 5578);
outpoints[0] = {
            startx: xcoords[0], 
            starty: ycoords[0],
            endx: xcoords[1],
            endy: ycoords[1]
        };
        
		// Special case, the Bezier should be a straight line
        _yuitest_coverline("build/charts-base/charts-base.js", 5586);
if (l === 1) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5588);
outpoints[0].ctrlx1 = (2.0*xcoords[0] + xcoords[1])/3.0;  
			_yuitest_coverline("build/charts-base/charts-base.js", 5589);
outpoints[0].ctrly2 = (2.0*ycoords[0] + ycoords[1])/3.0;
			_yuitest_coverline("build/charts-base/charts-base.js", 5590);
outpoints[0].ctrlx2 = 2.0*outpoints[0].ctrlx1 - xcoords[0];
            _yuitest_coverline("build/charts-base/charts-base.js", 5591);
outpoints[0].ctrly2 = 2.0*outpoints[0].ctrly1 - ycoords[0];
            _yuitest_coverline("build/charts-base/charts-base.js", 5592);
return outpoints;
		}

		_yuitest_coverline("build/charts-base/charts-base.js", 5595);
for (; i < l; ++i) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5597);
outpoints.push({startx: Math.round(xcoords[i]), starty: Math.round(ycoords[i]), endx: Math.round(xcoords[i+1]), endy: Math.round(ycoords[i+1])});
			_yuitest_coverline("build/charts-base/charts-base.js", 5598);
xvals[i] = 4.0 * xcoords[i] + 2*xcoords[i+1];
			_yuitest_coverline("build/charts-base/charts-base.js", 5599);
yvals[i] = 4.0*ycoords[i] + 2*ycoords[i+1];
		}
		
		_yuitest_coverline("build/charts-base/charts-base.js", 5602);
xvals[0] = xcoords[0] + (2.0 * xcoords[1]);
		_yuitest_coverline("build/charts-base/charts-base.js", 5603);
xvals[l-1] = (8.0 * xcoords[l-1] + xcoords[l]) / 2.0;
		_yuitest_coverline("build/charts-base/charts-base.js", 5604);
xvals = this.getControlPoints(xvals.concat());
        _yuitest_coverline("build/charts-base/charts-base.js", 5605);
yvals[0] = ycoords[0] + (2.0 * ycoords[1]);
		_yuitest_coverline("build/charts-base/charts-base.js", 5606);
yvals[l-1] = (8.0 * ycoords[l-1] + ycoords[l]) / 2.0;	
		_yuitest_coverline("build/charts-base/charts-base.js", 5607);
yvals = this.getControlPoints(yvals.concat());
		
        _yuitest_coverline("build/charts-base/charts-base.js", 5609);
for (i = 0; i < l; ++i) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5611);
outpoints[i].ctrlx1 = Math.round(xvals[i]);
            _yuitest_coverline("build/charts-base/charts-base.js", 5612);
outpoints[i].ctrly1 = Math.round(yvals[i]);
			
			_yuitest_coverline("build/charts-base/charts-base.js", 5614);
if (i < l-1) 
            {
				_yuitest_coverline("build/charts-base/charts-base.js", 5616);
outpoints[i].ctrlx2 = Math.round(2*xcoords[i+1] - xvals[i+1]);
                _yuitest_coverline("build/charts-base/charts-base.js", 5617);
outpoints[i].ctrly2 = Math.round(2*ycoords[i+1] - yvals[i+1]);
			}
			else 
            {
				_yuitest_coverline("build/charts-base/charts-base.js", 5621);
outpoints[i].ctrlx2 = Math.round((xcoords[l] + xvals[l-1])/2);
                _yuitest_coverline("build/charts-base/charts-base.js", 5622);
outpoints[i].ctrly2 = Math.round((ycoords[l] + yvals[l-1])/2);
			}
		}
		
		_yuitest_coverline("build/charts-base/charts-base.js", 5626);
return outpoints;	
	},

    /**
     * Gets the control points for the curve.
     *
     * @method getControlPoints
     * @param {Array} vals Collection of values coords used to generate control points.
     * @return Array
     * @private
     */
	getControlPoints: function(vals) 
    {
		_yuitest_coverfunc("build/charts-base/charts-base.js", "getControlPoints", 5637);
_yuitest_coverline("build/charts-base/charts-base.js", 5639);
var l = vals.length,
            x = [],
            tmp = [],
            b = 2.0,
            i = 1;
		_yuitest_coverline("build/charts-base/charts-base.js", 5644);
x[0] = vals[0] / b;
		_yuitest_coverline("build/charts-base/charts-base.js", 5645);
for (; i < l; ++i) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5647);
tmp[i] = 1/b;
			_yuitest_coverline("build/charts-base/charts-base.js", 5648);
b = (i < l-1 ? 4.0 : 3.5) - tmp[i];
			_yuitest_coverline("build/charts-base/charts-base.js", 5649);
x[i] = (vals[i] - x[i-1]) / b;
		}
		
		_yuitest_coverline("build/charts-base/charts-base.js", 5652);
for (i = 1; i < l; ++i) 
        {
			_yuitest_coverline("build/charts-base/charts-base.js", 5654);
x[l-i-1] -= tmp[l-i] * x[l-i];
		}
		
		_yuitest_coverline("build/charts-base/charts-base.js", 5657);
return x;
	}
};
_yuitest_coverline("build/charts-base/charts-base.js", 5660);
Y.CurveUtil = CurveUtil;
/**
 * Utility class used for creating stacked series.
 *
 * @module charts
 * @submodule charts-base
 * @class StackingUtil
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 5669);
function StackingUtil(){}

_yuitest_coverline("build/charts-base/charts-base.js", 5671);
StackingUtil.prototype = {
    /**
     * Indicates whether the series is stacked.
     *
     * @property _stacked
     * @private
     */
    _stacked: true,

    /**
     * @protected
     *
     * Adjusts coordinate values for stacked series.
     *
     * @method _stackCoordinates
     */
    _stackCoordinates: function() 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_stackCoordinates", 5687);
_yuitest_coverline("build/charts-base/charts-base.js", 5689);
if(this.get("direction") == "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5691);
this._stackXCoords();
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5695);
this._stackYCoords();
        }
    },

    /**
     * Stacks coordinates for a stacked vertical series.
     *
     * @method _stackXCoords
     * @protected
     */
    _stackXCoords: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_stackXCoords", 5705);
_yuitest_coverline("build/charts-base/charts-base.js", 5707);
var order = this.get("order"),
            type = this.get("type"),
            graph = this.get("graph"),
            seriesCollection = graph.seriesTypes[type],
            i = 0,
            xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            len,
            coord,
            prevCoord,
            prevOrder,
            stackedXCoords = xcoords.concat(),
            prevXCoords,
            prevYCoords,
            nullIndices = [],
            nullIndex;
        _yuitest_coverline("build/charts-base/charts-base.js", 5723);
if(order > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5725);
prevXCoords = seriesCollection[order - 1].get("stackedXCoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 5726);
prevYCoords = seriesCollection[order - 1].get("stackedYCoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 5727);
len = prevXCoords.length;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5731);
len = xcoords.length;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5733);
for(; i < len; i = i + 1)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5735);
if(Y_Lang.isNumber(xcoords[i]))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5737);
if(order > 0)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5739);
prevCoord = prevXCoords[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 5740);
if(!Y_Lang.isNumber(prevCoord))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5742);
prevOrder = order;
                        _yuitest_coverline("build/charts-base/charts-base.js", 5743);
while(prevOrder >  - 1 && !Y_Lang.isNumber(prevCoord))
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 5745);
prevOrder = prevOrder - 1;
                            _yuitest_coverline("build/charts-base/charts-base.js", 5746);
if(prevOrder > -1)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 5748);
prevCoord = seriesCollection[prevOrder].get("stackedXCoords")[i];
                            }
                            else
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 5752);
prevCoord = this._leftOrigin;
                            }
                        }
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 5756);
xcoords[i] = xcoords[i] + prevCoord;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 5758);
stackedXCoords[i] = xcoords[i];
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5762);
nullIndices.push(i);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5765);
this._cleanXNaN(stackedXCoords, ycoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 5766);
len = nullIndices.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5767);
if(len > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5769);
for(i = 0; i < len; i = i + 1)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5771);
nullIndex = nullIndices[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 5772);
coord = order > 0 ? prevXCoords[nullIndex] : this._leftOrigin;
                _yuitest_coverline("build/charts-base/charts-base.js", 5773);
stackedXCoords[nullIndex] =  Math.max(stackedXCoords[nullIndex], coord);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5776);
this.set("stackedXCoords", stackedXCoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 5777);
this.set("stackedYCoords", ycoords);
    },

    /**
     * Stacks coordinates for a stacked horizontal series.
     *
     * @method _stackYCoords
     * @protected
     */
    _stackYCoords: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_stackYCoords", 5786);
_yuitest_coverline("build/charts-base/charts-base.js", 5788);
var order = this.get("order"),
            type = this.get("type"),
            graph = this.get("graph"),
            h = graph.get("height"), 
            seriesCollection = graph.seriesTypes[type],
            i = 0,
            xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            len,
            coord,
            prevCoord,
            prevOrder,
            stackedYCoords = ycoords.concat(),
            prevXCoords,
            prevYCoords,
            nullIndices = [],
            nullIndex;
        _yuitest_coverline("build/charts-base/charts-base.js", 5805);
if(order > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5807);
prevXCoords = seriesCollection[order - 1].get("stackedXCoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 5808);
prevYCoords = seriesCollection[order - 1].get("stackedYCoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 5809);
len = prevYCoords.length;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5813);
len = ycoords.length;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5815);
for(; i < len; i = i + 1)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5817);
if(Y_Lang.isNumber(ycoords[i]))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5819);
if(order > 0)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 5821);
prevCoord = prevYCoords[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 5822);
if(!Y_Lang.isNumber(prevCoord))
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 5824);
prevOrder = order;
                        _yuitest_coverline("build/charts-base/charts-base.js", 5825);
while(prevOrder >  - 1 && !Y_Lang.isNumber(prevCoord))
                        {
                            _yuitest_coverline("build/charts-base/charts-base.js", 5827);
prevOrder = prevOrder - 1;
                            _yuitest_coverline("build/charts-base/charts-base.js", 5828);
if(prevOrder > -1)
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 5830);
prevCoord = seriesCollection[prevOrder].get("stackedYCoords")[i];
                            }
                            else
                            {
                                _yuitest_coverline("build/charts-base/charts-base.js", 5834);
prevCoord = this._bottomOrigin;
                            }
                        }
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 5838);
ycoords[i] = prevCoord - (h - ycoords[i]);
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 5840);
stackedYCoords[i] = ycoords[i];
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5844);
nullIndices.push(i);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5847);
this._cleanYNaN(xcoords, stackedYCoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 5848);
len = nullIndices.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5849);
if(len > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5851);
for(i = 0; i < len; i = i + 1)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5853);
nullIndex = nullIndices[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 5854);
coord = order > 0 ? prevYCoords[nullIndex] : h;
                _yuitest_coverline("build/charts-base/charts-base.js", 5855);
stackedYCoords[nullIndex] =  Math.min(stackedYCoords[nullIndex], coord);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5858);
this.set("stackedXCoords", xcoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 5859);
this.set("stackedYCoords", stackedYCoords);
    },

    /**
     * Cleans invalid x-coordinates by calculating their value based on the corresponding y-coordinate, the previous valid x-coordinate with its 
     * corresponding y-coordinate and the next valid x-coordinate with its corresponding y-coordinate. If there is no previous or next valid x-coordinate,
     * the value will not be altered.
     *
     * @method _cleanXNaN
     * @param {Array} xcoords An array of x-coordinate values
     * @param {Array} ycoords An arry of y-coordinate values
     * @private
     */
    _cleanXNaN: function(xcoords, ycoords)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_cleanXNaN", 5872);
_yuitest_coverline("build/charts-base/charts-base.js", 5874);
var previousValidIndex,
            nextValidIndex,
            previousValidX,
            previousValidY,
            x,
            y,
            nextValidX,
            nextValidY,
            isNumber = Y_Lang.isNumber,
            m,
            i = 0,
            len = ycoords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5886);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5888);
x = xcoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 5889);
y = ycoords[i];
            //if x is invalid, calculate where it should be
            _yuitest_coverline("build/charts-base/charts-base.js", 5891);
if(!isNumber(x) && i > 0 && i < len - 1)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 5893);
previousValidY = ycoords[i - 1];
                //check to see if the previous value is valid
                _yuitest_coverline("build/charts-base/charts-base.js", 5895);
previousValidX = this._getPreviousValidCoordValue(xcoords, i);
                _yuitest_coverline("build/charts-base/charts-base.js", 5896);
nextValidY = ycoords[i + 1];
                _yuitest_coverline("build/charts-base/charts-base.js", 5897);
nextValidX = this._getNextValidCoordValue(xcoords, i);
                //check to see if the next value is valid
                _yuitest_coverline("build/charts-base/charts-base.js", 5899);
if(isNumber(previousValidX) && isNumber(nextValidX))
                {
                    //calculate slope and solve for x
                    _yuitest_coverline("build/charts-base/charts-base.js", 5902);
m = (nextValidY - previousValidY) / (nextValidX - previousValidX);
                    _yuitest_coverline("build/charts-base/charts-base.js", 5903);
xcoords[i] = (y + (m * previousValidX) - previousValidY)/m;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 5905);
previousValidIndex = NaN;
                _yuitest_coverline("build/charts-base/charts-base.js", 5906);
nextValidIndex = NaN;
            }
        }
    },

    /**
     * Returns the previous valid (numeric) value in an array if available.
     *
     * @method _getPreviousValidCoordValue
     * @param {Array} coords Array of values
     * @param {Number} index The index in the array in which to begin searching.
     * @return Number
     * @private
     */
    _getPreviousValidCoordValue: function(coords, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getPreviousValidCoordValue", 5920);
_yuitest_coverline("build/charts-base/charts-base.js", 5922);
var coord,
            isNumber = Y_Lang.isNumber,
            limit = -1;
        _yuitest_coverline("build/charts-base/charts-base.js", 5925);
while(!isNumber(coord) && index > limit)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5927);
index = index - 1;
            _yuitest_coverline("build/charts-base/charts-base.js", 5928);
coord = coords[index];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5930);
return coord;
    },

    /**
     * Returns the next valid (numeric) value in an array if available.
     *
     * @method _getNextValidCoordValue
     * @param {Array} coords Array of values
     * @param {Number} index The index in the array in which to begin searching.
     * @return Number
     * @private
     */
    _getNextValidCoordValue: function(coords, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getNextValidCoordValue", 5942);
_yuitest_coverline("build/charts-base/charts-base.js", 5944);
var coord,
            isNumber = Y_Lang.isNumber,
            limit = coords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5947);
while(!isNumber(coord) && index < limit)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5949);
index = index + 1;
            _yuitest_coverline("build/charts-base/charts-base.js", 5950);
coord = coords[index];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 5952);
return coord;
    },

    /**
     * Cleans invalid y-coordinates by calculating their value based on the corresponding x-coordinate, the previous valid y-coordinate with its 
     * corresponding x-coordinate and the next valid y-coordinate with its corresponding x-coordinate. If there is no previous or next valid y-coordinate,
     * the value will not be altered.
     *
     * @method _cleanYNaN
     * @param {Array} xcoords An array of x-coordinate values
     * @param {Array} ycoords An arry of y-coordinate values
     * @private
     */
    _cleanYNaN: function(xcoords, ycoords)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_cleanYNaN", 5965);
_yuitest_coverline("build/charts-base/charts-base.js", 5967);
var previousValidIndex,
            nextValidIndex,
            previousValidX,
            previousValidY,
            x,
            y,
            nextValidX,
            nextValidY,
            isNumber = Y_Lang.isNumber,
            m,
            i = 0,
            len = xcoords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 5979);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 5981);
x = xcoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 5982);
y = ycoords[i];
            //if y is invalid, calculate where it should be
            _yuitest_coverline("build/charts-base/charts-base.js", 5984);
if(!isNumber(y) && i > 0 && i < len - 1)
            {
                //check to see if the previous value is valid
                _yuitest_coverline("build/charts-base/charts-base.js", 5987);
previousValidX = xcoords[i - 1];
                _yuitest_coverline("build/charts-base/charts-base.js", 5988);
previousValidY = this._getPreviousValidCoordValue(ycoords, i);
                //check to see if the next value is valid
                _yuitest_coverline("build/charts-base/charts-base.js", 5990);
nextValidX = xcoords[i + 1];
                _yuitest_coverline("build/charts-base/charts-base.js", 5991);
nextValidY = this._getNextValidCoordValue(ycoords, i);
                _yuitest_coverline("build/charts-base/charts-base.js", 5992);
if(isNumber(previousValidY) && isNumber(nextValidY))
                {
                    //calculate slope and solve for y
                    _yuitest_coverline("build/charts-base/charts-base.js", 5995);
m = (nextValidY - previousValidY) / (nextValidX - previousValidX);
                    _yuitest_coverline("build/charts-base/charts-base.js", 5996);
ycoords[i] = previousValidY + ((m * x) - (m * previousValidX));
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 5998);
previousValidIndex = NaN;
                _yuitest_coverline("build/charts-base/charts-base.js", 5999);
nextValidIndex = NaN;
            }
        }
    }
};
_yuitest_coverline("build/charts-base/charts-base.js", 6004);
Y.StackingUtil = StackingUtil;
/**
 * Utility class used for drawing lines.
 *
 * @module charts
 * @submodule charts-base
 * @class Lines
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 6013);
function Lines(){}

_yuitest_coverline("build/charts-base/charts-base.js", 6015);
Lines.prototype = {
    /**
     * @property _lineDefaults
     * @type Object
     * @private
     */
    _lineDefaults: null,
    
    /**
     * Creates a graphic in which to draw a series.
     *
     * @method _getGraphic
     * @return Graphic
     * @private
     */
    _getGraphic: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getGraphic", 6030);
_yuitest_coverline("build/charts-base/charts-base.js", 6032);
var graphic = this.get("graphic") || this.get("graph").get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 6033);
if(!this._lineGraphic)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6035);
this._lineGraphic = graphic.addShape({type: "path"});
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6037);
this._lineGraphic.clear();
        _yuitest_coverline("build/charts-base/charts-base.js", 6038);
return this._lineGraphic;
    },
    
    /**
     * Toggles visibility
     *
     * @method _toggleVisible
     * @param {Boolean} visible indicates visibilitye
     * @private
     */
    _toggleVisible: function(visible)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_toggleVisible", 6048);
_yuitest_coverline("build/charts-base/charts-base.js", 6050);
if(this._lineGraphic)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6052);
this._lineGraphic.set("visible", visible);
        }
    },

    /**
     * Draws lines for the series.
     *
     * @method drawLines
     * @protected
     */
    drawLines: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawLines", 6062);
_yuitest_coverline("build/charts-base/charts-base.js", 6064);
if(this.get("xcoords").length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6066);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6068);
var isNumber = Y_Lang.isNumber,
            xcoords,
            ycoords,
            direction = this.get("direction"),
            len,
            lastPointValid,
            pointValid,
            noPointsRendered = true,
            lastValidX,
            lastValidY,
            nextX,
            nextY,
            i,
            styles = this.get("styles").line,
            lineType = styles.lineType,
            lc = styles.color || this._getDefaultColor(this.get("graphOrder"), "line"),
            lineAlpha = styles.alpha,
            dashLength = styles.dashLength,
            gapSpace = styles.gapSpace,
            connectDiscontinuousPoints = styles.connectDiscontinuousPoints,
            discontinuousType = styles.discontinuousType,
            discontinuousDashLength = styles.discontinuousDashLength,
            discontinuousGapSpace = styles.discontinuousGapSpace,
            path = this._getGraphic();
        _yuitest_coverline("build/charts-base/charts-base.js", 6092);
if(this._stacked)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6094);
xcoords = this.get("stackedXCoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 6095);
ycoords = this.get("stackedYCoords");
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6099);
xcoords = this.get("xcoords");
            _yuitest_coverline("build/charts-base/charts-base.js", 6100);
ycoords = this.get("ycoords");
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6102);
len = direction === "vertical" ? ycoords.length : xcoords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 6103);
path.set("stroke", {
            weight: styles.weight, 
            color: lc, 
            opacity: lineAlpha
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 6108);
for(i = 0; i < len; i = ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6110);
nextX = xcoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 6111);
nextY = ycoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 6112);
pointValid = isNumber(nextX) && isNumber(nextY); 
            _yuitest_coverline("build/charts-base/charts-base.js", 6113);
if(!pointValid)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6115);
lastPointValid = pointValid;
                _yuitest_coverline("build/charts-base/charts-base.js", 6116);
continue;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6118);
if(noPointsRendered)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6120);
noPointsRendered = false;
                _yuitest_coverline("build/charts-base/charts-base.js", 6121);
path.moveTo(nextX, nextY);
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 6123);
if(lastPointValid)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6125);
if(lineType != "dashed")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6127);
path.lineTo(nextX, nextY);
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6131);
this.drawDashedLine(path, lastValidX, lastValidY, nextX, nextY, 
                                                dashLength, 
                                                gapSpace);
                }
            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 6136);
if(!connectDiscontinuousPoints)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6138);
path.moveTo(nextX, nextY);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6142);
if(discontinuousType != "solid")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6144);
this.drawDashedLine(path, lastValidX, lastValidY, nextX, nextY, 
                                                discontinuousDashLength, 
                                                discontinuousGapSpace);
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6150);
path.lineTo(nextX, nextY);
                }
            }}}
            _yuitest_coverline("build/charts-base/charts-base.js", 6153);
lastValidX = nextX;
            _yuitest_coverline("build/charts-base/charts-base.js", 6154);
lastValidY = nextY;
            _yuitest_coverline("build/charts-base/charts-base.js", 6155);
lastPointValid = true;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6157);
path.end();
    },
    
    /**
     * Connects data points with a consistent curve for a series.
     * 
     * @method drawSpline
     * @protected
     */
    drawSpline: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSpline", 6166);
_yuitest_coverline("build/charts-base/charts-base.js", 6168);
if(this.get("xcoords").length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6170);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6172);
var xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            curvecoords = this.getCurveControlPoints(xcoords, ycoords),
            len = curvecoords.length,
            cx1,
            cx2,
            cy1,
            cy2,
            x,
            y,
            i = 0,
            styles = this.get("styles").line,
            path = this._getGraphic(),
            lineAlpha = styles.alpha,
            color = styles.color || this._getDefaultColor(this.get("graphOrder"), "line");
        _yuitest_coverline("build/charts-base/charts-base.js", 6187);
path.set("stroke", { 
            weight: styles.weight, 
            color: color, 
            opacity: lineAlpha
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 6192);
path.moveTo(xcoords[0], ycoords[0]);
        _yuitest_coverline("build/charts-base/charts-base.js", 6193);
for(; i < len; i = ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6195);
x = curvecoords[i].endx;
            _yuitest_coverline("build/charts-base/charts-base.js", 6196);
y = curvecoords[i].endy;
            _yuitest_coverline("build/charts-base/charts-base.js", 6197);
cx1 = curvecoords[i].ctrlx1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6198);
cx2 = curvecoords[i].ctrlx2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6199);
cy1 = curvecoords[i].ctrly1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6200);
cy2 = curvecoords[i].ctrly2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6201);
path.curveTo(cx1, cy1, cx2, cy2, x, y);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6203);
path.end();
    },

    /**
     * Draws a dashed line between two points.
     * 
     * @method drawDashedLine
     * @param {Number} xStart	The x position of the start of the line
     * @param {Number} yStart	The y position of the start of the line
     * @param {Number} xEnd		The x position of the end of the line
     * @param {Number} yEnd		The y position of the end of the line
     * @param {Number} dashSize	the size of dashes, in pixels
     * @param {Number} gapSize	the size of gaps between dashes, in pixels
     * @private
     */
    drawDashedLine: function(path, xStart, yStart, xEnd, yEnd, dashSize, gapSize)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawDashedLine", 6218);
_yuitest_coverline("build/charts-base/charts-base.js", 6220);
dashSize = dashSize || 10;
        _yuitest_coverline("build/charts-base/charts-base.js", 6221);
gapSize = gapSize || 10;
        _yuitest_coverline("build/charts-base/charts-base.js", 6222);
var segmentLength = dashSize + gapSize,
            xDelta = xEnd - xStart,
            yDelta = yEnd - yStart,
            delta = Math.sqrt(Math.pow(xDelta, 2) + Math.pow(yDelta, 2)),
            segmentCount = Math.floor(Math.abs(delta / segmentLength)),
            radians = Math.atan2(yDelta, xDelta),
            xCurrent = xStart,
            yCurrent = yStart,
            i;
        _yuitest_coverline("build/charts-base/charts-base.js", 6231);
xDelta = Math.cos(radians) * segmentLength;
        _yuitest_coverline("build/charts-base/charts-base.js", 6232);
yDelta = Math.sin(radians) * segmentLength;
        
        _yuitest_coverline("build/charts-base/charts-base.js", 6234);
for(i = 0; i < segmentCount; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6236);
path.moveTo(xCurrent, yCurrent);
            _yuitest_coverline("build/charts-base/charts-base.js", 6237);
path.lineTo(xCurrent + Math.cos(radians) * dashSize, yCurrent + Math.sin(radians) * dashSize);
            _yuitest_coverline("build/charts-base/charts-base.js", 6238);
xCurrent += xDelta;
            _yuitest_coverline("build/charts-base/charts-base.js", 6239);
yCurrent += yDelta;
        }
        
        _yuitest_coverline("build/charts-base/charts-base.js", 6242);
path.moveTo(xCurrent, yCurrent);
        _yuitest_coverline("build/charts-base/charts-base.js", 6243);
delta = Math.sqrt((xEnd - xCurrent) * (xEnd - xCurrent) + (yEnd - yCurrent) * (yEnd - yCurrent));
        
        _yuitest_coverline("build/charts-base/charts-base.js", 6245);
if(delta > dashSize)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6247);
path.lineTo(xCurrent + Math.cos(radians) * dashSize, yCurrent + Math.sin(radians) * dashSize);
        }
        else {_yuitest_coverline("build/charts-base/charts-base.js", 6249);
if(delta > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6251);
path.lineTo(xCurrent + Math.cos(radians) * delta, yCurrent + Math.sin(radians) * delta);
        }}
        
        _yuitest_coverline("build/charts-base/charts-base.js", 6254);
path.moveTo(xEnd, yEnd);
    },

    /**
     * Default values for `styles` attribute.
     *
     * @method _getLineDefaults
     * @return Object
     * @protected
     */
    _getLineDefaults: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getLineDefaults", 6264);
_yuitest_coverline("build/charts-base/charts-base.js", 6266);
return {
            alpha: 1,
            weight: 6,
            lineType:"solid", 
            dashLength:10, 
            gapSpace:10, 
            connectDiscontinuousPoints:true, 
            discontinuousType:"solid", 
            discontinuousDashLength:10, 
            discontinuousGapSpace:10
        };
    }
};
_yuitest_coverline("build/charts-base/charts-base.js", 6279);
Y.augment(Lines, Y.Attribute);
_yuitest_coverline("build/charts-base/charts-base.js", 6280);
Y.Lines = Lines;
/**
 * Utility class used for drawing area fills.
 *
 * @module charts
 * @class Fills
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 6288);
function Fills(cfg)
{
    _yuitest_coverfunc("build/charts-base/charts-base.js", "Fills", 6288);
_yuitest_coverline("build/charts-base/charts-base.js", 6290);
var attrs = {
        area: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 6292);
_yuitest_coverline("build/charts-base/charts-base.js", 6294);
return this._defaults || this._getAreaDefaults();
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 6297);
_yuitest_coverline("build/charts-base/charts-base.js", 6299);
var defaults = this._defaults || this._getAreaDefaults();
                _yuitest_coverline("build/charts-base/charts-base.js", 6300);
this._defaults = Y.merge(defaults, val);
            }
        }
    };
    _yuitest_coverline("build/charts-base/charts-base.js", 6304);
this.addAttrs(attrs, cfg);
    _yuitest_coverline("build/charts-base/charts-base.js", 6305);
this.get("styles");
}

_yuitest_coverline("build/charts-base/charts-base.js", 6308);
Fills.prototype = {
    /**
     * Returns a path shape used for drawing fills.
     *
     * @method _getPath
     * @return Path
     * @private
     */
    _getPath: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getPath", 6316);
_yuitest_coverline("build/charts-base/charts-base.js", 6318);
var path = this._path;
        _yuitest_coverline("build/charts-base/charts-base.js", 6319);
if(!path)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6321);
path = this.get("graph").get("graphic").addShape({type:"path"});
            _yuitest_coverline("build/charts-base/charts-base.js", 6322);
this._path = path;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6324);
return path;
    },
    
    /**
     * Toggles visibility
     *
     * @method _toggleVisible
     * @param {Boolean} visible indicates visibilitye
     * @private
     */
    _toggleVisible: function(visible)
    {   
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_toggleVisible", 6334);
_yuitest_coverline("build/charts-base/charts-base.js", 6336);
if(this._path)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6338);
this._path.set("visible", visible);
        }
    },

    /**
     * Draws fill
     *
     * @method drawFill
     * @param {Array} xcoords The x-coordinates for the series.
     * @param {Array} ycoords The y-coordinates for the series.
     * @protected
     */
    drawFill: function(xcoords, ycoords)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawFill", 6350);
_yuitest_coverline("build/charts-base/charts-base.js", 6352);
if(xcoords.length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6354);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6356);
var isNumber = Y_Lang.isNumber,
            len = xcoords.length,
            firstX = xcoords[0],
            firstY = ycoords[0],
            lastValidX = firstX,
            lastValidY = firstY,
            nextX,
            nextY,
            pointValid,
            noPointsRendered = true,
            i = 0,
            styles = this.get("styles").area,
            path = this._getPath(),
            color = styles.color || this._getDefaultColor(this.get("graphOrder"), "slice");
        _yuitest_coverline("build/charts-base/charts-base.js", 6370);
path.clear();
        _yuitest_coverline("build/charts-base/charts-base.js", 6371);
path.set("fill", {
            color: color, 
            opacity: styles.alpha
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 6375);
path.set("stroke", {weight: 0});
        _yuitest_coverline("build/charts-base/charts-base.js", 6376);
for(; i < len; i = ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6378);
nextX = xcoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 6379);
nextY = ycoords[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 6380);
pointValid = isNumber(nextX) && isNumber(nextY); 
            _yuitest_coverline("build/charts-base/charts-base.js", 6381);
if(!pointValid)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6383);
continue;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6385);
if(noPointsRendered)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6387);
this._firstValidX = nextX;
                _yuitest_coverline("build/charts-base/charts-base.js", 6388);
this._firstValidY = nextY;
                _yuitest_coverline("build/charts-base/charts-base.js", 6389);
noPointsRendered = false;
                _yuitest_coverline("build/charts-base/charts-base.js", 6390);
path.moveTo(nextX, nextY);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6394);
path.lineTo(nextX, nextY);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6396);
lastValidX = nextX;
            _yuitest_coverline("build/charts-base/charts-base.js", 6397);
lastValidY = nextY;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6399);
this._lastValidX = lastValidX;
        _yuitest_coverline("build/charts-base/charts-base.js", 6400);
this._lastValidY = lastValidY;
        _yuitest_coverline("build/charts-base/charts-base.js", 6401);
path.end();
    },
	
    /**
     * Draws a fill for a spline
     *
     * @method drawAreaSpline
     * @protected
     */
    drawAreaSpline: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawAreaSpline", 6410);
_yuitest_coverline("build/charts-base/charts-base.js", 6412);
if(this.get("xcoords").length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6414);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6416);
var xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            curvecoords = this.getCurveControlPoints(xcoords, ycoords),
            len = curvecoords.length,
            cx1,
            cx2,
            cy1,
            cy2,
            x,
            y,
            i = 0,
            firstX = xcoords[0],
            firstY = ycoords[0],
            styles = this.get("styles").area,
            path = this._getPath(),
            color = styles.color || this._getDefaultColor(this.get("graphOrder"), "slice");
        _yuitest_coverline("build/charts-base/charts-base.js", 6432);
path.set("fill", {
            color: color, 
            opacity: styles.alpha
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 6436);
path.set("stroke", {weight: 0});
        _yuitest_coverline("build/charts-base/charts-base.js", 6437);
path.moveTo(firstX, firstY);
        _yuitest_coverline("build/charts-base/charts-base.js", 6438);
for(; i < len; i = ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6440);
x = curvecoords[i].endx;
            _yuitest_coverline("build/charts-base/charts-base.js", 6441);
y = curvecoords[i].endy;
            _yuitest_coverline("build/charts-base/charts-base.js", 6442);
cx1 = curvecoords[i].ctrlx1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6443);
cx2 = curvecoords[i].ctrlx2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6444);
cy1 = curvecoords[i].ctrly1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6445);
cy2 = curvecoords[i].ctrly2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6446);
path.curveTo(cx1, cy1, cx2, cy2, x, y);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6448);
if(this.get("direction") === "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6450);
path.lineTo(this._leftOrigin, y);
            _yuitest_coverline("build/charts-base/charts-base.js", 6451);
path.lineTo(this._leftOrigin, firstY);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6455);
path.lineTo(x, this._bottomOrigin);
            _yuitest_coverline("build/charts-base/charts-base.js", 6456);
path.lineTo(firstX, this._bottomOrigin);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6458);
path.lineTo(firstX, firstY);
        _yuitest_coverline("build/charts-base/charts-base.js", 6459);
path.end();
    },
    
    /**
     * Draws a a stacked area spline
     *
     * @method drawStackedAreaSpline
     * @protected
     */
    drawStackedAreaSpline: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawStackedAreaSpline", 6468);
_yuitest_coverline("build/charts-base/charts-base.js", 6470);
if(this.get("xcoords").length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6472);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6474);
var xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            curvecoords,
            order = this.get("order"),
            type = this.get("type"),
            graph = this.get("graph"),
            seriesCollection = graph.seriesTypes[type],
            prevXCoords,
            prevYCoords,
            len,
            cx1,
            cx2,
            cy1,
            cy2,
            x,
            y,
            i = 0,
            firstX,
            firstY,
            styles = this.get("styles").area,
            path = this._getPath(),
            color = styles.color || this._getDefaultColor(this.get("graphOrder"), "slice");
        _yuitest_coverline("build/charts-base/charts-base.js", 6496);
firstX = xcoords[0];
        _yuitest_coverline("build/charts-base/charts-base.js", 6497);
firstY = ycoords[0];
        _yuitest_coverline("build/charts-base/charts-base.js", 6498);
curvecoords = this.getCurveControlPoints(xcoords, ycoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 6499);
len = curvecoords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 6500);
path.set("fill", {
            color: color, 
            opacity: styles.alpha
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 6504);
path.set("stroke", {weight: 0});
        _yuitest_coverline("build/charts-base/charts-base.js", 6505);
path.moveTo(firstX, firstY);
        _yuitest_coverline("build/charts-base/charts-base.js", 6506);
for(; i < len; i = ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6508);
x = curvecoords[i].endx;
            _yuitest_coverline("build/charts-base/charts-base.js", 6509);
y = curvecoords[i].endy;
            _yuitest_coverline("build/charts-base/charts-base.js", 6510);
cx1 = curvecoords[i].ctrlx1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6511);
cx2 = curvecoords[i].ctrlx2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6512);
cy1 = curvecoords[i].ctrly1;
            _yuitest_coverline("build/charts-base/charts-base.js", 6513);
cy2 = curvecoords[i].ctrly2;
            _yuitest_coverline("build/charts-base/charts-base.js", 6514);
path.curveTo(cx1, cy1, cx2, cy2, x, y);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6516);
if(order > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6518);
prevXCoords = seriesCollection[order - 1].get("xcoords").concat().reverse();
            _yuitest_coverline("build/charts-base/charts-base.js", 6519);
prevYCoords = seriesCollection[order - 1].get("ycoords").concat().reverse();
            _yuitest_coverline("build/charts-base/charts-base.js", 6520);
curvecoords = this.getCurveControlPoints(prevXCoords, prevYCoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6521);
i = 0;
            _yuitest_coverline("build/charts-base/charts-base.js", 6522);
len = curvecoords.length;
            _yuitest_coverline("build/charts-base/charts-base.js", 6523);
path.lineTo(prevXCoords[0], prevYCoords[0]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6524);
for(; i < len; i = ++i)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6526);
x = curvecoords[i].endx;
                _yuitest_coverline("build/charts-base/charts-base.js", 6527);
y = curvecoords[i].endy;
                _yuitest_coverline("build/charts-base/charts-base.js", 6528);
cx1 = curvecoords[i].ctrlx1;
                _yuitest_coverline("build/charts-base/charts-base.js", 6529);
cx2 = curvecoords[i].ctrlx2;
                _yuitest_coverline("build/charts-base/charts-base.js", 6530);
cy1 = curvecoords[i].ctrly1;
                _yuitest_coverline("build/charts-base/charts-base.js", 6531);
cy2 = curvecoords[i].ctrly2;
                _yuitest_coverline("build/charts-base/charts-base.js", 6532);
path.curveTo(cx1, cy1, cx2, cy2, x, y);
            }
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6537);
if(this.get("direction") === "vertical")
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6539);
path.lineTo(this._leftOrigin, ycoords[ycoords.length-1]);
                _yuitest_coverline("build/charts-base/charts-base.js", 6540);
path.lineTo(this._leftOrigin, firstY);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6544);
path.lineTo(xcoords[xcoords.length-1], this._bottomOrigin);
                _yuitest_coverline("build/charts-base/charts-base.js", 6545);
path.lineTo(firstX, this._bottomOrigin);
            }

        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6549);
path.lineTo(firstX, firstY);
        _yuitest_coverline("build/charts-base/charts-base.js", 6550);
path.end();
    },
    
    /**
     * Storage for default area styles.
     *
     * @property _defaults
     * @type Object
     * @private
     */
    _defaults: null,

    /**
     * Concatenates coordinate array with correct coordinates for closing an area fill.
     *
     * @method _getClosingPoints
     * @return Array
     * @protected
     */
    _getClosingPoints: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getClosingPoints", 6569);
_yuitest_coverline("build/charts-base/charts-base.js", 6571);
var xcoords = this.get("xcoords").concat(),
            ycoords = this.get("ycoords").concat(),
            firstValidIndex,
            lastValidIndex;
        _yuitest_coverline("build/charts-base/charts-base.js", 6575);
if(this.get("direction") === "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6577);
lastValidIndex = this._getLastValidIndex(xcoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6578);
firstValidIndex = this._getFirstValidIndex(xcoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6579);
ycoords.push(ycoords[lastValidIndex]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6580);
ycoords.push(ycoords[firstValidIndex]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6581);
xcoords.push(this._leftOrigin);
            _yuitest_coverline("build/charts-base/charts-base.js", 6582);
xcoords.push(this._leftOrigin);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6586);
lastValidIndex = this._getLastValidIndex(ycoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6587);
firstValidIndex = this._getFirstValidIndex(ycoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6588);
xcoords.push(xcoords[lastValidIndex]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6589);
xcoords.push(xcoords[firstValidIndex]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6590);
ycoords.push(this._bottomOrigin);
            _yuitest_coverline("build/charts-base/charts-base.js", 6591);
ycoords.push(this._bottomOrigin);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6593);
xcoords.push(xcoords[0]);
        _yuitest_coverline("build/charts-base/charts-base.js", 6594);
ycoords.push(ycoords[0]);
        _yuitest_coverline("build/charts-base/charts-base.js", 6595);
return [xcoords, ycoords];
    },

    /**
     * Returns the order of the series closest to the current series that has a valid value for the current index.
     *
     * @method _getHighestValidOrder
     * @param {Array} seriesCollection Array of series of a given type.
     * @param {Number} index Index of the series item.
     * @param {Number} order Index of the the series in the seriesCollection
     * @param {String} direction Indicates the direction of the series
     * @return Number
     * @private
     */
    _getHighestValidOrder: function(seriesCollection, index, order, direction)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getHighestValidOrder", 6609);
_yuitest_coverline("build/charts-base/charts-base.js", 6611);
var coords = direction == "vertical" ? "stackedXCoords" : "stackedYCoords",
            coord;
        _yuitest_coverline("build/charts-base/charts-base.js", 6613);
while(isNaN(coord) && order > -1)
        {
          _yuitest_coverline("build/charts-base/charts-base.js", 6615);
order = order - 1;
          _yuitest_coverline("build/charts-base/charts-base.js", 6616);
if(order > -1)
          {
            _yuitest_coverline("build/charts-base/charts-base.js", 6618);
coord = seriesCollection[order].get(coords)[index];
          }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6621);
return order;
    },
    
    /**
     * Returns an array containing the x and y coordinates for a given series and index.
     *
     * @method _getCoordsByOrderAndIndex
     * @param {Array} seriesCollection Array of series of a given type.
     * @param {Number} index Index of the series item.
     * @param {Number} order Index of the the series in the seriesCollection
     * @param {String} direction Indicates the direction of the series
     * @return Array
     * @private
     */
    _getCoordsByOrderAndIndex: function(seriesCollection, index, order, direction)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getCoordsByOrderAndIndex", 6635);
_yuitest_coverline("build/charts-base/charts-base.js", 6637);
var xcoord,
            ycoord;
        _yuitest_coverline("build/charts-base/charts-base.js", 6639);
if(direction == "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6641);
xcoord = order < 0 ? this._leftOrigin : seriesCollection[order].get("stackedXCoords")[index];
            _yuitest_coverline("build/charts-base/charts-base.js", 6642);
ycoord = this.get("stackedYCoords")[index];
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6646);
xcoord = this.get("stackedXCoords")[index];
            _yuitest_coverline("build/charts-base/charts-base.js", 6647);
ycoord = order < 0 ? this._bottomOrigin : seriesCollection[order].get("stackedYCoords")[index];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6649);
return [xcoord, ycoord];
    },
    
    /**
     * Concatenates coordinate array with the correct coordinates for closing an area stack.
     *
     * @method _getStackedClosingPoints
     * @return Array
     * @protected
     */
    _getStackedClosingPoints: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getStackedClosingPoints", 6659);
_yuitest_coverline("build/charts-base/charts-base.js", 6661);
var order = this.get("order"),
            type = this.get("type"),
            graph = this.get("graph"),
            direction = this.get("direction"),
            seriesCollection = graph.seriesTypes[type],
            firstValidIndex,
            lastValidIndex,
            xcoords = this.get("stackedXCoords"),
            ycoords = this.get("stackedYCoords"),
            limit,
            previousSeries,
            previousSeriesFirstValidIndex,
            previousSeriesLastValidIndex,
            previousXCoords,
            previousYCoords,
            coords,
            closingXCoords,
            closingYCoords,
            currentIndex,
            highestValidOrder,
            oldOrder;
        _yuitest_coverline("build/charts-base/charts-base.js", 6682);
if(order < 1)
        {    
          _yuitest_coverline("build/charts-base/charts-base.js", 6684);
return this._getClosingPoints();
        }
        
        _yuitest_coverline("build/charts-base/charts-base.js", 6687);
previousSeries = seriesCollection[order - 1];
        _yuitest_coverline("build/charts-base/charts-base.js", 6688);
previousXCoords = previousSeries.get("stackedXCoords").concat();
        _yuitest_coverline("build/charts-base/charts-base.js", 6689);
previousYCoords = previousSeries.get("stackedYCoords").concat();
        _yuitest_coverline("build/charts-base/charts-base.js", 6690);
if(direction == "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6692);
firstValidIndex = this._getFirstValidIndex(xcoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6693);
lastValidIndex = this._getLastValidIndex(xcoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6694);
previousSeriesFirstValidIndex = previousSeries._getFirstValidIndex(previousXCoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6695);
previousSeriesLastValidIndex = previousSeries._getLastValidIndex(previousXCoords);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6699);
firstValidIndex = this._getFirstValidIndex(ycoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6700);
lastValidIndex = this._getLastValidIndex(ycoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6701);
previousSeriesFirstValidIndex = previousSeries._getFirstValidIndex(previousYCoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6702);
previousSeriesLastValidIndex = previousSeries._getLastValidIndex(previousYCoords);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6704);
if(previousSeriesLastValidIndex >= firstValidIndex && previousSeriesFirstValidIndex <= lastValidIndex)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6706);
previousSeriesFirstValidIndex = Math.max(firstValidIndex, previousSeriesFirstValidIndex);
            _yuitest_coverline("build/charts-base/charts-base.js", 6707);
previousSeriesLastValidIndex = Math.min(lastValidIndex, previousSeriesLastValidIndex);
            _yuitest_coverline("build/charts-base/charts-base.js", 6708);
previousXCoords = previousXCoords.slice(previousSeriesFirstValidIndex, previousSeriesLastValidIndex + 1);
            _yuitest_coverline("build/charts-base/charts-base.js", 6709);
previousYCoords = previousYCoords.slice(previousSeriesFirstValidIndex, previousSeriesLastValidIndex + 1);
            _yuitest_coverline("build/charts-base/charts-base.js", 6710);
limit = previousSeriesFirstValidIndex;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6714);
limit = lastValidIndex;
        }

        _yuitest_coverline("build/charts-base/charts-base.js", 6717);
closingXCoords = [xcoords[firstValidIndex]];
        _yuitest_coverline("build/charts-base/charts-base.js", 6718);
closingYCoords = [ycoords[firstValidIndex]];
        _yuitest_coverline("build/charts-base/charts-base.js", 6719);
currentIndex = firstValidIndex;
        _yuitest_coverline("build/charts-base/charts-base.js", 6720);
while((isNaN(highestValidOrder) || highestValidOrder < order - 1) && currentIndex <= limit)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6722);
oldOrder = highestValidOrder;
            _yuitest_coverline("build/charts-base/charts-base.js", 6723);
highestValidOrder = this._getHighestValidOrder(seriesCollection, currentIndex, order, direction);
            _yuitest_coverline("build/charts-base/charts-base.js", 6724);
if(!isNaN(oldOrder) && highestValidOrder > oldOrder)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6726);
coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, oldOrder, direction);
                _yuitest_coverline("build/charts-base/charts-base.js", 6727);
closingXCoords.push(coords[0]);
                _yuitest_coverline("build/charts-base/charts-base.js", 6728);
closingYCoords.push(coords[1]);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6730);
coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, highestValidOrder, direction);
            _yuitest_coverline("build/charts-base/charts-base.js", 6731);
closingXCoords.push(coords[0]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6732);
closingYCoords.push(coords[1]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6733);
currentIndex = currentIndex + 1;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6735);
if(previousXCoords && previousXCoords.length > 0 && previousSeriesLastValidIndex > firstValidIndex && previousSeriesFirstValidIndex < lastValidIndex)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6737);
closingXCoords = closingXCoords.concat(previousXCoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6738);
closingYCoords = closingYCoords.concat(previousYCoords);
            _yuitest_coverline("build/charts-base/charts-base.js", 6739);
highestValidOrder = order -1; 
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6741);
currentIndex = Math.max(firstValidIndex, previousSeriesLastValidIndex);
        _yuitest_coverline("build/charts-base/charts-base.js", 6742);
order = order - 1;
        _yuitest_coverline("build/charts-base/charts-base.js", 6743);
highestValidOrder = NaN;
        _yuitest_coverline("build/charts-base/charts-base.js", 6744);
while(currentIndex <= lastValidIndex)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6746);
oldOrder = highestValidOrder;
            _yuitest_coverline("build/charts-base/charts-base.js", 6747);
highestValidOrder = this._getHighestValidOrder(seriesCollection, currentIndex, order, direction);
            _yuitest_coverline("build/charts-base/charts-base.js", 6748);
if(!isNaN(oldOrder))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6750);
if(highestValidOrder > oldOrder)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6752);
coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, oldOrder, direction);
                    _yuitest_coverline("build/charts-base/charts-base.js", 6753);
closingXCoords.push(coords[0]);
                    _yuitest_coverline("build/charts-base/charts-base.js", 6754);
closingYCoords.push(coords[1]);
                }
                else {_yuitest_coverline("build/charts-base/charts-base.js", 6756);
if(highestValidOrder < oldOrder)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 6758);
coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex - 1, highestValidOrder, direction);
                    _yuitest_coverline("build/charts-base/charts-base.js", 6759);
closingXCoords.push(coords[0]);
                    _yuitest_coverline("build/charts-base/charts-base.js", 6760);
closingYCoords.push(coords[1]);
                }}
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6763);
coords = this._getCoordsByOrderAndIndex(seriesCollection, currentIndex, highestValidOrder, direction);
            _yuitest_coverline("build/charts-base/charts-base.js", 6764);
closingXCoords.push(coords[0]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6765);
closingYCoords.push(coords[1]);
            _yuitest_coverline("build/charts-base/charts-base.js", 6766);
currentIndex = currentIndex + 1;
        }

        _yuitest_coverline("build/charts-base/charts-base.js", 6769);
closingXCoords.reverse();
        _yuitest_coverline("build/charts-base/charts-base.js", 6770);
closingYCoords.reverse();
        _yuitest_coverline("build/charts-base/charts-base.js", 6771);
return [xcoords.concat(closingXCoords), ycoords.concat(closingYCoords)];
    },

    /**
     * Returns default values for area styles.
     *
     * @method _getAreaDefaults
     * @return Object
     * @private
     */
    _getAreaDefaults: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getAreaDefaults", 6781);
_yuitest_coverline("build/charts-base/charts-base.js", 6783);
return {
        };
    }
};
_yuitest_coverline("build/charts-base/charts-base.js", 6787);
Y.augment(Fills, Y.Attribute);
_yuitest_coverline("build/charts-base/charts-base.js", 6788);
Y.Fills = Fills;
/**
 * Utility class used for drawing markers.
 *
 * @module charts
 * @submodule charts-base
 * @class Plots
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 6797);
function Plots(cfg)
{
    _yuitest_coverfunc("build/charts-base/charts-base.js", "Plots", 6797);
_yuitest_coverline("build/charts-base/charts-base.js", 6799);
var attrs = { 
        markers: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 6801);
_yuitest_coverline("build/charts-base/charts-base.js", 6803);
return this._markers;
            }
        }
    };
    _yuitest_coverline("build/charts-base/charts-base.js", 6807);
this.addAttrs(attrs, cfg);
}

_yuitest_coverline("build/charts-base/charts-base.js", 6810);
Plots.prototype = {
    /**
     * Storage for default marker styles.
     *
     * @property _plotDefaults
     * @type Object
     * @private
     */
    _plotDefaults: null,

    /**
     * Draws the markers
     *
     * @method drawPlots
     * @protected
     */
    drawPlots: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawPlots", 6826);
_yuitest_coverline("build/charts-base/charts-base.js", 6828);
if(!this.get("xcoords") || this.get("xcoords").length < 1) 
		{
			_yuitest_coverline("build/charts-base/charts-base.js", 6830);
return;
		}
        _yuitest_coverline("build/charts-base/charts-base.js", 6832);
var isNumber = Y_Lang.isNumber,
            style = Y.clone(this.get("styles").marker),
            w = style.width,
            h = style.height,
            xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            i = 0,
            len = xcoords.length,
            top = ycoords[0],
            left,
            marker,
            offsetWidth = w/2,
            offsetHeight = h/2,
            xvalues,
            yvalues,
            fillColors = null,
            borderColors = null,
            graphOrder = this.get("graphOrder"),
            groupMarkers = this.get("groupMarkers");
        _yuitest_coverline("build/charts-base/charts-base.js", 6851);
if(groupMarkers)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6853);
xvalues = [];
            _yuitest_coverline("build/charts-base/charts-base.js", 6854);
yvalues = [];
            _yuitest_coverline("build/charts-base/charts-base.js", 6855);
for(; i < len; ++i)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6857);
xvalues.push(parseFloat(xcoords[i] - offsetWidth));
                _yuitest_coverline("build/charts-base/charts-base.js", 6858);
yvalues.push(parseFloat(ycoords[i] - offsetHeight));
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6860);
this._createGroupMarker({
                xvalues: xvalues,
                yvalues: yvalues,
                fill: style.fill,
                border: style.border,
                dimensions: {
                    width: w,
                    height: h
                },
                graphOrder: graphOrder,
                shape: style.shape
            });
            _yuitest_coverline("build/charts-base/charts-base.js", 6872);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6874);
if(Y_Lang.isArray(style.fill.color))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6876);
fillColors = style.fill.color.concat(); 
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6878);
if(Y_Lang.isArray(style.border.color))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6880);
borderColors = style.border.color.concat();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6882);
this._createMarkerCache();
        _yuitest_coverline("build/charts-base/charts-base.js", 6883);
for(; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6885);
top = parseFloat(ycoords[i] - offsetHeight);
            _yuitest_coverline("build/charts-base/charts-base.js", 6886);
left = parseFloat(xcoords[i] - offsetWidth);            
            _yuitest_coverline("build/charts-base/charts-base.js", 6887);
if(!isNumber(left) || !isNumber(top))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6889);
this._markers.push(null);
                _yuitest_coverline("build/charts-base/charts-base.js", 6890);
continue;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6892);
if(fillColors)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6894);
style.fill.color = fillColors[i % fillColors.length];
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 6896);
if(borderColors)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 6898);
style.border.color = borderColors[i % borderColors.length];
            }

            _yuitest_coverline("build/charts-base/charts-base.js", 6901);
style.x = left;
            _yuitest_coverline("build/charts-base/charts-base.js", 6902);
style.y = top;
            _yuitest_coverline("build/charts-base/charts-base.js", 6903);
marker = this.getMarker(style, graphOrder, i);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6905);
this._clearMarkerCache();
    },

    /**
     * Pre-defined group shapes.
     *
     * @property _groupShapes
     * @private
     */
    _groupShapes: {
        circle: Y.CircleGroup,
        rect: Y.RectGroup,
        ellipse: Y.EllipseGroup,
        diamond: Y.DiamondGroup
    },

    /**
     * Returns the correct group shape class.
     *
     * @method _getGroupShape
     * @param {Shape | String} shape Indicates which shape class. 
     * @return Function
     * @protected
     */
    _getGroupShape: function(shape)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getGroupShape", 6929);
_yuitest_coverline("build/charts-base/charts-base.js", 6931);
if(Y_Lang.isString(shape))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 6933);
shape = this._groupShapes[shape];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 6935);
return shape;
    },

    /**
     * Gets the default values for series that use the utility. This method is used by
     * the class' `styles` attribute's getter to get build default values.
     *
     * @method _getPlotDefaults
     * @return Object
     * @protected
     */
    _getPlotDefaults: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getPlotDefaults", 6946);
_yuitest_coverline("build/charts-base/charts-base.js", 6948);
var defs = {
            fill:{
                type: "solid",
                alpha: 1,
                colors:null,
                alphas: null,
                ratios: null
            },
            border:{
                weight: 1,
                alpha: 1
            },
            width: 10,
            height: 10,
            shape: "circle"
        };
        _yuitest_coverline("build/charts-base/charts-base.js", 6964);
defs.fill.color = this._getDefaultColor(this.get("graphOrder"), "fill");
        _yuitest_coverline("build/charts-base/charts-base.js", 6965);
defs.border.color = this._getDefaultColor(this.get("graphOrder"), "border");
        _yuitest_coverline("build/charts-base/charts-base.js", 6966);
return defs;
    },

    /**
     * Collection of markers to be used in the series.
     *
     * @property _markers
     * @type Array
     * @private
     */
    _markers: null,

    /**
     * Collection of markers to be re-used on a series redraw.
     *
     * @property _markerCache
     * @type Array
     * @private
     */
    _markerCache: null,
   
    /**
     * Gets and styles a marker. If there is a marker in cache, it will use it. Otherwise
     * it will create one.
     *
     * @method getMarker
     * @param {Object} styles Hash of style properties.
     * @param {Number} order Order of the series.
     * @param {Number} index Index within the series associated with the marker.
     * @return Shape
     * @protected
     */
    getMarker: function(styles, order, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getMarker", 6998);
_yuitest_coverline("build/charts-base/charts-base.js", 7000);
var marker,
            border = styles.border;
        _yuitest_coverline("build/charts-base/charts-base.js", 7002);
styles.id = this.get("chart").get("id") + "_" + order + "_" + index;
        //fix name differences between graphic layer
        _yuitest_coverline("build/charts-base/charts-base.js", 7004);
border.opacity = border.alpha;
        _yuitest_coverline("build/charts-base/charts-base.js", 7005);
styles.stroke = border;
        _yuitest_coverline("build/charts-base/charts-base.js", 7006);
styles.fill.opacity = styles.fill.alpha;
        _yuitest_coverline("build/charts-base/charts-base.js", 7007);
if(this._markerCache.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7009);
while(!marker)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7011);
if(this._markerCache.length < 1)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7013);
marker = this._createMarker(styles, order, index);
                    _yuitest_coverline("build/charts-base/charts-base.js", 7014);
break;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 7016);
marker = this._markerCache.shift();

            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7019);
marker.set(styles);
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7023);
marker = this._createMarker(styles, order, index);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7025);
this._markers.push(marker);
        _yuitest_coverline("build/charts-base/charts-base.js", 7026);
return marker;
    },
    
    /**
     * Creates a shape to be used as a marker.
     *
     * @method _createMarker
     * @param {Object} styles Hash of style properties.
     * @param {Number} order Order of the series.
     * @param {Number} index Index within the series associated with the marker.
     * @return Shape
     * @private
     */
    _createMarker: function(styles, order, index)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_createMarker", 7039);
_yuitest_coverline("build/charts-base/charts-base.js", 7041);
var graphic = this.get("graphic"),
            marker,
            cfg = Y.clone(styles);
        _yuitest_coverline("build/charts-base/charts-base.js", 7044);
graphic.set("autoDraw", false);
        _yuitest_coverline("build/charts-base/charts-base.js", 7045);
cfg.type = cfg.shape;
        _yuitest_coverline("build/charts-base/charts-base.js", 7046);
marker = graphic.addShape(cfg); 
        _yuitest_coverline("build/charts-base/charts-base.js", 7047);
marker.addClass(SERIES_MARKER);
        _yuitest_coverline("build/charts-base/charts-base.js", 7048);
return marker;
    },
    
    /**
     * Creates a cache of markers for reuse.
     *
     * @method _createMarkerCache
     * @private
     */
    _createMarkerCache: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_createMarkerCache", 7057);
_yuitest_coverline("build/charts-base/charts-base.js", 7059);
if(this._groupMarker)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7061);
this._groupMarker.destroy();
            _yuitest_coverline("build/charts-base/charts-base.js", 7062);
this._groupMarker = null;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7064);
if(this._markers && this._markers.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7066);
this._markerCache = this._markers.concat();
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7070);
this._markerCache = [];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7072);
this._markers = [];
    },
  
    /**
     * Draws a series of markers in a single shape instance.
     *
     * @method _createGroupMarkers
     * @param {Object} styles Set of configuration properties used to create the markers.
     * @protected
     */
    _createGroupMarker: function(styles)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_createGroupMarker", 7082);
_yuitest_coverline("build/charts-base/charts-base.js", 7084);
var marker,
            markers = this.get("markers"),
            border = styles.border,
            graphic,
            cfg,
            shape;
        _yuitest_coverline("build/charts-base/charts-base.js", 7090);
if(markers && markers.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7092);
while(markers.length > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7094);
marker = markers.shift();
                _yuitest_coverline("build/charts-base/charts-base.js", 7095);
marker.destroy();
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7097);
this.set("markers", []);
        }
        //fix name differences between graphic layer
        _yuitest_coverline("build/charts-base/charts-base.js", 7100);
border.opacity = border.alpha;
        _yuitest_coverline("build/charts-base/charts-base.js", 7101);
cfg = {
            id: this.get("chart").get("id") + "_" + styles.graphOrder,
            stroke: border,
            fill: styles.fill,
            dimensions: styles.dimensions,
            xvalues: styles.xvalues,
            yvalues: styles.yvalues
        };
        _yuitest_coverline("build/charts-base/charts-base.js", 7109);
cfg.fill.opacity = styles.fill.alpha;
        _yuitest_coverline("build/charts-base/charts-base.js", 7110);
shape = this._getGroupShape(styles.shape);
        _yuitest_coverline("build/charts-base/charts-base.js", 7111);
if(shape)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7113);
cfg.type = shape;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7115);
if(styles.hasOwnProperty("radius") && !isNaN(styles.radius))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7117);
cfg.dimensions.radius = styles.radius;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7119);
if(this._groupMarker)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7121);
this._groupMarker.destroy();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7123);
graphic = this.get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 7124);
this._groupMarker = graphic.addShape(cfg);
        _yuitest_coverline("build/charts-base/charts-base.js", 7125);
graphic._redraw();
    },

    /**
     * Toggles visibility
     *
     * @method _toggleVisible
     * @param {Boolean} visible indicates visibilitye
     * @private
     */
    _toggleVisible: function(visible)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_toggleVisible", 7135);
_yuitest_coverline("build/charts-base/charts-base.js", 7137);
var marker,
            markers = this.get("markers"),
            i = 0,
            len;
        _yuitest_coverline("build/charts-base/charts-base.js", 7141);
if(markers)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7143);
len = markers.length;
            _yuitest_coverline("build/charts-base/charts-base.js", 7144);
for(; i < len; ++i)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7146);
marker = markers[i];
                _yuitest_coverline("build/charts-base/charts-base.js", 7147);
if(marker)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7149);
marker.set("visible", visible);
                }
            }
        }
    },

    /**
     * Removes unused markers from the marker cache
     *
     * @method _clearMarkerCache
     * @private
     */
    _clearMarkerCache: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_clearMarkerCache", 7161);
_yuitest_coverline("build/charts-base/charts-base.js", 7163);
var marker;
        _yuitest_coverline("build/charts-base/charts-base.js", 7164);
while(this._markerCache.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7166);
marker = this._markerCache.shift();
            _yuitest_coverline("build/charts-base/charts-base.js", 7167);
if(marker)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7169);
marker.destroy();
            }
        }
    },

    /**
     * Resizes and positions markers based on a mouse interaction.
     *
     * @method updateMarkerState
     * @param {String} type state of the marker
     * @param {Number} i index of the marker
     * @protected
     */
    updateMarkerState: function(type, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMarkerState", 7182);
_yuitest_coverline("build/charts-base/charts-base.js", 7184);
if(this._markers && this._markers[i])
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7186);
var w,
                h,
                styles = Y.clone(this.get("styles").marker),
                state = this._getState(type),
                xcoords = this.get("xcoords"),
                ycoords = this.get("ycoords"),
                marker = this._markers[i],
                markerStyles = state == "off" || !styles[state] ? styles : styles[state]; 
                _yuitest_coverline("build/charts-base/charts-base.js", 7194);
markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);
                _yuitest_coverline("build/charts-base/charts-base.js", 7195);
markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);
                _yuitest_coverline("build/charts-base/charts-base.js", 7196);
markerStyles.stroke = markerStyles.border;
                _yuitest_coverline("build/charts-base/charts-base.js", 7197);
marker.set(markerStyles);
                _yuitest_coverline("build/charts-base/charts-base.js", 7198);
w = markerStyles.width;
                _yuitest_coverline("build/charts-base/charts-base.js", 7199);
h = markerStyles.height;
                _yuitest_coverline("build/charts-base/charts-base.js", 7200);
marker.set("x", (xcoords[i] - w/2));
                _yuitest_coverline("build/charts-base/charts-base.js", 7201);
marker.set("y",  (ycoords[i] - h/2));
                _yuitest_coverline("build/charts-base/charts-base.js", 7202);
marker.set("visible", this.get("visible"));
        }
    },

    /**
     * Parses a color from an array.
     *
     * @method _getItemColor
     * @param {Array} val collection of colors
     * @param {Number} i index of the item
     * @return String
     * @protected
     */
    _getItemColor: function(val, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getItemColor", 7215);
_yuitest_coverline("build/charts-base/charts-base.js", 7217);
if(Y_Lang.isArray(val))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7219);
return val[i % val.length];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7221);
return val;
    },

    /**
     * Method used by `styles` setter. Overrides base implementation.
     *
     * @method _setStyles
     * @param {Object} newStyles Hash of properties to update.
     * @return Object
     * @protected
     */
    _setStyles: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setStyles", 7232);
_yuitest_coverline("build/charts-base/charts-base.js", 7234);
val = this._parseMarkerStyles(val);
        _yuitest_coverline("build/charts-base/charts-base.js", 7235);
return Y.Renderer.prototype._setStyles.apply(this, [val]);
    },

    /**
     * Combines new styles with existing styles.
     *
     * @method _parseMarkerStyles
     * @param {Object} Object containing style properties for the marker.
     * @return Object
     * @private
     */
    _parseMarkerStyles: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_parseMarkerStyles", 7246);
_yuitest_coverline("build/charts-base/charts-base.js", 7248);
if(val.marker)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7250);
var defs = this._getPlotDefaults();
            _yuitest_coverline("build/charts-base/charts-base.js", 7251);
val.marker = this._mergeStyles(val.marker, defs);
            _yuitest_coverline("build/charts-base/charts-base.js", 7252);
if(val.marker.over)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7254);
val.marker.over = this._mergeStyles(val.marker.over, val.marker);
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7256);
if(val.marker.down)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7258);
val.marker.down = this._mergeStyles(val.marker.down, val.marker);
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7261);
return val;
    },

    /**
     * Returns marker state based on event type
     *
     * @method _getState
     * @param {String} type event type
     * @return String
     * @protected
     */
    _getState: function(type)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getState", 7272);
_yuitest_coverline("build/charts-base/charts-base.js", 7274);
var state;
        _yuitest_coverline("build/charts-base/charts-base.js", 7275);
switch(type)
        {
            case "mouseout" :
                _yuitest_coverline("build/charts-base/charts-base.js", 7278);
state = "off";
            _yuitest_coverline("build/charts-base/charts-base.js", 7279);
break;
            case "mouseover" :
                _yuitest_coverline("build/charts-base/charts-base.js", 7281);
state = "over";
            _yuitest_coverline("build/charts-base/charts-base.js", 7282);
break;
            case "mouseup" :
                _yuitest_coverline("build/charts-base/charts-base.js", 7284);
state = "over";
            _yuitest_coverline("build/charts-base/charts-base.js", 7285);
break;
            case "mousedown" :
                _yuitest_coverline("build/charts-base/charts-base.js", 7287);
state = "down";
            _yuitest_coverline("build/charts-base/charts-base.js", 7288);
break;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7290);
return state;
    },
    
    /**
     * @property _statSyles
     * @type Object
     * @private
     */
    _stateSyles: null
};

_yuitest_coverline("build/charts-base/charts-base.js", 7301);
Y.augment(Plots, Y.Attribute);
_yuitest_coverline("build/charts-base/charts-base.js", 7302);
Y.Plots = Plots;
/**
 * Histogram is the base class for Column and Bar series.
 *
 * @module charts
 * @submodule charts-base
 * @class Histogram
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 7311);
function Histogram(){}

_yuitest_coverline("build/charts-base/charts-base.js", 7313);
Histogram.prototype = {
    /**
     * Draws the series.
     *
     * @method drawSeries
     * @protected
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 7320);
_yuitest_coverline("build/charts-base/charts-base.js", 7322);
if(this.get("xcoords").length < 1) 
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7324);
return;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7326);
var style = Y.clone(this.get("styles").marker),
            setSize,
            calculatedSize,
            xcoords = this.get("xcoords"),
            ycoords = this.get("ycoords"),
            i = 0,
            len = xcoords.length,
            top = ycoords[0],
            type = this.get("type"),
            graph = this.get("graph"),
            seriesCollection = graph.seriesTypes[type],
            seriesLen = seriesCollection.length,
            seriesSize = 0,
            totalSize = 0,
            offset = 0,
            ratio,
            renderer,
            order = this.get("order"),
            graphOrder = this.get("graphOrder"),
            left,
            marker,
            setSizeKey,
            calculatedSizeKey,
            config,
            fillColors = null,
            borderColors = null,
            xMarkerPlane = [],
            yMarkerPlane = [],
            xMarkerPlaneLeft,
            xMarkerPlaneRight,
            yMarkerPlaneTop,
            yMarkerPlaneBottom,
            dimensions = {
                width: [],
                height: []
            },
            xvalues = [],
            yvalues = [],
            groupMarkers = this.get("groupMarkers");
        _yuitest_coverline("build/charts-base/charts-base.js", 7365);
if(Y_Lang.isArray(style.fill.color))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7367);
fillColors = style.fill.color.concat(); 
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7369);
if(Y_Lang.isArray(style.border.color))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7371);
borderColors = style.border.color.concat();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7373);
if(this.get("direction") == "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7375);
setSizeKey = "height";
            _yuitest_coverline("build/charts-base/charts-base.js", 7376);
calculatedSizeKey = "width";
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7380);
setSizeKey = "width";
            _yuitest_coverline("build/charts-base/charts-base.js", 7381);
calculatedSizeKey = "height";
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7383);
setSize = style[setSizeKey];
        _yuitest_coverline("build/charts-base/charts-base.js", 7384);
calculatedSize = style[calculatedSizeKey];
        _yuitest_coverline("build/charts-base/charts-base.js", 7385);
this._createMarkerCache();
        _yuitest_coverline("build/charts-base/charts-base.js", 7386);
for(; i < seriesLen; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7388);
renderer = seriesCollection[i];
            _yuitest_coverline("build/charts-base/charts-base.js", 7389);
seriesSize += renderer.get("styles").marker[setSizeKey];
            _yuitest_coverline("build/charts-base/charts-base.js", 7390);
if(order > i) 
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7392);
offset = seriesSize;
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7395);
totalSize = len * seriesSize;
        _yuitest_coverline("build/charts-base/charts-base.js", 7396);
this._maxSize = graph.get(setSizeKey);
        _yuitest_coverline("build/charts-base/charts-base.js", 7397);
if(totalSize > this._maxSize)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7399);
ratio = graph.get(setSizeKey)/totalSize;
            _yuitest_coverline("build/charts-base/charts-base.js", 7400);
seriesSize *= ratio;
            _yuitest_coverline("build/charts-base/charts-base.js", 7401);
offset *= ratio;
            _yuitest_coverline("build/charts-base/charts-base.js", 7402);
setSize *= ratio;
            _yuitest_coverline("build/charts-base/charts-base.js", 7403);
setSize = Math.max(setSize, 1);
            _yuitest_coverline("build/charts-base/charts-base.js", 7404);
this._maxSize = setSize;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7406);
offset -= seriesSize/2;
        _yuitest_coverline("build/charts-base/charts-base.js", 7407);
for(i = 0; i < len; ++i)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7409);
xMarkerPlaneLeft = xcoords[i] - seriesSize/2;
            _yuitest_coverline("build/charts-base/charts-base.js", 7410);
xMarkerPlaneRight = xMarkerPlaneLeft + seriesSize;
            _yuitest_coverline("build/charts-base/charts-base.js", 7411);
yMarkerPlaneTop = ycoords[i] - seriesSize/2;
            _yuitest_coverline("build/charts-base/charts-base.js", 7412);
yMarkerPlaneBottom = yMarkerPlaneTop + seriesSize;
            _yuitest_coverline("build/charts-base/charts-base.js", 7413);
xMarkerPlane.push({start: xMarkerPlaneLeft, end: xMarkerPlaneRight});
            _yuitest_coverline("build/charts-base/charts-base.js", 7414);
yMarkerPlane.push({start: yMarkerPlaneTop, end: yMarkerPlaneBottom});
            _yuitest_coverline("build/charts-base/charts-base.js", 7415);
if(isNaN(xcoords[i]) || isNaN(ycoords[i]))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7417);
this._markers.push(null);
                _yuitest_coverline("build/charts-base/charts-base.js", 7418);
continue;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7420);
config = this._getMarkerDimensions(xcoords[i], ycoords[i], calculatedSize, offset);
            _yuitest_coverline("build/charts-base/charts-base.js", 7421);
if(!isNaN(config.calculatedSize) && config.calculatedSize > 0)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7423);
top = config.top;
                _yuitest_coverline("build/charts-base/charts-base.js", 7424);
left = config.left;

                _yuitest_coverline("build/charts-base/charts-base.js", 7426);
if(groupMarkers)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7428);
dimensions[setSizeKey][i] = setSize;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7429);
dimensions[calculatedSizeKey][i] = config.calculatedSize;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7430);
xvalues.push(left);
                    _yuitest_coverline("build/charts-base/charts-base.js", 7431);
yvalues.push(top);
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7435);
style[setSizeKey] = setSize;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7436);
style[calculatedSizeKey] = config.calculatedSize;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7437);
style.x = left;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7438);
style.y = top;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7439);
if(fillColors)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 7441);
style.fill.color = fillColors[i % fillColors.length];
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 7443);
if(borderColors)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 7445);
style.border.color = borderColors[i % borderColors.length];
                    }
                    _yuitest_coverline("build/charts-base/charts-base.js", 7447);
marker = this.getMarker(style, graphOrder, i);
                }

            }
            else {_yuitest_coverline("build/charts-base/charts-base.js", 7451);
if(!groupMarkers)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7453);
this._markers.push(null);
            }}
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7456);
this.set("xMarkerPlane", xMarkerPlane);
        _yuitest_coverline("build/charts-base/charts-base.js", 7457);
this.set("yMarkerPlane", yMarkerPlane);
        _yuitest_coverline("build/charts-base/charts-base.js", 7458);
if(groupMarkers)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7460);
this._createGroupMarker({
                fill: style.fill,
                border: style.border,
                dimensions: dimensions,
                xvalues: xvalues,
                yvalues: yvalues,
                shape: style.shape
            });
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7471);
this._clearMarkerCache();
        }
    },
    
    /**
     * Collection of default colors used for marker fills in a series when not specified by user.
     *
     * @property _defaultFillColors
     * @type Array
     * @protected
     */
    _defaultFillColors: ["#66007f", "#a86f41", "#295454", "#996ab2", "#e8cdb7", "#90bdbd","#000000","#c3b8ca", "#968373", "#678585"],
    
    /**
     * Gets the default style values for the markers.
     *
     * @method _getPlotDefaults
     * @return Object
     * @private
     */
    _getPlotDefaults: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getPlotDefaults", 7491);
_yuitest_coverline("build/charts-base/charts-base.js", 7493);
var defs = {
            fill:{
                type: "solid",
                alpha: 1,
                colors:null,
                alphas: null,
                ratios: null
            },
            border:{
                weight: 0,
                alpha: 1
            },
            width: 12,
            height: 12,
            shape: "rect",

            padding:{
                top: 0,
                left: 0,
                right: 0,
                bottom: 0
            }
        };
        _yuitest_coverline("build/charts-base/charts-base.js", 7516);
defs.fill.color = this._getDefaultColor(this.get("graphOrder"), "fill");
        _yuitest_coverline("build/charts-base/charts-base.js", 7517);
defs.border.color = this._getDefaultColor(this.get("graphOrder"), "border");
        _yuitest_coverline("build/charts-base/charts-base.js", 7518);
return defs;
    }
};

_yuitest_coverline("build/charts-base/charts-base.js", 7522);
Y.Histogram = Histogram;
/**
 * The CartesianSeries class creates a chart with horizontal and vertical axes.
 *
 * @module charts
 * @submodule charts-base
 * @class CartesianSeries
 * @extends Base
 * @uses Renderer
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 7533);
Y.CartesianSeries = Y.Base.create("cartesianSeries", Y.Base, [Y.Renderer], {
    /**
     * Storage for `xDisplayName` attribute.
     *
     * @property _xDisplayName
     * @type String
     * @private
     */
    _xDisplayName: null,

    /**
     * Storage for `yDisplayName` attribute.
     *
     * @property _yDisplayName
     * @type String
     * @private
     */
    _yDisplayName: null,
    
    /**
     * Th x-coordinate for the left edge of the series.
     *
     * @property _leftOrigin
     * @type String
     * @private
     */
    _leftOrigin: null,

    /**
     * The y-coordinate for the bottom edge of the series.
     * 
     * @property _bottomOrigin
     * @type String
     * @private
     */
    _bottomOrigin: null,

    /**
     * @method render
     * @private
     */
    render: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "render", 7574);
_yuitest_coverline("build/charts-base/charts-base.js", 7576);
this._setCanvas();
        _yuitest_coverline("build/charts-base/charts-base.js", 7577);
this.addListeners();
        _yuitest_coverline("build/charts-base/charts-base.js", 7578);
this.set("rendered", true);
        _yuitest_coverline("build/charts-base/charts-base.js", 7579);
this.validate();
    },

    /**
     * Adds event listeners.
     *
     * @method addListeners
     * @private
     */
    addListeners: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "addListeners", 7588);
_yuitest_coverline("build/charts-base/charts-base.js", 7590);
var xAxis = this.get("xAxis"),
            yAxis = this.get("yAxis");
        _yuitest_coverline("build/charts-base/charts-base.js", 7592);
if(xAxis)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7594);
this._xDataReadyHandle = xAxis.after("dataReady", Y.bind(this._xDataChangeHandler, this));
            _yuitest_coverline("build/charts-base/charts-base.js", 7595);
this._xDataUpdateHandle = xAxis.after("dataUpdate", Y.bind(this._xDataChangeHandler, this));
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7597);
if(yAxis)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7599);
this._yDataReadyHandle = yAxis.after("dataReady", Y.bind(this._yDataChangeHandler, this));
            _yuitest_coverline("build/charts-base/charts-base.js", 7600);
this._yDataUpdateHandle = yAxis.after("dataUpdate", Y.bind(this._yDataChangeHandler, this));
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7602);
this._xAxisChangeHandle = this.after("xAxisChange", this._xAxisChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 7603);
this._yAxisChangeHandle = this.after("yAxisChange", this._yAxisChangeHandler);
        _yuitest_coverline("build/charts-base/charts-base.js", 7604);
this._stylesChangeHandle = this.after("stylesChange", function(e) {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "(anonymous 3)", 7604);
_yuitest_coverline("build/charts-base/charts-base.js", 7605);
var axesReady = this._updateAxisData();
            _yuitest_coverline("build/charts-base/charts-base.js", 7606);
if(axesReady)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7608);
this.draw();
            }
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 7611);
this._widthChangeHandle = this.after("widthChange", function(e) {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "(anonymous 4)", 7611);
_yuitest_coverline("build/charts-base/charts-base.js", 7612);
var axesReady = this._updateAxisData();
            _yuitest_coverline("build/charts-base/charts-base.js", 7613);
if(axesReady)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7615);
this.draw();
            }
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 7618);
this._heightChangeHandle = this.after("heightChange", function(e) {
            _yuitest_coverfunc("build/charts-base/charts-base.js", "(anonymous 5)", 7618);
_yuitest_coverline("build/charts-base/charts-base.js", 7619);
var axesReady = this._updateAxisData();
            _yuitest_coverline("build/charts-base/charts-base.js", 7620);
if(axesReady)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7622);
this.draw();
            }
        });
        _yuitest_coverline("build/charts-base/charts-base.js", 7625);
this._visibleChangeHandle = this.after("visibleChange", this._handleVisibleChange);
    },
  
    /**
     * Event handler for the xAxisChange event.
     *
     * @method _xAxisChangeHandler
     * @param {Object} e Event object.
     * @private
     */
    _xAxisChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_xAxisChangeHandler", 7635);
_yuitest_coverline("build/charts-base/charts-base.js", 7637);
var xAxis = this.get("xAxis");
        _yuitest_coverline("build/charts-base/charts-base.js", 7638);
xAxis.after("dataReady", Y.bind(this._xDataChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 7639);
xAxis.after("dataUpdate", Y.bind(this._xDataChangeHandler, this));
    },
    
    /**
     * Event handler the yAxisChange event.
     *
     * @method _yAxisChangeHandler
     * @param {Object} e Event object.
     * @private
     */
    _yAxisChangeHandler: function(e)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_yAxisChangeHandler", 7649);
_yuitest_coverline("build/charts-base/charts-base.js", 7651);
var yAxis = this.get("yAxis");
        _yuitest_coverline("build/charts-base/charts-base.js", 7652);
yAxis.after("dataReady", Y.bind(this._yDataChangeHandler, this));
        _yuitest_coverline("build/charts-base/charts-base.js", 7653);
yAxis.after("dataUpdate", Y.bind(this._yDataChangeHandler, this));
    },

    /**
     * Constant used to generate unique id.
     *
     * @property GUID
     * @type String
     * @private
     */
    GUID: "yuicartesianseries",

    /**
     * Event handler for xDataChange event.
     *
     * @method _xDataChangeHandler
     * @param {Object} event Event object.
     * @private 
     */
    _xDataChangeHandler: function(event)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_xDataChangeHandler", 7672);
_yuitest_coverline("build/charts-base/charts-base.js", 7674);
var axesReady = this._updateAxisData();
        _yuitest_coverline("build/charts-base/charts-base.js", 7675);
if(axesReady)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7677);
this.draw();
        }
    },

    /**
     * Event handler for yDataChange event.
     *
     * @method _yDataChangeHandler
     * @param {Object} event Event object.
     * @private 
     */
    _yDataChangeHandler: function(event)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_yDataChangeHandler", 7688);
_yuitest_coverline("build/charts-base/charts-base.js", 7690);
var axesReady = this._updateAxisData();
        _yuitest_coverline("build/charts-base/charts-base.js", 7691);
if(axesReady)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7693);
this.draw();
        }
    },

    /**
     * Checks to ensure that both xAxis and yAxis data are available. If so, set the `xData` and `yData` attributes and return `true`. Otherwise, return `false`.
     *
     * @method _updateAxisData
     * @return Boolean
     * @private 
     */
    _updateAxisData: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_updateAxisData", 7704);
_yuitest_coverline("build/charts-base/charts-base.js", 7706);
var xAxis = this.get("xAxis"),
            yAxis = this.get("yAxis"),
            xKey = this.get("xKey"),
            yKey = this.get("yKey"),
            yData,
            xData;
        _yuitest_coverline("build/charts-base/charts-base.js", 7712);
if(!xAxis || !yAxis || !xKey || !yKey)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7714);
return false;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7716);
xData = xAxis.getDataByKey(xKey);
        _yuitest_coverline("build/charts-base/charts-base.js", 7717);
yData = yAxis.getDataByKey(yKey);
        _yuitest_coverline("build/charts-base/charts-base.js", 7718);
if(!xData || !yData)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7720);
return false;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7722);
this.set("xData", xData.concat());
        _yuitest_coverline("build/charts-base/charts-base.js", 7723);
this.set("yData", yData.concat());
        _yuitest_coverline("build/charts-base/charts-base.js", 7724);
return true;
    },

    /**
     * Draws the series is the xAxis and yAxis data are both available.
     *
     * @method validate
     * @private
     */
    validate: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "validate", 7733);
_yuitest_coverline("build/charts-base/charts-base.js", 7735);
if((this.get("xData") && this.get("yData")) || this._updateAxisData())
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7737);
this.draw();
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7741);
this.fire("drawingComplete");
        }
    },

    /**
     * Creates a `Graphic` instance.
     *
     * @method _setCanvas
     * @protected
     */
    _setCanvas: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setCanvas", 7751);
_yuitest_coverline("build/charts-base/charts-base.js", 7753);
var graph = this.get("graph"),
            graphic = graph.get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 7755);
this.set("graphic", graphic);
    },

    /**
     * Calculates the coordinates for the series.
     *
     * @method setAreaData
     * @protected
     */
    setAreaData: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setAreaData", 7764);
_yuitest_coverline("build/charts-base/charts-base.js", 7766);
var isNumber = Y_Lang.isNumber,
            nextX, nextY,
            graph = this.get("graph"),
            w = graph.get("width"),
            h = graph.get("height"),
            xAxis = this.get("xAxis"),
            yAxis = this.get("yAxis"),
            xData = this.get("xData").concat(),
            yData = this.get("yData").concat(),
            xValue,
            yValue,
            xOffset = xAxis.getEdgeOffset(xData.length, w),
            yOffset = yAxis.getEdgeOffset(yData.length, h),
            padding = this.get("styles").padding,
			leftPadding = padding.left,
			topPadding = padding.top,
			dataWidth = w - (leftPadding + padding.right + xOffset),
			dataHeight = h - (topPadding + padding.bottom + yOffset),
			xcoords = [],
			ycoords = [],
			xMax = xAxis.get("maximum"),
			xMin = xAxis.get("minimum"),
			yMax = yAxis.get("maximum"),
			yMin = yAxis.get("minimum"),
            xScaleFactor = dataWidth / (xMax - xMin),
			yScaleFactor = dataHeight / (yMax - yMin),
            dataLength,
            direction = this.get("direction"),
            i = 0,
            xMarkerPlane = [],
            yMarkerPlane = [],
            xMarkerPlaneOffset = this.get("xMarkerPlaneOffset"),
            yMarkerPlaneOffset = this.get("yMarkerPlaneOffset"),
            graphic = this.get("graphic");
        _yuitest_coverline("build/charts-base/charts-base.js", 7800);
graphic.set("width", w);
        _yuitest_coverline("build/charts-base/charts-base.js", 7801);
graphic.set("height", h);
        _yuitest_coverline("build/charts-base/charts-base.js", 7802);
dataLength = xData.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 7803);
xOffset *= 0.5;
        _yuitest_coverline("build/charts-base/charts-base.js", 7804);
yOffset *= 0.5;
        //Assuming a vertical graph has a range/category for its vertical axis.    
        _yuitest_coverline("build/charts-base/charts-base.js", 7806);
if(direction === "vertical")
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7808);
yData = yData.reverse();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7810);
this._leftOrigin = Math.round(((0 - xMin) * xScaleFactor) + leftPadding + xOffset);
        _yuitest_coverline("build/charts-base/charts-base.js", 7811);
this._bottomOrigin = Math.round((dataHeight + topPadding + yOffset)); 
        _yuitest_coverline("build/charts-base/charts-base.js", 7812);
if(yMin < 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7814);
this._bottomOrigin = this._bottomOrigin - ((0 - yMin) * yScaleFactor);
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7816);
for (; i < dataLength; ++i) 
		{
            _yuitest_coverline("build/charts-base/charts-base.js", 7818);
xValue = parseFloat(xData[i]);
            _yuitest_coverline("build/charts-base/charts-base.js", 7819);
yValue = parseFloat(yData[i]);
            _yuitest_coverline("build/charts-base/charts-base.js", 7820);
if(isNumber(xValue))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7822);
nextX = (((xValue - xMin) * xScaleFactor) + leftPadding + xOffset);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7826);
nextX = NaN;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7828);
if(isNumber(yValue))
            {
			    _yuitest_coverline("build/charts-base/charts-base.js", 7830);
nextY = ((dataHeight + topPadding + yOffset) - (yValue - yMin) * yScaleFactor);
            }
            else
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7834);
nextY = NaN;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 7836);
xcoords.push(nextX);
            _yuitest_coverline("build/charts-base/charts-base.js", 7837);
ycoords.push(nextY);
            _yuitest_coverline("build/charts-base/charts-base.js", 7838);
xMarkerPlane.push({start:nextX - xMarkerPlaneOffset, end: nextX + xMarkerPlaneOffset});
            _yuitest_coverline("build/charts-base/charts-base.js", 7839);
yMarkerPlane.push({start:nextY - yMarkerPlaneOffset, end: nextY + yMarkerPlaneOffset});
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7841);
this.set("xcoords", xcoords);
		_yuitest_coverline("build/charts-base/charts-base.js", 7842);
this.set("ycoords", ycoords);
        _yuitest_coverline("build/charts-base/charts-base.js", 7843);
this.set("xMarkerPlane", xMarkerPlane);
        _yuitest_coverline("build/charts-base/charts-base.js", 7844);
this.set("yMarkerPlane", yMarkerPlane);
        _yuitest_coverline("build/charts-base/charts-base.js", 7845);
this._dataLength = dataLength;
    },

    /**
     * Finds the first valid index of an array coordinates.
     *
     * @method _getFirstValidIndex
     * @param {Array} coords An array of x or y coordinates.
     * @return Number
     * @private
     */
    _getFirstValidIndex: function(coords)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getFirstValidIndex", 7856);
_yuitest_coverline("build/charts-base/charts-base.js", 7858);
var coord,
            i = -1,
            limit = coords.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 7861);
while(!Y_Lang.isNumber(coord) && i < limit)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7863);
i += 1;
            _yuitest_coverline("build/charts-base/charts-base.js", 7864);
coord = coords[i];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7866);
return i;
    },

    /**
     * Finds the last valid index of an array coordinates.
     *
     * @method _getLastValidIndex
     * @param {Array} coords An array of x or y coordinates.
     * @return Number
     * @private
     */
    _getLastValidIndex: function(coords)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getLastValidIndex", 7877);
_yuitest_coverline("build/charts-base/charts-base.js", 7879);
var coord,
            i = coords.length,
            limit = -1;
        _yuitest_coverline("build/charts-base/charts-base.js", 7882);
while(!Y_Lang.isNumber(coord) && i > limit)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7884);
i -= 1;
            _yuitest_coverline("build/charts-base/charts-base.js", 7885);
coord = coords[i];
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 7887);
return i;
    },

    /**
     * Draws the series.
     *
     * @method draw
     * @protected
     */
    draw: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "draw", 7896);
_yuitest_coverline("build/charts-base/charts-base.js", 7898);
var graph = this.get("graph"),
            w = graph.get("width"),
            h = graph.get("height");
        _yuitest_coverline("build/charts-base/charts-base.js", 7901);
if(this.get("rendered"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 7903);
if((isFinite(w) && isFinite(h) && w > 0 && h > 0) && ((this.get("xData") && this.get("yData")) || this._updateAxisData()))
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 7905);
if(this._drawing)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7907);
this._callLater = true;
                    _yuitest_coverline("build/charts-base/charts-base.js", 7908);
return;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 7910);
this._drawing = true;
                _yuitest_coverline("build/charts-base/charts-base.js", 7911);
this._callLater = false;
                _yuitest_coverline("build/charts-base/charts-base.js", 7912);
this.setAreaData();
                _yuitest_coverline("build/charts-base/charts-base.js", 7913);
if(this.get("xcoords") && this.get("ycoords"))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7915);
this.drawSeries();
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 7917);
this._drawing = false;
                _yuitest_coverline("build/charts-base/charts-base.js", 7918);
if(this._callLater)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7920);
this.draw();
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 7924);
this._toggleVisible(this.get("visible"));
                    _yuitest_coverline("build/charts-base/charts-base.js", 7925);
this.fire("drawingComplete");
                }
            }
        }
    },
    
    /**
     * Default value for plane offsets when the parent chart's `interactiveType` is `planar`. 
     *
     * @property _defaultPlaneOffset
     * @type Number
     * @private
     */
    _defaultPlaneOffset: 4,
    
    /**
     * Gets the default value for the `styles` attribute. Overrides
     * base implementation.
     *
     * @method _getDefaultStyles
     * @return Object
     * @protected
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 7948);
_yuitest_coverline("build/charts-base/charts-base.js", 7950);
return {padding:{
                top: 0,
                left: 0,
                right: 0,
                bottom: 0
            }};
    },

    /**
     * Collection of default colors used for lines in a series when not specified by user.
     *
     * @property _defaultLineColors
     * @type Array
     * @protected
     */
    _defaultLineColors:["#426ab3", "#d09b2c", "#000000", "#b82837", "#b384b5", "#ff7200", "#779de3", "#cbc8ba", "#7ed7a6", "#007a6c"],

    /**
     * Collection of default colors used for marker fills in a series when not specified by user.
     *
     * @property _defaultFillColors
     * @type Array
     * @protected
     */
    _defaultFillColors:["#6084d0", "#eeb647", "#6c6b5f", "#d6484f", "#ce9ed1", "#ff9f3b", "#93b7ff", "#e0ddd0", "#94ecba", "#309687"],
    
    /**
     * Collection of default colors used for marker borders in a series when not specified by user.
     *
     * @property _defaultBorderColors
     * @type Array
     * @protected
     */
    _defaultBorderColors:["#205096", "#b38206", "#000000", "#94001e", "#9d6fa0", "#e55b00", "#5e85c9", "#adab9e", "#6ac291", "#006457"],
    
    /**
     * Collection of default colors used for area fills, histogram fills and pie fills in a series when not specified by user.
     *
     * @property _defaultSliceColors
     * @type Array
     * @protected
     */
    _defaultSliceColors: ["#66007f", "#a86f41", "#295454", "#996ab2", "#e8cdb7", "#90bdbd","#000000","#c3b8ca", "#968373", "#678585"],

    /**
     * Parses a color based on a series order and type.
     *
     * @method _getDefaultColor
     * @param {Number} index Index indicating the series order.
     * @param {String} type Indicates which type of object needs the color.
     * @return String
     * @protected
     */
    _getDefaultColor: function(index, type)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultColor", 8003);
_yuitest_coverline("build/charts-base/charts-base.js", 8005);
var colors = {
                line: this._defaultLineColors,
                fill: this._defaultFillColors,
                border: this._defaultBorderColors,
                slice: this._defaultSliceColors
            },
            col = colors[type],
            l = col.length;
        _yuitest_coverline("build/charts-base/charts-base.js", 8013);
index = index || 0;
        _yuitest_coverline("build/charts-base/charts-base.js", 8014);
if(index >= l)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8016);
index = index % l;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8018);
type = type || "fill";
        _yuitest_coverline("build/charts-base/charts-base.js", 8019);
return colors[type][index];
    },
    
    /**
     * Shows/hides contents of the series.
     *
     * @method _handleVisibleChange
     * @param {Object} e Event object.
     * @protected
     */
    _handleVisibleChange: function(e) 
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_handleVisibleChange", 8029);
_yuitest_coverline("build/charts-base/charts-base.js", 8031);
this._toggleVisible(this.get("visible"));
    },

    /**
     * Returns the sum of all values for the series.
     *
     * @method getTotalValues
     * @return Number
     */
    getTotalValues: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "getTotalValues", 8040);
_yuitest_coverline("build/charts-base/charts-base.js", 8042);
var total = this.get("valueAxis").getTotalByKey(this.get("valueKey"));
        _yuitest_coverline("build/charts-base/charts-base.js", 8043);
return total;
    },

    /**
     * Destructor implementation for the CartesianSeries class. Calls destroy on all Graphic instances.
     *
     * @method destructor
     * @protected
     */
    destructor: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "destructor", 8052);
_yuitest_coverline("build/charts-base/charts-base.js", 8054);
var marker,
            markers = this.get("markers");
        _yuitest_coverline("build/charts-base/charts-base.js", 8056);
if(this.get("rendered"))
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8058);
if(this._xDataReadyHandle)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8060);
this._xDataReadyHandle.detach();
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 8062);
if(this._xDataUpdateHandle)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8064);
this._xDataUpdateHandle.detach();
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 8066);
if(this._yDataReadyHandle)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8068);
this._yDataReadyHandle.detach();
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 8070);
if(this._yDataUpdateHandle)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8072);
this._yDataUpdateHandle.detach();
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 8074);
this._xAxisChangeHandle.detach();
            _yuitest_coverline("build/charts-base/charts-base.js", 8075);
this._yAxisChangeHandle.detach();
            _yuitest_coverline("build/charts-base/charts-base.js", 8076);
this._stylesChangeHandle.detach();
            _yuitest_coverline("build/charts-base/charts-base.js", 8077);
this._widthChangeHandle.detach();
            _yuitest_coverline("build/charts-base/charts-base.js", 8078);
this._heightChangeHandle.detach();
            _yuitest_coverline("build/charts-base/charts-base.js", 8079);
this._visibleChangeHandle.detach();
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8081);
while(markers && markers.length > 0)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8083);
marker = markers.shift();
            _yuitest_coverline("build/charts-base/charts-base.js", 8084);
if(marker && marker instanceof Y.Shape)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8086);
marker.destroy();
            }
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8089);
if(this._path)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8091);
this._path.destroy();
            _yuitest_coverline("build/charts-base/charts-base.js", 8092);
this._path = null;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8094);
if(this._lineGraphic)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8096);
this._lineGraphic.destroy();
            _yuitest_coverline("build/charts-base/charts-base.js", 8097);
this._lineGraphic = null;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8099);
if(this._groupMarker)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8101);
this._groupMarker.destroy();
            _yuitest_coverline("build/charts-base/charts-base.js", 8102);
this._groupMarker = null;
        }
    }
        /**
         * Event handle for the x-axis' dataReady event.
         * 
         * @property _xDataReadyHandle
         * @type {EventHandle}
         * @private
         */
        
        /**
         * Event handle for the x-axis dataUpdate event.
         *
         * @property _xDataUpdateHandle
         * @type {EventHandle}
         * @private
         */
        
        /**
         * Event handle for the y-axis dataReady event.
         *
         * @property _yDataReadyHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the y-axis dataUpdate event.
         * @property _yDataUpdateHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the xAxisChange event.
         * @property _xAxisChangeHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the yAxisChange event.
         * @property _yAxisChangeHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the stylesChange event.
         * @property _stylesChangeHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the widthChange event.
         * @property _widthChangeHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the heightChange event.
         * @property _heightChangeHandle
         * @type {EventHandle}
         * @private
         */

        /**
         * Event handle for the visibleChange event.
         * @property _visibleChangeHandle
         * @type {EventHandle}
         * @private
         */
}, {
    ATTRS: {
        /**
         * Name used for for displaying data related to the x-coordinate.
         *
         * @attribute xDisplayName
         * @type String
         */
        xDisplayName: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8186);
_yuitest_coverline("build/charts-base/charts-base.js", 8188);
return this._xDisplayName || this.get("xKey");
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8191);
_yuitest_coverline("build/charts-base/charts-base.js", 8193);
this._xDisplayName = val.toString();
                _yuitest_coverline("build/charts-base/charts-base.js", 8194);
return val;
            }
        },

        /**
         * Name used for for displaying data related to the y-coordinate.
         *
         * @attribute yDisplayName
         * @type String
         */
        yDisplayName: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8205);
_yuitest_coverline("build/charts-base/charts-base.js", 8207);
return this._yDisplayName || this.get("yKey");
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8210);
_yuitest_coverline("build/charts-base/charts-base.js", 8212);
this._yDisplayName = val.toString();
                _yuitest_coverline("build/charts-base/charts-base.js", 8213);
return val;
            }
        },
        
        /**
         * Name used for for displaying category data
         *
         * @attribute categoryDisplayName
         * @type String
         * @readOnly
         */
        categoryDisplayName: {
            lazyAdd: false,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8227);
_yuitest_coverline("build/charts-base/charts-base.js", 8229);
return this.get("direction") == "vertical" ? this.get("yDisplayName") : this.get("xDisplayName");
           },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8232);
_yuitest_coverline("build/charts-base/charts-base.js", 8234);
if(this.get("direction") == "vertical")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8236);
this._yDisplayName = val;
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8240);
this._xDisplayName = val;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 8242);
return val;
            }
        },

        /**
         * Name used for for displaying value data
         *
         * @attribute valueDisplayName
         * @type String
         * @readOnly
         */
        valueDisplayName: {
            lazyAdd: false,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8256);
_yuitest_coverline("build/charts-base/charts-base.js", 8258);
return this.get("direction") == "vertical" ? this.get("xDisplayName") : this.get("yDisplayName");
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8261);
_yuitest_coverline("build/charts-base/charts-base.js", 8263);
if(this.get("direction") == "vertical")
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8265);
this._xDisplayName = val;
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8269);
this._yDisplayName = val;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 8271);
return val;
            }
        },
        
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default cartesian
         */
        type: {		
            value: "cartesian"
        },

        /**
         * Order of this instance of this `type`.
         *
         * @attribute order
         * @type Number
         */
        order: {},

        /**
         * Order of the instance
         *
         * @attribute graphOrder
         * @type Number
         */
        graphOrder: {},

        /**
         * x coordinates for the series.
         *
         * @attribute xcoords
         * @type Array
         */
        xcoords: {},
        
        /**
         * y coordinates for the series
         *
         * @attribute ycoords
         * @type Array
         */
        ycoords: {},

        /**
         * Reference to the `Chart` application.
         *
         * @attribute chart
         * @type ChartBase
         * @readOnly
         */
        chart: {
            readOnly: true,

            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8328);
_yuitest_coverline("build/charts-base/charts-base.js", 8330);
return this.get("graph").get("chart");
            }
        },
        
        /**
         * Reference to the `Graph` in which the series is drawn into.
         *
         * @attribute graph
         * @type Graph
         */
        graph: {},

        /**
         * Reference to the `Axis` instance used for assigning 
         * x-values to the graph.
         *
         * @attribute xAxis
         * @type Axis
         */
        xAxis: {},
        
        /**
         * Reference to the `Axis` instance used for assigning 
         * y-values to the graph.
         *
         * @attribute yAxis
         * @type Axis
         */
        yAxis: {},
        
        /**
         * Indicates which array to from the hash of value arrays in 
         * the x-axis `Axis` instance.
         *
         * @attribute xKey
         * @type String
         */
        xKey: {
            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8368);
_yuitest_coverline("build/charts-base/charts-base.js", 8370);
return val.toString();
            }
        },

        /**
         * Indicates which array to from the hash of value arrays in 
         * the y-axis `Axis` instance.
         *
         * @attribute yKey
         * @type String
         */
        yKey: {
            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8382);
_yuitest_coverline("build/charts-base/charts-base.js", 8384);
return val.toString();
            }
        },

        /**
         * Array of x values for the series.
         *
         * @attribute xData
         * @type Array
         */
        xData: {},

        /**
         * Array of y values for the series.
         *
         * @attribute yData
         * @type Array
         */
        yData: {},
       
        /**
         * Indicates whether the Series has been through its initial set up.
         *
         * @attribute rendered
         * @type Boolean
         */
        rendered: {
            value: false
        },

        /*
         * Returns the width of the parent graph
         *
         * @attribute width
         * @type Number
         */
        width: {
            readOnly: true,
            
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8423);
_yuitest_coverline("build/charts-base/charts-base.js", 8425);
this.get("graph").get("width");
            }
        },

        /**
         * Returns the height of the parent graph
         *
         * @attribute height
         * @type Number
         */
        height: {
            readOnly: true,
            
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8438);
_yuitest_coverline("build/charts-base/charts-base.js", 8440);
this.get("graph").get("height");
            }
        },

        /**
         * Indicates whether to show the series
         *
         * @attribute visible
         * @type Boolean
         * @default true
         */
        visible: {
            value: true
        },

        /**
         * Collection of area maps along the xAxis. Used to determine mouseover for multiple
         * series.
         *
         * @attribute xMarkerPlane
         * @type Array
         */
        xMarkerPlane: {},
        
        /**
         * Collection of area maps along the yAxis. Used to determine mouseover for multiple
         * series.
         *
         * @attribute yMarkerPlane
         * @type Array
         */
        yMarkerPlane: {},

        /**
         * Distance from a data coordinate to the left/right for setting a hotspot.
         *
         * @attribute xMarkerPlaneOffset
         * @type Number
         */
        xMarkerPlaneOffset: {
            getter: function() {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8480);
_yuitest_coverline("build/charts-base/charts-base.js", 8481);
var marker = this.get("styles").marker;
                _yuitest_coverline("build/charts-base/charts-base.js", 8482);
if(marker && marker.width && isFinite(marker.width))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8484);
return marker.width * 0.5;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 8486);
return this._defaultPlaneOffset;
            }
        },

        /**
         * Distance from a data coordinate to the top/bottom for setting a hotspot.
         *
         * @attribute yMarkerPlaneOffset
         * @type Number
         */
        yMarkerPlaneOffset: {
            getter: function() {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8497);
_yuitest_coverline("build/charts-base/charts-base.js", 8498);
var marker = this.get("styles").marker;
                _yuitest_coverline("build/charts-base/charts-base.js", 8499);
if(marker && marker.height && isFinite(marker.height))
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8501);
return marker.height * 0.5;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 8503);
return this._defaultPlaneOffset;
            }
        },

        /**
         * Direction of the series
         *
         * @attribute direction
         * @type String
         */
        direction: {
            value: "horizontal"
        },

        /**
         * Indicates whether or not markers for a series will be grouped and rendered in a single complex shape instance.
         *
         * @attribute groupMarkers
         * @type Boolean
         */
        groupMarkers: {
            getter: function()
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "getter", 8524);
_yuitest_coverline("build/charts-base/charts-base.js", 8526);
if(this._groupMarkers === undefined)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8528);
return this.get("graph").get("groupMarkers");
                }
                else
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8532);
return this._groupMarkers;
                }
            },

            setter: function(val)
            {
                _yuitest_coverfunc("build/charts-base/charts-base.js", "setter", 8536);
_yuitest_coverline("build/charts-base/charts-base.js", 8538);
this._groupMarkers = val;
                _yuitest_coverline("build/charts-base/charts-base.js", 8539);
return val;
            }
        }
    }
});
/**
 * The MarkerSeries class renders quantitative data by plotting relevant data points 
 * on a graph.
 *
 * @module charts
 * @submodule charts-base
 * @class MarkerSeries
 * @extends CartesianSeries
 * @uses Plots
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8555);
Y.MarkerSeries = Y.Base.create("markerSeries", Y.CartesianSeries, [Y.Plots], {
    /**
     * @protected
     *
     * Draws the series.
     *
     * @method drawSeries
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 8563);
_yuitest_coverline("build/charts-base/charts-base.js", 8565);
this.drawPlots();
    },
    
    /**
     * @protected
     *
     * Method used by `styles` setter. Overrides base implementation.
     *
     * @method _setStyles
     * @param {Object} newStyles Hash of properties to update.
     * @return Object
     */
    _setStyles: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setStyles", 8577);
_yuitest_coverline("build/charts-base/charts-base.js", 8579);
if(!val.marker)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8581);
val = {marker:val};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8583);
val = this._parseMarkerStyles(val);
        _yuitest_coverline("build/charts-base/charts-base.js", 8584);
return Y.MarkerSeries.superclass._mergeStyles.apply(this, [val, this._getDefaultStyles()]);
    },
    
    /**
     * @protected
     *
     * Gets the default value for the `styles` attribute. Overrides
     * base implementation.
     *
     * @method _getDefaultStyles
     * @return Object
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 8596);
_yuitest_coverline("build/charts-base/charts-base.js", 8598);
var styles = this._mergeStyles({marker:this._getPlotDefaults()}, Y.MarkerSeries.superclass._getDefaultStyles());
        _yuitest_coverline("build/charts-base/charts-base.js", 8599);
return styles;
    }
},{
    ATTRS : {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default marker
         */
        type: {
            value:"marker"
        }
        
        /**
         * Style properties used for drawing markers. This attribute is inherited from `Renderer`. Below are the default values:
         *  <dl>
         *      <dt>fill</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#6084d0", "#eeb647", "#6c6b5f", "#d6484f", "#ce9ed1", "#ff9f3b", "#93b7ff", "#e0ddd0", "#94ecba", "#309687"]`
         *              </dd>
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>border</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#205096", "#b38206", "#000000", "#94001e", "#9d6fa0", "#e55b00", "#5e85c9", "#adab9e", "#6ac291", "#006457"]`
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>
         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 10.</dd>
         *      <dt>height</dt><dd>indicates the height of the marker The default value is 10.</dd>
         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default 
         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,
         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});

/**
 * The LineSeries class renders quantitative data on a graph by connecting relevant data points.
 *
 * @module charts
 * @submodule charts-base
 * @class LineSeries
 * @extends CartesianSeries
 * @uses Lines
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8658);
Y.LineSeries = Y.Base.create("lineSeries", Y.CartesianSeries, [Y.Lines], {
    /**
     * @protected
     *
     * @method drawSeries
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 8664);
_yuitest_coverline("build/charts-base/charts-base.js", 8666);
this.drawLines();
    },

    /**
     * @protected
     *
     * Method used by `styles` setter. Overrides base implementation.
     *
     * @method _setStyles
     * @param {Object} newStyles Hash of properties to update.
     * @return Object
     */
    _setStyles: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setStyles", 8678);
_yuitest_coverline("build/charts-base/charts-base.js", 8680);
if(!val.line)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8682);
val = {line:val};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8684);
return Y.LineSeries.superclass._setStyles.apply(this, [val]);
    },

    /**
     * @protected
     *
     * Gets the default value for the `styles` attribute. Overrides
     * base implementation.
     *
     * @method _getDefaultStyles
     * @return Object
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 8696);
_yuitest_coverline("build/charts-base/charts-base.js", 8698);
var styles = this._mergeStyles({line:this._getLineDefaults()}, Y.LineSeries.superclass._getDefaultStyles());
        _yuitest_coverline("build/charts-base/charts-base.js", 8699);
return styles;
    }
},
{
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default line
         */
        type: {
            value:"line"
        }

        /**
         * Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the default values:
         *  <dl>
         *      <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color will be
         *      retrieved from the following array: 
         *      `["#426ab3", "#d09b2c", "#000000", "#b82837", "#b384b5", "#ff7200", "#779de3", "#cbc8ba", "#7ed7a6", "#007a6c"]`
         *      <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>
         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>
         *      <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd> 
         *      <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>
         *      <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>
         *      <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value between points. The default value is true.</dd> 
         *      <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default value is solid.</dd>
         *      <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default value is 10.</dd>
         *      <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default value is 10.</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});



		

		
/**
 * SplineSeries renders a graph with data points connected by a curve.
 *
 * @module charts
 * @submodule charts-base
 * @class SplineSeries
 * @constructor
 * @extends CartesianSeries
 * @uses CurveUtil
 * @uses Lines
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8754);
Y.SplineSeries = Y.Base.create("splineSeries",  Y.LineSeries, [Y.CurveUtil, Y.Lines], {
    /**
     * @protected
     *
     * Draws the series.
     *
     * @method drawSeries
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 8762);
_yuitest_coverline("build/charts-base/charts-base.js", 8764);
this.drawSpline();
    }
}, {
	ATTRS : {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default spline
         */
        type : {
            value:"spline"
        }

        /**
         * Style properties used for drawing lines. This attribute is inherited from `Renderer`. Below are the default values:
         *  <dl>
         *      <dt>color</dt><dd>The color of the line. The default value is determined by the order of the series on the graph. The color will be
         *      retrieved from the following array: 
         *      `["#426ab3", "#d09b2c", "#000000", "#b82837", "#b384b5", "#ff7200", "#779de3", "#cbc8ba", "#7ed7a6", "#007a6c"]`
         *      <dt>weight</dt><dd>Number that indicates the width of the line. The default value is 6.</dd>
         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the line. The default value is 1.</dd>
         *      <dt>lineType</dt><dd>Indicates whether the line is solid or dashed. The default value is solid.</dd> 
         *      <dt>dashLength</dt><dd>When the `lineType` is dashed, indicates the length of the dash. The default value is 10.</dd>
         *      <dt>gapSpace</dt><dd>When the `lineType` is dashed, indicates the distance between dashes. The default value is 10.</dd>
         *      <dt>connectDiscontinuousPoints</dt><dd>Indicates whether or not to connect lines when there is a missing or null value between points. The default value is true.</dd> 
         *      <dt>discontinuousType</dt><dd>Indicates whether the line between discontinuous points is solid or dashed. The default value is solid.</dd>
         *      <dt>discontinuousDashLength</dt><dd>When the `discontinuousType` is dashed, indicates the length of the dash. The default value is 10.</dd>
         *      <dt>discontinuousGapSpace</dt><dd>When the `discontinuousType` is dashed, indicates the distance between dashes. The default value is 10.</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});



		

		
/**
 * StackedSplineSeries creates spline graphs in which the different series are stacked along a value axis
 * to indicate their contribution to a cumulative total.
 *
 * @module charts
 * @submodule charts-base
 * @class StackedSplineSeries
 * @constructor
 * @extends SplineSeries
 * @extends StackingUtil
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8818);
Y.StackedSplineSeries = Y.Base.create("stackedSplineSeries", Y.SplineSeries, [Y.StackingUtil], {
    /**
     * @protected
     *
     * Calculates the coordinates for the series. Overrides base implementation.
     *
     * @method setAreaData
     */
    setAreaData: function()
    {   
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setAreaData", 8826);
_yuitest_coverline("build/charts-base/charts-base.js", 8828);
Y.StackedSplineSeries.superclass.setAreaData.apply(this);
        _yuitest_coverline("build/charts-base/charts-base.js", 8829);
this._stackCoordinates.apply(this);
    }
}, {
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default stackedSpline
         */
        type: {
            value:"stackedSpline"
        }
    }
});

/**
 * StackedMarkerSeries plots markers with different series stacked along the value axis to indicate each
 * series' contribution to a cumulative total.
 *
 * @module charts
 * @submodule charts-base
 * @class StackedMarkerSeries
 * @constructor
 * @extends MarkerSeries
 * @extends StackingUtil
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8857);
Y.StackedMarkerSeries = Y.Base.create("stackedMarkerSeries", Y.MarkerSeries, [Y.StackingUtil], {
    /**
     * @protected
     *
     * Calculates the coordinates for the series. Overrides base implementation.
     *
     * @method setAreaData
     */
    setAreaData: function()
    {   
        _yuitest_coverfunc("build/charts-base/charts-base.js", "setAreaData", 8865);
_yuitest_coverline("build/charts-base/charts-base.js", 8867);
Y.StackedMarkerSeries.superclass.setAreaData.apply(this);
        _yuitest_coverline("build/charts-base/charts-base.js", 8868);
this._stackCoordinates.apply(this);
    }
}, {
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default stackedMarker
         */
        type: {
            value:"stackedMarker"
        }
    }
});

/**
 * The ColumnSeries class renders columns positioned horizontally along a category or time axis. The columns'
 * lengths are proportional to the values they represent along a vertical axis.
 * and the relevant data points.
 *
 * @module charts
 * @submodule charts-base
 * @class ColumnSeries
 * @extends MarkerSeries
 * @uses Histogram
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 8897);
Y.ColumnSeries = Y.Base.create("columnSeries", Y.MarkerSeries, [Y.Histogram], {
    /**
     * Helper method for calculating the size of markers. 
     *
     * @method _getMarkerDimensions
     * @param {Number} xcoord The x-coordinate representing the data point for the marker.
     * @param {Number} ycoord The y-coordinate representing the data point for the marker.
     * @param {Number} calculatedSize The calculated size for the marker. For a `BarSeries` is it the width. For a `ColumnSeries` it is the height.
     * @param {Number} offset Distance of position offset dictated by other marker series in the same graph.
     * @return Object
     * @private
     */
    _getMarkerDimensions: function(xcoord, ycoord, calculatedSize, offset)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getMarkerDimensions", 8909);
_yuitest_coverline("build/charts-base/charts-base.js", 8911);
var config = {
            left: xcoord + offset
        };
        _yuitest_coverline("build/charts-base/charts-base.js", 8914);
if(this._bottomOrigin >= ycoord)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8916);
config.top = ycoord;
            _yuitest_coverline("build/charts-base/charts-base.js", 8917);
config.calculatedSize = this._bottomOrigin - config.top;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8921);
config.top = this._bottomOrigin;
            _yuitest_coverline("build/charts-base/charts-base.js", 8922);
config.calculatedSize = ycoord - this._bottomOrigin;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 8924);
return config;
    },

    /**
     * Resizes and positions markers based on a mouse interaction.
     *
     * @method updateMarkerState
     * @param {String} type state of the marker
     * @param {Number} i index of the marker
     * @protected
     */
    updateMarkerState: function(type, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMarkerState", 8935);
_yuitest_coverline("build/charts-base/charts-base.js", 8937);
if(this._markers && this._markers[i])
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 8939);
var styles = Y.clone(this.get("styles").marker),
                markerStyles,
                state = this._getState(type),
                xcoords = this.get("xcoords"),
                ycoords = this.get("ycoords"),
                marker = this._markers[i],
                markers,
                graph = this.get("graph"),
                seriesStyles,
                seriesCollection = graph.seriesTypes[this.get("type")],
                seriesLen = seriesCollection.length,
                seriesSize = 0,
                offset = 0,
                renderer,
                n = 0,
                xs = [],
                order = this.get("order"),
                config;
            _yuitest_coverline("build/charts-base/charts-base.js", 8957);
markerStyles = state == "off" || !styles[state] ? Y.clone(styles) : Y.clone(styles[state]); 
            _yuitest_coverline("build/charts-base/charts-base.js", 8958);
markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);
            _yuitest_coverline("build/charts-base/charts-base.js", 8959);
markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);
            _yuitest_coverline("build/charts-base/charts-base.js", 8960);
config = this._getMarkerDimensions(xcoords[i], ycoords[i], styles.width, offset);
            _yuitest_coverline("build/charts-base/charts-base.js", 8961);
markerStyles.height = config.calculatedSize;
            _yuitest_coverline("build/charts-base/charts-base.js", 8962);
markerStyles.width = Math.min(this._maxSize, markerStyles.width);
            _yuitest_coverline("build/charts-base/charts-base.js", 8963);
marker.set(markerStyles);
            _yuitest_coverline("build/charts-base/charts-base.js", 8964);
for(; n < seriesLen; ++n)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8966);
xs[n] = xcoords[i] + seriesSize;
                _yuitest_coverline("build/charts-base/charts-base.js", 8967);
seriesStyles = seriesCollection[n].get("styles").marker;
                _yuitest_coverline("build/charts-base/charts-base.js", 8968);
seriesSize += Math.min(this._maxSize, seriesStyles.width);
                _yuitest_coverline("build/charts-base/charts-base.js", 8969);
if(order > n)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8971);
offset = seriesSize;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 8973);
offset -= seriesSize/2;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 8975);
for(n = 0; n < seriesLen; ++n)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 8977);
markers = seriesCollection[n].get("markers");
                _yuitest_coverline("build/charts-base/charts-base.js", 8978);
if(markers)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 8980);
renderer = markers[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 8981);
if(renderer && renderer !== undefined)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 8983);
renderer.set("x", (xs[n] - seriesSize/2));
                    }
                }
            }
        }
    }
}, {
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @readOnly
         * @default column
         */
        type: {
            value: "column"
        }
        
        /**
         * Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:
         *  <dl>
         *      <dt>fill</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#66007f", "#a86f41", "#295454", "#996ab2", "#e8cdb7", "#90bdbd","#000000","#c3b8ca", "#968373", "#678585"]`
         *              </dd>
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>border</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#205096", "#b38206", "#000000", "#94001e", "#9d6fa0", "#e55b00", "#5e85c9", "#adab9e", "#6ac291", "#006457"]`
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>
         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>width</dt><dd>indicates the width of the marker. The default value is 12.</dd>
         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default 
         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,
         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});
/**
 * The BarSeries class renders bars positioned vertically along a category or time axis. The bars'
 * lengths are proportional to the values they represent along a horizontal axis.
 * and the relevant data points.
 *
 * @module charts
 * @submodule charts-base
 * @class BarSeries
 * @extends MarkerSeries
 * @uses Histogram
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 9047);
Y.BarSeries = Y.Base.create("barSeries", Y.MarkerSeries, [Y.Histogram], {
    /**
     * Helper method for calculating the size of markers. 
     *
     * @method _getMarkerDimensions
     * @param {Number} xcoord The x-coordinate representing the data point for the marker.
     * @param {Number} ycoord The y-coordinate representing the data point for the marker.
     * @param {Number} calculatedSize The calculated size for the marker. For a `BarSeries` is it the width. For a `ColumnSeries` it is the height.
     * @param {Number} offset Distance of position offset dictated by other marker series in the same graph.
     * @return Object
     * @private
     */
    _getMarkerDimensions: function(xcoord, ycoord, calculatedSize, offset)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getMarkerDimensions", 9059);
_yuitest_coverline("build/charts-base/charts-base.js", 9061);
var config = {
            top: ycoord + offset
        };
        _yuitest_coverline("build/charts-base/charts-base.js", 9064);
if(xcoord >= this._leftOrigin)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 9066);
config.left = this._leftOrigin;
            _yuitest_coverline("build/charts-base/charts-base.js", 9067);
config.calculatedSize = xcoord - config.left;
        }
        else
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 9071);
config.left = xcoord;
            _yuitest_coverline("build/charts-base/charts-base.js", 9072);
config.calculatedSize = this._leftOrigin - xcoord;
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 9074);
return config;
    },
    
    /**
     * Resizes and positions markers based on a mouse interaction.
     *
     * @method updateMarkerState
     * @param {String} type state of the marker
     * @param {Number} i index of the marker
     * @protected
     */
    updateMarkerState: function(type, i)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "updateMarkerState", 9085);
_yuitest_coverline("build/charts-base/charts-base.js", 9087);
if(this._markers && this._markers[i])
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 9089);
var styles = Y.clone(this.get("styles").marker),
                markerStyles,
                state = this._getState(type),
                xcoords = this.get("xcoords"),
                ycoords = this.get("ycoords"),
                marker = this._markers[i],
                markers,
                graph = this.get("graph"),
                seriesCollection = graph.seriesTypes[this.get("type")],
                seriesLen = seriesCollection.length,
                seriesStyles,
                seriesSize = 0,
                offset = 0,
                renderer,
                n = 0,
                ys = [],
                order = this.get("order"),
                config;
            _yuitest_coverline("build/charts-base/charts-base.js", 9107);
markerStyles = state == "off" || !styles[state] ? styles : styles[state]; 
            _yuitest_coverline("build/charts-base/charts-base.js", 9108);
markerStyles.fill.color = this._getItemColor(markerStyles.fill.color, i);
            _yuitest_coverline("build/charts-base/charts-base.js", 9109);
markerStyles.border.color = this._getItemColor(markerStyles.border.color, i);
            _yuitest_coverline("build/charts-base/charts-base.js", 9110);
config = this._getMarkerDimensions(xcoords[i], ycoords[i], styles.height, offset);
            _yuitest_coverline("build/charts-base/charts-base.js", 9111);
markerStyles.width = config.calculatedSize;
            _yuitest_coverline("build/charts-base/charts-base.js", 9112);
markerStyles.height = Math.min(this._maxSize, markerStyles.height);
            _yuitest_coverline("build/charts-base/charts-base.js", 9113);
marker.set(markerStyles);
            _yuitest_coverline("build/charts-base/charts-base.js", 9114);
for(; n < seriesLen; ++n)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 9116);
ys[n] = ycoords[i] + seriesSize;
                _yuitest_coverline("build/charts-base/charts-base.js", 9117);
seriesStyles = seriesCollection[n].get("styles").marker;
                _yuitest_coverline("build/charts-base/charts-base.js", 9118);
seriesSize += Math.min(this._maxSize, seriesStyles.height); 
                _yuitest_coverline("build/charts-base/charts-base.js", 9119);
if(order > n)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 9121);
offset = seriesSize;
                }
                _yuitest_coverline("build/charts-base/charts-base.js", 9123);
offset -= seriesSize/2;
            }
            _yuitest_coverline("build/charts-base/charts-base.js", 9125);
for(n = 0; n < seriesLen; ++n)
            {
                _yuitest_coverline("build/charts-base/charts-base.js", 9127);
markers = seriesCollection[n].get("markers");
                _yuitest_coverline("build/charts-base/charts-base.js", 9128);
if(markers)
                {
                    _yuitest_coverline("build/charts-base/charts-base.js", 9130);
renderer = markers[i];
                    _yuitest_coverline("build/charts-base/charts-base.js", 9131);
if(renderer && renderer !== undefined)
                    {
                        _yuitest_coverline("build/charts-base/charts-base.js", 9133);
renderer.set("y", (ys[n] - seriesSize/2));
                    }
                }
            }
        }
    }
}, {
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default bar
         */
        type: {
            value: "bar"
        },

        /**
         * Indicates the direction of the category axis that the bars are plotted against.
         *
         * @attribute direction
         * @type String
         */
        direction: {
            value: "vertical"
        }
        
        /**
         * Style properties used for drawing markers. This attribute is inherited from `MarkerSeries`. Below are the default values:
         *  <dl>
         *      <dt>fill</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the fill. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#66007f", "#a86f41", "#295454", "#996ab2", "#e8cdb7", "#90bdbd","#000000","#c3b8ca", "#968373", "#678585"]`
         *              </dd>
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>border</dt><dd>A hash containing the following values:
         *          <dl>
         *              <dt>color</dt><dd>Color of the border. The default value is determined by the order of the series on the graph. The color
         *              will be retrieved from the below array:<br/>
         *              `["#205096", "#b38206", "#000000", "#94001e", "#9d6fa0", "#e55b00", "#5e85c9", "#adab9e", "#6ac291", "#006457"]`
         *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>
         *              <dt>weight</dt><dd>Number indicating the width of the border. The default value is 1.</dd>
         *          </dl>
         *      </dd>
         *      <dt>height</dt><dd>indicates the width of the marker. The default value is 12.</dd>
         *      <dt>over</dt><dd>hash containing styles for markers when highlighted by a `mouseover` event. The default 
         *      values for each style is null. When an over style is not set, the non-over value will be used. For example,
         *      the default value for `marker.over.fill.color` is equivalent to `marker.fill.color`.</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});
/**
 * The AreaSeries class renders quantitative data on a graph by creating a fill between 0
 * and the relevant data points.
 *
 * @module charts
 * @submodule charts-base
 * @class AreaSeries
 * @extends CartesianSeries
 * @uses Fills
 * @constructor
 */
_yuitest_coverline("build/charts-base/charts-base.js", 9205);
Y.AreaSeries = Y.Base.create("areaSeries", Y.CartesianSeries, [Y.Fills], {
    /**
     * @protected
     *
     * Renders the series. 
     *
     * @method drawSeries
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 9213);
_yuitest_coverline("build/charts-base/charts-base.js", 9215);
this.drawFill.apply(this, this._getClosingPoints());
    },
    
    /**
     * @protected
     *
     * Method used by `styles` setter. Overrides base implementation.
     *
     * @method _setStyles
     * @param {Object} newStyles Hash of properties to update.
     * @return Object
     */
    _setStyles: function(val)
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_setStyles", 9227);
_yuitest_coverline("build/charts-base/charts-base.js", 9229);
if(!val.area)
        {
            _yuitest_coverline("build/charts-base/charts-base.js", 9231);
val = {area:val};
        }
        _yuitest_coverline("build/charts-base/charts-base.js", 9233);
return Y.AreaSeries.superclass._setStyles.apply(this, [val]);
    },

    /**
     * @protected
     *
     * Gets the default value for the `styles` attribute. Overrides
     * base implementation.
     *
     * @method _getDefaultStyles
     * @return Object
     */
    _getDefaultStyles: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "_getDefaultStyles", 9245);
_yuitest_coverline("build/charts-base/charts-base.js", 9247);
var styles = this._mergeStyles({area:this._getAreaDefaults()}, Y.AreaSeries.superclass._getDefaultStyles());
        _yuitest_coverline("build/charts-base/charts-base.js", 9248);
return styles;
    }
},
{
    ATTRS: {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default area
         */
        type: {
            value:"area"
        }
        
        /**
         * Style properties used for drawing area fills. This attribute is inherited from `Renderer`. Below are the default values:
         *
         *  <dl>
         *      <dt>color</dt><dd>The color of the fill. The default value is determined by the order of the series on the graph. The color will be 
         *      retrieved from the following array:
         *      `["#66007f", "#a86f41", "#295454", "#996ab2", "#e8cdb7", "#90bdbd","#000000","#c3b8ca", "#968373", "#678585"]`
         *      </dd>
         *      <dt>alpha</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1</dd>
         *  </dl>
         *
         * @attribute styles
         * @type Object
         */
    }
});



		

		
/**
 * AreaSplineSeries renders an area graph with data points connected by a curve.
 *
 * @module charts
 * @submodule charts-base
 * @class AreaSplineSeries
 * @constructor
 * @extends CartesianSeries
 * @uses Fills
 * @uses CurveUtil
 */
_yuitest_coverline("build/charts-base/charts-base.js", 9297);
Y.AreaSplineSeries = Y.Base.create("areaSplineSeries", Y.AreaSeries, [Y.CurveUtil], {
    /**
     * @protected
     *
     * Draws the series.
     *
     * @method drawSeries
     */
    drawSeries: function()
    {
        _yuitest_coverfunc("build/charts-base/charts-base.js", "drawSeries", 9305);
_yuitest_coverline("build/charts-base/charts-base.js", 9307);
this.drawAreaSpline();
    }
}, {
	ATTRS : {
        /**
         * Read-only attribute indicating the type of series.
         *
         * @attribute type
         * @type String
         * @default areaSpline
         */
        type: {
            value:"are