<?PHP //$Id: block_login.php,v 1.19.2.3 2007/03/22 12:40:39 skodak Exp $

class block_login extends block_base {
    function init() {
        $this->title = get_string('login');
        $this->version = 2006102700; //TODO
    }

    function applicable_formats() {
        return array('site' => true);
    }

    function get_content () {
        global $USER, $CFG;
        $wwwroot = '';
        $signup = '';

        if ($this->content !== NULL) {
            return $this->content;
        }

        if (empty($CFG->loginhttps)) {
            $wwwroot = $CFG->wwwroot;
        } else {
            // This actually is not so secure ;-), 'cause we're
            // in unencrypted connection...
            $wwwroot = str_replace("http://", "https://", $CFG->wwwroot);
        }
        
        if (!empty($CFG->registerauth)) {
            $authplugin = get_auth_plugin($CFG->registerauth);
            if ($authplugin->can_signup()) {
                $signup = $wwwroot . '/login/signup.php';
            }
        }
        // TODO: now that we have multiauth it is hard to find out if there is a way to change password
        $forgot = $wwwroot . '/login/forgot_password.php';

        $username = get_moodle_cookie() === 'nobody' ? '' : get_moodle_cookie();

        $this->content->footer = '';
        $this->content->text = '';

        if (!isloggedin() or isguestuser()) {   // Show the block

            $this->content->text .= "\n".'<form class="loginform" id="login" method="post" action="'.$wwwroot.'/login/index.php">';

            $this->content->text .= '<div class="c1"><label for="login_username">'.get_string('username').'</label>: ';
// (Shirai078): ログイン時のユーザ名自動入力機能を抑制する改良 (2008/08/06)
// (Shirai181): 携帯電話でログインする時にユーザ名入力フォームで入力モードを自動的にアルファベットに変更する機能の追加 (2010/02/10)
// (Shirai078): 以下一行コメントアウト
//          $this->content->text .= '<input type="text" name="username" id="login_username" value="'.s($username).'" /></div>';
// (Shirai078): ここから追加
            $this->content->text .= '<input type="text" name="username" id="login_username" value=';
            if (!fs_function_enable('FS_ENABLE_VOIDLOGINNAME')) $this->content->text .= '"'.s($username).'"';
                else                                            $this->content->text .= '""';
            $this->content->text .= keitai_alphabet4input();    // (Shirai181)
            $this->content->text .= ' /></div>';
// (Shirai078): ここまで追加

            $this->content->text .= '<div class="c1"><label for="login_password">'.get_string('password').'</label>: ';
            $this->content->text .= '<input type="password" name="password" id="login_password" value="" /></div>';

            $this->content->text .= '<div class="c1 btn"><input type="submit" value="'.get_string('login').'" /></div>';

            $this->content->text .= "</form>\n";

            if (!empty($signup)) {
                $this->content->footer .= '<div><a href="'.$signup.'">'.get_string('startsignup').'</a></div>';
            }
            if (!empty($forgot)) {
                $this->content->footer .= '<div><a href="'.$forgot.'">'.get_string('forgotaccount').'</a></div>';
            }
        }

        return $this->content;
    }
}

?>
