<?php // $Id: index.php,v 1.111.2.8 2008/05/14 05:21:01 dongsheng Exp $

//  Manage all uploaded files in a course file area

//  All the Moodle-specific stuff is in this top section
//  Configuration and access control occurs here.
//  Must define:  USER, basedir, baseweb, html_header and html_footer
//  USER is a persistent variable using sessions

    require('../config.php');
    require($CFG->libdir.'/filelib.php');
    require($CFG->libdir.'/adminlib.php');

    $id      = required_param('id', PARAM_INT);
    $file    = optional_param('file', '', PARAM_PATH);
    $wdir    = optional_param('wdir', '', PARAM_PATH);
    $action  = optional_param('action', '', PARAM_ACTION);
    $name    = optional_param('name', '', PARAM_FILE);
    $oldname = optional_param('oldname', '', PARAM_FILE);
    $choose  = optional_param('choose', '', PARAM_FILE); //in fact it is always 'formname.inputname'
    $userfile= optional_param('userfile','',PARAM_FILE);
    $save    = optional_param('save', 0, PARAM_BOOL);
    $text    = optional_param('text', '', PARAM_RAW);
    $confirm = optional_param('confirm', 0, PARAM_BOOL);
// (Shirai014)  更新日時／ファイルサイズで並べ替え (2008/1/14) ここから追加
//  $sortorderfilelist is 
//    1=asort(filename),  2=arsort(filename)
//    3=ksort(filemtime), 4=krsort(filemtime)
//    5=ksort(filesize),  6=krsort(filesize)
    $sortorderfilelist = optional_param('sortorderfilelist', 0, PARAM_INT);
    if ($sortorderfilelist < 1) {
        if (isset($_SESSION['sortorderfilelist'])) $sortorderfilelist = $_SESSION['sortorderfilelist'];
            else $sortorderfilelist = 1; 
    } else $_SESSION['sortorderfilelist'] = $sortorderfilelist;
// (Shirai014): ここまで追加

    if ($choose) {
        if (count(explode('.', $choose)) > 2) {
            error('Incorrect format for choose parameter');
        }
    }


    if (! $course = get_record("course", "id", $id) ) {
        error("That's an invalid course id");
    }

    require_login($course);

    require_capability('moodle/course:managefiles', get_context_instance(CONTEXT_COURSE, $course->id));

    function html_footer() {
        global $course, $choose, $adminroot;

        echo '</td></tr></table>';

        if ($course->id == SITEID and !$choose) {
                admin_externalpage_print_footer($adminroot);
        } else {
            print_footer($course);
        }
    }

    function html_header($course, $wdir, $formfield=""){
        global $CFG, $ME, $choose;

        if ($course->id == SITEID) {
            $strfiles = get_string("sitefiles");
        } else {
            $strfiles = get_string("files");
        }

        if ($wdir == "/") {
            $fullnav = "$strfiles";
        } else {
            $dirs = explode("/", $wdir);
            $numdirs = count($dirs);
            $link = "";
            $navigation = "";
            for ($i=1; $i<$numdirs-1; $i++) {
               $navigation .= " -> ";
               $link .= "/".urlencode($dirs[$i]);
               $navigation .= "<a href=\"".$ME."?id=$course->id&amp;wdir=$link&amp;choose=$choose\">".$dirs[$i]."</a>";
            }
            $fullnav = "<a href=\"".$ME."?id=$course->id&amp;wdir=/&amp;choose=$choose\">$strfiles</a> $navigation -> ".$dirs[$numdirs-1];
        }


        if ($choose) {
            print_header();

            $chooseparts = explode('.', $choose);
            if (count($chooseparts)==2){
            ?>
            <script type="text/javascript">
            //<![CDATA[
            function set_value(txt) {
                opener.document.forms['<?php echo $chooseparts[0]."'].".$chooseparts[1] ?>.value = txt;
                window.close();
            }
            //]]>
            </script>

            <?php
            } elseif (count($chooseparts)==1){
            ?>
            <script type="text/javascript">
            //<![CDATA[
            function set_value(txt) {
                opener.document.getElementById('<?php echo $chooseparts[0] ?>').value = txt;
                window.close();
            }
            //]]>
            </script>

            <?php

            }
            $fullnav = str_replace('->', '&raquo;', format_string($course->shortname) . " -> $fullnav");
            echo '<div id="nav-bar">'.$fullnav.'</div>';

            if ($course->id == SITEID and $wdir != "/backupdata") {
                print_heading(get_string("publicsitefileswarning"), "center", 2);
            }

        } else {

            if ($course->id == SITEID) {

                if ($wdir == "/backupdata") {
                    $adminroot = admin_get_root();
                    admin_externalpage_setup('frontpagerestore', $adminroot);
                    admin_externalpage_print_header($adminroot);
                } else {
                    $adminroot = admin_get_root();
                    admin_externalpage_setup('sitefiles', $adminroot);
                    admin_externalpage_print_header($adminroot);

                    print_heading(get_string("publicsitefileswarning"), "center", 2);
                    
                }

            } else {
                print_header("$course->shortname: $strfiles", $course->fullname,
                             "<a href=\"../course/view.php?id=$course->id\">$course->shortname".
                             "</a> -> $fullnav", $formfield);
            }
        }


        echo "<table border=\"0\" style=\"margin-left:auto;margin-right:auto\" cellspacing=\"3\" cellpadding=\"3\" width=\"640\">";
        echo "<tr>";
        echo "<td colspan=\"2\">";

    }


    if (! $basedir = make_upload_directory("$course->id")) {
        error("The site administrator needs to fix the file permissions");
    }

    $baseweb = $CFG->wwwroot;

//  End of configuration and access control


    if ($wdir == '') {
        $wdir = "/";
    }

    if ($wdir{0} != '/') {  //make sure $wdir starts with slash
        $wdir = "/".$wdir;
    }

    if ($wdir == "/backupdata") {
        if (! make_upload_directory("$course->id/backupdata")) {   // Backup folder
            error("Could not create backupdata folder.  The site administrator needs to fix the file permissions");
        }
    }

// (FS_CONVERTER): ここから
//  if (!is_dir($basedir.$wdir)) {
    if (!fs_is_dir($basedir.$wdir)) {
// (FS_CONVERTER): ここまで
        html_header($course, $wdir);
        error("Requested directory does not exist.", "$CFG->wwwroot/files/index.php?id=$id");
    }

    switch ($action) {

        case "upload":
            html_header($course, $wdir);
            require_once($CFG->dirroot.'/lib/uploadlib.php');

            if ($save and confirm_sesskey()) {
                $course->maxbytes = 0;  // We are ignoring course limits
                $um = new upload_manager('userfile',false,false,$course,false,0);
                $dir = "$basedir$wdir";
                if ($um->process_file_uploads($dir)) {
                    notify(get_string('uploadedfile'));
                }
                // um will take care of error reporting.
                displaydir($wdir);
            } else {
                $upload_max_filesize = get_max_upload_file_size($CFG->maxbytes);
                $filesize = display_size($upload_max_filesize);

                $struploadafile = get_string("uploadafile");
                $struploadthisfile = get_string("uploadthisfile");
                $strmaxsize = get_string("maxsize", "", $filesize);
                $strcancel = get_string("cancel");

                echo "<p>$struploadafile ($strmaxsize) --> <b>$wdir</b></p>";
                echo "<form enctype=\"multipart/form-data\" method=\"post\" action=\"index.php\">";
                echo "<div>";             
                echo "<table><tr><td colspan=\"2\">";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"upload\" />";
                echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
                upload_print_form_fragment(1,array('userfile'),null,false,null,$upload_max_filesize,0,false);
                echo " </td></tr></table>";
                echo " <input type=\"submit\" name=\"save\" value=\"$struploadthisfile\" />";
                echo "</div>";
                echo "</form>";
                echo "<form action=\"index.php\" method=\"get\">";
                echo "<div>";             
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"$strcancel\" />";
                echo "</div>";
                echo "</form>";
            }
            html_footer();
            break;

// (FS_CONVERTER)：ファイルシステム文字コードの移行用：ここから追加
        case "convfs" :
            if ($confirm and confirm_sesskey()) {
                html_header($course, $wdir);
                if (!empty($USER->filelist)) {
                    foreach ($USER->filelist as $file) {
                        $fullfile = $basedir.'/'.$file;
                        // $fileは現在の文字コードでデコードされている.
                        // もし旧文字コードと同じ文字コードでファイルシステムに
                        // 存在可能な文字コード(擬似RAWURL)の場合は強制的にデコードする．
                        $path_parts = fs_pathinfo($file);
                        $pathdir = $path_parts['dirname'];
                        $file    = $path_parts['basename'];
                        if (fs_is_dir($fullfile) || fs_is_file($fullfile)) {
                            $file = oldfsCharset2currentCharset($file);
                        }
                        if (! rename(currentCharset2fsCharset($basedir.'/'.$pathdir).'/'.currentCharset2oldfsCharset($file), currentCharset2fsCharset($basedir.'/'.$pathdir).'/'.currentCharset2fsCharset($file))) {
                            echo "<br />Error: Could not convert: $fullfile";
                        }
                    }
                }
                clearfilelist();
                displaydir($wdir);
                html_footer();
            } else {
                html_header($course, $wdir);
                if (setfilelist($_POST)) {
//                  notify(get_string('deletecheckwarning').':');
                    notify('このフォルダ名／ファイル名を変換します:');
                    print_simple_box_start("center");
                    foreach ($USER->filelist as $file) {
                        $fullfile = $basedir.'/'.$file;
                        // $fileは現在の文字コードでデコードされている.
                        // もし旧文字コードと同じ文字コードでファイルシステムに
                        // 存在可能な文字コード(擬似RAWURL)の場合は強制的にデコードする．
                        if (fs_is_dir($fullfile) || fs_is_file($fullfile)) {
                            $file = oldfsCharset2currentCharset($file);
                        }
                        echo currentCharset2oldfsCharset($file).'->'.$file."<BR>";
                    }
                    print_simple_box_end();
                    echo "<br />";
                    $optionsyes = array('id'=>$id, 'wdir'=>$wdir, 'action'=>'convfs', 'confirm'=>1, 'sesskey'=>sesskey(), 'choose'=>$choose);
                    $optionsno  = array('id'=>$id, 'wdir'=>$wdir, 'action'=>'cancel', 'choose'=>$choose);
                    notice_yesno ('これらのフォルダ名／ファイル名を変換して良いですか？', 'index.php', 'index.php', $optionsyes, $optionsno, 'post', 'get');
//                  print_continue("index.php?id=$id&amp;wdir=$wdir&amp;action=cancel&amp;choose=$choose");
                } else {
                    displaydir($wdir);
                }
                html_footer();
            }
            break;
// (FS_CONVERTER)：ファイルシステム文字コードの移行用：ここまで追加

        case "delete":
            if ($confirm and confirm_sesskey()) {
                html_header($course, $wdir);
                if (!empty($USER->filelist)) {
                    foreach ($USER->filelist as $file) {
                        $fullfile = $basedir.'/'.$file;
                        if (! fulldelete($fullfile)) {
                            echo "<br />Error: Could not delete: $fullfile";
                        }
                    }
                }
                clearfilelist();
                displaydir($wdir);
                html_footer();

            } else {
                html_header($course, $wdir);

                if (setfilelist($_POST)) {
                    notify(get_string('deletecheckwarning').':');
                    print_simple_box_start("center");
                    printfilelist($USER->filelist);
                    print_simple_box_end();
                    echo "<br />";

                    require_once($CFG->dirroot.'/mod/resource/lib.php');
                    $block = resource_delete_warning($course, $USER->filelist);

                    if (empty($CFG->resource_blockdeletingfile) or $block == '') {
                        $optionsyes = array('id'=>$id, 'wdir'=>$wdir, 'action'=>'delete', 'confirm'=>1, 'sesskey'=>sesskey(), 'choose'=>$choose);
                        $optionsno  = array('id'=>$id, 'wdir'=>$wdir, 'action'=>'cancel', 'choose'=>$choose);
                        notice_yesno (get_string('deletecheckfiles'), 'index.php', 'index.php', $optionsyes, $optionsno, 'post', 'get');
                    } else {

                        notify(get_string('warningblockingdelete', 'resource'));
                        $options  = array('id'=>$id, 'wdir'=>$wdir, 'action'=>'cancel', 'choose'=>$choose);
                        print_continue("index.php?id=$id&amp;wdir=$wdir&amp;action=cancel&amp;choose=$choose");
                    }
                } else {
                    displaydir($wdir);
                }
                html_footer();
            }
            break;

        case "move":
            html_header($course, $wdir);
            if (($count = setfilelist($_POST)) and confirm_sesskey()) {
                $USER->fileop     = $action;
                $USER->filesource = $wdir;
                echo "<p class=\"centerpara\">";
                print_string("selectednowmove", "moodle", $count);
                echo "</p>";
            }
            displaydir($wdir);
            html_footer();
            break;

        case "paste":
            html_header($course, $wdir);
            if (isset($USER->fileop) and ($USER->fileop == "move") and confirm_sesskey()) {
                foreach ($USER->filelist as $file) {
// (FS_CONVERTER): ここから
//                  $shortfile = basename($file);       // basename()は動作が怪しい.
                    $shortfile = fs_basename($file);
// (FS_CONVERTER): ここまで
                    $oldfile = $basedir.'/'.$file;
                    $newfile = $basedir.$wdir."/".$shortfile;
// (FS_CONVERTER): ここから
//                  if (!rename($oldfile, $newfile)) {
                    if (!fs_rename($oldfile, $newfile)) {
// (FS_CONVERTER): ここまで
                        echo "<p>Error: $shortfile not moved</p>";
                    }
                }
            }
            clearfilelist();
            displaydir($wdir);
            html_footer();
            break;

        case "rename":
            if (($name != '') and confirm_sesskey()) {
                html_header($course, $wdir);
                $name = clean_filename($name);
// (FS_CONVERTER): ここから
//              if (file_exists($basedir.$wdir."/".$name)) {
                if (fs_file_exists($basedir.$wdir."/".$name)) {
// (FS_CONVERTER): ここまで
                    echo "<center>Error: $name already exists!</center>";
// (FS_CONVERTER): ここから
//              } else if (!rename($basedir.$wdir."/".$oldname, $basedir.$wdir."/".$name)) {
                } else if (!fs_rename($basedir.$wdir."/".$oldname, $basedir.$wdir."/".$name)) {
// (FS_CONVERTER): ここまで
                    echo "<p align=\"center\">Error: could not rename $oldname to $name</p>";
                } else {
                    //file was renamed now update resources if needed
                    require_once($CFG->dirroot.'/mod/resource/lib.php');
                    resource_renamefiles($course, $wdir, $oldname, $name);
                }
                displaydir($wdir);

            } else {
                $strrename = get_string("rename");
                $strcancel = get_string("cancel");
                $strrenamefileto = get_string("renamefileto", "moodle", $file);
                html_header($course, $wdir, "form.name");
                echo "<p>$strrenamefileto:</p>";
                echo "<table><tr><td>";
                echo "<form action=\"index.php\" method=\"post\">";
                echo "<fieldset class=\"invisiblefieldset\">";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"rename\" />";
                echo " <input type=\"hidden\" name=\"oldname\" value=\"$file\" />";
                echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
                echo " <input type=\"text\" name=\"name\" size=\"35\" value=\"$file\" />";
                echo " <input type=\"submit\" value=\"$strrename\" />";
                echo "</fieldset>";
                echo "</form>";
                echo "</td><td>";
                echo "<form action=\"index.php\" method=\"get\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"$strcancel\" />";
                echo "</div>";
                echo "</form>";
                echo "</td></tr></table>";
            }
            html_footer();
            break;

        case "makedir":
            if (($name != '') and confirm_sesskey()) {
                html_header($course, $wdir);
                $name = clean_filename($name);
// (FS_CONVERTER): ここから
//              if (file_exists("$basedir$wdir/$name")) {
                if (fs_file_exists("$basedir$wdir/$name")) {
// (FS_CONVERTER): ここまで
                    echo "Error: $name already exists!";
                } else if (! make_upload_directory("$course->id$wdir/$name")) {
                    echo "Error: could not create $name";
                }
                displaydir($wdir);

            } else {
                $strcreate = get_string("create");
                $strcancel = get_string("cancel");
                $strcreatefolder = get_string("createfolder", "moodle", $wdir);
                html_header($course, $wdir, "form.name");
                echo "<p>$strcreatefolder:</p>";
                echo "<table><tr><td>";
                echo "<form action=\"index.php\" method=\"post\">";
                echo "<fieldset class=\"invisiblefieldset\">";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"makedir\" />";
                echo " <input type=\"text\" name=\"name\" size=\"35\" />";
                echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
                echo " <input type=\"submit\" value=\"$strcreate\" />";
                echo "</fieldset>";
                echo "</form>";
                echo "</td><td>";
                echo "<form action=\"index.php\" method=\"get\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"$strcancel\" />";
                echo "</div>";
                echo "</form>";
                echo "</td></tr></table>";
            }
            html_footer();
            break;

        case "edit":
            html_header($course, $wdir);
            if (($text != '') and confirm_sesskey()) {
// (FS_CONVERTER): ここから
//              $fileptr = fopen($basedir.'/'.$file,"w");
                $fileptr = fs_fopen($basedir.'/'.$file,"w");
// (FS_CONVERTER): ここまで
                $text = preg_replace('/\x0D/', '', $text);  // http://moodle.org/mod/forum/discuss.php?d=38860
                fputs($fileptr, stripslashes($text));
                fclose($fileptr);
                displaydir($wdir);

            } else {
                $streditfile = get_string("edit", "", "<b>$file</b>");
// (FS_CONVERTER): ここから
//              $fileptr  = fopen($basedir.'/'.$file, "r");
                $fileptr  = fs_fopen($basedir.'/'.$file, "r");
//              $contents = fread($fileptr, filesize($basedir.'/'.$file));
                $contents = fread($fileptr, fs_filesize($basedir.'/'.$file));
// (Shirai048): UTF-8ではないテキストファイルをクライアントＰＣで作成し，アップロードした場合にMoodle上で編集できない
// (Shirai048): ここから追加
                if (($enc_str = mb_detect_encoding($contents)) != 'UTF-8') $streditfile .= '<BR><small>（文字コードを'.$enc_str.'からUTF-8に変換しました）<BR>”変更を保存する”とファイルの文字コードはUTF-8形式に変更されます．</small>';
                $contents = mb_convert_encoding($contents, 'UTF-8', 'auto');
// (Shirai048): ここまで追加
                fclose($fileptr);

                if (mimeinfo("type", $file) == "text/html") {
                    $usehtmleditor = can_use_html_editor();
                } else {
                    $usehtmleditor = false;
                }
                $usehtmleditor = false;    // Always keep it off for now

                print_heading("$streditfile");

                echo "<table><tr><td colspan=\"2\">";
                echo "<form action=\"index.php\" method=\"post\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"file\" value=\"$file\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"edit\" />";
                echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
                print_textarea($usehtmleditor, 25, 80, 680, 400, "text", $contents);
                echo "</td></tr><tr><td>";
                echo " <input type=\"submit\" value=\"".get_string("savechanges")."\" />";
                echo "</div>";
                echo "</form>";
                echo "</td><td>";
                echo "<form action=\"index.php\" method=\"get\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"".get_string("cancel")."\" />";
                echo "</div>";
                echo "</form>";
                echo "</td></tr></table>";

                if ($usehtmleditor) {
                    use_html_editor();
                }


            }
            html_footer();
            break;

// (FS_CONVERTER): ここから追加
        case "sjzip":
            $sjiszipflag = true;
// (FS_CONVERTER): ここまで追加
        case "zip":
// (FS_CONVERTER): ここから追加
            if (!isset($sjiszipflag)) $sjiszipflag = false; // ワーニングが出るので．
// (FS_CONVERTER): ここまで追加
            if (($name != '') and confirm_sesskey()) {
                html_header($course, $wdir);
                $name = clean_filename($name);

                $files = array();
                foreach ($USER->filelist as $file) {
                   $files[] = "$basedir/$file";
                }

// (FS_CONVERTER): ここから
//              if (!zip_files($files,"$basedir$wdir/$name")) {
                if (!zip_files($files,"$basedir$wdir/$name", $sjiszipflag)) {
// (FS_CONVERTER): ここまで
                    error(get_string("zipfileserror","error"));
                }

                clearfilelist();
                displaydir($wdir);

            } else {
                html_header($course, $wdir, "form.name");

                if (setfilelist($_POST)) {
                    echo "<p align=\"center\">".get_string("youareabouttocreatezip").":</p>";
                    print_simple_box_start("center");
                    printfilelist($USER->filelist);
                    print_simple_box_end();
                    echo "<br />";
                    echo "<p align=\"center\">".get_string("whattocallzip")."</p>";
                    echo "<table><tr><td>";
                    echo "<form action=\"index.php\" method=\"post\">";
                    echo "<fieldset class=\"invisiblefieldset\">";
                    echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                    echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                    echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
// (FS_CONVERTER): 以下１行をコメントアウト
//                  echo " <input type=\"hidden\" name=\"action\" value=\"zip\" />";
// (FS_CONVERTER): ここから追加
                    if ($sjiszipflag) {
                        echo " <input type=\"hidden\" name=\"action\" value=\"sjzip\" />"; // S-JISで強制的に圧縮
                    } else {
                        echo " <input type=\"hidden\" name=\"action\" value=\"zip\" />";   // 通常通りファイルシステムの文字コードで圧縮
                    }
// (FS_CONVERTER): ここまで追加
                    echo " <input type=\"text\" name=\"name\" size=\"35\" value=\"new.zip\" />";
                    echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
                    echo " <input type=\"submit\" value=\"".get_string("createziparchive")."\" />";
                    echo "<fieldset>";
                    echo "</form>";
                    echo "</td><td>";
                    echo "<form action=\"index.php\" method=\"get\">";
                    echo "<div>";
                    echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                    echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                    echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                    echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                    echo " <input type=\"submit\" value=\"".get_string("cancel")."\" />";
                    echo "</div>";
                    echo "</form>";
                    echo "</td></tr></table>";
                } else {
                    displaydir($wdir);
                    clearfilelist();
                }
            }
            html_footer();
            break;

        case "unzip":
            html_header($course, $wdir);
            if (($file != '') and confirm_sesskey()) {
                $strok = get_string("ok");
                $strunpacking = get_string("unpacking", "", $file);

                echo "<p align=\"center\">$strunpacking:</p>";

// (FS_CONVERTER): ここから
//              $file = basename($file);       // basename()は怪しい．
                $file = fs_basename($file);
// (FS_CONVERTER): ここまで

                if (!unzip_file("$basedir$wdir/$file")) {
                    error(get_string("unzipfileserror","error"));
                }

                echo "<div style=\"text-align:center\"><form action=\"index.php\" method=\"get\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"$strok\" />";
                echo "</div>";
                echo "</form>";
                echo "</div>";
            } else {
                displaydir($wdir);
            }
            html_footer();
            break;

        case "listzip":
            html_header($course, $wdir);
            if (($file != '') and confirm_sesskey()) {
                $strname = get_string("name");
                $strsize = get_string("size");
                $strmodified = get_string("modified");
                $strok = get_string("ok");
                $strlistfiles = get_string("listfiles", "", $file);

                echo "<p align=\"center\">$strlistfiles:</p>";
// (FS_CONVERTER): ここから
//              $file = basename($file);       // basename()は動作が怪しい．
                $file = fs_basename($file);
// (FS_CONVERTER): ここまで

                include_once("$CFG->libdir/pclzip/pclzip.lib.php");
// (FS_CONVERTER): ここから
//              $archive = new PclZip(cleardoubleslashes("$basedir$wdir/$file"));
                $archive = new PclZip(currentCharset2fsCharset(cleardoubleslashes("$basedir$wdir/$file")));
//              if (!$list = $archive->listContent(cleardoubleslashes("$basedir$wdir"))) {
                if (!$list = $archive->listContent(currentCharset2fsCharset(cleardoubleslashes("$basedir$wdir")))) {
// (FS_CONVERTER): ここまで
                    notify($archive->errorInfo(true));

                } else {
                    echo "<table cellpadding=\"4\" cellspacing=\"2\" border=\"0\" width=\"640\" class=\"files\">";
                    echo "<tr class=\"file\"><th align=\"left\" class=\"header name\" scope=\"col\">$strname</th><th align=\"right\" class=\"header size\" scope=\"col\">$strsize</th><th align=\"right\" class=\"header date\" scope=\"col\">$strmodified</th></tr>";
                    foreach ($list as $item) {
// (FS_CONVERTER): 以下１行を追加
                       $item['filename'] = zipitem2currentCharset($item['filename']);
// (FS_CONVERTER): ここまで追加
                        echo "<tr>";
                        print_cell("left", s($item['filename']), 'name');
                        if (! $item['folder']) {
                            print_cell("right", display_size($item['size']), 'size');
                        } else {
                            echo "<td>&nbsp;</td>";
                        }
                        $filedate  = userdate($item['mtime'], get_string("strftimedatetime"));
                        print_cell("right", $filedate, 'date');
                        echo "</tr>";
                    }
                    echo "</table>";
                }
                echo "<br /><center><form action=\"index.php\" method=\"get\">";
                echo "<div>";
                echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
                echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
                echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
                echo " <input type=\"hidden\" name=\"action\" value=\"cancel\" />";
                echo " <input type=\"submit\" value=\"$strok\" />";
                echo "</div>";
                echo "</form>";
                echo "</center>";
            } else {
                displaydir($wdir);
            }
            html_footer();
            break;

        case "restore":
            html_header($course, $wdir);
            if (($file != '') and confirm_sesskey()) {
                echo "<p align=\"center\">".get_string("youaregoingtorestorefrom").":</p>";
                print_simple_box_start("center");
                echo $file;
                print_simple_box_end();
                echo "<br />";
                echo "<p align=\"center\">".get_string("areyousuretorestorethisinfo")."</p>";
                $restore_path = "$CFG->wwwroot/backup/restore.php";
                notice_yesno (get_string("areyousuretorestorethis"),
                                $restore_path."?id=".$id."&amp;file=".cleardoubleslashes($id.$wdir."/".$file)."&amp;method=manual",
                                "index.php?id=$id&amp;wdir=$wdir&amp;action=cancel");
            } else {
                displaydir($wdir);
            }
            html_footer();
            break;

        case "cancel":
            clearfilelist();

        default:
            html_header($course, $wdir);
            displaydir($wdir);
// (Shirai196): リソースの追加などでポップアップするファイル選択ウィンドに「ウィンドウを閉じるボタン」を追加する改良 (2010/09/18)
// (Shirai196): ここから追加
            if (!empty($choose)) output_CloseWindowButton();
// (Shirai196): ここまで追加
            html_footer();
            break;
}


/// FILE FUNCTIONS ///////////////////////////////////////////////////////////


function setfilelist($VARS) {
    global $USER;

    $USER->filelist = array ();
    $USER->fileop = "";

    $count = 0;
    foreach ($VARS as $key => $val) {
        if (substr($key,0,4) == "file") {
            $count++;
            $val = rawurldecode($val);
            $USER->filelist[] = clean_param($val, PARAM_PATH);
        }
    }
    return $count;
}

function clearfilelist() {
    global $USER;

    $USER->filelist = array ();
    $USER->fileop = "";
}


function printfilelist($filelist) {
    global $CFG, $basedir;

    $strfolder = get_string("folder");
    $strfile   = get_string("file");

    foreach ($filelist as $file) {
// (FS_CONVERTER): ここから
//      if (is_dir($basedir.'/'.$file)) {
        if (fs_is_dir($basedir.'/'.$file)) {
// (FS_CONVERTER): ここまで
            echo '<img src="'. $CFG->pixpath .'/f/folder.gif" class="icon" alt="'. $strfolder .'" /> '. htmlspecialchars($file) .'<br />';
            $subfilelist = array();
// (FS_CONVERTER): ここから
//          $currdir = opendir($basedir.'/'.$file);
            $currdir = fs_opendir($basedir.'/'.$file);
//          while (false !== ($subfile = readdir($currdir))) {
            while (false !== ($subfile = fs_readdir($currdir))) {
// (FS_CONVERTER): ここまで
                if ($subfile <> ".." && $subfile <> ".") {
                    $subfilelist[] = $file."/".$subfile;
                }
            }
            printfilelist($subfilelist);

        } else {
            $icon = mimeinfo("icon", $file);
            echo '<img src="'. $CFG->pixpath .'/f/'. $icon .'" class="icon" alt="'. $strfile .'" /> '. htmlspecialchars($file) .'<br />';
        }
    }
}


function print_cell($alignment='center', $text='&nbsp;', $class='') {
    if ($class) {
        $class = ' class="'.$class.'"';
    }
    echo '<td align="'.$alignment.'" style="white-space:nowrap "'.$class.'>'.$text.'</td>';
}

function displaydir ($wdir) {
//  $wdir == / or /a or /a/b/c/d  etc

    global $basedir;
    global $id;
    global $USER, $CFG;
    global $choose;
// (Shirai014): 更新日時／ファイルサイズで並べ替え (2008/1/14)
// (Shirai014): 以下１行を追加
    global $sortorderfilelist;
// (Shirai014): ここまで
// (Shirai171): 特定の拡張子や指定したサイズ以上のファイルをバックアップしない機能の追加 (2009/10/08)
// (Shirai171): ここから追加
    if (fs_function_enable('FS_ENABLE_BACKUP_EXCEPTION')) {
        fs_set_backup_exception();
        fs_exception_condition_settingup($id);
    }
// (Shirai171): ここまで追加

    $fullpath = $basedir.$wdir;
    $dirlist = array();

// (FS_CONVERTER): ここから
//  $directory = opendir($fullpath);             // Find all files
    $directory = fs_opendir($fullpath);          // Find all files
//  while (false !== ($file = readdir($directory))) {
    while (false !== ($file = fs_readdir_for_displaydir($directory))) {
// (FS_CONVERTER): ここまで
        if ($file == "." || $file == "..") {
            continue;
        }

// (FS_CONVERTER): ここから
//      if (is_dir($fullpath."/".$file)) {
        if (fs_is_dir($fullpath."/".$file) || is_dir(currentCharset2oldfsCharset($fullpath)."/".currentCharset2fsCharset($file))) {
// (FS_CONVERTER): ここまで
// (Shirai014): 更新日時／ファイルサイズで並べ替え (2008/1/14)
// (Shirai014): ここからコメントアウト
//          $dirlist[] = $file;
//      } else {
//          $filelist[] = $file;
// (Shirai014): ここから追加
            switch ($sortorderfilelist) {
              case 3: case 4:
                $sortkeystr = strftime('%Y%m%d%H%M%S', fs_filemtime("$fullpath/$file"));
                break;
              case 5: case 6:
                $sortkeystr = strval(get_directory_size("$fullpath/$file"));
                break;
              case 1: case 2: default:
                $sortkeystr = $file;
                break;
			}
            $dirlist['0'.$file] = $sortkeystr;  
            // $dirlist["0"]が$dirlist[0]になってしまうため'0'を付けて$dirlist["00"]とする．
        } else { 
            switch ($sortorderfilelist) {
              case 3: case 4:
                $sortkeystr = strftime('%Y%m%d%H%M%S', fs_filemtime("$fullpath/$file"));
                break;
              case 5: case 6:
                $sortkeystr = strval(fs_filesize("$fullpath/$file"));
                break;
              default:
                $sortkeystr = $file; break;
			}
            $filelist['0'.$file] = $sortkeystr;
            // $filelist["0"]が$filelist[0]になってしまうため'0'を付けて$filelist["00"]とする．
// (Shirai014): ここまで追加
        }
    }
    closedir($directory);

    $strname = get_string("name");
    $strsize = get_string("size");
    $strmodified = get_string("modified");
    $straction = get_string("action");
    $strmakeafolder = get_string("makeafolder");
    $struploadafile = get_string("uploadafile");
    $strselectall = get_string("selectall");
    $strselectnone = get_string("deselectall");
    $strwithchosenfiles = get_string("withchosenfiles");
    $strmovetoanotherfolder = get_string("movetoanotherfolder");
    $strmovefilestohere = get_string("movefilestohere");
    $strdeletecompletely = get_string("deletecompletely");
    $strcreateziparchive = get_string("createziparchive");
    $strrename = get_string("rename");
    $stredit   = get_string("edit");
    $strunzip  = get_string("unzip");
    $strlist   = get_string("list");
    $strrestore= get_string("restore");
    $strchoose = get_string("choose");
    $strfolder = get_string("folder");
    $strfile   = get_string("file");
// (Shirai014): 更新日時／ファイルサイズで並べ替え (2008/1/14)
// (Shirai014): ここから追加
    $reloadurl = "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;choose=$choose&amp;";
    $strname .= "&nbsp(";
    $strname .= $sortorderfilelist == 1 ? "&#x25B2;/" : $reloadurl."sortorderfilelist=1\">&#x25B2;</a>/";
    $strname .= $sortorderfilelist == 2 ? "&#x25BC;)" : $reloadurl."sortorderfilelist=2\">&#x25BC;</a>)";
    $strmodified .= "&nbsp(";
    $strmodified .= $sortorderfilelist == 3 ? "&#x25B2;/" : $reloadurl."sortorderfilelist=3\">&#x25B2;</a>/";
    $strmodified .= $sortorderfilelist == 4 ? "&#x25BC;)" : $reloadurl."sortorderfilelist=4\">&#x25BC;</a>)";
    $strsize .= "&nbsp(";
    $strsize .= $sortorderfilelist == 5 ? "&#x25B2;/" : $reloadurl."sortorderfilelist=5\">&#x25B2;</a>/";
    $strsize .= $sortorderfilelist == 6 ? "&#x25BC;)" : $reloadurl."sortorderfilelist=6\">&#x25BC;</a>)";
// (Shirai014): ここまで追加


    echo "<form action=\"index.php\" method=\"post\" id=\"dirform\">";
    echo "<div>";
    echo '<input type="hidden" name="choose" value="'.$choose.'" />';
    // echo "<hr align=\"center\" noshade=\"noshade\" size=\"1\" />";
    echo "<hr/>";
    echo "<table border=\"0\" cellspacing=\"2\" cellpadding=\"2\" width=\"640\" class=\"files\">";
    echo "<tr>";
    echo "<th class=\"header\" scope=\"col\"></th>";
    echo "<th class=\"header name\" scope=\"col\">$strname</th>";
    echo "<th class=\"header size\" scope=\"col\">$strsize</th>";
    echo "<th class=\"header date\" scope=\"col\">$strmodified</th>";
    echo "<th class=\"header commands\" scope=\"col\">$straction</th>";
    echo "</tr>\n";

    if ($wdir != "/") {
        $dirlist[] = '..';
    }

    $count = 0;

    if (!empty($dirlist)) {
// (Shirai014): 更新日時／ファイルサイズで並べ替え (2008/1/14)
// (Shirai014): ここからコメントアウト
//      asort($dirlist);
//      foreach ($dirlist as $dir) {
// (Shirai014): ここから追加
        switch ($sortorderfilelist) {
          case 2:  case 4: case 6:  arsort($dirlist); break;
          case 3:  case 5: default: asort($dirlist);  break;
        }
        foreach ($dirlist as $key => $value) {
            if ($value == '..') {
                unset($dirlist[$key]);
                $dirlist = array('0..'=>'..') + $dirlist;
            }
        }
        foreach ($dirlist as $dir => $dummy) {
            $dir = substr($dir, 1);  // 頭のダミーの'0'を取り除く
// (Shirai014): ここまで追加
            echo "<tr class=\"folder\">";

            if ($dir == '..') {
                $fileurl = rawurlencode(dirname($wdir));
                print_cell();
                // alt attribute intentionally empty to prevent repetition in screen reader
                print_cell('left', '<a href="index.php?id='.$id.'&amp;wdir='.$fileurl.'&amp;choose='.$choose.'"><img src="'.$CFG->pixpath.'/f/parent.gif" class="icon" alt="" />&nbsp;'.get_string('parentfolder').'</a>', 'name');
                print_cell();
                print_cell();
                print_cell();

            } else {
                $count++;
                $filename = $fullpath."/".$dir;
                $fileurl  = rawurlencode($wdir."/".$dir);
                $filesafe = rawurlencode($dir);
                $filesize = display_size(get_directory_size("$fullpath/$dir"));
// (FS_CONVERTER): ここから
//              $filedate = userdate(filemtime($filename), "%d %b %Y, %I:%M %p");
                $filedate = userdate(fs_filemtime($filename), "");     // (T.Shirai)タイムスタンプを読みやすく(2008/1/14)
// (FS_CONVERTER): ここまで
                print_cell("center", "<input type=\"checkbox\" name=\"file$count\" value=\"$fileurl\" />", 'checkbox');
// (FS_CONVERTER): 新旧ファイルシステム文字コードの混在に対応（強調表示）
// (FS_CONVERTER): ここから追加
                $emstart = $emend = "";
                if (!fs_is_dir($filename)) { $emstart = '<font color="#ff8000"><STRONG>'; $emend = '</strong></font>';}
// (FS_CONVERTER): ここまで追加
// (Shirai171): ここから追加
                if (fs_function_enable('FS_ENABLE_BACKUP_EXCEPTION')) {
                    if (($excepno = fs_is_this_exceptional($filename))) $emend .= '&nbsp;<a title="'.get_string('matchingexceptioncondition', 'fs_moodle', $excepno).'">(!)</a>';
                }
// (Shirai171): ここまで追加
// (FS_CONVERTER): ここから
//              print_cell("left", "<a href=\"index.php?id=$id&amp;wdir=$fileurl&amp;choose=$choose\"><img src=\"$CFG->pixpath/f/folder.gif\" class=\"icon\" alt=\"$strfolder\" />&nbsp;".htmlspecialchars($dir)."</a>", 'name');
                print_cell("left", "<a href=\"index.php?id=$id&amp;wdir=$fileurl&amp;choose=$choose\"><img src=\"$CFG->pixpath/f/folder.gif\" class=\"icon\" alt=\"$strfolder\" />&nbsp;".$emstart.htmlspecialchars($dir).$emend."</a>", 'name');
// (FS_CONVERTER): ここまで
                print_cell("right", $filesize, 'size');
                print_cell("right", $filedate, 'date');
// (Shirai006): リソースの追加，フォルダの表示でフォルダをファイルブラウザから選択可能とする改良(2008/01/11)
// (shirai006): ここから追加
                if ($choose == 'id_reference2_value') {
                    $selectdir = trim($fileurl, "/");
                    $selectdir = mb_ereg_replace('^((//)|(\%2F\%2F))', '', $selectdir); // 頭の'//'(%2F%2F)を取り除く．Bug fix(2008/02/15)
                    $edittext = "<strong><a onclick=\"return set_value('".rawurldecode($selectdir)."')\" href=\"#\">$strchoose</a></strong>&nbsp;";
                } else $edittext = '';
// (Shirai006): ここまで追加
// (IE_Problem001)  IEで日本語フォルダの下のフォルダの名前をリネームできない問題
//              print_cell("right", "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$filesafe&amp;action=rename&amp;choose=$choose\">$strrename</a>", 'commands');  // (IE_PROBLEM)
                print_cell("right", "$edittext <a href=\"index.php?id=$id&amp;wdir=".fs_rawurlencode($wdir)."&amp;file=$filesafe&amp;action=rename&amp;choose=$choose\">$strrename</a>", 'commands');  // (IE_Problem001)
// $edittextは上の”リソースの追加”の関係で追加(T.Shirai)
            }

            echo "</tr>";
        }
    }


    if (!empty($filelist)) {
// (Shirai014): 更新日時／ファイルサイズで並べ替え (2008/1/14)
// (shirai014)：ここからコメントアウト
//      asort($filelist);
//      foreach ($filelist as $file) {
// (Shirai014): ここから追加
        switch ($sortorderfilelist) {
          case 2: case 4: case 6:  arsort($filelist); break;
          case 3: case 5: default: asort($filelist);  break;
        }
        foreach ($filelist as $file => $dummy) {
            $file = substr($file, 1);  // 頭のダミーの'0'を取り除く
// (Shirai014): ここまで追加

            $icon = mimeinfo("icon", $file);

            $count++;
            $filename    = $fullpath."/".$file;
// (IE_Problem002)：IEでダウンロードできない問題の対策：いつの間にかこの対策は不要になっていた．
            $fileurl     = trim($wdir, "/")."/$file";
//          $fileurl     = fs_rawurlencode(trim($wdir, "/")."/$file");  // URLエンコードすると保存時のファイル名がURLエンコードされた状態になってしまう(PDF)．(2008/04/21)
// (IE_Problem002): ここまで
            $filesafe    = rawurlencode($file);
            $fileurlsafe = rawurlencode($fileurl);
// (FS_CONVERTER): ここから
//          $filedate    = userdate(filemtime($filename), "%d %b %Y, %I:%M %p");
            $filedate    = userdate(fs_filemtime($filename), "");     // (T.Shirai) タイムスタンプを読みやすく (2008/1/14)
// (FS_CONVERTER): ここまで

            $selectfile = trim($fileurl, "/");

            echo "<tr class=\"file\">";

            print_cell("center", "<input type=\"checkbox\" name=\"file$count\" value=\"$fileurl\" />", 'checkbox');
            echo "<td align=\"left\" style=\"white-space:nowrap\" class=\"name\">";
            if ($CFG->slasharguments) {
                $ffurl = str_replace('//', '/', "/file.php/$id/$fileurl");
            } else {
                $ffurl = str_replace('//', '/', "/file.php?file=/$id/$fileurl");
            }
// (FS_CONVERTER): 新旧ファイルシステム文字コードの混在に対応（強調表示）
// (FS_CONVERTER): ここから追加
            $emstart = $emend = "";
            if (!fs_is_file($filename)) { $emstart = '<font color="#ff8000"><strong>'; $emend = '</strong></font>';}
// (FS_CONVERTER): ここまで追加
// (Shirai171): ここから追加
            if (fs_function_enable('FS_ENABLE_BACKUP_EXCEPTION')) {
                if (($excepno = fs_is_this_exceptional($filename))) {
                    $emend .= '&nbsp;<a title="'.get_string('matchingexceptioncondition', 'fs_moodle', $excepno).'">(!)</a>';
                }
            }
// (Shirai171): ここまで追加
            link_to_popup_window ($ffurl, "display",
// (FS_CONVERTER): ここから
//                                "<img src=\"$CFG->pixpath/f/$icon\" class=\"icon\" alt=\"$strfile\" />&nbsp;".htmlspecialchars($file),
                                  "<img src=\"$CFG->pixpath/f/$icon\" class=\"icon\" alt=\"$strfile\" />&nbsp;".$emstart.htmlspecialchars($file).$emend,
// (FS_CONVERTER): ここまで
                                  480, 640);
            echo "</td>";

// (FS_CONVERTER): ここから
//          $file_size = filesize($filename);
            $file_size = fs_filesize($filename);
// (FS_CONVERTER): ここまで
            print_cell("right", display_size($file_size), 'size');
            print_cell("right", $filedate, 'date');

// (Shirai006): リソースの追加，フォルダの表示でフォルダをファイルブラウザから選択可能とする改良(2008/01/11)
//          if ($choose) {
            if (($choose) && ($choose != 'id_reference2_value')) {
// (Shirai006): ここまで
// (IE_Problem003) IEで日本語ファイル名のファイルをリソースとして選択するとエラーが発生する問題 (2007/8/27)
//              $edittext = "<strong><a onclick=\"return set_value('$selectfile')\" href=\"#\">$strchoose</a></strong>&nbsp;";
                $edittext = "<strong><a onclick=\"return set_value('".rawurldecode($selectfile)."')\" href=\"#\">$strchoose</a></strong>&nbsp;";
// (IE_Problem003): ここまで
            } else {
                $edittext = '';
            }

// (IE_Problem004) ＩＥでは日本語フォルダの下にあるファイルの編集，UNZIP，ZIP書庫のリスト，リネームができない問題
// (IE_Problem004)：ここから追加
            $orgwdir = $wdir;
            $wdir = rawurlencode($wdir);
            $fileurl = rawurlencode($fileurl);
// (IE_Problem004)：ここまで追加
            if ($icon == "text.gif" || $icon == "html.gif") {
                $edittext .= "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$fileurl&amp;action=edit&amp;choose=$choose\">$stredit</a>";
            } else if ($icon == "zip.gif") {
                $edittext .= "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$fileurl&amp;action=unzip&amp;sesskey=$USER->sesskey&amp;choose=$choose\">$strunzip</a>&nbsp;";
                $edittext .= "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$fileurl&amp;action=listzip&amp;sesskey=$USER->sesskey&amp;choose=$choose\">$strlist</a> ";
                if (!empty($CFG->backup_version) and has_capability('moodle/site:restore', get_context_instance(CONTEXT_COURSE, $id))) {
                    $edittext .= "<a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$filesafe&amp;action=restore&amp;sesskey=$USER->sesskey&amp;choose=$choose\">$strrestore</a> ";
                }
            }

            print_cell("right", "$edittext <a href=\"index.php?id=$id&amp;wdir=$wdir&amp;file=$filesafe&amp;action=rename&amp;choose=$choose\">$strrename</a>", 'commands');
// (IE_Problem004)：ここから追加
            $wdir = $orgwdir;
// (IE_Problem004)：ここまで追加

            echo "</tr>";
        }
    }
    echo "</table>";
    echo "<hr />";
    //echo "<hr width=\"640\" align=\"center\" noshade=\"noshade\" size=\"1\" />";

    echo "<table border=\"0\" cellspacing=\"2\" cellpadding=\"2\" width=\"640\">";
    echo "<tr><td>";
    echo "<input type=\"hidden\" name=\"id\" value=\"$id\" />";
    echo '<input type="hidden" name="choose" value="'.$choose.'" />';
    echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\" /> ";
    echo "<input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
    $options = array (
                   "move" => "$strmovetoanotherfolder",
                   "delete" => "$strdeletecompletely",
                   "zip" => "$strcreateziparchive"
               );
// (FS_CONVERTER): ここから追加
    if (!is_fs_sjis()) $options["sjzip"] = "SJISでzip書庫作成";
    $options["convfs"] =  "文字コード変換(fs)";
// (FS_CONVERTER): ここまで追加
    if (!empty($count)) {
        choose_from_menu ($options, "action", "", "$strwithchosenfiles...", "javascript:getElementById('dirform').submit()");
    }
    echo "</td></tr></table>";
    echo "</div>";
    echo "</form>";
    echo "<table border=\"0\" cellspacing=\"2\" cellpadding=\"2\" width=\"640\"><tr>";
    echo "<td align=\"center\">";
    if (!empty($USER->fileop) and ($USER->fileop == "move") and ($USER->filesource <> $wdir)) {
        echo "<form action=\"index.php\" method=\"get\">";
        echo "<div>";
        echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
        echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
        echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
        echo " <input type=\"hidden\" name=\"action\" value=\"paste\" />";
        echo " <input type=\"hidden\" name=\"sesskey\" value=\"$USER->sesskey\" />";
        echo " <input type=\"submit\" value=\"$strmovefilestohere\" />";
        echo "</div>";
        echo "</form>";
    }
    echo "</td>";
    echo "<td align=\"right\">";
        echo "<form action=\"index.php\" method=\"get\">";
        echo "<div>";
        echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
        echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
        echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
        echo " <input type=\"hidden\" name=\"action\" value=\"makedir\" />";
        echo " <input type=\"submit\" value=\"$strmakeafolder\" />";
        echo "</div>";
        echo "</form>";
    echo "</td>";
    echo "<td align=\"right\">";
        echo "<form action=\"index.php\" method=\"get\">"; //dummy form - alignment only
        echo "<fieldset class=\"invisiblefieldset\">";
        echo " <input type=\"button\" value=\"$strselectall\" onclick=\"checkall();\" />";
        echo " <input type=\"button\" value=\"$strselectnone\" onclick=\"uncheckall();\" />";
        echo "</fieldset>";
        echo "</form>";
    echo "</td>";
    echo "<td align=\"right\">";
        echo "<form action=\"index.php\" method=\"get\">";
        echo "<div>";
        echo ' <input type="hidden" name="choose" value="'.$choose.'" />';
        echo " <input type=\"hidden\" name=\"id\" value=\"$id\" />";
        echo " <input type=\"hidden\" name=\"wdir\" value=\"$wdir\" />";
        echo " <input type=\"hidden\" name=\"action\" value=\"upload\" />";
        echo " <input type=\"submit\" value=\"$struploadafile\" />";
        echo "</div>";
        echo "</form>";
    echo "</td></tr>";
    echo "</table>";
    echo "<hr/>";
    //echo "<hr width=\"640\" align=\"center\" noshade=\"noshade\" size=\"1\" />";

}

?>
