<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_backupRestoreSettings()
{
    global $fsCFG;
    global $CFG;

    print_section_header('バックアップ／リストアに関する設定');

//  print_notice_message('メモ', '　現バージョンではリストアに関する設定はありません．');

    print_subsection_header_fs_switch('FS_ENABLE_DETAILLOG_BACKUPRESTORE');
    echo '　コースの手動によるバックアップとリストアとインポートが正常に完了しない場合のデバッグを助けるための詳細なログを出力します．';
    echo 'この機能を有効にすると，バックアップ等を行っているかどうかに関わらず，バックアップ／リストア／インポート用に用意されている関数が呼ばれるだけでログを吐き出します．';
    echo 'したがって'.color_red('この機能を有効にしたまま無効に戻さないでいるとログファイルが際限なく巨大化していきます').'ので，不要になったら機能を無効に戻すのを忘れないようにして下さい．';
    echo 'ログファイルは'.color_blue($CFG->datadir.'/temp/backup/backupRestoreDetail.log').'に保存されます．';
    newline();
    print_fs_switch_condition('FS_ENABLE_DETAILLOG_BACKUPRESTORE');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_DONOT_DELETE_BMZ');
    echo '　コースのバックアップ終了後に本来であれば完成したbmzファイルをバックアップ元のコースのバックアップファイル領域へ移動（コピー＆削除）します．';
    echo '本機能を有効にすると，バックアップファイルをmoodledata/backup/tempフォルダからコースバックアップファイル領域へコピーしますが，tempフォルダから削除しません．';
    echo '巨大なコースをあるサイトから別のサイトにコピーする際に，バックアップファイルをサーバ間で移動するにはMoodleのファイルストレージ領域にバックアップファイルを長時間かけてコピーし，それをダウンロードするのは時間の無駄です．';
    echo '当初，ファイルストレージ（バックアップ領域）へのコピーも省略できるように考えましたが，副作用が怖いので削除のみを省略します．';
    newline();
    print_fs_switch_condition('FS_ENABLE_DONOT_DELETE_BMZ');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_COPY2RENAME_BACKUP');
    print_notice_message('注意', '以下の記述はMoodle1.9までに関するものです．Moodle2.0からは変更になっている可能性があります．');
    echo '　Moodleはコースのバックアップを行う際にバックアップ対象のファイルを';
    echo '全てmoodledata/temp/backupの下に作成したユニークな名前のフォルダの下にコピーします．';
    echo '次にこれらのファイルを一つのzip書庫に圧縮・格納します．';
    echo '作成したzip書庫をコースのbackupフォルダにコピーした後に，作業用のフォルダを消去します．';
    echo 'もし作成したzip書庫が非常に大きなサイズの場合，二つの問題が生じます．';
    echo '外部コマンドを用いてzip書庫を作成しない設定の場合にタイムアウトが発生する恐れがあるのとは別に，';
    echo '<ul>';
    echo '<li>(1)　サーバにファイル複写の負荷が掛かる</li>';
    echo '<li>(2)　PHP5(32bit版)の制限として2GBを超えるファイルのコピーが正常に行えない（ファイルの尻切れ）</li>';
    echo '</ul>';
    echo 'という問題が生じます．';
    echo '(1)はサーバの性能次第ですが，(2)は致命的です．';
    newline();
    echo '　先のバックアップの処理でも述べたように，zip書庫は一つかつコピーした後はフォルダごと消去してしまう';
    echo 'という処理の流れから考えるに，複写ではなく移動で構わないはずです．';
    echo 'fs_moodleではこの処理をcopy()からrename()に置き換える改造を行っています．';
    echo 'copy()は2GBを超えるファイルに対して正常に動作しませんが，';
    echo 'rename()は問題なく，しかも移動先が同じドライブ内であれば一瞬で処理が完了することを確認しています．';
    newline();
    echo '　もしバックアップが正常に完了しないコースが現れた場合は本機能をOnにすると共に';
    echo '[サイト管理]-[サーバ]-[システムパス]の'.color_blue('zipのパス').'を設定して外部プログラムによるzip作成に変更して下さい．';
    echo '（現在のzipパスの設定は';
    if (isset($CFG->zip)) echo color_blue($CFG->zip); else color_blue('未設定');
    echo 'です）';
    newline();
    print_fs_switch_condition('FS_ENABLE_COPY2RENAME_BACKUP');
    print_notice_message('注意', 'システムの保守に関わる非常に重要な機能ですので，本家で当方の提案が採用されるまではデフォルトで無効とします．');

    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_BACKUP_EXCEPTION');
    echo '　現状のPHPには2GBを超えるファイルを操作できない使用上の制限があり，';
    echo 'その結果，大量（あるいは大きなサイズ）のコースファイルを持つコースのバックアップが正常に終了しない問題が頻繁に報告されています．';
    echo '大容量のバックアップファイルを作成することはHDDのみならず，サーバのCPU性能も浪費します．';
    print_fs_switch_condition('FS_ENABLE_BACKUP_EXCEPTION');
    echo '　本機能を有効にし，さらに'.color_blue('fsconfig_option.php').'に'.color_blue('バックアップ制限条件').'を記述することで，';
    echo '指定したファイルやフォルダのバックアップをパスすることが可能になります．';
    newline();
    newline();

    print_subsubsection_header('バックアップ制限条件の記述', link2shirai(171));
    echo '　fs_add_backup_exception_filename()などの関数を用いてバックアップ制限条件を記述できます．';
    echo 'これらの条件は複数個設定可能です．';
    echo '詳細は'.link2shirai(171).'をご覧下さい．';
    echo 'いま現在の設定値を以下に示します．';
    notice_fsconfig2fsconfig_option();
    printout_backup_exception_conditions();
    print_subsubsection_footer();

    print_subsubsection_header('バックアップ制限条件の確認（ファイル名）');
    echo '<form method="post" action="backupexceptioncheck.php" target="_blank">';
    echo 'ファイル名の入力：<input type="text" name="filename" size="60" />';
    echo '<input type="submit" value="チェック" />';
    echo '</form>';
    print_subsubsection_footer();
    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_backupRestoreSettings();

?>