<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

require_once('../../../config.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');

page_header();

$page = optional_param('page', 'menu', PARAM_RAW);

$pagelist = array();
$pagelist['fsc_server']         = 'サーバの設定';
$pagelist['fsc_basicconfig']    = '基本的なfsconfig.phpの設定';
$pagelist['fsc_user_login']     = 'ユーザアカウントとログインの設定';
$pagelist['fsc_course']         = 'コースに関する設定';
$pagelist['fsc_assignment']     = '課題（Assignment）の設定';
$pagelist['fsc_grade']          = '評定（Grade）の設定';
$pagelist['fsc_forum']          = 'フォーラム（Forum）の設定';
$pagelist['fsc_chat']           = 'チャット（Chat）の設定';
$pagelist['fsc_quiz']           = '小テスト（Quiz）の設定';
$pagelist['fsc_message']        = 'メッセージ（Ｅメール含む）の設定';
$pagelist['fsc_wiki']           = 'Wikiの設定';
$pagelist['fsc_editor']         = 'HTMLエディタの設定';
$pagelist['fsc_blog']           = 'ブログの設定';
$pagelist['fsc_calendar']       = 'カレンダーの設定';
$pagelist['fsc_backup']         = 'バックアップ／リストアの設定';
$pagelist['fsc_globalsearch']   = 'グローバルサーチの設定';
$pagelist['fsc_mnet']           = 'Moodleネットワークの設定';
$pagelist['fsc_language']       = '言語関係の設定';
$pagelist['fsc_nanogong']       = 'NanoGongの設定';
$pagelist['fsc_original']       = 'fs_moodleオリジナルの機能の設定';

if ($page == 'menu') {
    require_once('menu.php');
} else if ($page == 'all') {
    // 前処理
    analyze_parameters();
    // 編集ボタン表示
    print_paramedit_buttons();

    $output = '';
    $titleonly = true;
    while (@ob_end_flush());
    foreach ($pagelist as $page=>$pageitem) {
        $filepath = $CFG->libdir.'/fs_moodle/fs_status/'.$page.'.php';
        if (file_exists($filepath)) {
            // コンテンツ読み込み
            $pagename = $pageitem;
            ob_start();
            require_once($filepath);
            while (@ob_end_clean());
            echo $output;
            $output = '';
        } else {
            error('重要なファイルが存在しないため全設定表示は実行できません．');
            die;
        }
    }
    // 編集ボタン表示
    print_paramedit_buttons();
    // 戻るボタン
    print_link2page();
} else if ($page == 'list') {
    echo "<H3>設定一覧</H3>\n";
    echo '<ul>';
    $lists = $fs_cfg_strings;
    ksort($lists);
    foreach ($lists as $key=>$dummy) {
        echo '<li><a href="index.php?page=all#'.$key.'">'.$key."</a></li>\n";
    }
    echo '</ul>';
    echo "<hr />\n";
    echo "<H3>スイッチ一覧</H3>\n";
    echo '<ul>';
    $lists = $fs_switch_strings;
    ksort($lists);
    foreach ($lists as $key=>$dummy) {
        echo '<li><a href="index.php?page=all#'.$key.'">'.$key."</a></li>\n";
    }
    echo '</ul>';
    // 戻るボタン
    print_link2page();
} else {
    $filepath = $CFG->libdir.'/fs_moodle/fs_status/'.$page.'.php';
    if (file_exists($filepath)) {
        // 前処理
        analyze_parameters();
        // 編集ボタン表示
        print_paramedit_buttons();

        // コンテンツ読み込み
        $pagename = $pagelist[$page];
        require_once($filepath);

        // 編集ボタン表示
        print_paramedit_buttons();
        // 戻るボタン
        print_link2page();
    } else {
        error('指定されたページは存在しません．');
        die;
    }
}

?>
    <br />
    <hr />
    <br />
    <h4>fs_moodleサポートサイトのドキュメント検索</h4>
    <div class="admintre">
    <form method="post" action="<?php echo $CFG->wwwroot.'/lib/fs_moodle/fs_status/help.php'; ?>" target="_blank">
    三桁以下の数字を以下のテキストボックスに入力して[参照]ボタンをクリックして下さい．<br />
    <ul>
    <li>Shirai     <input type="text" name="shirai"     size="5" maxlength="3"/></li>
    <li>IE_Problem <input type="text" name="ie_problem" size="5" maxlength="3"/></li>
    <li>Debug      <input type="text" name="debug"      size="5" maxlength="3"/></li>
    <li>3rdParty   <input type="text" name="thirdparty" size="5" maxlength="3"/></li>
    </ul>
    <input type="submit" value="参照" />
    <input type="reset"  value="リセット" />
    </form>
    </div>
<?php

page_footer();

?>