/*
 * Decompiled with CFR 0.152.
 */
package Display;

import Display.InputComponent;
import Tree.BinaryOperator;
import Tree.Function;
import Tree.Grouping;
import Tree.MathObject;
import Tree.Matrix;
import Tree.NaryFunction;
import Tree.NaryOperator;
import Tree.RealNumber;
import Tree.Text;
import Tree.Variable;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeDisplay
extends JFrame {
    private DefaultMutableTreeNode root;
    private InputComponent[] inputComponents;
    private JPanel jPanel1;

    public TreeDisplay(MathObject start, InputComponent[] inputComponents) {
        this.initComponents();
        this.inputComponents = inputComponents;
        this.root = new DefaultMutableTreeNode("Expression");
        if (start != null) {
            this.traverse(start, this.root);
        }
        JScrollPane jScrollPane1 = new JScrollPane();
        JTree jTree1 = new JTree(this.root);
        jScrollPane1.setViewportView(jTree1);
        this.jPanel1.add((Component)jScrollPane1, "Center");
        for (int i = 0; i < jTree1.getRowCount(); ++i) {
            jTree1.expandRow(i);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("DragMath");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.setMaximumSize(new Dimension(1000, 1000));
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    public void traverse(MathObject start, DefaultMutableTreeNode currentNode) throws NullPointerException {
        int i;
        DefaultMutableTreeNode nary;
        if (start.getClass().getName().equals("Tree.Text")) {
            Text textObj = (Text)start;
            DefaultMutableTreeNode text = new DefaultMutableTreeNode(textObj.getText());
            currentNode.add(text);
        }
        if (start.getClass().getName().equals("Tree.Variable")) {
            Variable variableObj = (Variable)start;
            DefaultMutableTreeNode var = new DefaultMutableTreeNode(String.valueOf(variableObj.getVarName()));
            currentNode.add(var);
        }
        if (start.getClass().getName().equals("Tree.RealNumber")) {
            RealNumber numberObj = (RealNumber)start;
            DefaultMutableTreeNode number = new DefaultMutableTreeNode(numberObj.getNumber());
            currentNode.add(number);
        }
        if (start.getClass().getName().equals("Tree.BinaryOperator")) {
            BinaryOperator binaryObj = (BinaryOperator)start;
            DefaultMutableTreeNode binary = new DefaultMutableTreeNode(this.inputComponents[binaryObj.getID()].getDisplayText());
            currentNode.add(binary);
            this.traverse(binaryObj.getRightChild(), binary);
            this.traverse(binaryObj.getLeftChild(), binary);
        }
        if (start.getClass().getName().equals("Tree.Function")) {
            Function functionObj = (Function)start;
            DefaultMutableTreeNode function = new DefaultMutableTreeNode(this.inputComponents[functionObj.getID()].getDisplayText());
            currentNode.add(function);
            this.traverse(functionObj.getChild(), function);
        }
        if (start.getClass().getName().equals("Tree.NaryFunction")) {
            NaryFunction naryFunctionObj = (NaryFunction)start;
            nary = new DefaultMutableTreeNode(this.inputComponents[naryFunctionObj.getID()].getDisplayText());
            currentNode.add(nary);
            for (i = 0; i < naryFunctionObj.getSize(); ++i) {
                this.traverse(naryFunctionObj.getChild(i), nary);
            }
        }
        if (start.getClass().getName().equals("Tree.Matrix")) {
            Matrix matrixObj = (Matrix)start;
            DefaultMutableTreeNode matrix = new DefaultMutableTreeNode(this.inputComponents[matrixObj.getID()].getDisplayText());
            currentNode.add(matrix);
        }
        if (start.getClass().getName().equals("Tree.Grouping")) {
            Grouping groupingObj = (Grouping)start;
            DefaultMutableTreeNode grouping = new DefaultMutableTreeNode(this.inputComponents[groupingObj.getID()].getDisplayText());
            currentNode.add(grouping);
            this.traverse(groupingObj.getChild(), grouping);
        }
        if (start.getClass().getName().equals("Tree.NaryOperator")) {
            NaryOperator naryObj = (NaryOperator)start;
            nary = new DefaultMutableTreeNode(this.inputComponents[naryObj.getID()].getDisplayText());
            currentNode.add(nary);
            for (i = 0; i < naryObj.getSize(); ++i) {
                this.traverse(naryObj.getChild(i), nary);
            }
        }
    }
}

