/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class EvaluatorVisitor
implements ParserVisitor,
EvaluatorI {
    protected Stack stack;
    protected SymbolTable symTab;
    protected static final boolean debug = false;
    protected boolean trapNullValues = true;

    private EvaluatorVisitor() {
        this.symTab = null;
        this.stack = new Stack();
    }

    public EvaluatorVisitor(SymbolTable st) {
        this.symTab = st;
        this.stack = new Stack();
    }

    public Object getValue(Node topNode, SymbolTable symTab_in) throws ParseException {
        if (topNode == null) {
            throw new ParseException("topNode parameter is null");
        }
        this.symTab = symTab_in;
        this.stack.removeAllElements();
        topNode.jjtAccept(this, null);
        if (this.stack.size() != 1) {
            throw new ParseException("Stack corrupted");
        }
        return this.stack.pop();
    }

    public Object eval(Node node) throws ParseException {
        node.jjtAccept(this, null);
        return this.stack.pop();
    }

    public Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("No visit method for " + node.getClass().getName());
    }

    public Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("Start node encountered during evaluation");
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        if (node == null) {
            return null;
        }
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            throw new ParseException("No function class associated with " + node.getName());
        }
        if (pfmc instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)pfmc)).evaluate(node, data, this, this.stack, this.symTab);
        }
        if (pfmc instanceof CallbackEvaluationI) {
            Object val = ((CallbackEvaluationI)((Object)pfmc)).evaluate(node, this);
            this.stack.push(val);
            return val;
        }
        data = node.childrenAccept(this, data);
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        pfmc.run(this.stack);
        return data;
    }

    public Object visit(ASTVarNode node, Object data) throws ParseException {
        Variable var = node.getVar();
        if (var == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(message + "the variable was not found in the symbol table");
        }
        Object temp = var.getValue();
        if (this.trapNullValues && temp == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(message + "variable not set");
        }
        this.stack.push(temp);
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean b) {
        this.trapNullValues = b;
    }
}

