<?PHP

// blogDisp : 0 コースの最新のブログ表示 / This Course
//            1 コースの最新のブログ表示（一人一件） / One for One
//            2 サイトの最新のブログ表示 / This Site
$blogDisp = optional_param('blogDisp', -1, PARAM_INT);
if (($blogDisp < 0) || ($blogDisp > 2)) {
    if (isset($_SESSION['blogDisp'])) $blogDisp = $_SESSION['blogDisp'];
        else                          $blogDisp = 0;
}
$_SESSION['blogDisp'] = $blogDisp;

class block_updated_blogs extends block_base {

    function init() {
        global $CFG;
        $this->title = get_string('updated_blogs', 'block_updated_blogs');
        //helpbutton ('updated_blogs', get_string('updated_blogs', 'blog'), 'blog', true, false, '', true);
        $this->version = 2007031501;
    }

    function applicable_formats() {
        return array('all' => true, 'my' => true);
    }

    function has_config() {
        return true;
    }

    function get_content() {
        global $CFG, $COURSE;
        if ($this->content !== NULL) {
            return $this->content;
        }
        if (isset($CFG->block_updated_blogs_viewmax)) {
            $viewmax = $CFG->block_updated_blogs_viewmax;
        } else {
            $viewmax = 5;
        }

        if (isset($CFG->block_updated_blogs_layout)) {
            $layout = $CFG->block_updated_blogs_layout;
        } else {
            $layout = "rows";
        }

        // This query is built according to "login state".
        // Not logged in: Only public.
        // Logged in: Only site and public.
        // Drafts are never shown, guests can only see public.

        $blogDisp = $_SESSION['blogDisp'];
        if ((($blogDisp == 0) || ($blogDisp == 1)) && !empty($COURSE) && ($COURSE->id != SITEID)) {
            $sql  = 'SELECT p.subject,p.userid,p.id,p.lastmodified ';
            $sql .= "FROM {$CFG->prefix}post AS p, {$CFG->prefix}user_lastaccess AS ul ";
            $sql .= "WHERE (p.userid=ul.userid AND ul.courseid = $COURSE->id)";
            $sql .= "AND (p.publishstate = 'public'";
        } else {
            $sql = 'SELECT subject,userid,id,lastmodified'
                    . ' FROM '. $CFG->prefix.'post'
                    . ' where (publishstate = \'public\'';
        }
        if (isloggedin() && !isguest()) {
            $sql .= ' or publishstate = \'site\')';
        } else {
            $sql .= ')';
        }
        $sql .= ' order by lastmodified desc';

        $rows=get_records_sql($sql);

        $this->content = new stdClass;
        $this->content->text    = '';
        $this->content->footer  = '';
        if (is_array($rows) && (($layout == 'columns') || ($layout == 'rows'))) {
            $strdisplaymode       = get_string('displaymode',       'block_updated_blogs');
            $strtoggle            = get_string('toggle',            'block_updated_blogs');
            $strcoursemodenorm    = get_string('coursemodenorm',    'block_updated_blogs');
            $strcoursemodeonlyone = get_string('coursemodeonlyone', 'block_updated_blogs');
            $strsitemode          = get_string('sitemode',          'block_updated_blogs');
            $strlinktoblogview    = get_string('linktoblogview', 'block_updated_blogs');
            // for Japanese only
            if (substr($strdisplaymode,       0, 2) == '[[') $strdisplaymode       = '表示モード';
            if (substr($strtoggle,            0, 2) == '[[') $strtoggle            = '切替';
            if (substr($strcoursemodenorm,    0, 2) == '[[') $strcoursemodenorm    = '本コース';
            if (substr($strcoursemodeonlyone, 0, 2) == '[[') $strcoursemodeonlyone = '一人一件';
            if (substr($strsitemode,          0, 2) == '[[') $strsitemode          = '本サイト';
            if (substr($strlinktoblogview,    0, 2) == '[[') $strlinktoblogview    = '全ブログ表示';
            if ($COURSE->id == SITEID) {
                $subtext1 = ') : <a href="'.$CFG->wwwroot.'/index.php?blogDisp=';
            } else {
                $subtext1 = ') : <a href="'.$CFG->wwwroot.'/course/view.php?id='.$COURSE->id.'&amp;blogDisp=';
            }
            $subtext2 = '">'.$strtoggle.'</a></div>'."\n";
            $text = '<div class="block_updated_blogs blogend">'.$strdisplaymode.'(';
            if ($blogDisp == 0)        $text .= $strcoursemodenorm.   $subtext1.'1'.$subtext2;
              else if ($blogDisp == 1) $text .= $strcoursemodeonlyone.$subtext1.'2'.$subtext2;
              else if ($blogDisp == 2) $text .= $strsitemode.         $subtext1.'0'.$subtext2;
              else                     $text .= 'Abnormal'.           $subtext1.'0'.$subtext2;
            if ($layout == 'columns') {
                $text .= '<table width=100% class="sideblock content block_updated_blogs">';
                $text .='<th>'.get_string('page').'</th><th>'.get_string('date').'</th><th>'.get_string('user').'</th>';            }

            $lastlastmodified = "";
            $i=0;
            $userids = array();
            foreach ($rows as $row){
                if (($blogDisp == 1) && in_array($row->userid, $userids)) {
                    continue;
                } else {
                    $userids[] = $row->userid;
                }
                $info=get_user_info_from_db('id',$row->userid);
// (3rdParty021): 削除されたユーザのblogエントリのユーザ名表示がエラーになるバグ (2012/04/10) (Updated_Blogs)
// (3rdParty021): ここから追加
                if (empty($info->username)) $info->username = null;
// (3rdParty021): ここまで追加
                switch($layout) {
                  case "columns":
                    $text.= '<tr>
                        <td align="left" class="block_updated_blogs_blogend_table">
                            <a href="'.$CFG->wwwroot.'/blog/index.php?postid='.$row->id.'&amp;courseid='.$COURSE->id.'">'.
                            $row->subject.'</a>
                        </td>
                        <td align="right" class="block_updated_blogs_blogend_table">'.
                            userdate($row->lastmodified).
                        '</td>
                        <td align="right" class="block_updated_blogs_blogend_table">'.
                            $this->get_user_info($info->username,20,true).
                        '</td>
                        </tr>';
                    break;
                  case "rows":
                    $lastmodified = userdate($row->lastmodified);
                    if ($lastmodified != $lastlastmodified) {
                        $lastlastmodified = $lastmodified;
                        $text.= '<div class="block_updated_blogs block_updated_blogs_modified">'.$lastmodified.'</div>'."\n";
                    }
                    $text .= '<div class="block_updated_blogs">
                            <a href="'.$CFG->wwwroot.'/blog/index.php?postid='.$row->id.'&amp;courseid='.$COURSE->id.'">'.
                            $row->subject.'</a>
                        </div>'."\n".'
                        <div class="block_updated_blogs blogend">'.
                            $this->get_user_info($info->username,20,true).
                        '</div>'."\n";
                    break;
                  default:
                    break;
                }
                $i++;
                if($i==$viewmax) break;
            }
            if ($layout === 'columns') $text .= '</table>';
            $text .= '<div class="block_updated_blogs aligncenter">
                             <a href="'.$CFG->wwwroot.'/blog/index.php?filtertype=site';
            if (!empty($COURSE) && ($COURSE->id != SITEID)) $text .= '&amp;courseid='.$COURSE->id;
            $text .= '">'.$strlinktoblogview.'</a></div>';
            $this->content->text=$text;
        }

        return $this->content; 
    }

    function get_user_info ($user, $size, $puttext){
    global $course,$CFG;
    if (empty($course)) {
        global $COURSE;
        $course = $COURSE;
    }

    //get user id and image
    if (record_exists("user", 'username',$user)){
        $info=get_user_info_from_db('username',$user);
        $picture = print_user_picture($info->id, $course->id, $info->picture, $size, true,true);
        if ($puttext){
            $text = '<a href="'.$CFG->wwwroot.'/user/view.php?id='.$info->id.'&amp;course='.$course->id.'">'.fullname($info).'</a>';
        } else {
            $text = '';
        }
        //        $text = print_r($info, true);
    }else{
// (3rdParty021): ここから修正
//      $text = '<u>'.fullname($info).'</u>';
        $text = '<u>'.get_string('userdeleted', 'admin').'</u>';
// (3rdParty021): ここまで修正
        $picture = '';
    }

    //build url
    $res = $text.' '.$picture;
    return $res;
    }

    //this function trims any given text and returns it with some dots at the end
    function trim_string($text,$limit){

        if(strlen($text)>$limit){
            $text = substr($text,0,$limit).'...';
        }
        
        return $text;
    }
    
    /**
     * This function is called on your subclass right after an instance is loaded
     * Use this function to act on instance data just after it's loaded and before anything else is done
     * For instance: if your block will have different title's depending on location (site, course, blog, etc)
     */

    function specialization() {
        // Just to make sure that this method exists.
    }
}

?>
