<?php // $Id$

//  Remove oneself or someone else from a course, unassigning all
//  roles one might have
//
//  This will not delete any of their data from the course,
//  but will remove them from the participant list and prevent
//  any course email being sent to them.

    require_once("../config.php");
    require_once("lib.php");

    $id      = required_param('id', PARAM_INT);               //course
    $userid  = optional_param('user', 0, PARAM_INT);          //course
    $confirm = optional_param('confirm', 0, PARAM_BOOL);
// (Shirai201): 登録キーが登録されているコースからユーザ自ら登録抹消する際に登録キーの入力を要求する機能の追加 (2010/11/18)
// (Shirai201): ここから追加
    $action   = optional_param('action', '', PARAM_RAW);
    $password = optional_param('password', '', PARAM_RAW);
    $referer  = optional_param('referer', '', PARAM_URL);
// (Shirai201): ここまで追加

    if($userid == $USER->id){
        // the rest of this code assumes $userid=0 means 
        // you are unassigning yourself, so set this for the
        // correct capabiliy checks & language later
        $userid = 0;
    }

    if (! $course = get_record('course', 'id', $id) ) {
        error('Invalid course id');
    }

    if (! $context = get_context_instance(CONTEXT_COURSE, $course->id)) {
        error('Invalid context');
    }

    require_login($course->id);

    if ($course->metacourse) {
        print_error('cantunenrollfrommetacourse', '', $CFG->wwwroot.'/course/view.php?id='.$course->id);
    }

    if ($userid) {   // Unenrolling someone else
        require_capability('moodle/role:assign', $context, NULL, false);

        $roles = get_user_roles($context, $userid, false);

        // verify user may unassign all roles at course context
        foreach($roles as $role) {
            if (!user_can_assign($context, $role->roleid)) {
                error('Can not unassign this user from role id:'.$role->roleid);
            }
        }

    } else {         // Unenrol yourself
        require_capability('moodle/role:unassignself', $context, NULL, false);
    }

    if (!empty($USER->access['rsw'][$context->path])) {
        print_error('cantunenrollinthisrole', '',
                    $CFG->wwwroot.'/course/view.php?id='.$course->id);
    }

    if ($confirm and confirm_sesskey()) {
        if ($userid) {
            if (! role_unassign(0, $userid, 0, $context->id)) {
                error("An error occurred while trying to unenrol that person.");
            }

            add_to_log($course->id, 'course', 'unenrol',
                    "view.php?id=$course->id", $course->id);
            redirect($CFG->wwwroot.'/user/index.php?id='.$course->id);

        } else {
            if (! role_unassign(0, $USER->id, 0, $context->id)) {
                error("An error occurred while trying to unenrol you.");
            }

            // force a refresh of mycourses
            unset($USER->mycourses);
            add_to_log($course->id, 'course', 'unenrol',
                    "view.php?id=$course->id", $course->id);

            redirect($CFG->wwwroot);
        }
    }


    $strunenrol = get_string('unenrol');
    $navlinks = array();
    $navlinks[] = array('name' => $strunenrol, 'link' => null, 'type' => 'misc');
    $navigation = build_navigation($navlinks);

    print_header("$course->shortname: $strunenrol", $course->fullname, $navigation);

// (Shirai201): ここから追加
// enrol/manual/enrol.htmlを参考に改良
    if (fs_function_enable('FS_DISABLE_NEEDPASSWORD2COURSEENROLE')) {
        if ($course->password != '' and !(isguestuser() and !empty($USER->enrolkey[$course->id]))) {   // password
            if (empty($action)) $action = 'requirepassword';
            if ($action == 'enterpassword') {
                if ($password != $course->password) $action = 'password_ng';
                  else                              $action = 'password_ok';
            }
            if (!empty($referer)) $_SERVER['HTTP_REFERER'] = $referer;
        }
    } else $action = '';

    if (($action == 'requirepassword') || ($action == 'password_ng')) {
        print_box_start('generalbox centerpara');
        if ($action == 'password_ng') {
            echo '<p align="center">'.get_string('enrolmentkeyerror', 'enrol_manual').'</p>';
        }
        echo '<p align="center">';
        print_string('needenterpassword', 'fs_moodle');
?>
        </p>

        <form method="post" action="unenrol.php">
          <table align="center" width="100%">
            <tr>
              <td align="right"><?php print_string("enrolmentkey") ?>:</td>
              <td>
                <input type="password" name="password" size="20" value="<?php p($password) ?>"  />
                <input type="hidden" name="id" value="<?php p($course->id) ?>"  />
                <input type="hidden" name="sesskey" value="<?php echo sesskey() ?>" />
                <input type="hidden" name="action" value="enterpassword" />
                <input type="hidden" name="referer" value="<?php echo $_SERVER['HTTP_REFERER'];?>" />
                <input type="submit" value="<?php print_string("unenrol") ?>" />
              </td>
            </tr>
          </table>
        </form>
        <br />

        <div align="center">
        <form action="<?php echo $CFG->wwwroot.'/course/view.php?id='.$course->id; ?>" method="post">
        <input type="submit" value="<?php print_string("cancel") ?>" />
        </form>
        </div>
<?php 
        print_box_end();
    } else if (empty($action) || ($action == 'password_ok')) {
// (Shirai201): ここまで追加
    if ($userid) {
        if (!$user = get_record('user', 'id', $userid)) {
            error('That user does not exist!');
        }
        $strunenrolsure  = get_string('unenrolsure', '', fullname($user, true));
        notice_yesno($strunenrolsure, "unenrol.php?id=$id&amp;user=$user->id&amp;confirm=yes&amp;sesskey=".sesskey(),
                                      $_SERVER['HTTP_REFERER']);
    } else {
        $strunenrolsure  = get_string('unenrolsure', '', get_string("yourself"));
        notice_yesno($strunenrolsure, "unenrol.php?id=$id&amp;confirm=yes&amp;sesskey=".sesskey(),
                                      $_SERVER['HTTP_REFERER']);
    }
// (Shirai201): ここから追加
    }
// (Shirai201): ここまで追加

    print_footer($course);

?>
