<?php
// Mobile mode for Moodle since 2008/03/20
// Designed by Tatsuya Shirai (Suzuka National College of Technology)
// mailto:shirai@mech.suzuka-ct.ac.jp
// http://www.suzuka-ct.ac.jp/mech/ai_mech/~shirai/index.html (in Japanese only)
// http://www.suzuka-ct.ac.jp/mech/moodle (in Japanese only)
// http://www.suzuka-ct.ac.jp/mech/moodle/course/view.php?id=30&topic=0 (in Japanese only)

// <cookies for mobile mode>
// a) mobile_on                  : 'on', (or others eg.'off')
// b) mobile_courseViewColumn    : 'left', 'middle', 'right', 'all'
// c) mobile_frontpageViewColumn : 'left', 'middle', 'right', 'all'
// d) mobile_courseViewSection   : 'AllOpen', 'AllClose', 'TmpOpen', 'TmpClose', 'UserSel'

//////////////////////////////////////////////////////
// functions for setting up cookies in mobile mode.
//////////////////////////////////////////////////////

// (Shirai054): モバイルモード機能の追加 (2008/03/20)
// (Shirai054): ここから追加
    // モバイル端末向けのクッキーを設定する．
    function mobile_cookie($name, $value = false) {
        global $CFG;
        return setcookie("mobile_$name", $value, time()+60*60*24*30, "/", $CFG->wwwroot);
    }

    // モバイル端末向けの設定（クッキー）を初期化する．
    function mobile_on() {
        $status =  mobile_cookie('on', 'on');
        $status &= mobile_cookie('courseViewColumn', 'middle');
        $status &= mobile_cookie('frontpageViewColumn', 'middle');
        $status &= mobile_cookie('courseViewSection', 'AllOpen');
        return $status;
    }

    // モバイル端末向けの設定（クッキー）を削除する．
    function mobile_off() {
        $status =  mobile_cookie('on');
        $status &= mobile_cookie('courseViewColumn');
        $status &= mobile_cookie('frontpageViewColumn');
        $status &= mobile_cookie('courseViewSection');
        return $status;
    }
// (Shirai054): ここまで追加

// (Shirai060): ログイン時にクッキーの値を再書き込みして有効期限を更新する (2008/03/26)
// (Shirai060): ここから追加
    // モバイル端末向けの設定（クッキー）を更新する．
    // クッキーの更新に失敗した時のみfalse，それ以外はtrueを返す
    function mobile_refresh() {
        if (is_mobile_on()) {
            $status =  mobile_cookie('on', 'on');
            $status &= mobile_cookie('courseViewColumn', courseViewColumn());
            $status &= mobile_cookie('frontpageViewColumn', frontpageViewColumn());
            $status &= mobile_cookie('courseViewSection', courseViewSection());
            return $status;
        }
        return true;
    }
// (Shirai060): ここまで追加

///////////////////////////////////////////////////////////
// functions for checking status of cookies in mobile mode.
///////////////////////////////////////////////////////////

// (Shirai054): モバイルモード機能の追加 (2008/03/20)
// (Shirai054): ここから追加
    // モバイルモードがOnかOffか
    // （戻り値: true / false）
    function is_mobile_on() {
// (Shirai083): モバイルモードを無効化可能とする改善 (2008/08/19)
// (Shirai083): ここから追加
        if (!enable_mobilemode()) return false;
// (Shirai083): ここまで追加
        return (isset($_COOKIE['mobile_on']) && $_COOKIE['mobile_on'] == 'on');
    }
// (Shirai054): ここまで追加

// (Shirai055): コース表示の左コラム／メイン／右コラム／全ての選択を可能とする (2008/03/20)
// (Shirai055): ここから追加
    // コースで表示するカラムを返す
    //（戻り値： 'left', 'middle', 'right', 'all' or false）
    function courseViewColumn() {
        if (isset($_COOKIE['mobile_courseViewColumn'])) return ($_COOKIE['mobile_courseViewColumn']);
        return false;
    }
// (Shirai055): ここまで追加

// (Shirai058): フロントページも左コラム／メイン／右コラム／全ての選択を可能とする (2008/03/25)
// (Shirai058): ここから追加
    // フロントページで表示するカラムを返す
    //（戻り値： 'left', 'middle', 'right', 'all' or false）
    function frontpageViewColumn() {
        if (isset($_COOKIE['mobile_frontpageViewColumn'])) return ($_COOKIE['mobile_frontpageViewColumn']);
        return false;
    }
// (Shirai058): ここまで追加

// (Shirai061): コースのトピックスのセクションを展開／隠すを可能とする (2008/03/26)
// (Shirai061): ここから追加
    // コースのmiddle columnでの各セクションの開き方を返す
    //（戻り値： 'AllOpen', 'AllClose', 'TmpOpen', 'TmpClose', 'UserSel' or false）
    function courseViewSection() {
        if (isset($_COOKIE['mobile_courseViewSection'])) return ($_COOKIE['mobile_courseViewSection']);
        return false;
    }
// (Shirai061): ここまで追加

////////////////////////////////////////////
// Special functions for selecting a column.
////////////////////////////////////////////

// (Shirai055): コース表示の左コラム／メイン／右コラム／全ての選択を可能とする(2008/03/20)
// (Shirai055): ここから追加
    function get_columnSelect_button()
    {
        $colSelHead   = '<input type="button" onclick='."'".'mobile_cookie_set_and_reload("courseViewColumn", ';
        $colSelLeft   = $colSelHead.'"left")'  ."'".' value="';
        $colSelLeft  .= get_string('mm_leftButton', 'fs_moodle').'" />';
        $colSelMiddle = $colSelHead.'"middle")'."'".' value="&nbsp;';
        $colSelMiddle.= get_string('mm_middleButton', 'fs_moodle').'&nbsp;" />';
        $colSelRight  = $colSelHead.'"right")' ."'".' value="';
        $colSelRight .= get_string('mm_rightButton', 'fs_moodle').'" />';
        $colSelALL    = $colSelHead.'"all")'   ."'".' value="&nbsp;';
        $colSelALL   .= get_string('mm_allButton', 'fs_moodle').'&nbsp;" />';
        return $colSelLeft."&nbsp;".$colSelMiddle."&nbsp;".$colSelRight."&nbsp;".$colSelALL;
    }

    // どのカラムを表示するのかをArrayに入れて返す関数（テーマにも対応）
    function column_layouttable()
    {
        global $THEME;

        if (empty($THEME->layouttable)) {
            if (is_mobile_on()) {
                switch (courseViewColumn()) {
                    case 'left':    $lt = array('left');   break;
                    case 'right':   $lt = array('right');  break;
                    case 'middle':  $lt = array('middle'); break;
                    case 'all':
                    default:        $lt = array('left', 'middle', 'right');
                }
            } else $lt = array('left', 'middle', 'right');
        } else $lt = $THEME->layouttable;
        return $lt;
    }
// (Shirai055): ここまで追加


///////////////////////////////////////////////////////////
// Special functions for course/format/???/format.php
///////////////////////////////////////////////////////////

// (Shirai061): コースのトピックスのセクションを展開／隠すを可能とする (2008/03/26)
// (Shirai061): ここから追加
    // クリッカブルなセクション番号文字列を生成する関数
    function get_sectionSwitch_string($section, $currenttext = '')
    {
        global $SectionVisible;

        $secNumStr = '<td id="sectionblock-'.$section.'" class="left side"><a href="javascript:courseSectionToggle('.$section.',';
        if (isset($SectionVisible) && $SectionVisible[$section] == 1) {
            $secNumStr .= 'false)"';
        } else {
            $secNumStr .= 'true)"';
        }
        $secNumStr .= '>'.$currenttext.$section.'</a></td>';
        return $secNumStr;
    }
    // weeks/weekscss用
    function get_sectionSwitch_string_weeks($section, $weekperiod, $css = false)
    {
        global $SectionVisible;
        $secNumStr = '';
        if ($section == 0) {
            if ($css) $secNumStr .= '<div class="right side" >';
                else  $secNumStr .= '<td class="right side">';
        }
        $secNumStr .= '<a href="javascript:courseSectionToggle('.$section.',';
        if (isset($SectionVisible) && $SectionVisible[$section] == 1) {
            $secNumStr .= 'false)"';
        } else {
            $secNumStr .= 'true)"';
        }
        $secNumStr .= '>'.$weekperiod;
        if ($section == 0) {
            if ($css)   $secNumStr .= $section.'</a></div>';
                else    $secNumStr .= $section.'</a></td>';
        } else          $secNumStr .= '</a>';
        return $secNumStr;
    }

    // このセクションを開く(true)か否(false)かを返す関数
    function is_section_visible($section)
    {
        global $SectionVisible;
        if (!is_mobile_on()) return true;
        switch (courseViewSection()) {
            case 'AllOpen':  case 'TmpOpen':
                return true;
            case 'UserSel':
                if ($SectionVisible[$section] == 1) return true;
                break;
            case 'AllClose': case 'TmpClose':
                break;
        }
        return false;
    }

    // どのセクションを表示するか（デフォルトは表示しない）をシリアライズして$_SESSION変数で保存する．
    function load_SectionVisibleArray()
    {
        global $SectionVisible;
        global $course;

        if (isset($_SESSION['SectionVisible'])) {
            if (is_array($a = unserialize($_SESSION['SectionVisible']))) {
                $SectionVisible = $a;
            }
        }
        // クッキーやパラメータに従がって，$SectionVisibleの値を修正する
        if (is_mobile_on()) {
            // パラメータで与えられたセクションの値を変更する．保存は最後に．
            $SecOpen  = optional_param('SecOpen',  -1, PARAM_INT);
            $SecClose = optional_param('SecClose', -1, PARAM_INT);
            if (is_numeric($SecOpen)  && ($SecOpen  >= 0)) $SectionVisible[$SecOpen]  = 1;
            if (is_numeric($SecClose) && ($SecClose >= 0)) $SectionVisible[$SecClose] = 0;
            // クッキーの値に応じて修正
            if (($cvsMode = courseViewSection()) == 'AllOpen') $cvsSwitch =  1;
              else if ($cvsMode == 'AllClose')                 $cvsSwitch =  0;
              else {
                // TmpOpen, TmpClose, UserSel の場合
                $cvsSwitch = -1;  // No change
                // もしコースを移動しているならば全てのセクションを閉じる
                if (!isset($_SESSION['mobile_course_id']) || ($_SESSION['mobile_course_id'] != $course->id)) {
                    unset($SecvionVisible);
                    $cvsSwitch = 0;
                }
            }
            // 更新
            if ($cvsSwitch >= 0) {
                for ($section = 0; $section <= $course->numsections; $section++) $SectionVisible[$section] = $cvsSwitch;
            }
            $_SESSION['mobile_course_id'] = $course->id;
        }
    }
    // 再びシリアライズして保管する．
    function store_SectionVisibleArray()
    {
        global $SectionVisible;
        if (isset($SectionVisible)) $_SESSION['SectionVisible'] = serialize($SectionVisible);
    }
    // セクションの開き方を選択するボタン（＋チェックボックス）を表示するフォームを生成する関数
    function get_sectionSelectMethod_button()
    {
        $secSelTop  = '<div align = center><form name="SectionMode"><input type="checkbox" name="Force">';
        $secSelTop .= get_string('mm_completely', 'fs_moodle').'&nbsp;';
        $secSelBtm  = '</form></div>';
        $secSelHead    = '<input type="button" onClick='."'".'courseSectionSwitch(';
        $secSelOpen    = $secSelHead.'"Open")'.   "'".' value="&nbsp;';
        $secSelOpen   .= get_string('mm_openButton', 'fs_moodle').'&nbsp;" />';
        $secSelClose   = $secSelHead.'"Close")'.  "'".' value="';
        $secSelClose  .= get_string('mm_closeButton', 'fs_moodle').'" />';
        $secSelUserSel = $secSelHead.'"UserSel")'."'".' value="&nbsp;';
        $secSelUserSel.= get_string('mm_retButton', 'fs_moodle').'&nbsp;" />';
        $secSelStr = $secSelTop.$secSelOpen.'&nbsp;'.$secSelClose.'&nbsp;/&nbsp;'.$secSelUserSel.$secSelBtm;
        return $secSelStr;
    }
    // weeksccs/format.php 用
    // このコラムは表示するか，否か．
    // 引数： 'left', 'right', 'middle'のみ
    // （戻り値： boolean）
    function is_visible_thisColumn($column)
    {
        if (is_mobile_on()) {
            $cvc = courseViewColumn();
            if ($cvc == 'all')      return true;
            if ($cvc == $column)    return true;
            return false;
        }
        return true;
    }
// (Shirai061): ここまで追加

// (Shirai083): モバイルモードを無効化可能とする改善 (2008/08/19)
// (Shirai083): ここから追加
    function enable_mobilemode()
    {
        if (defined('FS_DISABLE_MOBILEMODE') && (FS_DISABLE_MOBILEMODE)) return false;
        return true;
    }
// (Shirai083): ここまで追加

?>
