<?php // $Id$

require_once('../config.php');
require_once('lib.php');
require_once('pagelib.php');
require_once($CFG->dirroot.'/lib/weblib.php');
require_once($CFG->dirroot.'/blog/lib.php');

require_login();

if (empty($CFG->usetags)) {
    print_error('tagsaredisabled', 'tag');
}

$tagid       = optional_param('id', 0, PARAM_INT); // tag id
$tagname     = optional_param('tag', '', PARAM_TAG); // tag 

$edit        = optional_param('edit', -1, PARAM_BOOL);
$userpage    = optional_param('userpage', 0, PARAM_INT); // which page to show
$perpage     = optional_param('perpage', 24, PARAM_INT);
// (Debug024): blogの編集時にコースIDを渡していない箇所の修正 (2009/07/21)
// (Debug024): ここから追加
$courseid = optional_param('courseid', SITEID, PARAM_INT);
course_setup($courseid);
if (isset($COURSE->id) && ($COURSE->id != SITEID)) $hcourseid = '&amp;courseid='.$COURSE->id;
    else                                           $hcourseid = '';
// (Debug024): ここまで追加


if ($tagname) {
    $tag = tag_get('name', $tagname, '*');
} else if ($tagid) {
    $tag = tag_get('id', $tagid, '*');
}

if (empty($tag)) {
    redirect($CFG->wwwroot.'/tag/search.php');
}


//create a new page_tag object, defined in pagelib.php
$PAGE = page_create_object(PAGE_TAG_INDEX, $tag->id);
$pageblocks = blocks_setup($PAGE,BLOCKS_PINNED_BOTH);
$PAGE->tag_object = $tag;

if (($edit != -1) and $PAGE->user_allowed_editing()) {
    $USER->editing = $edit;
}


$PAGE->print_header();

// Manage all tags links
$systemcontext   = get_context_instance(CONTEXT_SYSTEM);

if (has_capability('moodle/tag:manage', $systemcontext)) {
    echo '<div class="managelink"><a href="'. $CFG->wwwroot .'/tag/manage.php">'. get_string('managetags', 'tag') .'</a></div>' ;
}

echo '<table border="0" cellpadding="3" cellspacing="0" width="100%" id="layout-table">';
echo '<tr valign="top">';

//----------------- left column -----------------

$blocks_preferred_width = bounded_number(180, blocks_preferred_width($pageblocks[BLOCK_POS_LEFT]), 210);

if (blocks_have_content($pageblocks, BLOCK_POS_LEFT) || $PAGE->user_is_editing()) {
    echo '<td style="vertical-align: top; width: '.$blocks_preferred_width.'px;" id="left-column">';
    blocks_print_group($PAGE, $pageblocks, BLOCK_POS_LEFT);
    echo '</td>';
}

//----------------- middle column -----------------

echo '<td valign="top" id="middle-column">';

$tagname  = tag_display_name($tag);

if ($tag->flag > 0 && has_capability('moodle/tag:manage', $systemcontext)) {
    $tagname =  '<span class="flagged-tag">' . $tagname . '</span>';
}

print_heading($tagname, '', 2, 'headingblock header tag-heading');
tag_print_management_box($tag);
tag_print_description_box($tag);

$usercount = tag_record_count('user', $tag->id);

if ($usercount > 0) {

    //user table box
    print_box_start('generalbox', 'tag-user-table');

    $heading = get_string('userstaggedwith', 'tag', $tagname) . ': ' . $usercount;
    print_heading($heading, '', 3);

    $baseurl = $CFG->wwwroot.'/tag/index.php?id=' . $tag->id;

    print_paging_bar($usercount, $userpage, $perpage, $baseurl.'&amp;', 'userpage');
    tag_print_tagged_users_table($tag, $userpage * $perpage, $perpage);
    print_box_end();
}

// Print last 10 blogs

// I was not able to use get_items_tagged_with() because it automatically 
// tries to join on 'blog' table, since the itemtype is 'blog'. However blogs
// uses the post table so this would not really work.    - Yu 29/8/07
if (has_capability('moodle/blog:view', $systemcontext)) {  // You have to see blogs obviously

    if ($blogs = blog_fetch_entries('', 10, 0, 'site', '', $tag->id)) {

        print_box_start('generalbox', 'tag-blogs');

        print_heading(get_string('relatedblogs', 'tag'), '', 3);

        echo '<ul id="tagblogentries">';
        foreach ($blogs as $blog) {
            if ($blog->publishstate == 'draft') {
                $class = 'class="dimmed"';
            } else {
                $class = '';
            }
            echo '<li '.$class.'>';
// (Debug024): ここから修正
//          echo '<a '.$class.' href="'.$CFG->wwwroot.'/blog/index.php?postid='.$blog->id.'">';
            echo '<a '.$class.' href="'.$CFG->wwwroot.'/blog/index.php?postid='.$blog->id.$hcourseid.'">';
// (Debug024): ここまで修正
            echo format_string($blog->subject);
            echo '</a>';
            echo ' - '; 
            echo '<a '.$class.' href="'.$CFG->wwwroot.'/user/view.php?id='.$blog->userid.'">';
            echo fullname($blog);
            echo '</a>';
            echo ', '. userdate($blog->lastmodified);
            echo '</li>';
        }
        echo '</ul>';

// (Debug024): ここから修正
//      echo '<p class="moreblogs"><a href="'.$CFG->wwwroot.'/blog/index.php?filtertype=site&filterselect=0&tagid='.$tag->id.'">'.get_string('seeallblogs', 'tag').'</a>...</p>';
        echo '<p class="moreblogs"><a href="'.$CFG->wwwroot.'/blog/index.php?filtertype=site&filterselect=0&tagid='.$tag->id.$hcourseid.'">'.get_string('seeallblogs', 'tag').'</a>...</p>';
// (Debug024): ここまで修正

        print_box_end();
    }
}


echo '</td>';


//----------------- right column -----------------

$blocks_preferred_width = bounded_number(180, blocks_preferred_width($pageblocks[BLOCK_POS_RIGHT]), 210);

if (blocks_have_content($pageblocks, BLOCK_POS_RIGHT) || $PAGE->user_is_editing()) {
    echo '<td style="vertical-align: top; width: '.$blocks_preferred_width.'px;" id="right-column">';
    blocks_print_group($PAGE, $pageblocks, BLOCK_POS_RIGHT);
    echo '</td>';
}

/// Finish the page
echo '</tr></table>';



$PAGE->print_footer();


?>
