<?php // $Id$

class profile_field_checkbox extends profile_field_base {

    /**
     * Constructor method.
     * Pulls out the options for the checkbox from the database and sets the
     * the corresponding key for the data if it exists
     */
    function profile_field_checkbox($fieldid=0, $userid=0) {
        //first call parent constructor
        $this->profile_field_base($fieldid, $userid);

        if (!empty($this->field)) {
            $datafield = get_field('user_info_data', 'data', 'userid', $this->userid, 'fieldid', $this->fieldid);
            if ($datafield !== false) {
                $this->data = $datafield;
            } else {
                $this->data = $this->field->defaultdata;
            }
        }
    }

    function edit_field_add(&$mform) {
        /// Create the form field
// (Shirai108): ユーザプロファイルフィールドの各項目の説明をポップアップ表示可能とする(2008/12/18)
// (Shirai108): ここからコメントアウト
//      $checkbox = &$mform->addElement('advcheckbox', $this->inputname, format_string($this->field->name));
// (Shirai108): ここから追加
        if (fs_function_enable('FS_ENABLE_POPUP_USERPROFILEDESCRIPTION')) {
            $pre  = '<SPAN TITLE="'.format_string($this->field->description).'">';
            $post = '</SPAN>';
        } else {
            $pre = $post = '';
        }
        $checkbox = &$mform->addElement('advcheckbox', $this->inputname, $pre.format_string($this->field->name).$post);
// (Shirai108): ここまで追加
        if ($this->data == '1') {
            $checkbox->setChecked(true);
        }        
        $mform->setType($this->inputname, PARAM_BOOL);
        if ($this->is_required() and !has_capability('moodle/user:update', get_context_instance(CONTEXT_SYSTEM, SITEID))) {
            $mform->addRule($this->inputname, get_string('required'), 'nonzero', null, 'client');
        }
    }

    /**
     * Display the data for this field
     */
    function display_data() {
        $options->para = false;
        $checked = intval($this->data) === 1 ? 'checked="checked"' : '';
        return '<input disabled="disabled" type="checkbox" name="'.$this->inputname.'" '.$checked.' />';
    }

}

?>
