<?php

require_once('../../../config.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');

global $CFG, $fsCFG;

if (!fs_isadmin()) error('あなたは管理者権限を持つユーザではありません．');

if (! ($courses = fs_get_records("course", "guest", true))) {
    error('ゲストログイン可能なコースはこのサイトに存在しません．');
}

if (empty($fsCFG->autologin_guests)) {
    echo '　'.color_red('fs_add_autologin_guests()による例外コースの指定が存在しません！');
    newline();
} else {
    printout_autologinguests_conditions($courses);
    newline();
}

newline();
output_CloseWindowButton(true);

function printout_autologinguests_conditions($courses)
{
    global $CFG, $fsCFG;

    echo '<table border="1" width="95%" align="center" cellpadding="5" cellspacing="0" bordercolor="#333333">';
    echo '<caption align="top">ゲストログイン可能なコースとfsconfig_option.phpで設定された例外コースの設定一覧</caption>';
    echo '<tr bgcolor="#cccccc">';
    echo '<th>コースID</th><th>コース名</th><th>オートログイン可否</th></tr>';
    $guestcourses = array();
    // ゲストログイン可能なコース
    foreach ($courses as $course) {
        unset($data);
        $data->id       = $course->id;
        $data->fullname = $course->fullname;
        $data->exist    = true;
        $guestcourses[$course->id] = $data;
    }
    // 例外コース設定
    foreach ($fsCFG->autologin_guests as $courseid => $enable) {
        unset($data);
        if (empty($guestcourses[$courseid])) {
            $data->id = $courseid;
            if ($courseid == SITEID) {
                $data->fullname = '（フロントページ）';
                $data->exist    = true;
            } else {
                if (! ($course = fs_get_record("course", "id", $courseid))) {
                    // 本来，存在しないコースは設定が無視されるはず
                    $data->fullname = '（存在しないコース）';
                    $data->exist = false;
                } else {
                    $data->fullname = $course->fullname;
                    $data->exist    = true;
                }
            }
        } else {
            $data = $guestcourses[$courseid];
        }
        $data->enable = $enable;
        $guestcourses[$courseid] = $data;
    }
    ksort($guestcourses);

    // 一覧表示
    foreach ($guestcourses as $courseid=>$data) {
        echo '<tr>';
        echo '<td align="center">';
        echo $courseid;
        echo '</td><td>';
        if ($data->exist) {
            echo '<a href="'.$CFG->wwwroot.'/course/view.php?id='.$courseid.'" target="_blank">';
            echo $data->fullname;
            echo '</a>';
        } else {
            echo $data->fullname;
        }
        echo '</td><td align="center">';
        if (empty($data->enable)) {
            echo '－';
        } else if ($enable) {
            if (!$CFG->autologinguests)  echo '可';   else echo '（可）';
        } else {
            if ($CFG->autologinguests)   echo '不可'; else echo '（不可）';
        }
        echo '</td>';
        echo '</tr>';
    }
    echo '</table>';
    newline();
    echo 'カッコで（可），（不可）と表示された設定は無意味です．';
    echo 'この設定を行わないでも，$CFG->autologinguestsの設定により可／不可であるためです．';
    echo 'ただし，$CFG->autologinguestsを様子見のためにサイト単位で切り替える場合もあるでしょう．';
    echo 'その際に予想外の挙動（ログイン画面を表示したくないのに表示されてしまうなど）を起こすよりは，';
    echo '確実にオートログインを制御するために設定を記述しておくのは悪い選択ではありません．';
}

?>