// モバイル環境用のJavascript
// (Shirai054): モバイル機能の追加 (2008/03/20)
// lib/cookies.jsを活用

// 全てのモバイル拡張機能をOn
function mobile_all_on() {
    var mbc1 = new cookie("mobile_on", "on", 30, "/", "", "");
    mbc1.set();
    var mbc2 = new cookie("fs_trialreading_on", "on", 30, "/", "", "");
    mbc2.set();
    var mbc3 = new cookie("fs_send2me_on", "on", 30, "/", "", "");
    mbc3.set();
    var mbc4 = new cookie("fs_pdf2jpeg_on", "on", 30, "/", "", "");
    mbc4.set();
    window.location.reload();
}

// 全てのモバイル拡張機能をOff
function mobile_all_off() {
    var mbc1 = new cookie("mobile_on", "", "", "/", "", "");
    mbc1.kill();
    var mbc2 = new cookie("fs_trialreading_on", "", "", "/", "", "");
    mbc2.kill();
    var mbc3 = new cookie("fs_send2me_on", "", "", "/", "", "");
    mbc3.kill();
    var mbc4 = new cookie("fs_pdf2jpeg_on", "", "", "/", "", "");
    mbc4.kill();
    window.location.reload();
}

// 画面切替用関数
function change_column(l_val, m_val, r_val) {
    if (document.getElementById("left-column")  ) document.getElementById("left-column"  ).style.display = l_val;
    if (document.getElementById("middle-column")) document.getElementById("middle-column").style.display = m_val;
    if (document.getElementById("right-column") ) document.getElementById("right-column" ).style.display = r_val;
}

// クッキーの設定と画面のリロード（クッキーの有効期限は30日）
function mobile_cookie_set_and_reload(name, value) {
    var mbc = new cookie("mobile_" + name, value, 30, "/", "", "");
    mbc.set();
    // PSPは以下の機能に対応していない
    var strUA = "";
    strUA = navigator.userAgent;
    // 表示するカラムの変更時のみの処理
    if ((name == "courseViewColumn") && (strUA.indexOf("PSP") == -1)) {
        if (value == "all") {
            if (document.getElementById("left-column") && document.getElementById("middle-column") && document.getElementById("right-column")) {
                change_column("", "", "");
                return;
            }
        } else if (document.getElementById(value + "-column")) {
            switch (value) {
              case "middle" :
                change_column("none", "", "none");
                return;
              case "left" :
                change_column("", "none", "none");
                return;
              case "right" :
                change_column("none", "none", "");
                return;
            }
        }
    }
    window.location.reload();
}
// クッキーの削除と画面のリロード
function mobile_cookie_kill_and_reload(name) {
    var mbc = new cookie("mobile_" + name, "", "", "/", "", "");
    mbc.kill();
    window.location.reload();
}
// (Shirai059): ログイン画面に”モバイルモードでログイン”のチェックボックスを追加する (2008/03/26)
// (Shirai059): ここから追加
// チェックボックスを調べてクッキー（mobile_on）の値を変更する
function checkbox_mobile_on() {
    var mbc = new cookie("mobile_on", "off", 30, "/", "", "");
    if (document.mobile_on.ch.checked == true) {
        mbc.changeVal("on");
    } else {
        mbc.changeVal("off");
    }
}
// (Shirai059): ここまで追加
// (Shirai061): コースのトピックスのセクションを展開／隠すを可能とする (2008/03/26)
// (Shirai061): ここから追加
// クッキーを変更してリロード（余計なオプションは削除する）
function courseSectionSwitch(value) {
    if ((value == 'Open') || (value == 'Close')) {
        if (document.SectionMode.Force.checked) value = 'All' + value;
            else                                value = 'Tmp' + value;
    }
    var mbc = new cookie("mobile_courseViewSection", value, 30, "/", "", "");
    mbc.set();
    // URLのゴミを取り除く．アンカーはクリアする．
    var SPorigin = location.href.split("#")[0];
    var SPopen  = SPorigin.split("&SecOpen");
    var SPclose = SPopen[0].split("&SecClose");
    location.replace(SPclose[0]);
}
// クッキーを変更し，オプションパラメータをセットしてリロード．
function courseSectionToggle(section, flag) {
    var mbc = new cookie("mobile_courseViewSection", "UserSel", 30, "/", "", "");
    mbc.set();
    // URLのゴミを取り除く，ただしアンカーは残す
    var hash     = location.href.split("#");
    var SPorigin = hash[0];
    if (hash[0] != location.href) hash = "#" + hash[1]; else hash = "";
    var SPopen  = SPorigin.split("&SecOpen");
    var SPclose = SPopen[0].split("&SecClose");
    // 新しいパラメータを付加する
    if (flag == true) location.replace(SPclose[0] + "&SecOpen=" + section + hash);
        else          location.replace(SPclose[0] + "&SecClose=" + section + hash);
}
// (Shirai061): ここまで追加
