<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package moodlecore
 * @subpackage backup-moodle2
 * @copyright 2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Define all the restore steps that will be used by the restore_wiki_activity_task
 */

/**
 * Structure step to restore one wiki activity
 */
class restore_wiki_activity_structure_step extends restore_activity_structure_step {

    protected function define_structure() {

        $paths = array();
        $userinfo = $this->get_setting_value('userinfo');

        $paths[] = new restore_path_element('wiki', '/activity/wiki');
        if ($userinfo) {
            $paths[] = new restore_path_element('wiki_subwiki', '/activity/wiki/subwikis/subwiki');
            $paths[] = new restore_path_element('wiki_page', '/activity/wiki/subwikis/subwiki/pages/page');
            $paths[] = new restore_path_element('wiki_version', '/activity/wiki/subwikis/subwiki/pages/page/versions/version');
            $paths[] = new restore_path_element('wiki_tag', '/activity/wiki/subwikis/subwiki/pages/page/tags/tag');
            $paths[] = new restore_path_element('wiki_synonym', '/activity/wiki/subwikis/subwiki/synonyms/synonym');
            $paths[] = new restore_path_element('wiki_link', '/activity/wiki/subwikis/subwiki/links/link');
        }

        // Return the paths wrapped into standard activity structure
        return $this->prepare_activity_structure($paths);
    }

    protected function process_wiki($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
        $data->course = $this->get_courseid();
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki() / oldid = $oldid : Start");

        $data->editbegin = $this->apply_date_offset($data->editbegin);
        $data->editend = $this->apply_date_offset($data->editend);
        $data->timemodified = $this->apply_date_offset($data->timemodified);

        // insert the wiki record
        $newitemid = $DB->insert_record('wiki', $data);
        // immediately after inserting "activity" record, call this
        $this->apply_activity_instance($newitemid);
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki() / newitemid = $newitemid : End");
    }

    protected function process_wiki_subwiki($data) {
        global $DB;


        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_subwiki() / oldid = $oldid : Start");
        $data->wikiid = $this->get_new_parentid('wiki');
        $data->groupid = $this->get_mappingid('group', $data->groupid);
        $data->userid = $this->get_mappingid('user', $data->userid);

        $newitemid = $DB->insert_record('wiki_subwikis', $data);
// (Debug)
//      $this->set_mapping('wiki_subwiki', $oldid, $newitemid);
        $this->set_mapping('wiki_subwiki', $oldid, $newitemid, true);
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki() / newitemid = $newitemid : End");
    }
    protected function process_wiki_page($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_page() / oldid = $oldid : Start");
        $data->subwikiid = $this->get_new_parentid('wiki_subwiki');
        $data->userid = $this->get_mappingid('user', $data->userid);
        $data->timemodified = $this->apply_date_offset($data->timemodified);
        $data->timecreated = $this->apply_date_offset($data->timecreated);
        $data->timerendered = $this->apply_date_offset($data->timerendered);

        $newitemid = $DB->insert_record('wiki_pages', $data);
        $this->set_mapping('wiki_page', $oldid, $newitemid, true); // There are files related to this
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_page() / newitemid = $newitemid : End");
    }
    protected function process_wiki_version($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_version() / oldid = $oldid : Start");
        $data->pageid = $this->get_new_parentid('wiki_page');
        $data->userid = $this->get_mappingid('user', $data->userid);
        $data->timecreated = $this->apply_date_offset($data->timecreated);

        $newitemid = $DB->insert_record('wiki_versions', $data);
        $this->set_mapping('wiki_version', $oldid, $newitemid);
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_version() / newitemid = $newitemid : End");
    }
    protected function process_wiki_synonym($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_synonym() / oldid = $oldid : Start");
        $data->subwikiid = $this->get_new_parentid('wiki_subwiki');
        $data->pageid = $this->get_mappingid('wiki_page', $data->pageid);

        $newitemid = $DB->insert_record('wiki_synonyms', $data);
        // No need to save this mapping as far as nothing depend on it
        // (child paths, file areas nor links decoder)
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_synonym() / newitemid = $newitemid : End");
    }
    protected function process_wiki_link($data) {
        global $DB;

        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_link() / oldid = $oldid : Start");
        $data->subwikiid = $this->get_new_parentid('wiki_subwiki');
        $data->frompageid = $this->get_mappingid('wiki_page', $data->frompageid);
        $data->topageid = $this->get_mappingid('wiki_page', $data->topageid);

        $newitemid = $DB->insert_record('wiki_links', $data);
        // No need to save this mapping as far as nothing depend on it
        // (child paths, file areas nor links decoder)
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_link() / newitemid = $newitemid : End");
    }

    protected function process_wiki_tag($data) {
        global $CFG, $DB;

        $data = (object)$data;
        $oldid = $data->id;
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_log() / oldid = $oldid : Start");

        if (empty($CFG->usetags)) { // tags disabled in server, nothing to process
            return;
        }

        $tag = $data->rawname;
        $itemid = $this->get_new_parentid('wiki_page');
        tag_set_add('wiki_pages', $itemid, $tag);
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_stepslib.php / restore_wiki_activity_structure_step / process_wiki_log() / itemid = $itemid : End");
    }

    protected function after_execute() {
        // Add wiki related files, no need to match by itemname (just internally handled context)
        $this->add_related_files('mod_wiki', 'intro', null);
// (Shirai)
        fs_log_restore("mod/wiki/backup/moodle2/restore_wiki_steplib.php / after_execute() / this->add_related_files('mod_wiki', 'attachments', *)");
// (Debug)
//      $this->add_related_files('mod_wiki', 'attachments', 'wiki_page');
        $this->add_related_files('mod_wiki', 'attachments', 'wiki_subwiki');
    }
}
