<?php
    //This script is used to configure and execute the restore proccess.

require_once('../config.php');
require_once($CFG->dirroot . '/backup/util/includes/restore_includes.php');

$contextid   = required_param('contextid', PARAM_INT);
$stage       = optional_param('stage', restore_ui::STAGE_CONFIRM, PARAM_INT);

list($context, $course, $cm) = get_context_info_array($contextid);

navigation_node::override_active_url(new moodle_url('/backup/restorefile.php', array('contextid'=>$contextid)));
$PAGE->set_url(new moodle_url('/backup/restore.php', array('contextid'=>$contextid)));
$PAGE->set_context($context);
$PAGE->set_pagelayout('standard');

require_login($course, null, $cm);
require_capability('moodle/restore:restorecourse', $context);
// (Shirai003): Backup/Restoreの際のログを記録してデバッグを助ける機能の追加 (2013/10/12)
// (Shirai003): ここから追加
fs_log_restore(fs_class2str(__FILE__, __LINE__), "[TOP] contextid = $contextid, Stage = $stage");
// (Shirai003): ここまで追加

if ($stage & restore_ui::STAGE_CONFIRM + restore_ui::STAGE_DESTINATION) {
    $restore = restore_ui::engage_independent_stage($stage, $contextid);
} else {
    $restoreid = optional_param('restore', false, PARAM_ALPHANUM);
    $rc = restore_ui::load_controller($restoreid);
    if (!$rc) {
        $restore = restore_ui::engage_independent_stage($stage/2, $contextid);
        if ($restore->process()) {
            $rc = new restore_controller($restore->get_filepath(), $restore->get_course_id(), backup::INTERACTIVE_YES,
                                backup::MODE_GENERAL, $USER->id, $restore->get_target());
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "[TOP] restoreid = $restoreid, filepath = ".$restore->get_filepath().", courseID = ".$restore->get_course_id().", userID = ".$USER->id.", restore target = ".$restore->get_target());
// (Shirai003): ここまで追加
        }
    }
    if ($rc) {
        // check if the format conversion must happen first
        if ($rc->get_status() == backup::STATUS_REQUIRE_CONV) {
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "The format conversion must happen first / \$rc->convert() : Start");
// (Shirai003): ここまで追加
            $rc->convert();
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "The format conversion must happen first / \$rc->convert() : End");
// (Shirai003): ここまで追加
        }

        $restore = new restore_ui($rc, array('contextid'=>$context->id));
    }
}

$outcome = $restore->process();
if (!$restore->is_independent()) {
    if ($restore->get_stage() == restore_ui::STAGE_PROCESS && !$restore->requires_substage()) {
        try {
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "\$restore->execute() : Start");
// (Shirai003): ここまで追加
            $restore->execute();
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "\$restore->execute() : End");
// (Shirai003): ここまで追加
        } catch(Exception $e) {
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "\$restore->cleanup() : Start");
// (Shirai003): ここまで追加
            $restore->cleanup();
// (Shirai003): ここから追加
            fs_log_restore(fs_class2str(__FILE__, __LINE__), "\$restore->cleanup() : End");
// (Shirai003): ここまで追加
            throw $e;
        }
    } else {
        $restore->save_controller();
    }
}
$heading = $course->fullname;

$PAGE->set_title($heading.': '.$restore->get_stage_name());
$PAGE->set_heading($heading);
$PAGE->navbar->add($restore->get_stage_name());

$renderer = $PAGE->get_renderer('core','backup');
echo $OUTPUT->header();
if (!$restore->is_independent() && $restore->enforce_changed_dependencies()) {
    debugging('Your settings have been altered due to unmet dependencies', DEBUG_DEVELOPER);
}
echo $renderer->progress_bar($restore->get_progress_bar());
echo $restore->display($renderer);
$restore->destroy();
unset($restore);
echo $OUTPUT->footer();
