/**
 * Request actions.
 *
 * @module     tool_dataprivacy/requestactions
 * @package    tool_dataprivacy
 * @copyright  2018 Jun Pataleta
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_dataprivacy/requestactions",["jquery","core/ajax","core/notification","core/str","core/modal_factory","core/modal_events","core/templates","tool_dataprivacy/data_request_modal","tool_dataprivacy/events"],(function($,Ajax,Notification,Str,ModalFactory,ModalEvents,Templates,ModalDataRequest,DataPrivacyEvents){var ACTIONS_APPROVE_REQUEST='[data-action="approve"]',ACTIONS_DENY_REQUEST='[data-action="deny"]',ACTIONS_VIEW_REQUEST='[data-action="view"]',ACTIONS_MARK_COMPLETE='[data-action="complete"]',ACTIONS_CONFIRM_BULK_ACTION='[id="confirm-bulk-action"]',ACTIONS_SELECT_ALL='[data-action="selectall"]',BULK_ACTIONS_APPROVE=1,BULK_ACTIONS_DENY=2,SELECTORS_SELECT_REQUEST=".selectrequests",RequestActions=function(){this.registerEvents()};function approveEventWsData(requestId){return{wsfunction:"tool_dataprivacy_approve_data_request",wsparams:{requestid:requestId}}}function denyEventWsData(requestId){return{wsfunction:"tool_dataprivacy_deny_data_request",wsparams:{requestid:requestId}}}function showConfirmation(action,wsdata){var keys=[];switch(action){case DataPrivacyEvents.approve:keys=[{key:"approverequest",component:"tool_dataprivacy"},{key:"confirmapproval",component:"tool_dataprivacy"}];break;case DataPrivacyEvents.bulkApprove:keys=[{key:"bulkapproverequests",component:"tool_dataprivacy"},{key:"confirmbulkapproval",component:"tool_dataprivacy"}];break;case DataPrivacyEvents.deny:keys=[{key:"denyrequest",component:"tool_dataprivacy"},{key:"confirmdenial",component:"tool_dataprivacy"}];break;case DataPrivacyEvents.bulkDeny:keys=[{key:"bulkdenyrequests",component:"tool_dataprivacy"},{key:"confirmbulkdenial",component:"tool_dataprivacy"}];break;case DataPrivacyEvents.complete:keys=[{key:"markcomplete",component:"tool_dataprivacy"},{key:"confirmcompletion",component:"tool_dataprivacy"}]}var modalTitle="";Str.get_strings(keys).then((function(langStrings){modalTitle=langStrings[0];var confirmMessage=langStrings[1];return ModalFactory.create({title:modalTitle,body:confirmMessage,type:ModalFactory.types.SAVE_CANCEL})})).then((function(modal){modal.setSaveButtonText(modalTitle),modal.getRoot().on(ModalEvents.save,(function(){handleSave(wsdata.wsfunction,wsdata.wsparams)})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})).catch(Notification.exception)}function handleSave(wsfunction,params){var request={methodname:wsfunction,args:params};Ajax.call([request])[0].done((function(data){data.result?window.location.reload():Notification.addNotification({message:data.warnings[0].message,type:"error"})})).fail(Notification.exception)}return RequestActions.prototype.registerEvents=function(){$(ACTIONS_VIEW_REQUEST).click((function(e){e.preventDefault();var requestId=$(this).data("requestid"),request={methodname:"tool_dataprivacy_get_data_request",args:{requestid:requestId}},promises=Ajax.call([request]);$.when(promises[0]).then((function(data){return data.result?data.result:(Notification.addNotification({message:data.warnings[0].message,type:"error"}),!1)})).then((function(data){var body=Templates.render("tool_dataprivacy/request_details",data),templateContext={approvedeny:data.approvedeny,canmarkcomplete:data.canmarkcomplete};return ModalFactory.create({title:data.typename,body:body,type:ModalDataRequest.TYPE,large:!0,templateContext:templateContext})})).then((function(modal){modal.getRoot().on(DataPrivacyEvents.approve,(function(){showConfirmation(DataPrivacyEvents.approve,approveEventWsData(requestId))})),modal.getRoot().on(DataPrivacyEvents.deny,(function(){showConfirmation(DataPrivacyEvents.deny,denyEventWsData(requestId))})),modal.getRoot().on(DataPrivacyEvents.complete,(function(){handleSave("tool_dataprivacy_mark_complete",{requestid:requestId})})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})).catch(Notification.exception)})),$(ACTIONS_APPROVE_REQUEST).click((function(e){e.preventDefault();var requestId=$(this).data("requestid");showConfirmation(DataPrivacyEvents.approve,approveEventWsData(requestId))})),$(ACTIONS_DENY_REQUEST).click((function(e){e.preventDefault();var requestId=$(this).data("requestid");showConfirmation(DataPrivacyEvents.deny,denyEventWsData(requestId))})),$(ACTIONS_MARK_COMPLETE).click((function(e){e.preventDefault();var requestId=$(this).data("requestid");showConfirmation(DataPrivacyEvents.complete,function(requestId){return{wsfunction:"tool_dataprivacy_mark_complete",wsparams:{requestid:requestId}}}(requestId))})),$(ACTIONS_CONFIRM_BULK_ACTION).click((function(){var requestIds=[],actionEvent="",wsdata={},bulkActionKeys=[{key:"selectbulkaction",component:"tool_dataprivacy"},{key:"selectdatarequests",component:"tool_dataprivacy"},{key:"ok"}],bulkaction=parseInt($("#bulk-action").val());if(bulkaction==BULK_ACTIONS_APPROVE||bulkaction==BULK_ACTIONS_DENY)if($(".selectrequests:checked").each((function(){requestIds.push($(this).val())})),requestIds.length<1)Str.get_strings(bulkActionKeys).done((function(langStrings){Notification.alert("",langStrings[1],langStrings[2])})).fail(Notification.exception);else{switch(bulkaction){case BULK_ACTIONS_APPROVE:actionEvent=DataPrivacyEvents.bulkApprove,wsdata=function(requestIds){return{wsfunction:"tool_dataprivacy_bulk_approve_data_requests",wsparams:{requestids:requestIds}}}(requestIds);break;case BULK_ACTIONS_DENY:actionEvent=DataPrivacyEvents.bulkDeny,wsdata=function(requestIds){return{wsfunction:"tool_dataprivacy_bulk_deny_data_requests",wsparams:{requestids:requestIds}}}(requestIds)}showConfirmation(actionEvent,wsdata)}else Str.get_strings(bulkActionKeys).done((function(langStrings){Notification.alert("",langStrings[0],langStrings[2])})).fail(Notification.exception)})),$(ACTIONS_SELECT_ALL).change((function(e){e.preventDefault();var selectAll=$(this).is(":checked");$(SELECTORS_SELECT_REQUEST).prop("checked",selectAll)}))},RequestActions}));

//# sourceMappingURL=requestactions.min.js.map