/**
 * Controls the content area of the notification area on the
 * notification page.
 *
 * @module     message_popup/notification_area_content_area
 * @class      notification_area_content_area
 * @package    message
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("message_popup/notification_area_content_area",["jquery","core/templates","core/notification","core/custom_interaction_events","message_popup/notification_repository","message_popup/notification_area_events"],(function($,Templates,DebugNotification,CustomEvents,NotificationRepo,NotificationAreaEvents){var SELECTORS={CONTAINER:'[data-region="notification-area"]',CONTENT:'[data-region="content"]',HEADER:'[data-region="header"]',FOOTER:'[data-region="footer"]',TOGGLE_MODE:'[data-action="toggle-mode"]'},TEMPLATES_HEADER="message_popup/notification_area_content_area_header",TEMPLATES_CONTENT="message_popup/notification_area_content_area_content",TEMPLATES_FOOTER="message_popup/notification_area_content_area_footer",ContentArea=function(root,userId){this.root=$(root),this.container=this.root.closest(SELECTORS.CONTAINER),this.userId=userId,this.header=this.root.find(SELECTORS.HEADER),this.content=this.root.find(SELECTORS.CONTENT),this.footer=this.root.find(SELECTORS.FOOTER),this.registerEventListeners()};return ContentArea.prototype.getRoot=function(){return this.root},ContentArea.prototype.getContainer=function(){return this.container},ContentArea.prototype.getUserId=function(){return this.userId},ContentArea.prototype.getHeader=function(){return this.header},ContentArea.prototype.getContent=function(){return this.content},ContentArea.prototype.getFooter=function(){return this.footer},ContentArea.prototype.show=function(){this.getContainer().addClass("show-content-area")},ContentArea.prototype.hide=function(){this.getContainer().removeClass("show-content-area")},ContentArea.prototype.setHeaderHTML=function(html){this.getHeader().empty().html(html)},ContentArea.prototype.setContentHTML=function(html){this.getContent().empty().html(html)},ContentArea.prototype.setFooterHTML=function(html){this.getFooter().empty().html(html)},ContentArea.prototype.showNotification=function(notification){var headerPromise=Templates.render(TEMPLATES_HEADER,notification).done(function(html){this.setHeaderHTML(html)}.bind(this)),contentPromise=Templates.render(TEMPLATES_CONTENT,notification).done(function(html){this.setContentHTML(html)}.bind(this)),footerPromise=Templates.render(TEMPLATES_FOOTER,notification).done(function(html){this.setFooterHTML(html)}.bind(this));return $.when(headerPromise,contentPromise,footerPromise).done(function(){this.show(),this.getContainer().trigger(NotificationAreaEvents.notificationShown,[notification])}.bind(this))},ContentArea.prototype.registerEventListeners=function(){CustomEvents.define(this.getRoot(),[CustomEvents.events.activate]),this.getRoot().on(CustomEvents.events.activate,SELECTORS.VIEW_TOGGLE,function(){this.hide()}.bind(this)),this.getContainer().on(NotificationAreaEvents.showNotification,function(e,notification){this.showNotification(notification)}.bind(this))},ContentArea}));

//# sourceMappingURL=notification_area_content_area.min.js.map