<?php

require_once('../../../config.php');
require_once($CFG->dirroot.'/lib/filelib.php');
require_once($CFG->libdir.'/fs_moodle/fs_status/lib.php');

if (!fs_isadmin()) error('あなたは管理者権限を持つユーザではありません．');

// 標準のmimeタイプ
$mimearrays = get_mimetypes_array();
printout_mime_table($mimearrays);

newline();
// fs_config_option.phpで追加したmimeタイプ
if (!isset($fsCFG->add_mimetypes)) {
    echo color_blue('追加のmimetypeは設定されていません．');
} else {
    echo '　現在，以下のmimetypeが設定されています．';
    newline();
    printout_mime_table($fsCFG->add_mimetypes);
}
newline();

output_CloseWindowButton(true);

function printout_mime_table($mimearrays)
{
    global $CFG, $fsCFG;
    $pixpath = $CFG->dirroot.'/pix/f';
    $wwwpath = $CFG->wwwroot.'/pix/f';
    $unknowniconpath    = $wwwpath.'/unknown.gif';
    $unknownicon32path  = '';
    if (fs_get_major_version() >= 2.0) $unknownicon32path = $wwwpath.'/unknown-32.png';

    echo '<table border="1" width="95%" align="center" cellpadding="5" cellspacing="0" style="bordercolor: #333333">';
    echo '<caption align="top">追加（あるいは上書き）設定されているmimeタイプ</caption>';
    echo '<tr bgcolor="#cccccc">';
    echo '<th>No.</th><th>拡張子</th><th>mimeタイプ</th><th>アイコンファイル名</th><th>アイコン画像</th</tr>';
    $no = 1;
    foreach ($mimearrays as $key => $mime) {
        echo '<tr>';
        // No.
        echo '<td align="center">'.$no++.'</td>';
        // 拡張子
        echo '<td align="center">'.$key.'</td>';
        // mimeタイプ
        echo '<td align="center">'.$mime['type'].'</td>';
        // iconパス
        echo '<td align="center">'.$mime['icon'].'</td>';
        // アイコン画像
        echo '<td align="center">';
        echo '<img align="middle" src="';
        // 16×16アイコン
        $icon = $mime['icon'];
        $iconpath    = $pixpath.'/'.$icon;
        $wwwiconpath = $wwwpath.'/'.$icon;
        if (fs_get_major_version() >= 2.0) {
            $iconpath    .= '.gif';
            $wwwiconpath .= '.gif';
        }
        if (file_exists($iconpath)) echo $wwwiconpath; else echo $unknowniconpath;
        echo '">';
        if (fs_get_major_version() >= 2.0) {
            echo '&nbsp;';
            // 32×32アイコン
            echo '<img align="middle" src="';
            $iconpath    = $pixpath.'/'.$icon.'-32.png';
            $wwwiconpath = $wwwpath.'/'.$icon.'-32.png';
            if (file_exists($iconpath)) {
                // PNG32
                echo $wwwiconpath;
            } else {
                $iconpath    = $pixpath.'/'.$icon.'-32.gif';
                $wwwiconpath = $wwwpath.'/'.$icon.'-32.gif';
                if (file_exists($iconpath)) {
                    // GIF32
                    echo $wwwiconpath;
                } else {
                    echo $unknownicon32path;
                }
            }
            echo '">';
        }
        echo '</tr>';
    }
    echo '</table>';
}

?>