################################################################################
# <p>
#   WikiեޥåȤʸѡ񼰤бեå᥽åɤθƤӽФԤޤ
#   Wiki::ParserѾΥեå᥽åɤ򥪡С饤ɤ뤳ȤǤդΥեޥåȤؤѴǽǤ
# </p>
################################################################################
package Wiki::Parser;
use strict;
use Wiki::Keyword;
use Wiki::InterWiki;

$Wiki::Parser::keyword   = undef;
$Wiki::Parser::interwiki = undef;

#===============================================================================
# <p>
# 󥹥ȥ饯
# </p>
# <pre>
# my $parser = Wiki::HTMLParser-&gt;new($wiki);
# </pre>
#===============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	
	my $self = {};
	$self->{wiki} = $wiki;
	
	# KeywordInterWikiϹ®Τ⥸塼ѿȤݻ
	#ʤmod_perl+FarmξϥʤΤnew
	if(exists $ENV{MOD_PERL}){
		$self->{interwiki} = Wiki::InterWiki->new($wiki);
		$self->{keyword}   = Wiki::Keyword->new($wiki,$self->{interwiki});
	} else {
		unless(defined($Wiki::Parser::keyword)){
			$Wiki::Parser::interwiki = Wiki::InterWiki->new($wiki);
			$Wiki::Parser::keyword   = Wiki::Keyword->new($wiki,$Wiki::Parser::interwiki);
		}
		$self->{interwiki} = $Wiki::Parser::interwiki;
		$self->{keyword}   = $Wiki::Parser::keyword;
	}
	
	$self->{dl_flag} = 0;
	$self->{dt} = "";
	$self->{dd} = "";
	
	return bless $self,$class;
}

#===============================================================================
# <p>
# ѡ򳫻Ϥޤ
# </p>
# <pre>
# $parser-&gt;parse($source);
# </pre>
#===============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	
	$self->start_parse;
	$source =~ s/\r//g;
	
	my @lines = split(/\n/,$source);
	
	foreach my $line (@lines){
		chomp $line;
		
		# ʣԤ
		$self->multi_explanation($line);
		
		my $word1 = substr($line,0,1);
		my $word2 = substr($line,0,2);
		my $word3 = substr($line,0,3);
		
		# 
		if($line eq ""){
			$self->l_paragraph();
			next;
		}
		
		# ѥ饰եץ饰
		if($line =~ /^{{((.|\s)+?)}}$/){
			my $plugin = $self->{wiki}->parse_inline_plugin($1);
			my $info   = $self->{wiki}->get_plugin_info($plugin->{command});
			if($info->{TYPE} eq "paragraph"){
				$self->l_plugin($plugin);
			} else {
				my @obj = $self->parse_line($line);
				$self->l_text(\@obj);
			}
			next;
		}
		
		# PRE
		if($word1 eq " " || $word1 eq "\t"){
			$self->l_verbatim($line);
			
		# Ф
		} elsif($word3 eq "!!!"){
			my @obj = $self->parse_line(substr($line,3));
			$self->l_headline(1,\@obj);
			
		} elsif($word2 eq "!!"){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_headline(2,\@obj);
			
		} elsif($word1 eq "!"){
			my @obj = $self->parse_line(substr($line,1));
			$self->l_headline(3,\@obj);

		# 
		} elsif($word3 eq "***"){
			my @obj = $self->parse_line(substr($line,3));
			$self->l_list(3,\@obj);
			
		} elsif($word2 eq "**"){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_list(2,\@obj);
			
		} elsif($word1 eq "*"){
			my @obj = $self->parse_line(substr($line,1));
			$self->l_list(1,\@obj);
			
		# ֹդ
		} elsif($word3 eq "+++"){
			my @obj = $self->parse_line(substr($line,3));
			$self->l_numlist(3,\@obj);
			
		} elsif($word2 eq "++"){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_numlist(2,\@obj);
			
		} elsif($word1 eq "+"){
			my @obj = $self->parse_line(substr($line,1));
			$self->l_numlist(1,\@obj);
			
		# ʿ
		} elsif($line eq "----"){
			$self->l_line();
		
		# 
		} elsif($word2 eq '""'){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_quotation(\@obj);
			
		# 
		} elsif(index($line,":")==0 && index($line,":",1)!=-1){
			if(index($line,":::")==0){
				$self->{dd} .= substr($line,3);
				next;
			}
			if(index($line,"::")==0){
				if($self->{dt} ne "" || $self->{dd} ne ""){
					$self->multi_explanation;
				}
				$self->{dt} = substr($line,2);
				$self->{dl_flag} = 1;
				next;
			}
			my $dt = substr($line,1,index($line,":",1)-1);
			my $dd = substr($line,index($line,":",1)+1);
			my @obj1 = $self->parse_line($dt);
			my @obj2 = $self->parse_line($dd);
			$self->l_explanation(\@obj1,\@obj2);
			
		# ơ֥
		} elsif($word1 eq ","){
			if($line =~ /,$/){
				$line .= " ";
			}
			my @spl = map {/^"(.*)"$/ ? scalar($_ = $1, s/\"\"/\"/g, $_) : $_}
			              ($line =~ /,\s*(\"[^\"]*(?:\"\"[^\"]*)*\"|[^,]*)/g);
			my @array;
			foreach my $value (@spl){
				my @cell = $self->parse_line($value);
				push @array,\@cell;
			}
			$self->l_table(\@array);
			
		# 
		} elsif($word2 eq "//"){
		
		# ʤ
		} else {
			my @obj = $self->parse_line($line);
			$self->l_text(\@obj);
		}
	}
	
	# ʣԤ
	$self->multi_explanation;
	
	$self->end_parse;
}

#===============================================================================
# <p>
# ʣԤʸޤ
# </p>
#===============================================================================
sub multi_explanation {
	my $self = shift;
	my $line = shift;
	if($self->{dl_flag}==1 && (index($line,":")!=0 || !defined($line))){
		my @obj1 = $self->parse_line($self->{dt});
		my @obj2 = $self->parse_line($self->{dd});
		$self->l_explanation(\@obj1,\@obj2);
		$self->{dl_flag} = 0;
		$self->{dt} = "";
		$self->{dd} = "";
	}
}

#===============================================================================
# <p>
# ʬѡޤparse᥽åɤ椫ɬפ˱ƸƤӽФޤ
# </p>
#===============================================================================
sub parse_line {
	my $self   = shift;
	my $source = shift;
	my @array  = ();
		
	# ץ饰
	if($source =~ /{{((.|\s)+?)}}/){
		my $pre  = $`;
		my $post = $';
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		my $plugin = $self->{wiki}->parse_inline_plugin($1);
		my $info   = $self->{wiki}->get_plugin_info($plugin->{command});
		if($info->{TYPE} eq "inline"){
			push @array,$self->plugin($plugin);
		} else {
			push @array,$self->text("{{$1}}");
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# Ǥä
	} elsif($source =~ /(==)(.+?)(==)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->denialline($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# ܡ
	} elsif($source =~ /(''')(.+?)(''')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->bold($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# å
	} elsif($source =~ /('')(.+?)('')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->italic($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# InterWikiName
	} elsif($self->{interwiki}->exists_interwiki($source)){
		my $pre   = $self->{interwiki}->{g_pre};
		my $post  = $self->{interwiki}->{g_post};
		my $label = $self->{interwiki}->{g_label};
		my $url   = $self->{interwiki}->{g_url};
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->url_anchor($url,$label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# ڡ̾
	} elsif($source =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $page  = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page,$label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }

	# URL̾
	} elsif($source =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
	    ||  $source =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		if(index($url,'"') >= 0 || index($url,'><') >= 0 || index($url, 'javascript:') >= 0){
			push @array,"<span class=\"error\">ʥ󥯤Ǥ</span>";
		} else {
			push @array,$self->url_anchor($url,$label);
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# URL
	} elsif($source =~ /(http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $url = $&;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		if(index($url,'"') >= 0 || index($url,'><') >= 0 || index($url, 'javascript:') >= 0){
			push @array,"<span class=\"error\">ʥ󥯤Ǥ</span>";
		} else {
			push @array,$self->url_anchor($url);
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# ڡ
	} elsif($source =~ /\[\[([^\|]+?)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $page = $1;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page);
		if($post ne ""){ push(@array,$self->parse_line($post)); }

	# ǤդURL
	} elsif($source =~ /\[([^\[]+?)\|(.+?)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		if(index($url,'"') >= 0 || index($url,'><') >= 0 || index($url, 'javascript:') >= 0){
			push @array,"<span class=\"error\">ʥ󥯤Ǥ</span>";
		} else {
			# URI
			my $wiki = $self->{wiki};
			my $uri = $wiki->config('server_host');
			if($uri eq ""){
				$uri = $wiki->get_CGI()->url(-path_info => 1);
			} else {
				$uri = $uri . $wiki->get_CGI->url(-absolute => 1) . $wiki->get_CGI()->path_info();
			}
			push @array,$self->url_anchor($uri."/../".$url, $label);
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# 
	} elsif($self->{keyword}->exists_keyword($source)){
		my $pre   = $self->{keyword}->{g_pre};
		my $post  = $self->{keyword}->{g_post};
		my $label = $self->{keyword}->{g_label};
		my $url   = $self->{keyword}->{g_url};
		my $page  = $self->{keyword}->{g_page};
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		if(defined($url) && $url ne ""){
			push @array,$self->url_anchor($url,$label);
		} else {
			push @array,$self->wiki_anchor($page,$label);
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# WikiName
	} elsif($self->{wiki}->config('wikiname')==1 && $source =~ /[A-Z]+?[a-z]+?([A-Z]+?[a-z]+)+/){
		my $pre   = $`;
		my $post  = $';
		my $page  = $&;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# 
	} elsif($source =~ /(__)(.+?)(__)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->underline($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# 顼å
	} elsif($source =~ /(<<)(.+?)(>>)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->error($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	} else {
		push @array,$self->text($source);
	}
	
	return @array;
}

#===============================================================================
# <p>
# ѡ򳫻˸ƤӽФޤ
# ֥饹ɬפʽϥС饤ɤƤ
# </p>
#===============================================================================
sub start_parse {}

#===============================================================================
# <p>
# ѡλ˸ƤӽФޤ
# ֥饹ɬפʽϥС饤ɤƤ
# </p>
#===============================================================================
sub end_parse {}

#===============================================================================
# <p>
# URL󥫤˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub url_anchor {}

#===============================================================================
# <p>
# ڡ̾󥫤˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub wiki_anchor {}

#===============================================================================
# <p>
# å˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub italic {}

#===============================================================================
# <p>
# ܡɤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub bold {}

#===============================================================================
# <p>
# ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub underline {}

#===============================================================================
# <p>
# Ǥä˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub denialline {}

#===============================================================================
# <p>
# ץ饰˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub plugin {}

#===============================================================================
# <p>
# ƥȤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub text{}

#===============================================================================
# <p>
# ܤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_list {}

#===============================================================================
# <p>
# ֹդܤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_numlist {}

#===============================================================================
# <p>
# Ф˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_headline {}

#===============================================================================
# <p>
# PRE˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_verbatim {}

#===============================================================================
# <p>
# ʿ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_line {}

#===============================================================================
# <p>
# äˤʤˤʤԤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_text {}

#===============================================================================
# <p>
# ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_explanation {}

#===============================================================================
# <p>
# Ѥ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_quotation {}

#===============================================================================
# <p>
# ѥ饰դζڤ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_paragraph {}

#===============================================================================
# <p>
# ơ֥˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_table {}

#===============================================================================
# <p>
# ѥ饰եץ饰˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_plugin {}

#===============================================================================
# <p>
# ˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub l_image {}

#===============================================================================
# <p>
# 顼å˥ޥå˸ƤӽФޤ
# ֥饹ˤƽޤ
# </p>
#===============================================================================
sub error {}

1;
