###############################################################################
#
# Hikiν񼰤򥵥ݡȤեޥåȥץ饰
#
###############################################################################
package plugin::format::HikiFormat;
use strict;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# FSWikiν񼰤Ѵޤ
#==============================================================================
sub convert_to_fswiki {
	my $self   = shift;
	my $source = shift;
	
	my @lines  = split(/\n/,$source);
	my $buf    = "";
	
	foreach my $line (@lines){
		if($line =~ /^!!!/){
			$buf .= "!".$self->_convert_to_fswiki_line(substr($line,3))."\n";
		} elsif($line =~ /^!!/){
			$buf .= "!!".$self->_convert_to_fswiki_line(substr($line,2))."\n";
		} elsif($line =~ /^!/){
			$buf .= "!!!".$self->_convert_to_fswiki_line(substr($line,1))."\n";
		} elsif($line =~ /^###/){
			$buf .= "+++".$self->_convert_to_fswiki_line(substr($line,3))."\n";
		} elsif($line =~ /^##/){
			$buf .= "++".$self->_convert_to_fswiki_line(substr($line,2))."\n";
		} elsif($line =~ /^#/){
			$buf .= "+".$self->_convert_to_fswiki_line(substr($line,1))."\n";
		} elsif($line =~ /^\|\|/){
			my @words = split(/\|\|/,$line);
			foreach my $word (@words){
				if($word ne ""){
					$buf .= ",".$self->_convert_to_fswiki_line($word);
				}
			}
			$buf .= "\n";
		} elsif($line =~ /^[ \t]/){
			$buf .= $line."\n";
		} else {
			$buf .= $self->_convert_to_fswiki_line($line)."\n";
		}
	}
	return $buf;
}

#==============================================================================
# ʬΥ饤񼰤HikiFSWikiեޥåȤѴޤ
#==============================================================================
sub _convert_to_fswiki_line {
	my $self = shift;
	my $line = shift;
	my $buf  = "";
	
	# ̾
	if($line =~ /\[\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]\]/
	    ||  $line =~ /\[\[([^\[]+?)\|(file:[^\[\]]*)\]\]/
	    ||  $line =~ /\[\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ $buf .= $self->_convert_to_fswiki_line($pre); }
		$buf .= "[$label|$url]";
		if($post ne ""){ $buf .= $self->_convert_to_fswiki_line($post); }
		
	} else {
		$buf .= $line;
	}
	return $buf;
}

#==============================================================================
# FSWikiν񼰤Ѵޤ
#==============================================================================
sub convert_from_fswiki {
	my $self   = shift;
	my $source = shift;
	my @lines  = split(/\n/,$source);
	my $buf    = "";
	
	foreach my $line (@lines){
		if($line =~ /^!!!/){
			$buf .= "!".$self->_convert_from_fswiki_line(substr($line,3))."\n";
		} elsif($line =~ /^!!/){
			$buf .= "!!".$self->_convert_from_fswiki_line(substr($line,2))."\n";
		} elsif($line =~ /^!/){
			$buf .= "!!!".$self->_convert_from_fswiki_line(substr($line,1))."\n";
		} elsif($line =~ /^\+\+\+/){
			$buf .= "###".$self->_convert_from_fswiki_line(substr($line,3))."\n";
		} elsif($line =~ /^\+\+/){
			$buf .= "##".$self->_convert_from_fswiki_line(substr($line,2))."\n";
		} elsif($line =~ /^\+/){
			$buf .= "#".$self->_convert_from_fswiki_line(substr($line,1))."\n";
		} elsif($line =~ /^,/){
			my @words = map {/^"(.*)"$/ ? scalar($_ = $1, s/""/"/g, $_) : $_}
			                ($line =~ /,\s*("[^"]*(?:""[^"]*)*"|[^,]*)/g);
			foreach my $word (@words){
				if($word ne ""){
					$buf .= "||".$self->_convert_from_fswiki_line($word);
				}
			}
			$buf .= "||\n";
		} elsif($line =~ /^[ \t]/){
			$buf .= $line."\n";
		} else {
			$buf .= $self->_convert_from_fswiki_line($line)."\n";
		}
	}
	return $buf;
}

#==============================================================================
# ʬΥ饤񼰤FSWikiHikiեޥåȤѴޤ
#==============================================================================
sub _convert_from_fswiki_line {
	my $self = shift;
	my $line = shift;
	my $buf  = "";
	
	# ̾
	if($line =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/
	    ||  $line =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
	    ||  $line =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?\(\)!\$&=:;\*#\@']*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ $buf .= $self->_convert_from_fswiki_line($pre); }
		$buf .= "[[$label|$url]]";
		if($post ne ""){ $buf .= $self->_convert_from_fswiki_line($post); }
		
	# ڡ̾
	} elsif($line =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $page  = $2;
		if($pre ne ""){ $buf .= $self->_convert_from_fswiki_line($pre); }
		$buf .= "[[$label|$page]]";
		if($post ne ""){ $buf .= $self->_convert_from_fswiki_line($post); }
		
	} else {
		$buf .= $line;
	}
	return $buf;
}

1;
