/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.run.TestCommander;
import com.ftinc.si.assist.run.TestMain;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.FakeMethodRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.Record;
import com.ftinc.si.assist.test.TestCaseRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.EnvironmentData;
import com.ftinc.si.assist.test.gui.JSONEditor;
import com.ftinc.si.assist.test.gui.MethodEditor;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class TestCaseBrowser
extends JFrame {
    private static String copyright = "Copy Right Toyoaki Furusawa, 2014-.";
    private JTextField beginText;
    private JTextField endText;
    private JTextField caseName;
    private JTextArea txtDesc;
    private JTextArea txtStatus;
    private JList<String> testcase_list;
    private JMenuItem mntmCreateTable;
    private JMenuItem mntmAll;
    private ArrayList<TestCaseRecord> m_caselist = null;
    private TestCaseRecord m_curcase;
    private int m_begin;
    private int m_end;
    private boolean checkedBegin;
    private boolean checkedEnd;
    private String m_title;
    private EnvironmentData m_env;
    private boolean db_created = false;
    private DefaultListModel<String> testcase_model;
    public static JFrame s_curFrame = null;

    public TestCaseBrowser() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TestCaseBrowser.this.closing();
            }
        });
        if (s_curFrame == null) {
            s_curFrame = this;
        }
        this.setResizable(false);
        this.m_title = Messages.getString("TestCaseBrowser.0");
        this.setTitle(this.m_title);
        Tool.init(true);
        this.m_caselist = new ArrayList();
        this.testcase_model = new DefaultListModel();
        this.txtDesc = new JTextArea();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu(Messages.getString("TestCaseBrowser.1"));
        menuBar.add(mnFile);
        JMenuItem mntmExit = new JMenuItem(Messages.getString("TestCaseBrowser.2"));
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseBrowser.this.closing();
                TestCaseBrowser.this.setVisible(false);
            }
        });
        this.mntmCreateTable = new JMenuItem(Messages.getString("TestCaseBrowser.55"));
        this.mntmCreateTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestCaseBrowser.this.tryCreateTable();
            }
        });
        JMenuItem mntmExportEnviroment = new JMenuItem(Messages.getString("TestCaseBrowser.57"));
        mntmExportEnviroment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser t_fc = new JFileChooser(Tool.getPrevPath());
                t_fc.setFileSelectionMode(1);
                if (t_fc.showOpenDialog(null) == 0) {
                    File t_file = t_fc.getSelectedFile();
                    String t_path = t_file.getAbsolutePath();
                    Tool.setPrevPath(t_file.getAbsolutePath());
                    t_path = String.valueOf(t_path) + "\\tclenv.json";
                    ((TestCaseBrowser)TestCaseBrowser.this).m_env.prevPath = Tool.getPrevPath();
                    String envJSON = Tool.getJSONfromObject(TestCaseBrowser.this.m_env);
                    File t_env = new File(t_path);
                    if (!t_env.exists()) {
                        try {
                            t_env.createNewFile();
                            FileWriter t_w = new FileWriter(t_env);
                            t_w.write(envJSON);
                            t_w.close();
                        }
                        catch (IOException e1) {
                            Tool.alertMSG(null, e1.getMessage());
                        }
                    }
                }
            }
        });
        mnFile.add(mntmExportEnviroment);
        mnFile.add(this.mntmCreateTable);
        mnFile.add(mntmExit);
        JMenu mnExecute = new JMenu(Messages.getString("TestCaseBrowser.22"));
        menuBar.add(mnExecute);
        this.mntmAll = new JMenuItem(Messages.getString("TestCaseBrowser.23"));
        this.mntmAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestCaseBrowser.this.execTestCase(null, false);
                    }
                });
            }
        });
        mnExecute.add(this.mntmAll);
        JMenuItem mntmTestcase1 = new JMenuItem(Messages.getString("TestCaseBrowser.4"));
        mntmTestcase1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = TestCaseBrowser.this.testcase_list.getSelectedIndex();
                if (i >= 0 && TestCaseBrowser.this.m_caselist.get(i) != null) {
                    TestCaseBrowser.this.m_curcase = (TestCaseRecord)TestCaseBrowser.this.m_caselist.get(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TestCaseBrowser.this.execTestCase(TestCaseBrowser.this.m_curcase, true);
                        }
                    });
                } else {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.25"));
                }
            }
        });
        mnExecute.add(mntmTestcase1);
        JMenuItem mntmTestcase2 = new JMenuItem(Messages.getString("TestCaseBrowser.13"));
        mntmTestcase2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = TestCaseBrowser.this.testcase_list.getSelectedIndex();
                if (i >= 0 && TestCaseBrowser.this.m_caselist.get(i) != null) {
                    TestCaseBrowser.this.m_curcase = (TestCaseRecord)TestCaseBrowser.this.m_caselist.get(i);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TestCaseBrowser.this.execTestCase(TestCaseBrowser.this.m_curcase, false);
                        }
                    });
                } else {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.25"));
                }
            }
        });
        mnExecute.add(mntmTestcase2);
        JMenu mnOption = new JMenu(Messages.getString("TestCaseBrowser.26"));
        menuBar.add(mnOption);
        JMenuItem mntmDatabase = new JMenuItem(Messages.getString("TestCaseBrowser.27"));
        mntmDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnvironmentData t_dat = Tool.openEnvironmentDialog(s_curFrame, TestCaseBrowser.this.m_env);
                if (t_dat != null) {
                    if (t_dat.hiddenMode != ((TestCaseBrowser)TestCaseBrowser.this).m_env.hiddenMode) {
                        if (t_dat.hiddenMode) {
                            TestCaseBrowser.this.testcase_list.removeAll();
                            int i = 0;
                            while (TestCaseBrowser.this.m_caselist.size() > i) {
                                if (((TestCaseRecord)((TestCaseBrowser)TestCaseBrowser.this).m_caselist.get((int)i)).enable) {
                                    TestCaseBrowser.this.testcase_list.add(((TestCaseRecord)((TestCaseBrowser)TestCaseBrowser.this).m_caselist.get((int)i)).name, null);
                                }
                                ++i;
                            }
                        } else {
                            TestCaseBrowser.this.testcase_list.removeAll();
                            int i = 0;
                            while (TestCaseBrowser.this.m_caselist.size() > i) {
                                TestCaseBrowser.this.testcase_list.add(((TestCaseRecord)((TestCaseBrowser)TestCaseBrowser.this).m_caselist.get((int)i)).name, null);
                                ++i;
                            }
                        }
                    } else if (!Tool.version.equals(t_dat.version)) {
                        Tool.version = t_dat.version;
                        int i = TestCaseBrowser.this.m_caselist.size() - 1;
                        while (i >= 0) {
                            TestCaseBrowser.this.m_caselist.remove(i);
                            --i;
                        }
                        TestCaseBrowser.this.testcase_model.removeAllElements();
                    }
                    TestCaseBrowser.this.m_env = t_dat;
                    TestCaseBrowser.this.connectDB();
                }
                if (!TestCaseBrowser.this.db_created && Tool._db().isReady()) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.65"));
                    TestCaseBrowser.this.mntmCreateTable.setEnabled(false);
                    TestCaseBrowser.this.db_created = true;
                }
            }
        });
        mnOption.add(mntmDatabase);
        JMenuItem mntmRefleshFakeclass = new JMenuItem(Messages.getString("TestCaseBrowser.28"));
        mntmRefleshFakeclass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Tool.refleshFakes()) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.44"));
                }
            }
        });
        JMenuItem mntmEditFakemethod = new JMenuItem(Messages.getString("TestCaseBrowser.29"));
        mntmEditFakemethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MethodEditor.s_owner = null;
                MethodEditor t_dlg = new MethodEditor(null, null, null, null, null);
                t_dlg.setVisible(true);
                FakeMethodRecord t_rec = t_dlg.getFakeMethodRecord();
                if (t_dlg.is_OK) {
                    if (t_rec != null) {
                        if (Tool.existClass(t_rec.className)) {
                            try {
                                Tool._db().updateRecordBySQL(t_rec.getUpdateSQL(), true);
                                Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.52")) + t_rec.className + "#" + t_rec.methodName);
                            }
                            catch (SQLException e1) {
                                Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.37")) + e1.getMessage());
                            }
                        }
                    } else {
                        Tool.alertMSG(null, Messages.getString("TestCaseBrowser.18"));
                    }
                }
            }
        });
        JMenuItem mntmEditJson = new JMenuItem(Messages.getString("TestCaseBrowser.30"));
        mntmEditJson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSONEditor t_ed = new JSONEditor(null, null, null, null);
                t_ed.setVisible(true);
            }
        });
        mnOption.add(mntmEditJson);
        mnOption.add(mntmEditFakemethod);
        mnOption.add(mntmRefleshFakeclass);
        this.getContentPane().setLayout(null);
        if (Tool.group_code != null && Tool.group_code.length() > 0 && (Tool.version == null || Tool.version.length() == 0)) {
            mntmEditJson.setEnabled(false);
            mntmEditFakemethod.setEnabled(false);
        } else {
            mntmEditJson.setEnabled(true);
            mntmEditFakemethod.setEnabled(true);
        }
        JLabel lblUsecase = new JLabel(Messages.getString("TestCaseBrowser.31"));
        lblUsecase.setBounds(12, 10, 50, 13);
        this.getContentPane().add(lblUsecase);
        this.txtDesc.setBounds(171, 66, 601, 167);
        this.getContentPane().add(this.txtDesc);
        JLabel lblDescription = new JLabel(Messages.getString("TestCaseBrowser.32"));
        lblDescription.setBounds(171, 48, 93, 13);
        this.getContentPane().add(lblDescription);
        JLabel lblTestcommands = new JLabel(Messages.getString("TestCaseBrowser.33"));
        lblTestcommands.setBounds(171, 241, 91, 13);
        this.getContentPane().add(lblTestcommands);
        this.beginText = new JTextField();
        this.beginText.setText("0");
        this.beginText.setBounds(239, 7, 96, 19);
        this.getContentPane().add(this.beginText);
        this.beginText.setColumns(10);
        this.beginText.setHorizontalAlignment(4);
        this.beginText.enableInputMethods(false);
        this.beginText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TestCaseBrowser.this.checkedBegin = Tool.checkInteger(TestCaseBrowser.this.beginText.getText(), e, 200, 0);
                if (!TestCaseBrowser.this.checkedBegin) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!TestCaseBrowser.this.checkedBegin) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!TestCaseBrowser.this.checkedBegin) {
                    e.consume();
                }
            }
        });
        JLabel lblBeginid = new JLabel(Messages.getString("TestCaseBrowser.35"));
        lblBeginid.setBounds(186, 10, 50, 13);
        this.getContentPane().add(lblBeginid);
        JLabel lblEndid = new JLabel(Messages.getString("TestCaseBrowser.36"));
        lblEndid.setToolTipText("");
        lblEndid.setBounds(359, 10, 50, 13);
        this.getContentPane().add(lblEndid);
        this.endText = new JTextField();
        this.endText.setText("0");
        this.endText.setBounds(398, 7, 96, 19);
        this.getContentPane().add(this.endText);
        this.endText.setColumns(10);
        this.endText.setHorizontalAlignment(4);
        this.endText.enableInputMethods(false);
        this.endText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TestCaseBrowser.this.checkedEnd = Tool.checkInteger(TestCaseBrowser.this.endText.getText(), e, 200, 0);
                if (!TestCaseBrowser.this.checkedEnd) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!TestCaseBrowser.this.checkedEnd) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!TestCaseBrowser.this.checkedEnd) {
                    e.consume();
                }
            }
        });
        JButton btnSearch = new JButton(Messages.getString("TestCaseBrowser.39"));
        btnSearch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TestCaseBrowser.this.db_created) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.40"));
                    return;
                }
                if (Tool.group_code != null && Tool.group_code.length() > 0 && (Tool.version == null || Tool.version.length() == 0)) {
                    Tool.alertMSG(null, Messages.getString("TestMain.16"));
                    return;
                }
                if (TestCaseBrowser.this.caseName.getText() == null) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.41"));
                    return;
                }
                if (TestCaseBrowser.this.caseName.getText().matches("^.*?['\"\\s=].*$")) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.67"));
                }
                TestCaseBrowser.this.m_begin = -1;
                if (!TestCaseBrowser.this.beginText.getText().equals("")) {
                    try {
                        TestCaseBrowser.this.m_begin = new Integer(TestCaseBrowser.this.beginText.getText());
                    }
                    catch (NumberFormatException e2) {
                        TestCaseBrowser.this.m_begin = 0;
                    }
                }
                TestCaseBrowser.this.m_end = -1;
                if (!TestCaseBrowser.this.endText.getText().equals("")) {
                    try {
                        TestCaseBrowser.this.m_end = new Integer(TestCaseBrowser.this.endText.getText());
                    }
                    catch (NumberFormatException e2) {
                        TestCaseBrowser.this.m_end = 0;
                    }
                }
                TestCaseBrowser.this.m_caselist.clear();
                TestCaseBrowser.this.testcase_model.removeAllElements();
                TestCaseBrowser.this.m_caselist = Tool._db().getTestCaseList(TestCaseBrowser.this.caseName.getText(), TestCaseBrowser.this.m_begin, TestCaseBrowser.this.m_end, "", Tool.version);
                if (TestCaseBrowser.this.m_caselist.size() > 50) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.50"));
                } else if (TestCaseBrowser.this.m_caselist.size() == 0) {
                    Tool.alertMSG(null, Messages.getString("TestCaseBrowser.42"));
                }
                int i = 0;
                while (TestCaseBrowser.this.m_caselist.size() > i && 51 > i) {
                    TestCaseRecord t_case = (TestCaseRecord)TestCaseBrowser.this.m_caselist.get(i);
                    TestCaseBrowser.this.testcase_model.addElement(t_case.name);
                    ++i;
                }
            }
        });
        btnSearch.setBounds(511, 6, 91, 21);
        this.getContentPane().add(btnSearch);
        JSeparator separator = new JSeparator();
        separator.setBounds(12, 33, 770, 2);
        this.getContentPane().add(separator);
        this.caseName = new JTextField();
        this.caseName.setText("%");
        this.caseName.setBounds(74, 7, 96, 19);
        this.getContentPane().add(this.caseName);
        this.caseName.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(12, 47, 147, 373);
        this.getContentPane().add(scrollPane);
        this.testcase_list = new JList<String>(this.testcase_model);
        scrollPane.setViewportView(this.testcase_list);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(171, 264, 611, 156);
        this.getContentPane().add(scrollPane_1);
        this.txtStatus = new JTextArea();
        scrollPane_1.setViewportView(this.txtStatus);
        this.txtStatus.setEditable(false);
        this.testcase_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ListUI t_ui = TestCaseBrowser.this.testcase_list.getUI();
                    int j = t_ui.locationToIndex(TestCaseBrowser.this.testcase_list, e.getPoint());
                    if (j >= 0) {
                        String label = (String)TestCaseBrowser.this.testcase_model.get(j);
                        if (label != null) {
                            TestCaseBrowser.this.goTestCasePopUp(e, label);
                        }
                    } else {
                        TestCaseBrowser.this.goTestCasePopUp(e, null);
                    }
                } else if (e.getClickCount() == 2) {
                    String label;
                    ListUI t_ui = TestCaseBrowser.this.testcase_list.getUI();
                    int j = t_ui.locationToIndex(TestCaseBrowser.this.testcase_list, e.getPoint());
                    if (j >= 0 && (label = (String)TestCaseBrowser.this.testcase_model.get(j)) != null) {
                        TestCaseBrowser.this.editCase(label);
                    }
                } else {
                    TestCaseBrowser.this.displayCaseStatus();
                }
            }
        });
        this.initEnv();
    }

    private void displayCaseStatus() {
        int i = this.testcase_list.getSelectedIndex();
        if (i >= 0) {
            Integer n;
            TestCaseRecord t_case = this.m_caselist.get(i);
            this.txtDesc.setText("name=" + t_case.name + "\n" + t_case.description);
            String t_snap = Integer.toString(t_case.snapshot);
            String t_status = String.valueOf(Messages.getString("TestCaseBrowser.14")) + Integer.toString(t_case.begin) + Messages.getString("TestCaseBrowser.15") + Integer.toString(t_case.end);
            t_status = String.valueOf(t_status) + Messages.getString("TestCaseBrowser.20") + Boolean.toString(t_case.loggable) + "\n";
            if (t_snap != null && t_snap.length() > 0 && (n = new Integer(t_snap)) > 0) {
                t_status = String.valueOf(t_status) + Messages.getString("TestCaseBrowser.43") + t_snap + "\n";
            }
            t_status = String.valueOf(t_status) + Tool._db().getCaseStatus(t_case.name, Integer.toString(t_case.begin), Integer.toString(t_case.end));
            this.txtStatus.setText(t_status);
        }
    }

    private void initEnv() {
        this.m_env = Tool.readEnvironment();
        this.connectDB();
    }

    private void closing() {
        try {
            Tool.saveEnvironment(this.m_env);
            Tool.destroy();
        }
        catch (Exception e) {
            String t_msg = String.valueOf(e.getMessage()) + "\n";
            t_msg = String.valueOf(t_msg) + Tool.getStackMessage(e, 0, 10);
            Tool.alertMSG(null, t_msg);
        }
    }

    private void connectDB() {
        if (this.m_env != null) {
            Tool.setEnvironment(this.m_env);
            if (Tool._db() != null) {
                if (!this.db_created) {
                    JOptionPane.showMessageDialog(null, Messages.getString("TestCaseBrowser.49"));
                    if (!Tool._db().isReady()) {
                        this.mntmCreateTable.setEnabled(true);
                        this.db_created = false;
                        Tool.alertMSG(null, Messages.getString("TestCaseBrowser.64"));
                    } else {
                        this.mntmCreateTable.setEnabled(false);
                        this.db_created = true;
                    }
                }
            } else {
                this.db_created = false;
                this.mntmCreateTable.setEnabled(true);
                return;
            }
            String gcode = "";
            if (Tool.group_code.length() > 0) {
                gcode = "GroupCode=" + Tool.group_code;
            }
            this.setTitle(String.valueOf(this.m_title) + "   " + gcode);
        } else {
            Tool.alertMSG(null, Messages.getString(Messages.getString("TestCaseBrowser.45")));
        }
    }

    private boolean updateCaseData(TestCaseRecord rec, ArrayList<Record> removings, HashMap<Integer, TestCommandRecord> cmd, HashMap<String, ObjectRecord> objs, HashMap<Integer, AssertRecord> asrts) {
        block3: {
            try {
                if (Tool._db().saveTestCase(rec, removings, cmd, objs, asrts)) break block3;
                return false;
            }
            catch (SQLException e) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.46")) + e.getMessage());
                return false;
            }
        }
        rec.saved();
        JOptionPane.showMessageDialog(null, Messages.getString("TestCaseBrowser.34"));
        return true;
    }

    private void execTestCase(TestCaseRecord cdata, boolean editmode) {
        ArrayList<String> t_list = new ArrayList<String>();
        t_list.add(Boolean.toString(editmode));
        if (!this.m_env.process_mode) {
            if (cdata == null) {
                t_list.add("[]");
            } else {
                t_list.add(this.m_curcase.getCmdArgsStyle());
            }
            boolean cur_emode = Tool.editMode();
            Tool.setEditMode(editmode);
            TestCommander.execute(t_list);
            Tool.setEditMode(cur_emode);
        } else {
            if (cdata == null) {
                t_list.add("-caseName:%");
            } else {
                t_list.add("-caseName:" + this.m_curcase.name);
            }
            t_list.add(0, "-exec&wait");
            TestMain.main(t_list.toArray(new String[t_list.size()]));
        }
    }

    private void goTestCasePopUp(MouseEvent e, String label) {
        JPopupMenu t_pop = new JPopupMenu();
        t_pop.add(new JMenuItem(new TestCaseAction(Messages.getString("TestCaseBrowser.9"), this, label)));
        if (label != null) {
            t_pop.add(new JMenuItem(new TestCaseAction(Messages.getString("TestCaseBrowser.58"), this, label)));
            t_pop.add(new JMenuItem(new TestCaseAction(Messages.getString("TestCaseBrowser.5"), this, label)));
        }
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addTestCase() {
        if (!this.db_created) {
            Tool.alertMSG(null, Messages.getString("TestCaseBrowser.11"));
            return;
        }
        if (this.m_env.rootDirs.size() == 0) {
            Tool.alertMSG(null, Messages.getString("TestCaseBrowser.12"));
            return;
        }
        TestCaseRecord t_case = Tool._db().getNewTestCase(Tool.version);
        TestCaseEditor t_ed = new TestCaseEditor(this, t_case, this.m_env.hiddenMode);
        t_ed.setVisible(true);
        TestCaseRecord t_rec = new TestCaseRecord(2);
        t_ed.copyData(t_rec);
        if (t_ed.isOK()) {
            this.testcase_model.addElement(t_rec.name);
            this.m_caselist.add(t_rec);
            this.updateCaseData(t_rec, t_ed.m_removings, t_ed.m_cmds, t_ed.obj_table, t_ed.m_assert);
        }
    }

    private void editCase(String clabel) {
        if (clabel != null && !clabel.startsWith("//")) {
            int pos = -1;
            int i = 0;
            while (i < this.testcase_model.getSize()) {
                if (this.testcase_model.get(i) == clabel) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (pos >= 0) {
                TestCaseRecord t_rec = this.m_caselist.get(pos);
                TestCaseEditor t_ed = new TestCaseEditor(this, t_rec, this.m_env.hiddenMode);
                t_ed.setVisible(true);
                if (t_ed.isOK()) {
                    TestCaseRecord t_rec2 = t_rec._dup();
                    t_ed.copyData(t_rec);
                    if (!t_rec2.isEquivalentTo(t_rec)) {
                        t_rec.changed();
                    }
                    this.testcase_model.setElementAt(t_rec.name, pos);
                    this.txtDesc.setText(t_rec.description);
                    this.updateCaseData(t_rec, t_ed.m_removings, t_ed.m_cmds, t_ed.obj_table, t_ed.m_assert);
                    this.displayCaseStatus();
                }
            }
        }
    }

    private void tryCreateTable() {
        if (Tool._db() == null) {
            Tool.setEnvironment(this.m_env);
        }
        if (this.db_created) {
            Tool.alertMSG(null, Messages.getString("TestCaseBrowser.64"));
            return;
        }
        Tool._db().createTable();
        if (!Tool._db().isReady()) {
            Tool.alertMSG(null, Messages.getString("TestCaseBrowser.61"));
            this.mntmCreateTable.setEnabled(true);
            this.db_created = false;
        } else {
            Tool.alertMSG(null, Messages.getString("TestCaseBrowser.65"));
            this.mntmCreateTable.setEnabled(false);
            this.db_created = true;
        }
    }

    public void removeCase(String label) {
        int i = this.testcase_list.getSelectedIndex();
        if (i >= 0) {
            TestCaseRecord t_rec = this.m_caselist.get(i);
            if (Tool.group_code.length() == 0 || t_rec.groupCode != null && t_rec.groupCode.equals(Tool.group_code)) {
                int t_res = JOptionPane.showConfirmDialog(this, String.valueOf(t_rec.name) + Messages.getString("TestCaseBrowser.53"));
                if (t_res == 0 && t_rec.name.equals(label)) {
                    try {
                        Tool._db().removeCase(label, Tool.version);
                        JOptionPane.showMessageDialog(null, Messages.getString("TestCaseBrowser.38"));
                    }
                    catch (SQLException e) {
                        Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseBrowser.51")) + e.getMessage());
                    }
                    this.m_caselist.remove(i);
                    this.testcase_model.removeElementAt(i);
                }
            } else {
                Tool.alertMSG(null, Messages.getString("TestCaseBrowser.60"));
            }
        }
    }

    class TestCaseAction
    extends AbstractAction {
        String m_name;
        TestCaseBrowser m_master;
        String m_label;

        TestCaseAction(String name, TestCaseBrowser master, String cname) {
            this.putValue("Name", name);
            this.m_name = name;
            this.m_master = master;
            this.m_label = cname;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_name.equals(Messages.getString("TestCaseBrowser.62"))) {
                this.m_master.editCase(this.m_label);
            } else if (this.m_name.equals(Messages.getString("TestCaseBrowser.9"))) {
                this.m_master.addTestCase();
            } else if (this.m_name.equals(Messages.getString("TestCaseBrowser.6"))) {
                this.m_master.removeCase(this.m_label);
            }
        }
    }
}

