/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.web;

import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.web.PageAction;
import com.ftinc.si.assist.test.web.PagePlayer;
import com.ftinc.si.assist.test.web.WebElementGetter;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SendKeys
extends PageAction {
    private static String s_engraved = "";
    private static String s_clip_js = null;
    private static HashMap<String, Enum<Keys>> key_maps = null;

    @Override
    protected void doCore(WebDriver drv, WebElement elm) {
        if (elm != null) {
            Object t_obj = this.arg_map.get("keys");
            String t_keys = t_obj.toString();
            if (t_keys.endsWith("\\n")) {
                t_keys = String.valueOf(t_keys.replaceFirst("^([\\s\\S]*)\\\\n$", "$1")) + "\n";
            }
            Toolkit kit = Toolkit.getDefaultToolkit();
            Clipboard clip = kit.getSystemClipboard();
            String clip_str = "";
            clip_str = this.getClipBoardText();
            if (clip_str.startsWith("engrave>")) {
                s_engraved = clip_str.substring(8);
            }
            if (t_keys.startsWith("chord:")) {
                t_keys = this.chord(t_keys);
                if (t_obj.toString().matches("^.*\\[\\s*CONTROL\\s*,\\s*v\\s*\\].*$")) {
                    if (clip_str.startsWith("engrave>")) {
                        StringSelection ss = new StringSelection(s_engraved);
                        clip.setContents(ss, ss);
                    }
                    this.waitUntil1stSendKeys(drv, elm, t_keys);
                    this.restoreEngraved();
                } else {
                    elm.sendKeys(new CharSequence[]{t_keys});
                }
            } else {
                boolean after_waited = false;
                if (t_keys.matches("^\\+\\[.*\\]$")) {
                    t_keys = t_keys.replaceFirst("^\\+:\\[(.*)\\]$", "$1");
                } else {
                    this.waitUntil1stSendKeys(drv, elm, Keys.CONTROL + "a");
                    after_waited = true;
                }
                String t_ret = null;
                if (t_keys.indexOf("\n") == t_keys.length() - 1) {
                    t_ret = "\n";
                    t_keys = t_keys.substring(0, t_keys.length() - 1);
                }
                if (t_keys.length() > 0) {
                    this.setClipboard(drv, clip, elm, t_keys);
                    if (after_waited) {
                        elm.sendKeys(new CharSequence[]{Keys.CONTROL + "v"});
                    } else {
                        this.waitUntil1stSendKeys(drv, elm, Keys.CONTROL + "v");
                        after_waited = true;
                    }
                }
                this.restoreEngraved();
                if (t_ret != null) {
                    if (after_waited) {
                        elm.sendKeys(new CharSequence[]{Keys.RETURN});
                    } else {
                        this.waitUntil1stSendKeys(drv, elm, new CharSequence[]{Keys.RETURN});
                    }
                }
            }
        } else {
            String target = this.getXpath();
            if (this.arg_map.containsKey("itemID")) {
                target = String.valueOf(target) + " itemID=" + this.arg_map.get("itemID").toString();
            }
            throw new NotFoundException(String.valueOf(this.getClass().getSimpleName()) + " Not found " + target);
        }
    }

    private void setClipboard(WebDriver drv, Clipboard clip, WebElement elm, String str) {
        if (PagePlayer.isRemote()) {
            if (s_clip_js == null) {
                s_clip_js = "var t_x_t=document.createElement(\"textarea\");t_x_t.style.position='fixed';";
                s_clip_js = String.valueOf(s_clip_js) + "t_x_t.style.top=0;t_x_t.style.left=0;t_x_t.style.width='2em';t_x_t.style.height='2em';";
                s_clip_js = String.valueOf(s_clip_js) + "t_x_t.style.padding=0;t_x_t.style.border='none';t_x_t.style.outline='none';";
                s_clip_js = String.valueOf(s_clip_js) + "t_x_t.style.boxShadow='none';t_x_t.style.background='transparent';t_x_t.value='$$$';";
                s_clip_js = String.valueOf(s_clip_js) + "document.body.appendChild(t_x_t);t_x_t.select();document.execCommand('copy');";
                s_clip_js = String.valueOf(s_clip_js) + "document.body.removeChild(t_x_t);";
            }
            JavascriptExecutor jsexe = (JavascriptExecutor)drv;
            jsexe.executeScript(s_clip_js.replace("$$$", str), new Object[0]);
        } else {
            StringSelection ss = new StringSelection(str);
            clip.setContents(ss, ss);
        }
    }

    private void waitUntil1stSendKeys(WebDriver drv, final WebElement elm, final CharSequence ... keys) {
        int t_sec = this.getTimeout();
        WebDriverWait wait = new WebDriverWait(drv, (long)t_sec);
        ExpectedCondition<Boolean> t_ec = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver drv) {
                try {
                    elm.sendKeys(keys);
                }
                catch (Throwable e) {
                    return false;
                }
                return true;
            }
        };
        wait.until((Function)t_ec);
    }

    private String getClipBoardText() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard clip = kit.getSystemClipboard();
        try {
            return (String)clip.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return "";
        }
    }

    private void restoreEngraved() {
        if (s_engraved.length() > 0) {
            Toolkit kit = Toolkit.getDefaultToolkit();
            Clipboard clip = kit.getSystemClipboard();
            StringSelection ss = new StringSelection("engrave>" + s_engraved);
            clip.setContents(ss, ss);
        }
    }

    @Override
    protected ArrayList<String> getLabelAndParams() {
        ArrayList<String> t_list2 = new ArrayList<String>();
        t_list2.add("-");
        t_list2.add("Keys");
        Object t_keys = this.arg_map.get("keys");
        if (t_keys != null) {
            t_list2.add(t_keys.toString());
            if (!t_keys.toString().startsWith("chord:")) {
                t_list2.add("chord:");
            }
        } else {
            t_list2.add("chord:");
        }
        return t_list2;
    }

    @Override
    protected String[] getFocussingXPaths(String xpath) {
        if (xpath != null && xpath.length() > 0) {
            return super.getFocussingXPaths(xpath);
        }
        String[] t_result = new String[]{"//input[@type='text']", "//input[@type='password']", "//textarea"};
        return t_result;
    }

    @Override
    protected String getJsonElement(String target, String arg) {
        if (target != null && arg != null) {
            this.arg_map = (HashMap)Tool.getObjectfromJSON(HashMap.class, "{" + target + "}");
            this.arg_map.put("keys", arg);
        }
        return super.getJsonElement(null, null);
    }

    @Override
    protected JPopupMenu getPopup(WebElementGetter wg, String target) {
        JPopupMenu t_pop = new JPopupMenu();
        t_pop.add(new JMenuItem(new PageAction.InsertAction("\"id\":\"\"", "AddID", wg, target)));
        t_pop.add(new JMenuItem(new PageAction.InsertAction("\"xpath\":\"//*[@id='']\"", "AddXpath", wg, target)));
        JMenu t_menu = new JMenu("Matches");
        t_menu.add(new JMenuItem(new PageAction.InsertAction("Has Tag", "HasTag", wg, target)));
        t_pop.add(t_menu);
        return t_pop;
    }

    @Override
    protected boolean modifyByKeyInput(KeyEvent e, StringBuilder strb) {
        String c_str = strb.toString();
        if (c_str.startsWith("chord:")) {
            String t_s;
            int code = e.getKeyCode();
            ArrayList<String> t_list = new ArrayList<String>();
            if (e.isAltDown()) {
                t_list.add("ALT");
            }
            if (e.isControlDown()) {
                t_list.add("CONTROL");
            }
            if (e.isShiftDown()) {
                t_list.add("SHIFT");
            }
            if (e.isMetaDown()) {
                t_list.add("META");
            }
            switch (code) {
                case 112: {
                    t_list.add("F1");
                    code = 0;
                    break;
                }
                case 113: {
                    t_list.add("F2");
                    code = 0;
                    break;
                }
                case 114: {
                    t_list.add("F3");
                    code = 0;
                    break;
                }
                case 115: {
                    t_list.add("F4");
                    code = 0;
                    break;
                }
                case 116: {
                    t_list.add("F5");
                    code = 0;
                    break;
                }
                case 117: {
                    t_list.add("F6");
                    code = 0;
                    break;
                }
                case 118: {
                    t_list.add("F7");
                    code = 0;
                    break;
                }
                case 119: {
                    t_list.add("F8");
                    code = 0;
                    break;
                }
                case 120: {
                    t_list.add("F9");
                    code = 0;
                    break;
                }
                case 121: {
                    t_list.add("F10");
                    code = 0;
                    break;
                }
                case 122: {
                    t_list.add("F11");
                    code = 0;
                    break;
                }
                case 123: {
                    t_list.add("F12");
                    code = 0;
                    break;
                }
                case 38: {
                    t_list.add("ARROW_UP");
                    code = 0;
                    break;
                }
                case 40: {
                    t_list.add("ARROW_DOWN");
                    code = 0;
                    break;
                }
                case 37: {
                    t_list.add("ARROW_LEFT");
                    code = 0;
                    break;
                }
                case 39: {
                    t_list.add("ARROW_RIGHT");
                    code = 0;
                    break;
                }
                case 224: {
                    t_list.add("UP");
                    code = 0;
                    break;
                }
                case 225: {
                    t_list.add("DOWN");
                    code = 0;
                    break;
                }
                case 226: {
                    t_list.add("LEFT");
                    code = 0;
                    break;
                }
                case 227: {
                    t_list.add("RIGHT");
                    code = 0;
                    break;
                }
                case 8: {
                    t_list.add("BACK_SPACE");
                    code = 0;
                    break;
                }
                case 3: {
                    t_list.add("CANCEL");
                    code = 0;
                    break;
                }
                case 12: {
                    t_list.add("CLEAR");
                    code = 0;
                    break;
                }
                case 127: {
                    t_list.add("DELETE");
                    code = 0;
                    break;
                }
                case 35: {
                    t_list.add("END");
                    code = 0;
                    break;
                }
                case 10: {
                    t_list.add("ENTER");
                    code = 0;
                    break;
                }
                case 27: {
                    t_list.add("ESCAPE");
                    code = 0;
                    break;
                }
                case 156: {
                    t_list.add("HELP");
                    code = 0;
                    break;
                }
                case 36: {
                    t_list.add("HOME");
                    code = 0;
                    break;
                }
                case 155: {
                    t_list.add("INSERT");
                    code = 0;
                    break;
                }
                case 34: {
                    t_list.add("PAGE_DOWN");
                    code = 0;
                    break;
                }
                case 33: {
                    t_list.add("PAGE_UP");
                    code = 0;
                    break;
                }
                case 19: {
                    t_list.add("PAUSE");
                    code = 0;
                    break;
                }
                case 244: {
                    t_list.add("ZENKAKU_HANKAKU");
                    code = 0;
                }
            }
            if (code != 0 && (t_s = KeyEvent.getKeyText(e.getKeyCode())).length() > 0) {
                t_list.add(t_s.toLowerCase());
            }
            if (t_list.size() > 0) {
                strb.replace(0, strb.length(), "chord:" + Tool.getJSONfromObject(t_list));
                return true;
            }
        }
        return false;
    }

    private static void initKeyMaps() {
        key_maps = new HashMap();
        key_maps.put("ALT", (Enum<Keys>)Keys.ALT);
        key_maps.put("ARROW_DOWN", (Enum<Keys>)Keys.ARROW_DOWN);
        key_maps.put("ARROW_LEFT", (Enum<Keys>)Keys.ARROW_LEFT);
        key_maps.put("ARROW_RIGHT", (Enum<Keys>)Keys.ARROW_RIGHT);
        key_maps.put("ARROW_UP", (Enum<Keys>)Keys.ARROW_UP);
        key_maps.put("BACK_SPACE", (Enum<Keys>)Keys.BACK_SPACE);
        key_maps.put("CANCEL", (Enum<Keys>)Keys.CANCEL);
        key_maps.put("CLEAR", (Enum<Keys>)Keys.CLEAR);
        key_maps.put("COMMAND", (Enum<Keys>)Keys.COMMAND);
        key_maps.put("CONTROL", (Enum<Keys>)Keys.CONTROL);
        key_maps.put("DELETEL", (Enum<Keys>)Keys.DELETE);
        key_maps.put("DOWN", (Enum<Keys>)Keys.DOWN);
        key_maps.put("END", (Enum<Keys>)Keys.END);
        key_maps.put("ENTER", (Enum<Keys>)Keys.ENTER);
        key_maps.put("ESCAPE", (Enum<Keys>)Keys.ESCAPE);
        key_maps.put("F1", (Enum<Keys>)Keys.F1);
        key_maps.put("F10", (Enum<Keys>)Keys.F10);
        key_maps.put("F11", (Enum<Keys>)Keys.F11);
        key_maps.put("F12", (Enum<Keys>)Keys.F12);
        key_maps.put("F2", (Enum<Keys>)Keys.F2);
        key_maps.put("F3", (Enum<Keys>)Keys.F3);
        key_maps.put("F4", (Enum<Keys>)Keys.F4);
        key_maps.put("F5", (Enum<Keys>)Keys.F5);
        key_maps.put("F6", (Enum<Keys>)Keys.F6);
        key_maps.put("F7", (Enum<Keys>)Keys.F7);
        key_maps.put("F8", (Enum<Keys>)Keys.F8);
        key_maps.put("F9", (Enum<Keys>)Keys.F9);
        key_maps.put("HELP", (Enum<Keys>)Keys.HELP);
        key_maps.put("HOME", (Enum<Keys>)Keys.HOME);
        key_maps.put("INSERT", (Enum<Keys>)Keys.INSERT);
        key_maps.put("LEFT", (Enum<Keys>)Keys.LEFT);
        key_maps.put("LEFT_ALT", (Enum<Keys>)Keys.LEFT_ALT);
        key_maps.put("LEFT_CONTROL", (Enum<Keys>)Keys.LEFT_CONTROL);
        key_maps.put("LEFT_SHIFT", (Enum<Keys>)Keys.LEFT_SHIFT);
        key_maps.put("META", (Enum<Keys>)Keys.META);
        key_maps.put("PAGE_DOWN", (Enum<Keys>)Keys.PAGE_DOWN);
        key_maps.put("PAGE_UP", (Enum<Keys>)Keys.PAGE_UP);
        key_maps.put("PAUSE", (Enum<Keys>)Keys.PAUSE);
        key_maps.put("RIGHT", (Enum<Keys>)Keys.RIGHT);
        key_maps.put("SHIFT", (Enum<Keys>)Keys.SHIFT);
        key_maps.put("UP", (Enum<Keys>)Keys.UP);
        key_maps.put("ZENKAKU_HANKAKU", (Enum<Keys>)Keys.ZENKAKU_HANKAKU);
    }

    private String chord(String keys) {
        String t_result = keys;
        if (keys.startsWith("chord:")) {
            ArrayList t_keys;
            if (key_maps == null) {
                SendKeys.initKeyMaps();
            }
            if ((t_keys = (ArrayList)Tool.getObjectfromJSON(ArrayList.class, keys = keys.replaceFirst("^chord:", ""))).contains("CONTROL") && t_keys.contains("c")) {
                String clip_str = "";
                clip_str = this.getClipBoardText();
                if (clip_str.startsWith("engrave>")) {
                    s_engraved = clip_str.substring(8);
                }
            }
            t_result = "";
            int i = 0;
            while (i < t_keys.size()) {
                t_result = key_maps.containsKey(t_keys.get(i)) ? String.valueOf(t_result) + key_maps.get(t_keys.get(i)) : String.valueOf(t_result) + ((String)t_keys.get(i)).substring(0, 1);
                ++i;
            }
            t_result = Keys.chord((CharSequence[])new CharSequence[]{t_result});
        }
        return t_result;
    }
}

