package com.ftinc.si.assist.test.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;

public class EnvironmentDialog extends JDialog {
	private JTextField serverName;
	private JTextField port;
	private JTextField dbName;
	private JTextField encode;
	private JTextField uID;
	private JTextField pwd;
	private JList<String> rootDirs;
	private boolean hiddenMode = false;
	private boolean processMode = false;
	private JTextField textFakeDir;
	private JTextField textLogFile;
	private JTextField caseUnitSize;
	private JList<String> pluginList;
	private HashMap<String, HashMap<String, String>> plugins_properties;
	private JCheckBox chckbxRemote;
	private JTextField textGroupCode;
	private JTextArea aliasNames;
	private JCheckBox chckbxDebugmode;
	private JButton btnCreateTable;

	private EnvironmentData old_env;

	//入力チェック結果を保持
	private boolean checkedResult;
	private JTextField versionText;
	public boolean is_ok;

	public EnvironmentDialog(JFrame owner, EnvironmentData env) {
		super(owner, true);
		is_ok = false;

		hiddenMode = env.hiddenMode;
		processMode = env.process_mode;
		old_env = (EnvironmentData)Tool.getObjectfromJSON(EnvironmentData.class, Tool.getJSONfromObject(env));

		setResizable(false);
		if (owner != null) {
			setBounds(owner.getX() + 100, owner.getY() + 100, 450, 300);
		} else {
			setBounds(100, getY() + 100, 450, 300);
		}
		setTitle(Messages.getString("EnvironmentDialog.0")); //$NON-NLS-1$
		getContentPane().setLayout(null);

		//プラグイン用プロパティの初期化
		if (env.plugins_properties == null) {
			plugins_properties = new HashMap<String, HashMap<String, String>>();
		} else {
			plugins_properties = env.plugins_properties;
		}

		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		tabbedPane.setBounds(0, 0, 444, 271);
		getContentPane().add(tabbedPane);

		JPanel panel = new JPanel();
		tabbedPane.addTab(Messages.getString("EnvironmentDialog.1"), null, panel, null); //$NON-NLS-1$
		panel.setLayout(null);

		JButton btnApply = new JButton(Messages.getString("EnvironmentDialog.2")); //$NON-NLS-1$
		btnApply.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		btnApply.setBounds(336, 213, 91, 21);
		panel.add(btnApply);

		JCheckBox chckbxHideDisabled = new JCheckBox(Messages.getString("EnvironmentDialog.3"), hiddenMode); //$NON-NLS-1$
		chckbxHideDisabled.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				hiddenMode = !hiddenMode;
			}
		});
		chckbxHideDisabled.setBounds(8, 21, 103, 21);
		panel.add(chckbxHideDisabled);

		JLabel lblRootDirectoryFor = new JLabel(Messages.getString("EnvironmentDialog.4")); //$NON-NLS-1$
		lblRootDirectoryFor.setBounds(8, 75, 224, 13);
		panel.add(lblRootDirectoryFor);

		textFakeDir = new JTextField(env.fakedir);
		textFakeDir.setBounds(18, 98, 341, 19);
		panel.add(textFakeDir);
		textFakeDir.setColumns(10);

		JButton dirButton = new JButton(Messages.getString("EnvironmentDialog.5")); //$NON-NLS-1$
		dirButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser f_dlg = new JFileChooser(Tool.getPrevPath()); //$NON-NLS-1$
				f_dlg.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

				int i = f_dlg.showSaveDialog(null);
				if (i == JFileChooser.APPROVE_OPTION){
					File t_file = f_dlg.getSelectedFile();
					textFakeDir.setText(t_file.getAbsolutePath() + "\\"); //$NON-NLS-1$
					Tool.setPrevPath(t_file.getAbsolutePath());
				}

			}
		});
		dirButton.setBounds(370, 97, 57, 21);
		panel.add(dirButton);

		JLabel lblLogFile = new JLabel(Messages.getString("EnvironmentDialog.8")); //$NON-NLS-1$
		lblLogFile.setBounds(8, 143, 103, 13);
		panel.add(lblLogFile);

		textLogFile = new JTextField(env.logdir);
		textLogFile.setBounds(18, 166, 341, 19);
		panel.add(textLogFile);
		textLogFile.setColumns(10);

		JButton btnLogButton = new JButton(Messages.getString("EnvironmentDialog.9")); //$NON-NLS-1$
		btnLogButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser f_dlg = new JFileChooser(Tool.getPrevPath()); //$NON-NLS-1$
				f_dlg.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

				int i = f_dlg.showSaveDialog(null);
				if (i == JFileChooser.APPROVE_OPTION){
					File t_file = f_dlg.getSelectedFile();
					textLogFile.setText(t_file.getAbsolutePath() + "\\"); //$NON-NLS-1$
					Tool.setPrevPath(t_file.getAbsolutePath());
				}
			}
		});
		btnLogButton.setBounds(370, 165, 57, 21);
		panel.add(btnLogButton);

		JLabel lblUnitSizeOf = new JLabel(Messages.getString("EnvironmentDialog.lblUnitSizeOf.text")); //$NON-NLS-1$
		lblUnitSizeOf.setBounds(199, 25, 109, 13);
		panel.add(lblUnitSizeOf);

		caseUnitSize = new JTextField(Integer.toString(env.caseSize));
		caseUnitSize.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				checkedResult = Tool.checkInteger(caseUnitSize.getText(), e, 1000, 0);
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyReleased(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyTyped(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
		});
		caseUnitSize.enableInputMethods(false);
		caseUnitSize.setHorizontalAlignment(JTextField.RIGHT);

		caseUnitSize.setText(Integer.toString(env.caseSize));
		caseUnitSize.setBounds(302, 22, 96, 19);
		panel.add(caseUnitSize);
		caseUnitSize.setColumns(10);

		//テスト実行を別プロセスで行うか決めるモード
		JCheckBox chckbxProcessMode = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxRemoteMode.text"), processMode); //$NON-NLS-1$
		chckbxProcessMode.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				processMode = !processMode;
			}
		});
		chckbxProcessMode.setBounds(8, 213, 156, 21);
		panel.add(chckbxProcessMode);

		chckbxDebugmode = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxDebugmode.text")); //$NON-NLS-1$
		chckbxDebugmode.setBounds(194, 213, 103, 21);
		panel.add(chckbxDebugmode);
		chckbxDebugmode.setSelected(env.debug_mode);

		JPanel panel_1 = new JPanel();
		tabbedPane.addTab(Messages.getString("EnvironmentDialog.11"), null, panel_1, null); //$NON-NLS-1$
		panel_1.setLayout(null);

		JLabel lblTargetRootFolder = new JLabel(Messages.getString("EnvironmentDialog.12")); //$NON-NLS-1$
		lblTargetRootFolder.setBounds(12, 10, 188, 13);
		panel_1.add(lblTargetRootFolder);

		final DefaultListModel<String> rootModel = new DefaultListModel<String>();
		for (int i = 0; i < env.rootDirs.size(); i++) {
			rootModel.addElement(env.rootDirs.get(i));
		}
		rootDirs = new JList<String>(rootModel);
		rootDirs.setBounds(12, 33, 317, 175);
		panel_1.add(rootDirs);


		JButton btnAddDir = new JButton(Messages.getString("EnvironmentDialog.13")); //$NON-NLS-1$
		btnAddDir.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				JFileChooser t_fc = new JFileChooser(Tool.getPrevPath());
				t_fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				FileFilter filter = new FileNameExtensionFilter("Jar(*.jar)", "jar"); //$NON-NLS-1$ //$NON-NLS-2$
				t_fc.addChoosableFileFilter(filter);

				if (t_fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION){
					File t_file = t_fc.getSelectedFile();
					String t_path =t_file.getAbsolutePath(); //$NON-NLS-1$

					Tool.setPrevPath(t_file.getAbsolutePath());

					if (t_file.isDirectory()) {	//ディレクトリの場合、区切りを追加
						t_path += "\\"; //$NON-NLS-1$
					}

					int i = rootModel.indexOf(t_path);
					if (i < 0) {
						rootModel.addElement(t_path);
					}
				}
			}
		});
		btnAddDir.setBounds(339, 33, 88, 21);
		panel_1.add(btnAddDir);

		JButton btnRemove = new JButton(Messages.getString("EnvironmentDialog.15")); //$NON-NLS-1$
		btnRemove.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (!rootDirs.isSelectionEmpty()){
					int index = rootDirs.getSelectedIndex();
					rootModel.removeElementAt(index);
//					rootDirs.remove(index);
				}
			}
		});
		btnRemove.setBounds(339, 71, 88, 21);
		panel_1.add(btnRemove);

		JButton btnApply_1 = new JButton(Messages.getString("EnvironmentDialog.16")); //$NON-NLS-1$
		btnApply_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		btnApply_1.setBounds(336, 213, 91, 21);
		panel_1.add(btnApply_1);

		JPanel panel_3 = new JPanel();
		tabbedPane.addTab(Messages.getString("EnvironmentDialog.panel_3.title"), null, panel_3, null); //$NON-NLS-1$
		panel_3.setLayout(null);

		JLabel lblNewLabel = new JLabel(Messages.getString("EnvironmentDialog.lblNewLabel.text")); //$NON-NLS-1$
		lblNewLabel.setBounds(12, 10, 115, 13);
		panel_3.add(lblNewLabel);

		//Plugin系
		final DefaultListModel<String> pluginModel = new DefaultListModel<String>();
		for (int i = 0; i < env.plugins.size(); i++) {
			pluginModel.addElement(env.plugins.get(i));
		}

		pluginList = new JList<String>(pluginModel);
		pluginList.setBounds(12, 33, 312, 174);
		panel_3.add(pluginList);

		JButton addPlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_1.text")); //$NON-NLS-1$
		addPlugin.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				String cname = Tool.findClassName(Tool.getParent((Component)e.getSource(), "JDialog"), Tool.target_dirs); //$NON-NLS-1$
				if (cname != null && cname.length() > 0) {
					try {
						Class<?> t_c = Tool.forName(cname);
						if (Plugin.class.isAssignableFrom(t_c)) {
							pluginModel.addElement(cname);
						}
					} catch (ClassNotFoundException e1) {
						Tool.alertMSG(null, e1.getMessage());
					}
				}
			}
		});
		addPlugin.setBounds(336, 33, 91, 21);
		panel_3.add(addPlugin);

		JButton removePlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_2.text")); //$NON-NLS-1$
		removePlugin.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (!pluginList.isSelectionEmpty()){
					int index = pluginList.getSelectedIndex();
					pluginModel.removeElementAt(index);
					pluginList.remove(index);
				}
			}
		});
		removePlugin.setBounds(336, 68, 91, 21);
		panel_3.add(removePlugin);

		JButton btnClosePlugin = new JButton(Messages.getString("EnvironmentDialog.btnNewButton_1.text_1")); //$NON-NLS-1$
		btnClosePlugin.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		btnClosePlugin.setBounds(336, 213, 91, 21);
		panel_3.add(btnClosePlugin);

		JButton btnEdit = new JButton(Messages.getString("EnvironmentDialog.btnEdit.text")); //$NON-NLS-1$
		btnEdit.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				//プラグインの編集メソッドを起動する。
				if (!pluginList.isSelectionEmpty()){
					int i = pluginList.getSelectedIndex();

					if (i >= 0) {
						String c_name = (String)pluginModel.getElementAt(i);

						HashMap<String, String> t_map = plugins_properties.get(c_name);
						if (t_map == null) {
							t_map = new HashMap<String, String>();
						}

						Class<?> t_c;
						try {
							t_c = Tool.forName(c_name);
							Plugin t_plugin = (Plugin) Tool.newObject(t_c, null, null);
							t_plugin.editProperties(t_map);
						} catch (ClassNotFoundException e1) {
							Tool.alertMSG(null, "ClassNotFoundException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (SecurityException e1) {
							Tool.alertMSG(null, "SecurityException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (IllegalArgumentException e1) {
							Tool.alertMSG(null, "IllegalArgumentException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (NoSuchMethodException e1) {
							Tool.alertMSG(null, "NoSuchMethodException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (InstantiationException e1) {
							Tool.alertMSG(null, "InstantiationException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (IllegalAccessException e1) {
							Tool.alertMSG(null, "IllegalAccessException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						} catch (InvocationTargetException e1) {
							Tool.alertMSG(null, "InvocationTargetException:pluginEdit@EnvironmentDialog:" + e1.getMessage()); //$NON-NLS-1$
						}

						if (t_map.size() == 0) {
							if (plugins_properties.containsKey(c_name)) {
								//空ならば削除する
								plugins_properties.remove(c_name);
							}
						} else {
							plugins_properties.put(c_name, t_map);
						}
					}
				}
			}
		});
		btnEdit.setBounds(336, 108, 91, 21);
		panel_3.add(btnEdit);


		JPanel panel_2 = new JPanel();
		tabbedPane.addTab(Messages.getString("EnvironmentDialog.17"), null, panel_2, null); //$NON-NLS-1$
		panel_2.setLayout(null);


		JLabel lblServer = new JLabel(Messages.getString("EnvironmentDialog.18")); //$NON-NLS-1$
		lblServer.setBounds(12, 10, 69, 13);
		panel_2.add(lblServer);

		serverName = new JTextField(env.serverName);
		serverName.setBounds(103, 7, 224, 19);
		panel_2.add(serverName);
		serverName.setColumns(10);

		JLabel lblPort = new JLabel(Messages.getString("EnvironmentDialog.19")); //$NON-NLS-1$
		lblPort.setBounds(12, 39, 50, 13);
		panel_2.add(lblPort);

		port = new JTextField();
		port.setText(env.port);
		port.setBounds(103, 36, 107, 19);
		panel_2.add(port);
		port.setColumns(10);
		port.enableInputMethods(false);
		port.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				checkedResult = Tool.checkInteger(port.getText(), e, 0, 0);
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyReleased(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyTyped(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
		});


		JLabel lblDatabase = new JLabel(Messages.getString("EnvironmentDialog.20")); //$NON-NLS-1$
		lblDatabase.setBounds(12, 77, 90, 13);
		panel_2.add(lblDatabase);

		if (env.dbName == null || env.dbName.length() == 0) {
			env.dbName = "db_TestCase"; //$NON-NLS-1$
		}

		dbName = new JTextField(env.dbName);
		dbName.setBounds(103, 74, 224, 19);
		panel_2.add(dbName);
		dbName.setColumns(10);

		JLabel lblEncoding = new JLabel(Messages.getString("EnvironmentDialog.21")); //$NON-NLS-1$
		lblEncoding.setBounds(12, 111, 69, 13);
		panel_2.add(lblEncoding);

		encode = new JTextField();
		encode.setText(env.encode);
		encode.setBounds(103, 108, 96, 19);
		panel_2.add(encode);
		encode.setColumns(10);

		JLabel lblUserid = new JLabel(Messages.getString("EnvironmentDialog.22")); //$NON-NLS-1$
		lblUserid.setBounds(12, 150, 50, 13);
		panel_2.add(lblUserid);

		JLabel lblPassword = new JLabel(Messages.getString("EnvironmentDialog.23")); //$NON-NLS-1$
		lblPassword.setBounds(235, 150, 69, 13);
		panel_2.add(lblPassword);

		uID = new JTextField(env.uID);
		uID.setText(Messages.getString("EnvironmentDialog.24")); //$NON-NLS-1$
		uID.setBounds(101, 147, 109, 19);
		panel_2.add(uID);
		uID.setColumns(10);

		pwd = new JTextField(env.pwd);
		pwd.setText(Messages.getString("EnvironmentDialog.25")); //$NON-NLS-1$
		pwd.setBounds(318, 147, 109, 19);
		panel_2.add(pwd);
		pwd.setColumns(10);

		JButton btnApply_2 = new JButton(Messages.getString("EnvironmentDialog.26")); //$NON-NLS-1$
		btnApply_2.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		btnApply_2.setBounds(336, 213, 91, 21);
		panel_2.add(btnApply_2);

		chckbxRemote = new JCheckBox(Messages.getString("EnvironmentDialog.chckbxRemote.text"), env.remote_db); //$NON-NLS-1$
		chckbxRemote.setBounds(12, 186, 103, 21);

		panel_2.add(chckbxRemote);

		btnCreateTable = new JButton(Messages.getString("EnvironmentDialog.btnNewButton.text")); //$NON-NLS-1$
		btnCreateTable.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				//table生成を試みる。
				Tool._db().createTable();
				if (Tool._db().isReady()) {
					btnCreateTable.setEnabled(false);
				}
			}
		});
		btnCreateTable.setBounds(103, 213, 107, 21);
		panel_2.add(btnCreateTable);

		if (Tool._db() != null) {
			if (Tool._db().isReady()) {
				btnCreateTable.setEnabled(false);
			}
		}

		JPanel panel_4 = new JPanel();
		tabbedPane.addTab(Messages.getString("EnvironmentDialog.6"), null, panel_4, null); //$NON-NLS-1$
		panel_4.setLayout(null);

		JLabel lblGroupCode = new JLabel(Messages.getString("EnvironmentDialog.lblTeamid.text")); //$NON-NLS-1$
		lblGroupCode.setBounds(12, 21, 107, 13);
		panel_4.add(lblGroupCode);

		textGroupCode = new JTextField();
		textGroupCode.setText(env.groupCode);
		textGroupCode.setBounds(117, 18, 99, 19);
		panel_4.add(textGroupCode);
		textGroupCode.setColumns(10);
		textGroupCode.enableInputMethods(false);
		textGroupCode.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				checkedResult = Tool.checkInteger(textGroupCode.getText(), e, 100, 0);
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyReleased(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
			@Override
			public void keyTyped(KeyEvent e) {
				if (!checkedResult) {
					e.consume();
				}
			}
		});


		JButton btnClose = new JButton(Messages.getString("EnvironmentDialog.btnClose.text")); //$NON-NLS-1$
		btnClose.setBounds(336, 213, 91, 21);
		btnClose.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				is_ok = true;
				setVisible(false);
			}
		});
		panel_4.add(btnClose);

		JLabel lblAliasNames = new JLabel(Messages.getString("EnvironmentDialog.lblAliasNames.text")); //$NON-NLS-1$
		lblAliasNames.setBounds(12, 62, 85, 13);
		panel_4.add(lblAliasNames);
		String t_txt = ""; //$NON-NLS-1$
		if (env.aliasNames != null) {
			for (Entry<String, String> entry: env.aliasNames.entrySet()) {
				if (t_txt.length() > 0) {
					t_txt += "\n"; //$NON-NLS-1$
				}
				t_txt += entry.getKey() + "=" + entry.getValue(); //$NON-NLS-1$
			}
		}

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(117, 44, 299, 166);
		panel_4.add(scrollPane);

		aliasNames = new JTextArea();
		scrollPane.setViewportView(aliasNames);

		aliasNames.setText(t_txt);

		JLabel lblVersion = new JLabel(Messages.getString("EnvironmentDialog.lblVersion.text")); //$NON-NLS-1$
		lblVersion.setBounds(228, 21, 50, 13);
		panel_4.add(lblVersion);

		versionText = new JTextField();
		versionText.setText(env.version);
		versionText.setBounds(290, 18, 126, 19);
		panel_4.add(versionText);
		versionText.setColumns(10);
	}

	@SuppressWarnings("unchecked")
	public EnvironmentData getEnvData() {
		EnvironmentData t_d = new EnvironmentData();
		t_d.dbName = dbName.getText();
		t_d.encode = encode.getText();
		t_d.port = port.getText();
		t_d.pwd = pwd.getText();
		t_d.serverName = serverName.getText();
		t_d.uID = uID.getText();
		t_d.hiddenMode = hiddenMode;
		t_d.fakedir = textFakeDir.getText();
		t_d.logdir = textLogFile.getText();
		t_d.caseSize = Integer.valueOf(caseUnitSize.getText());
		t_d.process_mode = processMode;
		t_d.remote_db = chckbxRemote.isSelected();
		t_d.groupCode = textGroupCode.getText();
		t_d.version = versionText.getText();
		t_d.debug_mode = chckbxDebugmode.isSelected();

		t_d.rootDirs = new ArrayList<String>();
		for (int i = 0; i < rootDirs.getModel().getSize(); i++) {
			t_d.rootDirs.add((String) rootDirs.getModel().getElementAt(i));
		}
		t_d.plugins = new ArrayList<String>();
		for (int i = 0; i < pluginList.getModel().getSize(); i++) {
			t_d.plugins.add((String) pluginList.getModel().getElementAt(i));

		}
		if (t_d.plugins.size() > 0 && plugins_properties != null) {
			t_d.plugins_properties = (HashMap<String, HashMap<String, String>>)plugins_properties.clone();
		}

		//別名が設定されていたら、マップを構成する。
		if (aliasNames.getText().length() > 0) {
			t_d.aliasNames = new HashMap<String, String>();
			String[] t_lines = aliasNames.getText().split("\n"); //$NON-NLS-1$
			for (int i = 0; i < t_lines.length; i++) {
				//書式
				//   カテゴリ(include,url,server,pathのどれか):key=value
				//カテゴリは適用先を明示し誤変換をなくすため。

				String[] temp = t_lines[i].split("="); //$NON-NLS-1$
				t_d.aliasNames.put(temp[0].trim(),  temp[1].trim());
			}
		}

		String n_env = Tool.getJSONfromObject(t_d);
		if (n_env != null && !n_env.equals(Tool.getJSONfromObject(old_env))) {
			if (old_env.groupCode != null && old_env.groupCode.length() > 0 && t_d.groupCode.length() == 0) {
				//削除する資格を確認
				int t_res = JOptionPane.showConfirmDialog(this, Messages.getString("EnvironmentDialog.10")); //$NON-NLS-1$
				if(t_res != JOptionPane.YES_OPTION) {
					//processmodeの時だけログに記録する。
					Tool.logIfDebug(null, Messages.getString("EnvironmentDialog.7") + old_env.groupCode + Messages.getString("EnvironmentDialog.14") + t_d.groupCode); //$NON-NLS-1$ //$NON-NLS-2$

					//申告を信用して管理者にする。
					t_d.groupCode = old_env.groupCode;
				}
			}
			if (t_d.groupCode.length() > 0 && t_d.version.length() == 0) {
				//versionをnullにする資格なし。
				t_d.version = old_env.version;
			}
			return t_d;
		}
		//変更ない場合はnullを返す。
		return null;
	}
}
