package com.ftinc.si.assist.test.web;

import java.util.ArrayList;
import java.util.Set;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ResetBrowser extends PageAction {
	protected void doCore(WebDriver drv, WebElement elm) {
		if (drv != null) {
			Set<String> w_ids = drv.getWindowHandles();
			
			//全てのWindowを閉じる。（セッションまで切れるなら、ほかの方法を考える。ヒント：drv.delete_all_cookies()）
			for(String s : w_ids) {
				drv.switchTo().window(s);
				drv.manage().deleteAllCookies();
				if (s.equals(s_win_id)) {
					//オリジナルは残す。
					drv.get("about:blank");
				} else {
					drv.close();
				}
			}
		}
	}
	
	//このPageActionではフォーカスする対象を持たない。あるいは、WebDriverから情報を取得する必要はない。
	protected boolean getFocussingElements(WebDriver drv, ArrayList<WebElement> el_list, ArrayList<String> xp_list, String xpaths) {
		return false;//WebElementGetterを開かないサイン
	}
}
