# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from ftg.flowobject import FlowObject


class FlowPriority(FlowObject):
    DEFAULT_TYPE = 1

    def __init__(self, priority_no, label="", type=DEFAULT_TYPE, metadata={}):
        self.priority_no = priority_no
        self.label = label
        self.type = type
        self.metadata = metadata
        self.flow_entries = []

    def set_flow_entries(self, flow_entries):
        self.flow_entries = flow_entries

    def add_flow_entries(self, flow_entries):
        self.flow_entries.append(flow_entries)

    def get_flow_entries(self):
        return self.flow_entries

    def get_number_of_flow_entries(self):
        return len(self.flow_entries)

    def get_priority_no(self):
        return self.priority_no
