# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re
import urllib2
import time

from bbs_type_exception import BbsTypeError
from bbs_type_base import BaseType

_base_reg_expr = re.compile("http://(?P<host>jbbs\.livedoor\.jp)/(?P<board>(?P<brd_dir>[^/]+)/(?P<brd_bbs>[^/]+))(?:/[^/]*){0,1}$")
_cgi_reg_expr = re.compile("http://(?P<host>jbbs\.livedoor\.jp)/bbs/read\.cgi/(?P<board>(?P<brd_dir>[^/]+)/(?P<brd_bbs>[^/]+))/(?P<thread>[^/]+)/.*")
subject_reg_expr = re.compile("(?P<id>[^,]*)\.cgi,(?P<title>.*)\((?P<res>\d*)\)")
dat_reg_expr = re.compile("(?P<num>\d+)<>(?P<name>(?:(?!<>).)*)<>(?P<mail>(?:(?!<>).)*)<>(?P<date>(?:(?!<>).)*)<>(?P<msg>(?:(?!<>).)*)<>(?P<title>(?:(?!<>).)*)<>(?P<id>(?:(?!<>).)*)")


class TypeJbbs(BaseType):
    """Base of bbs type. Do not instantiate directly"""

    bbs_type = "jbbs"
    _base_reg = _base_reg_expr
    _cgi_reg = _cgi_reg_expr
    subject_reg = subject_reg_expr
    dat_reg = dat_reg_expr
    encoding = "euc-jp"

    def __init__(self, uri):
        self.brd_dir = None
        self.brd_bbs = None
        BaseType.__init__(self, uri)

    def _parse_uri(self, uri):
        m = self._base_reg.match(self.uri)
        if m:
            self.host = m.group("host")
            self.board = m.group("board")
            self.brd_dir = m.group("brd_dir")
            self.brd_bbs = m.group("brd_bbs")
        else:
            m = self._cgi_reg.match(self.uri)
            if m:
                self.host = m.group("host")
                self.board = m.group("board")
                self.brd_dir = m.group("brd_dir")
                self.brd_bbs = m.group("brd_bbs")
                self.thread = m.group("thread")
            else:
                raise BbsTypeError, \
                      "the uri %s does not represent %s" \
                      % (self.uri, self.bbs_type)

    def get_uri_base(self):
        return "http://" + self.host + "/" + self.board + "/"

    def get_subject_txt_uri(self):
        return self.get_uri_base() + "subject.txt"

    def get_dat_uri(self):
        if not self.thread:
            raise BbsTypeError, "not specified thread"
        return "http://" + self.host + "/bbs/rawmode.cgi/" + \
                  self.board + "/" + self.thread + "/"

    def get_thread_uri(self):
        if not self.thread:
            raise BbsTypeError, "not specified thread"
        return "http://" + self.host + "/bbs/read.cgi/" + \
                  self.board + "/" + self.thread + "/"

    def get_post_uri(self):
        return "http://" + self.host + "/bbs/write.cgi/" + self.board \
               + "/" + self.thread + "/"

    def build_post_dict(self, name, mail, msg):
        post_dict = {}
        post_dict["DIR"] = self.brd_dir
        post_dict["BBS"] = self.brd_bbs
        post_dict["KEY"] = self.thread
        post_dict["TIME"] = str(int(time.time()))
        post_dict["submit"] = u"\u66f8\u304d\u8fbc\u3080".encode(
            "euc-jp", "replace")
        post_dict["NAME"] = name.encode("euc-jp", "replace")
        post_dict["MAIL"] = mail.encode("euc-jp", "replace")
        post_dict["MESSAGE"] = msg.encode("euc-jp", "replace")
        return post_dict

    def set_extra_dat_request(self, request, thread):
        datfile_url = request.get_full_url()
        if thread.num > 0:
            datfile_url += str(thread.num+1) + "-"
        headers = dict(request.header_items())
        try:
            del headers["Range".capitalize()]
            del headers["If-modified-since".capitalize()]
            del headers["If-none-match".capitalize()]
        except KeyError:
            pass
        request = urllib2.Request(datfile_url, headers=headers)
        return request
        
    def get_board_dir_path(self):
        """Returns board dir path from logs dir downward, not full path"""

        return self.bbs_type + "/" + self.board
