# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import traceback

from bbs_type_2ch import Type2ch
from bbs_type_yy import TypeYY
from bbs_type_jbbs import TypeJbbs
from bbs_type_other import TypeOther
from bbs_type_exception import BbsTypeError

_typelist = [Type2ch, TypeYY, TypeJbbs, TypeOther]

def get_type(uri):
    for type_class in _typelist:
        try:
            bbs = type_class(uri)
        except BbsTypeError:
            pass
        except:
            traceback.print_exc()
        else:
            return bbs

    raise BbsTypeError, \
          "Not found a fit bbs type for the uri: " + uri
