# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gconf
import traceback
import itertools

import misc
import config

interest_dict = dict([
    ("columns", (list, str)), 
    ("widths", (list, int)),
    ("sort_column", (str, None)),
    ("sort_reverse", (bool, None)),
    ("window_height", (int , None)),
    ("window_width", (int, None)),
    ("toolbar_visible", (bool, None)),
    ("statusbar_visible", (bool, None)),
    ("filterbar_visible", (bool, None))
    ])

default_states_dict = dict([
    ("columns", ()),
    ("widths", ()),
    ("sort_column", "num"),
    ("sort_reverse", False),
    ("window_height", 600),
    ("window_width", 600),
    ("toolbar_visible", True),
    ("statusbar_visible", True),
    ("filterbar_visible", False)])

def states_file_to_dict_generator(bbs_type):
    def adjust_type(key, value):

        def to_int(value):
            try:
                return int(value)
            except:
                return 0

        key_type, key_type_extra = interest_dict[key]
        if key_type == str:
            return key, value
        elif key_type == int:
            return key, to_int(value)
        elif key_type == bool:
            return key, value == "True"
        elif key_type == list:
            if key_type_extra == str:
                return key, value.split(",")
            elif key_type_extra == int:
                return key, [to_int(i) for i in value.split(",")]
            else:
                print key, "not supported",
                key_type, key_type_extra, value
        else:
            print key, "not supported", key_type, value

    iterable = file(misc.get_board_states_path(bbs_type))
    iterable = itertools.imap(lambda l: l.rstrip(), iterable)
    iterable = itertools.imap(misc.split_key_and_value, iterable)
    iterable = itertools.ifilter(None, iterable)
    iterable = misc.unpack_ifilter(lambda k,v: k in interest_dict, iterable)
    iterable = itertools.starmap(adjust_type, iterable)
    iterable = itertools.ifilter(None, iterable)
    return iterable

def load_gconf_generator():
    key_base = config.gconf_app_key_base() + "/board_states"
    gconf_client = gconf.client_get_default()
    width = gconf_client.get_int(key_base + "/window_width")
    if width != 0:
        yield "window_width", width
    height = gconf_client.get_int(key_base + "/window_height")
    if height != 0:
        yield "window_height", height
    yield "toolbar_visible", gconf_client.get_bool(key_base + "/toolbar")
    yield "statusbar_visible", gconf_client.get_bool(
        key_base + "/statusbar")
    yield "filterbar_visible", gconf_client.get_bool(
        key_base + "/filterbar")

def states_file_to_dict(bbs_type):
    states_dict = default_states_dict.copy()

    try:
        for key, value in load_gconf_generator(): states_dict[key] = value
    except:
        traceback.print_exc()

    try:
        for key, value in states_file_to_dict_generator(bbs_type):
            states_dict[key] = value
    except IOError:
        pass

    return states_dict
