# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import itertools

import misc

metadata_namelist = ("title", "lineCount", "lastModified", "idxlastModified")
recorded_data = ("id", "title", "lineCount", "lastModified", "idxlastModified")
int_data = ("lineCount", "idxlastModified")

def _empty_generator():
    for name in metadata_namelist:
        if name in int_data:
            yield name, 0
        else:
            yield name, ""

default_dict = dict([pair for pair in _empty_generator()])

def _tabbed_to_dict(tabbed):

    def adjust_type(key, value):
        if key in int_data:
            try:
                value = int(value)
            except:
                value = 0
        return key, value

    iterable = misc.tabbed_to_dict_generator(tabbed)
    iterable = misc.unpack_ifilter(lambda k, v: k in recorded_data, iterable)
    iterable = itertools.starmap(adjust_type, iterable)

    dic = default_dict.copy()
    for key, value in iterable:
        dic[key] = value

    return dic

def _dict_to_tabbed(dic):

    def validate(name, value):
        if name in int_data and value > 0:
            return True
        elif name not in int_data and value:
            return True
        return False
        
    iterable = dic.iteritems()

    # save metadata only if its name exists in metadata_namelist
    iterable = misc.unpack_ifilter(lambda n,v: n in metadata_namelist,iterable)

    # no need to save an empty or invalid field
    iterable = misc.unpack_ifilter(validate, iterable)

    iterable = itertools.starmap(lambda n,v: "%s=%s\t" % (n, str(v)), iterable)

    line = ""
    for tabbed in iterable:
        line += tabbed
    return line

def do_formatted_to_dict(formatted):
    dic = _tabbed_to_dict(formatted)
    if "id" in dic and dic["id"]:
        return dic
    
def formatted_to_dict(iterable):
    iterable = itertools.imap(do_formatted_to_dict, iterable)
    iterable = itertools.ifilter(None, iterable)
    return iterable

def do_dict_to_formatted(thread_id, dic):
    return "id=%s\t%s\n" % (thread_id, _dict_to_tabbed(dic))

def dict_to_formatted(iterable):
    return itertools.starmap(do_dict_to_formatted, iterable)
