# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os.path
import codecs
import fileinput

import misc

def get_dat_file_size(bbs_type):
    """Returns size of dat file"""
    dat_path = misc.get_thread_dat_path(bbs_type)
    if not os.path.exists(dat_path):
        return 0

    return os.path.getsize(dat_path)

def get_dat_line_count(bbs_type):
    """Returns the number of line of a dat file specified by bbs, board
    and thread

    bbs: bbs id

    board: board id

    thread: thread id
    """
    dat_path = misc.get_thread_dat_path(bbs_type)
    if not os.path.exists(dat_path):
        return 0

    f = fileinput.FileInput(dat_path)
    for l in f: -1
    return f.filelineno()

def get_title_from_dat(bbs_type):
    """Returns thread title in dat file

    bbs: bbs id

    board: board id

    thread: thread id

    If failed, return None
    """
    dat_path = misc.get_thread_dat_path(bbs_type)
    if not os.path.exists(dat_path):
        return None

    f = open(dat_path, "r")
    try:
        line = f.readline()
        return bbs_type.get_title_from_dat(line)
    finally:
        f.close()

def load_dat(bbs_type, func):
    """Loads entire dat and invokes func per one res

    bbs: bbs id

    board: board id

    thread: thread id

    func: is invoked per one res
    format of user function is:
    def some_func(line):
    where line is raw body of the res
    """
    dat_path = misc.get_thread_dat_path(bbs_type)
    if not os.path.exists(dat_path):
        return

    f = fileinput.FileInput(dat_path)
    for line in f:
        func(line)
    f.close()

def load_dat_partly(bbs_type, func, resnum):
    """Loads dat partly
    similar to load_dat, but load_dat_partly does not load entire dat.

    bbs: bbs id

    board: board id

    thread: thread id

    func: invoked per one res

    resnum: load downward resnum
    """
    dat_path = misc.get_thread_dat_path(bbs_type)
    if not os.path.exists(dat_path):
        return

    f = fileinput.FileInput(dat_path)
    for line in f:
        num = f.filelineno()
        if num >= resnum:
            func(line)
    f.close()
