# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import os.path
import traceback
import itertools

import misc

metadata_namelist = ("title", "lineCount", "lastModified", "etag")
int_data = ("lineCount")

def _empty_generator():
    for name in metadata_namelist:
        if name in int_data:
            yield name, 0
        else:
            yield name, ""

default_dict = dict([pair for pair in _empty_generator()])

def load_idx(bbs_type):
    """Loads index file of thread

    return dictionary which key is in metadata_namelist if idx file exist,
    otherwise return empty dic
    """
    idxfile_path = misc.get_thread_idx_path(bbs_type)
    datadic = default_dict.copy()

    def adjust_type(name, value):
        if name in int_data:
            try:
                value = int(value)
            except:
                value = 0
        return name, value

    try:
        iterable = itertools.imap(lambda l: l.rstrip(), file(idxfile_path))
        iterable = itertools.imap(misc.split_key_and_value, iterable)
        iterable = itertools.ifilter(None, iterable)
        iterable = misc.unpack_ifilter(
            lambda name, value: name in metadata_namelist, iterable)
        iterable = itertools.starmap(adjust_type, iterable)
        for name, value in iterable: datadic[name] = value
    except IOError:
        pass

    return datadic

def save_idx(bbs_type, datadic):
    """Saves thread metadatas to a index file

    datadic: dictionary which key is in metadata_namelist

    no need to save empty or non-existing metadata
    """

    def validate(name, value):
        if name in int_data and value > 0:
            return True
        elif name not in int_data and value:
            return True
        return False

    iterable = datadic.iteritems()

    # save metadata only if its name exists in metadata_namelist
    iterable = misc.unpack_ifilter(
        lambda name, value: name in metadata_namelist, iterable)

    # no need to save an empty or invalid field
    iterable = misc.unpack_ifilter(validate, iterable)

    # format
    iterable = itertools.starmap(lambda n,v: "%s=%s\n" % (n, str(v)), iterable)

    # write
    idx_file = misc.FileWrap(misc.get_thread_idx_path(bbs_type), "w")
    try:
        idx_file.writelines(iterable)
    except IOError:
        traceback.print_exc()
