# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import os.path
import codecs
import re
import pango
import urllib2
import urlparse
import gnome
import gobject
import threading
import gconf
import traceback
import itertools
import os
import sys

import misc
from misc import FileWrap, ThreadInvoker
import datfile
import barehtmlparser
import idxfile
import session
import board_window
import uri_opener
from http_sub import HTTPRedirectHandler302, HTTPDebugHandler
from BbsType import bbs_type_judge_uri
from BbsType import bbs_type_exception
import config
import winwrapbase
import bookmark_list
import bookmark_window

GLADE_FILENAME = "thread_window.glade"

def open_thread(uri, update=False):
    if not uri:
        raise ValueError, "parameter must not be empty"

    bbs_type = bbs_type_judge_uri.get_type(uri)
    if not bbs_type.is_thread():
        raise bbs_type_exception.BbsTypeError, \
              "the uri does not represent thread: " + uri
    uri = bbs_type.get_thread_uri()  # use strict thread uri

    winwrap = session.get_window(uri)
    if winwrap:
        # already opened
        winwrap.window.present()
        if update:
            winwrap.load(update)
    else:
        winwrap = WinWrap(bbs_type.uri)  # pass original uri
        winwrap.load(update)

    # jump to the res if necessary.
    winwrap.jump_to_res(bbs_type.uri)


class WinWrap(winwrapbase.WinWrapBase):
    hovering_over_link = False
    hand_cursor = gtk.gdk.Cursor(gtk.gdk.HAND2)
    regular_cursor = gtk.gdk.Cursor(gtk.gdk.XTERM)


    def __init__(self, uri):
        from BbsType import bbs_type_judge_uri
        from BbsType import bbs_type_exception
        self.bbs_type = bbs_type_judge_uri.get_type(uri)
        if not self.bbs_type.is_thread():
            raise bbs_type_exception.BbsTypeError, \
                  "the uri does not represent thread: " + uri
        self.size = 0
        self.num = 0
        self.title = ""
        self.lock_obj = False
        self.jump_request_num = 0
        self.progress = False

        glade_path = os.path.join(config.glade_dir, GLADE_FILENAME)
        self.widget_tree = gtk.glade.XML(glade_path)
        self.window = self.widget_tree.get_widget("thread_window")
        self.toolbar = self.widget_tree.get_widget("toolbar")
        self.toolbar.unset_style()
        self.statusbar = self.widget_tree.get_widget("appbar")
        self.textview = self.widget_tree.get_widget("textview")
        self.textview.drag_dest_unset()

        self.initialize_buffer()

        self.hint = HintWrap()

        sigdic = {"on_refresh_activate": self.update,
                  "on_compose_activate": self.on_compose_clicked,
                  "on_toolbar_activate": self.on_toolbar_activate,
                  "on_statusbar_activate": self.on_statusbar_activate,
                  "on_refresh_activate": self.update,
                  "on_close_activate": self.on_close_activate,
                  "on_quit_activate": self.on_quit_activate,
                  "on_show_board_activate": self.on_show_board_activate,
                  "on_delete_activate": self.on_delete_activate,
                  "on_thread_window_delete_event":
                  self.on_thread_window_delete_event,
                  "on_add_bookmark_activate": self.on_add_bookmark_activate,
                  "on_manage_bookmarks_activate": \
                  self.on_manage_bookmarks_activate,
                  "on_thread_window_destroy": self.on_thread_window_destroy}
        self.widget_tree.signal_autoconnect(sigdic)

        self.textview.connect("event-after", self.on_event_after)
        self.textview.connect("motion-notify-event",
                              self.on_motion_notify_event)
        self.textview.connect("visibility-notify-event",
                              self.on_visibility_notify_event)
        self.restore()
        self.window.show()

        self.created()

    def initialize_buffer(self):
        self.textbuffer = gtk.TextBuffer()
        self.textview.set_buffer(self.textbuffer)
        self.enditer = self.textbuffer.get_end_iter()
        self.boldtag = self.textbuffer.create_tag(weight=pango.WEIGHT_BOLD)
        self.leftmargintag = self.textbuffer.create_tag()
        self.leftmargintag.set_property("left-margin", 20)

    def destroy(self):
        self.save()
        self.window.destroy()

    def get_uri(self):
        return self.bbs_type.get_thread_uri()

    def on_compose_clicked(self, widget):
        import submit_window
        submit_window.open(self.bbs_type.get_thread_uri())

    def on_toolbar_activate(self, widget):
        if self.toolbar.parent.get_property("visible"):
            self.toolbar.parent.hide()
        else:
            self.toolbar.parent.show()

    def on_statusbar_activate(self, widget):
        if self.statusbar.get_property("visible"):
            self.statusbar.hide()
        else:
            self.statusbar.show()

    def on_event_after(self, widget, event):
        if event.type != gtk.gdk.BUTTON_RELEASE:
            return False
        if event.button != 1:
            return False
        buffer = widget.get_buffer()

        try:
            start, end = buffer.get_selection_bounds()
        except ValueError:
            pass
        else:
            if start.get_offset() != end.get_offset():
                return False

        x, y = widget.window_to_buffer_coords(
            gtk.TEXT_WINDOW_WIDGET, int (event.x), int(event.y))
        iter = widget.get_iter_at_location(x, y)
        if not iter.has_tag(self.leftmargintag) or x > 20:
            tags = iter.get_tags()
            for tag in tags:
                href = tag.get_data("href")
                if href:
                    self.on_link_clicked(widget, href)
        return False

    def on_link_clicked(self, widget, href):

        if not href.startswith("http://"):
            # maybe a relative uri.
            href = urlparse.urljoin(self.bbs_type.get_uri_base(), href)

        try:
            uri_opener.open_uri(href)
        except bbs_type_exception.BbsTypeError:
            # not supported, show with the web browser.
            gnome.url_show(href)

    def on_motion_notify_event(self, widget, event):
        x, y = widget.window_to_buffer_coords(
            gtk.TEXT_WINDOW_WIDGET, int(event.x), int(event.y))
        self.set_cursor_if_appropriate(widget, x, y)
        widget.window.get_pointer()
        return False

    def on_visibility_notify_event(self, widget, event):
        wx, wy, mod = widget.window.get_pointer()
        bx, by = widget.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET, wx, wy)

        self.set_cursor_if_appropriate(widget, bx, by)
        return False

    def set_cursor_if_appropriate(self, widget, x, y):
        hovering = False
        href = ""

        buffer = widget.get_buffer()
        iter = widget.get_iter_at_location(x, y)
        if not iter.has_tag(self.leftmargintag) or x > 20:
            tags = iter.get_tags()
            for tag in tags:
                href = tag.get_data("href")
                if href:
                    hovering = True

        if hovering != self.hovering_over_link:
            self.hovering_over_link = hovering

        if self.hovering_over_link:
            widget.get_window(gtk.TEXT_WINDOW_TEXT).set_cursor(
                self.hand_cursor)
            if href:
                if not href.startswith("http://"):
                    href = urlparse.urljoin(self.bbs_type.get_uri_base(), href)

                strict_uri = self.bbs_type.get_thread_uri()
                if href != strict_uri and href.startswith(strict_uri):
                    resnum = href[len(strict_uri):]
                    match = re.match("\d+", resnum)
                    if match:
                        resnum = int(match.group())
                        if not self.hint.visible(resnum):
                            mark = self.textbuffer.get_mark(str(resnum))
                            n_mark = self.textbuffer.get_mark(str(resnum+1))
                            if mark and n_mark:
                                iter = self.textbuffer.get_iter_at_mark(mark)
                                n_iter = self.textbuffer.get_iter_at_mark(
                                    n_mark)
                                text = self.textbuffer.get_text(
                                    iter, n_iter, False)
                                if text:
                                    iter = self.textview.get_iter_at_location(
                                        x, y)
                                    rect = self.textview.get_iter_location(
                                        iter)
                                    x, y = \
                                       self.textview.buffer_to_window_coords(
                                        gtk.TEXT_WINDOW_WIDGET, rect.x, rect.y)
                                    x, y = self.textview.translate_coordinates(
                                        self.window, x, y)
                                    wx, wy = self.window.get_position()
                                    x += wx
                                    y += wy
                                    y += rect.height
                                    self.hint.show(x, y, text, resnum)
        else:
            widget.get_window(gtk.TEXT_WINDOW_TEXT).set_cursor(
                self.regular_cursor)
            self.hint.destroy()

    def on_close_activate(self, widget):
        self.destroy()

    def on_thread_window_delete_event(self, widget, event):
        self.save()
        return False
        
    def on_thread_window_destroy(self, widget):
        self.destroyed()

    def on_quit_activate(self, widget):
        session.main_quit()

    def on_add_bookmark_activate(self, widget):
        bookmark_list.bookmark_list.add_bookmark_with_edit(
            name=self.title, uri=self.bbs_type.uri)

    def on_manage_bookmarks_activate(self, widget):
        bookmark_window.open()

    def on_show_board_activate(self, widget):
        board_window.open_board(self.bbs_type.get_uri_base())

    def on_delete_activate(self, widget):
        try:
            dat_path = misc.get_thread_dat_path(self.bbs_type)
            os.remove(dat_path)
        except OSError:
            traceback.print_exc()
        try:
            idx_path = misc.get_thread_idx_path(self.bbs_type)
            os.remove(idx_path)
        except OSError:
            traceback.print_exc()
        try:
            states_path = misc.get_thread_states_path(self.bbs_type)
            os.remove(states_path)
        except OSError:
            traceback.print_exc()

    def http_get_dat(self, on_get_res):
        datfile_url = self.bbs_type.get_dat_uri()

        idx_dic = idxfile.load_idx(self.bbs_type)
        lastmod = idx_dic["lastModified"]
        etag = idx_dic["etag"]

        req = urllib2.Request(datfile_url)
        req.add_header("User-agent", config.User_Agent)
        if self.size > 0:
            req.add_header("Range", "bytes=" + str(self.size) + "-")
        if lastmod:
            req.add_header("If-Modified-Since", lastmod)
        if etag:
            req.add_header("If-None-Match", etag)

        req = self.bbs_type.set_extra_dat_request(req, self)

        opener = urllib2.build_opener(HTTPRedirectHandler302, HTTPDebugHandler)
        try:
            res = opener.open(req)
        except urllib2.HTTPError, e:
            gobject.idle_add(
                self.statusbar.set_status, "%d %s" % (e.code, e.msg))
        else:
            headers = res.info()
            gobject.idle_add(
                self.statusbar.set_status, "%d %s" % (res.code, res.msg))

            maybe_incomplete = False
            for line in res:
                if not line.endswith("\n"):
                    maybe_incomplete = True
                    print "does not end with \\n. maybe incomplete"
                    break
                on_get_res(line)

            res.close()

            if maybe_incomplete:
                lastmod = None
                etag = None
            else:
                if "Last-Modified" in headers:
                    lastmod = headers["Last-Modified"]
                if "ETag" in headers:
                    etag = headers["Etag"]

            if self.num > 0:
                # save idx
                idx_dic = {"title": self.title, "lineCount": self.num,
                       "lastModified": lastmod, "etag": etag}
                idxfile.save_idx(self.bbs_type, idx_dic)

                gobject.idle_add(session.thread_idx_updated,
                                 self.bbs_type.get_thread_uri(), idx_dic)

    def update(self, widget=None):

        self.jump_request_num = 0

        def load():
            if self.num == 0:
                def create_mark():
                    self.textbuffer.create_mark("1", self.enditer, True)
                gobject.idle_add(create_mark)

            line_count = datfile.get_dat_line_count(self.bbs_type)
            if line_count < self.num:
                self.num = 0
                self.size = 0

                gobject.idle_add(self.initialize_buffer)

            if line_count > self.num:
                datfile.load_dat_partly(
                    self.bbs_type, self.append_rawres_to_buffer, self.num+1)

                def do_jump(num):
                    if self.jump_request_num:
                        if self.jump_request_num <= num:
                            # jump if enable, otherwize jump later.
                            num = self.jump_request_num
                            self.jump_request_num = 0
                            mark = self.textbuffer.get_mark(str(num))
                            if mark:
                                self.textview.scroll_to_mark(
                                    mark, 0, True, 0, 0)
                    else:
                        self.jump_to_the_end(num)

                gobject.idle_add(do_jump, self.num)

        def get():
            dat_path = misc.get_thread_dat_path(self.bbs_type)
            dat_file = FileWrap(dat_path)

            def save_line_and_append_to_buffer(line):
                dat_file.seek(self.size)
                dat_file.write(line)
                self.append_rawres_to_buffer(line)

            self.http_get_dat(save_line_and_append_to_buffer)
            dat_file.close()

            def do_jump():
                if self.jump_request_num:
                    num = self.jump_request_num
                    self.jump_request_num = 0
                    mark = self.textbuffer.get_mark(str(num))
                    if mark:
                        self.textview.scroll_to_mark(mark, 0, True, 0, 0)

            gobject.idle_add(do_jump)

        if self.lock():

            def on_end():
                self.un_lock()
                self.progress = False

            self.progress = True
            t = ThreadInvoker(lambda : gobject.idle_add(on_end), load, get)
            t.start()

    def load_dat(self):

        self.size = 0
        self.num = 0
        self.jump_request_num = 0

        def load():

            def create_mark():
                self.textbuffer.create_mark("1", self.enditer, True)
            gobject.idle_add(create_mark)

            datfile.load_dat(self.bbs_type, self.append_rawres_to_buffer)
        def jump():

            def do_jump(num):
                if self.jump_request_num:
                    num = self.jump_request_num
                    self.jump_request_num = 0
                    mark = self.textbuffer.get_mark(str(num))
                    if mark:
                        self.textview.scroll_to_mark(mark, 0, True, 0, 0)
                else:
                    self.jump_to_the_end(num)

            gobject.idle_add(do_jump, self.num)

        if self.lock():

            def on_end():
                self.un_lock()
                self.progress = False

            self.progress = True
            t = ThreadInvoker(lambda : gobject.idle_add(on_end), load, jump)
            t.start()

    def append_rawres_to_buffer(self, line):
        self.size += len(line)
        self.num += 1

        if not self.title and self.num == 1:
            title = self.bbs_type.get_title_from_dat(line)
            if title:
                self.title = title
                gobject.idle_add(self.window.set_title, title)

        self.res_queue = []

        line = line.decode(self.bbs_type.encoding, "replace")
        m = self.bbs_type.dat_reg.match(line)
        if m:
            name = m.group("name")
            mail = m.group("mail")
            date = m.group("date")
            msg = m.group("msg")
            try:
                num = int(m.group("num"))
            except IndexError:
                # use simple counter num
                num = self.num
            else:
                # use num in dat
                self.num = num
            try:
                id = m.group("id")
            except IndexError:
                pass
            else:
                if id:
                    date += " ID:" + id
            self.reselems_to_buffer(num, name, mail, date, msg)
        else:
            self.res_queue.append((str(self.num)+"\n", False, None, False))
            self.res_queue.append((line, False, None, True))
            print "maybe syntax error.", self.num, line

        def process_res_queue(res_queue, num):
            self.process_queue(res_queue)
            # for next res
            self.textbuffer.create_mark(str(num+1), self.enditer, True)

        gobject.idle_add(
            process_res_queue, self.res_queue, self.num)

    def reselems_to_buffer(self, num, name, mail, date, msg):
        p = barehtmlparser.BareHTMLParser(
            lambda d,b,h: self.res_queue.append((d,b,h,False)))
        # number
        p.feed(str(num) + " ")

        # name
        p.feed("<b>" + name + "</b>")

        # mail
        p.feed("[" + mail + "]")

        # date
        p.feed(date)
        p.feed("<br>")

        # msg
        p.reset_func(lambda d,b,h: self.res_queue.append((d,b,h,True)))
        p.feed(msg.lstrip(" "))

        p.feed("<br><br>")
        p.close()

    def href_tag(self, href):
        tag = self.textbuffer.create_tag(underline=pango.UNDERLINE_SINGLE)
        tag.set_data("href", href)
        return tag

    def process_queue(self, queue):
        for data, bold, href, margin in queue:
            taglist = []
            if bold:
                taglist.append(self.boldtag)
            if href:
                taglist.append(self.href_tag(href))
            if margin:
                taglist.append(self.leftmargintag)

            if taglist:
                self.textbuffer.insert_with_tags(self.enditer, data, *taglist)
            else:
                self.textbuffer.insert(self.enditer, data)

    def jump_to_the_end(self, num):
        mark = self.textbuffer.get_mark(str(num+1))
        if mark:
            self.textview.scroll_to_mark(mark, 0)

    def lock(self):
        if self.lock_obj:
            print "locked, try later."
            return False
        else:
            print "get lock"
            self.lock_obj = True
            return True

    def un_lock(self):
        self.lock_obj = False
        print "unlock"

    def jump_to_res(self, uri):
        strict_uri = self.bbs_type.get_thread_uri()
        if uri != strict_uri and uri.startswith(strict_uri):
            resnum = uri[len(strict_uri):]
            match = re.match("\d+", resnum)
            if match:
                resnum = match.group()
                mark = self.textbuffer.get_mark(resnum)
                if mark:
                    self.textview.scroll_to_mark(mark, 0, True, 0, 0)
                elif self.progress:
                    # try later.
                    self.jump_request_num = int(resnum)

    def load(self, update=False):
        dat_path = misc.get_thread_dat_path(self.bbs_type)
        dat_exists = os.path.exists(dat_path)
        if update or not dat_exists:
            self.update()
        else:
            self.load_dat()

    def save(self):
        try:
            states_path = misc.get_thread_states_path(self.bbs_type)
            dat_path = misc.get_thread_dat_path(self.bbs_type)

            # save only if dat file exists.
            if os.path.exists(dat_path):
                window_width, window_height = self.window.get_size()
                toolbar_visible = self.toolbar.parent.get_property("visible")
                statusbar_visible = self.statusbar.get_property("visible")

                dirname = os.path.dirname(states_path)
                if not os.path.isdir(dirname):
                    os.makedirs(dirname)

                f = file(states_path, "w")

                f.write("window_width=" + str(window_width) + "\n")
                f.write("window_height=" + str(window_height) + "\n")
                f.write("toolbar_visible=" + str(toolbar_visible) + "\n")
                f.write("statusbar_visible=" + str(statusbar_visible) + "\n")

                f.close()
        except:
            traceback.print_exc()

    def restore(self):
        try:
            window_height = 600
            window_width = 600
            toolbar_visible = True
            statusbar_visible = True

            try:
                key_base = config.gconf_app_key_base() + "/thread_states"
                gconf_client = gconf.client_get_default()
                width = gconf_client.get_int(key_base + "/window_width")
                height = gconf_client.get_int(key_base + "/window_height")
                toolbar_visible = gconf_client.get_bool(
                    key_base + "/toolbar")
                statusbar_visible = gconf_client.get_bool(
                    key_base + "/statusbar")
                if width != 0:
                    window_width = width
                if height != 0:
                    window_height = height
            except:
                traceback.print_exc()

            states_path = misc.get_thread_states_path(self.bbs_type)
            if os.path.exists(states_path):
                for line in file(states_path):
                    if line.startswith("window_height="):
                        height = window_height
                        try:
                            height = int(
                                line[len("window_height="):].rstrip("\n"))
                        except:
                            pass
                        else:
                            window_height = height
                    elif line.startswith("window_width="):
                        width = window_width
                        try:
                            width = int(
                                line[len("window_width="):].rstrip("\n"))
                        except:
                            pass
                        else:
                            window_width = width
                    elif line.startswith("toolbar_visible="):
                        tbar = line[len("toolbar_visible="):].rstrip("\n")
                        toolbar_visible = tbar == "True"
                    elif line.startswith("statusbar_visible="):
                        sbar = line[len("statusbar_visible="):].rstrip("\n")
                        statusbar_visible = sbar == "True"

            self.window.set_default_size(window_width, window_height)

            if not toolbar_visible:
                gobject.idle_add(self.toolbar.parent.hide,
                                 priority=gobject.PRIORITY_HIGH)
            if not statusbar_visible:
                gobject.idle_add(self.statusbar.hide,
                                 priority=gobject.PRIORITY_HIGH)
        except:
            traceback.print_exc()


class HintWrap:

    def __init__(self):
        self.window = None
        self.textview = None
        self.nums = None

    def __del__(self):
        print "destruct"
        self.destroy()

    def destroy(self):
        if self.window:
            self.window.destroy()
        self.window = None
        self.textview = None
        self.nums = None

    def show(self, x, y, text, *nums):
        self.destroy()

        self.window = gtk.Window(gtk.WINDOW_POPUP)
        self.window.set_default_size(400, 10)
        self.window.move(x, y)

        self.textview = gtk.TextView()
        self.window.add(self.textview)

        self.textview.set_wrap_mode(gtk.WRAP_CHAR)
        self.textview.set_editable(False)

        buffer = self.textview.get_buffer()
        buffer.set_text(text.rstrip())
        self.nums = nums

        self.window.show_all()

    def visible(self, *nums):
        if not self.nums or len(self.nums) != len(nums):
            return False

        for num, mun in itertools.izip(self.nums, nums):
            if num != mun:
                return False
        return True
