/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DIRVIEW_H__
#define __DIRVIEW_H__

typedef enum {
	IMAGE,
	ARCHIVE,
	DIRECTORY,
	BACKUP,
	OTHER
} FbFileType;

enum {
	COLUMN_TYPE,           /* file type (gint)*/
	COLUMN_PATH,           /* file absolute path (gchar)*/
	COLUMN_SIZE,           /* file size (gint)*/
	COLUMN_MTIME,          /* file mtime (glong)*/
	COLUMN_READABLE,       /* file readable (gboolean) */
	COLUMN_ICON,           /* stock icon id (gchar)*/
	COLUMN_ICON_SIZE,      /* stock icon size (gint)*/
	COLUMN_DISPLAY_PATH,   /* (gchar) */
	COLUMN_PERMISSION,     /* permisson (gchar) */
	COLUMN_OWNER,          /* owner (gchar) */
	COLUMN_GROUP,          /* group (gchar) */
	COLUMN_DISPLAY_SIZE,   /* (gchar) */
	COLUMN_DISPLAY_MTIME,  /* (gchar) */
	COLUMN_EDITABLE,       /* row editable (gboolean) */
	NUM_COLUMNS
};

typedef enum {
	SORT_BY_NAME,
	SORT_BY_SIZE,
	SORT_BY_MTIME,
	SORT_BY_TYPE
} FbDirViewSortMode;

typedef struct MimeTypeEntry
{
	const gchar  *mime_type;

	const gchar  *description;

	const gchar **extensions;
	const gint    extensions_len;
	const gchar *icon;
} MimeTypeEntry;

gchar *str_local_to_utf8(gchar *string);
gchar *str_utf8_to_local(gchar *string);
gboolean is_imagefile(gchar *name);
gboolean is_archive(gchar *name);

GtkWidget *fb_dirview_new(Futaba *futaba);
void fb_dirview_edit_row(Futaba *futaba);
void fb_dirview_set_preview(Futaba *futaba,
			    gboolean show_preview);
gboolean fb_dirview_set_dir(Futaba *futaba,
			    gchar *path);
gboolean fb_dirview_set_history(Futaba *futaba,
				gchar *path);
void fb_dirview_add_file(Futaba *futaba,
			 gchar *path);
void fb_dirview_add_new_dir(Futaba *futaba);
gboolean fb_dirview_rename(Futaba *futaba,
			   GtkTreeIter iter,
			   gchar *name);
GList *fb_dirview_get_path(Futaba *futaba,
			   FbFileType type);
void fb_dirview_remove(Futaba *futaba,
		       GtkTreeIter iter);
void fb_dirview_remove_row(Futaba *futaba,
			   gint nth);
void fb_dirview_remove_at_cursor(Futaba *futaba);
/* deprecate under func, becase will write newly code
   (gboolean fb_dirview_get_at_cursor(Futaba *futaba, ...);). */
gboolean fb_dirview_get_readable_at_cursor(Futaba *futaba);
gchar *fb_dirview_get_path_at_cursor(Futaba *futaba);
FbFileType fb_dirview_get_type_at_cursor(Futaba *futaba);
/* end */
void fb_dirview_set_sort_mode(Futaba *futaba,
			      FbDirViewSortMode mode);
void fb_dirview_row_activated(Futaba *futaba);

#endif /* __DIRVIEW_H__ */
