/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "futaba.h"
#include "futaba_ui.h"
#include "dirview.h"
#include "imageviewer.h"
#include "rcfile.h"
#include "bookmark.h"
#include "history.h"

gint futaba_width;
gint futaba_height;
gboolean home_start;
gchar *home_page = NULL;
gchar *last_page = NULL;

static void cb_delete(GtkObject *object, gpointer data);

static void
cb_delete(GtkObject *object,
	  gpointer data)
{
	Futaba *futaba = data;

	futaba_quit(futaba);
}

Futaba *
futaba_new(void)
{
	GtkUIManager *ui_manager;
	GtkWidget *top;
	GtkWidget *vbox, *bar, *win;
	GtkWidget *tool_bar, *location_bar, *status_bar;
	Futaba *futaba = g_new0(Futaba, 1);

	/* prepare */
	ui_manager = fb_ui_new(futaba);
	if (!ui_manager) return NULL;

	/* top widget */
	top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(GTK_WIDGET(top), 130, 150);
	gtk_window_set_title(GTK_WINDOW(top), "Futaba");
	gtk_window_set_default_size(GTK_WINDOW(top), futaba_width, futaba_height);
	gtk_window_add_accel_group(GTK_WINDOW(top), gtk_ui_manager_get_accel_group(ui_manager));
	g_signal_connect(G_OBJECT(top), "destroy",
			 G_CALLBACK(cb_delete), futaba);

	/* set child widget */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(top), vbox);
	gtk_widget_show(vbox);

	/* add menubar */
	bar = gtk_ui_manager_get_widget(ui_manager, "/MenuBar");
	gtk_box_pack_start(GTK_BOX(vbox), bar, FALSE, FALSE, 0);
	gtk_widget_show(bar);

	/* add toolbar */
	tool_bar = gtk_ui_manager_get_widget(ui_manager, "/ToolBar");
	gtk_toolbar_set_style(GTK_TOOLBAR(tool_bar), GTK_TOOLBAR_ICONS);
	gtk_box_pack_start(GTK_BOX(vbox), tool_bar, FALSE, FALSE, 0);
	gtk_widget_show(tool_bar);

	/* add locationbar */
	location_bar = fb_locationbar_new(futaba);
	gtk_box_pack_start(GTK_BOX(vbox), location_bar, FALSE, FALSE, 0);
	gtk_widget_show(bar);

	/* add dirview and preview */
	win = fb_dirview_new(futaba);
	gtk_box_pack_start(GTK_BOX(vbox), win, TRUE, TRUE, 0);
	gtk_widget_show(win);

	/* add statusbar */
	status_bar = fb_statusbar_new();
	gtk_box_pack_start(GTK_BOX(vbox), status_bar, FALSE, FALSE, 0);
	gtk_widget_show(status_bar);

	gtk_widget_show_all(top);

	/* set members */
	futaba->top = top;
	futaba->tool_bar = tool_bar;
	futaba->location_bar = location_bar;
	futaba->status_bar = status_bar;
	futaba->ui_manager = ui_manager;

	futaba->width = futaba_width;
	futaba->height = futaba_height;

	futaba->dot_filter = TRUE;
	futaba->other_filter = TRUE;
	futaba->show_preview = TRUE;

	futaba->bookmarks = NULL;
	futaba->history = fb_dir_history_new();

	futaba->viewer_list = NULL;
	futaba->viewer = NULL;
	futaba->thumbwin_list = NULL;
	futaba->thumbwin = NULL;

	futaba->workdir = NULL;
	futaba->writable = FALSE;
	futaba->image_num = 0;

	futaba->paste_path = NULL;
	futaba->is_copy = TRUE;

	return futaba;
}

void
futaba_quit(Futaba *futaba)
{
	if (futaba->top) {
		futaba_width = futaba->top->allocation.width;
		futaba_height = futaba->top->allocation.height;
	}

	last_page = futaba->workdir;

	gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(futaba->liststore),
				       &sort_mode, &sort_direction);
	
	save_options();
	fb_save_bookmark(futaba);

	gtk_main_quit();
}

int
main(int argc, char **argv)
{
	Futaba *futaba;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	/* GTK Initialize */
	/*   gtk_set_locale(); */
	gtk_init(&argc,&argv);

	load_options();
	fb_icon_add_stock();

	futaba = futaba_new();
	if (!futaba) exit(-1);

	fb_menu_init_bookmark(futaba);
	fb_dirview_set_dir(futaba, home_page);

	gtk_main();

	return 0;
}
