/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "futaba.h"
#include "prefs.h"

#include "prefs_general.h"
#include "prefs_viewer.h"
#include "prefs_filter.h"

enum{
	CONTENTS,
	PREFERENCES
};

#define PREF_DIALOG_W 500
#define PREF_DIALOG_H 400

static void cb_change_page(GtkTreeView *tree, gpointer data);
static GtkWidget *content_list_new(FbPrefsWin *win);

static void fb_prefs_win_class_init(FbPrefsWinClass *klass);
static void fb_prefs_win_init(FbPrefsWin *win);
static void fb_prefs_win_finalize(GObject *object);
static void fb_prefs_win_apply(FbPrefsWin *win);
static void fb_prefs_win_response(GtkDialog *dialog, gint arg);

static GtkDialogClass *parent_class = NULL;

/*
 *------------------------------------------------------
 *        contents list     
 *------------------------------------------------------
 */

static void
cb_change_page(GtkTreeView *tree,
	       gpointer data)
{
	gint *n;
	gchar *content, *text;
	GtkTreeIter iter;
	GtkTreePath *tpath;
	GtkTreeModel *model;
	FbPrefsWin *win = data;

	gtk_tree_view_get_cursor(tree, &tpath, NULL);
	if (!tpath) tpath = gtk_tree_path_new_first();
	n = gtk_tree_path_get_indices(tpath);

	gtk_notebook_set_current_page(GTK_NOTEBOOK(win->note), *n);

	model = gtk_tree_view_get_model(tree);
	gtk_tree_model_get_iter(model, &iter, tpath);
	gtk_tree_model_get(model, &iter, CONTENTS, &content, -1);
	text = g_strconcat("<span weight=\"bold\" size=\"x-large\">", content,"</span>", NULL);
	gtk_label_set_markup(GTK_LABEL(win->title), text);

	gtk_tree_path_free(tpath);
	g_free(content);
	g_free(text);
}

static GtkWidget *
content_list_new(FbPrefsWin *win)
{
	gint i;
	gchar content[][8] = {
		N_("General"),
		N_("Viewer"),
		N_("Filter")
	};
	GtkListStore *store;
	GtkTreeIter iter;
	GtkTreeViewColumn *column;
	GtkCellRenderer *render;
	GtkWidget *list;

	list = gtk_tree_view_new();
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(list), TRUE);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(list), FALSE);
	g_signal_connect(G_OBJECT(list), "cursor_changed",
			 G_CALLBACK(cb_change_page), win);
	gtk_widget_show(list);

	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_max_width(column, 150);
	gtk_tree_view_column_set_min_width(column, 100);
	gtk_tree_view_append_column(GTK_TREE_VIEW(list), column);

	render = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(column, render, TRUE);
	gtk_tree_view_column_add_attribute(column, render, "text", CONTENTS);

	store = gtk_list_store_new(PREFERENCES,
				   G_TYPE_STRING);
	gtk_tree_view_set_model(GTK_TREE_VIEW(list), GTK_TREE_MODEL(store));

	for (i = 0; i < 3; i++) {
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter,
				   CONTENTS, _(content[i]),
				   -1);
	}

	return list;
}
/*
 *-------------------------------------------------
 *           preferences dialog
 *-------------------------------------------------
 */
GType
fb_prefs_win_get_type(void)
{
	static GType object_type = 0;

	if (!object_type) {
		static const GTypeInfo object_info = {
			sizeof (FbPrefsWinClass),
			NULL, /* base_init */
			NULL, /* base_finalize */
			(GClassInitFunc) fb_prefs_win_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (FbPrefsWin),
			32, /* n_preallocs */
			(GInstanceInitFunc) fb_prefs_win_init,
		};
		
		object_type = g_type_register_static(GTK_TYPE_DIALOG, "FbPrefsWin",
						     &object_info, 0);
	}

	return object_type;
}

static void
fb_prefs_win_class_init(FbPrefsWinClass *klass)
{
	GObjectClass *object_class;
	GtkDialogClass *dialog_class;
	GtkWidgetClass *widget_class;

	parent_class = g_type_class_peek_parent(klass);
	object_class = (GObjectClass *) klass;
	dialog_class = (GtkDialogClass *) klass;
	widget_class = (GtkWidgetClass *) klass;

	object_class->finalize = fb_prefs_win_finalize;
	
	dialog_class->response = fb_prefs_win_response;

}

static void
fb_prefs_win_init(FbPrefsWin *win)
{
	GList *page_list = NULL;
	GtkWidget  *main_hbox, *hbox, *vbox;
	GtkWidget *list, *title, *sepa, *note, *page;

	gtk_window_set_default_size(GTK_WINDOW(win), PREF_DIALOG_W, PREF_DIALOG_H);

	gtk_dialog_add_buttons(GTK_DIALOG(win),
			       GTK_STOCK_APPLY, GTK_RESPONSE_APPLY,
			       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			       GTK_STOCK_OK, GTK_RESPONSE_OK,
			       NULL);

	main_hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), main_hbox, TRUE, TRUE, 10);
	gtk_widget_show(main_hbox);

	/* contents list */
	list = content_list_new(win);
	gtk_box_pack_start(GTK_BOX(main_hbox), list, FALSE, TRUE, 0);
	gtk_widget_show(list);

	/* display */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(main_hbox), vbox, TRUE, TRUE, 5);
	gtk_widget_show(vbox);

	/* title */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	title = gtk_label_new(NULL);
	gtk_box_pack_start(GTK_BOX(hbox), title, FALSE, FALSE, 5);
	gtk_widget_show(title);

	sepa = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), sepa, FALSE, FALSE, 0);
	gtk_widget_show(sepa);

	/* menu */
	note = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(note), FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(note), FALSE);
	gtk_box_pack_end(GTK_BOX(vbox), note, TRUE, TRUE, 0);
	gtk_widget_show(note);

	gtk_notebook_append_page(GTK_NOTEBOOK(note), prefs_general_new(), NULL);
	gtk_notebook_append_page(GTK_NOTEBOOK(note), prefs_viewer_new(), NULL);
	gtk_notebook_append_page(GTK_NOTEBOOK(note), prefs_filter_new(), NULL);

	page_list = g_list_append(page_list, prefs_general_get_func());
	page_list = g_list_append(page_list, prefs_viewer_get_func());
	page_list = g_list_append(page_list, prefs_filter_get_func());

	win->title = title;
	win->note = note;
	win->page_list = page_list;
}

GtkWidget *
fb_prefs_win_new(void)
{
	GObject *object;

	object = g_object_new(FB_TYPE_PREFS_WIN,
			      "title", _("Preference - Futaba"),
			      NULL);

	return GTK_WIDGET(object);
}

static void
fb_prefs_win_finalize(GObject *object)
{
	GList *node, *page_list;

	page_list = g_list_first(FB_PREFS_WIN(object)->page_list);

	for (node = page_list; node; node = g_list_next(node)) {
		FbPrefsFunc *func = node->data;

		if (func->destroy) func->destroy();
	}

	g_list_free(page_list);

	if (G_OBJECT_CLASS(parent_class)->finalize)
		G_OBJECT_CLASS(parent_class)->finalize(object);
}

static void
fb_prefs_win_apply(FbPrefsWin *win)
{
	GList *node, *page_list;

	page_list = g_list_first(win->page_list);

	for (node = page_list; node; node = g_list_next(node)) {
		FbPrefsFunc *func = node->data;

		if (func->apply) func->apply();
	}

}

static void
fb_prefs_win_response(GtkDialog *dialog,
		      gint arg)
{

	switch (arg) {
	case GTK_RESPONSE_APPLY:
		fb_prefs_win_apply(FB_PREFS_WIN(dialog));
		break;
	case GTK_RESPONSE_OK:
		fb_prefs_win_apply(FB_PREFS_WIN(dialog));
		gtk_widget_destroy(GTK_WIDGET(dialog));
		break;
	case GTK_RESPONSE_CANCEL:
		gtk_widget_destroy(GTK_WIDGET(dialog));
		break;
	default:
		break;
	}
}
