/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "futaba.h"
#include "rcfile.h"

void
load_options(void)
{
	FILE *rc;
	gchar *rc_dir, *path;
	gchar buf[1024];
	gchar **contents;
	gchar *option, *value;

	rc_dir = g_strconcat(g_get_home_dir(), FUTABA_RC_DIR, NULL);
	path = g_strconcat(rc_dir, RC_FILE, NULL);

	if (!g_file_test(path, G_FILE_TEST_EXISTS)) {
		futaba_width = 600;
		futaba_height = 500;
		viewer_width = 300;
		viewer_height = 400;
		zoom_scale = 2.0;
		zoom_width = 150;
		zoom_height = 150;
		pdir_filter = FALSE;
		cdir_filter = FALSE;
		thumbwin_width = 600;
		thumbwin_height = 500;
		show_coltitle = FALSE;
		show_col1 = FALSE;
		show_col2 = FALSE;
		show_col3 = FALSE;
		show_col4 = FALSE;
		show_col5 = FALSE;
		sort_mode = 3;
		sort_direction = GTK_SORT_ASCENDING;
		home_start = TRUE;
		home_page = g_strdup(g_get_home_dir());

		g_free(rc_dir);
		g_free(path);

		return;
	}

	rc = fopen(path, "r");
	g_free(path);
	if (rc == NULL) return;

	while (fgets(buf, 1024, rc)) {
		if (buf[0] == '#') continue;
		if (buf[0] == '\n') continue;

		contents = g_strsplit(buf, ":", 2);
		option = g_strstrip(g_strdup(*contents));
		value = g_strstrip(g_strdup(*(contents + 1)));
		g_strfreev(contents);

		if (!g_ascii_strcasecmp("futaba_width", option))
			futaba_width = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("futaba_height", option))
			futaba_height = (gint) g_ascii_strtod(value, NULL);
		if (!g_ascii_strcasecmp("viewer_width", option))
			viewer_width = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("viewer_height", option))
			viewer_height = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("zoom_scale", option))
			zoom_scale = g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("zoom_width", option))
			zoom_width = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("zoom_height", option))
			zoom_height = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("pdir_filter", option))
			pdir_filter = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("cdir_filter", option))
			cdir_filter = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("thumbwin_width", option))
			thumbwin_width = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("thumbwin_height", option))
			thumbwin_height = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_coltitle", option))
			show_coltitle = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_col1", option))
			show_col1 = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_col2", option))
			show_col2 = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_col3", option))
			show_col3 = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_col4", option))
			show_col4 = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("show_col5", option))
			show_col5 = (gboolean) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("sort_mode", option))
			sort_mode = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("sort_direction", option))
			sort_direction = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("home_start", option))
			home_start = (gint) g_ascii_strtod(value, NULL);
		else if (!g_ascii_strcasecmp("home_page", option))
			home_page = g_strdup(value);
		else if (!g_ascii_strcasecmp("last_page", option))
			last_page = g_strdup(value);

		g_free(option);
		g_free(value);
	}
	fclose(rc);

	if (futaba_width < 100) futaba_width = 600;
	if (futaba_height < 100) futaba_height = 500;
	if (viewer_width < 50) viewer_width = 300;
	if (viewer_height < 50) viewer_height = 400;
	if (zoom_width < 10) zoom_width = 160;
	if (zoom_height < 10) zoom_height = 160;
	if (zoom_scale <= 1.0) zoom_scale = 2.0;
	if (thumbwin_width < 50) thumbwin_width = 500;
	if (thumbwin_height < 50) thumbwin_height = 400;

	if (home_start && home_page)
		home_page = g_strdup(g_get_home_dir());	
	else
		home_page = g_strdup(last_page);

	path = g_strconcat(rc_dir, ACCEL_FILE, NULL);
	gtk_accel_map_load(path);

	g_free(rc_dir);
	g_free(path);
}

void
save_options(void)
{
	FILE *rc;
	gchar *rc_dir, *rc_path, *accel;

	rc_dir = g_strconcat(g_get_home_dir(), FUTABA_RC_DIR, NULL);
	if (!g_file_test(rc_dir, G_FILE_TEST_IS_DIR))
		mkdir(rc_dir, S_IRWXU);

	rc_path = g_strconcat(rc_dir, RC_FILE, NULL);

	rc = fopen(rc_path, "w");
	g_free(rc_path);

	if (!rc) {
		g_free(rc_dir);
      
		return;
	}

	g_fprintf(rc, "#######################################################\n");
	g_fprintf(rc, "#                                                     #\n");
	g_fprintf(rc, "#######################################################\n");
	g_fprintf(rc, "\n");
	g_fprintf(rc, "futaba_width: %d\n", futaba_width);
	g_fprintf(rc, "futaba_height: %d\n", futaba_height);
	g_fprintf(rc, "viewer_width: %d\n", viewer_width);
	g_fprintf(rc, "viewer_height: %d\n", viewer_height);
	g_fprintf(rc, "thumbwin_width: %d\n", thumbwin_width);
	g_fprintf(rc, "thumbwin_height: %d\n", thumbwin_height);
	g_fprintf(rc, "zoom_scale: %2.1f\n", zoom_scale);
	g_fprintf(rc, "zoom_width: %d\n", zoom_width);
	g_fprintf(rc, "zoom_height: %d\n", zoom_height);
	g_fprintf(rc, "cdir_filter: %d\n", cdir_filter);
	g_fprintf(rc, "pdir_filter: %d\n", pdir_filter);
	g_fprintf(rc, "show_col1: %d\n", show_col1);
	g_fprintf(rc, "show_col2: %d\n", show_col2);
	g_fprintf(rc, "show_col3: %d\n", show_col3);
	g_fprintf(rc, "show_col4: %d\n", show_col4);
	g_fprintf(rc, "show_col5: %d\n", show_col5);
	g_fprintf(rc, "sort_mode: %d\n", sort_mode);
	g_fprintf(rc, "sort_direction: %d\n", sort_direction);
	g_fprintf(rc, "home_start: %d\n", home_start);
	g_fprintf(rc, "home_page: %s\n", home_page);
	g_fprintf(rc, "last_page: %s\n", last_page);
	g_fprintf(rc, "\n");

	fclose(rc);

	accel = g_strconcat(rc_dir, ACCEL_FILE, NULL);
	gtk_accel_map_save(accel);

	g_free(rc_dir);
	g_free(accel);
}
