/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <unistd.h>

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "futaba.h"
#include "fb-window.h"
#include "fb-dirview.h"
#include "fb-dialog.h"
#include "fb-pathmenuitem.h"
#include "file-utils.h"

/*
 *---------------------------------------------------------
 *       Bookmark Editer
 *---------------------------------------------------------
 */
#define DEFAULT_EDITER_W 400
#define DEFAULT_EDITER_H 300

enum {
	PATH,
	EDITABLE,
	BOOKMARKS
};

typedef struct _BookmarkEditer {
	GtkWidget *dlg;
	GtkWidget *entry;
	GtkWidget *tview;
	GtkListStore *store;
} BookmarkEditer;

static void
store_set_bookmark (GtkListStore *store,
		    FbWindow *fb)
{
	const gchar *path;
	gchar *set_path;
	GList *child;
	GtkTreeIter iter;
	GtkWidget *item, *menu;

	g_return_if_fail (FB_IS_WINDOW (fb));

	item = gtk_ui_manager_get_widget (fb->ui_manager, "/MenuBar/BookmarkMenu");
	menu = gtk_menu_item_get_submenu (GTK_MENU_ITEM (item));

	child = gtk_container_get_children (GTK_CONTAINER (menu));
	for (; child; child = child->next) {
		if (! FB_IS_PATH_MENU_ITEM (child->data))
			continue;

		path = fb_path_menu_item_get_path (FB_PATH_MENU_ITEM (child->data));
		set_path = g_locale_to_utf8 (path, -1, NULL, NULL, NULL);
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter,
				    PATH, set_path,
				    -1);
		g_free (set_path);
	}

}

static void
cb_add_bookmark (GtkEntry *entry,
		 gpointer data)
{
	GtkDialog *dlg = data;

	gtk_dialog_response (dlg, GTK_RESPONSE_ACCEPT);
}

static void
cb_editer_res (GtkDialog *dlg,
	       gint arg,
	       gpointer data)
{
	FbWindow *fb = data;
	BookmarkEditer *editer = g_object_get_data (G_OBJECT (dlg), "BookmarkEditer");

	switch (arg) {
	case GTK_RESPONSE_REJECT: {
		gint *nth;
		GtkTreeIter iter;
		GtkTreePath *path;

		gtk_tree_view_get_cursor(GTK_TREE_VIEW(editer->tview), &path, NULL);
		if (! path) return;

		nth = gtk_tree_path_get_indices(path);

		gtk_tree_model_get_iter(GTK_TREE_MODEL (editer->store), &iter, path);
		gtk_list_store_remove(editer->store, &iter);

		fb_window_remove_bookmark (fb, *nth);

		gtk_tree_path_free(path);
	}
		break;
	case GTK_RESPONSE_ACCEPT: {
		gchar *text, *locale;
		GtkTreeIter iter;

		text = gtk_editable_get_chars(GTK_EDITABLE(editer->entry), 0, -1);
		locale = g_locale_to_utf8(text, -1, NULL, NULL, NULL);

		if (! path_is_exists(locale)) {
			GtkWidget *err_dlg;

			err_dlg = gtk_message_dialog_new (GTK_WINDOW (dlg), GTK_DIALOG_MODAL,
							  GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
							  _("The path don't exist"));
			g_signal_connect_swapped (G_OBJECT (err_dlg), "response",
						  G_CALLBACK (gtk_widget_destroy), err_dlg);
			gtk_widget_show (err_dlg);

			g_free (locale);

			return;
		}

		gtk_list_store_append(editer->store, &iter);
		gtk_list_store_set(editer->store, &iter,
				   PATH, locale,
				   -1);
		fb_window_add_bookmark (fb, locale);

		gtk_editable_delete_text(GTK_EDITABLE(editer->entry), 0, -1);

		g_free (locale);
	}
		break;
	case GTK_RESPONSE_OK: {
		gtk_widget_destroy (GTK_WIDGET (dlg));
	}
		break;
	}
}

GtkWidget *
fb_bookmark_editer_new (FbWindow *fb)
{
	GtkWidget *hbox, *scroll, *label;
	GtkCellRenderer *render;
	GtkTreeViewColumn *column;
	BookmarkEditer *editer = g_new0 (BookmarkEditer, 1);

	editer->dlg = gtk_dialog_new_with_buttons(_("Bookmark Editor - Futaba"),
					     GTK_WINDOW(fb),
					     GTK_DIALOG_MODAL |
					     GTK_DIALOG_NO_SEPARATOR,
					     GTK_STOCK_REMOVE, GTK_RESPONSE_REJECT,
					     GTK_STOCK_OK, GTK_RESPONSE_OK,
					     NULL);
	gtk_window_set_default_size(GTK_WINDOW(editer->dlg), DEFAULT_EDITER_W, DEFAULT_EDITER_H);
	g_object_set_data (G_OBJECT (editer->dlg), "BookmarkEditer", editer);
	g_signal_connect(G_OBJECT(editer->dlg), "response",
			 G_CALLBACK(cb_editer_res), fb);

	/* editer->dlg->vbox area */
	/*   label = gtk_label_new(_("Bookmarks.")); */
	/*   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(editer->dlg)->vbox), label, FALSE, FALSE, 0); */
	/*   gtk_widget_show(label); */

	scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroll),
					    GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
				       GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);
	gtk_widget_set_size_request(scroll, -1, DEFAULT_EDITER_H - 30);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(editer->dlg)->vbox), scroll, TRUE, TRUE, 0);
	gtk_widget_show(scroll);

	editer->tview = gtk_tree_view_new();
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(editer->tview), TRUE);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(editer->tview), FALSE);
	gtk_container_add(GTK_CONTAINER(scroll), editer->tview);
	gtk_widget_show(editer->tview);

	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_min_width(column, (gint)(DEFAULT_EDITER_W * 5 / 7));
	gtk_tree_view_append_column(GTK_TREE_VIEW(editer->tview), column);

	render = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(column, render, TRUE);
	gtk_tree_view_column_set_attributes(column, render,
					    "text", PATH,
					    NULL);

	editer->store = gtk_list_store_new (BOOKMARKS,
					    G_TYPE_STRING,
					    G_TYPE_BOOLEAN
					    -1);
	store_set_bookmark (editer->store, fb);
	gtk_tree_view_set_model(GTK_TREE_VIEW(editer->tview), GTK_TREE_MODEL(editer->store));

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(editer->dlg)->vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	label = gtk_label_new(_("add : "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	editer->entry = gtk_entry_new_with_max_length(128);
	g_signal_connect(G_OBJECT(editer->entry), "activate",
			 G_CALLBACK(cb_add_bookmark), editer->dlg);
	gtk_box_pack_start(GTK_BOX(hbox), editer->entry, TRUE, TRUE, 0);
	gtk_widget_show(editer->entry);

	return editer->dlg;
}

/*
 *---------------------------------------------------------
 *       About Dialog
 *---------------------------------------------------------
 */
GtkWidget *
fb_about_dialog_new(FbWindow *fb)
{
	GtkWidget *dialog, *box, *label;

	dialog = gtk_dialog_new_with_buttons(_("About - Futaba"),
					     GTK_WINDOW(fb),
					     GTK_DIALOG_MODAL |
					     GTK_DIALOG_NO_SEPARATOR,
					     GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
					     NULL);
	gtk_window_set_default_size(GTK_WINDOW(dialog), 300, 120);
	g_signal_connect_swapped(G_OBJECT(dialog), "response",
				 G_CALLBACK(gtk_widget_destroy), dialog);

	box = GTK_DIALOG(dialog)->vbox;

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), 
			     "<span weight=\"bold\" size=\"x-large\">Futaba</span>");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label),
			     "<span weight=\"bold\" size=\"x-large\">Version "VERSION"</span>");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup (GTK_LABEL (label),
			      "<b>Copyright (C) 2005 Futaba Project</b>");
	gtk_box_pack_end(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);


	return dialog;
}

/*
 *-------------------------------------------------
 *           property dialog
 *-------------------------------------------------
 */
#define LABEL_TAB 15
#define LABEL_TAB2 0

GtkWidget *
fb_property_dialog_new(FbWindow *fb)
{
	gchar *name, *size, *path, *owner, *group, *permission, *mtime;
	GtkWidget *dialog;
	GtkWidget *table, *label;

	fb_dirview_row_get (FB_DIRVIEW (fb->dirview),
			   COLUMN_PATH, &path,
			   COLUMN_DISPLAY_PATH, &name,
			   COLUMN_PERMISSION, &permission,
			   COLUMN_OWNER, &owner,
			   COLUMN_GROUP, &group,
			   COLUMN_DISPLAY_SIZE, &size,
			   COLUMN_DISPLAY_MTIME, &mtime,
			   -1);

	dialog = gtk_dialog_new_with_buttons(_("Property"),
					     GTK_WINDOW(fb),
					     GTK_DIALOG_MODAL |
					     GTK_DIALOG_NO_SEPARATOR,
					     GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
					     NULL);
	/*   gtk_window_set_default_size(GTK_WINDOW(dialog), 300, 200); */
	g_signal_connect_swapped(G_OBJECT(dialog), "response",
				 G_CALLBACK(gtk_widget_destroy), dialog);

	/* dialog->vbox area */
	table = gtk_table_new(7, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, TRUE, TRUE, 0);
	gtk_widget_show(table);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>name:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 0, 1,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(name);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 0, 1,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>size:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 1, 2,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(size);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 1, 2,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>path:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 2, 3,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(path);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 2, 3,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>owner:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 3, 4,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(owner);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 3, 4,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>group:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 4, 5,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(group);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 4, 5,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>permission:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 5, 6,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(permission);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 5, 6,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label), _("<b>mtime:</b>"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 6, 7,
			 GTK_FILL, 0, LABEL_TAB, 0);
	gtk_widget_show(label);

	label = gtk_label_new(mtime);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 1, 2, 6, 7,
			 GTK_FILL, 0, LABEL_TAB2, 0);
	gtk_widget_show(label);

	g_free(name);
	g_free(size);
	g_free(path);
	g_free(owner);
	g_free(group);
	g_free(permission);
	g_free(mtime);

	return dialog;
}

/*
 *-------------------------------------------------
 *           bulk change dialog
 *-------------------------------------------------
 */
GtkWidget *
fb_bulk_change_dialog_new(FbWindow *fb)
{
	GtkWidget *dialog;
	
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), _("change name in bulk"));
	gtk_window_set_default_size(GTK_WINDOW(dialog), 350, 100);
	gtk_window_set_destroy_with_parent(GTK_WINDOW(dialog), TRUE);
	gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);

	return dialog;
}
