/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_PREFS_H__
#define __FB_PREFS_H__

#define FB_TYPE_PREFS_WIN               (fb_prefs_win_get_type())
#define FB_PREFS_WIN(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_PREFS_WIN, FbPrefsWin))
#define FB_PREFS_WIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_PREFS_WIN, FbPrefsWinClass))
#define FB_IS_PREFS_WIN(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_PREFS_WIN))
#define FB_IS_PREFS_WIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_PREFS_WIN))
#define FB_PREFS_WIN_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_PREFS_WIN, FbPrefsWinClass))

typedef struct _FbPrefsWin FbPrefsWin;
typedef struct _FbPrefsWinClass FbPrefsWinClass;
typedef struct _FbPrefsFunc FbPrefsFunc;
typedef struct _FbPrefsPageEntry FbPrefsPageEntry;

struct _FbPrefsWin
{
	GtkDialog dialog;

	GtkWidget *title;
	GtkWidget *pages;

	GtkWidget *title_list;
	GtkListStore *store;

	GList *page_func_list;
};

struct _FbPrefsWinClass
{
	GtkDialogClass parent_class;
};

struct _FbPrefsFunc
{
	GtkWidget *(*create)  (void);
	void       (*apply)   (void);
	void       (*destroy) (void);
};

struct _FbPrefsPageEntry
{
	gchar *title;
	FbPrefsFunc *(*get) (void);
};

GType        fb_prefs_win_get_type  (void);

GtkWidget   *fb_prefs_win_new       (void);

#endif /* __FB_PREFS_H__ */
