/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "fb-statusbar.h"

static void     fb_statusbar_class_init     (FbStatusbarClass *klass);
static void     fb_statusbar_init           (FbStatusbar      *fb);
static void     fb_statusbar_finalize       (GObject          *object);

static GtkStatusbarClass *parent_class = NULL;
static FbStatusbar *fb_statusbar = NULL;

GType
fb_statusbar_get_type (void)
{
	static GType object_type = 0;

	if (! object_type) {
		static const GTypeInfo object_info = {
			sizeof (FbStatusbarClass),
			NULL,
			NULL,
			(GClassInitFunc) fb_statusbar_class_init,
			NULL,
			NULL,
			sizeof (FbStatusbar),
			32,
			(GInstanceInitFunc) fb_statusbar_init,
		};

		object_type = g_type_register_static (GTK_TYPE_STATUSBAR, "FbStatusbar",
						      &object_info, 0);
	}

	return object_type;
}

static void
fb_statusbar_class_init (FbStatusbarClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);

	object_class = (GObjectClass *) klass;

	object_class->finalize = fb_statusbar_finalize;

}

static void
fb_statusbar_init (FbStatusbar *sb)
{

	sb->id = gtk_statusbar_get_context_id (GTK_STATUSBAR (sb), "Futaba status");
	sb->progress = gtk_progress_bar_new ();

	gtk_box_pack_end (GTK_BOX (sb), sb->progress, FALSE, FALSE, 0);
	gtk_widget_show (sb->progress);

}

static void
fb_statusbar_finalize (GObject *object)
{
	if (G_OBJECT_CLASS (parent_class)->finalize)
		G_OBJECT_CLASS (parent_class)->finalize (object);

	fb_statusbar = NULL;
}

GtkWidget *
fb_statusbar_new (void)
{
	GObject *object = g_object_new (FB_TYPE_STATUSBAR, NULL);

	fb_statusbar = FB_STATUSBAR (object);

	return GTK_WIDGET (object);
}

void
fb_statusbar_push (const gchar *format,
		   ...)
{
	gchar *text, *utf8_text;
	va_list var_args;

	g_return_if_fail (fb_statusbar != NULL);

	va_start (var_args, format);
	text = g_strdup_vprintf (format, var_args);
	va_end (var_args);

	utf8_text = g_locale_to_utf8 (text, -1, NULL, NULL, NULL);
	if (! utf8_text) utf8_text = g_strdup (text);

	gtk_statusbar_push (GTK_STATUSBAR (fb_statusbar), fb_statusbar->id, utf8_text);

	g_free (text);
	g_free (utf8_text);
}

void
fb_statusbar_swap (const gchar *format,
		   ...)
{
	gchar *text, *utf8_text;
	va_list var_args;

	g_return_if_fail (fb_statusbar != NULL);

	va_start (var_args, format);
	text = g_strdup_vprintf (format, var_args);
	va_end (var_args);

	utf8_text = g_locale_to_utf8 (text, -1, NULL, NULL, NULL);
	if (! utf8_text) utf8_text = g_strdup (text);

	gtk_statusbar_pop(GTK_STATUSBAR (fb_statusbar), fb_statusbar->id);
	gtk_statusbar_push (GTK_STATUSBAR (fb_statusbar), fb_statusbar->id, utf8_text);

	g_free (text);
	g_free (utf8_text);
}

void
fb_statusbar_pop (void)
{
	g_return_if_fail (fb_statusbar != NULL);

	gtk_statusbar_pop(GTK_STATUSBAR (fb_statusbar), fb_statusbar->id);
}

void
fb_statusbar_set_progress (FbStatusbar *sb,
			   gdouble fraction)
{
	g_return_if_fail (FB_IS_STATUSBAR (sb));

	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (sb->progress), fraction);
}

static gboolean
set_progress (FbStatusbar *sb)
{
	gtk_progress_bar_pulse (GTK_PROGRESS_BAR (sb->progress));

	return FALSE;
}

void
fb_statusbar_progress_start (FbStatusbar *sb)
{
	g_return_if_fail (FB_IS_STATUSBAR (sb));

	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (sb->progress), 0.2);
	gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR (sb->progress), 0.1);

	sb->timer_id = g_timeout_add (100, (GSourceFunc) set_progress, sb);
}

void
fb_statusbar_progress_end (FbStatusbar *sb)
{
	g_return_if_fail (FB_IS_STATUSBAR (sb));

	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (sb->progress), 0.0);
	g_source_remove (sb->timer_id);
}
