/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_VIEWER_H__
#define __FB_VIEWER_H__

typedef enum {
        VIEWER_NORMAL = 1 << 0,
        VIEWER_MAX = 1 << 1,
        VIEWER_FULL = 1 << 2
} FbViewerSize;

#define FB_TYPE_VIEWER		  (fb_viewer_get_type ())
#define FB_VIEWER(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_VIEWER, FbViewer))
#define FB_VIEWER_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_VIEWER, FbViewerClass))
#define FB_IS_VIEWER(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_VIEWER))
#define FB_IS_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_VIEWER))
#define FB_VIEWER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_VIEWER, FbViewerClass))

typedef struct _FbViewer FbViewer;
typedef struct _FbViewerClass FbViewerClass;

struct _FbViewer
{
	GtkWindow parent;

	GtkWidget *image;
	GtkWidget *popup;

	FbViewerSize size;

	GList *path_list;
	gint position;
};

struct _FbViewerClass
{
	GtkWindowClass parent_class;
};

extern GtkWidget *focus_viewer;

GType fb_viewer_get_type (void);

GtkWidget *fb_viewer_new (GList *path_list);

void fb_viewer_start (GList *path_list,
		      const gchar *path);

void fb_viewer_next_images (FbViewer *viewer,
			    gint n);

void fb_viewer_prev_images (FbViewer *viewer,
			    gint n);

void fb_viewer_segmentalize (FbViewer *viewer,
			     GtkOrientation way);

#endif /* __FB_VIEWER_H__ */
