/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-icons.c,v 1.8 2004/06/11 02:46:15 ikezoe Exp $
 */
/*
 *
 *  Modified 2005/05/21 Masataka Ikezoe
 *      Icon size and Checking filename of icon image.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "fb-icons.h"

GtkIconSize FB_ICON_SIZE_SMALL = GTK_ICON_SIZE_INVALID;

GdkPixbuf *fb_icon = NULL;

void
fb_icons_init (void)
{
	GtkIconFactory *factory;
	static gchar *dirname = NULL;
	GDir *dir;
	GError *error = NULL;
	const gchar *entry;

	if (!dirname)
		dirname = g_strconcat(DATADIR, "/icons", NULL);

	dir = g_dir_open(dirname, 0, &error);
	if (error)
	{
		g_warning("%s", error->message);
		g_error_free(error);
	}
	if (!dir) return;

	factory = gtk_icon_factory_new();
	gtk_icon_factory_add_default(factory);

	/*
	 * regist our icon size definitions
	 */
	FB_ICON_SIZE_SMALL
		= gtk_icon_size_register("FB_ICON_SIZE_SMALL",
					 10, 10);

	/*
	 * regist our icons
	 */
	while ((entry = g_dir_read_name(dir)))
	{
		GtkIconSet *icon_set;
		GdkPixbuf *pixbuf;
		gchar *filename, icon_name[256];
		gint len, namelen;

		len = strlen(entry);
		if (len <= 4 || strcasecmp(entry + len - 4, ".png"))
			continue;
		if (! g_str_has_prefix (entry, "fb-"))
			continue;

		/* build icon name */
		namelen = len - 4 < sizeof(icon_name)
			? len - 4 : sizeof(icon_name) - 1;
		memcpy(icon_name, entry, namelen);
		icon_name[namelen] = '\0';

		/* load icon file */
		filename = g_strconcat(dirname, "/", entry, NULL);
		pixbuf = gdk_pixbuf_new_from_file(filename, NULL);
		g_free (filename);

		if (!pixbuf) continue;

		/* store to the global icon stock */
		icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
		gtk_icon_factory_add(factory, icon_name, icon_set);
		gtk_icon_set_unref(icon_set);

		g_object_unref(G_OBJECT(pixbuf));
	}

	g_dir_close(dir);


	/*
	 * regist futaba icon
	 */
/* 	fb_icon = gdk_pixbuf_new_from_file */
/* 			(DATADIR "/pixmaps/futaba-icon.png", NULL); */
/* 	if (fb_icon) */
/* 	{ */
/* 		GtkIconSet *icon_set; */

/* 		icon_set = gtk_icon_set_new_from_pixbuf(fb_icon); */
/* 		gtk_icon_factory_add(factory, "futaba-icon", */
/* 				     icon_set); */
/* 		gtk_icon_set_unref(icon_set); */
/* 		g_object_unref(fb_icon); */
/* 	} */

	g_object_unref(G_OBJECT (factory));
}
