/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_PATHMENUITEM_H__
#define __FB_PATHMENUITEM_H__

#define FB_TYPE_PATH_MENU_ITEM			(fb_path_menu_item_get_type ())
#define FB_PATH_MENU_ITEM(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_PATH_MENU_ITEM, FbPathMenuItem))
#define FB_PATH_MENU_ITEM_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_PATH_MENU_ITEM, FbPathMenuItemClass))
#define FB_IS_PATH_MENU_ITEM(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_PATH_MENU_ITEM))
#define FB_IS_PATH_MENU_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_PATH_MENU_ITEM))
#define FB_PATH_MENU_ITEM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_PATH_MENU_ITEM, FbPathMenuItemClass))

typedef struct _FbPathMenuItem	FbPathMenuItem;
typedef struct _FbPathMenuItemClass	FbPathMenuItemClass;

struct _FbPathMenuItem
{
	GtkImageMenuItem parent;

	gchar *path;
	gchar *label;
	gchar *message;
};

struct _FbPathMenuItemClass
{
	GtkImageMenuItemClass parent_class;
};

GType             fb_path_menu_item_get_type        (void);

GtkWidget        *fb_path_menu_item_new             (const gchar *path);

G_CONST_RETURN gchar *fb_path_menu_item_get_path    (FbPathMenuItem *pitem);

#endif /* __FB_PATHMENUITEM_H__ */
