/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_PREVIEW_H__
#define __FB_PREVIEW_H__

#define FB_TYPE_PREVIEW			(fb_preview_get_type ())
#define FB_PREVIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_PREVIEW, FbPreview))
#define FB_PREVIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_PREVIEW, FbPreviewClass))
#define FB_IS_PREVIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_PREVIEW))
#define FB_IS_PREVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_PREVIEW))
#define FB_PREVIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_PREVIEW, FbPreviewClass))

typedef struct _FbPreview	FbPreview;
typedef struct _FbPreviewClass	FbPreviewClass;

struct _FbPreview
{
  GtkVBox parent;

  GtkWidget *frame;
  GtkWidget *image;
  GtkWidget *label;

  gchar *path;
};

struct _FbPreviewClass
{
  GtkVBoxClass parent_class;
};

GType             fb_preview_get_type        (void);

GtkWidget        *fb_preview_new             (void);

void              fb_preview_set_image       (FbPreview   *preview,
					      const gchar *path);

#endif /* __FB_PREVIEW_H__ */
