/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_STATUSBAR_H__
#define __FB_STATUSBAR_H__

#define FB_TYPE_STATUSBAR			(fb_statusbar_get_type ())
#define FB_STATUSBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_STATUSBAR, FbStatusbar))
#define FB_STATUSBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_STATUSBAR, FbStatusbarClass))
#define FB_IS_STATUSBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_STATUSBAR))
#define FB_IS_STATUSBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_STATUSBAR))
#define FB_STATUSBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_STATUSBAR, FbStatusbarClass))

typedef struct _FbStatusbar	FbStatusbar;
typedef struct _FbStatusbarClass	FbStatusbarClass;

struct _FbStatusbar
{
	GtkStatusbar parent;

	guint id;

	GtkWidget *progress;

	guint timer_id;
};

struct _FbStatusbarClass
{
	GtkStatusbarClass parent_class;
};

GType             fb_statusbar_get_type       (void);

GtkWidget        *fb_statusbar_new            (void);

void              fb_statusbar_push           (const gchar *format,
					       ...);

void              fb_statusbar_swap           (const gchar *format,
					       ...);

void              fb_statusbar_pop            (void);

void              fb_statusbar_set_progress   (FbStatusbar *sb,
					       gdouble      fraction);

void              fb_statusbar_progress_start (FbStatusbar *sb);

void              fb_statusbar_progress_end   (FbStatusbar *sb);

#endif /* __FB_STATUSBAR_H__ */
