/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <unistd.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "futaba.h"
#include "fb-thumbwin-action.h"
#include "fb-thumbwin.h"
#include "fb-viewer.h"
#include "file-utils.h"

static void
cb_rename (GtkAction *action,
	   gpointer data)
{
	GtkTreeIter iter;
	FbThumbWin *tw = FB_THUMBWIN (data);

}

static void
cb_open_viewer (GtkAction *action,
		gpointer data)
{
	gchar *path;
	GList *pathl = NULL;
	GtkTreeIter iter;
	GtkTreeModel *model;
	FbThumbWin *tw = FB_THUMBWIN (data);

	model = GTK_TREE_MODEL (tw->store);

	gtk_tree_model_get_iter_first (model, &iter);
	do {
		path = NULL;
		gtk_tree_model_get (model, &iter,
				    THUMBWIN_PATH, &path,
				    -1);
		if (path) pathl = g_list_append (pathl, path);
	} while (gtk_tree_model_iter_next (model, &iter));

	path = NULL;
	if (tw->prev_path && gtk_tree_model_get_iter (model, &iter, tw->prev_path)) {
		gtk_tree_model_get (model, &iter,
				    THUMBWIN_PATH, &path,
				    -1);
	}

	fb_viewer_start (pathl, path);

	g_list_foreach (pathl, (GFunc) g_free, NULL);
	g_list_free (pathl);

	if (path) g_free (path);
}

static void
cb_change_background (GtkAction *action,
		      gpointer data)
{
	FbThumbWin *tw = FB_THUMBWIN (data);

}

static void
cb_del_thumb (GtkAction *action,
	      gpointer data)
{
	gchar *path;
	GList *items;
	GtkTreeIter iter;
	FbThumbWin *tw = FB_THUMBWIN (data);

	items = fb_thumbwin_get_selected_items (tw);
	for (; items; items = items->next) {
		if (! items->data) continue;

		path = NULL;
		if (gtk_tree_model_get_iter (GTK_TREE_MODEL (tw->store), &iter, items->data))
			gtk_tree_model_get (GTK_TREE_MODEL (tw->store), &iter,
					    THUMBWIN_PATH, &path,
					    -1);
		/* Write Code (Show delete confirm dialog) */
		if (! unlink (path)) {
			gtk_list_store_remove (tw->store, &iter);
		}
		gtk_tree_path_free (items->data);
		if (path) g_free (path);
	}
	g_list_free (items);

	fb_thumbwin_update_title (tw);
}

static void
cb_copy (GtkAction *action,
	 gpointer data)
{
	gchar *path;
	GList *items;
	GtkTreeIter iter;
	FbThumbWin *tw = FB_THUMBWIN (data);

	g_list_foreach (paste_list, (GFunc) g_free, NULL);
	g_list_free (paste_list);
	paste_list = NULL;

	items = fb_thumbwin_get_selected_items (tw);
	for (; items; items = items->next) {
		if (! items->data) continue;
	
		path = NULL;
		if (gtk_tree_model_get_iter (GTK_TREE_MODEL (tw->store), &iter, items->data))
			gtk_tree_model_get (GTK_TREE_MODEL (tw->store), &iter,
					    THUMBWIN_PATH, &path,
					    -1);

		if (path_is_exists (path)) 
			paste_list = g_list_append (paste_list, path);
		
		gtk_tree_path_free (items->data);
		if (path) g_free (path);
	}
	g_list_free (items);

	is_copy = TRUE;
}

static void
cb_cut (GtkAction *action,
	gpointer data)
{
	gchar *path;
	GList *items;
	GtkTreeIter iter;
	FbThumbWin *tw = FB_THUMBWIN (data);

	g_list_foreach (paste_list, (GFunc) g_free, NULL);
	g_list_free (paste_list);
	paste_list = NULL;

	items = fb_thumbwin_get_selected_items (tw);
	for (; items; items = items->next) {
		if (! items->data) continue;
	
		path = NULL;
		if (gtk_tree_model_get_iter (GTK_TREE_MODEL (tw->store), &iter, items->data))
			gtk_tree_model_get (GTK_TREE_MODEL (tw->store), &iter,
					    THUMBWIN_PATH, &path,
					    -1);

		if (path_is_exists (path)) 
			paste_list = g_list_append (paste_list, path);

		gtk_tree_path_free (items->data);
		if (path) g_free (path);
	}
	g_list_free (items);

	is_copy = FALSE;
}

static void
cb_paste (GtkAction *action,
	  gpointer data)
{
	gboolean result;
	gchar *tmp, *src, *dest;
	GList *pathl;
	FbThumbWin *tw = FB_THUMBWIN (data);

	for (pathl = paste_list; pathl; pathl = pathl->next) {
		src = pathl->data;

		tmp = g_path_get_basename (src);
		dest = g_strconcat (tw->workdir, "/", tmp, NULL);
		g_free (tmp);

		result = FALSE;
		if (path_is_dir (src)) {
			result = cpdir_recursive (src, dest);
			if (! is_copy && result)
				result = rmdir_recursive (src);
		}
		else if (path_is_file (src)) {
			result = file_copy (src, dest);
			if (! is_copy && result)
				result = ! unlink (src);
		}

		if (result && file_is_image (dest))
			fb_thumbwin_add_thumbnail (tw, dest);

		g_free (dest);
	}

	if (! is_copy) {
		g_list_foreach (paste_list, (GFunc) g_free, NULL);
		g_list_free (paste_list);
		paste_list = NULL;
	}

	fb_thumbwin_update_title (tw);
}

static void
cb_update_thumb (GtkAction *action,
		 gpointer data)
{
	FbThumbWin *tw = FB_THUMBWIN (data);

	fb_thumbwin_update_thumbnail (tw);
}

static GtkActionEntry actions[] = {
	{"Rename", NULL, N_("Rename"), NULL, NULL, G_CALLBACK (cb_rename)},
	{"OpenViewer", NULL, N_("Open Viewer"), NULL, NULL, G_CALLBACK (cb_open_viewer)},
	{"DelThumb", NULL, N_("Delete File"), NULL, NULL, G_CALLBACK (cb_del_thumb)},
	{"CopyThumb", "gtk-copy", N_("Copy File"), NULL, NULL, G_CALLBACK (cb_copy)},
	{"CutThumb", "gtk-cut", N_("Cut File"), NULL, NULL, G_CALLBACK (cb_cut)},
	{"UpdateThumb", "gtk-refresh", N_("Update Thumbnail"), NULL, NULL, G_CALLBACK (cb_update_thumb)},

	{"Sort", NULL, N_("Sort")},
	{"BackGround", NULL, N_("Change Background"), NULL, NULL, G_CALLBACK (cb_change_background)},
	{"Paste", "gtk-paste", N_("Paste File"), NULL, NULL, G_CALLBACK (cb_paste)},
};
static guint n_actions = G_N_ELEMENTS (actions);

static void
cb_set_reverse(GtkAction *action,
	       gpointer data)
{
	gint sort_id;
	GtkSortType order;
	GtkTreeSortable *sortable;
	FbThumbWin *tw = data;

	sortable = GTK_TREE_SORTABLE (tw->store);

	if (gtk_toggle_action_get_active(GTK_TOGGLE_ACTION(action)))
		order = GTK_SORT_DESCENDING;
	else
		order = GTK_SORT_ASCENDING;

	gtk_tree_sortable_get_sort_column_id(sortable, &sort_id, NULL);
	gtk_tree_sortable_set_sort_column_id(sortable, sort_id, order);
}      

static GtkToggleActionEntry toggle_actions[] = {
	{"Reverse", NULL, N_("Reversed order"), NULL, NULL, G_CALLBACK (cb_set_reverse), FALSE},
};
static guint n_toggle_actions = G_N_ELEMENTS (toggle_actions);

static void
cb_sort_mode(GtkRadioAction *action,
	     GtkRadioAction *current,
	     gpointer data)
{
	gint mode;
	GtkSortType order;
	GtkTreeSortable *sortable;
	FbThumbWin *tw = data;

	sortable = GTK_TREE_SORTABLE (tw->store);

	mode = gtk_radio_action_get_current_value(GTK_RADIO_ACTION(current));
	g_print ("mode %d\n", mode);
	gtk_tree_sortable_get_sort_column_id(sortable, NULL, &order);
	gtk_tree_sortable_set_sort_column_id(sortable, mode, order);

}

static GtkRadioActionEntry radio_actions[] = {
  {"SortName", NULL, N_("Sort by name"), NULL, NULL, SORT_BY_NAME},
  {"SortSize", NULL, N_("Sort by size"), NULL, NULL, SORT_BY_SIZE},
  {"SortMtime", NULL, N_("Sort by mtime"), NULL, NULL, SORT_BY_MTIME},
  {"SortArea", NULL, N_("Sort by area"), NULL, NULL, SORT_BY_AREA}
};
static guint n_radio_actions = G_N_ELEMENTS(radio_actions);

static const gchar *thumbwin_ui = {
	"<ui>"
	"  <popup name=\"OverThumbPopup\">"
	"     <menuitem action=\"OpenViewer\"/>"
	"     <separator/>"
/* 	"     <menuitem action=\"Rename\"/>" */
	"     <menuitem action=\"CopyThumb\"/>"
	"     <menuitem action=\"CutThumb\"/>"
	"     <menuitem action=\"DelThumb\"/>"
	"  </popup>"
	"  <popup name=\"Popup\">"
	"     <menuitem action=\"OpenViewer\"/>"
	"     <separator/>"
	"     <menuitem action=\"Paste\"/>"
	"     <menuitem action=\"UpdateThumb\"/>"
/* 	"     <menu action=\"Sort\">" */
/* 	"       <menuitem action=\"SortName\"/>" */
/* 	"       <menuitem action=\"SortSize\"/>" */
/* 	"       <menuitem action=\"SortMtime\"/>" */
/* 	"       <menuitem action=\"SortArea\"/>" */
/* 	"       <separator/>" */
/* 	"       <menuitem action=\"Reverse\"/>" */
/* 	"     </menu>" */
/* 	"     <menuitem action=\"BackGround\"/>" */
	"  </popup>"
	"</ui>"
};

GtkUIManager *
fb_thumbwin_ui_manager_get (gpointer data)
{
	GError *error = NULL;
	GtkActionGroup *action_group;
	GtkUIManager *ui_manager;

/* 	if (fb_viewer_ui) return fb_viewer_ui; */

	action_group = gtk_action_group_new("Futaba Thumbnail Window");

	gtk_action_group_set_translation_domain(action_group, NULL);

	gtk_action_group_add_actions(action_group,
				     actions, n_actions,
				     data);

	gtk_action_group_add_toggle_actions(action_group,
					    toggle_actions, n_toggle_actions,
					    data);

	gtk_action_group_add_radio_actions(action_group,
					   radio_actions, n_radio_actions,
					   SORT_BY_NAME,
					   G_CALLBACK(cb_sort_mode), data);

	ui_manager = gtk_ui_manager_new();

	gtk_ui_manager_insert_action_group(ui_manager, action_group, 0);

	if (!gtk_ui_manager_add_ui_from_string(ui_manager, thumbwin_ui, -1, &error)) {
		g_print("Failed thumbwin popup init: %s\n", error->message);
		g_error_free(error);

		return NULL;
	}

	return ui_manager;
}
