/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FUTABA_H__
#define __FUTABA_H__

#define FB_RC_DIR "/.futaba"
#define FB_EXTRACT_DIR FUTABA_RC_DIR"/tmp"
#define FB_RC_FILE FB_RC_DIR"/futabarc"
#define FB_STATUS_FILE FB_RC_DIR"/status"
#define FB_BOOKMARK_FILE FB_RC_DIR"/bookmarks"
#define FB_ACCEL_FILE FB_RC_DIR"/keyaccelrc"

typedef enum {
	WORKDIR,
	PARENTDIR,
	DIRECTORY,
	ARCHIVE,
	IMAGE,
	BACKUP,
	OTHER
} FbFileType;

typedef enum {
	SORT_BY_NAME,
	SORT_BY_SIZE,
	SORT_BY_MTIME,
	SORT_BY_TYPE,
	SORT_BY_AREA
} FbSortMode;

/* dnd support */
enum {
	TARGET_TEXT_URI_LIST,
	TARGET_TEXT_PLAIN
};

static GtkTargetEntry uri_drag_types [] = {
	{"text/uri-list", 0, TARGET_TEXT_URI_LIST},
	{"text/plain", 0, TARGET_TEXT_PLAIN},
};
static guint n_uri_drag_types = G_N_ELEMENTS (uri_drag_types);

/* common resource */
extern GList *paste_list;
extern gboolean is_copy;
extern gboolean cdir_filter;
extern gboolean pdir_filter;
	
#endif /* __FUTABA_H__ */
