/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "futaba.h"
#include "fb-icons.h"
#include "fb-conf.h"
#include "fb-window.h"
#include "file-utils.h"

static void
fb_init (void)
{
	gchar *path;

	path = g_strconcat (g_get_home_dir (),
			    "/.futaba",
			    NULL);
	if (! path_is_dir (path))
		ensure_dir_exists (path, 0755);
	g_free (path);

	fb_icons_init ();

	path = g_strconcat (g_get_home_dir (),
			    "/.futaba/futabarc",
			    NULL);

	fb_conf_load (path);

	g_free (path);
}

static void
fb_fin (void)
{
	gboolean flag;
	gchar *path;

	fb_conf_get_value ("remove extracted archive", &flag, FB_CONF_TYPE_BOOLEAN, "FALSE");
	if (flag) {
		path = g_strconcat (g_get_home_dir (),
				    "/.futaba/tmp",
				    NULL);
		rmdir_recursive (path);
		g_free (path);
	}

	path = g_strconcat (g_get_home_dir (),
			    "/.futaba/futabarc",
			    NULL);

	fb_conf_save (path);

	g_free (path);
}

int
main(int argc, char **argv)
{
	gboolean flag;
	gchar *key, *path;
	GtkWidget *futaba;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	/* GTK Initialize */
	/*   gtk_set_locale(); */
	gtk_init(&argc,&argv);

	fb_init ();

	fb_conf_get_value ("start home", &flag, FB_CONF_TYPE_BOOLEAN, "TRUE");
	if (flag)
		key = g_strdup ("home page");
	else
		key = g_strdup ("last page");
	fb_conf_get_value (key, &path, FB_CONF_TYPE_STRING, g_get_home_dir ());
	g_free (key);

	if (! path_is_dir (path)) {
		g_free (path);
		path = g_strdup (g_get_home_dir ());
	}

	futaba = fb_window_new (path);
	gtk_widget_show (futaba);
	g_free (path);

	gtk_main();

	fb_fin ();

	return 0;
}
